# Copyright (C) 2018-2025 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from perftest import perftest

import gdb


class TemplateBreakpoints(perftest.TestCaseWithBasicMeasurements):
    def __init__(self):
        super(TemplateBreakpoints, self).__init__("template-breakpoints")

    def warm_up(self):
        for _ in range(0, 2):
            gdb.Breakpoint("template-breakpoints.cc:38").delete()

    def _do_test(self, bpcount):
        for _ in range(1, bpcount):
            gdb.Breakpoint("template-breakpoints.cc:38").delete()

    def execute_test(self):
        for bpcount in range(1, 10):
            self.measure.measure(
                lambda bound_bpcount=bpcount: self._do_test(bound_bpcount), bpcount
            )
