//Original:/testcases/core/c_dsp32shiftim_lhalf_rn/c_dsp32shiftim_lhalf_rn.dsp
// Spec Reference: dspshiftimm dreg_lo(hi) = lshift (dreg_lo(hi) by imm5)
# mach: bfin

.include "testutils.inc"
	start



// lshift : neg data, count (+)=left (half reg)
// d_lo = lshift (d_lo BY d_lo)
// RLx by RLx
imm32 r0, 0x00000000;
R0.L = -1;
imm32 r1, 0x00008001;
imm32 r2, 0x00008002;
imm32 r3, 0x00008003;
imm32 r4, 0x00008004;
imm32 r5, 0x00008005;
imm32 r6, 0x00008006;
imm32 r7, 0x00008007;
R0.L = R0.L >> 1;
R1.L = R1.L >> 2;
R2.L = R2.L >> 3;
R3.L = R3.L >> 4;
R4.L = R4.L >> 5;
R5.L = R5.L >> 6;
R6.L = R6.L >> 7;
R7.L = R7.L >> 8;
CHECKREG r0, 0x00007FFF;
CHECKREG r1, 0x00002000;
CHECKREG r2, 0x00001000;
CHECKREG r3, 0x00000800;
CHECKREG r4, 0x00000400;
CHECKREG r5, 0x00000200;
CHECKREG r6, 0x00000100;
CHECKREG r7, 0x00000080;

imm32 r0, 0x00008001;
R1.L = -1;
imm32 r2, 0x00008002;
imm32 r3, 0x00008003;
imm32 r4, 0x00008004;
imm32 r5, 0x00008005;
imm32 r6, 0x00008006;
imm32 r7, 0x00008007;
R0.L = R0.L >> 9;
R1.L = R1.L >> 10;
R2.L = R2.L >> 11;
R3.L = R3.L >> 12;
R4.L = R4.L >> 13;
R5.L = R5.L >> 14;
R6.L = R6.L >> 15;
R7.L = R7.L >> 10;
CHECKREG r0, 0x00000040;
CHECKREG r1, 0x0000003F;
CHECKREG r2, 0x00000010;
CHECKREG r3, 0x00000008;
CHECKREG r4, 0x00000004;
CHECKREG r5, 0x00000002;
CHECKREG r6, 0x00000001;
CHECKREG r7, 0x00000020;


imm32 r0, 0x30008001;
imm32 r1, 0x30008001;
R2.L = -15;
imm32 r3, 0x30008003;
imm32 r4, 0x30008004;
imm32 r5, 0x30008005;
imm32 r6, 0x30008006;
imm32 r7, 0x30008007;
R7.L = R0.L >> 1;
R6.L = R1.L >> 2;
R5.L = R2.L >> 3;
R4.L = R3.L >> 4;
R3.L = R4.L >> 5;
R2.L = R5.L >> 6;
R0.L = R7.L >> 8;
R1.L = R6.L >> 7;
CHECKREG r0, 0x30000040;
CHECKREG r1, 0x30000040;
CHECKREG r2, 0x0000007F;
CHECKREG r3, 0x30000040;
CHECKREG r4, 0x30000800;
CHECKREG r5, 0x30001FFE;
CHECKREG r6, 0x30002000;
CHECKREG r7, 0x30004000;

imm32 r0, 0x00008001;
imm32 r1, 0x00008001;
imm32 r2, 0x00008002;
R3.L = -16;
imm32 r4, 0x00008004;
imm32 r5, 0x00008005;
imm32 r6, 0x00008006;
imm32 r7, 0x00008007;
R6.L = R0.L >> 13;
R5.L = R1.L >> 13;
R4.L = R2.L >> 13;
R3.L = R3.L >> 13;
R2.L = R4.L >> 13;
R1.L = R5.L >> 13;
R0.L = R6.L >> 13;
R7.L = R7.L >> 13;
CHECKREG r0, 0x00000000;
CHECKREG r1, 0x00000000;
CHECKREG r2, 0x00000000;
CHECKREG r3, 0x30000007;
CHECKREG r4, 0x00000004;
CHECKREG r5, 0x00000004;
CHECKREG r6, 0x00000004;
CHECKREG r7, 0x00000004;

// d_lo = lshift (d_hi BY d_lo)
// RHx by RLx
imm32 r0, 0x00000000;
imm32 r1, 0x80010000;
imm32 r2, 0x80020000;
imm32 r3, 0x80030000;
imm32 r4, 0x80040000;
imm32 r5, 0x80050000;
imm32 r6, 0x80060000;
imm32 r7, 0x80070000;
R0.L = R0.H >> 1;
R1.L = R1.H >> 1;
R2.L = R2.H >> 1;
R3.L = R3.H >> 1;
R4.L = R4.H >> 1;
R5.L = R5.H >> 1;
R6.L = R6.H >> 1;
R7.L = R7.H >> 1;
CHECKREG r0, 0x00000000;
CHECKREG r1, 0x80014000;
CHECKREG r2, 0x80024001;
CHECKREG r3, 0x80034001;
CHECKREG r4, 0x80044002;
CHECKREG r5, 0x80054002;
CHECKREG r6, 0x80064003;
CHECKREG r7, 0x80074003;

imm32 r0, 0x80010000;
R1.L = -1;
imm32 r2, 0x80020000;
imm32 r3, 0x80030000;
imm32 r4, 0x80040000;
imm32 r5, 0x80050000;
imm32 r6, 0x80060000;
imm32 r7, 0x80070000;
R1.L = R0.H >> 10;
R2.L = R1.H >> 11;
R3.L = R2.H >> 12;
R4.L = R3.H >> 13;
R5.L = R4.H >> 14;
R6.L = R5.H >> 15;
R0.L = R7.H >> 15;
R7.L = R6.H >> 15;
CHECKREG r0, 0x80010001;
CHECKREG r1, 0x80010020;
CHECKREG r2, 0x80020010;
CHECKREG r3, 0x80030008;
CHECKREG r4, 0x80040004;
CHECKREG r5, 0x80050002;
CHECKREG r6, 0x80060001;
CHECKREG r7, 0x80070001;


imm32 r0, 0xa0010000;
imm32 r1, 0xa0010000;
R2.L = -15;
imm32 r3, 0xa0030000;
imm32 r4, 0xa0040000;
imm32 r5, 0xa0050000;
imm32 r6, 0xa0060000;
imm32 r7, 0xa0070000;
R2.L = R0.H >> 2;
R3.L = R1.H >> 2;
R4.L = R2.H >> 2;
R5.L = R3.H >> 2;
R6.L = R4.H >> 2;
R7.L = R5.H >> 2;
R0.L = R6.H >> 2;
R1.L = R7.H >> 2;
CHECKREG r0, 0xA0012801;
CHECKREG r1, 0xA0012801;
CHECKREG r2, 0x80022800;
CHECKREG r3, 0xA0032800;
CHECKREG r4, 0xA0042000;
CHECKREG r5, 0xA0052800;
CHECKREG r6, 0xA0062801;
CHECKREG r7, 0xA0072801;

imm32 r0, 0xb0010001;
imm32 r1, 0xb0010001;
imm32 r2, 0xb0020002;
R3.L = -16;
imm32 r4, 0xb0040004;
imm32 r5, 0xb0050005;
imm32 r6, 0xb0060006;
imm32 r7, 0xb0070007;
R3.L = R0.H >> 13;
R4.L = R1.H >> 13;
R5.L = R2.H >> 13;
R6.L = R3.H >> 13;
R7.L = R4.H >> 13;
R0.L = R5.H >> 13;
R1.L = R6.H >> 13;
R2.L = R7.H >> 13;
CHECKREG r0, 0xB0010005;
CHECKREG r1, 0xB0010005;
CHECKREG r2, 0xB0020005;
CHECKREG r3, 0xA0030005;
CHECKREG r4, 0xB0040005;
CHECKREG r5, 0xB0050005;
CHECKREG r6, 0xB0060005;
CHECKREG r7, 0xB0070005;

// d_hi = lshift (d_lo BY d_lo)
// RLx by RLx
imm32 r0, 0x00000001;
imm32 r1, 0x00000001;
imm32 r2, 0x00000002;
imm32 r3, 0x00000003;
imm32 r4, 0x00000004;
imm32 r5, 0x00000005;
imm32 r6, 0x00000006;
imm32 r7, 0x00000007;
R0.H = R0.L >> 14;
R1.H = R1.L >> 14;
R2.H = R2.L >> 14;
R3.H = R3.L >> 14;
R4.H = R4.L >> 14;
R5.H = R5.L >> 14;
R6.H = R6.L >> 14;
R7.H = R7.L >> 14;
CHECKREG r0, 0x00000001;
CHECKREG r1, 0x00000001;
CHECKREG r2, 0x00000002;
CHECKREG r3, 0x00000003;
CHECKREG r4, 0x00000004;
CHECKREG r5, 0x00000005;
CHECKREG r6, 0x00000006;
CHECKREG r7, 0x00000007;

imm32 r0, 0x00008001;
imm32 r1, 0x00008001;
imm32 r2, 0x00008002;
imm32 r3, 0x00008003;
imm32 r4, 0x00008004;
R5.L = -1;
imm32 r6, 0x00008006;
imm32 r7, 0x00008007;
R1.H = R0.L >> 5;
R0.H = R7.L >> 5;
R2.H = R1.L >> 5;
R3.H = R2.L >> 5;
R4.H = R3.L >> 5;
R5.H = R4.L >> 5;
R6.H = R5.L >> 5;
R7.H = R6.L >> 5;
CHECKREG r0, 0x04008001;
CHECKREG r1, 0x04008001;
CHECKREG r2, 0x04008002;
CHECKREG r3, 0x04008003;
CHECKREG r4, 0x04008004;
CHECKREG r5, 0x0400FFFF;
CHECKREG r6, 0x07FF8006;
CHECKREG r7, 0x04008007;


imm32 r0, 0x00009001;
imm32 r1, 0x00009001;
imm32 r2, 0x00009002;
imm32 r3, 0x00009003;
imm32 r4, 0x00009004;
imm32 r5, 0x00009005;
R6.L = -15;
imm32 r7, 0x00009007;
R3.H = R0.L >> 14;
R4.H = R1.L >> 14;
R5.H = R2.L >> 14;
R6.H = R3.L >> 14;
R7.H = R4.L >> 14;
R0.H = R5.L >> 14;
R1.H = R6.L >> 14;
R2.H = R7.L >> 14;
CHECKREG r0, 0x00029001;
CHECKREG r1, 0x00039001;
CHECKREG r2, 0x00029002;
CHECKREG r3, 0x00029003;
CHECKREG r4, 0x00029004;
CHECKREG r5, 0x00029005;
CHECKREG r6, 0x0002FFF1;
CHECKREG r7, 0x00029007;

imm32 r0, 0x0000a001;
imm32 r1, 0x0000a001;
imm32 r2, 0x0000a002;
imm32 r3, 0x0000a003;
imm32 r4, 0x0000a004;
imm32 r5, 0x0000a005;
imm32 r6, 0x0000a006;
R7.L = -16;
R4.H = R0.L >> 15;
R5.H = R1.L >> 15;
R6.H = R2.L >> 15;
R7.H = R3.L >> 15;
R0.H = R4.L >> 15;
R1.H = R5.L >> 15;
R2.H = R6.L >> 15;
R3.H = R7.L >> 15;
CHECKREG r0, 0x0001A001;
CHECKREG r1, 0x0001A001;
CHECKREG r2, 0x0001A002;
CHECKREG r3, 0x0001A003;
CHECKREG r4, 0x0001A004;
CHECKREG r5, 0x0001A005;
CHECKREG r6, 0x0001A006;
CHECKREG r7, 0x0001FFF0;

// d_lo = lshft (d_hi BY d_lo)
// RHx by RLx
imm32 r0, 0x80010000;
imm32 r1, 0x80010000;
imm32 r2, 0x80020000;
imm32 r3, 0x80030000;
R4.L = -1;
imm32 r5, 0x80050000;
imm32 r6, 0x80060000;
imm32 r7, 0x80070000;
R0.H = R0.H >> 4;
R1.H = R1.H >> 4;
R2.H = R2.H >> 4;
R3.H = R3.H >> 4;
R4.H = R4.H >> 4;
R5.H = R5.H >> 4;
R6.H = R6.H >> 4;
R7.H = R7.H >> 4;
CHECKREG r0, 0x08000000;
CHECKREG r1, 0x08000000;
CHECKREG r2, 0x08000000;
CHECKREG r3, 0x08000000;
CHECKREG r4, 0x0000FFFF;
CHECKREG r5, 0x08000000;
CHECKREG r6, 0x08000000;
CHECKREG r7, 0x08000000;

imm32 r0, 0x80010000;
imm32 r1, 0x80010000;
imm32 r2, 0x80020000;
imm32 r3, 0x80030000;
imm32 r4, 0x80040000;
R5.L = -1;
imm32 r6, 0x80060000;
imm32 r7, 0x80070000;
R1.H = R0.H >> 15;
R2.H = R1.H >> 15;
R3.H = R2.H >> 15;
R4.H = R3.H >> 15;
R5.H = R4.H >> 15;
R6.H = R5.H >> 15;
R0.H = R7.H >> 15;
R7.H = R6.H >> 15;
CHECKREG r0, 0x00010000;
CHECKREG r1, 0x00010000;
CHECKREG r2, 0x00000000;
CHECKREG r3, 0x00000000;
CHECKREG r4, 0x00000000;
CHECKREG r5, 0x0000FFFF;
CHECKREG r6, 0x00000000;
CHECKREG r7, 0x00000000;


imm32 r0, 0xd0010000;
imm32 r1, 0xd0010000;
imm32 r2, 0xd0020000;
imm32 r3, 0xd0030000;
imm32 r4, 0xd0040000;
imm32 r5, 0xd0050000;
R6.L = -15;
imm32 r7, 0xd0070000;
R3.H = R0.H >> 6;
R4.H = R1.H >> 6;
R5.H = R2.H >> 6;
R6.H = R3.H >> 6;
R7.H = R4.H >> 6;
R0.H = R5.H >> 6;
R1.H = R6.H >> 6;
R2.H = R7.H >> 6;
CHECKREG r0, 0x000D0000;
CHECKREG r1, 0x00000000;
CHECKREG r2, 0x00000000;
CHECKREG r3, 0x03400000;
CHECKREG r4, 0x03400000;
CHECKREG r5, 0x03400000;
CHECKREG r6, 0x000DFFF1;
CHECKREG r7, 0x000D0000;

imm32 r0, 0xe0010000;
imm32 r1, 0xe0010000;
imm32 r2, 0xe0020000;
imm32 r3, 0xe0030000;
imm32 r4, 0xe0040000;
imm32 r5, 0xe0050000;
imm32 r6, 0xe0060000;
R7.L = -16;
R4.H = R0.H >> 7;
R5.H = R1.H >> 7;
R6.H = R2.H >> 7;
R7.H = R3.H >> 7;
R0.H = R4.H >> 7;
R1.H = R5.H >> 7;
R2.H = R6.H >> 7;
R3.H = R7.H >> 7;
CHECKREG r0, 0x00030000;
CHECKREG r1, 0x00030000;
CHECKREG r2, 0x00030000;
CHECKREG r3, 0x00030000;
CHECKREG r4, 0x01C00000;
CHECKREG r5, 0x01C00000;
CHECKREG r6, 0x01C00000;
CHECKREG r7, 0x01C0FFF0;

pass
