/* Test ufromfp.
   Copyright (C) 1997-2025 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */

#include "libm-test-driver.c"

static const struct test_fiu_f_data ufromfp_test_data[] =
  {
    /* Infinity, NaN and values that are definitely out of range
       (large values of width count as the width of the return
       type).  */
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_infty, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_infty, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, qnan_value, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -qnan_value, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, snan_value, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -snan_value, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_UPWARD, MAX_EXP - 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_UPWARD, MAX_EXP, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, max_value, FP_INT_UPWARD, UINT_MAX, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, max_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_DOWNWARD, MAX_EXP - 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_DOWNWARD, MAX_EXP, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, max_value, FP_INT_DOWNWARD, UINT_MAX, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TOWARDZERO, MAX_EXP - 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TOWARDZERO, MAX_EXP, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TOWARDZERO, UINT_MAX, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TONEARESTFROMZERO, MAX_EXP - 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TONEARESTFROMZERO, MAX_EXP, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TONEAREST, MAX_EXP - 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TONEAREST, MAX_EXP, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, max_value, FP_INT_TONEAREST, UINT_MAX, max_value, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_UPWARD, MAX_EXP - 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_UPWARD, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_DOWNWARD, MAX_EXP - 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_DOWNWARD, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TOWARDZERO, MAX_EXP - 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TOWARDZERO, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TONEARESTFROMZERO, MAX_EXP - 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TONEARESTFROMZERO, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TONEAREST, MAX_EXP - 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TONEAREST, MAX_EXP, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -max_value, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_UPWARD, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_DOWNWARD, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TOWARDZERO, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEAREST, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p64, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p63, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#if MANT_DIG >= 53
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p63, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
#if MANT_DIG >= 64
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x8000000000000001p0, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif

    /* Zero (OK unless the width specified is zero).  */
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_UPWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_UPWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_UPWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, plus_zero, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_DOWNWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_DOWNWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_DOWNWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, minus_zero, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    /* For unsigned results, -1 and below are always invalid.  */
    TEST_fiu_f (ufromfp, -1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -1.1, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -2.5, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -123.456, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_UPWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_TOWARDZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1p32, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),

    /* Tests below here are generated with gen-fromfp-tests.py.  */

    /* Integer inputs within range of uintmax_t.  */
    TEST_fiu_f (ufromfp, 1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_DOWNWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_DOWNWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_DOWNWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_DOWNWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_TOWARDZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_TOWARDZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_TOWARDZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_TOWARDZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_TONEARESTFROMZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4, FP_INT_TONEAREST, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_UPWARD, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_UPWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_UPWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_UPWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_DOWNWARD, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_DOWNWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_DOWNWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_DOWNWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_TOWARDZERO, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_TOWARDZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_TOWARDZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_TOWARDZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_TONEARESTFROMZERO, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_TONEARESTFROMZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_TONEARESTFROMZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5, FP_INT_TONEAREST, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_TONEAREST, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_TONEAREST, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5, FP_INT_TONEAREST, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_UPWARD, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_UPWARD, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_UPWARD, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_UPWARD, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_DOWNWARD, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_DOWNWARD, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_DOWNWARD, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_DOWNWARD, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_TOWARDZERO, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_TOWARDZERO, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_TOWARDZERO, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_TOWARDZERO, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_TONEARESTFROMZERO, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_TONEARESTFROMZERO, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_TONEARESTFROMZERO, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_TONEARESTFROMZERO, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 6, FP_INT_TONEAREST, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_TONEAREST, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_TONEAREST, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 6, FP_INT_TONEAREST, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_UPWARD, 3, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_UPWARD, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_UPWARD, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_UPWARD, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_DOWNWARD, 3, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_DOWNWARD, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_DOWNWARD, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_DOWNWARD, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_TOWARDZERO, 3, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_TOWARDZERO, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_TOWARDZERO, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_TOWARDZERO, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_TONEARESTFROMZERO, 3, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_TONEARESTFROMZERO, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_TONEARESTFROMZERO, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_TONEARESTFROMZERO, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 7, FP_INT_TONEAREST, 3, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_TONEAREST, 4, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_TONEAREST, 64, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 7, FP_INT_TONEAREST, UINT_MAX, 7, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_UPWARD, 4, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_UPWARD, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_UPWARD, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_UPWARD, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_DOWNWARD, 4, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_DOWNWARD, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_DOWNWARD, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_DOWNWARD, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_TOWARDZERO, 4, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_TOWARDZERO, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_TOWARDZERO, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_TOWARDZERO, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_TONEARESTFROMZERO, 4, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_TONEARESTFROMZERO, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_TONEARESTFROMZERO, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_TONEARESTFROMZERO, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 8, FP_INT_TONEAREST, 4, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_TONEAREST, 5, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_TONEAREST, 64, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 8, FP_INT_TONEAREST, UINT_MAX, 8, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_UPWARD, 4, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_UPWARD, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_UPWARD, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_UPWARD, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_DOWNWARD, 4, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_DOWNWARD, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_DOWNWARD, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_DOWNWARD, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_TOWARDZERO, 4, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_TOWARDZERO, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_TOWARDZERO, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_TOWARDZERO, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_TONEARESTFROMZERO, 4, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_TONEARESTFROMZERO, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_TONEARESTFROMZERO, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_TONEARESTFROMZERO, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 9, FP_INT_TONEAREST, 4, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_TONEAREST, 5, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_TONEAREST, 64, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 9, FP_INT_TONEAREST, UINT_MAX, 9, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_UPWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_UPWARD, 4, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_UPWARD, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_UPWARD, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_UPWARD, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_DOWNWARD, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_DOWNWARD, 4, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_DOWNWARD, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_DOWNWARD, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_DOWNWARD, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_TOWARDZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_TOWARDZERO, 4, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_TOWARDZERO, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_TOWARDZERO, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_TOWARDZERO, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_TONEARESTFROMZERO, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_TONEARESTFROMZERO, 4, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_TONEARESTFROMZERO, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_TONEARESTFROMZERO, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_TONEARESTFROMZERO, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_TONEAREST, 3, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 15, FP_INT_TONEAREST, 4, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_TONEAREST, 5, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_TONEAREST, 64, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 15, FP_INT_TONEAREST, UINT_MAX, 15, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_UPWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_UPWARD, 5, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_UPWARD, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_UPWARD, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_UPWARD, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_DOWNWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_DOWNWARD, 5, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_DOWNWARD, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_DOWNWARD, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_DOWNWARD, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_TOWARDZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_TOWARDZERO, 5, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_TOWARDZERO, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_TOWARDZERO, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_TOWARDZERO, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_TONEARESTFROMZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_TONEARESTFROMZERO, 5, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_TONEARESTFROMZERO, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_TONEARESTFROMZERO, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_TONEARESTFROMZERO, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_TONEAREST, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 16, FP_INT_TONEAREST, 5, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_TONEAREST, 6, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_TONEAREST, 64, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 16, FP_INT_TONEAREST, UINT_MAX, 16, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_UPWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_UPWARD, 5, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_UPWARD, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_UPWARD, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_UPWARD, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_DOWNWARD, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_DOWNWARD, 5, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_DOWNWARD, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_DOWNWARD, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_DOWNWARD, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_TOWARDZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_TOWARDZERO, 5, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_TOWARDZERO, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_TOWARDZERO, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_TOWARDZERO, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_TONEARESTFROMZERO, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_TONEARESTFROMZERO, 5, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_TONEARESTFROMZERO, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_TONEARESTFROMZERO, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_TONEARESTFROMZERO, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_TONEAREST, 4, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 17, FP_INT_TONEAREST, 5, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_TONEAREST, 6, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_TONEAREST, 64, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 17, FP_INT_TONEAREST, UINT_MAX, 17, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_UPWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_UPWARD, 22, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_UPWARD, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_UPWARD, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_UPWARD, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_DOWNWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_DOWNWARD, 22, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_DOWNWARD, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_DOWNWARD, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_DOWNWARD, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TOWARDZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TOWARDZERO, 22, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TOWARDZERO, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TOWARDZERO, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TOWARDZERO, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TONEARESTFROMZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TONEARESTFROMZERO, 22, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TONEARESTFROMZERO, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TONEARESTFROMZERO, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TONEAREST, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TONEAREST, 22, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TONEAREST, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TONEAREST, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff, FP_INT_TONEAREST, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_UPWARD, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_UPWARD, 23, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_UPWARD, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_UPWARD, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_UPWARD, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_DOWNWARD, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_DOWNWARD, 23, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_DOWNWARD, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_DOWNWARD, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_DOWNWARD, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TOWARDZERO, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TOWARDZERO, 23, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TOWARDZERO, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TOWARDZERO, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TOWARDZERO, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TONEARESTFROMZERO, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TONEARESTFROMZERO, 23, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TONEARESTFROMZERO, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TONEARESTFROMZERO, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TONEAREST, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TONEAREST, 23, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TONEAREST, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TONEAREST, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400000, FP_INT_TONEAREST, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_UPWARD, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_UPWARD, 23, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_UPWARD, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_UPWARD, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_UPWARD, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_DOWNWARD, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_DOWNWARD, 23, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_DOWNWARD, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_DOWNWARD, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_DOWNWARD, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TOWARDZERO, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TOWARDZERO, 23, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TOWARDZERO, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TOWARDZERO, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TOWARDZERO, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TONEARESTFROMZERO, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TONEARESTFROMZERO, 23, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TONEARESTFROMZERO, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TONEARESTFROMZERO, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TONEAREST, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TONEAREST, 23, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TONEAREST, 24, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TONEAREST, 64, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x400001, FP_INT_TONEAREST, UINT_MAX, 0x400001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_UPWARD, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_UPWARD, 23, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_UPWARD, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_UPWARD, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_UPWARD, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_DOWNWARD, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_DOWNWARD, 23, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_DOWNWARD, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_DOWNWARD, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_DOWNWARD, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TOWARDZERO, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TOWARDZERO, 23, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TOWARDZERO, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TOWARDZERO, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TONEARESTFROMZERO, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TONEARESTFROMZERO, 23, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TONEARESTFROMZERO, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TONEARESTFROMZERO, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TONEAREST, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TONEAREST, 23, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TONEAREST, 24, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TONEAREST, 64, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff, FP_INT_TONEAREST, UINT_MAX, 0x7fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_UPWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_UPWARD, 24, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_UPWARD, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_UPWARD, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_UPWARD, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_DOWNWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_DOWNWARD, 24, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_DOWNWARD, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_DOWNWARD, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_DOWNWARD, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TOWARDZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TOWARDZERO, 24, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TOWARDZERO, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TOWARDZERO, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TOWARDZERO, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TONEARESTFROMZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TONEARESTFROMZERO, 24, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TONEARESTFROMZERO, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TONEARESTFROMZERO, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TONEAREST, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TONEAREST, 24, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TONEAREST, 25, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TONEAREST, 64, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800000, FP_INT_TONEAREST, UINT_MAX, 0x800000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_UPWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_UPWARD, 24, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_UPWARD, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_UPWARD, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_UPWARD, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_DOWNWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_DOWNWARD, 24, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_DOWNWARD, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_DOWNWARD, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_DOWNWARD, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TOWARDZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TOWARDZERO, 24, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TOWARDZERO, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TOWARDZERO, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TOWARDZERO, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TONEARESTFROMZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TONEARESTFROMZERO, 24, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TONEARESTFROMZERO, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TONEARESTFROMZERO, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TONEAREST, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TONEAREST, 24, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TONEAREST, 25, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TONEAREST, 64, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x800001, FP_INT_TONEAREST, UINT_MAX, 0x800001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_UPWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_UPWARD, 24, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_UPWARD, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_UPWARD, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_UPWARD, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_DOWNWARD, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_DOWNWARD, 24, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_DOWNWARD, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_DOWNWARD, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_DOWNWARD, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TOWARDZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TOWARDZERO, 24, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TOWARDZERO, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TOWARDZERO, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TOWARDZERO, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TONEARESTFROMZERO, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TONEARESTFROMZERO, 24, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TONEARESTFROMZERO, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TONEARESTFROMZERO, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TONEAREST, 23, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TONEAREST, 24, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TONEAREST, 25, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TONEAREST, 64, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff, FP_INT_TONEAREST, UINT_MAX, 0xffffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_UPWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_UPWARD, 25, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_UPWARD, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_UPWARD, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_UPWARD, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_DOWNWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_DOWNWARD, 25, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_DOWNWARD, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_DOWNWARD, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_DOWNWARD, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TOWARDZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TOWARDZERO, 25, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TOWARDZERO, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TOWARDZERO, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TOWARDZERO, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TONEARESTFROMZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TONEARESTFROMZERO, 25, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TONEARESTFROMZERO, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TONEARESTFROMZERO, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TONEAREST, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TONEAREST, 25, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TONEAREST, 26, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TONEAREST, 64, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000000, FP_INT_TONEAREST, UINT_MAX, 0x1000000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_UPWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_UPWARD, 25, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_UPWARD, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_UPWARD, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_UPWARD, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_DOWNWARD, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_DOWNWARD, 25, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_DOWNWARD, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_DOWNWARD, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_DOWNWARD, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TOWARDZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TOWARDZERO, 25, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TOWARDZERO, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TOWARDZERO, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TOWARDZERO, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TONEARESTFROMZERO, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TONEARESTFROMZERO, 25, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TONEARESTFROMZERO, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TONEARESTFROMZERO, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TONEAREST, 24, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TONEAREST, 25, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TONEAREST, 26, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TONEAREST, 64, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1000001, FP_INT_TONEAREST, UINT_MAX, 0x1000001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_UPWARD, 50, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_UPWARD, 51, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_UPWARD, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_UPWARD, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 50, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 51, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_DOWNWARD, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 50, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 51, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 50, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 51, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TONEAREST, 50, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TONEAREST, 51, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TONEAREST, 52, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TONEAREST, 64, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0x7ffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_UPWARD, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_UPWARD, 52, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_UPWARD, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_UPWARD, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_UPWARD, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_DOWNWARD, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_DOWNWARD, 52, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_DOWNWARD, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_DOWNWARD, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TOWARDZERO, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TOWARDZERO, 52, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TOWARDZERO, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TOWARDZERO, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 52, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TONEAREST, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TONEAREST, 52, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TONEAREST, 53, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TONEAREST, 64, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_UPWARD, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_UPWARD, 52, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_UPWARD, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_UPWARD, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_UPWARD, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_DOWNWARD, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_DOWNWARD, 52, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_DOWNWARD, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_DOWNWARD, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TOWARDZERO, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TOWARDZERO, 52, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TOWARDZERO, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TOWARDZERO, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 52, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TONEAREST, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TONEAREST, 52, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TONEAREST, 53, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TONEAREST, 64, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000001LL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_UPWARD, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_UPWARD, 52, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_UPWARD, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_UPWARD, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_DOWNWARD, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_DOWNWARD, 52, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_DOWNWARD, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_DOWNWARD, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 52, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TOWARDZERO, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 52, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TONEAREST, 51, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TONEAREST, 52, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TONEAREST, 53, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TONEAREST, 64, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0xfffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_UPWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_UPWARD, 53, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_UPWARD, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_UPWARD, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_UPWARD, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_DOWNWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_DOWNWARD, 53, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_DOWNWARD, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_DOWNWARD, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TOWARDZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TOWARDZERO, 53, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TOWARDZERO, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TOWARDZERO, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 53, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TONEAREST, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TONEAREST, 53, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TONEAREST, 54, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TONEAREST, 64, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x10000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_UPWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_UPWARD, 53, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_UPWARD, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_UPWARD, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_UPWARD, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_DOWNWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_DOWNWARD, 53, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_DOWNWARD, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_DOWNWARD, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_DOWNWARD, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TOWARDZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TOWARDZERO, 53, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TOWARDZERO, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TOWARDZERO, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 53, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TONEAREST, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TONEAREST, 53, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TONEAREST, 54, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TONEAREST, 64, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x10000000000001LL, FP_INT_TONEAREST, UINT_MAX, 0x10000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_UPWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_UPWARD, 53, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_UPWARD, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_UPWARD, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 53, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_DOWNWARD, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 53, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 53, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TONEAREST, 52, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TONEAREST, 53, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TONEAREST, 54, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TONEAREST, 64, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0x1fffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_UPWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_UPWARD, 54, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_UPWARD, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_UPWARD, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_UPWARD, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_DOWNWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_DOWNWARD, 54, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_DOWNWARD, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_DOWNWARD, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TOWARDZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TOWARDZERO, 54, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TOWARDZERO, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TOWARDZERO, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 54, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TONEAREST, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TONEAREST, 54, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TONEAREST, 55, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TONEAREST, 64, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x20000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 64
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_UPWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_UPWARD, 54, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_UPWARD, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_UPWARD, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_UPWARD, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_DOWNWARD, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_DOWNWARD, 54, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_DOWNWARD, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_DOWNWARD, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_DOWNWARD, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TOWARDZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TOWARDZERO, 54, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TOWARDZERO, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TOWARDZERO, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 54, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TONEAREST, 53, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TONEAREST, 54, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TONEAREST, 55, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TONEAREST, 64, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x20000000000001LL, FP_INT_TONEAREST, UINT_MAX, 0x20000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_UPWARD, 61, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_UPWARD, 62, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_UPWARD, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_UPWARD, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 61, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 62, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 61, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 62, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 61, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 62, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 61, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 62, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 63, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TONEAREST, 64, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0x3fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_UPWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_UPWARD, 63, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_UPWARD, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_UPWARD, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_DOWNWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_DOWNWARD, 63, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_DOWNWARD, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TOWARDZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TOWARDZERO, 63, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TOWARDZERO, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 63, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TONEAREST, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TONEAREST, 63, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TONEAREST, 64, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x4000000000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 64
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_UPWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_UPWARD, 63, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_UPWARD, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_UPWARD, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_DOWNWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_DOWNWARD, 63, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_DOWNWARD, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_DOWNWARD, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TOWARDZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TOWARDZERO, 63, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TOWARDZERO, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TOWARDZERO, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 63, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TONEAREST, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TONEAREST, 63, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TONEAREST, 64, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4000000000000001LL, FP_INT_TONEAREST, UINT_MAX, 0x4000000000000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_UPWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_UPWARD, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_UPWARD, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_UPWARD, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_DOWNWARD, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TONEAREST, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffLL, FP_INT_TONEAREST, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_UPWARD, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_UPWARD, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_UPWARD, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_DOWNWARD, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_DOWNWARD, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TOWARDZERO, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TOWARDZERO, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TONEAREST, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TONEAREST, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000000ULL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 64
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_UPWARD, 64, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_UPWARD, 65, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_UPWARD, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_DOWNWARD, 64, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_DOWNWARD, 65, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TOWARDZERO, 64, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TOWARDZERO, 65, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, 65, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TONEAREST, 64, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TONEAREST, 65, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000001ULL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000001ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_UPWARD, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_UPWARD, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_UPWARD, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_DOWNWARD, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_DOWNWARD, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_DOWNWARD, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TOWARDZERO, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TONEAREST, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TONEAREST, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffULL, FP_INT_TONEAREST, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_UPWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_UPWARD, 63, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_UPWARD, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_UPWARD, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 63, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_DOWNWARD, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_DOWNWARD, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 63, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 63, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TONEAREST, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TONEAREST, 63, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TONEAREST, 64, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffff8000000000LL, FP_INT_TONEAREST, UINT_MAX, 0x7fffff8000000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_UPWARD, 64, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_UPWARD, 65, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_UPWARD, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_DOWNWARD, 64, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_DOWNWARD, 65, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_DOWNWARD, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TOWARDZERO, 64, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TOWARDZERO, 65, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, 64, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, 65, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TONEAREST, 64, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TONEAREST, 65, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000010000000000ULL, FP_INT_TONEAREST, UINT_MAX, 0x8000010000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_UPWARD, 64, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_UPWARD, 65, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_UPWARD, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_DOWNWARD, 64, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_DOWNWARD, 65, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_DOWNWARD, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, 64, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, 65, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TOWARDZERO, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, 64, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, 65, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TONEAREST, 64, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TONEAREST, 65, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffff0000000000ULL, FP_INT_TONEAREST, UINT_MAX, 0xffffff0000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 63, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_UPWARD, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_UPWARD, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 63, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_DOWNWARD, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 63, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TOWARDZERO, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 63, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 63, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, 64, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7ffffffffffffc00LL, FP_INT_TONEAREST, UINT_MAX, 0x7ffffffffffffc00LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_UPWARD, 64, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_UPWARD, 65, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_UPWARD, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_DOWNWARD, 64, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_DOWNWARD, 65, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_DOWNWARD, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TOWARDZERO, 64, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TOWARDZERO, 65, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TOWARDZERO, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, 65, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TONEAREST, 64, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TONEAREST, 65, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x8000000000000800ULL, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_UPWARD, 64, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_UPWARD, 65, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_UPWARD, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, 64, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, 65, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_DOWNWARD, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, 64, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, 65, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TOWARDZERO, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, 64, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, 65, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TONEAREST, 64, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TONEAREST, 65, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffffffffffff800ULL, FP_INT_TONEAREST, UINT_MAX, 0xfffffffffffff800ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif

    /* Inputs with absolute value between 0 and 1.  */
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_subnorm_value, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_subnorm_value, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, min_value, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, min_value, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, min_value, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -min_value, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.1, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.1, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.25, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.25, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.499, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.499, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp-1, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp-1, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp-1, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
    TEST_fiu_f (ufromfp, 0.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TONEAREST, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TONEAREST, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TONEAREST, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.5, FP_INT_TONEAREST, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TONEAREST, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TONEAREST, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TONEAREST, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.5, FP_INT_TONEAREST, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000002p-1, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#if MANT_DIG >= 53
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000001p-1, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
#if MANT_DIG >= 64
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
#if MANT_DIG >= 106
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.000000000000000000000000008p-1, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
#if MANT_DIG >= 113
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x1.0000000000000000000000000001p-1, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
    TEST_fiu_f (ufromfp, 0.501, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.501, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.501, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.75, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.75, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0.9, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0.9, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffp0, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#if MANT_DIG >= 53
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.fffffffffffff8p0, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
#if MANT_DIG >= 64
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffp0, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
#if MANT_DIG >= 106
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffcp0, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif
#if MANT_DIG >= 113
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 1, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 2, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 64, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_UPWARD, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 1, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 2, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, 64, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, minus_zero, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, -0x0.ffffffffffffffffffffffffffff8p0, FP_INT_TONEAREST, UINT_MAX, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
#endif

    /* Various non-integer inputs.  */
    TEST_fiu_f (ufromfp, 1.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.25, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.5, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 1.75, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.25, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.5, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 2.75, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.25, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TONEARESTFROMZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TONEAREST, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.5, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TONEARESTFROMZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TONEAREST, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 3.75, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_UPWARD, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_UPWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_UPWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_UPWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_DOWNWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_DOWNWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_DOWNWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_DOWNWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TOWARDZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TOWARDZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TOWARDZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TOWARDZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TONEARESTFROMZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TONEAREST, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.25, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_UPWARD, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_UPWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_UPWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_UPWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_DOWNWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_DOWNWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_DOWNWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_DOWNWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TOWARDZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TOWARDZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TOWARDZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TOWARDZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TONEARESTFROMZERO, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TONEARESTFROMZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TONEARESTFROMZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TONEAREST, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.5, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_UPWARD, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_UPWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_UPWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_UPWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_DOWNWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_DOWNWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_DOWNWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_DOWNWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TOWARDZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TOWARDZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TOWARDZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TOWARDZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TONEARESTFROMZERO, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TONEARESTFROMZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TONEARESTFROMZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TONEAREST, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TONEAREST, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TONEAREST, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 4.75, FP_INT_TONEAREST, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_UPWARD, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_UPWARD, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_UPWARD, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_UPWARD, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_DOWNWARD, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_DOWNWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_DOWNWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_DOWNWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TOWARDZERO, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TOWARDZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TOWARDZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TOWARDZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TONEARESTFROMZERO, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TONEARESTFROMZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TONEARESTFROMZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TONEARESTFROMZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TONEAREST, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TONEAREST, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TONEAREST, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.25, FP_INT_TONEAREST, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_UPWARD, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_UPWARD, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_UPWARD, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_UPWARD, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_DOWNWARD, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_DOWNWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_DOWNWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_DOWNWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TOWARDZERO, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TOWARDZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TOWARDZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TOWARDZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TONEARESTFROMZERO, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TONEARESTFROMZERO, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TONEARESTFROMZERO, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TONEARESTFROMZERO, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TONEAREST, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TONEAREST, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TONEAREST, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.5, FP_INT_TONEAREST, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_UPWARD, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_UPWARD, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_UPWARD, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_UPWARD, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_DOWNWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_DOWNWARD, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_DOWNWARD, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_DOWNWARD, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_DOWNWARD, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TOWARDZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TOWARDZERO, 3, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TOWARDZERO, 4, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TOWARDZERO, 64, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TOWARDZERO, UINT_MAX, 5, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TONEARESTFROMZERO, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TONEARESTFROMZERO, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TONEARESTFROMZERO, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TONEARESTFROMZERO, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TONEAREST, 3, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TONEAREST, 4, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TONEAREST, 64, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 5.75, FP_INT_TONEAREST, UINT_MAX, 6, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),

    /* 1, 1.5, 2, 2.5, 3, 3.5 +/- 1ulp.  */
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffp1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000002p1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffff8p-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.000008p-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffcp0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.000004p0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffff8p-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TONEAREST, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.000008p-1, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MANT_DIG >= 53
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.fffffffffffff8p1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000001p1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.ffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000004p-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffep0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000002p0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.ffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TONEAREST, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000004p-1, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffp1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000002p1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000008p-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffcp0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000004p0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffff8p-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000008p-1, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 106
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffcp1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.000000000000000000000000008p1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.00000000000000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.ffffffffffffffffffffffffffp0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.00000000000000000000000001p0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.00000000000000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 113
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p0, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep-1, FP_INT_TONEAREST, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_UPWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_DOWNWARD, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 1, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 2, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, 64, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TOWARDZERO, UINT_MAX, 1, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x0.ffffffffffffffffffffffffffff8p1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.0000000000000000000000000001p1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x4.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x5.0000000000000000000000000004p-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_UPWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_UPWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_UPWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_UPWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_DOWNWARD, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_DOWNWARD, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_DOWNWARD, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_DOWNWARD, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TOWARDZERO, 2, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TOWARDZERO, 3, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TOWARDZERO, 64, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 2, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x2.fffffffffffffffffffffffffffep0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3.0000000000000000000000000002p0, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x6.fffffffffffffffffffffffffffcp-1, FP_INT_TONEAREST, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_UPWARD, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_UPWARD, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_UPWARD, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_UPWARD, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_UPWARD, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_DOWNWARD, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_DOWNWARD, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 2, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 3, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, 64, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TOWARDZERO, UINT_MAX, 3, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TONEARESTFROMZERO, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TONEAREST, 2, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TONEAREST, 3, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TONEAREST, 4, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TONEAREST, 64, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7.0000000000000000000000000004p-1, FP_INT_TONEAREST, UINT_MAX, 4, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif

    /* 31, 32, 33 fractional bits.  */
#if MANT_DIG >= 53
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_UPWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_UPWARD, 22, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_UPWARD, 23, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_UPWARD, 64, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_UPWARD, UINT_MAX, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_DOWNWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_DOWNWARD, 22, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_DOWNWARD, 23, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_DOWNWARD, 64, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_DOWNWARD, UINT_MAX, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TOWARDZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TOWARDZERO, 22, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TOWARDZERO, 23, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TOWARDZERO, 64, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 22, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 23, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 64, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TONEAREST, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TONEAREST, 22, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TONEAREST, 23, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TONEAREST, 64, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.7ffffffep0, FP_INT_TONEAREST, UINT_MAX, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_UPWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_UPWARD, 22, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_UPWARD, 23, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_UPWARD, 64, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_UPWARD, UINT_MAX, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_DOWNWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_DOWNWARD, 22, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_DOWNWARD, 23, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_DOWNWARD, 64, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TOWARDZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TOWARDZERO, 22, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TOWARDZERO, 23, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TOWARDZERO, 64, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TONEARESTFROMZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TONEARESTFROMZERO, 22, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TONEARESTFROMZERO, 23, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TONEAREST, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TONEAREST, 22, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TONEAREST, 23, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TONEAREST, 64, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.8p0, FP_INT_TONEAREST, UINT_MAX, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_UPWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_UPWARD, 22, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_UPWARD, 23, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_UPWARD, 64, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_UPWARD, UINT_MAX, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_DOWNWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_DOWNWARD, 22, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_DOWNWARD, 23, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_DOWNWARD, 64, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_DOWNWARD, UINT_MAX, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TOWARDZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TOWARDZERO, 22, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TOWARDZERO, 23, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TOWARDZERO, 64, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TOWARDZERO, UINT_MAX, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TONEARESTFROMZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TONEARESTFROMZERO, 22, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TONEARESTFROMZERO, 23, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TONEARESTFROMZERO, 64, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TONEAREST, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TONEAREST, 22, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TONEAREST, 23, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TONEAREST, 64, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200000.80000002p0, FP_INT_TONEAREST, UINT_MAX, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_UPWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_UPWARD, 22, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_UPWARD, 23, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_UPWARD, 64, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_UPWARD, UINT_MAX, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_DOWNWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_DOWNWARD, 22, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_DOWNWARD, 23, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_DOWNWARD, 64, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_DOWNWARD, UINT_MAX, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TOWARDZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TOWARDZERO, 22, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TOWARDZERO, 23, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TOWARDZERO, 64, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 22, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 23, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 64, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TONEAREST, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TONEAREST, 22, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TONEAREST, 23, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TONEAREST, 64, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.7ffffffep0, FP_INT_TONEAREST, UINT_MAX, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_UPWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_UPWARD, 22, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_UPWARD, 23, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_UPWARD, 64, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_UPWARD, UINT_MAX, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_DOWNWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_DOWNWARD, 22, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_DOWNWARD, 23, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_DOWNWARD, 64, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TOWARDZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TOWARDZERO, 22, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TOWARDZERO, 23, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TOWARDZERO, 64, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TONEARESTFROMZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TONEARESTFROMZERO, 22, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TONEARESTFROMZERO, 23, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TONEAREST, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TONEAREST, 22, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TONEAREST, 23, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TONEAREST, 64, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.8p0, FP_INT_TONEAREST, UINT_MAX, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_UPWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_UPWARD, 22, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_UPWARD, 23, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_UPWARD, 64, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_UPWARD, UINT_MAX, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_DOWNWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_DOWNWARD, 22, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_DOWNWARD, 23, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_DOWNWARD, 64, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_DOWNWARD, UINT_MAX, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TOWARDZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TOWARDZERO, 22, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TOWARDZERO, 23, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TOWARDZERO, 64, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TOWARDZERO, UINT_MAX, 0x200001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TONEARESTFROMZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TONEARESTFROMZERO, 22, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TONEARESTFROMZERO, 23, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TONEARESTFROMZERO, 64, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TONEAREST, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TONEAREST, 22, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TONEAREST, 23, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TONEAREST, 64, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x200001.80000002p0, FP_INT_TONEAREST, UINT_MAX, 0x200002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_UPWARD, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_UPWARD, 23, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_UPWARD, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_UPWARD, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_UPWARD, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_DOWNWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_DOWNWARD, 22, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_DOWNWARD, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_DOWNWARD, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_DOWNWARD, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TOWARDZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TOWARDZERO, 22, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TOWARDZERO, 23, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TOWARDZERO, 64, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 0x3fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 23, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TONEAREST, 22, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TONEAREST, 23, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TONEAREST, 24, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TONEAREST, 64, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x3fffff.fffffffep0, FP_INT_TONEAREST, UINT_MAX, 0x400000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_UPWARD, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_UPWARD, 21, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_UPWARD, 22, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_UPWARD, 64, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_UPWARD, UINT_MAX, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_DOWNWARD, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_DOWNWARD, 21, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_DOWNWARD, 22, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_DOWNWARD, 64, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TOWARDZERO, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TOWARDZERO, 21, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TOWARDZERO, 22, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TOWARDZERO, 64, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 21, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 22, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 64, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TONEAREST, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TONEAREST, 21, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TONEAREST, 22, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TONEAREST, 64, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.7fffffffp0, FP_INT_TONEAREST, UINT_MAX, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_UPWARD, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_UPWARD, 21, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_UPWARD, 22, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_UPWARD, 64, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_UPWARD, UINT_MAX, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_DOWNWARD, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_DOWNWARD, 21, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_DOWNWARD, 22, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_DOWNWARD, 64, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TOWARDZERO, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TOWARDZERO, 21, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TOWARDZERO, 22, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TOWARDZERO, 64, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TONEARESTFROMZERO, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TONEARESTFROMZERO, 21, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TONEARESTFROMZERO, 22, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TONEAREST, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TONEAREST, 21, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TONEAREST, 22, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TONEAREST, 64, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.8p0, FP_INT_TONEAREST, UINT_MAX, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_UPWARD, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_UPWARD, 21, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_UPWARD, 22, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_UPWARD, 64, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_UPWARD, UINT_MAX, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_DOWNWARD, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_DOWNWARD, 21, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_DOWNWARD, 22, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_DOWNWARD, 64, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_DOWNWARD, UINT_MAX, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TOWARDZERO, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TOWARDZERO, 21, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TOWARDZERO, 22, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TOWARDZERO, 64, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TONEARESTFROMZERO, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TONEARESTFROMZERO, 21, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TONEARESTFROMZERO, 22, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TONEARESTFROMZERO, 64, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TONEAREST, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TONEAREST, 21, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TONEAREST, 22, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TONEAREST, 64, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000.80000001p0, FP_INT_TONEAREST, UINT_MAX, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_UPWARD, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_UPWARD, 21, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_UPWARD, 22, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_UPWARD, 64, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_UPWARD, UINT_MAX, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_DOWNWARD, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_DOWNWARD, 21, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_DOWNWARD, 22, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_DOWNWARD, 64, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TOWARDZERO, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TOWARDZERO, 21, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TOWARDZERO, 22, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TOWARDZERO, 64, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 21, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 22, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 64, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TONEAREST, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TONEAREST, 21, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TONEAREST, 22, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TONEAREST, 64, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.7fffffffp0, FP_INT_TONEAREST, UINT_MAX, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_UPWARD, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_UPWARD, 21, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_UPWARD, 22, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_UPWARD, 64, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_UPWARD, UINT_MAX, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_DOWNWARD, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_DOWNWARD, 21, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_DOWNWARD, 22, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_DOWNWARD, 64, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TOWARDZERO, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TOWARDZERO, 21, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TOWARDZERO, 22, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TOWARDZERO, 64, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TONEARESTFROMZERO, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TONEARESTFROMZERO, 21, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TONEARESTFROMZERO, 22, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TONEAREST, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TONEAREST, 21, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TONEAREST, 22, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TONEAREST, 64, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.8p0, FP_INT_TONEAREST, UINT_MAX, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_UPWARD, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_UPWARD, 21, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_UPWARD, 22, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_UPWARD, 64, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_UPWARD, UINT_MAX, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_DOWNWARD, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_DOWNWARD, 21, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_DOWNWARD, 22, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_DOWNWARD, 64, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_DOWNWARD, UINT_MAX, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TOWARDZERO, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TOWARDZERO, 21, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TOWARDZERO, 22, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TOWARDZERO, 64, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TONEARESTFROMZERO, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TONEARESTFROMZERO, 21, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TONEARESTFROMZERO, 22, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TONEARESTFROMZERO, 64, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TONEAREST, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TONEAREST, 21, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TONEAREST, 22, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TONEAREST, 64, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100001.80000001p0, FP_INT_TONEAREST, UINT_MAX, 0x100002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_UPWARD, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_UPWARD, 22, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_UPWARD, 23, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_UPWARD, 64, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_UPWARD, UINT_MAX, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_DOWNWARD, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_DOWNWARD, 21, 0x1fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_DOWNWARD, 22, 0x1fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_DOWNWARD, 64, 0x1fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0x1fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TOWARDZERO, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TOWARDZERO, 21, 0x1fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TOWARDZERO, 22, 0x1fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TOWARDZERO, 64, 0x1fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0x1fffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 22, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 23, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 64, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TONEAREST, 21, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TONEAREST, 22, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TONEAREST, 23, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TONEAREST, 64, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1fffff.ffffffffp0, FP_INT_TONEAREST, UINT_MAX, 0x200000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_UPWARD, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_UPWARD, 20, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_UPWARD, 21, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_UPWARD, 64, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_UPWARD, UINT_MAX, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_DOWNWARD, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_DOWNWARD, 20, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_DOWNWARD, 21, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_DOWNWARD, 64, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TOWARDZERO, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TOWARDZERO, 20, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TOWARDZERO, 21, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TOWARDZERO, 64, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 20, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 21, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TONEAREST, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TONEAREST, 20, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TONEAREST, 21, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TONEAREST, 64, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.7fffffff8p0, FP_INT_TONEAREST, UINT_MAX, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_UPWARD, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_UPWARD, 20, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_UPWARD, 21, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_UPWARD, 64, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_UPWARD, UINT_MAX, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_DOWNWARD, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_DOWNWARD, 20, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_DOWNWARD, 21, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_DOWNWARD, 64, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TOWARDZERO, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TOWARDZERO, 20, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TOWARDZERO, 21, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TOWARDZERO, 64, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TONEARESTFROMZERO, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TONEARESTFROMZERO, 20, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TONEARESTFROMZERO, 21, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TONEAREST, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TONEAREST, 20, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TONEAREST, 21, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TONEAREST, 64, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.8p0, FP_INT_TONEAREST, UINT_MAX, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_UPWARD, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_UPWARD, 20, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_UPWARD, 21, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_UPWARD, 64, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_UPWARD, UINT_MAX, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_DOWNWARD, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_DOWNWARD, 20, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_DOWNWARD, 21, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_DOWNWARD, 64, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_DOWNWARD, UINT_MAX, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TOWARDZERO, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TOWARDZERO, 20, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TOWARDZERO, 21, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TOWARDZERO, 64, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TONEARESTFROMZERO, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TONEARESTFROMZERO, 20, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TONEARESTFROMZERO, 21, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TONEARESTFROMZERO, 64, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TONEAREST, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TONEAREST, 20, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TONEAREST, 21, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TONEAREST, 64, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000.800000008p0, FP_INT_TONEAREST, UINT_MAX, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_UPWARD, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_UPWARD, 20, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_UPWARD, 21, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_UPWARD, 64, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_UPWARD, UINT_MAX, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_DOWNWARD, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_DOWNWARD, 20, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_DOWNWARD, 21, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_DOWNWARD, 64, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TOWARDZERO, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TOWARDZERO, 20, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TOWARDZERO, 21, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TOWARDZERO, 64, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 20, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 21, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TONEAREST, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TONEAREST, 20, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TONEAREST, 21, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TONEAREST, 64, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.7fffffff8p0, FP_INT_TONEAREST, UINT_MAX, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_UPWARD, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_UPWARD, 20, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_UPWARD, 21, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_UPWARD, 64, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_UPWARD, UINT_MAX, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_DOWNWARD, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_DOWNWARD, 20, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_DOWNWARD, 21, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_DOWNWARD, 64, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TOWARDZERO, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TOWARDZERO, 20, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TOWARDZERO, 21, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TOWARDZERO, 64, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TONEARESTFROMZERO, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TONEARESTFROMZERO, 20, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TONEARESTFROMZERO, 21, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TONEAREST, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TONEAREST, 20, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TONEAREST, 21, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TONEAREST, 64, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.8p0, FP_INT_TONEAREST, UINT_MAX, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_UPWARD, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_UPWARD, 20, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_UPWARD, 21, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_UPWARD, 64, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_UPWARD, UINT_MAX, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_DOWNWARD, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_DOWNWARD, 20, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_DOWNWARD, 21, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_DOWNWARD, 64, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_DOWNWARD, UINT_MAX, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TOWARDZERO, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TOWARDZERO, 20, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TOWARDZERO, 21, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TOWARDZERO, 64, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80001, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TONEARESTFROMZERO, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TONEARESTFROMZERO, 20, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TONEARESTFROMZERO, 21, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TONEARESTFROMZERO, 64, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TONEAREST, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TONEAREST, 20, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TONEAREST, 21, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TONEAREST, 64, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80001.800000008p0, FP_INT_TONEAREST, UINT_MAX, 0x80002, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_UPWARD, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_UPWARD, 21, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_UPWARD, 22, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_UPWARD, 64, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_UPWARD, UINT_MAX, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_DOWNWARD, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_DOWNWARD, 20, 0xfffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_DOWNWARD, 21, 0xfffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_DOWNWARD, 64, 0xfffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0xfffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TOWARDZERO, 19, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TOWARDZERO, 20, 0xfffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TOWARDZERO, 21, 0xfffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TOWARDZERO, 64, 0xfffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0xfffff, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 21, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 22, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TONEAREST, 20, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TONEAREST, 21, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TONEAREST, 22, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TONEAREST, 64, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xfffff.ffffffff8p0, FP_INT_TONEAREST, UINT_MAX, 0x100000, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 64
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_UPWARD, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_UPWARD, 33, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_UPWARD, 34, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_UPWARD, 64, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_UPWARD, UINT_MAX, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_DOWNWARD, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_DOWNWARD, 33, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_DOWNWARD, 34, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_DOWNWARD, 64, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_DOWNWARD, UINT_MAX, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TOWARDZERO, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TOWARDZERO, 33, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TOWARDZERO, 34, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TOWARDZERO, 64, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 33, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 34, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TONEARESTFROMZERO, 64, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TONEAREST, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TONEAREST, 33, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TONEAREST, 34, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TONEAREST, 64, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.7ffffffep0, FP_INT_TONEAREST, UINT_MAX, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_UPWARD, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_UPWARD, 33, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_UPWARD, 34, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_UPWARD, 64, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_UPWARD, UINT_MAX, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_DOWNWARD, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_DOWNWARD, 33, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_DOWNWARD, 34, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_DOWNWARD, 64, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TOWARDZERO, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TOWARDZERO, 33, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TOWARDZERO, 34, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TOWARDZERO, 64, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TONEARESTFROMZERO, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TONEARESTFROMZERO, 33, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TONEARESTFROMZERO, 34, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TONEAREST, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TONEAREST, 33, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TONEAREST, 34, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TONEAREST, 64, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.8p0, FP_INT_TONEAREST, UINT_MAX, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_UPWARD, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_UPWARD, 33, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_UPWARD, 34, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_UPWARD, 64, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_UPWARD, UINT_MAX, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_DOWNWARD, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_DOWNWARD, 33, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_DOWNWARD, 34, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_DOWNWARD, 64, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_DOWNWARD, UINT_MAX, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TOWARDZERO, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TOWARDZERO, 33, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TOWARDZERO, 34, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TOWARDZERO, 64, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TONEARESTFROMZERO, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TONEARESTFROMZERO, 33, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TONEARESTFROMZERO, 34, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TONEARESTFROMZERO, 64, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TONEAREST, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TONEAREST, 33, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TONEAREST, 34, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TONEAREST, 64, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000000.80000002p0, FP_INT_TONEAREST, UINT_MAX, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_UPWARD, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_UPWARD, 33, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_UPWARD, 34, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_UPWARD, 64, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_UPWARD, UINT_MAX, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_DOWNWARD, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_DOWNWARD, 33, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_DOWNWARD, 34, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_DOWNWARD, 64, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_DOWNWARD, UINT_MAX, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TOWARDZERO, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TOWARDZERO, 33, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TOWARDZERO, 34, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TOWARDZERO, 64, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 33, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 34, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TONEARESTFROMZERO, 64, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TONEAREST, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TONEAREST, 33, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TONEAREST, 34, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TONEAREST, 64, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.7ffffffep0, FP_INT_TONEAREST, UINT_MAX, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_UPWARD, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_UPWARD, 33, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_UPWARD, 34, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_UPWARD, 64, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_UPWARD, UINT_MAX, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_DOWNWARD, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_DOWNWARD, 33, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_DOWNWARD, 34, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_DOWNWARD, 64, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TOWARDZERO, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TOWARDZERO, 33, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TOWARDZERO, 34, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TOWARDZERO, 64, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TONEARESTFROMZERO, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TONEARESTFROMZERO, 33, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TONEARESTFROMZERO, 34, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TONEAREST, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TONEAREST, 33, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TONEAREST, 34, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TONEAREST, 64, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.8p0, FP_INT_TONEAREST, UINT_MAX, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_UPWARD, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_UPWARD, 33, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_UPWARD, 34, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_UPWARD, 64, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_UPWARD, UINT_MAX, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_DOWNWARD, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_DOWNWARD, 33, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_DOWNWARD, 34, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_DOWNWARD, 64, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_DOWNWARD, UINT_MAX, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TOWARDZERO, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TOWARDZERO, 33, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TOWARDZERO, 34, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TOWARDZERO, 64, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TOWARDZERO, UINT_MAX, 0x100000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TONEARESTFROMZERO, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TONEARESTFROMZERO, 33, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TONEARESTFROMZERO, 34, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TONEARESTFROMZERO, 64, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TONEAREST, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TONEAREST, 33, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TONEAREST, 34, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TONEAREST, 64, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x100000001.80000002p0, FP_INT_TONEAREST, UINT_MAX, 0x100000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_UPWARD, 33, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_UPWARD, 34, 0x200000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_UPWARD, 35, 0x200000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_UPWARD, 64, 0x200000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_UPWARD, UINT_MAX, 0x200000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_DOWNWARD, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_DOWNWARD, 33, 0x1ffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_DOWNWARD, 34, 0x1ffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_DOWNWARD, 64, 0x1ffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_DOWNWARD, UINT_MAX, 0x1ffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TOWARDZERO, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TOWARDZERO, 33, 0x1ffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TOWARDZERO, 34, 0x1ffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TOWARDZERO, 64, 0x1ffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TOWARDZERO, UINT_MAX, 0x1ffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 33, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 34, 0x200000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 35, 0x200000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TONEARESTFROMZERO, 64, 0x200000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x200000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TONEAREST, 33, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TONEAREST, 34, 0x200000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TONEAREST, 35, 0x200000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TONEAREST, 64, 0x200000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1ffffffff.fffffffep0, FP_INT_TONEAREST, UINT_MAX, 0x200000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_UPWARD, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_UPWARD, 32, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_UPWARD, 33, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_UPWARD, 64, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_UPWARD, UINT_MAX, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_DOWNWARD, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_DOWNWARD, 32, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_DOWNWARD, 33, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_DOWNWARD, 64, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TOWARDZERO, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TOWARDZERO, 32, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TOWARDZERO, 33, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TOWARDZERO, 64, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 32, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 33, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TONEARESTFROMZERO, 64, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TONEAREST, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TONEAREST, 32, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TONEAREST, 33, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TONEAREST, 64, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.7fffffffp0, FP_INT_TONEAREST, UINT_MAX, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_UPWARD, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_UPWARD, 32, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_UPWARD, 33, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_UPWARD, 64, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_UPWARD, UINT_MAX, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_DOWNWARD, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_DOWNWARD, 32, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_DOWNWARD, 33, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_DOWNWARD, 64, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TOWARDZERO, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TOWARDZERO, 32, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TOWARDZERO, 33, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TOWARDZERO, 64, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TONEARESTFROMZERO, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TONEARESTFROMZERO, 32, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TONEARESTFROMZERO, 33, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TONEAREST, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TONEAREST, 32, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TONEAREST, 33, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TONEAREST, 64, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.8p0, FP_INT_TONEAREST, UINT_MAX, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_UPWARD, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_UPWARD, 32, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_UPWARD, 33, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_UPWARD, 64, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_UPWARD, UINT_MAX, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_DOWNWARD, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_DOWNWARD, 32, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_DOWNWARD, 33, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_DOWNWARD, 64, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_DOWNWARD, UINT_MAX, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TOWARDZERO, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TOWARDZERO, 32, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TOWARDZERO, 33, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TOWARDZERO, 64, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TONEARESTFROMZERO, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TONEARESTFROMZERO, 32, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TONEARESTFROMZERO, 33, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TONEARESTFROMZERO, 64, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TONEAREST, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TONEAREST, 32, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TONEAREST, 33, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TONEAREST, 64, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000000.80000001p0, FP_INT_TONEAREST, UINT_MAX, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_UPWARD, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_UPWARD, 32, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_UPWARD, 33, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_UPWARD, 64, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_UPWARD, UINT_MAX, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_DOWNWARD, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_DOWNWARD, 32, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_DOWNWARD, 33, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_DOWNWARD, 64, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TOWARDZERO, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TOWARDZERO, 32, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TOWARDZERO, 33, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TOWARDZERO, 64, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 32, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 33, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TONEARESTFROMZERO, 64, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TONEAREST, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TONEAREST, 32, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TONEAREST, 33, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TONEAREST, 64, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.7fffffffp0, FP_INT_TONEAREST, UINT_MAX, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_UPWARD, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_UPWARD, 32, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_UPWARD, 33, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_UPWARD, 64, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_UPWARD, UINT_MAX, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_DOWNWARD, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_DOWNWARD, 32, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_DOWNWARD, 33, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_DOWNWARD, 64, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TOWARDZERO, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TOWARDZERO, 32, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TOWARDZERO, 33, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TOWARDZERO, 64, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TONEARESTFROMZERO, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TONEARESTFROMZERO, 32, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TONEARESTFROMZERO, 33, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TONEAREST, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TONEAREST, 32, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TONEAREST, 33, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TONEAREST, 64, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.8p0, FP_INT_TONEAREST, UINT_MAX, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_UPWARD, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_UPWARD, 32, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_UPWARD, 33, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_UPWARD, 64, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_UPWARD, UINT_MAX, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_DOWNWARD, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_DOWNWARD, 32, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_DOWNWARD, 33, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_DOWNWARD, 64, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_DOWNWARD, UINT_MAX, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TOWARDZERO, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TOWARDZERO, 32, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TOWARDZERO, 33, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TOWARDZERO, 64, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TOWARDZERO, UINT_MAX, 0x80000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TONEARESTFROMZERO, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TONEARESTFROMZERO, 32, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TONEARESTFROMZERO, 33, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TONEARESTFROMZERO, 64, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TONEAREST, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TONEAREST, 32, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TONEAREST, 33, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TONEAREST, 64, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x80000001.80000001p0, FP_INT_TONEAREST, UINT_MAX, 0x80000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_UPWARD, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_UPWARD, 33, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_UPWARD, 34, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_UPWARD, 64, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_UPWARD, UINT_MAX, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_DOWNWARD, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_DOWNWARD, 32, 0xffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_DOWNWARD, 33, 0xffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_DOWNWARD, 64, 0xffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_DOWNWARD, UINT_MAX, 0xffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TOWARDZERO, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TOWARDZERO, 32, 0xffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TOWARDZERO, 33, 0xffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TOWARDZERO, 64, 0xffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TOWARDZERO, UINT_MAX, 0xffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 33, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 34, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, 64, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TONEAREST, 32, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TONEAREST, 33, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TONEAREST, 34, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TONEAREST, 64, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffff.ffffffffp0, FP_INT_TONEAREST, UINT_MAX, 0x100000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_UPWARD, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_UPWARD, 31, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_UPWARD, 32, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_UPWARD, 64, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_UPWARD, UINT_MAX, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_DOWNWARD, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_DOWNWARD, 31, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_DOWNWARD, 32, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_DOWNWARD, 64, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TOWARDZERO, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TOWARDZERO, 31, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TOWARDZERO, 32, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TOWARDZERO, 64, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 31, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 32, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TONEAREST, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TONEAREST, 31, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TONEAREST, 32, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TONEAREST, 64, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.7fffffff8p0, FP_INT_TONEAREST, UINT_MAX, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_UPWARD, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_UPWARD, 31, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_UPWARD, 32, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_UPWARD, 64, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_UPWARD, UINT_MAX, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_DOWNWARD, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_DOWNWARD, 31, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_DOWNWARD, 32, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_DOWNWARD, 64, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TOWARDZERO, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TOWARDZERO, 31, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TOWARDZERO, 32, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TOWARDZERO, 64, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TONEARESTFROMZERO, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TONEARESTFROMZERO, 31, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TONEARESTFROMZERO, 32, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TONEAREST, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TONEAREST, 31, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TONEAREST, 32, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TONEAREST, 64, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.8p0, FP_INT_TONEAREST, UINT_MAX, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_UPWARD, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_UPWARD, 31, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_UPWARD, 32, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_UPWARD, 64, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_UPWARD, UINT_MAX, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_DOWNWARD, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_DOWNWARD, 31, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_DOWNWARD, 32, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_DOWNWARD, 64, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_DOWNWARD, UINT_MAX, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TOWARDZERO, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TOWARDZERO, 31, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TOWARDZERO, 32, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TOWARDZERO, 64, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TOWARDZERO, UINT_MAX, 0x40000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TONEARESTFROMZERO, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TONEARESTFROMZERO, 31, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TONEARESTFROMZERO, 32, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TONEARESTFROMZERO, 64, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TONEAREST, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TONEAREST, 31, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TONEAREST, 32, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TONEAREST, 64, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000000.800000008p0, FP_INT_TONEAREST, UINT_MAX, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_UPWARD, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_UPWARD, 31, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_UPWARD, 32, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_UPWARD, 64, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_UPWARD, UINT_MAX, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_DOWNWARD, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_DOWNWARD, 31, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_DOWNWARD, 32, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_DOWNWARD, 64, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TOWARDZERO, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TOWARDZERO, 31, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TOWARDZERO, 32, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TOWARDZERO, 64, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 31, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 32, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TONEAREST, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TONEAREST, 31, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TONEAREST, 32, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TONEAREST, 64, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.7fffffff8p0, FP_INT_TONEAREST, UINT_MAX, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_UPWARD, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_UPWARD, 31, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_UPWARD, 32, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_UPWARD, 64, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_UPWARD, UINT_MAX, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_DOWNWARD, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_DOWNWARD, 31, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_DOWNWARD, 32, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_DOWNWARD, 64, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TOWARDZERO, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TOWARDZERO, 31, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TOWARDZERO, 32, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TOWARDZERO, 64, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TONEARESTFROMZERO, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TONEARESTFROMZERO, 31, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TONEARESTFROMZERO, 32, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TONEAREST, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TONEAREST, 31, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TONEAREST, 32, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TONEAREST, 64, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.8p0, FP_INT_TONEAREST, UINT_MAX, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_UPWARD, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_UPWARD, 31, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_UPWARD, 32, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_UPWARD, 64, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_UPWARD, UINT_MAX, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_DOWNWARD, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_DOWNWARD, 31, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_DOWNWARD, 32, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_DOWNWARD, 64, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_DOWNWARD, UINT_MAX, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TOWARDZERO, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TOWARDZERO, 31, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TOWARDZERO, 32, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TOWARDZERO, 64, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TOWARDZERO, UINT_MAX, 0x40000001LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TONEARESTFROMZERO, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TONEARESTFROMZERO, 31, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TONEARESTFROMZERO, 32, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TONEARESTFROMZERO, 64, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TONEAREST, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TONEAREST, 31, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TONEAREST, 32, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TONEAREST, 64, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x40000001.800000008p0, FP_INT_TONEAREST, UINT_MAX, 0x40000002LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_UPWARD, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_UPWARD, 32, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_UPWARD, 33, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_UPWARD, 64, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_UPWARD, UINT_MAX, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_DOWNWARD, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_DOWNWARD, 31, 0x7fffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_DOWNWARD, 32, 0x7fffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_DOWNWARD, 64, 0x7fffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_DOWNWARD, UINT_MAX, 0x7fffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TOWARDZERO, 30, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TOWARDZERO, 31, 0x7fffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TOWARDZERO, 32, 0x7fffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TOWARDZERO, 64, 0x7fffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 32, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 33, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, 64, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TONEAREST, 31, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TONEAREST, 32, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TONEAREST, 33, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TONEAREST, 64, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffff.ffffffff8p0, FP_INT_TONEAREST, UINT_MAX, 0x80000000LL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif

    /* Tests where overflow depends on the rounding mode.  */
#if MANT_DIG >= 64
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_UPWARD, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_UPWARD, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_UPWARD, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_DOWNWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_DOWNWARD, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_DOWNWARD, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_DOWNWARD, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TOWARDZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TOWARDZERO, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TOWARDZERO, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TONEAREST, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TONEAREST, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.8p0, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 72
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_UPWARD, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_UPWARD, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_UPWARD, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_DOWNWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_DOWNWARD, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_DOWNWARD, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_DOWNWARD, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TOWARDZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TOWARDZERO, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TOWARDZERO, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TONEAREST, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TONEAREST, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TONEAREST, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.7fp0, FP_INT_TONEAREST, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_UPWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_UPWARD, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_UPWARD, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_UPWARD, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_DOWNWARD, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_DOWNWARD, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_DOWNWARD, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_DOWNWARD, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TOWARDZERO, 62, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TOWARDZERO, 63, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TOWARDZERO, 64, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffffffffffffffLL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TONEAREST, 64, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TONEAREST, 65, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffff.81p0, FP_INT_TONEAREST, UINT_MAX, 0x8000000000000000ULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_UPWARD, 65, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_UPWARD, 66, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_UPWARD, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_DOWNWARD, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_DOWNWARD, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_DOWNWARD, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TOWARDZERO, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TONEAREST, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TONEAREST, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TONEAREST, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.7fp0, FP_INT_TONEAREST, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_UPWARD, 65, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_UPWARD, 66, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_UPWARD, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_DOWNWARD, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_DOWNWARD, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_DOWNWARD, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TOWARDZERO, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TOWARDZERO, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 65, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 66, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TONEAREST, 65, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TONEAREST, 66, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.8p0, FP_INT_TONEAREST, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_UPWARD, 65, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_UPWARD, 66, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_UPWARD, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_DOWNWARD, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_DOWNWARD, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_DOWNWARD, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_DOWNWARD, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TOWARDZERO, 63, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TOWARDZERO, 64, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TOWARDZERO, 65, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TOWARDZERO, UINT_MAX, 0xffffffffffffffffULL, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 65, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 66, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TONEAREST, 65, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TONEAREST, 66, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffff.81p0, FP_INT_TONEAREST, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif

    /* Tests that are out of range for compat functions, OK for C23.  */
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_UPWARD, 65, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_UPWARD, 66, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_UPWARD, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_DOWNWARD, 65, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_DOWNWARD, 66, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_DOWNWARD, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TOWARDZERO, 65, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TOWARDZERO, 66, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TOWARDZERO, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEARESTFROMZERO, 65, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEARESTFROMZERO, 66, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEAREST, 65, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEAREST, 66, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p64, FP_INT_TONEAREST, UINT_MAX, 0x1p64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_UPWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_UPWARD, 65, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_UPWARD, 66, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_UPWARD, UINT_MAX, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_DOWNWARD, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_DOWNWARD, 65, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_DOWNWARD, 66, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_DOWNWARD, UINT_MAX, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TOWARDZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TOWARDZERO, 65, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TOWARDZERO, 66, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TOWARDZERO, UINT_MAX, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TONEARESTFROMZERO, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TONEARESTFROMZERO, 65, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TONEARESTFROMZERO, 66, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TONEAREST, 64, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TONEAREST, 65, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TONEAREST, 66, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp64, FP_INT_TONEAREST, UINT_MAX, 0x1.fp64, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_UPWARD, 127, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_UPWARD, 128, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_UPWARD, 129, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_UPWARD, UINT_MAX, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_DOWNWARD, 127, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_DOWNWARD, 128, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_DOWNWARD, 129, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_DOWNWARD, UINT_MAX, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TOWARDZERO, 127, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TOWARDZERO, 128, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TOWARDZERO, 129, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TOWARDZERO, UINT_MAX, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TONEARESTFROMZERO, 127, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TONEARESTFROMZERO, 128, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TONEARESTFROMZERO, 129, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TONEAREST, 127, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TONEAREST, 128, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TONEAREST, 129, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p127, FP_INT_TONEAREST, UINT_MAX, 0x1p127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_UPWARD, 127, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_UPWARD, 128, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_UPWARD, 129, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_UPWARD, UINT_MAX, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_DOWNWARD, 127, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_DOWNWARD, 128, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_DOWNWARD, 129, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_DOWNWARD, UINT_MAX, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TOWARDZERO, 127, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TOWARDZERO, 128, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TOWARDZERO, 129, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TOWARDZERO, UINT_MAX, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TONEARESTFROMZERO, 127, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TONEARESTFROMZERO, 128, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TONEARESTFROMZERO, 129, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TONEAREST, 127, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TONEAREST, 128, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TONEAREST, 129, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp127, FP_INT_TONEAREST, UINT_MAX, 0x1.fp127, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#if MAX_EXP >= 1024
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_UPWARD, 1023, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_UPWARD, 1024, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_UPWARD, 1025, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_UPWARD, UINT_MAX, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_DOWNWARD, 1023, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_DOWNWARD, 1024, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_DOWNWARD, 1025, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_DOWNWARD, UINT_MAX, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TOWARDZERO, 1023, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TOWARDZERO, 1024, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TOWARDZERO, 1025, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TOWARDZERO, UINT_MAX, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TONEARESTFROMZERO, 1023, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TONEARESTFROMZERO, 1024, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TONEARESTFROMZERO, 1025, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TONEAREST, 1023, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TONEAREST, 1024, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TONEAREST, 1025, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p1023, FP_INT_TONEAREST, UINT_MAX, 0x1p1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_UPWARD, 1023, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_UPWARD, 1024, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_UPWARD, 1025, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_UPWARD, UINT_MAX, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_DOWNWARD, 1023, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_DOWNWARD, 1024, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_DOWNWARD, 1025, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_DOWNWARD, UINT_MAX, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TOWARDZERO, 1023, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TOWARDZERO, 1024, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TOWARDZERO, 1025, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TOWARDZERO, UINT_MAX, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TONEARESTFROMZERO, 1023, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TONEARESTFROMZERO, 1024, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TONEARESTFROMZERO, 1025, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TONEAREST, 1023, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TONEAREST, 1024, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TONEAREST, 1025, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp1023, FP_INT_TONEAREST, UINT_MAX, 0x1.fp1023, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MAX_EXP >= 16384
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_UPWARD, 16383, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_UPWARD, 16384, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_UPWARD, 16385, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_UPWARD, UINT_MAX, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_DOWNWARD, 16383, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_DOWNWARD, 16384, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_DOWNWARD, 16385, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_DOWNWARD, UINT_MAX, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TOWARDZERO, 16383, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TOWARDZERO, 16384, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TOWARDZERO, 16385, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TOWARDZERO, UINT_MAX, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TONEARESTFROMZERO, 16383, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TONEARESTFROMZERO, 16384, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TONEARESTFROMZERO, 16385, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TONEAREST, 16383, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TONEAREST, 16384, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TONEAREST, 16385, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1p16383, FP_INT_TONEAREST, UINT_MAX, 0x1p16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_UPWARD, 16383, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_UPWARD, 16384, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_UPWARD, 16385, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_UPWARD, UINT_MAX, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_DOWNWARD, 16383, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_DOWNWARD, 16384, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_DOWNWARD, 16385, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_DOWNWARD, UINT_MAX, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TOWARDZERO, 16383, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TOWARDZERO, 16384, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TOWARDZERO, 16385, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TOWARDZERO, UINT_MAX, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TONEARESTFROMZERO, 16383, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TONEARESTFROMZERO, 16384, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TONEARESTFROMZERO, 16385, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TONEAREST, 16383, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TONEAREST, 16384, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TONEAREST, 16385, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x1.fp16383, FP_INT_TONEAREST, UINT_MAX, 0x1.fp16383, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
#if MANT_DIG >= 80
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_UPWARD, 71, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_UPWARD, 72, 0x1p71, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_UPWARD, 73, 0x1p71, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_UPWARD, UINT_MAX, 0x1p71, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_DOWNWARD, 70, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_DOWNWARD, 71, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_DOWNWARD, 72, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_DOWNWARD, UINT_MAX, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 70, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 71, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 72, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 70, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 71, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 72, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TONEAREST, 70, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TONEAREST, 71, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TONEAREST, 72, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.7fp0, FP_INT_TONEAREST, UINT_MAX, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_UPWARD, 71, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_UPWARD, 72, 0x1p71, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_UPWARD, 73, 0x1p71, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_UPWARD, UINT_MAX, 0x1p71, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_DOWNWARD, 70, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_DOWNWARD, 71, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_DOWNWARD, 72, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_DOWNWARD, UINT_MAX, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TOWARDZERO, 70, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TOWARDZERO, 71, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TOWARDZERO, 72, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TOWARDZERO, UINT_MAX, 0x7fffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 71, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 72, 0x1p71, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 73, 0x1p71, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1p71, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TONEAREST, 71, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TONEAREST, 72, 0x1p71, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TONEAREST, 73, 0x1p71, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0x7fffffffffffffffff.81p0, FP_INT_TONEAREST, UINT_MAX, 0x1p71, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_UPWARD, 72, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_UPWARD, 73, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_UPWARD, 74, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_UPWARD, UINT_MAX, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_DOWNWARD, 71, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_DOWNWARD, 72, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_DOWNWARD, 73, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_DOWNWARD, UINT_MAX, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 71, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 72, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TOWARDZERO, 73, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TOWARDZERO, UINT_MAX, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 71, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 72, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, 73, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TONEAREST, 71, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TONEAREST, 72, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TONEAREST, 73, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.7fp0, FP_INT_TONEAREST, UINT_MAX, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_UPWARD, 72, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_UPWARD, 73, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_UPWARD, 74, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_UPWARD, UINT_MAX, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_DOWNWARD, 71, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_DOWNWARD, 72, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_DOWNWARD, 73, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_DOWNWARD, UINT_MAX, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TOWARDZERO, 71, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TOWARDZERO, 72, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TOWARDZERO, 73, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TOWARDZERO, UINT_MAX, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 72, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 73, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, 74, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TONEAREST, 72, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TONEAREST, 73, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TONEAREST, 74, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.8p0, FP_INT_TONEAREST, UINT_MAX, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_UPWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_UPWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_UPWARD, 72, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_UPWARD, 73, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_UPWARD, 74, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_UPWARD, UINT_MAX, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_DOWNWARD, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_DOWNWARD, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_DOWNWARD, 71, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_DOWNWARD, 72, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_DOWNWARD, 73, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_DOWNWARD, UINT_MAX, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TOWARDZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TOWARDZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TOWARDZERO, 71, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TOWARDZERO, 72, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TOWARDZERO, 73, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TOWARDZERO, UINT_MAX, 0xffffffffffffffffffp0, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 72, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 73, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, 74, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TONEARESTFROMZERO, UINT_MAX, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TONEAREST, 0, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TONEAREST, 1, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TONEAREST, 72, qnan_value, NO_INEXACT_EXCEPTION|INVALID_EXCEPTION|ERRNO_EDOM),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TONEAREST, 73, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TONEAREST, 74, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
    TEST_fiu_f (ufromfp, 0xffffffffffffffffff.81p0, FP_INT_TONEAREST, UINT_MAX, 0x1p72, NO_INEXACT_EXCEPTION|ERRNO_UNCHANGED),
#endif
  };

static void
ufromfp_test (void)
{
  ALL_RM_TEST (ufromfp, 1, ufromfp_test_data, RUN_TEST_LOOP_fiu_f, END);
}

static void
do_test (void)
{
  ufromfp_test ();
}

/*
 * Local Variables:
 * mode:c
 * End:
 */
