/* This machine-generated file includes source code from GNU Jitter.

   Copyright (C) 2016-2021 Luca Saiu
   Written by Luca Saiu

   GNU Jitter is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published
   by the Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   GNU Jitter is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Jitter.  If not, see <https://www.gnu.org/licenses/>.


  Copyright (C) 2017, 2019, 2020, 2021, 2024 Luca Saiu
  Copyright (C) 2021 pEp Foundation
  Updated in 2025 by Luca Saiu
  Written by Luca Saiu

  This file is part of Structured, a GNU Jitter example.

  Structured is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Structured is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Structured.  If not, see <https://www.gnu.org/licenses/>.

*/

/* User-specified code, initial vm2 part: beginning. */

/* User-specified code, initial vm2 part: end */

/* These two macros are convenient for making VM-specific identifiers
   using VM-independent macros from a public header, without polluting
   the global namespace. */
#define JITTER_VM_PREFIX_LOWER_CASE structuredvm
#define JITTER_VM_PREFIX_UPPER_CASE STRUCTUREDVM

#include <jitter/jitter-early-header.h>

//#include <config.h>

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

/* Early C code from the user. */

#   include <stdio.h>
  /* End of the early C code from the user. */

#include <jitter/jitter.h>
#include <jitter/jitter-instruction.h>

#define JITTER_THIS_CAN_INCLUDE_JITTER_EXECUTOR_H
#include <jitter/jitter-executor.h>

#ifdef JITTER_ENABLE_ASSEMBLY
#include <jitter/jitter-machine-common.h>
#include <jitter/machine/jitter-machine.h>
#endif // #ifdef JITTER_ENABLE_ASSEMBLY
#include <jitter/jitter-fatal.h>
#include <jitter/jitter-malloc.h>

#include "structuredvm-vm.h"
//#include "structuredvm-meta-instructions.h"
//#include "structuredvm-specialized-instructions.h"
//#include "structuredvm-state.h"

/* Include stack data structure support. */
#include <jitter/jitter-stack.h>

/* Include patch-in definitions, only if patch-in is enabled.  We know whether it is
   by checking JITTER_HAVE_PATCH_IN , defined in jitter/jitter-patch-in.h .
   The same for defects. */
#include <jitter/jitter-patch-in.h>
#include <jitter/jitter-fast-branch.h>
#include <jitter/jitter-defect.h>
#ifdef JITTER_HAVE_PATCH_IN
  JITTER_PATCH_IN_DESCRIPTOR_DECLARATIONS_(structuredvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_HAVE_DEFECT_REPLACEMENT
  static void jitter_useless_function (void) asm ("jitter_fake_target_asm");
  static void jitter_useless_function (void) {}
  JITTER_DEFECT_DESCRIPTOR_DECLARATIONS_(structuredvm);
  static const char * const structuredvm_fake_target_asm
    = (const char *) & jitter_useless_function;
#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT

/* Always include the non-user fast-branch definitions, which use patch-ins where possible
   or consist in fallback definitions otherwise. */
#include <jitter/jitter-fast-branch.h>

#define JITTER_FAST_BRANCH_PREFIX structuredvm_

/* Most of the needed macros are in jitter-executor.h .  This however
   needs to be here, as it relies on a prefix to be substituted. */
#define _JITTER_STATE_BACKING  \
  (jitter_original_state->structuredvm_state_backing)
/* Expand to an l-value evaluating to the pending_notification field for
   the current state. */
#define JITTER_PENDING_NOTIFICATIONS  \
  (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA->pending_notifications)
/* Expand to an l-value evaluating to the pending field of the struct
   jitter_signal_notification element for the given signal, for the
   current state. */
#define JITTER_PENDING_SIGNAL_NOTIFICATION(signal_id)  \
  ((STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA->pending_signal_notifications + (signal_id))->pending)

/* Expand to the i-th fast register as an lvalue.  This is used internally,
   always with a literal index . */
#define JITTER_FAST_REGISTER(class, index)                             \
  (JITTER_CONCATENATE_FOUR(jitter_state_runtime.jitter_fast_register_, \
                           class, _, index))

/* Expand to the 0-th fast r-register as an lvalue. */
#define JITTER_FAST_REGISTER_r_0 JITTER_FAST_REGISTER(r, 0)

/* Expand to the 1-th fast r-register as an lvalue. */
#define JITTER_FAST_REGISTER_r_1 JITTER_FAST_REGISTER(r, 1)

/* Expand to a slow register lvalue, given an offset in bytes from the base. */
#define JITTER_SLOW_REGISTER_FROM_OFFSET(c, offset)               \
  (* ((JITTER_CONCATENATE_TWO(structuredvm_register_, c) * restrict)  \
      (((char *) jitter_array_base) + offset)))

/* Expand to the i-th register, which must be a slow register, as an lvalue.
   The given index must be a register index counting from 0 and including fast
   regusters as well, if there are any.  For example if an r class had 3 fast
   registers then the first slow register would be %r3, to be accessed as
   JITTER_SLOW_REGISTER(r, 3).  It would be invalid to access %r0, %r1 and
   %r2 which this macro, as %r0, %r1 and %r2 would be fast. */
#define JITTER_SLOW_REGISTER(c, i)                                          \
  JITTER_SLOW_REGISTER_FROM_OFFSET(c, STRUCTUREDVM_SLOW_REGISTER_OFFSET(c, i))

/* It's not possible to have a single macro JITTER_REGISTER taking an index and
   expanding to either a fast or a slow register lvalue, due to CPP conditional
   limitations.  This restriction is unfortunate, but we have to live with it
   as long as we don't switch to a different preprocessor.
   What we can have is a set of zero-argument macros each expanding to a register
   lvalue, for *a limited number* of registers.  Here we define access macros for
   every fast register plus a reasonable number (currently 32) of slow registers,
   per class. */
#define JITTER_REGISTER_r_0    JITTER_FAST_REGISTER(r, 0)
#define JITTER_REGISTER_r_1    JITTER_FAST_REGISTER(r, 1)
#define JITTER_REGISTER_r_2    JITTER_SLOW_REGISTER(r, 2)
#define JITTER_REGISTER_r_3    JITTER_SLOW_REGISTER(r, 3)
#define JITTER_REGISTER_r_4    JITTER_SLOW_REGISTER(r, 4)
#define JITTER_REGISTER_r_5    JITTER_SLOW_REGISTER(r, 5)
#define JITTER_REGISTER_r_6    JITTER_SLOW_REGISTER(r, 6)
#define JITTER_REGISTER_r_7    JITTER_SLOW_REGISTER(r, 7)
#define JITTER_REGISTER_r_8    JITTER_SLOW_REGISTER(r, 8)
#define JITTER_REGISTER_r_9    JITTER_SLOW_REGISTER(r, 9)
#define JITTER_REGISTER_r_10   JITTER_SLOW_REGISTER(r, 10)
#define JITTER_REGISTER_r_11   JITTER_SLOW_REGISTER(r, 11)
#define JITTER_REGISTER_r_12   JITTER_SLOW_REGISTER(r, 12)
#define JITTER_REGISTER_r_13   JITTER_SLOW_REGISTER(r, 13)
#define JITTER_REGISTER_r_14   JITTER_SLOW_REGISTER(r, 14)
#define JITTER_REGISTER_r_15   JITTER_SLOW_REGISTER(r, 15)
#define JITTER_REGISTER_r_16   JITTER_SLOW_REGISTER(r, 16)
#define JITTER_REGISTER_r_17   JITTER_SLOW_REGISTER(r, 17)
#define JITTER_REGISTER_r_18   JITTER_SLOW_REGISTER(r, 18)
#define JITTER_REGISTER_r_19   JITTER_SLOW_REGISTER(r, 19)
#define JITTER_REGISTER_r_20   JITTER_SLOW_REGISTER(r, 20)
#define JITTER_REGISTER_r_21   JITTER_SLOW_REGISTER(r, 21)
#define JITTER_REGISTER_r_22   JITTER_SLOW_REGISTER(r, 22)
#define JITTER_REGISTER_r_23   JITTER_SLOW_REGISTER(r, 23)
#define JITTER_REGISTER_r_24   JITTER_SLOW_REGISTER(r, 24)
#define JITTER_REGISTER_r_25   JITTER_SLOW_REGISTER(r, 25)
#define JITTER_REGISTER_r_26   JITTER_SLOW_REGISTER(r, 26)
#define JITTER_REGISTER_r_27   JITTER_SLOW_REGISTER(r, 27)
#define JITTER_REGISTER_r_28   JITTER_SLOW_REGISTER(r, 28)
#define JITTER_REGISTER_r_29   JITTER_SLOW_REGISTER(r, 29)
#define JITTER_REGISTER_r_30   JITTER_SLOW_REGISTER(r, 30)
#define JITTER_REGISTER_r_31   JITTER_SLOW_REGISTER(r, 31)
#define JITTER_REGISTER_r_32   JITTER_SLOW_REGISTER(r, 32)
#define JITTER_REGISTER_r_33   JITTER_SLOW_REGISTER(r, 33)


#ifdef JITTER_DISPATCH_NO_THREADING

/* Reserve the scratch register, if any. */
#ifdef JITTER_SCRATCH_REGISTER
  register union jitter_word
  jitter_residual_argument_scratch_register_variable asm (JITTER_STRINGIFY(JITTER_SCRATCH_REGISTER));
#endif // #ifdef JITTER_SCRATCH_REGISTER

/* Reserve The Array base register. */
#ifndef JITTER_BASE_REGISTER
# error "the machine does not define JITTER_BASE_REGISTER"
#else
register char * restrict
structuredvm_array_base_register_variable asm (JITTER_STRINGIFY(JITTER_BASE_REGISTER));
#endif // #ifndef JITTER_BASE_REGISTER

/* Reserve registers for our 4 residual arguments.  If this particular VM doesn't
   need all of those supported by the assembly machine then reserve only the first
   ones.  If, on the other hand, we need more residual arguments than we have
   available registers, use CPP macros to map the remaining residual arguments
   to memory locations relative to the base, with constant offsets. */

/* Define a macro for the 0-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_0_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_0));
# define JITTER_RESIDUAL_ARGUMENT_0               \
    jitter_residual_argument_0_register_variable
# define JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_0_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_0  \
    (* (union jitter_word *)                 \
       (jitter_array_base + STRUCTUREDVM_RESIDUAL_OFFSET(0)))
# define JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_0)
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 1-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_1_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_1));
# define JITTER_RESIDUAL_ARGUMENT_1               \
    jitter_residual_argument_1_register_variable
# define JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_1_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_1  \
    (* (union jitter_word *)                 \
       (jitter_array_base + STRUCTUREDVM_RESIDUAL_OFFSET(1)))
# define JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_1)
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 2-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_2_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_2));
# define JITTER_RESIDUAL_ARGUMENT_2               \
    jitter_residual_argument_2_register_variable
# define JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_2_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_2  \
    (* (union jitter_word *)                 \
       (jitter_array_base + STRUCTUREDVM_RESIDUAL_OFFSET(2)))
# define JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_2)
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 3-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (3 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_3_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_3));
# define JITTER_RESIDUAL_ARGUMENT_3               \
    jitter_residual_argument_3_register_variable
# define JITTER_MARK_RESIDUAL_3_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_3_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_3  \
    (* (union jitter_word *)                 \
       (jitter_array_base + STRUCTUREDVM_RESIDUAL_OFFSET(3)))
# define JITTER_MARK_RESIDUAL_3_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_3)
#endif // #if (3 < JITTER_RESIDUAL_REGISTER_NO)

/* The global register values we reserve in this compilation unit are
   callee-save: the called function is supposed to save them before
   setting them, and restore them to their previous value before
   returning to the caller.  Of course this is not done automatically
   in this compilation unit, so we have to do it by hand.  Notice that
   every variable allocated to a register by GCC will not use the
   registers we reserved, so we can be sure that, if we save our
   global register variables before setting them for the first time,
   their values will be the ones we want to retain. */

/* The buffer where I keep the original register values needs to hold
   every residual register, plus possibly the scratch register and the
   residual base; those two registers are not always used, but allocating
   just two words more costs essentially nothing and lets me simplify
   the code a little.  The two words are not written or read unless
   needed. */
#define STRUCTUREDVM_REGISTER_BUFFER_ELEMENT_NO (JITTER_RESIDUAL_REGISTER_NO + 2)
__attribute__ ((noinline, cold))

static void
structuredvm_save_registers (union jitter_word *buffer)
{
  buffer [0].pointer = (union jitter_word*) structuredvm_array_base_register_variable;
#ifdef JITTER_SCRATCH_REGISTER
  buffer [1] = jitter_residual_argument_scratch_register_variable;
#endif // #ifdef JITTER_SCRATCH_REGISTER
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [0 + 2] = JITTER_RESIDUAL_ARGUMENT_0;
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [1 + 2] = JITTER_RESIDUAL_ARGUMENT_1;
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [2 + 2] = JITTER_RESIDUAL_ARGUMENT_2;
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
#if (3 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [3 + 2] = JITTER_RESIDUAL_ARGUMENT_3;
#endif // #if (3 < JITTER_RESIDUAL_REGISTER_NO)
}

__attribute__ ((noinline, cold))
static void
structuredvm_restore_registers (const union jitter_word *buffer)
{
  structuredvm_array_base_register_variable = (char *) buffer [0].pointer;
#ifdef JITTER_SCRATCH_REGISTER
  jitter_residual_argument_scratch_register_variable = buffer [1];
#endif // #ifdef JITTER_SCRATCH_REGISTER
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_0 = buffer [0 + 2];
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_1 = buffer [1 + 2];
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_2 = buffer [2 + 2];
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
#if (3 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_3 = buffer [3 + 2];
#endif // #if (3 < JITTER_RESIDUAL_REGISTER_NO)
}

#endif // #ifdef JITTER_DISPATCH_NO_THREADING


/* The following stack operations (without the initial state
   argument) can be used inside instruction code blocks.
   Notice that macros with the same "STRUCTUREDVM_" names are
   defined in the generated header to be used out of VM code,
   but those alternative definitions have an additional first
   argument, a VM state pointer. */

/* Wrapper definition of the top operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_TOP_MAINSTACK
#undef STRUCTUREDVM_TOP_MAINSTACK
#define STRUCTUREDVM_TOP_MAINSTACK /* The preferred name. */ \
  JITTER_TOP_MAINSTACK
#define JITTER_TOP_MAINSTACK()  \
  JITTER_STACK_TOS_TOP (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the under_top operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_UNDER_TOP_MAINSTACK
#undef STRUCTUREDVM_UNDER_TOP_MAINSTACK
#define STRUCTUREDVM_UNDER_TOP_MAINSTACK /* The preferred name. */ \
  JITTER_UNDER_TOP_MAINSTACK
#define JITTER_UNDER_TOP_MAINSTACK()  \
  JITTER_STACK_TOS_UNDER_TOP (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the at_depth operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_AT_DEPTH_MAINSTACK
#undef STRUCTUREDVM_AT_DEPTH_MAINSTACK
#define STRUCTUREDVM_AT_DEPTH_MAINSTACK /* The preferred name. */ \
  JITTER_AT_DEPTH_MAINSTACK
#define JITTER_AT_DEPTH_MAINSTACK(x0)  \
  JITTER_STACK_TOS_AT_DEPTH (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the at_nonzero_depth operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_AT_NONZERO_DEPTH_MAINSTACK
#undef STRUCTUREDVM_AT_NONZERO_DEPTH_MAINSTACK
#define STRUCTUREDVM_AT_NONZERO_DEPTH_MAINSTACK /* The preferred name. */ \
  JITTER_AT_NONZERO_DEPTH_MAINSTACK
#define JITTER_AT_NONZERO_DEPTH_MAINSTACK(x0)  \
  JITTER_STACK_TOS_AT_NONZERO_DEPTH (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the set_at_depth operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_SET_AT_DEPTH_MAINSTACK
#undef STRUCTUREDVM_SET_AT_DEPTH_MAINSTACK
#define STRUCTUREDVM_SET_AT_DEPTH_MAINSTACK /* The preferred name. */ \
  JITTER_SET_AT_DEPTH_MAINSTACK
#define JITTER_SET_AT_DEPTH_MAINSTACK(x0, x1)  \
  JITTER_STACK_TOS_SET_AT_DEPTH (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0, x1)
/* Wrapper definition of the set_at_nonzero_depth operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_SET_AT_NONZERO_DEPTH_MAINSTACK
#undef STRUCTUREDVM_SET_AT_NONZERO_DEPTH_MAINSTACK
#define STRUCTUREDVM_SET_AT_NONZERO_DEPTH_MAINSTACK /* The preferred name. */ \
  JITTER_SET_AT_NONZERO_DEPTH_MAINSTACK
#define JITTER_SET_AT_NONZERO_DEPTH_MAINSTACK(x0, x1)  \
  JITTER_STACK_TOS_SET_AT_NONZERO_DEPTH (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0, x1)
/* Wrapper definition of the push_unspecified operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_PUSH_UNSPECIFIED_MAINSTACK
#undef STRUCTUREDVM_PUSH_UNSPECIFIED_MAINSTACK
#define STRUCTUREDVM_PUSH_UNSPECIFIED_MAINSTACK /* The preferred name. */ \
  JITTER_PUSH_UNSPECIFIED_MAINSTACK
#define JITTER_PUSH_UNSPECIFIED_MAINSTACK()  \
  JITTER_STACK_TOS_PUSH_UNSPECIFIED (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the push operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_PUSH_MAINSTACK
#undef STRUCTUREDVM_PUSH_MAINSTACK
#define STRUCTUREDVM_PUSH_MAINSTACK /* The preferred name. */ \
  JITTER_PUSH_MAINSTACK
#define JITTER_PUSH_MAINSTACK(x0)  \
  JITTER_STACK_TOS_PUSH (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the under_push_unspecified operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_UNDER_PUSH_UNSPECIFIED_MAINSTACK
#undef STRUCTUREDVM_UNDER_PUSH_UNSPECIFIED_MAINSTACK
#define STRUCTUREDVM_UNDER_PUSH_UNSPECIFIED_MAINSTACK /* The preferred name. */ \
  JITTER_UNDER_PUSH_UNSPECIFIED_MAINSTACK
#define JITTER_UNDER_PUSH_UNSPECIFIED_MAINSTACK()  \
  JITTER_STACK_TOS_UNDER_PUSH_UNSPECIFIED (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the under_push operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_UNDER_PUSH_MAINSTACK
#undef STRUCTUREDVM_UNDER_PUSH_MAINSTACK
#define STRUCTUREDVM_UNDER_PUSH_MAINSTACK /* The preferred name. */ \
  JITTER_UNDER_PUSH_MAINSTACK
#define JITTER_UNDER_PUSH_MAINSTACK(x0)  \
  JITTER_STACK_TOS_UNDER_PUSH (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the drop operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_DROP_MAINSTACK
#undef STRUCTUREDVM_DROP_MAINSTACK
#define STRUCTUREDVM_DROP_MAINSTACK /* The preferred name. */ \
  JITTER_DROP_MAINSTACK
#define JITTER_DROP_MAINSTACK()  \
  JITTER_STACK_TOS_DROP (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the dup operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_DUP_MAINSTACK
#undef STRUCTUREDVM_DUP_MAINSTACK
#define STRUCTUREDVM_DUP_MAINSTACK /* The preferred name. */ \
  JITTER_DUP_MAINSTACK
#define JITTER_DUP_MAINSTACK()  \
  JITTER_STACK_TOS_DUP (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the swap operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_SWAP_MAINSTACK
#undef STRUCTUREDVM_SWAP_MAINSTACK
#define STRUCTUREDVM_SWAP_MAINSTACK /* The preferred name. */ \
  JITTER_SWAP_MAINSTACK
#define JITTER_SWAP_MAINSTACK()  \
  JITTER_STACK_TOS_SWAP (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the quake operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_QUAKE_MAINSTACK
#undef STRUCTUREDVM_QUAKE_MAINSTACK
#define STRUCTUREDVM_QUAKE_MAINSTACK /* The preferred name. */ \
  JITTER_QUAKE_MAINSTACK
#define JITTER_QUAKE_MAINSTACK()  \
  JITTER_STACK_TOS_QUAKE (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the over operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_OVER_MAINSTACK
#undef STRUCTUREDVM_OVER_MAINSTACK
#define STRUCTUREDVM_OVER_MAINSTACK /* The preferred name. */ \
  JITTER_OVER_MAINSTACK
#define JITTER_OVER_MAINSTACK()  \
  JITTER_STACK_TOS_OVER (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the tuck operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_TUCK_MAINSTACK
#undef STRUCTUREDVM_TUCK_MAINSTACK
#define STRUCTUREDVM_TUCK_MAINSTACK /* The preferred name. */ \
  JITTER_TUCK_MAINSTACK
#define JITTER_TUCK_MAINSTACK()  \
  JITTER_STACK_TOS_TUCK (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the nip operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_NIP_MAINSTACK
#undef STRUCTUREDVM_NIP_MAINSTACK
#define STRUCTUREDVM_NIP_MAINSTACK /* The preferred name. */ \
  JITTER_NIP_MAINSTACK
#define JITTER_NIP_MAINSTACK()  \
  JITTER_STACK_TOS_NIP (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the rot operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_ROT_MAINSTACK
#undef STRUCTUREDVM_ROT_MAINSTACK
#define STRUCTUREDVM_ROT_MAINSTACK /* The preferred name. */ \
  JITTER_ROT_MAINSTACK
#define JITTER_ROT_MAINSTACK()  \
  JITTER_STACK_TOS_ROT (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the mrot operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_MROT_MAINSTACK
#undef STRUCTUREDVM_MROT_MAINSTACK
#define STRUCTUREDVM_MROT_MAINSTACK /* The preferred name. */ \
  JITTER_MROT_MAINSTACK
#define JITTER_MROT_MAINSTACK()  \
  JITTER_STACK_TOS_MROT (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the roll operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_ROLL_MAINSTACK
#undef STRUCTUREDVM_ROLL_MAINSTACK
#define STRUCTUREDVM_ROLL_MAINSTACK /* The preferred name. */ \
  JITTER_ROLL_MAINSTACK
#define JITTER_ROLL_MAINSTACK(x0)  \
  JITTER_STACK_TOS_ROLL (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the mroll operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_MROLL_MAINSTACK
#undef STRUCTUREDVM_MROLL_MAINSTACK
#define STRUCTUREDVM_MROLL_MAINSTACK /* The preferred name. */ \
  JITTER_MROLL_MAINSTACK
#define JITTER_MROLL_MAINSTACK(x0)  \
  JITTER_STACK_TOS_MROLL (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the slide operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_SLIDE_MAINSTACK
#undef STRUCTUREDVM_SLIDE_MAINSTACK
#define STRUCTUREDVM_SLIDE_MAINSTACK /* The preferred name. */ \
  JITTER_SLIDE_MAINSTACK
#define JITTER_SLIDE_MAINSTACK(x0, x1)  \
  JITTER_STACK_TOS_SLIDE (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0, x1)
/* Wrapper definition of the whirl operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_WHIRL_MAINSTACK
#undef STRUCTUREDVM_WHIRL_MAINSTACK
#define STRUCTUREDVM_WHIRL_MAINSTACK /* The preferred name. */ \
  JITTER_WHIRL_MAINSTACK
#define JITTER_WHIRL_MAINSTACK(x0)  \
  JITTER_STACK_TOS_WHIRL (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the bulge operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_BULGE_MAINSTACK
#undef STRUCTUREDVM_BULGE_MAINSTACK
#define STRUCTUREDVM_BULGE_MAINSTACK /* The preferred name. */ \
  JITTER_BULGE_MAINSTACK
#define JITTER_BULGE_MAINSTACK(x0)  \
  JITTER_STACK_TOS_BULGE (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the height operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_HEIGHT_MAINSTACK
#undef STRUCTUREDVM_HEIGHT_MAINSTACK
#define STRUCTUREDVM_HEIGHT_MAINSTACK /* The preferred name. */ \
  JITTER_HEIGHT_MAINSTACK
#define JITTER_HEIGHT_MAINSTACK()  \
  JITTER_STACK_TOS_HEIGHT (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the set_height operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_SET_HEIGHT_MAINSTACK
#undef STRUCTUREDVM_SET_HEIGHT_MAINSTACK
#define STRUCTUREDVM_SET_HEIGHT_MAINSTACK /* The preferred name. */ \
  JITTER_SET_HEIGHT_MAINSTACK
#define JITTER_SET_HEIGHT_MAINSTACK(x0)  \
  JITTER_STACK_TOS_SET_HEIGHT (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the reverse operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_REVERSE_MAINSTACK
#undef STRUCTUREDVM_REVERSE_MAINSTACK
#define STRUCTUREDVM_REVERSE_MAINSTACK /* The preferred name. */ \
  JITTER_REVERSE_MAINSTACK
#define JITTER_REVERSE_MAINSTACK(x0)  \
  JITTER_STACK_TOS_REVERSE (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the unary operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_UNARY_MAINSTACK
#undef STRUCTUREDVM_UNARY_MAINSTACK
#define STRUCTUREDVM_UNARY_MAINSTACK /* The preferred name. */ \
  JITTER_UNARY_MAINSTACK
#define JITTER_UNARY_MAINSTACK(x0)  \
  JITTER_STACK_TOS_UNARY (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the binary operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_BINARY_MAINSTACK
#undef STRUCTUREDVM_BINARY_MAINSTACK
#define STRUCTUREDVM_BINARY_MAINSTACK /* The preferred name. */ \
  JITTER_BINARY_MAINSTACK
#define JITTER_BINARY_MAINSTACK(x0)  \
  JITTER_STACK_TOS_BINARY (jitter_int,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)

/* Late C code from the user. */

    static const char *structured_fixnum_format_string = "%" JITTER_PRIi "\n";
  
static jitter_int
structured_input (void)
{
#define STRUCTURED_PROMPT "> "
  printf (STRUCTURED_PROMPT);
  jitter_int res;
  int scanf_result;
  while ((scanf_result = scanf ("%" JITTER_PRIi, & res)) != 1)
    {
      printf ("Invalid input: expecting an integer.\n" STRUCTURED_PROMPT);
    }
  return res;
#undef STRUCTURED_PROMPT
}
  /* End of the late C code from the user. */

/* The definition of this is machine-generated in structuredvm-vm2.c , and the
   function is not intended for the user.  If initializing then set
   structuredvm_threads and structuredvm_thread_sizes and just return, ignoring
   the other fields and s.  If not initializing then actually enter VM code
   starting from the initial program point in the state. */
static enum structuredvm_exit_status
structuredvm_execute_or_initialize (bool jitter_initialize,
                                struct structuredvm_state * const jitter_original_state)
  __attribute__ ((noclone, noinline, no_reorder));

enum structuredvm_exit_status
structuredvm_execute_executable_routine (const struct jitter_executable_routine *er,
                                     struct structuredvm_state *s)
{
  structuredvm_make_place_for_slow_registers (s, er->slow_register_per_class_no);
  jitter_program_point initial_program_point
    = STRUCTUREDVM_EXECUTABLE_ROUTINE_BEGINNING (er);
  return structuredvm_branch_to_program_point (initial_program_point,
                                           s);
}


/* Threads or pointers to native code blocks of course don't exist with
   switch-dispatching. */
#ifndef JITTER_DISPATCH_SWITCH
const jitter_thread *
structuredvm_threads;

const jitter_thread *
structuredvm_thread_ends;

const long *
structuredvm_thread_sizes;
#endif // #ifndef JITTER_DISPATCH_SWITCH

void
structuredvm_initialize_threads (void)
{
  structuredvm_execute_or_initialize (true, NULL);
}

enum structuredvm_exit_status
structuredvm_branch_to_program_point (structuredvm_program_point p, struct structuredvm_state *s)
{
  /* Change the state to set the initial program point. */
  s->structuredvm_state_backing.initial_program_point = p;

  /* Execute. */
  return structuredvm_execute_or_initialize (false, s);
}

__attribute__ ((noinline, noclone, no_reorder))
void
structuredvm_asm_headers (void)
{
#ifdef JITTER_HAVE_PATCH_IN
  /* Generate the single patch-in header for this executor as a
     global asm statement.  This expands into a global definition in
     assembly in a separate subsection, and relies on toplevel C
     definitions not being reordered: structuredvm_execute_or_initialize
     will add to the same global.  Do the same for defects. */
  JITTER_PATCH_IN_HEADER(structuredvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_HAVE_DEFECT_REPLACEMENT

  /* The same for defects... */
  JITTER_DEFECT_HEADER(structuredvm);
#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT

#ifndef JITTER_DISPATCH_SWITCH
  JITTER_DATA_LOCATION_HEADER(structuredvm);
#endif // #ifndef JITTER_DISPATCH_SWITCH

}
static enum structuredvm_exit_status
structuredvm_execute_or_initialize (bool jitter_initialize,
                                struct structuredvm_state * const jitter_original_state)
{
/* Undefine the state field access macros which are meant to be
   used out of VM instructions. */
#undef STRUCTUREDVM_STATE_RUNTIME_FIELD
#undef STRUCTUREDVM_STATE_BACKING_FIELD

/* Replace the definitions by versions which will work (only!)
   inside instruction bodies.  These macros have one argument
   instead of two: the VM state being used is *the* current
   state. */
#define STRUCTUREDVM_STATE_RUNTIME_FIELD  _JITTER_STATE_RUNTIME_FIELD
#define STRUCTUREDVM_STATE_BACKING_FIELD  _JITTER_STATE_BACKING_FIELD

#ifdef JITTER_DISPATCH_NO_THREADING
  /* Save the values in the registers we reserved as global variables,
     since from the point of view of the other C compilation units such
     registers are callee-save.  FIXME: this is not really needed when
     initializing, if I've been careful; but for the time being I want
     to play it safe. */
  union jitter_word jitter_register_buffer [STRUCTUREDVM_REGISTER_BUFFER_ELEMENT_NO];
  structuredvm_save_registers (jitter_register_buffer);
#endif // #ifdef JITTER_DISPATCH_NO_THREADING

  /* Initialization.  This is only called once at startup. */
  if (__builtin_expect (jitter_initialize, false))
    {
      /* Make sure that vm1 and vm2 were macroexpanded consistently
         with respect to instrumentation macros.  This relies on the
         enum values for each feature working as individual bits in a
         bitmask: see the comment in jitter/jitter-vm.h . */
      enum jitter_vm_instrumentation correct_instrumentation
        = jitter_vm_instrumentation_none;
#if defined (STRUCTUREDVM_PROFILE_COUNT)
      correct_instrumentation |= jitter_vm_instrumentation_count;
#endif
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
      correct_instrumentation |= jitter_vm_instrumentation_sample;
#endif
      if (structuredvm_vm_configuration->instrumentation != correct_instrumentation)
        jitter_fatal ("vm1 and vm2 were compiled with different profiling "
                      "instrumentation macros.  Please recompile with coherent "
                      "CPPFLAGS");

#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
    /* Initialise the sample-profile subsystem, once and for all. */
    structuredvm_profile_sample_initialize ();
#endif // #if defined (STRUCTUREDVM_PROFILE_SAMPLE)

#ifndef JITTER_DISPATCH_SWITCH
      /* FIXME: I can do this with only one relocation, by keeping
         a pointer to the first VM instruction beginning in a static
         variable, and then having a static vector of offsets with
         respect to the first pointer.  This will slightly complicate
         my initialization code, but should make startup faster.
         FIXME: that won't work on AVR, according to the GCC
         documentation.  Do I care?  Probably not, since AVRs can't
         address more than 2^16 bytes, which is too little to run my
         VMs. */
      static const jitter_thread structuredvm_the_threads []
        = {
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eINVALID),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eBEGINBASICBLOCK),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eEXITVM),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eDATALOCATIONS),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eNOP),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_ePRETENDTOJUMPANYWHERE),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(b__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n_m1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n2__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bf_mstack__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n_m1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n2__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bt_mstack__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__fR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mto_mr_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mto_mr_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mto_mr_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(different_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided_mstack__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(dup_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equal_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exitvm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(greater_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(greaterorequal_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input_mstack__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(isnonzero_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(less_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lessorequal_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n3___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n3___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n3___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n4___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n4___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n4___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n5___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n5___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n5___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n6___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n6___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n6___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n7___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n7___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n7___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n8___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n8___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n8___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n9___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n9___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n9___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n10___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n10___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__n10___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(load_mboxed_mliteral__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(logicaland_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(logicalnot_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(logicalor_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusi_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusi_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusi_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n_m1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n_m1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n_m1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__n2__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__n_m1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print_mstack__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(procedure_mprolog),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mboxed_mliteral__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mboxed_mliteral__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mboxed_mliteral__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mboxed_mliteral__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mboxed_mliteral__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mboxed_mliteral__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mboxed_mliteral__n6),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mboxed_mliteral__n7),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mboxed_mliteral__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mboxed_mliteral__n9),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mboxed_mliteral__n10),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mboxed_mliteral__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n_m1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_munspecified_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder_mstack__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(return_mto_mundertop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swap_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(underpop_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(underpop_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(underpop_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(underpush_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(underpush_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(underpush_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(underpush_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(unreachable),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mb__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rr0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rr0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rr0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rr0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rr0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rr1___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rr1___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rr1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rr1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rr1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rrR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rrR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe__n0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe__n0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe__nR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe__nR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbe__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__n_m1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__n2__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbf_mstack__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rr0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rr0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rr0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rr0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rr0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rr1___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rr1___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rr1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rr1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rr1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rrR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rrR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg__n0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg__n0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg__nR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg__nR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbg__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rr0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rr0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rr0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rr0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rr0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rr1___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rr1___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rr1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rr1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rr1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rrR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rrR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__n0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__n0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__nR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__nR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbge__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rr0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rr0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rr0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rr0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rr0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rr1___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rr1___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rr1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rr1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rr1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rrR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rrR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl__n0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl__n0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl__nR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl__nR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbl__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rr0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rr0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rr0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rr0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rr0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rr1___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rr1___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rr1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rr1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rr1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rrR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rrR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__n0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__n0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__nR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__nR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mble__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rr0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rr0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rr0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rr0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rr0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rr1___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rr1___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rr1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rr1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rr1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rrR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rrR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__n0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__n0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__nR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__nR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbne__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__n_m1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__n2__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbt_mstack__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mexitvm__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprocedure_mprolog__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mreturn_mto_mundertop__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_munreachable__retR),
                0)
          };
      static const jitter_thread structuredvm_the_thread_ends []
        = {
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eINVALID),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eBEGINBASICBLOCK),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eEXITVM),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eDATALOCATIONS),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eNOP),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_ePRETENDTOJUMPANYWHERE),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(b__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__n_m1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__n2__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bf_mstack__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__n_m1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__n2__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bt_mstack__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__fR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(copy_mto_mr_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(copy_mto_mr_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(copy_mto_mr_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(different_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided_mstack__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(dup_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equal_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equali_mstack__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equali_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equali_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equali_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(exitvm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(greater_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(greaterorequal_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(input___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(input___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(input___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(input_mstack__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(isnonzero_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(less_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lessorequal_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n3___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n3___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n3___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n4___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n4___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n4___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n5___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n5___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n5___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n6___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n6___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n6___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n7___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n7___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n7___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n8___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n8___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n8___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n9___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n9___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n9___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n10___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n10___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__n10___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(load_mboxed_mliteral__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(logicaland_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(logicalnot_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(logicalor_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusi_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusi_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusi_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n_m1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n_m1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n_m1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__n2__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plusi_mstack__n_m1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plusi_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plusi_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plusi_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pop_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pop_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pop_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print_mstack__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(procedure_mprolog),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mboxed_mliteral__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mboxed_mliteral__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mboxed_mliteral__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mboxed_mliteral__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mboxed_mliteral__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mboxed_mliteral__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mboxed_mliteral__n6),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mboxed_mliteral__n7),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mboxed_mliteral__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mboxed_mliteral__n9),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mboxed_mliteral__n10),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mboxed_mliteral__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__n_m1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_munspecified_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr0___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr0___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr0___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr1___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr1___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr1___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rrR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rrR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rrR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__n2___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__n2___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__n2___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__nR___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__nR___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__nR___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder_mstack__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(return_mto_mundertop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swap_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(underpop_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(underpop_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(underpop_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(underpush_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(underpush_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(underpush_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(underpush_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(unreachable),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mb__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rr0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rr0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rr0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rr0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rr0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rr1___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rr1___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rr1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rr1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rr1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rrR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rrR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe__n0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe__n0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe__nR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe__nR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbe__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__n_m1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__n2__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbf_mstack__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rr0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rr0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rr0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rr0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rr0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rr1___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rr1___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rr1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rr1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rr1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rrR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rrR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg__n0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg__n0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg__nR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg__nR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbg__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rr0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rr0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rr0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rr0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rr0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rr1___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rr1___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rr1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rr1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rr1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rrR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rrR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__n0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__n0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__nR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__nR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbge__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rr0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rr0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rr0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rr0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rr0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rr1___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rr1___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rr1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rr1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rr1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rrR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rrR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl__n0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl__n0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl__nR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl__nR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbl__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rr0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rr0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rr0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rr0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rr0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rr1___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rr1___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rr1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rr1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rr1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rrR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rrR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__n0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__n0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__nR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__nR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mble__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rr0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rr0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rr0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rr0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rr0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rr1___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rr1___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rr1___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rr1__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rr1__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rrR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rrR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rrR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne___rrR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__n0___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__n0___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__n0___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__n0__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__n0__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__nR___rr0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__nR___rr1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__nR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbne__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__n_m1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__n2__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbt_mstack__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mexitvm__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprocedure_mprolog__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mreturn_mto_mundertop__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_munreachable__retR),
                0)
          };
      /* A few non-GCC compilers such as TCC support GNU C's labels
         as values, but do not recognise their differences as
         *constant* expressions.  Compute the difference at
         initialisation then. */
      static long
      structuredvm_the_thread_sizes [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO];
      int i;
      for (i = 0; i < STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO; i ++)
        structuredvm_the_thread_sizes [i]
          = structuredvm_the_thread_ends [i] - structuredvm_the_threads [i];
      structuredvm_thread_sizes
        = (const long *) structuredvm_the_thread_sizes;
      structuredvm_threads = structuredvm_the_threads;
      structuredvm_thread_ends = structuredvm_the_thread_ends;

#ifdef JITTER_HAVE_DEFECT_REPLACEMENT
      /* Define the correct distance between the fake target in C
         and in assembly, for this VM. */
      JITTER_DEFECT_CORRECT_DISPLACEMENT_NAME (structuredvm)
        = ((char *) && jitter_fake_target
           - (char *) structuredvm_fake_target_asm);
      //fprintf (stderr, "DEBUG: INITIALISE CORRECT DISPLACEMENT TO %li\n", (long) JITTER_DEFECT_CORRECT_DISPLACEMENT_NAME (structuredvm));
#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT

#endif // #ifndef JITTER_DISPATCH_SWITCH

      /* Back to regular C, without our reserved registers if any; I can share
         the end code with the non-initialization case. */
#ifdef JITTER_HAVE_PATCH_IN
      //JITTER_DUMP_PATCH_IN_DESCRIPTORS(structuredvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN
      goto jitter_possibly_restore_registers_and_return_label;
    }


  /* Before setting up runtime structures and jumping to the first
     instruction check that the last exit status was correct, and
     update it for the present run. */
  switch (_JITTER_STATE_BACKING_FIELD (exit_status))
    {
    case structuredvm_exit_status_never_executed:
    case structuredvm_exit_status_exited:
    case structuredvm_exit_status_debug:
      /* This is normal and expected. */
      _JITTER_STATE_BACKING_FIELD (exit_status)
        = structuredvm_exit_status_being_executed;
      break;

    case structuredvm_exit_status_being_executed:
      jitter_fatal ("the exit status before execution is "
                    "structuredvm_exit_status_being_executed: "
                    "you may have exited the last evaluation "
                    "through longjmp, or reused the same VM "
                    "state for a new execution with a previous "
                    "execution still in progress.");

    default:
      jitter_fatal ("invalid exit state %i",
                    (int) _JITTER_STATE_BACKING_FIELD (exit_status));
    }

  /* Here is the actual *executor* initialization, to be run before
     actually running the code. */

/* Selectively suppress suprious -Wmaybe-uninitialized .
   The indirect jump hack I use in profiling mode in order to
   have a large gap inside a function introduced by assembler without
   being restricted by jump offset limits (intentionally) tricks GCC
   into believing that the indirect jump may reach any instruction label;
   GCC would then warn that some locals might be used uninitialized,
   by skipping over their initialization.  This however is not possible,
   and I want to selectively silence the warning for the variables in
   question. */
//#pragma GCC diagnostic push
//#pragma GCC diagnostic ignored "-Wmaybe-uninitialized"

  /* Wrap functions and globals used within VM instructions, if needed.
     This is a trick to keep instructions readable while avoiding PC-relative
     addressing, which would mess up replicated code. */
#ifdef JITTER_REPLICATE

  /* Protect the C globals used in VM instructions so that they are always
     referred thru a pointer (from a register or the stack) set in the
     non-replicated part.  This is necessary on architectures where I can't
     force global references to pass thru a GOT.
     [FIXME: possibly don't do this on architectures that don't need it.] */

  typeof (structuredvm_states) * volatile _my_volatile_pointer_to_structuredvm_states = & structuredvm_states;
  typeof (structuredvm_states) * const restrict _my_pointer_to_structuredvm_states __attribute__ ((unused))
     = _my_volatile_pointer_to_structuredvm_states;
# undef structuredvm_states
# define structuredvm_states (* _my_pointer_to_structuredvm_states)

  typeof (structured_fixnum_format_string) * volatile _my_volatile_pointer_to_structured_fixnum_format_string = & structured_fixnum_format_string;
  typeof (structured_fixnum_format_string) * const restrict _my_pointer_to_structured_fixnum_format_string __attribute__ ((unused))
     = _my_volatile_pointer_to_structured_fixnum_format_string;
# undef structured_fixnum_format_string
# define structured_fixnum_format_string (* _my_pointer_to_structured_fixnum_format_string)

  /* Similarly, wrap the C functions used in VM instructions, so that they are
     always called thru a function pointer.  This is necessary on architectures
     where call instructions represent the callee as a PC-relative address.
     Unfortunately C has a special quirky syntax for function pointers, so I
     can't just use the code above.  [FIXME: don't do this on architectures
     that don't need it.] */
  typeof (structured_input) * volatile _jitter_my_volatile_pointer_to_structured_input = & structured_input;
  typeof (structured_input) * const _jitter_my_structured_input __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_structured_input;
# undef structured_input
# define structured_input(...)  \
  JITTER_CALL_C (_jitter_my_structured_input, __VA_ARGS__)
  typeof (printf) * volatile _jitter_my_volatile_pointer_to_printf = & printf;
  typeof (printf) * const _jitter_my_printf __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_printf;
# undef printf
# define printf(...)  \
  JITTER_CALL_C (_jitter_my_printf, __VA_ARGS__)
/* See the comment above about spurious -Wmaybe-uninitialized warnings. */
//#pragma GCC diagnostic pop
#endif // #ifdef JITTER_REPLICATE


  /* Make an automatic struct holding a copy of the state whose pointer was given.
     The idea is that the copy should be in registers, as far as possible. */
  struct structuredvm_state_runtime jitter_state_runtime
    = jitter_original_state->_structuredvm_yQcCd7rlyo_state_runtime;

  /* Initialize a pointer to The Array base.  This pointer will be in a
     global register variable with no-threading dispatch, and with
     other dispatches in an automatic variable, still hopefully kept
     in a register. */
/* About the pragma, look for "-Wmaybe-uninitialized" in the comments above. FIXME: this is to avoid a GCC warning with profiling.  Check with profiling on. */
//#pragma GCC diagnostic push
//#pragma GCC diagnostic ignored "-Wmaybe-uninitialized"
#ifdef JITTER_DISPATCH_NO_THREADING
# define jitter_array_base structuredvm_array_base_register_variable
#else
  char * restrict jitter_array_base __attribute__ ((unused));
#endif // #ifdef JITTER_DISPATCH_NO_THREADING
//#pragma GCC diagnostic pop
  jitter_array_base
    = (((char *) jitter_original_state->structuredvm_state_backing.jitter_array)
       + JITTER_ARRAY_BIAS);

  /* Declare the instruction pointer from the thread array, unless the dispatch
     is no-threading, in which case no thread array even exists. */
  structuredvm_program_point jitter_ip = NULL; /* Invalidate to catch errors. */
#ifdef JITTER_REPLICATE
  /* Save an instruction address within this function, to jump to at VM exit
     time; that way we can be sure that at exit time we are back to
     non-replicated code, and stuff like PC-relative addressing work again
     without special tricks.  This variable may safely (and actually should,
     for performance) be kept on the stack.  We need it to be volatile to
     prevent the compiler from being too clever and jump to it using a
     PC-relative displacement from replicated code.   It must not be static,
     since non-automatic variables are problematic to access from replicated
     code, which might use PC-relative addressing. */
  volatile typeof (&& jitter_exit_vm_label) restrict
  jitter_saved_exit_non_replicated_code_pointer = &&jitter_exit_vm_label;
  JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(jitter_saved_exit_non_replicated_code_pointer);
#endif // #ifdef JITTER_REPLICATE


#ifdef JITTER_REPLICATE
  /* FIXME: comment. */
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr0___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0___rr0___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr0___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr0___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr0___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0___rr0___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr0___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr0___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr0___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0___rr0___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr0___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr0___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr1___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0___rr1___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr1___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr1___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr1___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0___rr1___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr1___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr1___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr1___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0___rr1___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr1___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rr1___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rrR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0___rrR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rrR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rrR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rrR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0___rrR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rrR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rrR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rrR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0___rrR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rrR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0___rrR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__n2___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0__n2___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__n2___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__n2___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__n2___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0__n2___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__n2___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__n2___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__n2___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0__n2___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__n2___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__n2___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__nR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0__nR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__nR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__nR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__nR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0__nR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__nR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__nR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__nR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr0__nR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__nR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr0__nR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr0___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1___rr0___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr0___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr0___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr0___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1___rr0___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr0___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr0___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr0___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1___rr0___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr0___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr0___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr1___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1___rr1___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr1___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr1___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr1___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1___rr1___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr1___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr1___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr1___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1___rr1___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr1___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rr1___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rrR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1___rrR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rrR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rrR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rrR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1___rrR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rrR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rrR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rrR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1___rrR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rrR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1___rrR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__n2___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1__n2___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__n2___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__n2___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__n2___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1__n2___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__n2___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__n2___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__n2___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1__n2___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__n2___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__n2___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__nR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1__nR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__nR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__nR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__nR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1__nR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__nR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__nR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__nR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rr1__nR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__nR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rr1__nR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr0___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR___rr0___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr0___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr0___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr0___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR___rr0___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr0___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr0___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr0___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR___rr0___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr0___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr0___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr1___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR___rr1___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr1___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr1___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr1___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR___rr1___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr1___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr1___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr1___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR___rr1___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr1___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rr1___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rrR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR___rrR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rrR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rrR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rrR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR___rrR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rrR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rrR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rrR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR___rrR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rrR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR___rrR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__n2___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR__n2___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__n2___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__n2___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__n2___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR__n2___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__n2___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__n2___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__n2___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR__n2___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__n2___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__n2___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__nR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR__nR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__nR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__nR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__nR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR__nR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__nR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__nR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__nR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided___rrR__nR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__nR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided___rrR__nR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr0___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR___rr0___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr0___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr0___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr0___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR___rr0___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr0___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr0___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr0___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR___rr0___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr0___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr0___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr1___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR___rr1___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr1___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr1___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr1___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR___rr1___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr1___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr1___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr1___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR___rr1___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr1___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rr1___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rrR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR___rrR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rrR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rrR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rrR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR___rrR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rrR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rrR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rrR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR___rrR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rrR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR___rrR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__n2___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR__n2___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__n2___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__n2___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__n2___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR__n2___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__n2___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__n2___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__n2___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR__n2___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__n2___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__n2___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__nR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR__nR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__nR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__nR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__nR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR__nR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__nR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__nR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__nR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided__nR__nR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__nR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided__nR__nR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided_mstack__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(divided_mstack__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided_mstack__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(divided_mstack__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(input___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(input___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(input___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input_mstack__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(input_mstack__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input_mstack__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input_mstack__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(print___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(print___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(print___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(print__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print_mstack__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(print_mstack__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print_mstack__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print_mstack__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr0___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0___rr0___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr0___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr0___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr0___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0___rr0___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr0___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr0___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr0___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0___rr0___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr0___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr0___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr1___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0___rr1___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr1___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr1___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr1___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0___rr1___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr1___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr1___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr1___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0___rr1___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr1___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rr1___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rrR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0___rrR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rrR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rrR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rrR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0___rrR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rrR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rrR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rrR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0___rrR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rrR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0___rrR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__n2___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0__n2___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__n2___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__n2___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__n2___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0__n2___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__n2___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__n2___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__n2___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0__n2___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__n2___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__n2___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__nR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0__nR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__nR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__nR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__nR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0__nR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__nR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__nR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__nR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr0__nR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__nR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr0__nR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr0___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1___rr0___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr0___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr0___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr0___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1___rr0___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr0___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr0___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr0___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1___rr0___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr0___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr0___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr1___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1___rr1___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr1___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr1___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr1___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1___rr1___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr1___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr1___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr1___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1___rr1___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr1___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rr1___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rrR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1___rrR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rrR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rrR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rrR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1___rrR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rrR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rrR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rrR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1___rrR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rrR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1___rrR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__n2___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1__n2___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__n2___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__n2___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__n2___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1__n2___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__n2___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__n2___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__n2___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1__n2___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__n2___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__n2___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__nR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1__nR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__nR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__nR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__nR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1__nR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__nR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__nR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__nR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rr1__nR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__nR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rr1__nR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr0___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR___rr0___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr0___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr0___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr0___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR___rr0___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr0___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr0___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr0___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR___rr0___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr0___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr0___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr1___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR___rr1___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr1___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr1___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr1___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR___rr1___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr1___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr1___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr1___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR___rr1___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr1___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rr1___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rrR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR___rrR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rrR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rrR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rrR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR___rrR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rrR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rrR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rrR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR___rrR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rrR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR___rrR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__n2___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR__n2___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__n2___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__n2___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__n2___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR__n2___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__n2___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__n2___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__n2___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR__n2___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__n2___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__n2___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__nR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR__nR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__nR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__nR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__nR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR__nR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__nR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__nR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__nR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder___rrR__nR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__nR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder___rrR__nR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr0___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR___rr0___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr0___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr0___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr0___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR___rr0___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr0___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr0___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr0___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR___rr0___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr0___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr0___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr1___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR___rr1___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr1___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr1___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr1___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR___rr1___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr1___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr1___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr1___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR___rr1___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr1___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rr1___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rrR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR___rrR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rrR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rrR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rrR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR___rrR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rrR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rrR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rrR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR___rrR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rrR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR___rrR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__n2___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR__n2___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__n2___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__n2___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__n2___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR__n2___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__n2___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__n2___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__n2___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR__n2___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__n2___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__n2___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__nR___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR__nR___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__nR___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__nR___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__nR___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR__nR___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__nR___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__nR___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__nR___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder__nR__nR___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__nR___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder__nR__nR___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder_mstack__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(remainder_mstack__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder_mstack__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(remainder_mstack__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mb__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mb__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mb__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mb__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rr0___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rr0___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rr0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rr0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rr0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rr1___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rr1___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rr1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rr1__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rr1__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rr1__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rrR___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rrR___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe__n0___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe__n0___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe__nR___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe__nR___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbe__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbe__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__n_m1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__n_m1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__n_m1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__n_m1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__n2__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__n2__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__n2__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__n2__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbeqi_mstack__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbeqi_mstack__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbf_mstack__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbf_mstack__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbf_mstack__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbf_mstack__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rr0___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rr0___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rr0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rr0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rr0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rr1___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rr1___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rr1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rr1__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rr1__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rr1__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rrR___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rrR___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg__n0___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg__n0___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg__nR___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg__nR___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbg__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbg__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rr0___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rr0___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rr0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rr0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rr0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rr1___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rr1___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rr1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rr1__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rr1__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rr1__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rrR___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rrR___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__n0___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__n0___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__nR___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__nR___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbge__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbge__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rr0___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rr0___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rr0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rr0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rr0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rr1___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rr1___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rr1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rr1__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rr1__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rr1__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rrR___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rrR___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl__n0___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl__n0___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl__nR___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl__nR___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbl__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbl__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rr0___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rr0___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rr0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rr0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rr0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rr1___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rr1___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rr1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rr1__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rr1__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rr1__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rrR___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rrR___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__n0___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__n0___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__nR___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__nR___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mble__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mble__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rr0___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rr0___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rr0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rr0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rr0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rr1___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rr1___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rr1___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rr1__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rr1__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rr1__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rrR___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rrR___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rrR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne___rrR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne___rrR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__n0___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__n0___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__n0___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__n0__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__n0__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__n0__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR___rr0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__nR___rr0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR___rr0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR___rr0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR___rr1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__nR___rr1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR___rr1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR___rr1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__nR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbne__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbne__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__n_m1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__n_m1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__n_m1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__n_m1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__n2__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__n2__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__n2__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__n2__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbneqi_mstack__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbneqi_mstack__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbt_mstack__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbt_mstack__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbt_mstack__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbt_mstack__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexitvm__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mexitvm__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexitvm__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexitvm__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedure_mprolog__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprocedure_mprolog__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedure_mprolog__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedure_mprolog__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mreturn_mto_mundertop__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mreturn_mto_mundertop__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mreturn_mto_mundertop__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mreturn_mto_mundertop__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_munreachable__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_munreachable__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_munreachable__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_munreachable__retR)));
#endif // #ifdef JITTER_REPLICATE

  /* Initialization C code from the user */
  /* End of the initialization C code from the user */


# if defined(JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined(JITTER_DISPATCH_NO_THREADING)
  /* Execute architecture-specific execution-beginning code, if any.
     Make sure it is safe to expand the macro without do..while
     (false), since the expansion may contain declarations of
     variables to be used later. */
  {}; JITTER_EXECUTION_BEGINNING_; {};
  /* Declare a variable used in asm constraints on some architectures:
     see the comment in jitter-executor.h . */
  volatile long _jitter_useless_variable __attribute__ ((unused))
    = 0;
# endif

#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
    /* Start sample-profiling: this starts the periodic timer signal,
       whose handler will look at the current instruction field within
       the special-purpose struct in the Array. */
    structuredvm_profile_sample_start (STRUCTUREDVM_OWN_STATE);
#endif // #if defined (STRUCTUREDVM_PROFILE_SAMPLE)

  /* Jump to the first instruction.  If replication is enabled this point
     marks the boundary between the ordinary world of C compiled code and
     the more fragile replicated code, where PC-relative address does
     not work as intended (which prevents the use of global and static
     variables, string literals and possibly large literal constants), and
     GDB gets easily confused. */
  jitter_ip
    = jitter_original_state->structuredvm_state_backing.initial_program_point;

  /* This is the actual jump to the first instruction: it's not an
     inline asm constraint lie like below. */

# if   defined(JITTER_DISPATCH_SWITCH)
    goto jitter_dispatching_switch_label;
# elif (defined(JITTER_DISPATCH_DIRECT_THREADING)  \
        || defined(JITTER_DISPATCH_MINIMAL_THREADING))
    goto * (jitter_ip->label);
# elif defined(JITTER_DISPATCH_NO_THREADING)
    /* On no-threading we only use jitter_ip for the first instruction.
       Make it an alias for the base, which will be enough to satisfy
       inline assembly code which pretends to alter the instruction
       pointer in ways invisible to the compiler.
       At least in my tests this trick frees up one hardware register,
       which is not surprising. */
    goto * jitter_ip;
#   define jitter_ip structuredvm_array_base_register_variable
# else
#   error "unknown dispatch"
# endif // if ... dispatch
#ifdef JITTER_REPLICATE
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE();
  goto jitter_fake_target;
#endif // #ifdef JITTER_REPLICATE

#ifdef JITTER_DISPATCH_SWITCH
  /* This is the dispatching switch.  At the beginning of the first VM
     VM instruction and at the end of each other, control jumps here. */
 jitter_dispatching_switch_label:
  switch (jitter_ip->fixnum)
    {
#endif // #ifdef JITTER_DISPATCH_SWITCH

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!INVALID, _eINVALID, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  0
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !INVALID
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eINVALID
{

jitter_fatal ("reached the !INVALID instruction");
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!INVALID, _eINVALID, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!BEGINBASICBLOCK, _eBEGINBASICBLOCK, hot)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  1
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !BEGINBASICBLOCK
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eBEGINBASICBLOCK
{

#ifdef JITTER_DISPATCH_MINIMAL_THREADING
  JITTER_SET_IP (jitter_ip + 1);
#endif // #ifdef JITTER_DISPATCH_MINIMAL_THREADING

}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!BEGINBASICBLOCK, _eBEGINBASICBLOCK, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!EXITVM, _eEXITVM, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  2
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !EXITVM
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eEXITVM
{

_JITTER_EXIT();
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!EXITVM, _eEXITVM, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!DATALOCATIONS, _eDATALOCATIONS, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  3
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !DATALOCATIONS
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eDATALOCATIONS
{
#ifndef JITTER_DISPATCH_SWITCH
#ifndef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("instruction pointer", jitter_ip);
#endif // #ifndef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("base", jitter_array_base);
#ifdef JITTER_DISPATCH_NO_THREADING
#ifdef JITTER_SCRATCH_REGISTER
  JITTER_DATA_LOCATION_DATUM ("scratch", jitter_residual_argument_scratch_register_variable);
#endif // #ifdef JITTER_SCRATCH_REGISTER

#endif // #ifdef JITTER_DISPATCH_NO_THREADING
#ifdef JITTER_DISPATCH_NO_THREADING
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 0", jitter_residual_argument_0_register_variable);
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 1", jitter_residual_argument_1_register_variable);
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 2", jitter_residual_argument_2_register_variable);
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
#if (3 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 3", jitter_residual_argument_3_register_variable);
#endif // #if (3 < JITTER_RESIDUAL_REGISTER_NO)
#endif // #ifdef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("link register", jitter_state_runtime._jitter_link);
  JITTER_DATA_LOCATION_DATUM ("mainstack top", 
     JITTER_STACK_TOS_TOP_NAME (whatever, jitter_state_runtime., mainstack));
  JITTER_DATA_LOCATION_DATUM ("mainstack undertop ptr", 
     JITTER_STACK_TOS_UNDER_TOP_POINTER_NAME (whatever, jitter_state_runtime., mainstack));
JITTER_DATA_LOCATION_DATUM("%%r0", JITTER_REGISTER_r_0);
JITTER_DATA_LOCATION_DATUM("%%r1", JITTER_REGISTER_r_1);
#endif // #ifndef JITTER_DISPATCH_SWITCH
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!DATALOCATIONS, _eDATALOCATIONS, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!NOP, _eNOP, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  4
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !NOP
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eNOP
{

  /* Do nothing. */;
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!NOP, _eNOP, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!UNREACHABLE0, _eUNREACHABLE0, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  5
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !UNREACHABLE0
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eUNREACHABLE0
{

jitter_fatal ("reached the !UNREACHABLE0 instruction");
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!UNREACHABLE0, _eUNREACHABLE0, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!UNREACHABLE1, _eUNREACHABLE1, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  6
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !UNREACHABLE1
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eUNREACHABLE1
{

jitter_fatal ("reached the !UNREACHABLE1 instruction");
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!UNREACHABLE1, _eUNREACHABLE1, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!PRETENDTOJUMPANYWHERE, _ePRETENDTOJUMPANYWHERE, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  7
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !PRETENDTOJUMPANYWHERE
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _ePRETENDTOJUMPANYWHERE
jitter_fake_target: __attribute__ ((unused));{

#if ! defined(JITTER_DISPATCH_SWITCH)
  JITTER_PRETEND_TO_UPDATE_IP_;
  goto * jitter_ip;
#endif

}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!PRETENDTOJUMPANYWHERE, _ePRETENDTOJUMPANYWHERE, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  /* Ordinary specialized instructions. */
  /* Ordinary specialised instruction b/fR */
  JITTER_INSTRUCTION_PROLOG_(b/fR, b__fR, hot)
  { /* This block begins with definitions for b/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       8
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         b/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "b"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "b/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME b__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for b/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of b/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "b/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for b/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST(JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for b/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "b/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the b/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(b/fR, b__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for b/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%r0/%r0/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%r0/%r0/fR, be___rr0___rr0__fR, hot)
  { /* This block begins with definitions for be/%r0/%r0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       9
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r0/%r0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%r0/%r0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr0___rr0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r0/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%r0/%r0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%r0/%r0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%r0/%r0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%r0/%r0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%r0/%r0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%r0/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%r0/%r0/fR, be___rr0___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%r0/%r0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%r0/%r1/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%r0/%r1/fR, be___rr0___rr1__fR, hot)
  { /* This block begins with definitions for be/%r0/%r1/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       10
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r0/%r1/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%r0/%r1/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr0___rr1__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r0/%r1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%r0/%r1/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%r0/%r1/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%r0/%r1/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%r0/%r1/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%r0/%r1/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%r0/%r1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%r0/%r1/fR, be___rr0___rr1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%r0/%r1/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%r0/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%r0/%rR/fR, be___rr0___rrR__fR, cold)
  { /* This block begins with definitions for be/%r0/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       11
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r0/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%r0/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr0___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r0/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%r0/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%r0/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%r0/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%r0/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%r0/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%r0/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%r0/%rR/fR, be___rr0___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%r0/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%r0/n0/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%r0/n0/fR, be___rr0__n0__fR, hot)
  { /* This block begins with definitions for be/%r0/n0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       12
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r0/n0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%r0/n0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr0__n0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r0/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%r0/n0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%r0/n0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%r0/n0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%r0/n0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%r0/n0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%r0/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%r0/n0/fR, be___rr0__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%r0/n0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%r0/nR/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%r0/nR/fR, be___rr0__nR__fR, cold)
  { /* This block begins with definitions for be/%r0/nR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       13
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r0/nR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%r0/nR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr0__nR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r0/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%r0/nR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%r0/nR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%r0/nR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%r0/nR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%r0/nR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%r0/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%r0/nR/fR, be___rr0__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%r0/nR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%r1/%r0/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%r1/%r0/fR, be___rr1___rr0__fR, hot)
  { /* This block begins with definitions for be/%r1/%r0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       14
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r1/%r0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%r1/%r0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr1___rr0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r1/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%r1/%r0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%r1/%r0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%r1/%r0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%r1/%r0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%r1/%r0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%r1/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%r1/%r0/fR, be___rr1___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%r1/%r0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%r1/%r1/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%r1/%r1/fR, be___rr1___rr1__fR, hot)
  { /* This block begins with definitions for be/%r1/%r1/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       15
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r1/%r1/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%r1/%r1/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr1___rr1__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r1/%r1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%r1/%r1/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%r1/%r1/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%r1/%r1/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%r1/%r1/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%r1/%r1/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%r1/%r1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%r1/%r1/fR, be___rr1___rr1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%r1/%r1/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%r1/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%r1/%rR/fR, be___rr1___rrR__fR, cold)
  { /* This block begins with definitions for be/%r1/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       16
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r1/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%r1/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr1___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r1/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%r1/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%r1/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%r1/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%r1/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%r1/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%r1/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%r1/%rR/fR, be___rr1___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%r1/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%r1/n0/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%r1/n0/fR, be___rr1__n0__fR, hot)
  { /* This block begins with definitions for be/%r1/n0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       17
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r1/n0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%r1/n0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr1__n0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r1/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%r1/n0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%r1/n0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%r1/n0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%r1/n0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%r1/n0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%r1/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%r1/n0/fR, be___rr1__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%r1/n0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%r1/nR/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%r1/nR/fR, be___rr1__nR__fR, cold)
  { /* This block begins with definitions for be/%r1/nR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       18
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r1/nR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%r1/nR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr1__nR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r1/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%r1/nR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%r1/nR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%r1/nR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%r1/nR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%r1/nR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%r1/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%r1/nR/fR, be___rr1__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%r1/nR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%rR/%r0/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%rR/%r0/fR, be___rrR___rr0__fR, cold)
  { /* This block begins with definitions for be/%rR/%r0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       19
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%rR/%r0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%rR/%r0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rrR___rr0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%rR/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%rR/%r0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%rR/%r0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%rR/%r0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%rR/%r0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%rR/%r0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%rR/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%rR/%r0/fR, be___rrR___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%rR/%r0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%rR/%r1/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%rR/%r1/fR, be___rrR___rr1__fR, cold)
  { /* This block begins with definitions for be/%rR/%r1/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       20
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%rR/%r1/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%rR/%r1/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rrR___rr1__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%rR/%r1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%rR/%r1/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%rR/%r1/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%rR/%r1/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%rR/%r1/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%rR/%r1/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%rR/%r1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%rR/%r1/fR, be___rrR___rr1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%rR/%r1/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%rR/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%rR/%rR/fR, be___rrR___rrR__fR, cold)
  { /* This block begins with definitions for be/%rR/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       21
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%rR/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%rR/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rrR___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%rR/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%rR/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%rR/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%rR/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%rR/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%rR/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%rR/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%rR/%rR/fR, be___rrR___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%rR/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%rR/n0/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%rR/n0/fR, be___rrR__n0__fR, cold)
  { /* This block begins with definitions for be/%rR/n0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       22
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%rR/n0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%rR/n0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rrR__n0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%rR/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%rR/n0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%rR/n0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%rR/n0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%rR/n0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%rR/n0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%rR/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%rR/n0/fR, be___rrR__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%rR/n0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/%rR/nR/fR */
  JITTER_INSTRUCTION_PROLOG_(be/%rR/nR/fR, be___rrR__nR__fR, cold)
  { /* This block begins with definitions for be/%rR/nR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       23
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%rR/nR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/%rR/nR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rrR__nR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%rR/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/%rR/nR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/%rR/nR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/%rR/nR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/%rR/nR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/%rR/nR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/%rR/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/%rR/nR/fR, be___rrR__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/%rR/nR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/n0/%r0/fR */
  JITTER_INSTRUCTION_PROLOG_(be/n0/%r0/fR, be__n0___rr0__fR, hot)
  { /* This block begins with definitions for be/n0/%r0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       24
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/n0/%r0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/n0/%r0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__n0___rr0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/n0/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/n0/%r0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/n0/%r0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/n0/%r0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/n0/%r0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/n0/%r0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/n0/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/n0/%r0/fR, be__n0___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/n0/%r0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/n0/%r1/fR */
  JITTER_INSTRUCTION_PROLOG_(be/n0/%r1/fR, be__n0___rr1__fR, hot)
  { /* This block begins with definitions for be/n0/%r1/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       25
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/n0/%r1/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/n0/%r1/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__n0___rr1__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/n0/%r1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/n0/%r1/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/n0/%r1/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/n0/%r1/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/n0/%r1/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/n0/%r1/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/n0/%r1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/n0/%r1/fR, be__n0___rr1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/n0/%r1/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/n0/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(be/n0/%rR/fR, be__n0___rrR__fR, cold)
  { /* This block begins with definitions for be/n0/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       26
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/n0/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/n0/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__n0___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/n0/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/n0/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/n0/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/n0/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/n0/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/n0/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/n0/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/n0/%rR/fR, be__n0___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/n0/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/n0/n0/fR */
  JITTER_INSTRUCTION_PROLOG_(be/n0/n0/fR, be__n0__n0__fR, hot)
  { /* This block begins with definitions for be/n0/n0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       27
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/n0/n0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/n0/n0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__n0__n0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/n0/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/n0/n0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/n0/n0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/n0/n0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/n0/n0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/n0/n0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/n0/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/n0/n0/fR, be__n0__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/n0/n0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/n0/nR/fR */
  JITTER_INSTRUCTION_PROLOG_(be/n0/nR/fR, be__n0__nR__fR, cold)
  { /* This block begins with definitions for be/n0/nR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       28
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/n0/nR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/n0/nR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__n0__nR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/n0/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/n0/nR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/n0/nR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/n0/nR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/n0/nR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/n0/nR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/n0/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/n0/nR/fR, be__n0__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/n0/nR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/nR/%r0/fR */
  JITTER_INSTRUCTION_PROLOG_(be/nR/%r0/fR, be__nR___rr0__fR, cold)
  { /* This block begins with definitions for be/nR/%r0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       29
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/nR/%r0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/nR/%r0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__nR___rr0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/nR/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/nR/%r0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/nR/%r0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/nR/%r0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/nR/%r0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/nR/%r0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/nR/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/nR/%r0/fR, be__nR___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/nR/%r0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/nR/%r1/fR */
  JITTER_INSTRUCTION_PROLOG_(be/nR/%r1/fR, be__nR___rr1__fR, cold)
  { /* This block begins with definitions for be/nR/%r1/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       30
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/nR/%r1/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/nR/%r1/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__nR___rr1__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/nR/%r1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/nR/%r1/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/nR/%r1/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/nR/%r1/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/nR/%r1/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/nR/%r1/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/nR/%r1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/nR/%r1/fR, be__nR___rr1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/nR/%r1/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/nR/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(be/nR/%rR/fR, be__nR___rrR__fR, cold)
  { /* This block begins with definitions for be/nR/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       31
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/nR/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/nR/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__nR___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/nR/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/nR/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/nR/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/nR/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/nR/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/nR/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/nR/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/nR/%rR/fR, be__nR___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/nR/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/nR/n0/fR */
  JITTER_INSTRUCTION_PROLOG_(be/nR/n0/fR, be__nR__n0__fR, cold)
  { /* This block begins with definitions for be/nR/n0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       32
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/nR/n0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/nR/n0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__nR__n0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/nR/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/nR/n0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/nR/n0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/nR/n0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/nR/n0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/nR/n0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/nR/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/nR/n0/fR, be__nR__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/nR/n0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction be/nR/nR/fR */
  JITTER_INSTRUCTION_PROLOG_(be/nR/nR/fR, be__nR__nR__fR, cold)
  { /* This block begins with definitions for be/nR/nR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       33
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/nR/nR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "be"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "be/nR/nR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__nR__nR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/nR/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of be/nR/nR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "be/nR/nR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for be/nR/nR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for be/nR/nR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "be/nR/nR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the be/nR/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(be/nR/nR/fR, be__nR__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for be/nR/nR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction beqi-stack/n-1/fR */
  JITTER_INSTRUCTION_PROLOG_(beqi-stack/n-1/fR, beqi_mstack__n_m1__fR, hot)
  { /* This block begins with definitions for beqi-stack/n-1/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       34
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beqi-stack/n-1/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "beqi-stack"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "beqi-stack/n-1/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beqi_mstack__n_m1__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beqi-stack/n-1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of beqi-stack/n-1/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "beqi-stack/n-1/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for beqi-stack/n-1/fR . */
  {
/* User-specified code, user code block part: beginning. */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTER_ARGN0, JITTER_ARGF1);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for beqi-stack/n-1/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "beqi-stack/n-1/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the beqi-stack/n-1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(beqi-stack/n-1/fR, beqi_mstack__n_m1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for beqi-stack/n-1/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction beqi-stack/n0/fR */
  JITTER_INSTRUCTION_PROLOG_(beqi-stack/n0/fR, beqi_mstack__n0__fR, hot)
  { /* This block begins with definitions for beqi-stack/n0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       35
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beqi-stack/n0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "beqi-stack"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "beqi-stack/n0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beqi_mstack__n0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beqi-stack/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of beqi-stack/n0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "beqi-stack/n0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for beqi-stack/n0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTER_ARGN0, JITTER_ARGF1);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for beqi-stack/n0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "beqi-stack/n0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the beqi-stack/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(beqi-stack/n0/fR, beqi_mstack__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for beqi-stack/n0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction beqi-stack/n1/fR */
  JITTER_INSTRUCTION_PROLOG_(beqi-stack/n1/fR, beqi_mstack__n1__fR, hot)
  { /* This block begins with definitions for beqi-stack/n1/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       36
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beqi-stack/n1/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "beqi-stack"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "beqi-stack/n1/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beqi_mstack__n1__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beqi-stack/n1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of beqi-stack/n1/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "beqi-stack/n1/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for beqi-stack/n1/fR . */
  {
/* User-specified code, user code block part: beginning. */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTER_ARGN0, JITTER_ARGF1);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for beqi-stack/n1/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "beqi-stack/n1/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the beqi-stack/n1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(beqi-stack/n1/fR, beqi_mstack__n1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for beqi-stack/n1/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction beqi-stack/n2/fR */
  JITTER_INSTRUCTION_PROLOG_(beqi-stack/n2/fR, beqi_mstack__n2__fR, hot)
  { /* This block begins with definitions for beqi-stack/n2/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       37
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beqi-stack/n2/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "beqi-stack"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "beqi-stack/n2/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beqi_mstack__n2__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beqi-stack/n2/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 2L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 2L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of beqi-stack/n2/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "beqi-stack/n2/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for beqi-stack/n2/fR . */
  {
/* User-specified code, user code block part: beginning. */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTER_ARGN0, JITTER_ARGF1);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for beqi-stack/n2/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "beqi-stack/n2/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the beqi-stack/n2/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(beqi-stack/n2/fR, beqi_mstack__n2__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for beqi-stack/n2/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction beqi-stack/nR/fR */
  JITTER_INSTRUCTION_PROLOG_(beqi-stack/nR/fR, beqi_mstack__nR__fR, cold)
  { /* This block begins with definitions for beqi-stack/nR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       38
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beqi-stack/nR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "beqi-stack"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "beqi-stack/nR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beqi_mstack__nR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beqi-stack/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of beqi-stack/nR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "beqi-stack/nR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for beqi-stack/nR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTER_ARGN0, JITTER_ARGF1);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for beqi-stack/nR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "beqi-stack/nR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the beqi-stack/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(beqi-stack/nR/fR, beqi_mstack__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for beqi-stack/nR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bf-stack/fR */
  JITTER_INSTRUCTION_PROLOG_(bf-stack/fR, bf_mstack__fR, hot)
  { /* This block begins with definitions for bf-stack/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       39
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bf-stack/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bf-stack"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bf-stack/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bf_mstack__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bf-stack/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bf-stack/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bf-stack/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bf-stack/fR . */
  {
/* User-specified code, user code block part: beginning. */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_ZERO(top, JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bf-stack/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bf-stack/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bf-stack/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bf-stack/fR, bf_mstack__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bf-stack/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bg/%r0/%r0/fR */
  JITTER_INSTRUCTION_PROLOG_(bg/%r0/%r0/fR, bg___rr0___rr0__fR, hot)
  { /* This block begins with definitions for bg/%r0/%r0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       40
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r0/%r0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bg"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bg/%r0/%r0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr0___rr0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r0/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bg/%r0/%r0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bg/%r0/%r0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bg/%r0/%r0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bg/%r0/%r0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bg/%r0/%r0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bg/%r0/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bg/%r0/%r0/fR, bg___rr0___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bg/%r0/%r0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bg/%r0/%r1/fR */
  JITTER_INSTRUCTION_PROLOG_(bg/%r0/%r1/fR, bg___rr0___rr1__fR, hot)
  { /* This block begins with definitions for bg/%r0/%r1/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       41
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r0/%r1/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bg"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bg/%r0/%r1/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr0___rr1__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r0/%r1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bg/%r0/%r1/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bg/%r0/%r1/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bg/%r0/%r1/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bg/%r0/%r1/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bg/%r0/%r1/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bg/%r0/%r1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bg/%r0/%r1/fR, bg___rr0___rr1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bg/%r0/%r1/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bg/%r0/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(bg/%r0/%rR/fR, bg___rr0___rrR__fR, cold)
  { /* This block begins with definitions for bg/%r0/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       42
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r0/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bg"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bg/%r0/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr0___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r0/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bg/%r0/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bg/%r0/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bg/%r0/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bg/%r0/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bg/%r0/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bg/%r0/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bg/%r0/%rR/fR, bg___rr0___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bg/%r0/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bg/%r0/n0/fR */
  JITTER_INSTRUCTION_PROLOG_(bg/%r0/n0/fR, bg___rr0__n0__fR, hot)
  { /* This block begins with definitions for bg/%r0/n0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       43
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r0/n0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bg"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bg/%r0/n0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr0__n0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r0/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bg/%r0/n0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bg/%r0/n0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bg/%r0/n0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bg/%r0/n0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bg/%r0/n0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bg/%r0/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bg/%r0/n0/fR, bg___rr0__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bg/%r0/n0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bg/%r0/nR/fR */
  JITTER_INSTRUCTION_PROLOG_(bg/%r0/nR/fR, bg___rr0__nR__fR, cold)
  { /* This block begins with definitions for bg/%r0/nR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       44
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r0/nR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bg"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bg/%r0/nR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr0__nR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r0/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bg/%r0/nR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bg/%r0/nR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bg/%r0/nR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bg/%r0/nR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bg/%r0/nR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bg/%r0/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bg/%r0/nR/fR, bg___rr0__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bg/%r0/nR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bg/%r1/%r0/fR */
  JITTER_INSTRUCTION_PROLOG_(bg/%r1/%r0/fR, bg___rr1___rr0__fR, hot)
  { /* This block begins with definitions for bg/%r1/%r0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       45
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r1/%r0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bg"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bg/%r1/%r0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr1___rr0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r1/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bg/%r1/%r0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bg/%r1/%r0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bg/%r1/%r0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bg/%r1/%r0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bg/%r1/%r0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bg/%r1/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bg/%r1/%r0/fR, bg___rr1___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bg/%r1/%r0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bg/%r1/%r1/fR */
  JITTER_INSTRUCTION_PROLOG_(bg/%r1/%r1/fR, bg___rr1___rr1__fR, hot)
  { /* This block begins with definitions for bg/%r1/%r1/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       46
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r1/%r1/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bg"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bg/%r1/%r1/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr1___rr1__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r1/%r1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bg/%r1/%r1/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bg/%r1/%r1/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bg/%r1/%r1/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bg/%r1/%r1/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bg/%r1/%r1/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bg/%r1/%r1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bg/%r1/%r1/fR, bg___rr1___rr1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bg/%r1/%r1/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bg/%r1/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(bg/%r1/%rR/fR, bg___rr1___rrR__fR, cold)
  { /* This block begins with definitions for bg/%r1/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       47
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r1/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bg"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bg/%r1/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr1___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r1/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bg/%r1/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bg/%r1/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bg/%r1/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bg/%r1/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bg/%r1/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bg/%r1/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bg/%r1/%rR/fR, bg___rr1___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bg/%r1/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bg/%r1/n0/fR */
  JITTER_INSTRUCTION_PROLOG_(bg/%r1/n0/fR, bg___rr1__n0__fR, hot)
  { /* This block begins with definitions for bg/%r1/n0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       48
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r1/n0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bg"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bg/%r1/n0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr1__n0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r1/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bg/%r1/n0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bg/%r1/n0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bg/%r1/n0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bg/%r1/n0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bg/%r1/n0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bg/%r1/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bg/%r1/n0/fR, bg___rr1__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bg/%r1/n0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bg/%r1/nR/fR */
  JITTER_INSTRUCTION_PROLOG_(bg/%r1/nR/fR, bg___rr1__nR__fR, cold)
  { /* This block begins with definitions for bg/%r1/nR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       49
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r1/nR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bg"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bg/%r1/nR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr1__nR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r1/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bg/%r1/nR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bg/%r1/nR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bg/%r1/nR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bg/%r1/nR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bg/%r1/nR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bg/%r1/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bg/%r1/nR/fR, bg___rr1__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bg/%r1/nR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bg/%rR/%r0/fR */
  JITTER_INSTRUCTION_PROLOG_(bg/%rR/%r0/fR, bg___rrR___rr0__fR, cold)
  { /* This block begins with definitions for bg/%rR/%r0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       50
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%rR/%r0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bg"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bg/%rR/%r0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rrR___rr0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%rR/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bg/%rR/%r0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (STRUCTUREDVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bg/%rR/%r0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bg/%rR/%r0/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bg/%rR/%r0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bg/%rR/%r0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bg/%rR/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bg/%rR/%r0/fR, bg___rrR___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bg/%rR/%r0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bg/%rR/%r1/fR */
  JITTER_INSTRUCTION_PROLOG_(bg/%rR/%r1/fR, bg___rrR___rr1__fR, cold)
  { /* This block begins with definitions for bg/%rR/%r1/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       51
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%rR/%r1/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bg"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bg/%rR/%r1/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rrR___rr1__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIG