/* This machine-generated file includes source code from GNU Jitter.

   Copyright (C) 2016-2025 Luca Saiu
   Written by Luca Saiu

   GNU Jitter is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published
   by the Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   GNU Jitter is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Jitter.  If not, see <https://www.gnu.org/licenses/>.

This generated code also is also derived from a user VM specification.

*/

/* User-specified code, initial vm2 part: beginning. */
#line 222 "./pvm.jitter"
#line 222 "./pvm.jitter"

#   include <config.h>
  
/* User-specified code, initial vm2 part: end */

/* These two macros are convenient for making VM-specific identifiers
   using VM-independent macros from a public header, without polluting
   the global namespace. */
#define JITTER_VM_PREFIX_LOWER_CASE pvm
#define JITTER_VM_PREFIX_UPPER_CASE PVM

#include <jitter/jitter-early-header.h>

//#include <config.h>

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

/* Early C code from the user. */
#line 228 "./pvm.jitter"
#line 228 "./pvm.jitter"

#   include <config.h>
#   include <stdlib.h>
#   include <assert.h>
#   include <errno.h>
#   include "intprops.h"

#   include "pvm-alloc.h"
#   include "pvm-wrappers.h"
  /* End of the early C code from the user. */

#include <jitter/jitter.h>
#include <jitter/jitter-instruction.h>

#define JITTER_THIS_CAN_INCLUDE_JITTER_EXECUTOR_H
#include <jitter/jitter-executor.h>

#ifdef JITTER_ENABLE_ASSEMBLY
#include <jitter/jitter-machine-common.h>
#include <jitter/machine/jitter-machine.h>
#endif // #ifdef JITTER_ENABLE_ASSEMBLY
#include <jitter/jitter-fatal.h>
#include <jitter/jitter-malloc.h>

#include "pvm-vm.h"
//#include "pvm-meta-instructions.h"
//#include "pvm-specialized-instructions.h"
//#include "pvm-state.h"

/* Include stack data structure support. */
#include <jitter/jitter-stack.h>

/* Include patch-in definitions, only if patch-in is enabled.  We know whether it is
   by checking JITTER_HAVE_PATCH_IN , defined in jitter/jitter-patch-in.h .
   The same for defects. */
#include <jitter/jitter-patch-in.h>
#include <jitter/jitter-fast-branch.h>
#include <jitter/jitter-defect.h>
#ifdef JITTER_HAVE_PATCH_IN
  JITTER_PATCH_IN_DESCRIPTOR_DECLARATIONS_(pvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_HAVE_DEFECT_REPLACEMENT
  static void jitter_useless_function (void) asm ("jitter_fake_target_asm");
  static void jitter_useless_function (void) {}
  JITTER_DEFECT_DESCRIPTOR_DECLARATIONS_(pvm);
  static const char * const pvm_fake_target_asm
    = (const char *) & jitter_useless_function;
#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT

/* Always include the non-user fast-branch definitions, which use patch-ins where possible
   or consist in fallback definitions otherwise. */
#include <jitter/jitter-fast-branch.h>

#define JITTER_FAST_BRANCH_PREFIX pvm_

/* Most of the needed macros are in jitter-executor.h .  This however
   needs to be here, as it relies on a prefix to be substituted. */
#define _JITTER_STATE_BACKING  \
  (jitter_original_state->pvm_state_backing)
/* Expand to an l-value evaluating to the pending_notification field for
   the current state. */
#define JITTER_PENDING_NOTIFICATIONS  \
  (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA->pending_notifications)
/* Expand to an l-value evaluating to the pending field of the struct
   jitter_signal_notification element for the given signal, for the
   current state. */
#define JITTER_PENDING_SIGNAL_NOTIFICATION(signal_id)  \
  ((PVM_OWN_SPECIAL_PURPOSE_STATE_DATA->pending_signal_notifications + (signal_id))->pending)

/* Expand to the i-th fast register as an lvalue.  This is used internally,
   always with a literal index . */
#define JITTER_FAST_REGISTER(class, index)                             \
  (JITTER_CONCATENATE_FOUR(jitter_state_runtime.jitter_fast_register_, \
                           class, _, index))

/* Expand to a slow register lvalue, given an offset in bytes from the base. */
#define JITTER_SLOW_REGISTER_FROM_OFFSET(c, offset)               \
  (* ((JITTER_CONCATENATE_TWO(pvm_register_, c) * restrict)  \
      (((char *) jitter_array_base) + offset)))

/* Expand to the i-th register, which must be a slow register, as an lvalue.
   The given index must be a register index counting from 0 and including fast
   regusters as well, if there are any.  For example if an r class had 3 fast
   registers then the first slow register would be %r3, to be accessed as
   JITTER_SLOW_REGISTER(r, 3).  It would be invalid to access %r0, %r1 and
   %r2 which this macro, as %r0, %r1 and %r2 would be fast. */
#define JITTER_SLOW_REGISTER(c, i)                                          \
  JITTER_SLOW_REGISTER_FROM_OFFSET(c, PVM_SLOW_REGISTER_OFFSET(c, i))

/* It's not possible to have a single macro JITTER_REGISTER taking an index and
   expanding to either a fast or a slow register lvalue, due to CPP conditional
   limitations.  This restriction is unfortunate, but we have to live with it
   as long as we don't switch to a different preprocessor.
   What we can have is a set of zero-argument macros each expanding to a register
   lvalue, for *a limited number* of registers.  Here we define access macros for
   every fast register plus a reasonable number (currently 32) of slow registers,
   per class. */
#define JITTER_REGISTER_r_0    JITTER_SLOW_REGISTER(r, 0)
#define JITTER_REGISTER_r_1    JITTER_SLOW_REGISTER(r, 1)
#define JITTER_REGISTER_r_2    JITTER_SLOW_REGISTER(r, 2)
#define JITTER_REGISTER_r_3    JITTER_SLOW_REGISTER(r, 3)
#define JITTER_REGISTER_r_4    JITTER_SLOW_REGISTER(r, 4)
#define JITTER_REGISTER_r_5    JITTER_SLOW_REGISTER(r, 5)
#define JITTER_REGISTER_r_6    JITTER_SLOW_REGISTER(r, 6)
#define JITTER_REGISTER_r_7    JITTER_SLOW_REGISTER(r, 7)
#define JITTER_REGISTER_r_8    JITTER_SLOW_REGISTER(r, 8)
#define JITTER_REGISTER_r_9    JITTER_SLOW_REGISTER(r, 9)
#define JITTER_REGISTER_r_10   JITTER_SLOW_REGISTER(r, 10)
#define JITTER_REGISTER_r_11   JITTER_SLOW_REGISTER(r, 11)
#define JITTER_REGISTER_r_12   JITTER_SLOW_REGISTER(r, 12)
#define JITTER_REGISTER_r_13   JITTER_SLOW_REGISTER(r, 13)
#define JITTER_REGISTER_r_14   JITTER_SLOW_REGISTER(r, 14)
#define JITTER_REGISTER_r_15   JITTER_SLOW_REGISTER(r, 15)
#define JITTER_REGISTER_r_16   JITTER_SLOW_REGISTER(r, 16)
#define JITTER_REGISTER_r_17   JITTER_SLOW_REGISTER(r, 17)
#define JITTER_REGISTER_r_18   JITTER_SLOW_REGISTER(r, 18)
#define JITTER_REGISTER_r_19   JITTER_SLOW_REGISTER(r, 19)
#define JITTER_REGISTER_r_20   JITTER_SLOW_REGISTER(r, 20)
#define JITTER_REGISTER_r_21   JITTER_SLOW_REGISTER(r, 21)
#define JITTER_REGISTER_r_22   JITTER_SLOW_REGISTER(r, 22)
#define JITTER_REGISTER_r_23   JITTER_SLOW_REGISTER(r, 23)
#define JITTER_REGISTER_r_24   JITTER_SLOW_REGISTER(r, 24)
#define JITTER_REGISTER_r_25   JITTER_SLOW_REGISTER(r, 25)
#define JITTER_REGISTER_r_26   JITTER_SLOW_REGISTER(r, 26)
#define JITTER_REGISTER_r_27   JITTER_SLOW_REGISTER(r, 27)
#define JITTER_REGISTER_r_28   JITTER_SLOW_REGISTER(r, 28)
#define JITTER_REGISTER_r_29   JITTER_SLOW_REGISTER(r, 29)
#define JITTER_REGISTER_r_30   JITTER_SLOW_REGISTER(r, 30)
#define JITTER_REGISTER_r_31   JITTER_SLOW_REGISTER(r, 31)


#ifdef JITTER_DISPATCH_NO_THREADING

/* Reserve the scratch register, if any. */
#ifdef JITTER_SCRATCH_REGISTER
  register union jitter_word
  jitter_residual_argument_scratch_register_variable asm (JITTER_STRINGIFY(JITTER_SCRATCH_REGISTER));
#endif // #ifdef JITTER_SCRATCH_REGISTER

/* Reserve The Array base register. */
#ifndef JITTER_BASE_REGISTER
# error "the machine does not define JITTER_BASE_REGISTER"
#else
register char * restrict
pvm_array_base_register_variable asm (JITTER_STRINGIFY(JITTER_BASE_REGISTER));
#endif // #ifndef JITTER_BASE_REGISTER

/* Reserve registers for our 3 residual arguments.  If this particular VM doesn't
   need all of those supported by the assembly machine then reserve only the first
   ones.  If, on the other hand, we need more residual arguments than we have
   available registers, use CPP macros to map the remaining residual arguments
   to memory locations relative to the base, with constant offsets. */

/* Define a macro for the 0-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_0_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_0));
# define JITTER_RESIDUAL_ARGUMENT_0               \
    jitter_residual_argument_0_register_variable
# define JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_0_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_0  \
    (* (union jitter_word *)                 \
       (jitter_array_base + PVM_RESIDUAL_OFFSET(0)))
# define JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_0)
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 1-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_1_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_1));
# define JITTER_RESIDUAL_ARGUMENT_1               \
    jitter_residual_argument_1_register_variable
# define JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_1_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_1  \
    (* (union jitter_word *)                 \
       (jitter_array_base + PVM_RESIDUAL_OFFSET(1)))
# define JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_1)
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 2-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_2_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_2));
# define JITTER_RESIDUAL_ARGUMENT_2               \
    jitter_residual_argument_2_register_variable
# define JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_2_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_2  \
    (* (union jitter_word *)                 \
       (jitter_array_base + PVM_RESIDUAL_OFFSET(2)))
# define JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_2)
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)

/* The global register values we reserve in this compilation unit are
   callee-save: the called function is supposed to save them before
   setting them, and restore them to their previous value before
   returning to the caller.  Of course this is not done automatically
   in this compilation unit, so we have to do it by hand.  Notice that
   every variable allocated to a register by GCC will not use the
   registers we reserved, so we can be sure that, if we save our
   global register variables before setting them for the first time,
   their values will be the ones we want to retain. */

/* The buffer where I keep the original register values needs to hold
   every residual register, plus possibly the scratch register and the
   residual base; those two registers are not always used, but allocating
   just two words more costs essentially nothing and lets me simplify
   the code a little.  The two words are not written or read unless
   needed. */
#define PVM_REGISTER_BUFFER_ELEMENT_NO (JITTER_RESIDUAL_REGISTER_NO + 2)
__attribute__ ((noinline, cold))

static void
pvm_save_registers (union jitter_word *buffer)
{
  buffer [0].pointer = (union jitter_word*) pvm_array_base_register_variable;
#ifdef JITTER_SCRATCH_REGISTER
  buffer [1] = jitter_residual_argument_scratch_register_variable;
#endif // #ifdef JITTER_SCRATCH_REGISTER
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [0 + 2] = JITTER_RESIDUAL_ARGUMENT_0;
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [1 + 2] = JITTER_RESIDUAL_ARGUMENT_1;
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [2 + 2] = JITTER_RESIDUAL_ARGUMENT_2;
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
}

__attribute__ ((noinline, cold))
static void
pvm_restore_registers (const union jitter_word *buffer)
{
  pvm_array_base_register_variable = (char *) buffer [0].pointer;
#ifdef JITTER_SCRATCH_REGISTER
  jitter_residual_argument_scratch_register_variable = buffer [1];
#endif // #ifdef JITTER_SCRATCH_REGISTER
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_0 = buffer [0 + 2];
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_1 = buffer [1 + 2];
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_2 = buffer [2 + 2];
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
}

#endif // #ifdef JITTER_DISPATCH_NO_THREADING


/* The following stack operations (without the initial state
   argument) can be used inside instruction code blocks.
   Notice that macros with the same "PVM_" names are
   defined in the generated header to be used out of VM code,
   but those alternative definitions have an additional first
   argument, a VM state pointer. */

/* Wrapper definition of the top operation for the
   TOS-optimized stack "stack". */
#undef JITTER_TOP_STACK
#undef PVM_TOP_STACK
#define PVM_TOP_STACK /* The preferred name. */ \
  JITTER_TOP_STACK
#define JITTER_TOP_STACK()  \
  JITTER_STACK_TOS_TOP (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the under_top operation for the
   TOS-optimized stack "stack". */
#undef JITTER_UNDER_TOP_STACK
#undef PVM_UNDER_TOP_STACK
#define PVM_UNDER_TOP_STACK /* The preferred name. */ \
  JITTER_UNDER_TOP_STACK
#define JITTER_UNDER_TOP_STACK()  \
  JITTER_STACK_TOS_UNDER_TOP (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the at_depth operation for the
   TOS-optimized stack "stack". */
#undef JITTER_AT_DEPTH_STACK
#undef PVM_AT_DEPTH_STACK
#define PVM_AT_DEPTH_STACK /* The preferred name. */ \
  JITTER_AT_DEPTH_STACK
#define JITTER_AT_DEPTH_STACK(x0)  \
  JITTER_STACK_TOS_AT_DEPTH (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0)
/* Wrapper definition of the at_nonzero_depth operation for the
   TOS-optimized stack "stack". */
#undef JITTER_AT_NONZERO_DEPTH_STACK
#undef PVM_AT_NONZERO_DEPTH_STACK
#define PVM_AT_NONZERO_DEPTH_STACK /* The preferred name. */ \
  JITTER_AT_NONZERO_DEPTH_STACK
#define JITTER_AT_NONZERO_DEPTH_STACK(x0)  \
  JITTER_STACK_TOS_AT_NONZERO_DEPTH (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0)
/* Wrapper definition of the set_at_depth operation for the
   TOS-optimized stack "stack". */
#undef JITTER_SET_AT_DEPTH_STACK
#undef PVM_SET_AT_DEPTH_STACK
#define PVM_SET_AT_DEPTH_STACK /* The preferred name. */ \
  JITTER_SET_AT_DEPTH_STACK
#define JITTER_SET_AT_DEPTH_STACK(x0, x1)  \
  JITTER_STACK_TOS_SET_AT_DEPTH (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0, x1)
/* Wrapper definition of the set_at_nonzero_depth operation for the
   TOS-optimized stack "stack". */
#undef JITTER_SET_AT_NONZERO_DEPTH_STACK
#undef PVM_SET_AT_NONZERO_DEPTH_STACK
#define PVM_SET_AT_NONZERO_DEPTH_STACK /* The preferred name. */ \
  JITTER_SET_AT_NONZERO_DEPTH_STACK
#define JITTER_SET_AT_NONZERO_DEPTH_STACK(x0, x1)  \
  JITTER_STACK_TOS_SET_AT_NONZERO_DEPTH (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0, x1)
/* Wrapper definition of the push_unspecified operation for the
   TOS-optimized stack "stack". */
#undef JITTER_PUSH_UNSPECIFIED_STACK
#undef PVM_PUSH_UNSPECIFIED_STACK
#define PVM_PUSH_UNSPECIFIED_STACK /* The preferred name. */ \
  JITTER_PUSH_UNSPECIFIED_STACK
#define JITTER_PUSH_UNSPECIFIED_STACK()  \
  JITTER_STACK_TOS_PUSH_UNSPECIFIED (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the push operation for the
   TOS-optimized stack "stack". */
#undef JITTER_PUSH_STACK
#undef PVM_PUSH_STACK
#define PVM_PUSH_STACK /* The preferred name. */ \
  JITTER_PUSH_STACK
#define JITTER_PUSH_STACK(x0)  \
  JITTER_STACK_TOS_PUSH (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0)
/* Wrapper definition of the under_push_unspecified operation for the
   TOS-optimized stack "stack". */
#undef JITTER_UNDER_PUSH_UNSPECIFIED_STACK
#undef PVM_UNDER_PUSH_UNSPECIFIED_STACK
#define PVM_UNDER_PUSH_UNSPECIFIED_STACK /* The preferred name. */ \
  JITTER_UNDER_PUSH_UNSPECIFIED_STACK
#define JITTER_UNDER_PUSH_UNSPECIFIED_STACK()  \
  JITTER_STACK_TOS_UNDER_PUSH_UNSPECIFIED (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the under_push operation for the
   TOS-optimized stack "stack". */
#undef JITTER_UNDER_PUSH_STACK
#undef PVM_UNDER_PUSH_STACK
#define PVM_UNDER_PUSH_STACK /* The preferred name. */ \
  JITTER_UNDER_PUSH_STACK
#define JITTER_UNDER_PUSH_STACK(x0)  \
  JITTER_STACK_TOS_UNDER_PUSH (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0)
/* Wrapper definition of the drop operation for the
   TOS-optimized stack "stack". */
#undef JITTER_DROP_STACK
#undef PVM_DROP_STACK
#define PVM_DROP_STACK /* The preferred name. */ \
  JITTER_DROP_STACK
#define JITTER_DROP_STACK()  \
  JITTER_STACK_TOS_DROP (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the dup operation for the
   TOS-optimized stack "stack". */
#undef JITTER_DUP_STACK
#undef PVM_DUP_STACK
#define PVM_DUP_STACK /* The preferred name. */ \
  JITTER_DUP_STACK
#define JITTER_DUP_STACK()  \
  JITTER_STACK_TOS_DUP (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the swap operation for the
   TOS-optimized stack "stack". */
#undef JITTER_SWAP_STACK
#undef PVM_SWAP_STACK
#define PVM_SWAP_STACK /* The preferred name. */ \
  JITTER_SWAP_STACK
#define JITTER_SWAP_STACK()  \
  JITTER_STACK_TOS_SWAP (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the quake operation for the
   TOS-optimized stack "stack". */
#undef JITTER_QUAKE_STACK
#undef PVM_QUAKE_STACK
#define PVM_QUAKE_STACK /* The preferred name. */ \
  JITTER_QUAKE_STACK
#define JITTER_QUAKE_STACK()  \
  JITTER_STACK_TOS_QUAKE (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the over operation for the
   TOS-optimized stack "stack". */
#undef JITTER_OVER_STACK
#undef PVM_OVER_STACK
#define PVM_OVER_STACK /* The preferred name. */ \
  JITTER_OVER_STACK
#define JITTER_OVER_STACK()  \
  JITTER_STACK_TOS_OVER (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the tuck operation for the
   TOS-optimized stack "stack". */
#undef JITTER_TUCK_STACK
#undef PVM_TUCK_STACK
#define PVM_TUCK_STACK /* The preferred name. */ \
  JITTER_TUCK_STACK
#define JITTER_TUCK_STACK()  \
  JITTER_STACK_TOS_TUCK (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the nip operation for the
   TOS-optimized stack "stack". */
#undef JITTER_NIP_STACK
#undef PVM_NIP_STACK
#define PVM_NIP_STACK /* The preferred name. */ \
  JITTER_NIP_STACK
#define JITTER_NIP_STACK()  \
  JITTER_STACK_TOS_NIP (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the rot operation for the
   TOS-optimized stack "stack". */
#undef JITTER_ROT_STACK
#undef PVM_ROT_STACK
#define PVM_ROT_STACK /* The preferred name. */ \
  JITTER_ROT_STACK
#define JITTER_ROT_STACK()  \
  JITTER_STACK_TOS_ROT (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the mrot operation for the
   TOS-optimized stack "stack". */
#undef JITTER_MROT_STACK
#undef PVM_MROT_STACK
#define PVM_MROT_STACK /* The preferred name. */ \
  JITTER_MROT_STACK
#define JITTER_MROT_STACK()  \
  JITTER_STACK_TOS_MROT (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the roll operation for the
   TOS-optimized stack "stack". */
#undef JITTER_ROLL_STACK
#undef PVM_ROLL_STACK
#define PVM_ROLL_STACK /* The preferred name. */ \
  JITTER_ROLL_STACK
#define JITTER_ROLL_STACK(x0)  \
  JITTER_STACK_TOS_ROLL (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0)
/* Wrapper definition of the mroll operation for the
   TOS-optimized stack "stack". */
#undef JITTER_MROLL_STACK
#undef PVM_MROLL_STACK
#define PVM_MROLL_STACK /* The preferred name. */ \
  JITTER_MROLL_STACK
#define JITTER_MROLL_STACK(x0)  \
  JITTER_STACK_TOS_MROLL (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0)
/* Wrapper definition of the slide operation for the
   TOS-optimized stack "stack". */
#undef JITTER_SLIDE_STACK
#undef PVM_SLIDE_STACK
#define PVM_SLIDE_STACK /* The preferred name. */ \
  JITTER_SLIDE_STACK
#define JITTER_SLIDE_STACK(x0, x1)  \
  JITTER_STACK_TOS_SLIDE (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0, x1)
/* Wrapper definition of the whirl operation for the
   TOS-optimized stack "stack". */
#undef JITTER_WHIRL_STACK
#undef PVM_WHIRL_STACK
#define PVM_WHIRL_STACK /* The preferred name. */ \
  JITTER_WHIRL_STACK
#define JITTER_WHIRL_STACK(x0)  \
  JITTER_STACK_TOS_WHIRL (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0)
/* Wrapper definition of the bulge operation for the
   TOS-optimized stack "stack". */
#undef JITTER_BULGE_STACK
#undef PVM_BULGE_STACK
#define PVM_BULGE_STACK /* The preferred name. */ \
  JITTER_BULGE_STACK
#define JITTER_BULGE_STACK(x0)  \
  JITTER_STACK_TOS_BULGE (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0)
/* Wrapper definition of the height operation for the
   TOS-optimized stack "stack". */
#undef JITTER_HEIGHT_STACK
#undef PVM_HEIGHT_STACK
#define PVM_HEIGHT_STACK /* The preferred name. */ \
  JITTER_HEIGHT_STACK
#define JITTER_HEIGHT_STACK()  \
  JITTER_STACK_TOS_HEIGHT (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the set_height operation for the
   TOS-optimized stack "stack". */
#undef JITTER_SET_HEIGHT_STACK
#undef PVM_SET_HEIGHT_STACK
#define PVM_SET_HEIGHT_STACK /* The preferred name. */ \
  JITTER_SET_HEIGHT_STACK
#define JITTER_SET_HEIGHT_STACK(x0)  \
  JITTER_STACK_TOS_SET_HEIGHT (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0)
/* Wrapper definition of the under_top_address operation for the
   TOS-optimized stack "stack". */
#undef JITTER_UNDER_TOP_ADDRESS_STACK
#undef PVM_UNDER_TOP_ADDRESS_STACK
#define PVM_UNDER_TOP_ADDRESS_STACK /* The preferred name. */ \
  JITTER_UNDER_TOP_ADDRESS_STACK
#define JITTER_UNDER_TOP_ADDRESS_STACK()  \
  JITTER_STACK_TOS_UNDER_TOP_ADDRESS (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the bottom_address operation for the
   TOS-optimized stack "stack". */
#undef JITTER_BOTTOM_ADDRESS_STACK
#undef PVM_BOTTOM_ADDRESS_STACK
#define PVM_BOTTOM_ADDRESS_STACK /* The preferred name. */ \
  JITTER_BOTTOM_ADDRESS_STACK
#define JITTER_BOTTOM_ADDRESS_STACK()  \
  JITTER_STACK_TOS_BOTTOM_ADDRESS (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    )
/* Wrapper definition of the reverse operation for the
   TOS-optimized stack "stack". */
#undef JITTER_REVERSE_STACK
#undef PVM_REVERSE_STACK
#define PVM_REVERSE_STACK /* The preferred name. */ \
  JITTER_REVERSE_STACK
#define JITTER_REVERSE_STACK(x0)  \
  JITTER_STACK_TOS_REVERSE (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0)
/* Wrapper definition of the unary operation for the
   TOS-optimized stack "stack". */
#undef JITTER_UNARY_STACK
#undef PVM_UNARY_STACK
#define PVM_UNARY_STACK /* The preferred name. */ \
  JITTER_UNARY_STACK
#define JITTER_UNARY_STACK(x0)  \
  JITTER_STACK_TOS_UNARY (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0)
/* Wrapper definition of the binary operation for the
   TOS-optimized stack "stack". */
#undef JITTER_BINARY_STACK
#undef PVM_BINARY_STACK
#define PVM_BINARY_STACK /* The preferred name. */ \
  JITTER_BINARY_STACK
#define JITTER_BINARY_STACK(x0)  \
  JITTER_STACK_TOS_BINARY (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    stack  \
    , x0)
/* Wrapper definition of the top operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_TOP_RETURNSTACK
#undef PVM_TOP_RETURNSTACK
#define PVM_TOP_RETURNSTACK /* The preferred name. */ \
  JITTER_TOP_RETURNSTACK
#define JITTER_TOP_RETURNSTACK()  \
  JITTER_STACK_NTOS_TOP (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the under_top operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_UNDER_TOP_RETURNSTACK
#undef PVM_UNDER_TOP_RETURNSTACK
#define PVM_UNDER_TOP_RETURNSTACK /* The preferred name. */ \
  JITTER_UNDER_TOP_RETURNSTACK
#define JITTER_UNDER_TOP_RETURNSTACK()  \
  JITTER_STACK_NTOS_UNDER_TOP (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the at_depth operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_AT_DEPTH_RETURNSTACK
#undef PVM_AT_DEPTH_RETURNSTACK
#define PVM_AT_DEPTH_RETURNSTACK /* The preferred name. */ \
  JITTER_AT_DEPTH_RETURNSTACK
#define JITTER_AT_DEPTH_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_AT_DEPTH (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0)
/* Wrapper definition of the at_nonzero_depth operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_AT_NONZERO_DEPTH_RETURNSTACK
#undef PVM_AT_NONZERO_DEPTH_RETURNSTACK
#define PVM_AT_NONZERO_DEPTH_RETURNSTACK /* The preferred name. */ \
  JITTER_AT_NONZERO_DEPTH_RETURNSTACK
#define JITTER_AT_NONZERO_DEPTH_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_AT_NONZERO_DEPTH (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0)
/* Wrapper definition of the set_at_depth operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_SET_AT_DEPTH_RETURNSTACK
#undef PVM_SET_AT_DEPTH_RETURNSTACK
#define PVM_SET_AT_DEPTH_RETURNSTACK /* The preferred name. */ \
  JITTER_SET_AT_DEPTH_RETURNSTACK
#define JITTER_SET_AT_DEPTH_RETURNSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SET_AT_DEPTH (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0, x1)
/* Wrapper definition of the set_at_nonzero_depth operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_SET_AT_NONZERO_DEPTH_RETURNSTACK
#undef PVM_SET_AT_NONZERO_DEPTH_RETURNSTACK
#define PVM_SET_AT_NONZERO_DEPTH_RETURNSTACK /* The preferred name. */ \
  JITTER_SET_AT_NONZERO_DEPTH_RETURNSTACK
#define JITTER_SET_AT_NONZERO_DEPTH_RETURNSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SET_AT_NONZERO_DEPTH (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0, x1)
/* Wrapper definition of the push_unspecified operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_PUSH_UNSPECIFIED_RETURNSTACK
#undef PVM_PUSH_UNSPECIFIED_RETURNSTACK
#define PVM_PUSH_UNSPECIFIED_RETURNSTACK /* The preferred name. */ \
  JITTER_PUSH_UNSPECIFIED_RETURNSTACK
#define JITTER_PUSH_UNSPECIFIED_RETURNSTACK()  \
  JITTER_STACK_NTOS_PUSH_UNSPECIFIED (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the push operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_PUSH_RETURNSTACK
#undef PVM_PUSH_RETURNSTACK
#define PVM_PUSH_RETURNSTACK /* The preferred name. */ \
  JITTER_PUSH_RETURNSTACK
#define JITTER_PUSH_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_PUSH (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0)
/* Wrapper definition of the under_push_unspecified operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_UNDER_PUSH_UNSPECIFIED_RETURNSTACK
#undef PVM_UNDER_PUSH_UNSPECIFIED_RETURNSTACK
#define PVM_UNDER_PUSH_UNSPECIFIED_RETURNSTACK /* The preferred name. */ \
  JITTER_UNDER_PUSH_UNSPECIFIED_RETURNSTACK
#define JITTER_UNDER_PUSH_UNSPECIFIED_RETURNSTACK()  \
  JITTER_STACK_NTOS_UNDER_PUSH_UNSPECIFIED (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the under_push operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_UNDER_PUSH_RETURNSTACK
#undef PVM_UNDER_PUSH_RETURNSTACK
#define PVM_UNDER_PUSH_RETURNSTACK /* The preferred name. */ \
  JITTER_UNDER_PUSH_RETURNSTACK
#define JITTER_UNDER_PUSH_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_UNDER_PUSH (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0)
/* Wrapper definition of the drop operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_DROP_RETURNSTACK
#undef PVM_DROP_RETURNSTACK
#define PVM_DROP_RETURNSTACK /* The preferred name. */ \
  JITTER_DROP_RETURNSTACK
#define JITTER_DROP_RETURNSTACK()  \
  JITTER_STACK_NTOS_DROP (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the dup operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_DUP_RETURNSTACK
#undef PVM_DUP_RETURNSTACK
#define PVM_DUP_RETURNSTACK /* The preferred name. */ \
  JITTER_DUP_RETURNSTACK
#define JITTER_DUP_RETURNSTACK()  \
  JITTER_STACK_NTOS_DUP (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the swap operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_SWAP_RETURNSTACK
#undef PVM_SWAP_RETURNSTACK
#define PVM_SWAP_RETURNSTACK /* The preferred name. */ \
  JITTER_SWAP_RETURNSTACK
#define JITTER_SWAP_RETURNSTACK()  \
  JITTER_STACK_NTOS_SWAP (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the quake operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_QUAKE_RETURNSTACK
#undef PVM_QUAKE_RETURNSTACK
#define PVM_QUAKE_RETURNSTACK /* The preferred name. */ \
  JITTER_QUAKE_RETURNSTACK
#define JITTER_QUAKE_RETURNSTACK()  \
  JITTER_STACK_NTOS_QUAKE (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the over operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_OVER_RETURNSTACK
#undef PVM_OVER_RETURNSTACK
#define PVM_OVER_RETURNSTACK /* The preferred name. */ \
  JITTER_OVER_RETURNSTACK
#define JITTER_OVER_RETURNSTACK()  \
  JITTER_STACK_NTOS_OVER (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the tuck operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_TUCK_RETURNSTACK
#undef PVM_TUCK_RETURNSTACK
#define PVM_TUCK_RETURNSTACK /* The preferred name. */ \
  JITTER_TUCK_RETURNSTACK
#define JITTER_TUCK_RETURNSTACK()  \
  JITTER_STACK_NTOS_TUCK (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the nip operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_NIP_RETURNSTACK
#undef PVM_NIP_RETURNSTACK
#define PVM_NIP_RETURNSTACK /* The preferred name. */ \
  JITTER_NIP_RETURNSTACK
#define JITTER_NIP_RETURNSTACK()  \
  JITTER_STACK_NTOS_NIP (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the rot operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_ROT_RETURNSTACK
#undef PVM_ROT_RETURNSTACK
#define PVM_ROT_RETURNSTACK /* The preferred name. */ \
  JITTER_ROT_RETURNSTACK
#define JITTER_ROT_RETURNSTACK()  \
  JITTER_STACK_NTOS_ROT (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the mrot operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_MROT_RETURNSTACK
#undef PVM_MROT_RETURNSTACK
#define PVM_MROT_RETURNSTACK /* The preferred name. */ \
  JITTER_MROT_RETURNSTACK
#define JITTER_MROT_RETURNSTACK()  \
  JITTER_STACK_NTOS_MROT (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the roll operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_ROLL_RETURNSTACK
#undef PVM_ROLL_RETURNSTACK
#define PVM_ROLL_RETURNSTACK /* The preferred name. */ \
  JITTER_ROLL_RETURNSTACK
#define JITTER_ROLL_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_ROLL (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0)
/* Wrapper definition of the mroll operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_MROLL_RETURNSTACK
#undef PVM_MROLL_RETURNSTACK
#define PVM_MROLL_RETURNSTACK /* The preferred name. */ \
  JITTER_MROLL_RETURNSTACK
#define JITTER_MROLL_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_MROLL (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0)
/* Wrapper definition of the slide operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_SLIDE_RETURNSTACK
#undef PVM_SLIDE_RETURNSTACK
#define PVM_SLIDE_RETURNSTACK /* The preferred name. */ \
  JITTER_SLIDE_RETURNSTACK
#define JITTER_SLIDE_RETURNSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SLIDE (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0, x1)
/* Wrapper definition of the whirl operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_WHIRL_RETURNSTACK
#undef PVM_WHIRL_RETURNSTACK
#define PVM_WHIRL_RETURNSTACK /* The preferred name. */ \
  JITTER_WHIRL_RETURNSTACK
#define JITTER_WHIRL_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_WHIRL (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0)
/* Wrapper definition of the bulge operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_BULGE_RETURNSTACK
#undef PVM_BULGE_RETURNSTACK
#define PVM_BULGE_RETURNSTACK /* The preferred name. */ \
  JITTER_BULGE_RETURNSTACK
#define JITTER_BULGE_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_BULGE (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0)
/* Wrapper definition of the height operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_HEIGHT_RETURNSTACK
#undef PVM_HEIGHT_RETURNSTACK
#define PVM_HEIGHT_RETURNSTACK /* The preferred name. */ \
  JITTER_HEIGHT_RETURNSTACK
#define JITTER_HEIGHT_RETURNSTACK()  \
  JITTER_STACK_NTOS_HEIGHT (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the set_height operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_SET_HEIGHT_RETURNSTACK
#undef PVM_SET_HEIGHT_RETURNSTACK
#define PVM_SET_HEIGHT_RETURNSTACK /* The preferred name. */ \
  JITTER_SET_HEIGHT_RETURNSTACK
#define JITTER_SET_HEIGHT_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_SET_HEIGHT (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0)
/* Wrapper definition of the under_top_address operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_UNDER_TOP_ADDRESS_RETURNSTACK
#undef PVM_UNDER_TOP_ADDRESS_RETURNSTACK
#define PVM_UNDER_TOP_ADDRESS_RETURNSTACK /* The preferred name. */ \
  JITTER_UNDER_TOP_ADDRESS_RETURNSTACK
#define JITTER_UNDER_TOP_ADDRESS_RETURNSTACK()  \
  JITTER_STACK_NTOS_UNDER_TOP_ADDRESS (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the bottom_address operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_BOTTOM_ADDRESS_RETURNSTACK
#undef PVM_BOTTOM_ADDRESS_RETURNSTACK
#define PVM_BOTTOM_ADDRESS_RETURNSTACK /* The preferred name. */ \
  JITTER_BOTTOM_ADDRESS_RETURNSTACK
#define JITTER_BOTTOM_ADDRESS_RETURNSTACK()  \
  JITTER_STACK_NTOS_BOTTOM_ADDRESS (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    )
/* Wrapper definition of the reverse operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_REVERSE_RETURNSTACK
#undef PVM_REVERSE_RETURNSTACK
#define PVM_REVERSE_RETURNSTACK /* The preferred name. */ \
  JITTER_REVERSE_RETURNSTACK
#define JITTER_REVERSE_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_REVERSE (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0)
/* Wrapper definition of the unary operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_UNARY_RETURNSTACK
#undef PVM_UNARY_RETURNSTACK
#define PVM_UNARY_RETURNSTACK /* The preferred name. */ \
  JITTER_UNARY_RETURNSTACK
#define JITTER_UNARY_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_UNARY (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0)
/* Wrapper definition of the binary operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_BINARY_RETURNSTACK
#undef PVM_BINARY_RETURNSTACK
#define PVM_BINARY_RETURNSTACK /* The preferred name. */ \
  JITTER_BINARY_RETURNSTACK
#define JITTER_BINARY_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_BINARY (pvm_val,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    returnstack  \
    , x0)
/* Wrapper definition of the top operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_TOP_EXCEPTIONSTACK
#undef PVM_TOP_EXCEPTIONSTACK
#define PVM_TOP_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_TOP_EXCEPTIONSTACK
#define JITTER_TOP_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_TOP (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the under_top operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_UNDER_TOP_EXCEPTIONSTACK
#undef PVM_UNDER_TOP_EXCEPTIONSTACK
#define PVM_UNDER_TOP_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_UNDER_TOP_EXCEPTIONSTACK
#define JITTER_UNDER_TOP_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_UNDER_TOP (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the at_depth operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_AT_DEPTH_EXCEPTIONSTACK
#undef PVM_AT_DEPTH_EXCEPTIONSTACK
#define PVM_AT_DEPTH_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_AT_DEPTH_EXCEPTIONSTACK
#define JITTER_AT_DEPTH_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_AT_DEPTH (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0)
/* Wrapper definition of the at_nonzero_depth operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_AT_NONZERO_DEPTH_EXCEPTIONSTACK
#undef PVM_AT_NONZERO_DEPTH_EXCEPTIONSTACK
#define PVM_AT_NONZERO_DEPTH_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_AT_NONZERO_DEPTH_EXCEPTIONSTACK
#define JITTER_AT_NONZERO_DEPTH_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_AT_NONZERO_DEPTH (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0)
/* Wrapper definition of the set_at_depth operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_SET_AT_DEPTH_EXCEPTIONSTACK
#undef PVM_SET_AT_DEPTH_EXCEPTIONSTACK
#define PVM_SET_AT_DEPTH_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_SET_AT_DEPTH_EXCEPTIONSTACK
#define JITTER_SET_AT_DEPTH_EXCEPTIONSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SET_AT_DEPTH (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0, x1)
/* Wrapper definition of the set_at_nonzero_depth operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_SET_AT_NONZERO_DEPTH_EXCEPTIONSTACK
#undef PVM_SET_AT_NONZERO_DEPTH_EXCEPTIONSTACK
#define PVM_SET_AT_NONZERO_DEPTH_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_SET_AT_NONZERO_DEPTH_EXCEPTIONSTACK
#define JITTER_SET_AT_NONZERO_DEPTH_EXCEPTIONSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SET_AT_NONZERO_DEPTH (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0, x1)
/* Wrapper definition of the push_unspecified operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_PUSH_UNSPECIFIED_EXCEPTIONSTACK
#undef PVM_PUSH_UNSPECIFIED_EXCEPTIONSTACK
#define PVM_PUSH_UNSPECIFIED_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_PUSH_UNSPECIFIED_EXCEPTIONSTACK
#define JITTER_PUSH_UNSPECIFIED_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_PUSH_UNSPECIFIED (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the push operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_PUSH_EXCEPTIONSTACK
#undef PVM_PUSH_EXCEPTIONSTACK
#define PVM_PUSH_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_PUSH_EXCEPTIONSTACK
#define JITTER_PUSH_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_PUSH (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0)
/* Wrapper definition of the under_push_unspecified operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_UNDER_PUSH_UNSPECIFIED_EXCEPTIONSTACK
#undef PVM_UNDER_PUSH_UNSPECIFIED_EXCEPTIONSTACK
#define PVM_UNDER_PUSH_UNSPECIFIED_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_UNDER_PUSH_UNSPECIFIED_EXCEPTIONSTACK
#define JITTER_UNDER_PUSH_UNSPECIFIED_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_UNDER_PUSH_UNSPECIFIED (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the under_push operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_UNDER_PUSH_EXCEPTIONSTACK
#undef PVM_UNDER_PUSH_EXCEPTIONSTACK
#define PVM_UNDER_PUSH_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_UNDER_PUSH_EXCEPTIONSTACK
#define JITTER_UNDER_PUSH_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_UNDER_PUSH (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0)
/* Wrapper definition of the drop operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_DROP_EXCEPTIONSTACK
#undef PVM_DROP_EXCEPTIONSTACK
#define PVM_DROP_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_DROP_EXCEPTIONSTACK
#define JITTER_DROP_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_DROP (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the dup operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_DUP_EXCEPTIONSTACK
#undef PVM_DUP_EXCEPTIONSTACK
#define PVM_DUP_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_DUP_EXCEPTIONSTACK
#define JITTER_DUP_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_DUP (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the swap operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_SWAP_EXCEPTIONSTACK
#undef PVM_SWAP_EXCEPTIONSTACK
#define PVM_SWAP_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_SWAP_EXCEPTIONSTACK
#define JITTER_SWAP_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_SWAP (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the quake operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_QUAKE_EXCEPTIONSTACK
#undef PVM_QUAKE_EXCEPTIONSTACK
#define PVM_QUAKE_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_QUAKE_EXCEPTIONSTACK
#define JITTER_QUAKE_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_QUAKE (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the over operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_OVER_EXCEPTIONSTACK
#undef PVM_OVER_EXCEPTIONSTACK
#define PVM_OVER_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_OVER_EXCEPTIONSTACK
#define JITTER_OVER_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_OVER (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the tuck operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_TUCK_EXCEPTIONSTACK
#undef PVM_TUCK_EXCEPTIONSTACK
#define PVM_TUCK_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_TUCK_EXCEPTIONSTACK
#define JITTER_TUCK_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_TUCK (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the nip operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_NIP_EXCEPTIONSTACK
#undef PVM_NIP_EXCEPTIONSTACK
#define PVM_NIP_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_NIP_EXCEPTIONSTACK
#define JITTER_NIP_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_NIP (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the rot operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_ROT_EXCEPTIONSTACK
#undef PVM_ROT_EXCEPTIONSTACK
#define PVM_ROT_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_ROT_EXCEPTIONSTACK
#define JITTER_ROT_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_ROT (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the mrot operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_MROT_EXCEPTIONSTACK
#undef PVM_MROT_EXCEPTIONSTACK
#define PVM_MROT_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_MROT_EXCEPTIONSTACK
#define JITTER_MROT_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_MROT (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the roll operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_ROLL_EXCEPTIONSTACK
#undef PVM_ROLL_EXCEPTIONSTACK
#define PVM_ROLL_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_ROLL_EXCEPTIONSTACK
#define JITTER_ROLL_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_ROLL (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0)
/* Wrapper definition of the mroll operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_MROLL_EXCEPTIONSTACK
#undef PVM_MROLL_EXCEPTIONSTACK
#define PVM_MROLL_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_MROLL_EXCEPTIONSTACK
#define JITTER_MROLL_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_MROLL (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0)
/* Wrapper definition of the slide operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_SLIDE_EXCEPTIONSTACK
#undef PVM_SLIDE_EXCEPTIONSTACK
#define PVM_SLIDE_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_SLIDE_EXCEPTIONSTACK
#define JITTER_SLIDE_EXCEPTIONSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SLIDE (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0, x1)
/* Wrapper definition of the whirl operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_WHIRL_EXCEPTIONSTACK
#undef PVM_WHIRL_EXCEPTIONSTACK
#define PVM_WHIRL_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_WHIRL_EXCEPTIONSTACK
#define JITTER_WHIRL_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_WHIRL (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0)
/* Wrapper definition of the bulge operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_BULGE_EXCEPTIONSTACK
#undef PVM_BULGE_EXCEPTIONSTACK
#define PVM_BULGE_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_BULGE_EXCEPTIONSTACK
#define JITTER_BULGE_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_BULGE (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0)
/* Wrapper definition of the height operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_HEIGHT_EXCEPTIONSTACK
#undef PVM_HEIGHT_EXCEPTIONSTACK
#define PVM_HEIGHT_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_HEIGHT_EXCEPTIONSTACK
#define JITTER_HEIGHT_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_HEIGHT (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the set_height operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_SET_HEIGHT_EXCEPTIONSTACK
#undef PVM_SET_HEIGHT_EXCEPTIONSTACK
#define PVM_SET_HEIGHT_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_SET_HEIGHT_EXCEPTIONSTACK
#define JITTER_SET_HEIGHT_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_SET_HEIGHT (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0)
/* Wrapper definition of the under_top_address operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_UNDER_TOP_ADDRESS_EXCEPTIONSTACK
#undef PVM_UNDER_TOP_ADDRESS_EXCEPTIONSTACK
#define PVM_UNDER_TOP_ADDRESS_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_UNDER_TOP_ADDRESS_EXCEPTIONSTACK
#define JITTER_UNDER_TOP_ADDRESS_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_UNDER_TOP_ADDRESS (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the bottom_address operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_BOTTOM_ADDRESS_EXCEPTIONSTACK
#undef PVM_BOTTOM_ADDRESS_EXCEPTIONSTACK
#define PVM_BOTTOM_ADDRESS_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_BOTTOM_ADDRESS_EXCEPTIONSTACK
#define JITTER_BOTTOM_ADDRESS_EXCEPTIONSTACK()  \
  JITTER_STACK_NTOS_BOTTOM_ADDRESS (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    )
/* Wrapper definition of the reverse operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_REVERSE_EXCEPTIONSTACK
#undef PVM_REVERSE_EXCEPTIONSTACK
#define PVM_REVERSE_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_REVERSE_EXCEPTIONSTACK
#define JITTER_REVERSE_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_REVERSE (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0)
/* Wrapper definition of the unary operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_UNARY_EXCEPTIONSTACK
#undef PVM_UNARY_EXCEPTIONSTACK
#define PVM_UNARY_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_UNARY_EXCEPTIONSTACK
#define JITTER_UNARY_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_UNARY (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0)
/* Wrapper definition of the binary operation for the
   non-TOS-optimized stack "exceptionstack". */
#undef JITTER_BINARY_EXCEPTIONSTACK
#undef PVM_BINARY_EXCEPTIONSTACK
#define PVM_BINARY_EXCEPTIONSTACK /* The preferred name. */ \
  JITTER_BINARY_EXCEPTIONSTACK
#define JITTER_BINARY_EXCEPTIONSTACK(x0)  \
  JITTER_STACK_NTOS_BINARY (struct pvm_exception_handler,  \
    jitter_state_runtime. , jitter_original_state->pvm_state_backing. ,  \
    exceptionstack  \
    , x0)

/* Late C code from the user. */
#line 773 "./pvm.jitter"
#line 773 "./pvm.jitter"

    void
    pvm_handle_signal (int signal_number)
    {
      struct pvm_state *s;

      /* For every state... */
      PVM_FOR_EACH_STATE (s)
      {
        /* ...Mark the signal signal_number as pending... */
        PVM_STATE_AND_SIGNAL_TO_PENDING_SIGNAL_NOTIFICATION
           (s, signal_number) = true;
        /* ...And record the fact that there is at least one notification to
           handle. */
        PVM_STATE_TO_PENDING_NOTIFICATIONS (s) = true;
      }
    }

    /* These are not `const' to suppress compiler warnings.  */
    static char *pvm_literal_empty = "";
    static char *pvm_literal_c = "c";

    static const char *pvm_literal_code = "code";
    static const char *pvm_literal_enomem = "out of memory";
    static const char *pvm_literal_no_toplevel_var = "no top-level variable found";
    static const char *pvm_literal_eindex = "invalid index in ains";
    static const char *pvm_literal_notmappable = "not mappable value";
    static const char *pvm_literal_newline = "\n";
    static const char *pvm_literal_formatf_fmt = "%%.%u%c";
    static const char pvm_literal_formatf_styles[3] = { 'f', 'e', 'g' };
    static const char *pvm_literal_dispatch_name = PVM_DISPATCH_HUMAN_READABLE;

#define E(key) [PVM_E_##key] = PVM_E_##key##_NAME,
    static const char *pvm_exception_names[] = {
      PVM_EXCEPTIONS(E)
    };
#undef E

    struct ionum_ctx
    {
      uint64_t count;
    };

    static void
    ionum_callback (ios io, void *data)
    {
      struct ionum_ctx *ctx = data;

      ++ctx->count;
    }

    struct ioref_ctx
    {
      uint64_t index;
      int ios_id;
    };

    static void
    ioref_callback (ios io, void *data)
    {
      struct ioref_ctx *ctx = data;

      if (ctx->ios_id != -1)
        return;
      if (ctx->index == 0)
        ctx->ios_id = ios_get_id (io);
      else
        --ctx->index;
    }
  /* End of the late C code from the user. */

/* The definition of this is machine-generated in pvm-vm2.c , and the
   function is not intended for the user.  If initializing then set
   structuredvm_threads and structuredvm_thread_sizes and just return, ignoring
   the other fields and s.  If not initializing then actually enter VM code
   starting from the initial program point in the state. */
static enum pvm_exit_status
pvm_execute_or_initialize (bool jitter_initialize,
                                struct pvm_state * const jitter_original_state)
  __attribute__ ((noclone, noinline, no_reorder));

enum pvm_exit_status
pvm_execute_executable_routine (const struct jitter_executable_routine *er,
                                     struct pvm_state *s)
{
  pvm_make_place_for_slow_registers (s, er->slow_register_per_class_no);
  jitter_program_point initial_program_point
    = PVM_EXECUTABLE_ROUTINE_BEGINNING (er);
  return pvm_branch_to_program_point (initial_program_point,
                                           s);
}


/* Threads or pointers to native code blocks of course don't exist with
   switch-dispatching. */
#ifndef JITTER_DISPATCH_SWITCH
const jitter_thread *
pvm_threads;

const jitter_thread *
pvm_thread_ends;

const long *
pvm_thread_sizes;
#endif // #ifndef JITTER_DISPATCH_SWITCH

void
pvm_initialize_threads (void)
{
  pvm_execute_or_initialize (true, NULL);
}

enum pvm_exit_status
pvm_branch_to_program_point (pvm_program_point p, struct pvm_state *s)
{
  /* Change the state to set the initial program point. */
  s->pvm_state_backing.initial_program_point = p;

  /* Execute. */
  return pvm_execute_or_initialize (false, s);
}

__attribute__ ((noinline, noclone, no_reorder))
void
pvm_asm_headers (void)
{
#ifdef JITTER_HAVE_PATCH_IN
  /* Generate the single patch-in header for this executor as a
     global asm statement.  This expands into a global definition in
     assembly in a separate subsection, and relies on toplevel C
     definitions not being reordered: pvm_execute_or_initialize
     will add to the same global.  Do the same for defects. */
  JITTER_PATCH_IN_HEADER(pvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_HAVE_DEFECT_REPLACEMENT

  /* The same for defects... */
  JITTER_DEFECT_HEADER(pvm);
#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT

#ifndef JITTER_DISPATCH_SWITCH
  JITTER_DATA_LOCATION_HEADER(pvm);
#endif // #ifndef JITTER_DISPATCH_SWITCH

}
static enum pvm_exit_status
pvm_execute_or_initialize (bool jitter_initialize,
                                struct pvm_state * const jitter_original_state)
{
/* Undefine the state field access macros which are meant to be
   used out of VM instructions. */
#undef PVM_STATE_RUNTIME_FIELD
#undef PVM_STATE_BACKING_FIELD

/* Replace the definitions by versions which will work (only!)
   inside instruction bodies.  These macros have one argument
   instead of two: the VM state being used is *the* current
   state. */
#define PVM_STATE_RUNTIME_FIELD  _JITTER_STATE_RUNTIME_FIELD
#define PVM_STATE_BACKING_FIELD  _JITTER_STATE_BACKING_FIELD

#ifdef JITTER_DISPATCH_NO_THREADING
  /* Save the values in the registers we reserved as global variables,
     since from the point of view of the other C compilation units such
     registers are callee-save.  FIXME: this is not really needed when
     initializing, if I've been careful; but for the time being I want
     to play it safe. */
  union jitter_word jitter_register_buffer [PVM_REGISTER_BUFFER_ELEMENT_NO];
  pvm_save_registers (jitter_register_buffer);
#endif // #ifdef JITTER_DISPATCH_NO_THREADING

  /* Initialization.  This is only called once at startup. */
  if (__builtin_expect (jitter_initialize, false))
    {
      /* Make sure that vm1 and vm2 were macroexpanded consistently
         with respect to instrumentation macros.  This relies on the
         enum values for each feature working as individual bits in a
         bitmask: see the comment in jitter/jitter-vm.h . */
      enum jitter_vm_instrumentation correct_instrumentation
        = jitter_vm_instrumentation_none;
#if defined (PVM_PROFILE_COUNT)
      correct_instrumentation |= jitter_vm_instrumentation_count;
#endif
#if defined (PVM_PROFILE_SAMPLE)
      correct_instrumentation |= jitter_vm_instrumentation_sample;
#endif
      if (pvm_vm_configuration->instrumentation != correct_instrumentation)
        jitter_fatal ("vm1 and vm2 were compiled with different profiling "
                      "instrumentation macros.  Please recompile with coherent "
                      "CPPFLAGS");

#if defined (PVM_PROFILE_SAMPLE)
    /* Initialise the sample-profile subsystem, once and for all. */
    pvm_profile_sample_initialize ();
#endif // #if defined (PVM_PROFILE_SAMPLE)

#ifndef JITTER_DISPATCH_SWITCH
      /* FIXME: I can do this with only one relocation, by keeping
         a pointer to the first VM instruction beginning in a static
         variable, and then having a static vector of offsets with
         respect to the first pointer.  This will slightly complicate
         my initialization code, but should make startup faster.
         FIXME: that won't work on AVR, according to the GCC
         documentation.  Do I care?  Probably not, since AVRs can't
         address more than 2^16 bytes, which is too little to run my
         VMs. */
      static const jitter_thread pvm_the_threads []
        = {
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eINVALID),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eBEGINBASICBLOCK),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eEXITVM),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eDATALOCATIONS),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eNOP),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_ePRETENDTOJUMPANYWHERE),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addiof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addlof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(addlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ains),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(and),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(aref),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(arefo),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(arem),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(aset),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(atr),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ba__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bandlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beghl__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(begsc__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bn__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnn__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnoti),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnotlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnzi__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnziu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnzl__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bnzlu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bori),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(boriu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(borl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(borlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsli),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsliu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsll),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsllu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsri),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsriu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsrl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bsrlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxori),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxoriu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxorl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bxorlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bzi__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bziu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bzl__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bzlu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(canary),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(cgetn),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(close),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ctos),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(disas__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(diviof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(diviu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divlof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(duc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(dup),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(endhl__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(endsc__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eql),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(eqs),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exit),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exitvm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(flush),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(formatf32__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(formatf32__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(formatf32__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(formatf32__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(formatf64__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(formatf64__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(formatf64__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(formatf64__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(formati__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(formatiu__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(formatl__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(formatlu__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(fromr),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gei),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(geiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gel),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gelu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ges),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(getenv),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gti),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gtiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gtl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gtlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gts),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ioflags),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iogetb),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iogetv),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iohandler),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ionum),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ioref),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iosetb),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iosize),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iotype),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(isa),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(isios),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(isty),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(itolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(iutolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lei),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(leiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lel),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lelu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(les),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lti),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ltolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lts),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lutolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(map),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetios),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgeto),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgets),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetsel),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetsiz),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mgetw),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mka),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mko),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mkoq),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mksct),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktya),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyo),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktys),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktysct),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mktyv),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modiof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modlof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(modlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetios),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mseto),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msets),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetsel),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetsiz),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(msetw),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(muli),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(muliof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(muliu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mull),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mullof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mullu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(muls),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nec),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(negi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(negiof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(negiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(negl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(neglof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(neglu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nei),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(neiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nel),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nelu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nes),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nn),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nnn),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(not),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(note__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nrot),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ogetbt),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ogetm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ogetu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(oover),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(open),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(or),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(osetm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(over),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pec),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdl__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekdlu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peeki__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekiu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peekl__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(peeklu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokedi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokediu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokedl__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokedlu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokei__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokeiu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokel__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pokelu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(poparem),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popcountiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popcountlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pope),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popend),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popexite),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popf__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popios),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoac),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popob),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popobc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popod),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popom),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popoo),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popopp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popr___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(popvar__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powiof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powlof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(powlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printi__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printiu__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printl__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(printlu__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(prints__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(prolog),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push32__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push32__nR__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push32__lR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push32__lR__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pusharem),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushe__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushend),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushf__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushios),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoac),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushob),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushobc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushod),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushom),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushoo),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushopp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushtopvar__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__n0__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushvar__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(quake),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(raise),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(rand),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(regvar),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(reloc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(restorer___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(return),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(revn__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(revn__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(revn__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(rot),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(rtrace__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(saver___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sconc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sel),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(setr___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(siz),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sleep),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(smodi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(spropc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sproph),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sprops),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sref),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefia),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefin),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefio),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefmnt),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefnt),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(srefo),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sset),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sseti),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stod),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(stof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(strace__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(strref),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(strset),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subiof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(subl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sublof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sublu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(substr),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swap),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgti),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgtiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgtl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(swapgtlu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(sync),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(time),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tor),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tuck),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyagetb),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyagett),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyasetb),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyigetsg),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyigetsz),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyisa),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyisc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyisi),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyisiu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyisl),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyislu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyiso),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyiss),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyissct),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyisv),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyogetm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyogetrt),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyogetu),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tyosetrt),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(typof),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tysctgetc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tysctgetfn),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tysctgetft),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tysctgetn),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tysctgetnf),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tysctsetc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tysctsetn),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(unmap),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(unreachable),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ureloc),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(vmdisp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(write__retR),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mains__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_maref__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_marefo__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_marem__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mba__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbn__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnn__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnzi__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnziu__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnzl__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbnzlu__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbzi__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbziu__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbzl__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbzlu__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mexit__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mexitvm__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mformatf32__n0__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mformatf32__n1__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mformatf32__n2__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mformatf32__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mformatf64__n0__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mformatf64__n1__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mformatf64__n2__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mformatf64__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprolog__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mpushtopvar__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mraise__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mreloc__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mreturn__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msmodi__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msref__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msrefi__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msrefia__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msrefin__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msrefio__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msrefo__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msset__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msseti__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mstrref__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mstrset__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msubstr__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_msync__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_munreachable__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mureloc__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mwrite__retR),
                0)
          };
      static const jitter_thread pvm_the_thread_ends []
        = {
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eINVALID),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eBEGINBASICBLOCK),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eEXITVM),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eDATALOCATIONS),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eNOP),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_ePRETENDTOJUMPANYWHERE),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addiof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addlof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(addlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ains),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(and),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(aref),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(arefo),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(arem),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(aset),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(atr),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ba__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bandi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bandiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bandl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bandlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beghl__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(begsc__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bn__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnn__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnoti),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnotlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnzi__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnziu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnzl__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bnzlu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bori),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(boriu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(borl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(borlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsli),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsliu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsll),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsllu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsri),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsriu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsrl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bsrlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bxori),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bxoriu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bxorl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bxorlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bzi__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bziu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bzl__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bzlu__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(canary),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(cgetn),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(close),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ctos),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(disas__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(diviof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(diviu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divlof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(duc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(dup),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(endhl__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(endsc__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eqc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eqi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eqiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eql),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eqlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(eqs),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(exit),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(exitvm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(flush),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(formatf32__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(formatf32__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(formatf32__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(formatf32__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(formatf64__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(formatf64__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(formatf64__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(formatf64__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(formati__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(formatiu__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(formatl__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(formatlu__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(fromr),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gei),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(geiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gel),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gelu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ges),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(getenv),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gti),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gtiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gtl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gtlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gts),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ioflags),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iogetb),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iogetv),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iohandler),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ionum),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ioref),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iosetb),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iosize),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iotype),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(isa),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(isios),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(isty),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(itoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(itoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(itol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(itolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iutoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iutoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iutol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(iutolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lei),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(leiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lel),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lelu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(les),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lti),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ltolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lts),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lutoi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lutoiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lutol__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lutolu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(map),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetios),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgeto),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgets),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetsel),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetsiz),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mgetw),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mka),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mko),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mkoq),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mksct),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktya),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktyc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktyi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktyo),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktys),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktysct),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mktyv),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modiof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modlof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(modlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetios),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mseto),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msets),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetsel),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetsiz),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(msetw),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(muli),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(muliof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(muliu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mull),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mullof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mullu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(muls),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nec),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(negi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(negiof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(negiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(negl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(neglof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(neglu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nei),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(neiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nel),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nelu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nes),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nn),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nnn),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(not),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(note__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nrot),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ogetbt),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ogetm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ogetu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(oover),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(open),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(or),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(osetm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(over),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pec),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekdi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekdiu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekdl__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekdlu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peeki__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekiu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peekl__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(peeklu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokedi__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokediu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokedl__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokedlu__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokei__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokeiu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokel__nR__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pokelu__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(poparem),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popcountiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popcountlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pope),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popend),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popexite),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popf__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popios),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popoac),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popob),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popobc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popoc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popod),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popoi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popom),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popoo),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popopp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popr___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(popvar__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(powi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(powiof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(powiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(powl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(powlof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(powlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(printi__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(printiu__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(printl__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(printlu__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(prints__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(prolog),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push32__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push32__nR__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push32__lR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push32__lR__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pusharem),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushe__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushend),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushf__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushios),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushoac),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushob),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushobc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushoc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushod),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushoi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushom),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushoo),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushopp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushtopvar__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__n0__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__n5),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushvar__nR__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(quake),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(raise),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(rand),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(regvar),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(reloc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(restorer___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(return),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(revn__n3),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(revn__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(revn__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(rot),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(rtrace__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(saver___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sconc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sel),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(setr___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(siz),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sleep),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(smodi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(spropc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sproph),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sprops),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sref),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefia),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefin),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefio),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefmnt),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefnt),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(srefo),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sset),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sseti),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stod),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(stof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(strace__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(strref),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(strset),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subiof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(subl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sublof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sublu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(substr),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swap),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swapgti),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swapgtiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swapgtl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(swapgtlu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(sync),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(time),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tor),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tuck),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyagetb),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyagett),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyasetb),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyigetsg),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyigetsz),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyisa),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyisc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyisi),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyisiu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyisl),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyislu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyiso),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyiss),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyissct),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyisv),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyogetm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyogetrt),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyogetu),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tyosetrt),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(typof),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tysctgetc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tysctgetfn),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tysctgetft),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tysctgetn),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tysctgetnf),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tysctsetc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tysctsetn),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(unmap),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(unreachable),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ureloc),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(vmdisp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(write__retR),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mains__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_maref__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_marefo__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_marem__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mba__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbn__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnn__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnzi__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnziu__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnzl__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbnzlu__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbzi__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbziu__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbzl__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbzlu__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mexit__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mexitvm__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mformatf32__n0__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mformatf32__n1__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mformatf32__n2__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mformatf32__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mformatf64__n0__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mformatf64__n1__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mformatf64__n2__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mformatf64__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprolog__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mpushtopvar__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mraise__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mreloc__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mreturn__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msmodi__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msref__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msrefi__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msrefia__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msrefin__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msrefio__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msrefo__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msset__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msseti__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mstrref__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mstrset__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msubstr__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_msync__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_munreachable__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mureloc__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mwrite__retR),
                0)
          };
      /* A few non-GCC compilers such as TCC support GNU C's labels
         as values, but do not recognise their differences as
         *constant* expressions.  Compute the difference at
         initialisation then. */
      static long
      pvm_the_thread_sizes [PVM_SPECIALIZED_INSTRUCTION_NO];
      int i;
      for (i = 0; i < PVM_SPECIALIZED_INSTRUCTION_NO; i ++)
        pvm_the_thread_sizes [i]
          = pvm_the_thread_ends [i] - pvm_the_threads [i];
      pvm_thread_sizes
        = (const long *) pvm_the_thread_sizes;
      pvm_threads = pvm_the_threads;
      pvm_thread_ends = pvm_the_thread_ends;

#ifdef JITTER_HAVE_DEFECT_REPLACEMENT
      /* Define the correct distance between the fake target in C
         and in assembly, for this VM. */
      JITTER_DEFECT_CORRECT_DISPLACEMENT_NAME (pvm)
        = ((char *) && jitter_fake_target
           - (char *) pvm_fake_target_asm);
      //fprintf (stderr, "DEBUG: INITIALISE CORRECT DISPLACEMENT TO %li\n", (long) JITTER_DEFECT_CORRECT_DISPLACEMENT_NAME (pvm));
#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT

#endif // #ifndef JITTER_DISPATCH_SWITCH

      /* Back to regular C, without our reserved registers if any; I can share
         the end code with the non-initialization case. */
#ifdef JITTER_HAVE_PATCH_IN
      //JITTER_DUMP_PATCH_IN_DESCRIPTORS(pvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN
      goto jitter_possibly_restore_registers_and_return_label;
    }


  /* Before setting up runtime structures and jumping to the first
     instruction check that the last exit status was correct, and
     update it for the present run. */
  switch (_JITTER_STATE_BACKING_FIELD (exit_status))
    {
    case pvm_exit_status_never_executed:
    case pvm_exit_status_exited:
    case pvm_exit_status_debug:
      /* This is normal and expected. */
      _JITTER_STATE_BACKING_FIELD (exit_status)
        = pvm_exit_status_being_executed;
      break;

    case pvm_exit_status_being_executed:
      jitter_fatal ("the exit status before execution is "
                    "pvm_exit_status_being_executed: "
                    "you may have exited the last evaluation "
                    "through longjmp, or reused the same VM "
                    "state for a new execution with a previous "
                    "execution still in progress.");

    default:
      jitter_fatal ("invalid exit state %i",
                    (int) _JITTER_STATE_BACKING_FIELD (exit_status));
    }

  /* Here is the actual *executor* initialization, to be run before
     actually running the code. */

/* Selectively suppress suprious -Wmaybe-uninitialized .
   The indirect jump hack I use in profiling mode in order to
   have a large gap inside a function introduced by assembler without
   being restricted by jump offset limits (intentionally) tricks GCC
   into believing that the indirect jump may reach any instruction label;
   GCC would then warn that some locals might be used uninitialized,
   by skipping over their initialization.  This however is not possible,
   and I want to selectively silence the warning for the variables in
   question. */
//#pragma GCC diagnostic push
//#pragma GCC diagnostic ignored "-Wmaybe-uninitialized"

  /* Wrap functions and globals used within VM instructions, if needed.
     This is a trick to keep instructions readable while avoiding PC-relative
     addressing, which would mess up replicated code. */
#ifdef JITTER_REPLICATE

  /* Protect the C globals used in VM instructions so that they are always
     referred thru a pointer (from a register or the stack) set in the
     non-replicated part.  This is necessary on architectures where I can't
     force global references to pass thru a GOT.
     [FIXME: possibly don't do this on architectures that don't need it.] */

  typeof (pvm_states) * volatile _my_volatile_pointer_to_pvm_states = & pvm_states;
  typeof (pvm_states) * const restrict _my_pointer_to_pvm_states __attribute__ ((unused))
     = _my_volatile_pointer_to_pvm_states;
# undef pvm_states
# define pvm_states (* _my_pointer_to_pvm_states)

  typeof (pvm_exception_names) * volatile _my_volatile_pointer_to_pvm_exception_names = & pvm_exception_names;
  typeof (pvm_exception_names) * const restrict _my_pointer_to_pvm_exception_names __attribute__ ((unused))
     = _my_volatile_pointer_to_pvm_exception_names;
# undef pvm_exception_names
# define pvm_exception_names (* _my_pointer_to_pvm_exception_names)

  typeof (libpoke_term_if) * volatile _my_volatile_pointer_to_libpoke_term_if = & libpoke_term_if;
  typeof (libpoke_term_if) * const restrict _my_pointer_to_libpoke_term_if __attribute__ ((unused))
     = _my_volatile_pointer_to_libpoke_term_if;
# undef libpoke_term_if
# define libpoke_term_if (* _my_pointer_to_libpoke_term_if)

  typeof (pvm_literal_dispatch_name) * volatile _my_volatile_pointer_to_pvm_literal_dispatch_name = & pvm_literal_dispatch_name;
  typeof (pvm_literal_dispatch_name) * const restrict _my_pointer_to_pvm_literal_dispatch_name __attribute__ ((unused))
     = _my_volatile_pointer_to_pvm_literal_dispatch_name;
# undef pvm_literal_dispatch_name
# define pvm_literal_dispatch_name (* _my_pointer_to_pvm_literal_dispatch_name)

  typeof (pvm_literal_formatf_styles) * volatile _my_volatile_pointer_to_pvm_literal_formatf_styles = & pvm_literal_formatf_styles;
  typeof (pvm_literal_formatf_styles) * const restrict _my_pointer_to_pvm_literal_formatf_styles __attribute__ ((unused))
     = _my_volatile_pointer_to_pvm_literal_formatf_styles;
# undef pvm_literal_formatf_styles
# define pvm_literal_formatf_styles (* _my_pointer_to_pvm_literal_formatf_styles)

  typeof (pvm_literal_formatf_fmt) * volatile _my_volatile_pointer_to_pvm_literal_formatf_fmt = & pvm_literal_formatf_fmt;
  typeof (pvm_literal_formatf_fmt) * const restrict _my_pointer_to_pvm_literal_formatf_fmt __attribute__ ((unused))
     = _my_volatile_pointer_to_pvm_literal_formatf_fmt;
# undef pvm_literal_formatf_fmt
# define pvm_literal_formatf_fmt (* _my_pointer_to_pvm_literal_formatf_fmt)

  typeof (pvm_literal_newline) * volatile _my_volatile_pointer_to_pvm_literal_newline = & pvm_literal_newline;
  typeof (pvm_literal_newline) * const restrict _my_pointer_to_pvm_literal_newline __attribute__ ((unused))
     = _my_volatile_pointer_to_pvm_literal_newline;
# undef pvm_literal_newline
# define pvm_literal_newline (* _my_pointer_to_pvm_literal_newline)

  typeof (pvm_literal_notmappable) * volatile _my_volatile_pointer_to_pvm_literal_notmappable = & pvm_literal_notmappable;
  typeof (pvm_literal_notmappable) * const restrict _my_pointer_to_pvm_literal_notmappable __attribute__ ((unused))
     = _my_volatile_pointer_to_pvm_literal_notmappable;
# undef pvm_literal_notmappable
# define pvm_literal_notmappable (* _my_pointer_to_pvm_literal_notmappable)

  typeof (pvm_literal_eindex) * volatile _my_volatile_pointer_to_pvm_literal_eindex = & pvm_literal_eindex;
  typeof (pvm_literal_eindex) * const restrict _my_pointer_to_pvm_literal_eindex __attribute__ ((unused))
     = _my_volatile_pointer_to_pvm_literal_eindex;
# undef pvm_literal_eindex
# define pvm_literal_eindex (* _my_pointer_to_pvm_literal_eindex)

  typeof (pvm_literal_no_toplevel_var) * volatile _my_volatile_pointer_to_pvm_literal_no_toplevel_var = & pvm_literal_no_toplevel_var;
  typeof (pvm_literal_no_toplevel_var) * const restrict _my_pointer_to_pvm_literal_no_toplevel_var __attribute__ ((unused))
     = _my_volatile_pointer_to_pvm_literal_no_toplevel_var;
# undef pvm_literal_no_toplevel_var
# define pvm_literal_no_toplevel_var (* _my_pointer_to_pvm_literal_no_toplevel_var)

  typeof (pvm_literal_enomem) * volatile _my_volatile_pointer_to_pvm_literal_enomem = & pvm_literal_enomem;
  typeof (pvm_literal_enomem) * const restrict _my_pointer_to_pvm_literal_enomem __attribute__ ((unused))
     = _my_volatile_pointer_to_pvm_literal_enomem;
# undef pvm_literal_enomem
# define pvm_literal_enomem (* _my_pointer_to_pvm_literal_enomem)

  typeof (pvm_literal_code) * volatile _my_volatile_pointer_to_pvm_literal_code = & pvm_literal_code;
  typeof (pvm_literal_code) * const restrict _my_pointer_to_pvm_literal_code __attribute__ ((unused))
     = _my_volatile_pointer_to_pvm_literal_code;
# undef pvm_literal_code
# define pvm_literal_code (* _my_pointer_to_pvm_literal_code)

  typeof (pvm_literal_c) * volatile _my_volatile_pointer_to_pvm_literal_c = & pvm_literal_c;
  typeof (pvm_literal_c) * const restrict _my_pointer_to_pvm_literal_c __attribute__ ((unused))
     = _my_volatile_pointer_to_pvm_literal_c;
# undef pvm_literal_c
# define pvm_literal_c (* _my_pointer_to_pvm_literal_c)

  typeof (pvm_literal_empty) * volatile _my_volatile_pointer_to_pvm_literal_empty = & pvm_literal_empty;
  typeof (pvm_literal_empty) * const restrict _my_pointer_to_pvm_literal_empty __attribute__ ((unused))
     = _my_volatile_pointer_to_pvm_literal_empty;
# undef pvm_literal_empty
# define pvm_literal_empty (* _my_pointer_to_pvm_literal_empty)

  /* Similarly, wrap the C functions used in VM instructions, so that they are
     always called thru a function pointer.  This is necessary on architectures
     where call instructions represent the callee as a PC-relative address.
     Unfortunately C has a special quirky syntax for function pointers, so I
     can't just use the code above.  [FIXME: don't do this on architectures
     that don't need it.] */
  typeof (pvm_popcount) * volatile _jitter_my_volatile_pointer_to_pvm_popcount = & pvm_popcount;
  typeof (pvm_popcount) * const _jitter_my_pvm_popcount __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_popcount;
# undef pvm_popcount
# define pvm_popcount(...)  \
  JITTER_CALL_C (_jitter_my_pvm_popcount, __VA_ARGS__)
  typeof (pvm_stod) * volatile _jitter_my_volatile_pointer_to_pvm_stod = & pvm_stod;
  typeof (pvm_stod) * const _jitter_my_pvm_stod __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_stod;
# undef pvm_stod
# define pvm_stod(...)  \
  JITTER_CALL_C (_jitter_my_pvm_stod, __VA_ARGS__)
  typeof (pvm_stof) * volatile _jitter_my_volatile_pointer_to_pvm_stof = & pvm_stof;
  typeof (pvm_stof) * const _jitter_my_pvm_stof __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_stof;
# undef pvm_stof
# define pvm_stof(...)  \
  JITTER_CALL_C (_jitter_my_pvm_stof, __VA_ARGS__)
  typeof (pvm_snprintf) * volatile _jitter_my_volatile_pointer_to_pvm_snprintf = & pvm_snprintf;
  typeof (pvm_snprintf) * const _jitter_my_pvm_snprintf __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_snprintf;
# undef pvm_snprintf
# define pvm_snprintf(...)  \
  JITTER_CALL_C (_jitter_my_pvm_snprintf, __VA_ARGS__)
  typeof (pvm_nanosleep) * volatile _jitter_my_volatile_pointer_to_pvm_nanosleep = & pvm_nanosleep;
  typeof (pvm_nanosleep) * const _jitter_my_pvm_nanosleep __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_nanosleep;
# undef pvm_nanosleep
# define pvm_nanosleep(...)  \
  JITTER_CALL_C (_jitter_my_pvm_nanosleep, __VA_ARGS__)
  typeof (pvm_strcat) * volatile _jitter_my_volatile_pointer_to_pvm_strcat = & pvm_strcat;
  typeof (pvm_strcat) * const _jitter_my_pvm_strcat __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_strcat;
# undef pvm_strcat
# define pvm_strcat(...)  \
  JITTER_CALL_C (_jitter_my_pvm_strcat, __VA_ARGS__)
  typeof (pvm_strncpy) * volatile _jitter_my_volatile_pointer_to_pvm_strncpy = & pvm_strncpy;
  typeof (pvm_strncpy) * const _jitter_my_pvm_strncpy __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_strncpy;
# undef pvm_strncpy
# define pvm_strncpy(...)  \
  JITTER_CALL_C (_jitter_my_pvm_strncpy, __VA_ARGS__)
  typeof (pvm_strcpy) * volatile _jitter_my_volatile_pointer_to_pvm_strcpy = & pvm_strcpy;
  typeof (pvm_strcpy) * const _jitter_my_pvm_strcpy __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_strcpy;
# undef pvm_strcpy
# define pvm_strcpy(...)  \
  JITTER_CALL_C (_jitter_my_pvm_strcpy, __VA_ARGS__)
  typeof (pvm_strcmp) * volatile _jitter_my_volatile_pointer_to_pvm_strcmp = & pvm_strcmp;
  typeof (pvm_strcmp) * const _jitter_my_pvm_strcmp __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_strcmp;
# undef pvm_strcmp
# define pvm_strcmp(...)  \
  JITTER_CALL_C (_jitter_my_pvm_strcmp, __VA_ARGS__)
  typeof (pvm_strlen) * volatile _jitter_my_volatile_pointer_to_pvm_strlen = & pvm_strlen;
  typeof (pvm_strlen) * const _jitter_my_pvm_strlen __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_strlen;
# undef pvm_strlen
# define pvm_strlen(...)  \
  JITTER_CALL_C (_jitter_my_pvm_strlen, __VA_ARGS__)
  typeof (pvm_memcpy) * volatile _jitter_my_volatile_pointer_to_pvm_memcpy = & pvm_memcpy;
  typeof (pvm_memcpy) * const _jitter_my_pvm_memcpy __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_memcpy;
# undef pvm_memcpy
# define pvm_memcpy(...)  \
  JITTER_CALL_C (_jitter_my_pvm_memcpy, __VA_ARGS__)
  typeof (pvm_asprintf) * volatile _jitter_my_volatile_pointer_to_pvm_asprintf = & pvm_asprintf;
  typeof (pvm_asprintf) * const _jitter_my_pvm_asprintf __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_asprintf;
# undef pvm_asprintf
# define pvm_asprintf(...)  \
  JITTER_CALL_C (_jitter_my_pvm_asprintf, __VA_ARGS__)
  typeof (pvm_gettime) * volatile _jitter_my_volatile_pointer_to_pvm_gettime = & pvm_gettime;
  typeof (pvm_gettime) * const _jitter_my_pvm_gettime __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_gettime;
# undef pvm_gettime
# define pvm_gettime(...)  \
  JITTER_CALL_C (_jitter_my_pvm_gettime, __VA_ARGS__)
  typeof (pvm_secure_getenv) * volatile _jitter_my_volatile_pointer_to_pvm_secure_getenv = & pvm_secure_getenv;
  typeof (pvm_secure_getenv) * const _jitter_my_pvm_secure_getenv __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_secure_getenv;
# undef pvm_secure_getenv
# define pvm_secure_getenv(...)  \
  JITTER_CALL_C (_jitter_my_pvm_secure_getenv, __VA_ARGS__)
  typeof (pvm_srandom) * volatile _jitter_my_volatile_pointer_to_pvm_srandom = & pvm_srandom;
  typeof (pvm_srandom) * const _jitter_my_pvm_srandom __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_srandom;
# undef pvm_srandom
# define pvm_srandom(...)  \
  JITTER_CALL_C (_jitter_my_pvm_srandom, __VA_ARGS__)
  typeof (pvm_random) * volatile _jitter_my_volatile_pointer_to_pvm_random = & pvm_random;
  typeof (pvm_random) * const _jitter_my_pvm_random __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_random;
# undef pvm_random
# define pvm_random(...)  \
  JITTER_CALL_C (_jitter_my_pvm_random, __VA_ARGS__)
  typeof (ios_set_cur) * volatile _jitter_my_volatile_pointer_to_ios_set_cur = & ios_set_cur;
  typeof (ios_set_cur) * const _jitter_my_ios_set_cur __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_set_cur;
# undef ios_set_cur
# define ios_set_cur(...)  \
  JITTER_CALL_C (_jitter_my_ios_set_cur, __VA_ARGS__)
  typeof (ios_get_dev_if_name) * volatile _jitter_my_volatile_pointer_to_ios_get_dev_if_name = & ios_get_dev_if_name;
  typeof (ios_get_dev_if_name) * const _jitter_my_ios_get_dev_if_name __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_get_dev_if_name;
# undef ios_get_dev_if_name
# define ios_get_dev_if_name(...)  \
  JITTER_CALL_C (_jitter_my_ios_get_dev_if_name, __VA_ARGS__)
  typeof (ios_get_bias) * volatile _jitter_my_volatile_pointer_to_ios_get_bias = & ios_get_bias;
  typeof (ios_get_bias) * const _jitter_my_ios_get_bias __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_get_bias;
# undef ios_get_bias
# define ios_get_bias(...)  \
  JITTER_CALL_C (_jitter_my_ios_get_bias, __VA_ARGS__)
  typeof (ios_set_bias) * volatile _jitter_my_volatile_pointer_to_ios_set_bias = & ios_set_bias;
  typeof (ios_set_bias) * const _jitter_my_ios_set_bias __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_set_bias;
# undef ios_set_bias
# define ios_set_bias(...)  \
  JITTER_CALL_C (_jitter_my_ios_set_bias, __VA_ARGS__)
  typeof (ios_search_by_id) * volatile _jitter_my_volatile_pointer_to_ios_search_by_id = & ios_search_by_id;
  typeof (ios_search_by_id) * const _jitter_my_ios_search_by_id __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_search_by_id;
# undef ios_search_by_id
# define ios_search_by_id(...)  \
  JITTER_CALL_C (_jitter_my_ios_search_by_id, __VA_ARGS__)
  typeof (ios_write_uint) * volatile _jitter_my_volatile_pointer_to_ios_write_uint = & ios_write_uint;
  typeof (ios_write_uint) * const _jitter_my_ios_write_uint __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_write_uint;
# undef ios_write_uint
# define ios_write_uint(...)  \
  JITTER_CALL_C (_jitter_my_ios_write_uint, __VA_ARGS__)
  typeof (ios_write_int) * volatile _jitter_my_volatile_pointer_to_ios_write_int = & ios_write_int;
  typeof (ios_write_int) * const _jitter_my_ios_write_int __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_write_int;
# undef ios_write_int
# define ios_write_int(...)  \
  JITTER_CALL_C (_jitter_my_ios_write_int, __VA_ARGS__)
  typeof (ios_read_uint) * volatile _jitter_my_volatile_pointer_to_ios_read_uint = & ios_read_uint;
  typeof (ios_read_uint) * const _jitter_my_ios_read_uint __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_read_uint;
# undef ios_read_uint
# define ios_read_uint(...)  \
  JITTER_CALL_C (_jitter_my_ios_read_uint, __VA_ARGS__)
  typeof (ios_read_int) * volatile _jitter_my_volatile_pointer_to_ios_read_int = & ios_read_int;
  typeof (ios_read_int) * const _jitter_my_ios_read_int __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_read_int;
# undef ios_read_int
# define ios_read_int(...)  \
  JITTER_CALL_C (_jitter_my_ios_read_int, __VA_ARGS__)
  typeof (ios_open) * volatile _jitter_my_volatile_pointer_to_ios_open = & ios_open;
  typeof (ios_open) * const _jitter_my_ios_open __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_open;
# undef ios_open
# define ios_open(...)  \
  JITTER_CALL_C (_jitter_my_ios_open, __VA_ARGS__)
  typeof (ios_volatile_p) * volatile _jitter_my_volatile_pointer_to_ios_volatile_p = & ios_volatile_p;
  typeof (ios_volatile_p) * const _jitter_my_ios_volatile_p __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_volatile_p;
# undef ios_volatile_p
# define ios_volatile_p(...)  \
  JITTER_CALL_C (_jitter_my_ios_volatile_p, __VA_ARGS__)
  typeof (ios_size) * volatile _jitter_my_volatile_pointer_to_ios_size = & ios_size;
  typeof (ios_size) * const _jitter_my_ios_size __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_size;
# undef ios_size
# define ios_size(...)  \
  JITTER_CALL_C (_jitter_my_ios_size, __VA_ARGS__)
  typeof (ios_handler) * volatile _jitter_my_volatile_pointer_to_ios_handler = & ios_handler;
  typeof (ios_handler) * const _jitter_my_ios_handler __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_handler;
# undef ios_handler
# define ios_handler(...)  \
  JITTER_CALL_C (_jitter_my_ios_handler, __VA_ARGS__)
  typeof (ios_map) * volatile _jitter_my_volatile_pointer_to_ios_map = & ios_map;
  typeof (ios_map) * const _jitter_my_ios_map __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_map;
# undef ios_map
# define ios_map(...)  \
  JITTER_CALL_C (_jitter_my_ios_map, __VA_ARGS__)
  typeof (ios_get_id) * volatile _jitter_my_volatile_pointer_to_ios_get_id = & ios_get_id;
  typeof (ios_get_id) * const _jitter_my_ios_get_id __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_get_id;
# undef ios_get_id
# define ios_get_id(...)  \
  JITTER_CALL_C (_jitter_my_ios_get_id, __VA_ARGS__)
  typeof (ios_flush) * volatile _jitter_my_volatile_pointer_to_ios_flush = & ios_flush;
  typeof (ios_flush) * const _jitter_my_ios_flush __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_flush;
# undef ios_flush
# define ios_flush(...)  \
  JITTER_CALL_C (_jitter_my_ios_flush, __VA_ARGS__)
  typeof (ios_flags) * volatile _jitter_my_volatile_pointer_to_ios_flags = & ios_flags;
  typeof (ios_flags) * const _jitter_my_ios_flags __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_flags;
# undef ios_flags
# define ios_flags(...)  \
  JITTER_CALL_C (_jitter_my_ios_flags, __VA_ARGS__)
  typeof (ios_cur) * volatile _jitter_my_volatile_pointer_to_ios_cur = & ios_cur;
  typeof (ios_cur) * const _jitter_my_ios_cur __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_cur;
# undef ios_cur
# define ios_cur(...)  \
  JITTER_CALL_C (_jitter_my_ios_cur, __VA_ARGS__)
  typeof (ios_close) * volatile _jitter_my_volatile_pointer_to_ios_close = & ios_close;
  typeof (ios_close) * const _jitter_my_ios_close __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_ios_close;
# undef ios_close
# define ios_close(...)  \
  JITTER_CALL_C (_jitter_my_ios_close, __VA_ARGS__)
  typeof (pvm_sizeof) * volatile _jitter_my_volatile_pointer_to_pvm_sizeof = & pvm_sizeof;
  typeof (pvm_sizeof) * const _jitter_my_pvm_sizeof __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_sizeof;
# undef pvm_sizeof
# define pvm_sizeof(...)  \
  JITTER_CALL_C (_jitter_my_pvm_sizeof, __VA_ARGS__)
  typeof (pvm_refo_struct) * volatile _jitter_my_volatile_pointer_to_pvm_refo_struct = & pvm_refo_struct;
  typeof (pvm_refo_struct) * const _jitter_my_pvm_refo_struct __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_refo_struct;
# undef pvm_refo_struct
# define pvm_refo_struct(...)  \
  JITTER_CALL_C (_jitter_my_pvm_refo_struct, __VA_ARGS__)
  typeof (pvm_print_val_with_params) * volatile _jitter_my_volatile_pointer_to_pvm_print_val_with_params = & pvm_print_val_with_params;
  typeof (pvm_print_val_with_params) * const _jitter_my_pvm_print_val_with_params __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_print_val_with_params;
# undef pvm_print_val_with_params
# define pvm_print_val_with_params(...)  \
  JITTER_CALL_C (_jitter_my_pvm_print_val_with_params, __VA_ARGS__)
  typeof (pvm_print_string) * volatile _jitter_my_volatile_pointer_to_pvm_print_string = & pvm_print_string;
  typeof (pvm_print_string) * const _jitter_my_pvm_print_string __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_print_string;
# undef pvm_print_string
# define pvm_print_string(...)  \
  JITTER_CALL_C (_jitter_my_pvm_print_string, __VA_ARGS__)
  typeof (pvm_val_writer) * volatile _jitter_my_volatile_pointer_to_pvm_val_writer = & pvm_val_writer;
  typeof (pvm_val_writer) * const _jitter_my_pvm_val_writer __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_val_writer;
# undef pvm_val_writer
# define pvm_val_writer(...)  \
  JITTER_CALL_C (_jitter_my_pvm_val_writer, __VA_ARGS__)
  typeof (pvm_make_cls) * volatile _jitter_my_volatile_pointer_to_pvm_make_cls = & pvm_make_cls;
  typeof (pvm_make_cls) * const _jitter_my_pvm_make_cls __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_cls;
# undef pvm_make_cls
# define pvm_make_cls(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_cls, __VA_ARGS__)
  typeof (pvm_make_void_type) * volatile _jitter_my_volatile_pointer_to_pvm_make_void_type = & pvm_make_void_type;
  typeof (pvm_make_void_type) * const _jitter_my_pvm_make_void_type __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_void_type;
# undef pvm_make_void_type
# define pvm_make_void_type(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_void_type, __VA_ARGS__)
  typeof (pvm_make_closure_type) * volatile _jitter_my_volatile_pointer_to_pvm_make_closure_type = & pvm_make_closure_type;
  typeof (pvm_make_closure_type) * const _jitter_my_pvm_make_closure_type __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_closure_type;
# undef pvm_make_closure_type
# define pvm_make_closure_type(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_closure_type, __VA_ARGS__)
  typeof (pvm_get_struct_method) * volatile _jitter_my_volatile_pointer_to_pvm_get_struct_method = & pvm_get_struct_method;
  typeof (pvm_get_struct_method) * const _jitter_my_pvm_get_struct_method __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_get_struct_method;
# undef pvm_get_struct_method
# define pvm_get_struct_method(...)  \
  JITTER_CALL_C (_jitter_my_pvm_get_struct_method, __VA_ARGS__)
  typeof (pvm_env_set_var) * volatile _jitter_my_volatile_pointer_to_pvm_env_set_var = & pvm_env_set_var;
  typeof (pvm_env_set_var) * const _jitter_my_pvm_env_set_var __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_env_set_var;
# undef pvm_env_set_var
# define pvm_env_set_var(...)  \
  JITTER_CALL_C (_jitter_my_pvm_env_set_var, __VA_ARGS__)
  typeof (pvm_array_rem) * volatile _jitter_my_volatile_pointer_to_pvm_array_rem = & pvm_array_rem;
  typeof (pvm_array_rem) * const _jitter_my_pvm_array_rem __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_array_rem;
# undef pvm_array_rem
# define pvm_array_rem(...)  \
  JITTER_CALL_C (_jitter_my_pvm_array_rem, __VA_ARGS__)
  typeof (pvm_elemsof) * volatile _jitter_my_volatile_pointer_to_pvm_elemsof = & pvm_elemsof;
  typeof (pvm_elemsof) * const _jitter_my_pvm_elemsof __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_elemsof;
# undef pvm_elemsof
# define pvm_elemsof(...)  \
  JITTER_CALL_C (_jitter_my_pvm_elemsof, __VA_ARGS__)
  typeof (pvm_allocate_closure_attrs) * volatile _jitter_my_volatile_pointer_to_pvm_allocate_closure_attrs = & pvm_allocate_closure_attrs;
  typeof (pvm_allocate_closure_attrs) * const _jitter_my_pvm_allocate_closure_attrs __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_allocate_closure_attrs;
# undef pvm_allocate_closure_attrs
# define pvm_allocate_closure_attrs(...)  \
  JITTER_CALL_C (_jitter_my_pvm_allocate_closure_attrs, __VA_ARGS__)
  typeof (pvm_val_ureloc) * volatile _jitter_my_volatile_pointer_to_pvm_val_ureloc = & pvm_val_ureloc;
  typeof (pvm_val_ureloc) * const _jitter_my_pvm_val_ureloc __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_val_ureloc;
# undef pvm_val_ureloc
# define pvm_val_ureloc(...)  \
  JITTER_CALL_C (_jitter_my_pvm_val_ureloc, __VA_ARGS__)
  typeof (pvm_val_unmap) * volatile _jitter_my_volatile_pointer_to_pvm_val_unmap = & pvm_val_unmap;
  typeof (pvm_val_unmap) * const _jitter_my_pvm_val_unmap __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_val_unmap;
# undef pvm_val_unmap
# define pvm_val_unmap(...)  \
  JITTER_CALL_C (_jitter_my_pvm_val_unmap, __VA_ARGS__)
  typeof (pvm_val_reloc) * volatile _jitter_my_volatile_pointer_to_pvm_val_reloc = & pvm_val_reloc;
  typeof (pvm_val_reloc) * const _jitter_my_pvm_val_reloc __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_val_reloc;
# undef pvm_val_reloc
# define pvm_val_reloc(...)  \
  JITTER_CALL_C (_jitter_my_pvm_val_reloc, __VA_ARGS__)
  typeof (pvm_set_struct) * volatile _jitter_my_volatile_pointer_to_pvm_set_struct = & pvm_set_struct;
  typeof (pvm_set_struct) * const _jitter_my_pvm_set_struct __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_set_struct;
# undef pvm_set_struct
# define pvm_set_struct(...)  \
  JITTER_CALL_C (_jitter_my_pvm_set_struct, __VA_ARGS__)
  typeof (pvm_ref_struct_cstr) * volatile _jitter_my_volatile_pointer_to_pvm_ref_struct_cstr = & pvm_ref_struct_cstr;
  typeof (pvm_ref_struct_cstr) * const _jitter_my_pvm_ref_struct_cstr __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_ref_struct_cstr;
# undef pvm_ref_struct_cstr
# define pvm_ref_struct_cstr(...)  \
  JITTER_CALL_C (_jitter_my_pvm_ref_struct_cstr, __VA_ARGS__)
  typeof (pvm_ref_struct) * volatile _jitter_my_volatile_pointer_to_pvm_ref_struct = & pvm_ref_struct;
  typeof (pvm_ref_struct) * const _jitter_my_pvm_ref_struct __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_ref_struct;
# undef pvm_ref_struct
# define pvm_ref_struct(...)  \
  JITTER_CALL_C (_jitter_my_pvm_ref_struct, __VA_ARGS__)
  typeof (pvm_type_equal_p) * volatile _jitter_my_volatile_pointer_to_pvm_type_equal_p = & pvm_type_equal_p;
  typeof (pvm_type_equal_p) * const _jitter_my_pvm_type_equal_p __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_type_equal_p;
# undef pvm_type_equal_p
# define pvm_type_equal_p(...)  \
  JITTER_CALL_C (_jitter_my_pvm_type_equal_p, __VA_ARGS__)
  typeof (pvm_typeof) * volatile _jitter_my_volatile_pointer_to_pvm_typeof = & pvm_typeof;
  typeof (pvm_typeof) * const _jitter_my_pvm_typeof __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_typeof;
# undef pvm_typeof
# define pvm_typeof(...)  \
  JITTER_CALL_C (_jitter_my_pvm_typeof, __VA_ARGS__)
  typeof (pvm_make_struct_type) * volatile _jitter_my_volatile_pointer_to_pvm_make_struct_type = & pvm_make_struct_type;
  typeof (pvm_make_struct_type) * const _jitter_my_pvm_make_struct_type __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_struct_type;
# undef pvm_make_struct_type
# define pvm_make_struct_type(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_struct_type, __VA_ARGS__)
  typeof (pvm_allocate_struct_attrs) * volatile _jitter_my_volatile_pointer_to_pvm_allocate_struct_attrs = & pvm_allocate_struct_attrs;
  typeof (pvm_allocate_struct_attrs) * const _jitter_my_pvm_allocate_struct_attrs __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_allocate_struct_attrs;
# undef pvm_allocate_struct_attrs
# define pvm_allocate_struct_attrs(...)  \
  JITTER_CALL_C (_jitter_my_pvm_allocate_struct_attrs, __VA_ARGS__)
  typeof (pvm_alloc_gc) * volatile _jitter_my_volatile_pointer_to_pvm_alloc_gc = & pvm_alloc_gc;
  typeof (pvm_alloc_gc) * const _jitter_my_pvm_alloc_gc __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_alloc_gc;
# undef pvm_alloc_gc
# define pvm_alloc_gc(...)  \
  JITTER_CALL_C (_jitter_my_pvm_alloc_gc, __VA_ARGS__)
  typeof (pvm_alloc) * volatile _jitter_my_volatile_pointer_to_pvm_alloc = & pvm_alloc;
  typeof (pvm_alloc) * const _jitter_my_pvm_alloc __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_alloc;
# undef pvm_alloc
# define pvm_alloc(...)  \
  JITTER_CALL_C (_jitter_my_pvm_alloc, __VA_ARGS__)
  typeof (pk_format_binary) * volatile _jitter_my_volatile_pointer_to_pk_format_binary = & pk_format_binary;
  typeof (pk_format_binary) * const _jitter_my_pk_format_binary __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pk_format_binary;
# undef pk_format_binary
# define pk_format_binary(...)  \
  JITTER_CALL_C (_jitter_my_pk_format_binary, __VA_ARGS__)
  typeof (pk_upow) * volatile _jitter_my_volatile_pointer_to_pk_upow = & pk_upow;
  typeof (pk_upow) * const _jitter_my_pk_upow __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pk_upow;
# undef pk_upow
# define pk_upow(...)  \
  JITTER_CALL_C (_jitter_my_pk_upow, __VA_ARGS__)
  typeof (pvm_make_array_type) * volatile _jitter_my_volatile_pointer_to_pvm_make_array_type = & pvm_make_array_type;
  typeof (pvm_make_array_type) * const _jitter_my_pvm_make_array_type __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_array_type;
# undef pvm_make_array_type
# define pvm_make_array_type(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_array_type, __VA_ARGS__)
  typeof (pvm_make_offset_type) * volatile _jitter_my_volatile_pointer_to_pvm_make_offset_type = & pvm_make_offset_type;
  typeof (pvm_make_offset_type) * const _jitter_my_pvm_make_offset_type __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_offset_type;
# undef pvm_make_offset_type
# define pvm_make_offset_type(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_offset_type, __VA_ARGS__)
  typeof (pvm_make_string_type) * volatile _jitter_my_volatile_pointer_to_pvm_make_string_type = & pvm_make_string_type;
  typeof (pvm_make_string_type) * const _jitter_my_pvm_make_string_type __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_string_type;
# undef pvm_make_string_type
# define pvm_make_string_type(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_string_type, __VA_ARGS__)
  typeof (pvm_make_integral_type) * volatile _jitter_my_volatile_pointer_to_pvm_make_integral_type = & pvm_make_integral_type;
  typeof (pvm_make_integral_type) * const _jitter_my_pvm_make_integral_type __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_integral_type;
# undef pvm_make_integral_type
# define pvm_make_integral_type(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_integral_type, __VA_ARGS__)
  typeof (pvm_make_exception) * volatile _jitter_my_volatile_pointer_to_pvm_make_exception = & pvm_make_exception;
  typeof (pvm_make_exception) * const _jitter_my_pvm_make_exception __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_exception;
# undef pvm_make_exception
# define pvm_make_exception(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_exception, __VA_ARGS__)
  typeof (pvm_make_ulong) * volatile _jitter_my_volatile_pointer_to_pvm_make_ulong = & pvm_make_ulong;
  typeof (pvm_make_ulong) * const _jitter_my_pvm_make_ulong __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_ulong;
# undef pvm_make_ulong
# define pvm_make_ulong(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_ulong, __VA_ARGS__)
  typeof (pvm_make_long) * volatile _jitter_my_volatile_pointer_to_pvm_make_long = & pvm_make_long;
  typeof (pvm_make_long) * const _jitter_my_pvm_make_long __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_long;
# undef pvm_make_long
# define pvm_make_long(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_long, __VA_ARGS__)
  typeof (pvm_make_uint) * volatile _jitter_my_volatile_pointer_to_pvm_make_uint = & pvm_make_uint;
  typeof (pvm_make_uint) * const _jitter_my_pvm_make_uint __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_uint;
# undef pvm_make_uint
# define pvm_make_uint(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_uint, __VA_ARGS__)
  typeof (pvm_make_int) * volatile _jitter_my_volatile_pointer_to_pvm_make_int = & pvm_make_int;
  typeof (pvm_make_int) * const _jitter_my_pvm_make_int __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_int;
# undef pvm_make_int
# define pvm_make_int(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_int, __VA_ARGS__)
  typeof (pvm_make_offset) * volatile _jitter_my_volatile_pointer_to_pvm_make_offset = & pvm_make_offset;
  typeof (pvm_make_offset) * const _jitter_my_pvm_make_offset __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_offset;
# undef pvm_make_offset
# define pvm_make_offset(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_offset, __VA_ARGS__)
  typeof (pvm_make_struct) * volatile _jitter_my_volatile_pointer_to_pvm_make_struct = & pvm_make_struct;
  typeof (pvm_make_struct) * const _jitter_my_pvm_make_struct __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_struct;
# undef pvm_make_struct
# define pvm_make_struct(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_struct, __VA_ARGS__)
  typeof (pvm_make_array) * volatile _jitter_my_volatile_pointer_to_pvm_make_array = & pvm_make_array;
  typeof (pvm_make_array) * const _jitter_my_pvm_make_array __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_array;
# undef pvm_make_array
# define pvm_make_array(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_array, __VA_ARGS__)
  typeof (pvm_make_string_nodup) * volatile _jitter_my_volatile_pointer_to_pvm_make_string_nodup = & pvm_make_string_nodup;
  typeof (pvm_make_string_nodup) * const _jitter_my_pvm_make_string_nodup __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_string_nodup;
# undef pvm_make_string_nodup
# define pvm_make_string_nodup(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_string_nodup, __VA_ARGS__)
  typeof (pvm_make_string) * volatile _jitter_my_volatile_pointer_to_pvm_make_string = & pvm_make_string;
  typeof (pvm_make_string) * const _jitter_my_pvm_make_string __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_make_string;
# undef pvm_make_string
# define pvm_make_string(...)  \
  JITTER_CALL_C (_jitter_my_pvm_make_string, __VA_ARGS__)
  typeof (pvm_env_toplevel) * volatile _jitter_my_volatile_pointer_to_pvm_env_toplevel = & pvm_env_toplevel;
  typeof (pvm_env_toplevel) * const _jitter_my_pvm_env_toplevel __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_env_toplevel;
# undef pvm_env_toplevel
# define pvm_env_toplevel(...)  \
  JITTER_CALL_C (_jitter_my_pvm_env_toplevel, __VA_ARGS__)
  typeof (pvm_env_push_frame) * volatile _jitter_my_volatile_pointer_to_pvm_env_push_frame = & pvm_env_push_frame;
  typeof (pvm_env_push_frame) * const _jitter_my_pvm_env_push_frame __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_env_push_frame;
# undef pvm_env_push_frame
# define pvm_env_push_frame(...)  \
  JITTER_CALL_C (_jitter_my_pvm_env_push_frame, __VA_ARGS__)
  typeof (pvm_env_pop_frame) * volatile _jitter_my_volatile_pointer_to_pvm_env_pop_frame = & pvm_env_pop_frame;
  typeof (pvm_env_pop_frame) * const _jitter_my_pvm_env_pop_frame __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_env_pop_frame;
# undef pvm_env_pop_frame
# define pvm_env_pop_frame(...)  \
  JITTER_CALL_C (_jitter_my_pvm_env_pop_frame, __VA_ARGS__)
  typeof (pvm_env_register) * volatile _jitter_my_volatile_pointer_to_pvm_env_register = & pvm_env_register;
  typeof (pvm_env_register) * const _jitter_my_pvm_env_register __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_env_register;
# undef pvm_env_register
# define pvm_env_register(...)  \
  JITTER_CALL_C (_jitter_my_pvm_env_register, __VA_ARGS__)
  typeof (pvm_env_lookup) * volatile _jitter_my_volatile_pointer_to_pvm_env_lookup = & pvm_env_lookup;
  typeof (pvm_env_lookup) * const _jitter_my_pvm_env_lookup __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_env_lookup;
# undef pvm_env_lookup
# define pvm_env_lookup(...)  \
  JITTER_CALL_C (_jitter_my_pvm_env_lookup, __VA_ARGS__)
  typeof (pvm_assert) * volatile _jitter_my_volatile_pointer_to_pvm_assert = & pvm_assert;
  typeof (pvm_assert) * const _jitter_my_pvm_assert __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_assert;
# undef pvm_assert
# define pvm_assert(...)  \
  JITTER_CALL_C (_jitter_my_pvm_assert, __VA_ARGS__)
  typeof (pvm_array_set) * volatile _jitter_my_volatile_pointer_to_pvm_array_set = & pvm_array_set;
  typeof (pvm_array_set) * const _jitter_my_pvm_array_set __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_array_set;
# undef pvm_array_set
# define pvm_array_set(...)  \
  JITTER_CALL_C (_jitter_my_pvm_array_set, __VA_ARGS__)
  typeof (pvm_array_insert) * volatile _jitter_my_volatile_pointer_to_pvm_array_insert = & pvm_array_insert;
  typeof (pvm_array_insert) * const _jitter_my_pvm_array_insert __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_array_insert;
# undef pvm_array_insert
# define pvm_array_insert(...)  \
  JITTER_CALL_C (_jitter_my_pvm_array_insert, __VA_ARGS__)
  typeof (pvm_free) * volatile _jitter_my_volatile_pointer_to_pvm_free = & pvm_free;
  typeof (pvm_free) * const _jitter_my_pvm_free __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_pvm_free;
# undef pvm_free
# define pvm_free(...)  \
  JITTER_CALL_C (_jitter_my_pvm_free, __VA_ARGS__)
/* See the comment above about spurious -Wmaybe-uninitialized warnings. */
//#pragma GCC diagnostic pop
#endif // #ifdef JITTER_REPLICATE


  /* Make an automatic struct holding a copy of the state whose pointer was given.
     The idea is that the copy should be in registers, as far as possible. */
  struct pvm_state_runtime jitter_state_runtime
    = jitter_original_state->_pvm_Vv9tlAxnoJ_state_runtime;

  /* Initialize a pointer to The Array base.  This pointer will be in a
     global register variable with no-threading dispatch, and with
     other dispatches in an automatic variable, still hopefully kept
     in a register. */
/* About the pragma, look for "-Wmaybe-uninitialized" in the comments above. FIXME: this is to avoid a GCC warning with profiling.  Check with profiling on. */
//#pragma GCC diagnostic push
//#pragma GCC diagnostic ignored "-Wmaybe-uninitialized"
#ifdef JITTER_DISPATCH_NO_THREADING
# define jitter_array_base pvm_array_base_register_variable
#else
  char * restrict jitter_array_base __attribute__ ((unused));
#endif // #ifdef JITTER_DISPATCH_NO_THREADING
//#pragma GCC diagnostic pop
  jitter_array_base
    = (((char *) jitter_original_state->pvm_state_backing.jitter_array)
       + JITTER_ARRAY_BIAS);

  /* Declare the instruction pointer from the thread array, unless the dispatch
     is no-threading, in which case no thread array even exists. */
  pvm_program_point jitter_ip = NULL; /* Invalidate to catch errors. */
#ifdef JITTER_REPLICATE
  /* Save an instruction address within this function, to jump to at VM exit
     time; that way we can be sure that at exit time we are back to
     non-replicated code, and stuff like PC-relative addressing work again
     without special tricks.  This variable may safely (and actually should,
     for performance) be kept on the stack.  We need it to be volatile to
     prevent the compiler from being too clever and jump to it using a
     PC-relative displacement from replicated code.   It must not be static,
     since non-automatic variables are problematic to access from replicated
     code, which might use PC-relative addressing. */
  volatile typeof (&& jitter_exit_vm_label) restrict
  jitter_saved_exit_non_replicated_code_pointer = &&jitter_exit_vm_label;
  JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(jitter_saved_exit_non_replicated_code_pointer);
#endif // #ifdef JITTER_REPLICATE


#ifdef JITTER_REPLICATE
  /* FIXME: comment. */
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(beghl__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(beghl__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(beghl__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(beghl__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(begsc__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(begsc__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(begsc__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(begsc__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(disas__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(disas__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(disas__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(disas__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(endhl__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(endhl__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(endhl__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(endhl__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(endsc__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(endsc__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(endsc__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(endsc__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(formati__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(formati__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(formati__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(formati__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(formatiu__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(formatiu__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(formatiu__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(formatiu__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(formatl__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(formatl__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(formatl__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(formatl__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(formatlu__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(formatlu__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(formatlu__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(formatlu__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printi__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(printi__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printi__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printi__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printiu__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(printiu__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printiu__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printiu__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printl__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(printl__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printl__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printl__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printlu__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(printlu__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printlu__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(printlu__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(prints__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(prints__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(prints__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(prints__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(rtrace__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(rtrace__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(rtrace__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(rtrace__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(strace__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(strace__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(strace__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(strace__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mains__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mains__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mains__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mains__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maref__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_maref__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maref__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_maref__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_marefo__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_marefo__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_marefo__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_marefo__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_marem__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_marem__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_marem__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_marem__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mba__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mba__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mba__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mba__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbn__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbn__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbn__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbn__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnn__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnn__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnn__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnn__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnzi__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnzi__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnzi__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnzi__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnziu__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnziu__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnziu__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnziu__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnzl__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnzl__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnzl__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnzl__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnzlu__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbnzlu__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnzlu__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbnzlu__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbzi__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbzi__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbzi__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbzi__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbziu__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbziu__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbziu__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbziu__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbzl__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbzl__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbzl__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbzl__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbzlu__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbzlu__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbzlu__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbzlu__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexit__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mexit__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexit__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexit__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexitvm__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mexitvm__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexitvm__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexitvm__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf32__n0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mformatf32__n0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf32__n0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf32__n0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf32__n1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mformatf32__n1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf32__n1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf32__n1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf32__n2__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mformatf32__n2__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf32__n2__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf32__n2__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf32__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mformatf32__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf32__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf32__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf64__n0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mformatf64__n0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf64__n0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf64__n0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf64__n1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mformatf64__n1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf64__n1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf64__n1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf64__n2__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mformatf64__n2__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf64__n2__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf64__n2__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf64__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mformatf64__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf64__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mformatf64__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprolog__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprolog__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprolog__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprolog__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mpushtopvar__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mpushtopvar__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mpushtopvar__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mpushtopvar__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mraise__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mraise__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mreloc__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mreloc__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mreloc__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mreloc__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mreturn__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mreturn__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mreturn__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mreturn__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msmodi__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msmodi__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msmodi__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msmodi__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msref__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msref__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msref__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msref__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefi__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msrefi__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefi__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefi__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefia__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msrefia__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefia__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefia__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefin__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msrefin__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefin__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefin__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefio__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msrefio__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefio__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefio__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefo__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msrefo__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefo__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msrefo__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msset__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msset__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msset__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msset__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msseti__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msseti__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msseti__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msseti__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mstrref__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mstrref__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mstrref__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mstrref__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mstrset__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mstrset__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mstrset__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mstrset__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubstr__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msubstr__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubstr__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msubstr__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msync__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_msync__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msync__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_msync__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_munreachable__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_munreachable__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_munreachable__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_munreachable__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mureloc__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mureloc__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mureloc__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mureloc__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mwrite__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mwrite__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mwrite__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mwrite__retR)));
#endif // #ifdef JITTER_REPLICATE

  /* Initialization C code from the user */
  /* End of the initialization C code from the user */


# if defined(JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined(JITTER_DISPATCH_NO_THREADING)
  /* Execute architecture-specific execution-beginning code, if any.
     Make sure it is safe to expand the macro without do..while
     (false), since the expansion may contain declarations of
     variables to be used later. */
  {}; JITTER_EXECUTION_BEGINNING_; {};
  /* Declare a variable used in asm constraints on some architectures:
     see the comment in jitter-executor.h . */
  volatile long _jitter_useless_variable __attribute__ ((unused))
    = 0;
# endif

#if defined (PVM_PROFILE_SAMPLE)
    /* Start sample-profiling: this starts the periodic timer signal,
       whose handler will look at the current instruction field within
       the special-purpose struct in the Array. */
    pvm_profile_sample_start (PVM_OWN_STATE);
#endif // #if defined (PVM_PROFILE_SAMPLE)

  /* Jump to the first instruction.  If replication is enabled this point
     marks the boundary between the ordinary world of C compiled code and
     the more fragile replicated code, where PC-relative address does
     not work as intended (which prevents the use of global and static
     variables, string literals and possibly large literal constants), and
     GDB gets easily confused. */
  jitter_ip
    = jitter_original_state->pvm_state_backing.initial_program_point;

  /* This is the actual jump to the first instruction: it's not an
     inline asm constraint lie like below. */

# if   defined(JITTER_DISPATCH_SWITCH)
    goto jitter_dispatching_switch_label;
# elif (defined(JITTER_DISPATCH_DIRECT_THREADING)  \
        || defined(JITTER_DISPATCH_MINIMAL_THREADING))
    goto * (jitter_ip->label);
# elif defined(JITTER_DISPATCH_NO_THREADING)
    /* On no-threading we only use jitter_ip for the first instruction.
       Make it an alias for the base, which will be enough to satisfy
       inline assembly code which pretends to alter the instruction
       pointer in ways invisible to the compiler.
       At least in my tests this trick frees up one hardware register,
       which is not surprising. */
    goto * jitter_ip;
#   define jitter_ip pvm_array_base_register_variable
# else
#   error "unknown dispatch"
# endif // if ... dispatch
#ifdef JITTER_REPLICATE
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE();
  goto jitter_fake_target;
#endif // #ifdef JITTER_REPLICATE

#ifdef JITTER_DISPATCH_SWITCH
  /* This is the dispatching switch.  At the beginning of the first VM
     VM instruction and at the end of each other, control jumps here. */
 jitter_dispatching_switch_label:
  switch (jitter_ip->fixnum)
    {
#endif // #ifdef JITTER_DISPATCH_SWITCH

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!INVALID, _eINVALID, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  0
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !INVALID
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eINVALID
{

jitter_fatal ("reached the !INVALID instruction");
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!INVALID, _eINVALID, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!BEGINBASICBLOCK, _eBEGINBASICBLOCK, hot)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  1
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !BEGINBASICBLOCK
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eBEGINBASICBLOCK
{

#ifdef JITTER_DISPATCH_MINIMAL_THREADING
  JITTER_SET_IP (jitter_ip + 1);
#endif // #ifdef JITTER_DISPATCH_MINIMAL_THREADING

}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!BEGINBASICBLOCK, _eBEGINBASICBLOCK, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!EXITVM, _eEXITVM, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  2
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !EXITVM
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eEXITVM
{

_JITTER_EXIT();
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!EXITVM, _eEXITVM, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!DATALOCATIONS, _eDATALOCATIONS, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  3
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !DATALOCATIONS
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eDATALOCATIONS
{
#ifndef JITTER_DISPATCH_SWITCH
#ifndef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("instruction pointer", jitter_ip);
#endif // #ifndef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("base", jitter_array_base);
#ifdef JITTER_DISPATCH_NO_THREADING
#ifdef JITTER_SCRATCH_REGISTER
  JITTER_DATA_LOCATION_DATUM ("scratch", jitter_residual_argument_scratch_register_variable);
#endif // #ifdef JITTER_SCRATCH_REGISTER

#endif // #ifdef JITTER_DISPATCH_NO_THREADING
#ifdef JITTER_DISPATCH_NO_THREADING
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 0", jitter_residual_argument_0_register_variable);
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 1", jitter_residual_argument_1_register_variable);
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 2", jitter_residual_argument_2_register_variable);
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
#endif // #ifdef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("link register", jitter_state_runtime._jitter_link);
  JITTER_DATA_LOCATION_DATUM ("stack top", 
     JITTER_STACK_TOS_TOP_NAME (whatever, jitter_state_runtime., jitter_state_backing->, stack));
  JITTER_DATA_LOCATION_DATUM ("stack undertop ptr", 
     JITTER_STACK_TOS_UNDER_TOP_POINTER_NAME (whatever, jitter_state_runtime., jitter_state_backing->, stack));
  JITTER_DATA_LOCATION_DATUM ("returnstack top ptr", 
     JITTER_STACK_NTOS_TOP_POINTER_NAME (whatever, jitter_state_runtime., jitter_state_backing->, returnstack));
  JITTER_DATA_LOCATION_DATUM ("exceptionstack top ptr", 
     JITTER_STACK_NTOS_TOP_POINTER_NAME (whatever, jitter_state_runtime., jitter_state_backing->, exceptionstack));
#endif // #ifndef JITTER_DISPATCH_SWITCH
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!DATALOCATIONS, _eDATALOCATIONS, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!NOP, _eNOP, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  4
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !NOP
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eNOP
{

  /* Do nothing. */;
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!NOP, _eNOP, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!UNREACHABLE0, _eUNREACHABLE0, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  5
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !UNREACHABLE0
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eUNREACHABLE0
{

jitter_fatal ("reached the !UNREACHABLE0 instruction");
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!UNREACHABLE0, _eUNREACHABLE0, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!UNREACHABLE1, _eUNREACHABLE1, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  6
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !UNREACHABLE1
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eUNREACHABLE1
{

jitter_fatal ("reached the !UNREACHABLE1 instruction");
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!UNREACHABLE1, _eUNREACHABLE1, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!PRETENDTOJUMPANYWHERE, _ePRETENDTOJUMPANYWHERE, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  7
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !PRETENDTOJUMPANYWHERE
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _ePRETENDTOJUMPANYWHERE
jitter_fake_target: __attribute__ ((unused));{

#if ! defined(JITTER_DISPATCH_SWITCH)
  JITTER_PRETEND_TO_UPDATE_IP_;
  goto * jitter_ip;
#endif

}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!PRETENDTOJUMPANYWHERE, _ePRETENDTOJUMPANYWHERE, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  /* Ordinary specialized instructions. */
  /* Ordinary specialised instruction addi */
  JITTER_INSTRUCTION_PROLOG_(addi, addi, hot)
  { /* This block begins with definitions for addi . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       8
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addi
#   define JITTER_INSTRUCTION_NAME_AS_STRING "addi"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "addi"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addi

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of addi ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "addi"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for addi . */
  {
/* User-specified code, user code block part: beginning. */
#line 3081 "./pvm.jitter"

    PVM_BINOP (INT, INT, INT, +);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for addi . */

  //fprintf (stderr, "..Executed instruction %s\n", "addi");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the addi argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(addi, addi, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for addi, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction addiof */
  JITTER_INSTRUCTION_PROLOG_(addiof, addiof, hot)
  { /* This block begins with definitions for addiof . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       9
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addiof
#   define JITTER_INSTRUCTION_NAME_AS_STRING "addiof"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "addiof"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addiof

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of addiof ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "addiof"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for addiof . */
  {
/* User-specified code, user code block part: beginning. */
#line 2789 "./pvm.jitter"

    int32_t a = PVM_VAL_INT (JITTER_UNDER_TOP_STACK ());
    int32_t b = PVM_VAL_INT (JITTER_TOP_STACK ());
    int size = PVM_VAL_INT_SIZE (JITTER_TOP_STACK ());
    int64_t a64 = ((uint64_t)(int64_t) a) << (64 - size);
    int64_t b64 = ((uint64_t)(int64_t) b) << (64 - size);

    JITTER_PUSH_STACK (pvm_make_int (INT_ADD_OVERFLOW (a64, b64),32));
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for addiof . */

  //fprintf (stderr, "..Executed instruction %s\n", "addiof");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the addiof argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(addiof, addiof, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for addiof, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction addiu */
  JITTER_INSTRUCTION_PROLOG_(addiu, addiu, hot)
  { /* This block begins with definitions for addiu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       10
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addiu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "addiu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "addiu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addiu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of addiu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "addiu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for addiu . */
  {
/* User-specified code, user code block part: beginning. */
#line 3094 "./pvm.jitter"

    PVM_BINOP (UINT, UINT, UINT, +);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for addiu . */

  //fprintf (stderr, "..Executed instruction %s\n", "addiu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the addiu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(addiu, addiu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for addiu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction addl */
  JITTER_INSTRUCTION_PROLOG_(addl, addl, hot)
  { /* This block begins with definitions for addl . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       11
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addl
#   define JITTER_INSTRUCTION_NAME_AS_STRING "addl"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "addl"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addl

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of addl ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "addl"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for addl . */
  {
/* User-specified code, user code block part: beginning. */
#line 3111 "./pvm.jitter"

    PVM_BINOP (LONG, LONG, LONG, +);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for addl . */

  //fprintf (stderr, "..Executed instruction %s\n", "addl");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the addl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(addl, addl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for addl, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction addlof */
  JITTER_INSTRUCTION_PROLOG_(addlof, addlof, hot)
  { /* This block begins with definitions for addlof . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       12
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addlof
#   define JITTER_INSTRUCTION_NAME_AS_STRING "addlof"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "addlof"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addlof

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of addlof ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "addlof"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for addlof . */
  {
/* User-specified code, user code block part: beginning. */
#line 2808 "./pvm.jitter"

    int64_t a = PVM_VAL_LONG (JITTER_UNDER_TOP_STACK ());
    int64_t b = PVM_VAL_LONG (JITTER_TOP_STACK ());
    int size = PVM_VAL_LONG_SIZE (JITTER_TOP_STACK ());
    int64_t a64 = ((uint64_t)(int64_t) a) << (64 - size);
    int64_t b64 = ((uint64_t)(int64_t) b) << (64 - size);

    JITTER_PUSH_STACK (pvm_make_int (INT_ADD_OVERFLOW (a64, b64),32));
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for addlof . */

  //fprintf (stderr, "..Executed instruction %s\n", "addlof");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the addlof argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(addlof, addlof, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for addlof, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction addlu */
  JITTER_INSTRUCTION_PROLOG_(addlu, addlu, hot)
  { /* This block begins with definitions for addlu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       13
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         addlu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "addlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "addlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME addlu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of addlu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "addlu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for addlu . */
  {
/* User-specified code, user code block part: beginning. */
#line 3124 "./pvm.jitter"

    PVM_BINOP (ULONG, ULONG, ULONG, +);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for addlu . */

  //fprintf (stderr, "..Executed instruction %s\n", "addlu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the addlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(addlu, addlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for addlu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction ains */
  JITTER_INSTRUCTION_PROLOG_(ains, ains, hot)
  { /* This block begins with definitions for ains . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       14
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         ains
#   define JITTER_INSTRUCTION_NAME_AS_STRING "ains"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "ains"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME ains

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of ains ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "ains"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for ains . */
  {
/* User-specified code, user code block part: beginning. */
#line 5171 "./pvm.jitter"

    pvm_val val = JITTER_TOP_STACK ();
    pvm_val idx = JITTER_UNDER_TOP_STACK ();
    pvm_val arr;

    JITTER_DROP_STACK ();
    JITTER_DROP_STACK ();
    arr = JITTER_TOP_STACK ();

    if (PVM_VAL_ULONG (idx) < PVM_VAL_ULONG (PVM_VAL_ARR_NELEM (arr)))
      /* Note that pvm_array_set can't return 0 here due
         to the index check.  */
      pvm_array_set (arr, idx, val);
    else
    {
      if (!pvm_array_insert (arr, idx, val))
        PVM_RAISE (PVM_E_INVAL, pvm_literal_eindex,
                   PVM_E_INVAL_ESTATUS);
    }
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for ains . */

  //fprintf (stderr, "..Executed instruction %s\n", "ains");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the ains argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(ains, ains, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for ains, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction and */
  JITTER_INSTRUCTION_PROLOG_(and, and, hot)
  { /* This block begins with definitions for and . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       15
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         and
#   define JITTER_INSTRUCTION_NAME_AS_STRING "and"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "and"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME and

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of and ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "and"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for and . */
  {
/* User-specified code, user code block part: beginning. */
#line 4027 "./pvm.jitter"

    PVM_BOOL_BINOP (INT, &&);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for and . */

  //fprintf (stderr, "..Executed instruction %s\n", "and");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the and argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(and, and, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for and, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction aref */
  JITTER_INSTRUCTION_PROLOG_(aref, aref, hot)
  { /* This block begins with definitions for aref . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       16
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         aref
#   define JITTER_INSTRUCTION_NAME_AS_STRING "aref"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "aref"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME aref

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of aref ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "aref"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for aref . */
  {
/* User-specified code, user code block part: beginning. */
#line 5263 "./pvm.jitter"

    pvm_val array = JITTER_UNDER_TOP_STACK ();
    pvm_val index = JITTER_TOP_STACK ();

    if ((PVM_VAL_ULONG (index) >=
            PVM_VAL_INTEGRAL (PVM_VAL_ARR_NELEM (array))))
      PVM_RAISE_DFL (PVM_E_OUT_OF_BOUNDS);

    JITTER_PUSH_STACK (PVM_VAL_ARR_ELEM_VALUE (array,
                                               PVM_VAL_ULONG (index)));
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for aref . */

  //fprintf (stderr, "..Executed instruction %s\n", "aref");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the aref argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(aref, aref, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for aref, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction arefo */
  JITTER_INSTRUCTION_PROLOG_(arefo, arefo, hot)
  { /* This block begins with definitions for arefo . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       17
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         arefo
#   define JITTER_INSTRUCTION_NAME_AS_STRING "arefo"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "arefo"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME arefo

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of arefo ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "arefo"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for arefo . */
  {
/* User-specified code, user code block part: beginning. */
#line 5289 "./pvm.jitter"

    pvm_val array = JITTER_UNDER_TOP_STACK ();
    pvm_val index = JITTER_TOP_STACK ();

    if (PVM_VAL_ULONG (index) < 0
        || (PVM_VAL_ULONG (index) >=
            PVM_VAL_INTEGRAL (PVM_VAL_ARR_NELEM (array))))
      PVM_RAISE_DFL (PVM_E_OUT_OF_BOUNDS);

    JITTER_PUSH_STACK (PVM_VAL_ARR_ELEM_OFFSET (array,
                                                PVM_VAL_ULONG (index)));
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for arefo . */

  //fprintf (stderr, "..Executed instruction %s\n", "arefo");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the arefo argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(arefo, arefo, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for arefo, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction arem */
  JITTER_INSTRUCTION_PROLOG_(arem, arem, hot)
  { /* This block begins with definitions for arem . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       18
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         arem
#   define JITTER_INSTRUCTION_NAME_AS_STRING "arem"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "arem"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME arem

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of arem ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "arem"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for arem . */
  {
/* User-specified code, user code block part: beginning. */
#line 5206 "./pvm.jitter"

    pvm_val arr = JITTER_UNDER_TOP_STACK ();
    pvm_val idx = JITTER_TOP_STACK ();

    if (PVM_VAL_ULONG (idx) >= PVM_VAL_ULONG (PVM_VAL_ARR_NELEM (arr)))
      PVM_RAISE_DFL (PVM_E_OUT_OF_BOUNDS);

    /* This call can't fail (return 0) due to the index check above.  */
    (void) pvm_array_rem (arr, idx);
    JITTER_DROP_STACK ();
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for arem . */

  //fprintf (stderr, "..Executed instruction %s\n", "arem");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the arem argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(arem, arem, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for arem, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction aset */
  JITTER_INSTRUCTION_PROLOG_(aset, aset, hot)
  { /* This block begins with definitions for aset . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       19
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         aset
#   define JITTER_INSTRUCTION_NAME_AS_STRING "aset"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "aset"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME aset

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of aset ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "aset"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for aset . */
  {
/* User-specified code, user code block part: beginning. */
#line 5228 "./pvm.jitter"

    pvm_val idx;
    pvm_val val;
    pvm_val arr;
    size_t index;

    val= JITTER_TOP_STACK ();
    idx = JITTER_UNDER_TOP_STACK ();
    index = PVM_VAL_ULONG (idx);
    JITTER_DROP_STACK ();
    JITTER_DROP_STACK ();

    arr = JITTER_TOP_STACK ();

    PVM_ASSERT (index < PVM_VAL_INTEGRAL (PVM_VAL_ARR_NELEM (arr)));

    /* Note that pvm_aray_set cannot fail here, due to the check
       on index above.  */
    pvm_array_set (arr, idx, val);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for aset . */

  //fprintf (stderr, "..Executed instruction %s\n", "aset");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the aset argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(aset, aset, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for aset, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction atr */
  JITTER_INSTRUCTION_PROLOG_(atr, atr, hot)
  { /* This block begins with definitions for atr . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       20
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         atr
#   define JITTER_INSTRUCTION_NAME_AS_STRING "atr"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "atr"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME atr

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of atr ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "atr"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for atr . */
  {
/* User-specified code, user code block part: beginning. */
#line 2770 "./pvm.jitter"

    JITTER_PUSH_STACK (JITTER_TOP_RETURNSTACK ());
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for atr . */

  //fprintf (stderr, "..Executed instruction %s\n", "atr");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the atr argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(atr, atr, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for atr, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction ba/fR */
  JITTER_INSTRUCTION_PROLOG_(ba/fR, ba__fR, hot)
  { /* This block begins with definitions for ba/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       21
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         ba/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "ba"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "ba/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME ba__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for ba/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of ba/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "ba/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for ba/fR . */
  {
/* User-specified code, user code block part: beginning. */
#line 4507 "./pvm.jitter"

    JITTER_BRANCH_FAST(JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for ba/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "ba/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the ba/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(ba/fR, ba__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for ba/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bandi */
  JITTER_INSTRUCTION_PROLOG_(bandi, bandi, hot)
  { /* This block begins with definitions for bandi . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       22
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bandi
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bandi"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bandi"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bandi

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bandi ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bandi"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bandi . */
  {
/* User-specified code, user code block part: beginning. */
#line 4168 "./pvm.jitter"

    PVM_BINOP (INT, INT, INT, &);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bandi . */

  //fprintf (stderr, "..Executed instruction %s\n", "bandi");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bandi argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bandi, bandi, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bandi, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bandiu */
  JITTER_INSTRUCTION_PROLOG_(bandiu, bandiu, hot)
  { /* This block begins with definitions for bandiu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       23
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bandiu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bandiu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bandiu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bandiu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bandiu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bandiu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bandiu . */
  {
/* User-specified code, user code block part: beginning. */
#line 4181 "./pvm.jitter"

    PVM_BINOP (UINT, UINT, UINT, &);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bandiu . */

  //fprintf (stderr, "..Executed instruction %s\n", "bandiu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bandiu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bandiu, bandiu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bandiu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bandl */
  JITTER_INSTRUCTION_PROLOG_(bandl, bandl, hot)
  { /* This block begins with definitions for bandl . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       24
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bandl
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bandl"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bandl"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bandl

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bandl ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bandl"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bandl . */
  {
/* User-specified code, user code block part: beginning. */
#line 4193 "./pvm.jitter"

    PVM_BINOP (LONG, LONG, LONG, &);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bandl . */

  //fprintf (stderr, "..Executed instruction %s\n", "bandl");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bandl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bandl, bandl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bandl, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bandlu */
  JITTER_INSTRUCTION_PROLOG_(bandlu, bandlu, hot)
  { /* This block begins with definitions for bandlu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       25
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bandlu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bandlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bandlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bandlu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bandlu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bandlu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bandlu . */
  {
/* User-specified code, user code block part: beginning. */
#line 4206 "./pvm.jitter"

    PVM_BINOP (ULONG, ULONG, ULONG, &);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bandlu . */

  //fprintf (stderr, "..Executed instruction %s\n", "bandlu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bandlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bandlu, bandlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bandlu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction beghl/retR */
  JITTER_INSTRUCTION_PROLOG_(beghl/retR, beghl__retR, cold)
  { /* This block begins with definitions for beghl/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       26
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beghl/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "beghl"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "beghl/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beghl__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is non-relocatable.
       Its 0-th argument, a literal, is the return address where to jump
       at the end, back to relocated code. */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is non-relocatable.
       Its 0-th argument, a literal, is the return address where to jump
       at the end, back to relocated code. */

    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#ifdef JITTER_REPLICATE
/* When jumping to the non-relocatable part it is important not
   to use a fallback version of JITTER_COMPUTED_GOTO, in order to
   prevent GCC from tail-merging. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
    /* Jump to non-relocatable code. */
    JITTER_COMPUTED_GOTO(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE);

    /* Here the residual arity is given as zero: it's too late to
       skip residuals, since we've already jumped and this code is
       unreachable.  The instruction pointer, if any, is advanced
       in the non-relocatable code. */
    JITTER_INSTRUCTION_EPILOG_(beghl/retR, beghl__retR, 0)

    /* Relocated code will jump to this label in non-relocated code. */
  JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL:
    JITTER_COMMENT_IN_ASM_("beghl/retR non-relocatable code");
#endif // #ifdef JITTER_REPLICATE
#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of beghl/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  no. */
#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "beghl/retR"); fflush (stderr);
  //fprintf (stderr, "Executing non-relocatable instruction %s with JITTER_SPECIALIZED_INSTRUCTION_WORD_NO=%i..\n", "beghl/retR", (int) JITTER_SPECIALIZED_INSTRUCTION_WORD_NO); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for beghl/retR . */
  {
/* User-specified code, user code block part: beginning. */
#line 2157 "./pvm.jitter"

    char *url = PVM_VAL_STR (JITTER_UNDER_TOP_STACK ());
    char *id = PVM_VAL_STR (JITTER_TOP_STACK ());

    JITTER_DROP_STACK ();
    JITTER_DROP_STACK ();
    pk_term_hyperlink (url, id);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for beghl/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "beghl/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
#ifdef JITTER_REPLICATE
  {
    /* Advance the instruction pointer, if any, to skip every
       residual but the last; branch back to replicated
       code. */
    const void *_jitter_back_to_replicated_code_pointer =
      JITTER_ARGP0;
    JITTER_SKIP_RESIDUALS_;
    goto * _jitter_back_to_replicated_code_pointer;
  }
#endif // #ifdef JITTER_REPLICATE

    /* Undefine the beghl/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#ifndef JITTER_REPLICATE
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(beghl/retR, beghl__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#endif // #ifndef JITTER_REPLICATE
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for beghl/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction begsc/retR */
  JITTER_INSTRUCTION_PROLOG_(begsc/retR, begsc__retR, cold)
  { /* This block begins with definitions for begsc/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       27
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         begsc/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "begsc"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "begsc/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME begsc__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is non-relocatable.
       Its 0-th argument, a literal, is the return address where to jump
       at the end, back to relocated code. */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is non-relocatable.
       Its 0-th argument, a literal, is the return address where to jump
       at the end, back to relocated code. */

    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#ifdef JITTER_REPLICATE
/* When jumping to the non-relocatable part it is important not
   to use a fallback version of JITTER_COMPUTED_GOTO, in order to
   prevent GCC from tail-merging. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
    /* Jump to non-relocatable code. */
    JITTER_COMPUTED_GOTO(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE);

    /* Here the residual arity is given as zero: it's too late to
       skip residuals, since we've already jumped and this code is
       unreachable.  The instruction pointer, if any, is advanced
       in the non-relocatable code. */
    JITTER_INSTRUCTION_EPILOG_(begsc/retR, begsc__retR, 0)

    /* Relocated code will jump to this label in non-relocated code. */
  JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL:
    JITTER_COMMENT_IN_ASM_("begsc/retR non-relocatable code");
#endif // #ifdef JITTER_REPLICATE
#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of begsc/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  no. */
#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "begsc/retR"); fflush (stderr);
  //fprintf (stderr, "Executing non-relocatable instruction %s with JITTER_SPECIALIZED_INSTRUCTION_WORD_NO=%i..\n", "begsc/retR", (int) JITTER_SPECIALIZED_INSTRUCTION_WORD_NO); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for begsc/retR . */
  {
/* User-specified code, user code block part: beginning. */
#line 2194 "./pvm.jitter"

    pk_term_class (PVM_VAL_STR (JITTER_TOP_STACK ()));
    JITTER_DROP_STACK ();
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for begsc/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "begsc/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
#ifdef JITTER_REPLICATE
  {
    /* Advance the instruction pointer, if any, to skip every
       residual but the last; branch back to replicated
       code. */
    const void *_jitter_back_to_replicated_code_pointer =
      JITTER_ARGP0;
    JITTER_SKIP_RESIDUALS_;
    goto * _jitter_back_to_replicated_code_pointer;
  }
#endif // #ifdef JITTER_REPLICATE

    /* Undefine the begsc/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#ifndef JITTER_REPLICATE
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(begsc/retR, begsc__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#endif // #ifndef JITTER_REPLICATE
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for begsc/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bn/fR */
  JITTER_INSTRUCTION_PROLOG_(bn/fR, bn__fR, hot)
  { /* This block begins with definitions for bn/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       28
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bn/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bn"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bn/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bn__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bn/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bn/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bn/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bn/fR . */
  {
/* User-specified code, user code block part: beginning. */
#line 4521 "./pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_ZERO (tmp != PVM_NULL, JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bn/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bn/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bn/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bn/fR, bn__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bn/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bnn/fR */
  JITTER_INSTRUCTION_PROLOG_(bnn/fR, bnn__fR, hot)
  { /* This block begins with definitions for bnn/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       29
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnn/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bnn"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bnn/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnn__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bnn/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bnn/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bnn/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bnn/fR . */
  {
/* User-specified code, user code block part: beginning. */
#line 4536 "./pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_ZERO (tmp == PVM_NULL, JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bnn/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bnn/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bnn/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bnn/fR, bnn__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bnn/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bnoti */
  JITTER_INSTRUCTION_PROLOG_(bnoti, bnoti, hot)
  { /* This block begins with definitions for bnoti . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       30
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnoti
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bnoti"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bnoti"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnoti

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bnoti ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bnoti"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bnoti . */
  {
/* User-specified code, user code block part: beginning. */
#line 4218 "./pvm.jitter"

    PVM_UNOP (INT, INT, int, ~);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bnoti . */

  //fprintf (stderr, "..Executed instruction %s\n", "bnoti");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bnoti argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bnoti, bnoti, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bnoti, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bnotiu */
  JITTER_INSTRUCTION_PROLOG_(bnotiu, bnotiu, hot)
  { /* This block begins with definitions for bnotiu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       31
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnotiu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bnotiu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bnotiu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnotiu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bnotiu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bnotiu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bnotiu . */
  {
/* User-specified code, user code block part: beginning. */
#line 4231 "./pvm.jitter"

    PVM_UNOP (UINT, UINT, uint, ~);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bnotiu . */

  //fprintf (stderr, "..Executed instruction %s\n", "bnotiu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bnotiu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bnotiu, bnotiu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bnotiu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bnotl */
  JITTER_INSTRUCTION_PROLOG_(bnotl, bnotl, hot)
  { /* This block begins with definitions for bnotl . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       32
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnotl
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bnotl"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bnotl"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnotl

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bnotl ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bnotl"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bnotl . */
  {
/* User-specified code, user code block part: beginning. */
#line 4243 "./pvm.jitter"

    PVM_UNOP (LONG, LONG, long, ~);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bnotl . */

  //fprintf (stderr, "..Executed instruction %s\n", "bnotl");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bnotl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bnotl, bnotl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bnotl, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bnotlu */
  JITTER_INSTRUCTION_PROLOG_(bnotlu, bnotlu, hot)
  { /* This block begins with definitions for bnotlu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       33
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnotlu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bnotlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bnotlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnotlu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bnotlu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bnotlu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bnotlu . */
  {
/* User-specified code, user code block part: beginning. */
#line 4255 "./pvm.jitter"

    PVM_UNOP (ULONG, ULONG, ulong, ~);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bnotlu . */

  //fprintf (stderr, "..Executed instruction %s\n", "bnotlu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bnotlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bnotlu, bnotlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bnotlu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bnzi/fR */
  JITTER_INSTRUCTION_PROLOG_(bnzi/fR, bnzi__fR, hot)
  { /* This block begins with definitions for bnzi/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       34
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnzi/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bnzi"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bnzi/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnzi__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bnzi/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bnzi/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bnzi/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bnzi/fR . */
  {
/* User-specified code, user code block part: beginning. */
#line 4615 "./pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_NONZERO (PVM_VAL_INT (tmp), JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bnzi/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bnzi/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bnzi/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bnzi/fR, bnzi__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bnzi/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bnziu/fR */
  JITTER_INSTRUCTION_PROLOG_(bnziu/fR, bnziu__fR, hot)
  { /* This block begins with definitions for bnziu/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       35
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnziu/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bnziu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bnziu/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnziu__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bnziu/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bnziu/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bnziu/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bnziu/fR . */
  {
/* User-specified code, user code block part: beginning. */
#line 4630 "./pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_NONZERO (PVM_VAL_UINT (tmp), JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bnziu/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bnziu/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bnziu/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bnziu/fR, bnziu__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bnziu/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bnzl/fR */
  JITTER_INSTRUCTION_PROLOG_(bnzl/fR, bnzl__fR, hot)
  { /* This block begins with definitions for bnzl/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       36
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnzl/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bnzl"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bnzl/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnzl__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bnzl/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bnzl/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bnzl/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bnzl/fR . */
  {
/* User-specified code, user code block part: beginning. */
#line 4645 "./pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    /* JITTER_BRANCH_FAST_IF_ZERO expects word-size value for condition;
       PVM_VAL_LONG values are not word-size on 32-bit machines.  */
    JITTER_BRANCH_FAST_IF_NONZERO (!!PVM_VAL_LONG (tmp), JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bnzl/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bnzl/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bnzl/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bnzl/fR, bnzl__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bnzl/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bnzlu/fR */
  JITTER_INSTRUCTION_PROLOG_(bnzlu/fR, bnzlu__fR, hot)
  { /* This block begins with definitions for bnzlu/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       37
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bnzlu/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bnzlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bnzlu/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bnzlu__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bnzlu/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bnzlu/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bnzlu/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bnzlu/fR . */
  {
/* User-specified code, user code block part: beginning. */
#line 4662 "./pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    /* JITTER_BRANCH_FAST_IF_ZERO expects word-size value for condition;
       PVM_VAL_LONG values are not word-size on 32-bit machines.  */
    JITTER_BRANCH_FAST_IF_NONZERO (!!PVM_VAL_ULONG (tmp), JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bnzlu/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bnzlu/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bnzlu/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bnzlu/fR, bnzlu__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bnzlu/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bori */
  JITTER_INSTRUCTION_PROLOG_(bori, bori, hot)
  { /* This block begins with definitions for bori . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       38
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bori
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bori"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bori"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bori

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bori ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bori"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bori . */
  {
/* User-specified code, user code block part: beginning. */
#line 4119 "./pvm.jitter"

    PVM_BINOP (INT, INT, INT, |);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bori . */

  //fprintf (stderr, "..Executed instruction %s\n", "bori");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bori argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bori, bori, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bori, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction boriu */
  JITTER_INSTRUCTION_PROLOG_(boriu, boriu, hot)
  { /* This block begins with definitions for boriu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       39
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         boriu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "boriu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "boriu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME boriu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of boriu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "boriu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for boriu . */
  {
/* User-specified code, user code block part: beginning. */
#line 4132 "./pvm.jitter"

    PVM_BINOP (UINT, UINT, UINT, |);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for boriu . */

  //fprintf (stderr, "..Executed instruction %s\n", "boriu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the boriu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(boriu, boriu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for boriu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction borl */
  JITTER_INSTRUCTION_PROLOG_(borl, borl, hot)
  { /* This block begins with definitions for borl . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       40
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         borl
#   define JITTER_INSTRUCTION_NAME_AS_STRING "borl"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "borl"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME borl

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of borl ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "borl"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for borl . */
  {
/* User-specified code, user code block part: beginning. */
#line 4144 "./pvm.jitter"

    PVM_BINOP (LONG, LONG, LONG, |);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for borl . */

  //fprintf (stderr, "..Executed instruction %s\n", "borl");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the borl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(borl, borl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for borl, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction borlu */
  JITTER_INSTRUCTION_PROLOG_(borlu, borlu, hot)
  { /* This block begins with definitions for borlu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       41
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         borlu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "borlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "borlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME borlu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of borlu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "borlu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for borlu . */
  {
/* User-specified code, user code block part: beginning. */
#line 4156 "./pvm.jitter"

    PVM_BINOP (ULONG, ULONG, ULONG, |);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for borlu . */

  //fprintf (stderr, "..Executed instruction %s\n", "borlu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the borlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(borlu, borlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for borlu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bsli */
  JITTER_INSTRUCTION_PROLOG_(bsli, bsli, hot)
  { /* This block begins with definitions for bsli . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       42
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsli
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bsli"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bsli"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsli

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bsli ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bsli"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bsli . */
  {
/* User-specified code, user code block part: beginning. */
#line 4307 "./pvm.jitter"

    PVM_BINOP (INT, UINT, INT, <<);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bsli . */

  //fprintf (stderr, "..Executed instruction %s\n", "bsli");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bsli argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bsli, bsli, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bsli, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bsliu */
  JITTER_INSTRUCTION_PROLOG_(bsliu, bsliu, hot)
  { /* This block begins with definitions for bsliu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       43
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsliu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bsliu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bsliu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsliu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bsliu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bsliu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bsliu . */
  {
/* User-specified code, user code block part: beginning. */
#line 4325 "./pvm.jitter"

    PVM_BINOP (UINT, UINT, UINT, <<);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bsliu . */

  //fprintf (stderr, "..Executed instruction %s\n", "bsliu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bsliu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bsliu, bsliu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bsliu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bsll */
  JITTER_INSTRUCTION_PROLOG_(bsll, bsll, hot)
  { /* This block begins with definitions for bsll . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       44
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsll
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bsll"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bsll"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsll

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bsll ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bsll"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bsll . */
  {
/* User-specified code, user code block part: beginning. */
#line 4342 "./pvm.jitter"

    PVM_BINOP (LONG, UINT, LONG, <<);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bsll . */

  //fprintf (stderr, "..Executed instruction %s\n", "bsll");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bsll argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bsll, bsll, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bsll, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bsllu */
  JITTER_INSTRUCTION_PROLOG_(bsllu, bsllu, hot)
  { /* This block begins with definitions for bsllu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       45
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsllu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bsllu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bsllu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsllu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bsllu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bsllu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bsllu . */
  {
/* User-specified code, user code block part: beginning. */
#line 4360 "./pvm.jitter"

    PVM_BINOP (ULONG, UINT, ULONG, <<);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bsllu . */

  //fprintf (stderr, "..Executed instruction %s\n", "bsllu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bsllu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bsllu, bsllu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bsllu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bsri */
  JITTER_INSTRUCTION_PROLOG_(bsri, bsri, hot)
  { /* This block begins with definitions for bsri . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       46
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsri
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bsri"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bsri"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsri

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bsri ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bsri"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bsri . */
  {
/* User-specified code, user code block part: beginning. */
#line 4373 "./pvm.jitter"

    PVM_BINOP (INT, UINT, INT, >>);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bsri . */

  //fprintf (stderr, "..Executed instruction %s\n", "bsri");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bsri argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bsri, bsri, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bsri, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bsriu */
  JITTER_INSTRUCTION_PROLOG_(bsriu, bsriu, hot)
  { /* This block begins with definitions for bsriu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       47
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsriu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bsriu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bsriu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsriu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bsriu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bsriu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bsriu . */
  {
/* User-specified code, user code block part: beginning. */
#line 4386 "./pvm.jitter"

    PVM_BINOP (UINT, UINT, UINT, >>);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bsriu . */

  //fprintf (stderr, "..Executed instruction %s\n", "bsriu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bsriu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bsriu, bsriu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bsriu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bsrl */
  JITTER_INSTRUCTION_PROLOG_(bsrl, bsrl, hot)
  { /* This block begins with definitions for bsrl . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       48
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsrl
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bsrl"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bsrl"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsrl

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bsrl ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bsrl"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bsrl . */
  {
/* User-specified code, user code block part: beginning. */
#line 4399 "./pvm.jitter"

    PVM_BINOP (LONG, UINT, LONG, >>);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bsrl . */

  //fprintf (stderr, "..Executed instruction %s\n", "bsrl");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bsrl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bsrl, bsrl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bsrl, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bsrlu */
  JITTER_INSTRUCTION_PROLOG_(bsrlu, bsrlu, hot)
  { /* This block begins with definitions for bsrlu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       49
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bsrlu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bsrlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bsrlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bsrlu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bsrlu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bsrlu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bsrlu . */
  {
/* User-specified code, user code block part: beginning. */
#line 4412 "./pvm.jitter"

    PVM_BINOP (ULONG, UINT, ULONG, >>);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bsrlu . */

  //fprintf (stderr, "..Executed instruction %s\n", "bsrlu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bsrlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bsrlu, bsrlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bsrlu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bxori */
  JITTER_INSTRUCTION_PROLOG_(bxori, bxori, hot)
  { /* This block begins with definitions for bxori . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       50
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bxori
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bxori"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bxori"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bxori

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bxori ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bxori"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bxori . */
  {
/* User-specified code, user code block part: beginning. */
#line 4068 "./pvm.jitter"

    PVM_BINOP (INT, INT, INT, ^);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bxori . */

  //fprintf (stderr, "..Executed instruction %s\n", "bxori");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bxori argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bxori, bxori, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bxori, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bxoriu */
  JITTER_INSTRUCTION_PROLOG_(bxoriu, bxoriu, hot)
  { /* This block begins with definitions for bxoriu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       51
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bxoriu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bxoriu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bxoriu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bxoriu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bxoriu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bxoriu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bxoriu . */
  {
/* User-specified code, user code block part: beginning. */
#line 4081 "./pvm.jitter"

    PVM_BINOP (UINT, UINT, UINT, ^);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bxoriu . */

  //fprintf (stderr, "..Executed instruction %s\n", "bxoriu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bxoriu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bxoriu, bxoriu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bxoriu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bxorl */
  JITTER_INSTRUCTION_PROLOG_(bxorl, bxorl, hot)
  { /* This block begins with definitions for bxorl . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       52
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bxorl
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bxorl"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bxorl"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bxorl

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bxorl ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bxorl"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bxorl . */
  {
/* User-specified code, user code block part: beginning. */
#line 4094 "./pvm.jitter"

    PVM_BINOP (LONG, LONG, LONG, ^);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bxorl . */

  //fprintf (stderr, "..Executed instruction %s\n", "bxorl");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bxorl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bxorl, bxorl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bxorl, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bxorlu */
  JITTER_INSTRUCTION_PROLOG_(bxorlu, bxorlu, hot)
  { /* This block begins with definitions for bxorlu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       53
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bxorlu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bxorlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bxorlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bxorlu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bxorlu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bxorlu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bxorlu . */
  {
/* User-specified code, user code block part: beginning. */
#line 4107 "./pvm.jitter"

    PVM_BINOP (ULONG, ULONG, ULONG, ^);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bxorlu . */

  //fprintf (stderr, "..Executed instruction %s\n", "bxorlu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bxorlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bxorlu, bxorlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bxorlu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bzi/fR */
  JITTER_INSTRUCTION_PROLOG_(bzi/fR, bzi__fR, hot)
  { /* This block begins with definitions for bzi/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       54
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bzi/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bzi"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bzi/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bzi__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bzi/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bzi/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bzi/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bzi/fR . */
  {
/* User-specified code, user code block part: beginning. */
#line 4551 "./pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_ZERO (PVM_VAL_INT (tmp), JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bzi/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bzi/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bzi/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bzi/fR, bzi__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bzi/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bziu/fR */
  JITTER_INSTRUCTION_PROLOG_(bziu/fR, bziu__fR, hot)
  { /* This block begins with definitions for bziu/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       55
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bziu/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bziu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bziu/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bziu__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bziu/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bziu/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bziu/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bziu/fR . */
  {
/* User-specified code, user code block part: beginning. */
#line 4566 "./pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    JITTER_BRANCH_FAST_IF_ZERO (PVM_VAL_UINT (tmp), JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bziu/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bziu/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bziu/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bziu/fR, bziu__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bziu/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bzl/fR */
  JITTER_INSTRUCTION_PROLOG_(bzl/fR, bzl__fR, hot)
  { /* This block begins with definitions for bzl/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       56
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bzl/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bzl"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bzl/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bzl__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bzl/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bzl/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bzl/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bzl/fR . */
  {
/* User-specified code, user code block part: beginning. */
#line 4581 "./pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    /* JITTER_BRANCH_FAST_IF_ZERO expects word-size value for condition;
       PVM_VAL_LONG values are not word-size on 32-bit machines.  */
    JITTER_BRANCH_FAST_IF_ZERO (!!PVM_VAL_LONG (tmp), JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bzl/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bzl/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bzl/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bzl/fR, bzl__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bzl/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction bzlu/fR */
  JITTER_INSTRUCTION_PROLOG_(bzlu/fR, bzlu__fR, hot)
  { /* This block begins with definitions for bzlu/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       57
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bzlu/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "bzlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "bzlu/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bzlu__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bzlu/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of bzlu/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "bzlu/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for bzlu/fR . */
  {
/* User-specified code, user code block part: beginning. */
#line 4598 "./pvm.jitter"

    pvm_val tmp = JITTER_TOP_STACK ();
    /* JITTER_BRANCH_FAST_IF_ZERO expects word-size value for condition;
       PVM_VAL_LONG values are not word-size on 32-bit machines.  */
    JITTER_BRANCH_FAST_IF_ZERO (!!PVM_VAL_ULONG (tmp), JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for bzlu/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "bzlu/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the bzlu/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(bzlu/fR, bzlu__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for bzlu/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call/retR */
  JITTER_INSTRUCTION_PROLOG_(call/retR, call__retR, cold)
  { /* This block begins with definitions for call/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       58
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 0-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP0;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call/retR . */
  {
/* User-specified code, user code block part: beginning. */
#line 1866 "./pvm.jitter"

    pvm_val closure = JITTER_TOP_STACK ();

    PVM_ASSERT (PVM_VAL_CLS_ENV (closure) != NULL);
    JITTER_DROP_STACK ();
    PVM_CALL (closure);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call/retR, call__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction canary */
  JITTER_INSTRUCTION_PROLOG_(canary, canary, hot)
  { /* This block begins with definitions for canary . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       59
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         canary
#   define JITTER_INSTRUCTION_NAME_AS_STRING "canary"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "canary"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME canary

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of canary ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "canary"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for canary . */
  {
/* User-specified code, user code block part: beginning. */
#line 1035 "./pvm.jitter"

     PVM_STATE_BACKING_FIELD (canary_stack) = JITTER_HEIGHT_STACK ();
     PVM_STATE_BACKING_FIELD (canary_returnstack) =
       JITTER_HEIGHT_RETURNSTACK ();
     PVM_STATE_BACKING_FIELD (canary_exceptionstack) =
       JITTER_HEIGHT_EXCEPTIONSTACK ();
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for canary . */

  //fprintf (stderr, "..Executed instruction %s\n", "canary");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the canary argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(canary, canary, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for canary, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction cgetn */
  JITTER_INSTRUCTION_PROLOG_(cgetn, cgetn, hot)
  { /* This block begins with definitions for cgetn . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       60
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         cgetn
#   define JITTER_INSTRUCTION_NAME_AS_STRING "cgetn"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "cgetn"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME cgetn

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of cgetn ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "cgetn"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for cgetn . */
  {
/* User-specified code, user code block part: beginning. */
#line 5116 "./pvm.jitter"

    JITTER_PUSH_STACK (PVM_VAL_CLS_NAME (JITTER_TOP_STACK ()));
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for cgetn . */

  //fprintf (stderr, "..Executed instruction %s\n", "cgetn");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the cgetn argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(cgetn, cgetn, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for cgetn, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction close */
  JITTER_INSTRUCTION_PROLOG_(close, close, hot)
  { /* This block begins with definitions for close . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       61
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         close
#   define JITTER_INSTRUCTION_NAME_AS_STRING "close"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "close"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME close

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of close ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "close"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for close . */
  {
/* User-specified code, user code block part: beginning. */
#line 1561 "./pvm.jitter"

    int io_id = PVM_VAL_INT (JITTER_TOP_STACK ());
    ios_context ios_ctx = PVM_STATE_BACKING_FIELD (ios_ctx);
    ios io = ios_search_by_id (ios_ctx, io_id);

    if (io == NULL)
      JITTER_TOP_STACK () = PVM_MAKE_DFL_EXCEPTION (PVM_E_NO_IOS);
    else if (ios_close (ios_ctx, io) != IOS_OK)
      JITTER_TOP_STACK () = PVM_MAKE_DFL_EXCEPTION (PVM_E_IO);
    else
      JITTER_TOP_STACK () = PVM_NULL;
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for close . */

  //fprintf (stderr, "..Executed instruction %s\n", "close");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the close argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(close, close, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for close, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction ctos */
  JITTER_INSTRUCTION_PROLOG_(ctos, ctos, hot)
  { /* This block begins with definitions for ctos . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       62
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         ctos
#   define JITTER_INSTRUCTION_NAME_AS_STRING "ctos"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "ctos"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME ctos

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of ctos ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "ctos"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for ctos . */
  {
/* User-specified code, user code block part: beginning. */
#line 4681 "./pvm.jitter"

    uint8_t c = PVM_VAL_UINT (JITTER_TOP_STACK ());
    char *str = pvm_alloc (2);
    str[0] = c;
    str[1] = '\0';

    JITTER_PUSH_STACK (pvm_make_string_nodup (str));
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for ctos . */

  //fprintf (stderr, "..Executed instruction %s\n", "ctos");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the ctos argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(ctos, ctos, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for ctos, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction disas/retR */
  JITTER_INSTRUCTION_PROLOG_(disas/retR, disas__retR, cold)
  { /* This block begins with definitions for disas/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       63
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         disas/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "disas"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "disas/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME disas__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is non-relocatable.
       Its 0-th argument, a literal, is the return address where to jump
       at the end, back to relocated code. */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is non-relocatable.
       Its 0-th argument, a literal, is the return address where to jump
       at the end, back to relocated code. */

    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#ifdef JITTER_REPLICATE
/* When jumping to the non-relocatable part it is important not
   to use a fallback version of JITTER_COMPUTED_GOTO, in order to
   prevent GCC from tail-merging. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
    /* Jump to non-relocatable code. */
    JITTER_COMPUTED_GOTO(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE);

    /* Here the residual arity is given as zero: it's too late to
       skip residuals, since we've already jumped and this code is
       unreachable.  The instruction pointer, if any, is advanced
       in the non-relocatable code. */
    JITTER_INSTRUCTION_EPILOG_(disas/retR, disas__retR, 0)

    /* Relocated code will jump to this label in non-relocated code. */
  JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL:
    JITTER_COMMENT_IN_ASM_("disas/retR non-relocatable code");
#endif // #ifdef JITTER_REPLICATE
#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of disas/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  no. */
#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "disas/retR"); fflush (stderr);
  //fprintf (stderr, "Executing non-relocatable instruction %s with JITTER_SPECIALIZED_INSTRUCTION_WORD_NO=%i..\n", "disas/retR", (int) JITTER_SPECIALIZED_INSTRUCTION_WORD_NO); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for disas/retR . */
  {
/* User-specified code, user code block part: beginning. */
#line 7102 "./pvm.jitter"

    pvm_val cls = JITTER_TOP_STACK ();
    pvm_disassemble_program (PVM_VAL_CLS_PROGRAM (cls));
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for disas/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "disas/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
#ifdef JITTER_REPLICATE
  {
    /* Advance the instruction pointer, if any, to skip every
       residual but the last; branch back to replicated
       code. */
    const void *_jitter_back_to_replicated_code_pointer =
      JITTER_ARGP0;
    JITTER_SKIP_RESIDUALS_;
    goto * _jitter_back_to_replicated_code_pointer;
  }
#endif // #ifdef JITTER_REPLICATE

    /* Undefine the disas/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#ifndef JITTER_REPLICATE
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(disas/retR, disas__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#endif // #ifndef JITTER_REPLICATE
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for disas/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction divi */
  JITTER_INSTRUCTION_PROLOG_(divi, divi, hot)
  { /* This block begins with definitions for divi . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       64
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         divi
#   define JITTER_INSTRUCTION_NAME_AS_STRING "divi"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "divi"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME divi

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of divi ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "divi"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for divi . */
  {
/* User-specified code, user code block part: beginning. */
#line 3262 "./pvm.jitter"

    PVM_BINOP (INT, INT, INT, /);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for divi . */

  //fprintf (stderr, "..Executed instruction %s\n", "divi");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the divi argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(divi, divi, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for divi, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction diviof */
  JITTER_INSTRUCTION_PROLOG_(diviof, diviof, hot)
  { /* This block begins with definitions for diviof . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       65
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         diviof
#   define JITTER_INSTRUCTION_NAME_AS_STRING "diviof"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "diviof"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME diviof

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of diviof ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "diviof"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for diviof . */
  {
/* User-specified code, user code block part: beginning. */
#line 2901 "./pvm.jitter"

    int32_t a = PVM_VAL_INT (JITTER_UNDER_TOP_STACK ());
    int32_t b = PVM_VAL_INT (JITTER_TOP_STACK ());
    int size = PVM_VAL_INT_SIZE (JITTER_TOP_STACK ());
    int64_t a64 = ((uint64_t)(int64_t) a) << (64 - size);

    JITTER_PUSH_STACK (pvm_make_int (INT_DIVIDE_OVERFLOW (a64, b),32));
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for diviof . */

  //fprintf (stderr, "..Executed instruction %s\n", "diviof");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the diviof argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(diviof, diviof, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for diviof, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction diviu */
  JITTER_INSTRUCTION_PROLOG_(diviu, diviu, hot)
  { /* This block begins with definitions for diviu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       66
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         diviu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "diviu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "diviu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME diviu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of diviu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "diviu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for diviu . */
  {
/* User-specified code, user code block part: beginning. */
#line 3280 "./pvm.jitter"

    PVM_BINOP (UINT, UINT, UINT, /);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for diviu . */

  //fprintf (stderr, "..Executed instruction %s\n", "diviu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the diviu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(diviu, diviu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for diviu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction divl */
  JITTER_INSTRUCTION_PROLOG_(divl, divl, hot)
  { /* This block begins with definitions for divl . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       67
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         divl
#   define JITTER_INSTRUCTION_NAME_AS_STRING "divl"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "divl"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME divl

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of divl ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "divl"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for divl . */
  {
/* User-specified code, user code block part: beginning. */
#line 3300 "./pvm.jitter"

    PVM_BINOP (LONG, LONG, LONG, /);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for divl . */

  //fprintf (stderr, "..Executed instruction %s\n", "divl");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the divl argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(divl, divl, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for divl, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction divlof */
  JITTER_INSTRUCTION_PROLOG_(divlof, divlof, hot)
  { /* This block begins with definitions for divlof . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       68
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         divlof
#   define JITTER_INSTRUCTION_NAME_AS_STRING "divlof"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "divlof"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME divlof

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of divlof ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "divlof"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for divlof . */
  {
/* User-specified code, user code block part: beginning. */
#line 2919 "./pvm.jitter"

    int64_t a = PVM_VAL_LONG (JITTER_UNDER_TOP_STACK ());
    int64_t b = PVM_VAL_LONG (JITTER_TOP_STACK ());
    int size = PVM_VAL_LONG_SIZE (JITTER_TOP_STACK ());
    int64_t a64 = ((uint64_t)(int64_t) a) << (64 - size);

    JITTER_PUSH_STACK (pvm_make_int (INT_DIVIDE_OVERFLOW (a64, b), 32));
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for divlof . */

  //fprintf (stderr, "..Executed instruction %s\n", "divlof");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the divlof argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(divlof, divlof, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for divlof, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction divlu */
  JITTER_INSTRUCTION_PROLOG_(divlu, divlu, hot)
  { /* This block begins with definitions for divlu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       69
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         divlu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "divlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "divlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME divlu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of divlu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "divlu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for divlu . */
  {
/* User-specified code, user code block part: beginning. */
#line 3318 "./pvm.jitter"

    PVM_BINOP (ULONG, ULONG, ULONG, /);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for divlu . */

  //fprintf (stderr, "..Executed instruction %s\n", "divlu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the divlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(divlu, divlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for divlu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction drop */
  JITTER_INSTRUCTION_PROLOG_(drop, drop, hot)
  { /* This block begins with definitions for drop . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       70
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         drop
#   define JITTER_INSTRUCTION_NAME_AS_STRING "drop"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "drop"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME drop

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of drop ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "drop"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for drop . */
  {
/* User-specified code, user code block part: beginning. */
#line 2444 "./pvm.jitter"

    JITTER_DROP_STACK();
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for drop . */

  //fprintf (stderr, "..Executed instruction %s\n", "drop");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the drop argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(drop, drop, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for drop, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction drop2 */
  JITTER_INSTRUCTION_PROLOG_(drop2, drop2, hot)
  { /* This block begins with definitions for drop2 . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       71
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         drop2
#   define JITTER_INSTRUCTION_NAME_AS_STRING "drop2"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "drop2"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME drop2

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of drop2 ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "drop2"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for drop2 . */
  {
/* User-specified code, user code block part: beginning. */
#line 2456 "./pvm.jitter"

    JITTER_DROP_STACK();
    JITTER_DROP_STACK();
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for drop2 . */

  //fprintf (stderr, "..Executed instruction %s\n", "drop2");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the drop2 argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(drop2, drop2, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for drop2, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction drop3 */
  JITTER_INSTRUCTION_PROLOG_(drop3, drop3, hot)
  { /* This block begins with definitions for drop3 . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       72
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         drop3
#   define JITTER_INSTRUCTION_NAME_AS_STRING "drop3"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "drop3"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME drop3

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of drop3 ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "drop3"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for drop3 . */
  {
/* User-specified code, user code block part: beginning. */
#line 2469 "./pvm.jitter"

    JITTER_DROP_STACK();
    JITTER_DROP_STACK();
    JITTER_DROP_STACK();
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for drop3 . */

  //fprintf (stderr, "..Executed instruction %s\n", "drop3");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the drop3 argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(drop3, drop3, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for drop3, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction drop4 */
  JITTER_INSTRUCTION_PROLOG_(drop4, drop4, hot)
  { /* This block begins with definitions for drop4 . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       73
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         drop4
#   define JITTER_INSTRUCTION_NAME_AS_STRING "drop4"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "drop4"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME drop4

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of drop4 ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "drop4"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for drop4 . */
  {
/* User-specified code, user code block part: beginning. */
#line 2483 "./pvm.jitter"

    JITTER_DROP_STACK();
    JITTER_DROP_STACK();
    JITTER_DROP_STACK();
    JITTER_DROP_STACK();
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for drop4 . */

  //fprintf (stderr, "..Executed instruction %s\n", "drop4");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the drop4 argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(drop4, drop4, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for drop4, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction duc */
  JITTER_INSTRUCTION_PROLOG_(duc, duc, hot)
  { /* This block begins with definitions for duc . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       74
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         duc
#   define JITTER_INSTRUCTION_NAME_AS_STRING "duc"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "duc"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME duc

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of duc ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "duc"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for duc . */
  {
/* User-specified code, user code block part: beginning. */
#line 2039 "./pvm.jitter"

    pvm_val cls = JITTER_TOP_STACK ();
    pvm_val new_cls = pvm_make_cls (PVM_VAL_CLS_PROGRAM (cls),
                                    PVM_VAL_CLS_NAME (cls));

    JITTER_DROP_STACK ();
    JITTER_PUSH_STACK (new_cls);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for duc . */

  //fprintf (stderr, "..Executed instruction %s\n", "duc");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the duc argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(duc, duc, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for duc, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction dup */
  JITTER_INSTRUCTION_PROLOG_(dup, dup, hot)
  { /* This block begins with definitions for dup . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       75
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         dup
#   define JITTER_INSTRUCTION_NAME_AS_STRING "dup"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "dup"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME dup

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of dup ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "dup"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for dup . */
  {
/* User-specified code, user code block part: beginning. */
#line 2551 "./pvm.jitter"

    JITTER_DUP_STACK ();
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for dup . */

  //fprintf (stderr, "..Executed instruction %s\n", "dup");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the dup argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(dup, dup, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for dup, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction endhl/retR */
  JITTER_INSTRUCTION_PROLOG_(endhl/retR, endhl__retR, cold)
  { /* This block begins with definitions for endhl/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       76
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         endhl/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "endhl"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "endhl/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME endhl__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is non-relocatable.
       Its 0-th argument, a literal, is the return address where to jump
       at the end, back to relocated code. */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is non-relocatable.
       Its 0-th argument, a literal, is the return address where to jump
       at the end, back to relocated code. */

    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#ifdef JITTER_REPLICATE
/* When jumping to the non-relocatable part it is important not
   to use a fallback version of JITTER_COMPUTED_GOTO, in order to
   prevent GCC from tail-merging. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
    /* Jump to non-relocatable code. */
    JITTER_COMPUTED_GOTO(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE);

    /* Here the residual arity is given as zero: it's too late to
       skip residuals, since we've already jumped and this code is
       unreachable.  The instruction pointer, if any, is advanced
       in the non-relocatable code. */
    JITTER_INSTRUCTION_EPILOG_(endhl/retR, endhl__retR, 0)

    /* Relocated code will jump to this label in non-relocated code. */
  JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL:
    JITTER_COMMENT_IN_ASM_("endhl/retR non-relocatable code");
#endif // #ifdef JITTER_REPLICATE
#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of endhl/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  no. */
#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "endhl/retR"); fflush (stderr);
  //fprintf (stderr, "Executing non-relocatable instruction %s with JITTER_SPECIALIZED_INSTRUCTION_WORD_NO=%i..\n", "endhl/retR", (int) JITTER_SPECIALIZED_INSTRUCTION_WORD_NO); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for endhl/retR . */
  {
/* User-specified code, user code block part: beginning. */
#line 2179 "./pvm.jitter"

    JITTER_PUSH_STACK (pvm_make_int (!!pk_term_end_hyperlink (), 32));
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for endhl/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "endhl/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
#ifdef JITTER_REPLICATE
  {
    /* Advance the instruction pointer, if any, to skip every
       residual but the last; branch back to replicated
       code. */
    const void *_jitter_back_to_replicated_code_pointer =
      JITTER_ARGP0;
    JITTER_SKIP_RESIDUALS_;
    goto * _jitter_back_to_replicated_code_pointer;
  }
#endif // #ifdef JITTER_REPLICATE

    /* Undefine the endhl/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#ifndef JITTER_REPLICATE
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(endhl/retR, endhl__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#endif // #ifndef JITTER_REPLICATE
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for endhl/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction endsc/retR */
  JITTER_INSTRUCTION_PROLOG_(endsc/retR, endsc__retR, cold)
  { /* This block begins with definitions for endsc/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       77
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         endsc/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "endsc"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "endsc/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME endsc__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is non-relocatable.
       Its 0-th argument, a literal, is the return address where to jump
       at the end, back to relocated code. */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is non-relocatable.
       Its 0-th argument, a literal, is the return address where to jump
       at the end, back to relocated code. */

    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#ifdef JITTER_REPLICATE
/* When jumping to the non-relocatable part it is important not
   to use a fallback version of JITTER_COMPUTED_GOTO, in order to
   prevent GCC from tail-merging. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
    /* Jump to non-relocatable code. */
    JITTER_COMPUTED_GOTO(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE);

    /* Here the residual arity is given as zero: it's too late to
       skip residuals, since we've already jumped and this code is
       unreachable.  The instruction pointer, if any, is advanced
       in the non-relocatable code. */
    JITTER_INSTRUCTION_EPILOG_(endsc/retR, endsc__retR, 0)

    /* Relocated code will jump to this label in non-relocated code. */
  JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL:
    JITTER_COMMENT_IN_ASM_("endsc/retR non-relocatable code");
#endif // #ifdef JITTER_REPLICATE
#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of endsc/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  no. */
#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "endsc/retR"); fflush (stderr);
  //fprintf (stderr, "Executing non-relocatable instruction %s with JITTER_SPECIALIZED_INSTRUCTION_WORD_NO=%i..\n", "endsc/retR", (int) JITTER_SPECIALIZED_INSTRUCTION_WORD_NO); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for endsc/retR . */
  {
/* User-specified code, user code block part: beginning. */
#line 2212 "./pvm.jitter"

    pvm_val str = JITTER_TOP_STACK ();

    JITTER_DROP_STACK ();
    JITTER_PUSH_STACK (pvm_make_int (!!pk_term_end_class (PVM_VAL_STR (str)), 32));
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for endsc/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "endsc/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
#ifdef JITTER_REPLICATE
  {
    /* Advance the instruction pointer, if any, to skip every
       residual but the last; branch back to replicated
       code. */
    const void *_jitter_back_to_replicated_code_pointer =
      JITTER_ARGP0;
    JITTER_SKIP_RESIDUALS_;
    goto * _jitter_back_to_replicated_code_pointer;
  }
#endif // #ifdef JITTER_REPLICATE

    /* Undefine the endsc/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#ifndef JITTER_REPLICATE
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(endsc/retR, endsc__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#endif // #ifndef JITTER_REPLICATE
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for endsc/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction eqc */
  JITTER_INSTRUCTION_PROLOG_(eqc, eqc, hot)
  { /* This block begins with definitions for eqc . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       78
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         eqc
#   define JITTER_INSTRUCTION_NAME_AS_STRING "eqc"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "eqc"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME eqc

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of eqc ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "eqc"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for eqc . */
  {
/* User-specified code, user code block part: beginning. */
#line 3970 "./pvm.jitter"

    pvm_val res = PVM_MAKE_INT (JITTER_UNDER_TOP_STACK ()
                                == JITTER_TOP_STACK (),
                                32);
    JITTER_PUSH_STACK (res);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for eqc . */

  //fprintf (stderr, "..Executed instruction %s\n", "eqc");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the eqc argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(eqc, eqc, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for eqc, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction eqi */
  JITTER_INSTRUCTION_PROLOG_(eqi, eqi, hot)
  { /* This block begins with definitions for eqi . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       79
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         eqi
#   define JITTER_INSTRUCTION_NAME_AS_STRING "eqi"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "eqi"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME eqi

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of eqi ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "eqi"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for eqi . */
  {
/* User-specified code, user code block part: beginning. */
#line 3529 "./pvm.jitter"

     PVM_BOOL_BINOP (INT, ==);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for eqi . */

  //fprintf (stderr, "..Executed instruction %s\n", "eqi");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the eqi argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(eqi, eqi, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for eqi, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction eqiu */
  JITTER_INSTRUCTION_PROLOG_(eqiu, eqiu, hot)
  { /* This block begins with definitions for eqiu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       80
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         eqiu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "eqiu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "eqiu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME eqiu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of eqiu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "eqiu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for eqiu . */
  {
/* User-specified code, user code block part: beginning. */
#line 3542 "./pvm.jitter"

     PVM_BOOL_BINOP (UINT, ==);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for eqiu . */

  //fprintf (stderr, "..Executed instruction %s\n", "eqiu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the eqiu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(eqiu, eqiu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for eqiu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction eql */
  JITTER_INSTRUCTION_PROLOG_(eql, eql, hot)
  { /* This block begins with definitions for eql . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       81
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         eql
#   define JITTER_INSTRUCTION_NAME_AS_STRING "eql"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "eql"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME eql

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of eql ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "eql"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for eql . */
  {
/* User-specified code, user code block part: beginning. */
#line 3555 "./pvm.jitter"

     PVM_BOOL_BINOP (LONG, ==);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for eql . */

  //fprintf (stderr, "..Executed instruction %s\n", "eql");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the eql argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(eql, eql, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for eql, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction eqlu */
  JITTER_INSTRUCTION_PROLOG_(eqlu, eqlu, hot)
  { /* This block begins with definitions for eqlu . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       82
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         eqlu
#   define JITTER_INSTRUCTION_NAME_AS_STRING "eqlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "eqlu"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME eqlu

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of eqlu ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "eqlu"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for eqlu . */
  {
/* User-specified code, user code block part: beginning. */
#line 3568 "./pvm.jitter"

     PVM_BOOL_BINOP (ULONG, ==);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for eqlu . */

  //fprintf (stderr, "..Executed instruction %s\n", "eqlu");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the eqlu argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(eqlu, eqlu, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for eqlu, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction eqs */
  JITTER_INSTRUCTION_PROLOG_(eqs, eqs, hot)
  { /* This block begins with definitions for eqs . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       83
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         eqs
#   define JITTER_INSTRUCTION_NAME_AS_STRING "eqs"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "eqs"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME eqs

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of eqs ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (PVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (PVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (PVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "eqs"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for eqs . */
  {
/* User-specified code, user code block part: beginning. */
#line 3581 "./pvm.jitter"

    pvm_val res
      = PVM_MAKE_INT (pvm_strcmp (PVM_VAL_STR (JITTER_UNDER_TOP_STACK ()),
                                  PVM_VAL_STR (JITTER_TOP_STACK ())) == 0,
                      32);
    JITTER_PUSH_STACK (res);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for eqs . */

  //fprintf (stderr, "..Executed instruction %s\n", "eqs");
  {
/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the eqs argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(eqs, eqs, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for eqs, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction exit */
  JITTER_INSTRUCTION_PROLOG_(exit, exit, hot)
  { /* This block begins with definitions for exit . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       84
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         exit
#   define JITTER_INSTRUCTION_NAME_AS_STRING "exit"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "exit"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME exit

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp