/* This machine-generated file includes source code from GNU Jitter.

   Copyright (C) 2016-2021 Luca Saiu
   Written by Luca Saiu

   GNU Jitter is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published
   by the Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   GNU Jitter is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Jitter.  If not, see <https://www.gnu.org/licenses/>.


  Copyright (C) 2017, 2019, 2020, 2021, 2024 Luca Saiu
  Copyright (C) 2021 pEp Foundation
  Updated in 2025 by Luca Saiu
  Written by Luca Saiu

  This file is part of Structured, a GNU Jitter example.

  Structured is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Structured is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Structured.  If not, see <https://www.gnu.org/licenses/>.

*/

/* User-specified code, initial vm1 part: beginning. */

/* User-specified code, initial vm1 part: end */

/* VM library: main VM C file template.

   Copyright (C) 2016, 2017, 2018, 2019, 2020, 2021 Luca Saiu
   Written by Luca Saiu

   This file is part of GNU Jitter.

   GNU Jitter is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNU Jitter is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Jitter.  If not, see <https://www.gnu.org/licenses/>. */


/* Generated file warning.
 * ************************************************************************** */

/* Unless this file is named exactly "vm1.c" , without any prefix, you are
   looking at a machine-generated derived file.  The original source is the vm.c
   template from Jitter, with added code implementing the structuredvm VM. */




#include <jitter/jitter-early-header.h>

/* When we are using Gnulib the standard header files included below will in
   fact be Gnulib replacements; make sure that the Gnulib macros are
   recognised.
   It is in fact possible that  HAVE_CONFIG_H  is defined even in other
   contexts; it should be harmless to include config.h anyway. */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif // #ifdef HAVE_CONFIG_H

#include <assert.h>
#include <string.h>

#include <jitter/jitter.h>

#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
#include <sys/time.h>
#endif // #if defined (STRUCTUREDVM_PROFILE_SAMPLE)

#include <jitter/jitter-hash.h>
#include <jitter/jitter-instruction.h>
#include <jitter/jitter-mmap.h>
#include <jitter/jitter-mutable-routine.h>
#include <jitter/jitter-print.h>
#include <jitter/jitter-rewrite.h>
#include <jitter/jitter-routine.h>
#include <jitter/jitter-routine-parser.h>
#include <jitter/jitter-specialize.h>
#include <jitter/jitter-defect.h>
#include <jitter/jitter-patch-in.h>

/* I don't need to include <jitter/jitter-executor.h> here, nor to define
   JITTER_THIS_CAN_INCLUDE_JITTER_EXECUTOR_H ; doing so carelessly might
   lead to subtle bugs, that it is better to prevent.
   Of course I can reconsider this decision in the future. */

#include <jitter/jitter-data-locations.h>

#include "structuredvm-vm.h"
//#include "structuredvm-specialized-instructions.h"
//#include "structuredvm-meta-instructions.h"
#include <jitter/jitter-fatal.h>




/* Check requirements for particular features.
 * ************************************************************************** */

/* VM sample-profiling is only supported with GCC.  Do not bother activating it
   with other compilers, when the numbers would turn out to be unreliable in the
   end. */
#if  defined (STRUCTUREDVM_PROFILE_SAMPLE)        \
     && ! defined (JITTER_HAVE_ACTUAL_GCC)
# error "Sample-profiling is only supported with GCC: it requires (machine-independent)"
# error "GNU C extended asm.  It is not worth supporting other compilers if"
# error "the numbers turn out to be unreliable in the end."
#endif

/* Warn about the unreliability of sample-profiling with simple dispatches
   unless one of the complex dispatches is in use. */
#if  defined (STRUCTUREDVM_PROFILE_SAMPLE)                 \
     && ! defined (JITTER_DISPATCH_MINIMAL_THREADING)  \
     && ! defined (JITTER_DISPATCH_NO_THREADING)
# warning "Sample-profiling is unreliable with simple dispatches: the sample"
# warning "incrementation code can be executed at any point in the VM"
# warning "instruction, not necessarily at the same point (the beginning) for"
# warning "every VM instruction."
#endif




/* Machine-generated data structures.
 * ************************************************************************** */

/* Machine-generated data structures defining this VM.  Initializing a static
   struct is problematic, as it requires constant expressions for each field --
   and const pointers don't qualify.  This is why we initialize the struct
   fields below in structuredvm_initialize. */
static struct jitter_vm
the_structuredvm_vm;

struct jitter_vm * const
structuredvm_vm = & the_structuredvm_vm;

struct jitter_list_header * const
structuredvm_states = & the_structuredvm_vm.states;

/* It is convenient to have this initialised at start up, even before calling
   any initialisation function.  This makes it reliable to read this when, for
   example, handling --version . */
static const struct jitter_vm_configuration
structuredvm_vm_the_configuration
  = {
      STRUCTUREDVM_LOWER_CASE_PREFIX /* lower_case_prefix */,
      STRUCTUREDVM_UPPER_CASE_PREFIX /* upper_case_prefix */,
      STRUCTUREDVM_HASH_PREFIX /* hash_prefix */,
      STRUCTUREDVM_MAX_FAST_REGISTER_NO_PER_CLASS
        /* max_fast_register_no_per_class */,
      STRUCTUREDVM_MAX_NONRESIDUAL_LITERAL_NO /* max_nonresidual_literal_no */,
      STRUCTUREDVM_DISPATCH_HUMAN_READABLE /* dispatch_human_readable */,
      /* The instrumentation field can be seen as a bit map.  See the comment
         in jitter/jitter-vm.h . */
      (jitter_vm_instrumentation_none
#if defined (STRUCTUREDVM_PROFILE_COUNT)
       | jitter_vm_instrumentation_count
#endif
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
       | jitter_vm_instrumentation_sample
#endif
       ) /* instrumentation */
    };

const struct jitter_vm_configuration * const
structuredvm_vm_configuration
  = & structuredvm_vm_the_configuration;




/* Initialization and finalization: internal functions, not for the user.
 * ************************************************************************** */

/* Initialize threads.  This only needs to be called once at initialization, and
   the user doesn't need to bother with it.  Defined along with the executor. */
void
structuredvm_initialize_threads (void);

/* Check that the encodings in enum jitter_specialized_instruction_opcode (as
   used in the specializer) are coherent with machine-generated code.  Making a
   mistake here would introduce subtle bugs, so it's better to be defensive. */
static void
structuredvm_check_specialized_instruction_opcode_once (void)
{
  static bool already_checked = false;
  if (already_checked)
    return;

  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eINVALID)
          == jitter_specialized_instruction_opcode_INVALID);
  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eBEGINBASICBLOCK)
          == jitter_specialized_instruction_opcode_BEGINBASICBLOCK);
  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eEXITVM)
          == jitter_specialized_instruction_opcode_EXITVM);
  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eDATALOCATIONS)
          == jitter_specialized_instruction_opcode_DATALOCATIONS);
  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eNOP)
          == jitter_specialized_instruction_opcode_NOP);
  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eUNREACHABLE0)
          == jitter_specialized_instruction_opcode_UNREACHABLE0);
  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__eUNREACHABLE1)
          == jitter_specialized_instruction_opcode_UNREACHABLE1);
  assert (((enum jitter_specialized_instruction_opcode)
           structuredvm_specialized_instruction_opcode__ePRETENDTOJUMPANYWHERE)
          == jitter_specialized_instruction_opcode_PRETENDTOJUMPANYWHERE);

  already_checked = true;
}

/* A prototype for a machine-generated function not needing a public
   declaration, only called thru a pointer within struct jitter_vm . */
int
structuredvm_specialize_instruction (struct jitter_mutable_routine *p,
                                 const struct jitter_instruction *ins);

/* Initialize the pointed special-purpose data structure. */
static void
structuredvm_initialize_special_purpose_data
   (volatile struct jitter_special_purpose_state_data *d)
{
  d->pending_notifications = 0;
  jitter_initialize_pending_signal_notifications
     (& d->pending_signal_notifications);

  /* Initialise profiling fields. */
  jitter_profile_runtime_initialize (structuredvm_vm,
                                     (struct jitter_profile_runtime *)
                                     & d->profile_runtime);
}

/* Finalize the pointed special-purpose data structure. */
static void
structuredvm_finalize_special_purpose_data
   (volatile struct jitter_special_purpose_state_data *d)
{
  jitter_finalize_pending_signal_notifications
     (d->pending_signal_notifications);

  jitter_profile_runtime_finalize (structuredvm_vm,
                                   (struct jitter_profile_runtime *)
                                   & d->profile_runtime);
}




/* Check that we link with the correct Jitter library.
 * ************************************************************************** */

/* It is possible to make a mistake at link time, and link a VM compiled with
   some dispatch with the Jitter runtime for a different dispatch.  That
   would cause crashes that is better to prevent.  This is a way to detect such
   mistakes very early, by causing a link-time failure in case of mismatch. */
extern volatile const bool
JITTER_DISPATCH_DEPENDENT_GLOBAL_NAME;




/* Low-level debugging features relying on assembly: data locations.
 * ************************************************************************** */

#if defined (JITTER_HAVE_KNOWN_BINARY_FORMAT) && ! defined (JITTER_DISPATCH_SWITCH)
/* A declaration for data locations, as visible from C.  The global is defined in
   assembly in its own separate section thru the machinery in
   jitter/jitter-sections.h . */
extern const char
JITTER_DATA_LOCATION_NAME(structuredvm) [];
#endif // #if ...

void
structuredvm_dump_data_locations (jitter_print_context output)
{
#ifndef JITTER_DISPATCH_SWITCH
  jitter_dump_data_locations (output, & the_structuredvm_vm);
#else
  jitter_print_char_star (output,
                          "VM data location information unavailable\n");
#endif // #ifndef JITTER_DISPATCH_SWITCH
}




/* Initialization and finalization.
 * ************************************************************************** */

#if defined (JITTER_HAVE_DEFECT_REPLACEMENT)
JITTER_DEFECT_DESCRIPTOR_DECLARATIONS_(structuredvm)

/* This global is defined from C: there is no particular need of doing it in
   assembly.  It is initialised in structuredvm_execute_or_initialize , where C
   labels are visible. */ // FIXME: unless it turns out to be simpler in assembly ...
jitter_int
structuredvm_defect_descriptors_correct_displacement;
#endif // #if defined (JITTER_HAVE_DEFECT_REPLACEMENT)
#if defined (JITTER_HAVE_PATCH_IN)
JITTER_PATCH_IN_DESCRIPTOR_DECLARATIONS_(structuredvm)
#endif // #if defined (JITTER_HAVE_PATCH_IN)

#ifndef JITTER_DISPATCH_SWITCH
/* True iff thread sizes are all non-negative and non-huge.  We refuse to
   disassemble otherwise, and when replication is enabled we refuse to run
   altogether.  See the comment right below. */
static bool
structuredvm_threads_validated = false;
#endif // #ifndef JITTER_DISPATCH_SWITCH

/* Omit structuredvm_validate_thread_sizes_once for switch-dispatching, as threads
   don't exist at all in that case.*/
#ifndef JITTER_DISPATCH_SWITCH
/* Check that VM instruction sizes are all non-negative, and that no thread
   starts before the end of the previous one.  Even one violation of such
   conditions is a symptom that the code has not been compiled with
   -fno-reorder-blocks , which would have disastrous effects with replication.
   It's better to validate threads at startup and fail immediately than to crash
   at run time.

   If even one thread appears to be wrong then refuse to disassemble when
   replication is disabled, and refuse to run altogether if replication is
   enabled. */
static void
structuredvm_validate_threads_once (void)
{
  /* Return if this is not the first time we got here. */
  static bool already_validated = false;
  if (already_validated)
    return;

#ifdef JITTER_REPLICATE
# define JITTER_FAIL(error_text)                                             \
    do                                                                       \
      {                                                                      \
        fprintf (stderr,                                                     \
                 "About specialized instruction %i (%s) at %p, size %liB\n", \
                 i, structuredvm_specialized_instruction_names [i],              \
                 structuredvm_threads [i],                                       \
                 structuredvm_thread_sizes [i]);                                 \
        jitter_fatal ("%s: you are not compiling with -fno-reorder-blocks",  \
                      error_text);                                           \
      }                                                                      \
    while (false)
#else
# define JITTER_FAIL(ignored_error_text)  \
    do                                    \
      {                                   \
        everything_valid = false;         \
        goto out;                         \
      }                                   \
    while (false)
#endif // #ifdef JITTER_REPLICATE

  /* The minimum address the next instruction code has to start at.

     This relies on NULL being zero, or in general lower in magnitude than any
     valid pointer.  It is not worth the trouble to be pedantic, as this will be
     true on every architecture where I can afford low-level tricks. */
  jitter_thread lower_bound = NULL;

  /* Check every thread.  We rely on the order here, following specialized
     instruction opcodes. */
  int i;
  bool everything_valid = true;
  for (i = 0; i < STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO; i ++)
    {
      jitter_thread thread = structuredvm_threads [i];
      long size = structuredvm_thread_sizes [i];

      /* Check that the current thread has non-negative non-huge size and
         doesn't start before the end of the previous one.  If this is true for
         all threads we can conclude that they are non-overlapping as well. */
      if (__builtin_expect (size < 0, false))
        JITTER_FAIL("a specialized instruction has negative code size");
      if (__builtin_expect (size > (1 << 24), false))
        JITTER_FAIL("a specialized instruction has huge code size");
      if (__builtin_expect (lower_bound > thread, false))
        JITTER_FAIL("non-sequential thread");

      /* The next thread cannot start before the end of the current one. */
      lower_bound = ((char*) thread) + size;
    }

#undef JITTER_FAIL

#ifndef JITTER_REPLICATE
 out:
#endif // #ifndef JITTER_REPLICATE

  /* If we have validated every thread size then disassembling appears safe. */
  if (everything_valid)
    structuredvm_threads_validated = true;

  /* We have checked the thread sizes, once and for all.  If this function gets
     called again, thru a second structuredvm initialization, it will immediately
     return. */
  already_validated = true;
}
#endif // #ifndef JITTER_DISPATCH_SWITCH

#if defined (JITTER_HAVE_DEFECT_REPLACEMENT)
/* The actual replacement table.  We only need it when defect replacement is in
   use. */
jitter_uint
structuredvm_replacement_table [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO];

/* The defective-instruction array for this VM.  The first
   defective_specialized_instruction_no elements of the array contain the
   specialized_instruction_ids of defective instructions; the remaining elements
   are set to -1.  This is initialised by jitter_fill_replacement_table . */
jitter_int
structuredvm_defective_specialized_instructions [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO];
#endif // #if defined (JITTER_HAVE_DEFECT_REPLACEMENT)

void
structuredvm_initialize (void)
{
  /* Check that the Jitter library we linked is the right one.  This check
     actually only useful to force the global to be used.  I prefer not to use
     an assert, because assertions can be disabled. */
  if (! JITTER_DISPATCH_DEPENDENT_GLOBAL_NAME)
    jitter_fatal ("impossible to reach: the thing should fail at link time");

#ifdef JITTER_REPLICATE
  /* Initialize the executable-memory subsystem. */
  jitter_initialize_executable ();
#endif // #ifdef JITTER_REPLICATE

  /* Initialise the print-context machinery. */
  jitter_print_initialize ();

  /* Perform some sanity checks which only need to be run once. */
  structuredvm_check_specialized_instruction_opcode_once ();

  /* We have to initialize threads before structuredvm_threads , since the struct
     needs threads. */
  structuredvm_initialize_threads ();

#ifndef JITTER_DISPATCH_SWITCH
  /* Validate threads, to make sure the generated code was not compiled with
     incorrect options.  This only needs to be done once. */
  structuredvm_validate_threads_once ();
#endif // ifndef JITTER_DISPATCH_SWITCH

  /* Initialize the object pointed by structuredvm_vm (see the comment above as to
     why we do it here).  Before actually setting the fields to valid data, fill
     the whole struct with a -- hopefully -- invalid pattern, just to catch
     bugs. */
  static bool vm_struct_initialized = false;
  if (! vm_struct_initialized)
    {
      memset (& the_structuredvm_vm, 0xff, sizeof (struct jitter_vm));

      /* Make the configuration struct reachable from the VM struct. */
      the_structuredvm_vm.configuration = structuredvm_vm_configuration;
      //structuredvm_print_vm_configuration (stdout, & the_structuredvm_vm.configuration);

      /* Initialize meta-instruction pointers for implicit instructions.
         VM-independent program specialization relies on those, so they have to
         be accessible to the Jitter library, out of generated code.  Since
         meta-instructions are sorted alphabetically in the array, the index
         is not fixed. */
      the_structuredvm_vm.exitvm_meta_instruction
        = (structuredvm_meta_instructions + structuredvm_meta_instruction_id_exitvm);
      the_structuredvm_vm.unreachable_meta_instruction
        = (structuredvm_meta_instructions
           + structuredvm_meta_instruction_id_unreachable);

      /* Threads or pointers to native code blocks of course don't exist with
         switch-dispatching. */
#ifndef JITTER_DISPATCH_SWITCH
      the_structuredvm_vm.threads = (jitter_thread *)structuredvm_threads;
      the_structuredvm_vm.thread_sizes = (long *) structuredvm_thread_sizes;
      the_structuredvm_vm.threads_validated = structuredvm_threads_validated;
#if defined (JITTER_HAVE_KNOWN_BINARY_FORMAT)
      the_structuredvm_vm.data_locations = JITTER_DATA_LOCATION_NAME(structuredvm);
#else
      the_structuredvm_vm.data_locations = NULL;
#endif // #if defined (JITTER_HAVE_KNOWN_BINARY_FORMAT)
#endif // #ifndef JITTER_DISPATCH_SWITCH

      the_structuredvm_vm.specialized_instruction_residual_arities
        = structuredvm_specialized_instruction_residual_arities;
      the_structuredvm_vm.specialized_instruction_label_bitmasks
        = structuredvm_specialized_instruction_label_bitmasks;

      /* FIXME: I might want to conditionalize this. */
      the_structuredvm_vm.specialized_instruction_relocatables
        = structuredvm_specialized_instruction_relocatables;

      the_structuredvm_vm.specialized_instruction_callers
        = structuredvm_specialized_instruction_callers;
      the_structuredvm_vm.specialized_instruction_callees
        = structuredvm_specialized_instruction_callees;

      the_structuredvm_vm.specialized_instruction_names
        = structuredvm_specialized_instruction_names;
      the_structuredvm_vm.specialized_instruction_no
        = STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO;

      the_structuredvm_vm.meta_instruction_string_hash
        = & structuredvm_meta_instruction_hash;
      the_structuredvm_vm.meta_instructions
        = (struct jitter_meta_instruction *) structuredvm_meta_instructions;
      the_structuredvm_vm.meta_instruction_no = STRUCTUREDVM_META_INSTRUCTION_NO;
      the_structuredvm_vm.max_meta_instruction_name_length
        = STRUCTUREDVM_MAX_META_INSTRUCTION_NAME_LENGTH;
      the_structuredvm_vm.specialized_instruction_to_unspecialized_instruction
        = structuredvm_specialized_instruction_to_unspecialized_instruction;
      the_structuredvm_vm.register_class_character_to_register_class
        = structuredvm_register_class_character_to_register_class;
      the_structuredvm_vm.specialize_instruction = structuredvm_specialize_instruction;
      the_structuredvm_vm.rewrite = structuredvm_rewrite;

#if defined (JITTER_HAVE_DEFECT_REPLACEMENT)
      /* Fill the replacement table.  Since the array in question is a global
         with a fixed size, this needs to be done only once. */
      jitter_fill_replacement_table
         (structuredvm_replacement_table,
          structuredvm_defective_specialized_instructions,
          & the_structuredvm_vm,
          structuredvm_worst_case_replacement_table,
          structuredvm_call_related_specialized_instruction_ids,
          structuredvm_call_related_specialized_instruction_id_no,
          structuredvm_specialized_instruction_call_relateds,
          JITTER_DEFECT_DESCRIPTORS_NAME (structuredvm),
          (JITTER_DEFECT_DESCRIPTORS_SIZE_IN_BYTES_NAME (structuredvm)
           / sizeof (struct jitter_defect_descriptor)),
          JITTER_DEFECT_CORRECT_DISPLACEMENT_NAME (structuredvm));
      the_structuredvm_vm.replacement_table = structuredvm_replacement_table;
      the_structuredvm_vm.defective_specialized_instructions
        = structuredvm_defective_specialized_instructions;
      the_structuredvm_vm.specialized_instruction_call_relateds
        = structuredvm_specialized_instruction_call_relateds;
#else /* no defect replacement */
      /* In this configuration it is impossible to have defects: set every
         defect count to zero. */
      the_structuredvm_vm.defect_no = 0;
      the_structuredvm_vm.defective_specialized_instruction_no = 0;
      the_structuredvm_vm.defective_call_related_specialized_instruction_no = 0;
      the_structuredvm_vm.replacement_specialized_instruction_no = 0;
      the_structuredvm_vm.replacement_table = NULL;
      the_structuredvm_vm.defective_specialized_instructions = NULL;
      the_structuredvm_vm.specialized_instruction_call_relateds = NULL;
#endif // #if defined (JITTER_HAVE_DEFECT_REPLACEMENT)

      /* Initialize the empty list of states. */
      JITTER_LIST_INITIALIZE_HEADER (& the_structuredvm_vm.states);

      vm_struct_initialized = true;
    }

#ifdef JITTER_HAVE_PATCH_IN
    /* Since the patch-in table is destroyed at finalisation time we have to
       rebuild it at every initialisation, out of the previous conditional. */
    the_structuredvm_vm.specialized_instruction_fast_label_bitmasks
      = structuredvm_specialized_instruction_fast_label_bitmasks;
    the_structuredvm_vm.patch_in_descriptors =
      JITTER_PATCH_IN_DESCRIPTORS_NAME(structuredvm);
    const size_t patch_in_descriptor_size
      = sizeof (struct jitter_patch_in_descriptor);
    the_structuredvm_vm.patch_in_descriptor_no
      = (JITTER_PATCH_IN_DESCRIPTORS_SIZE_IN_BYTES_NAME(structuredvm)
         / patch_in_descriptor_size);
    /* Cheap sanity check: if the size in bytes is not a multiple of
       the element size, we are doing something very wrong. */
    if (JITTER_PATCH_IN_DESCRIPTORS_SIZE_IN_BYTES_NAME(structuredvm)
        % patch_in_descriptor_size != 0)
      jitter_fatal ("patch-in descriptors total size %li not a multiple "
                    "of the element size %li",
                    (long) (JITTER_PATCH_IN_DESCRIPTORS_SIZE_IN_BYTES_NAME
                            (structuredvm)),
                    (long) patch_in_descriptor_size);
    /* Initialize the patch-in table for this VM. */
    the_structuredvm_vm.patch_in_table
      = jitter_make_patch_in_table (the_structuredvm_vm.patch_in_descriptors,
                                    the_structuredvm_vm.patch_in_descriptor_no,
                                    STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO);
#else
    the_structuredvm_vm.specialized_instruction_fast_label_bitmasks = NULL;
#endif // #ifdef JITTER_HAVE_PATCH_IN

  jitter_initialize_meta_instructions (& structuredvm_meta_instruction_hash,
                                         structuredvm_meta_instructions,
                                         STRUCTUREDVM_META_INSTRUCTION_NO);

#if defined (JITTER_HAVE_DEFECT_REPLACEMENT)
# if 0
  jitter_dump_replacement_table (stderr, structuredvm_replacement_table,
                                 & the_structuredvm_vm);
  jitter_dump_defects (stderr, structuredvm_defective_specialized_instructions,
                       & the_structuredvm_vm,
                       structuredvm_specialized_instruction_call_relateds);
# endif
#endif // #if defined (JITTER_HAVE_DEFECT_REPLACEMENT)
#if defined (JITTER_HAVE_PATCH_IN)
  //printf ("======================= Patch-in descriptors: BEGIN\n");
  //JITTER_DUMP_PATCH_IN_DESCRIPTORS(structuredvm);
  //printf ("======================= Patch-in descriptors: END\n");
#endif // #if defined (JITTER_HAVE_PATCH_IN)
}

void
structuredvm_finalize (void)
{
  /* There's no need to touch the_structuredvm_vm ; we can keep it as it is, as it
     contains no dynamically-allocated fields. */
  /* Threads need no finalization. */
  jitter_finalize_meta_instructions (& structuredvm_meta_instruction_hash);

#ifdef JITTER_HAVE_PATCH_IN
  /* Destroy the patch-in table for this VM. */
  jitter_destroy_patch_in_table (the_structuredvm_vm.patch_in_table,
                                 STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO);
#endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
  /* Finalize the executable-memory subsystem. */
  jitter_finalize_executable ();
#endif // #ifdef JITTER_REPLICATE

  /* Finalize the state list.  If it is not empty then something has gone
     wrong earlier. */
  if (the_structuredvm_vm.states.first != NULL
      || the_structuredvm_vm.states.last != NULL)
    jitter_fatal ("not every state structure was destroyed before STRUCTUREDVM "
                  "finalisation.");
}




/* VM-dependant mutable routine initialization.
 * ************************************************************************** */

struct jitter_mutable_routine*
structuredvm_make_mutable_routine (void)
{
  return jitter_make_mutable_routine (structuredvm_vm);
}




/* Sample profiling: internal API.
 * ************************************************************************** */

#if defined (STRUCTUREDVM_PROFILE_SAMPLE)

/* Sample profiling depends on some system features: fail immediately if they
   are not available */
#if ! defined (JITTER_HAVE_SIGACTION) || ! defined (JITTER_HAVE_SETITIMER)
# jitter_fatal "sample-profiling depends on sigaction and setitimer"
#endif

static struct itimerval
structuredvm_timer_interval;

static struct itimerval
structuredvm_timer_disabled_interval;

/* The sampling data, currently global.  The current implementation does not
   play well with threads, but it can be changed later keeping the same user
   API. */
struct structuredvm_sample_profile_state
{
  /* The state currently sample-profiling.  Since such a state can be only one
     right now this field is useful for printing error messages in case the user
     sets up sample-profiling from two states at the same time by mistake.
     This field is also useful for temporarily suspending and then reenabling
     sampling, when The Array is being resized: if the signal handler sees that
     this field is NULL it will not touch the fields. */
  struct structuredvm_state *state_p;

  /* A pointer to the counts field within the sample_profile_runtime struct. */
  uint32_t *counts;

  /* A pointer to the current specialised instruction opcode within the
     sample_profile_runtime struct. */
  volatile jitter_int * specialized_opcode_p;

  /* A pointer to the field counting the number of samples, again within the
     sample_profile_runtime struct. */
  unsigned int *sample_no_p;
};

/* The (currently) one and only global state for sample-profiling. */
static struct structuredvm_sample_profile_state
structuredvm_sample_profile_state;

static void
structuredvm_sigprof_handler (int signal)
{
#if 0
  assert (structuredvm_sample_profile_state.state_p != NULL);
#endif

  jitter_int specialized_opcode
    = * structuredvm_sample_profile_state.specialized_opcode_p;
  if (__builtin_expect ((specialized_opcode >= 0
                         && (specialized_opcode
                             < STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO)),
                        true))
    structuredvm_sample_profile_state.counts [specialized_opcode] ++;

  (* structuredvm_sample_profile_state.sample_no_p) ++;
}

void
structuredvm_profile_sample_initialize (void)
{
  /* Perform a sanity check over the sampling period. */
  if (JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS <= 0 ||
      JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS >= 1000)
    jitter_fatal ("invalid JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS: %f",
                  (double) JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS);
  struct sigaction action;
  sigaction (SIGPROF, NULL, & action);
  action.sa_handler = structuredvm_sigprof_handler;
  sigaction (SIGPROF, & action, NULL);

  long microseconds
    = (long) (JITTER_PROFILE_SAMPLE_PERIOD_IN_MILLISECONDS * 1000);
  structuredvm_timer_interval.it_interval.tv_sec = 0;
  structuredvm_timer_interval.it_interval.tv_usec = microseconds;
  structuredvm_timer_interval.it_value = structuredvm_timer_interval.it_interval;

  structuredvm_sample_profile_state.state_p = NULL;
  structuredvm_timer_disabled_interval.it_interval.tv_sec = 0;
  structuredvm_timer_disabled_interval.it_interval.tv_usec = 0;
  structuredvm_timer_disabled_interval.it_value
    = structuredvm_timer_disabled_interval.it_interval;
}

void
structuredvm_profile_sample_start (struct structuredvm_state *state_p)
{
  struct jitter_sample_profile_runtime *spr
    = ((struct jitter_sample_profile_runtime *)
       & STRUCTUREDVM_STATE_TO_SPECIAL_PURPOSE_STATE_DATA (state_p)
           ->profile_runtime.sample_profile_runtime);

  if (structuredvm_sample_profile_state.state_p != NULL)
    {
      if (state_p != structuredvm_sample_profile_state.state_p)
        jitter_fatal ("currently it is only possible to sample-profile from "
                      "one state at the time: trying to sample-profile from "
                      "the state %p when already sample-profiling from the "
                      "state %p",
                      state_p, structuredvm_sample_profile_state.state_p);
      else
        {
          /* This situation is a symptom of a bug, but does not need to lead
             to a fatal error. */
          printf ("WARNING: starting profile on the state %p when profiling "
                  "was already active in the same state.\n"
                  "Did you call longjmp from VM code?", state_p);
          fflush (stdout);
        }
    }
  structuredvm_sample_profile_state.state_p = state_p;
  structuredvm_sample_profile_state.sample_no_p = & spr->sample_no;
  structuredvm_sample_profile_state.counts = spr->counts;
  structuredvm_sample_profile_state.specialized_opcode_p
    = & spr->current_specialized_instruction_opcode;
  //fprintf (stderr, "SAMPLE START\n"); fflush (NULL);
  if (setitimer (ITIMER_PROF, & structuredvm_timer_interval, NULL) != 0)
    jitter_fatal ("setitimer failed when establishing a timer");
}

void
structuredvm_profile_sample_stop (void)
{
  if (setitimer (ITIMER_PROF, & structuredvm_timer_disabled_interval, NULL) != 0)
    jitter_fatal ("setitimer failed when disabling a timer");

  structuredvm_sample_profile_state.state_p = NULL;

  /* The rest is just for defenisveness' sake. */
  * structuredvm_sample_profile_state.specialized_opcode_p = -1;
  structuredvm_sample_profile_state.sample_no_p = NULL;
  structuredvm_sample_profile_state.counts = NULL;
  structuredvm_sample_profile_state.specialized_opcode_p = NULL;
}
#endif // #if defined (STRUCTUREDVM_PROFILE_SAMPLE)




/* Slow register initialisation.
 * ************************************************************************** */

/* Initialise slow registers (for register classes defining an initial value) in
   a given Array, starting from a given rank up to another given rank.  The
   argument old_slow_register_no_per_class indicates the number of already
   initialised ranks, which this functions does not touch;
   new_slow_register_no_per_class indicates the new number of ranks.  Every rank
   from old_slow_register_no_per_class + 1 to new_slow_register_no_per_class,
   both included, will be initialised. */
static void
structuredvm_initialize_slow_registers (char *initial_array_pointer,
                                    jitter_int old_slow_register_no_per_class,
                                    jitter_int new_slow_register_no_per_class)
{
  /* Compute the address of the first slow registers, which is the beginning
     of the first rank. */
  union structuredvm_any_register *first_slow_register
    = ((union structuredvm_any_register *)
       ((char *) initial_array_pointer
        + STRUCTUREDVM_FIRST_SLOW_REGISTER_UNBIASED_OFFSET));

  /* Initialise every *new* rank, without touching the old ones. */
  jitter_int i;
  for (i = old_slow_register_no_per_class;
       i < new_slow_register_no_per_class;
       i ++)
    {
      /* A pointer to the i-th rank of slow registers.  Every register
         in the rank is new and in general (according to its class) may
         need initialisation. */
      union structuredvm_any_register *rank
        = first_slow_register + (i * STRUCTUREDVM_REGISTER_CLASS_NO);
      STRUCTUREDVM_INITIALIZE_SLOW_REGISTER_RANK (rank);
    }
#if 0
      fprintf (stderr, "initialised %li (up from %li) slow registers per class, array at %p\n",
               (long) new_slow_register_no_per_class,
               (long) old_slow_register_no_per_class,
               initial_array_pointer);
#endif
}




/* Array re-allocation.
 * ************************************************************************** */

char *
structuredvm_make_place_for_slow_registers (struct structuredvm_state *s,
                                        jitter_int new_slow_register_no_per_class)
{
  if (new_slow_register_no_per_class < 0)
    jitter_fatal ("structuredvm_make_place_for_slow_registers: negative slow "
                  "register number");
  jitter_int old_slow_register_no_per_class
    = s->structuredvm_state_backing.jitter_slow_register_no_per_class;
  /* Change nothing if we already have enough space for the required number of
     slow registers.  The no-change case will be the most common one, and
     this function might be worth optimizing. */
  if (__builtin_expect (new_slow_register_no_per_class
                        > old_slow_register_no_per_class,
                        false))
    {
#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
      /* If sample-profiling is currently in progress on this state suspend it
         temporarily. */
      bool suspending_sample_profiling
        = (structuredvm_sample_profile_state.state_p == s);
      if (suspending_sample_profiling)
        structuredvm_profile_sample_stop ();
#endif // #if defined (STRUCTUREDVM_PROFILE_SAMPLE)

#if 0
      printf ("Increasing slow register-no (per class) from %li to %li\n", (long) old_slow_register_no_per_class, (long)new_slow_register_no_per_class);
      printf ("Array size %li -> %li\n", (long) STRUCTUREDVM_ARRAY_SIZE(old_slow_register_no_per_class), (long) STRUCTUREDVM_ARRAY_SIZE(new_slow_register_no_per_class));
#endif
      /* Save the new value for new_slow_register_no_per_class in the state
         structure; reallocate The Array. */
      s->structuredvm_state_backing.jitter_slow_register_no_per_class
        = new_slow_register_no_per_class;
      s->structuredvm_state_backing.jitter_array
        = jitter_xrealloc ((void *) s->structuredvm_state_backing.jitter_array,
                           STRUCTUREDVM_ARRAY_SIZE(new_slow_register_no_per_class));

     /* Initialise the slow registers we have just added, for every class. */
     structuredvm_initialize_slow_registers (s->structuredvm_state_backing.jitter_array,
                                         old_slow_register_no_per_class,
                                         new_slow_register_no_per_class);

#if defined (STRUCTUREDVM_PROFILE_SAMPLE)
      /* Now we can resume sample-profiling on this state if we suspended it. */
      if (suspending_sample_profiling)
        structuredvm_profile_sample_start (s);
#endif // #if defined (STRUCTUREDVM_PROFILE_SAMPLE)
#if 0
      fprintf (stderr, "slow registers are now %li per class, Array at %p (biased %p)\n",
               ((long)
                s->structuredvm_state_backing.jitter_slow_register_no_per_class),
               s->structuredvm_state_backing.jitter_array,
               s->structuredvm_state_backing.jitter_array + JITTER_ARRAY_BIAS);
#endif
    }

  /* Return the new (or unchanged) base, by simply adding the bias to the
     Array as it is now. */
  return s->structuredvm_state_backing.jitter_array + JITTER_ARRAY_BIAS;
}

void
structuredvm_ensure_enough_slow_registers_for_executable_routine
   (const struct jitter_executable_routine *er, struct structuredvm_state *s)
{
  structuredvm_make_place_for_slow_registers (s, er->slow_register_per_class_no);
}




/* Program text frontend.
 * ************************************************************************** */

struct structuredvm_routine_parse_error *
structuredvm_parse_mutable_routine_from_file_star (FILE *input_file,
                                               struct jitter_mutable_routine *p)
{
  return jitter_parse_mutable_routine_from_file_star (input_file, p,
                                                      structuredvm_vm);
}

struct structuredvm_routine_parse_error *
structuredvm_parse_mutable_routine_from_file (const char *input_file_name,
                                          struct jitter_mutable_routine *p)
{
  return jitter_parse_mutable_routine_from_file (input_file_name, p,
                                                 structuredvm_vm);
}

struct structuredvm_routine_parse_error *
structuredvm_parse_mutable_routine_from_string (const char *string,
                                            struct jitter_mutable_routine *p)
{
  return jitter_parse_mutable_routine_from_string (string, p, structuredvm_vm);
}




/* State making and destroying.
 * ************************************************************************** */

/* State initialisation (with a given number of slow registers), reset and
   finalisation are machine-generated. */

void
structuredvm_state_initialize (struct structuredvm_state *sp)
{
  structuredvm_state_initialize_with_slow_registers (sp, 0);
}

struct structuredvm_state *
structuredvm_state_make_with_slow_registers (jitter_uint slow_register_no_per_class)
{
  struct structuredvm_state *res = jitter_xmalloc (sizeof (struct structuredvm_state));
  structuredvm_state_initialize_with_slow_registers (res,
                                                 slow_register_no_per_class);
  return res;
}

struct structuredvm_state *
structuredvm_state_make (void)
{
  return structuredvm_state_make_with_slow_registers (0);
}

void
structuredvm_state_destroy (struct structuredvm_state *state)
{
  structuredvm_state_finalize (state);
  free (state);
}




/* Executing code: unified routine API.
 * ************************************************************************** */

void
structuredvm_ensure_enough_slow_registers_for_routine
   (jitter_routine r, struct structuredvm_state *s)
{
  struct jitter_executable_routine *e
    = jitter_routine_make_executable_if_needed (r);
  structuredvm_ensure_enough_slow_registers_for_executable_routine (e, s);
}

enum structuredvm_exit_status
structuredvm_execute_routine (jitter_routine r,
                          struct structuredvm_state *s)
{
  struct jitter_executable_routine *e
    = jitter_routine_make_executable_if_needed (r);
  return structuredvm_execute_executable_routine (e, s);
}





/* Defects and replacements: user API.
 * ************************************************************************** */

/* These functions are all trivial wrappers around the functionality declared
   in jitter/jitter-defect.h, hiding the VM pointer. */

void
structuredvm_defect_print_summary (jitter_print_context cx)
{
  jitter_defect_print_summary (cx, structuredvm_vm);
}

void
structuredvm_defect_print (jitter_print_context cx,
                       unsigned indentation_column_no)
{
  jitter_defect_print (cx, structuredvm_vm, indentation_column_no);
}

void
structuredvm_defect_print_replacement_table (jitter_print_context cx,
                                         unsigned indentation_column_no)
{
  jitter_defect_print_replacement_table (cx, structuredvm_vm, indentation_column_no);
}




/* Profiling: user API.
 * ************************************************************************** */

/* These functions are all trivial wrappers around the functionality declared
   in jitter/jitter-profile.h, hiding the VM pointer. */

struct structuredvm_profile_runtime *
structuredvm_state_profile_runtime (struct structuredvm_state *s)
{
  volatile struct jitter_special_purpose_state_data *spd
    = STRUCTUREDVM_ARRAY_TO_SPECIAL_PURPOSE_STATE_DATA
        (s->structuredvm_state_backing.jitter_array);
  return (struct structuredvm_profile_runtime *) & spd->profile_runtime;
}

struct structuredvm_profile_runtime *
structuredvm_profile_runtime_make (void)
{
  return jitter_profile_runtime_make (structuredvm_vm);
}

void
structuredvm_profile_runtime_destroy (struct structuredvm_profile_runtime *p)
{
  jitter_profile_runtime_destroy (structuredvm_vm, p);
}

void
structuredvm_profile_runtime_clear (struct structuredvm_profile_runtime * p)
{
  jitter_profile_runtime_clear (structuredvm_vm, p);
}

void
structuredvm_profile_runtime_merge_from (struct structuredvm_profile_runtime *to,
                                     const struct structuredvm_profile_runtime *from)
{
  jitter_profile_runtime_merge_from (structuredvm_vm, to, from);
}

void
structuredvm_profile_runtime_merge_from_state (struct structuredvm_profile_runtime *to,
                                           const struct structuredvm_state *from_state)
{
  const struct structuredvm_profile_runtime* from
    = structuredvm_state_profile_runtime ((struct structuredvm_state *) from_state);
  jitter_profile_runtime_merge_from (structuredvm_vm, to, from);
}

void
structuredvm_profile_runtime_print_unspecialized
   (jitter_print_context ct,
    const struct structuredvm_profile_runtime *p)
{
  jitter_profile_runtime_print_unspecialized (ct, structuredvm_vm, p);
}

void
structuredvm_profile_runtime_print_specialized (jitter_print_context ct,
                                            const struct structuredvm_profile_runtime
                                            *p)
{
  jitter_profile_runtime_print_specialized (ct, structuredvm_vm, p);
}

struct structuredvm_profile *
structuredvm_profile_unspecialized_from_runtime
   (const struct structuredvm_profile_runtime *p)
{
  return jitter_profile_unspecialized_from_runtime (structuredvm_vm, p);
}

struct structuredvm_profile *
structuredvm_profile_specialized_from_runtime (const struct structuredvm_profile_runtime
                                           *p)
{
  return jitter_profile_specialized_from_runtime (structuredvm_vm, p);
}




/* Evrything following this point is machine-generated.
 * ************************************************************************** */

/* What follows could be conceptually split into several generated C files, but
   having too many of them would be inconvenient for the user to compile and
   link.  For this reason we currently generate just three files: one is this,
   which also contains the specializer, another is for the executor, and then a
   header -- a main module is optional.  The executor will be potentially very
   large, so it is best compiled separately.  The specializer might be large as
   well at this stage, even if its compilation is usually much less
   expensive. */
/* These two macros are convenient for making VM-specific identifiers
   using VM-independent macros from a public header, without polluting
   the global namespace. */
#define JITTER_VM_PREFIX_LOWER_CASE structuredvm
#define JITTER_VM_PREFIX_UPPER_CASE STRUCTUREDVM

/* User-specified code, printer part: beginning. */

static void
structured_literal_printer (jitter_print_context out, jitter_uint u,
                            void *user_data /* ignored */)
{
  jitter_print_begin_class (out, "structuredvm-number");
  jitter_print_jitter_uint (out, 10, u);
  jitter_print_end_class (out);
}
  
/* User-specified code, printer part: end */

//#include <stdbool.h>

//#include <jitter/jitter.h>
//#include <jitter/jitter-instruction.h>

//#include "structuredvm-meta-instructions.h"

// FIXME: comment.
struct jitter_hash_table
structuredvm_meta_instruction_hash;


static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_b_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_be_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_beqi_mstack_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bf_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bg_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bge_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bl_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_ble_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bne_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bneqi_mstack_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_bt_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_call_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_label, NULL, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_copy_mto_mr_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_divided_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_equali_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, structured_literal_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_input_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_load_mboxed_mliteral_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_minus_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_minusi_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, structured_literal_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_mov_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_plus_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_plusi_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, structured_literal_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_pop_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_print_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_push_mboxed_mliteral_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_literal_fixnum, NULL, structured_literal_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_push_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum_or_literal_label, & structuredvm_register_class_r, structured_literal_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_remainder_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_times_meta_instruction_parameter_types [3] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_uminus_meta_instruction_parameter_types [2] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, structured_literal_printer }, { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_underpop_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };

static const /*FIXME: use enum jitterc_instruction_argument_kind instead*/struct jitter_meta_instruction_parameter_type structuredvm_underpush_mstack_meta_instruction_parameter_types [1] =
  { { jitter_meta_instruction_parameter_kind_register_or_literal_fixnum, & structuredvm_register_class_r, jitter_default_literal_parameter_printer } };


const struct jitter_meta_instruction
structuredvm_meta_instructions [STRUCTUREDVM_META_INSTRUCTION_NO]
  = {
      { 0, "b", 1, true, false, false, true /* this ignores replacements */, structuredvm_b_meta_instruction_parameter_types },
      { 1, "be", 3, true, false, false, true /* this ignores replacements */, structuredvm_be_meta_instruction_parameter_types },
      { 2, "beqi-stack", 2, true, false, false, true /* this ignores replacements */, structuredvm_beqi_mstack_meta_instruction_parameter_types },
      { 3, "bf-stack", 1, true, false, false, true /* this ignores replacements */, structuredvm_bf_mstack_meta_instruction_parameter_types },
      { 4, "bg", 3, true, false, false, true /* this ignores replacements */, structuredvm_bg_meta_instruction_parameter_types },
      { 5, "bge", 3, true, false, false, true /* this ignores replacements */, structuredvm_bge_meta_instruction_parameter_types },
      { 6, "bl", 3, true, false, false, true /* this ignores replacements */, structuredvm_bl_meta_instruction_parameter_types },
      { 7, "ble", 3, true, false, false, true /* this ignores replacements */, structuredvm_ble_meta_instruction_parameter_types },
      { 8, "bne", 3, true, false, false, true /* this ignores replacements */, structuredvm_bne_meta_instruction_parameter_types },
      { 9, "bneqi-stack", 2, true, false, false, true /* this ignores replacements */, structuredvm_bneqi_mstack_meta_instruction_parameter_types },
      { 10, "bt-stack", 1, true, false, false, true /* this ignores replacements */, structuredvm_bt_mstack_meta_instruction_parameter_types },
      { 11, "call", 1, true, true, false, true /* this ignores replacements */, structuredvm_call_meta_instruction_parameter_types },
      { 12, "copy-to-r-stack", 1, false, false, false, true /* this ignores replacements */, structuredvm_copy_mto_mr_mstack_meta_instruction_parameter_types },
      { 13, "different-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 14, "divided", 3, false, false, false, false /* this ignores replacements */, structuredvm_divided_meta_instruction_parameter_types },
      { 15, "divided-stack", 0, false, false, false, false /* this ignores replacements */, NULL },
      { 16, "drop-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 17, "dup-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 18, "equal-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 19, "equali-stack", 1, false, false, false, true /* this ignores replacements */, structuredvm_equali_mstack_meta_instruction_parameter_types },
      { 20, "exitvm", 0, true, false, false, true /* this ignores replacements */, NULL },
      { 21, "greater-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 22, "greaterorequal-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 23, "input", 1, false, false, false, false /* this ignores replacements */, structuredvm_input_meta_instruction_parameter_types },
      { 24, "input-stack", 0, false, false, false, false /* this ignores replacements */, NULL },
      { 25, "isnonzero-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 26, "less-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 27, "lessorequal-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 28, "load-boxed-literal", 2, false, false, false, true /* this ignores replacements */, structuredvm_load_mboxed_mliteral_meta_instruction_parameter_types },
      { 29, "logicaland-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 30, "logicalnot-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 31, "logicalor-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 32, "minus", 3, false, false, false, true /* this ignores replacements */, structuredvm_minus_meta_instruction_parameter_types },
      { 33, "minus-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 34, "minusi-stack", 1, false, false, false, true /* this ignores replacements */, structuredvm_minusi_mstack_meta_instruction_parameter_types },
      { 35, "mov", 2, false, false, false, true /* this ignores replacements */, structuredvm_mov_meta_instruction_parameter_types },
      { 36, "plus", 3, false, false, false, true /* this ignores replacements */, structuredvm_plus_meta_instruction_parameter_types },
      { 37, "plus-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 38, "plusi-stack", 1, false, false, false, true /* this ignores replacements */, structuredvm_plusi_mstack_meta_instruction_parameter_types },
      { 39, "pop-stack", 1, false, false, false, true /* this ignores replacements */, structuredvm_pop_mstack_meta_instruction_parameter_types },
      { 40, "print", 1, false, false, false, false /* this ignores replacements */, structuredvm_print_meta_instruction_parameter_types },
      { 41, "print-stack", 0, false, false, false, false /* this ignores replacements */, NULL },
      { 42, "procedure-prolog", 0, true, false, true, true /* this ignores replacements */, NULL },
      { 43, "push-boxed-literal", 1, false, false, false, true /* this ignores replacements */, structuredvm_push_mboxed_mliteral_meta_instruction_parameter_types },
      { 44, "push-stack", 1, false, false, false, true /* this ignores replacements */, structuredvm_push_mstack_meta_instruction_parameter_types },
      { 45, "push-unspecified-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 46, "remainder", 3, false, false, false, false /* this ignores replacements */, structuredvm_remainder_meta_instruction_parameter_types },
      { 47, "remainder-stack", 0, false, false, false, false /* this ignores replacements */, NULL },
      { 48, "return-to-undertop", 0, true, false, false, true /* this ignores replacements */, NULL },
      { 49, "swap-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 50, "times", 3, false, false, false, true /* this ignores replacements */, structuredvm_times_meta_instruction_parameter_types },
      { 51, "times-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 52, "uminus", 2, false, false, false, true /* this ignores replacements */, structuredvm_uminus_meta_instruction_parameter_types },
      { 53, "uminus-stack", 0, false, false, false, true /* this ignores replacements */, NULL },
      { 54, "underpop-stack", 1, false, false, false, true /* this ignores replacements */, structuredvm_underpop_mstack_meta_instruction_parameter_types },
      { 55, "underpush-stack", 1, false, false, false, true /* this ignores replacements */, structuredvm_underpush_mstack_meta_instruction_parameter_types },
      { 56, "unreachable", 0, true, false, false, true /* this ignores replacements */, NULL }
    };

/* The register class descriptor for r registers. */
const struct jitter_register_class
structuredvm_register_class_r
  = {
      structuredvm_register_class_id_r,
      'r',
      "general_register",
      "GENERAL_REGISTER",
      STRUCTUREDVM_REGISTER_r_FAST_REGISTER_NO,
      1 /* Use slow registers */
    };


/* A pointer to every existing register class descriptor. */
const struct jitter_register_class * const
structuredvm_regiter_classes []
  = {
      & structuredvm_register_class_r
    };

const struct jitter_register_class *
structuredvm_register_class_character_to_register_class (char c)
{
  switch (c)
    {
    case 'r': return & structuredvm_register_class_r;
    default:  return NULL;
    }
}

//#include "structuredvm-specialized-instructions.h"

const char * const
structuredvm_specialized_instruction_names [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
      "!INVALID",
      "!BEGINBASICBLOCK",
      "!EXITVM",
      "!DATALOCATIONS",
      "!NOP",
      "!UNREACHABLE0",
      "!UNREACHABLE1",
      "!PRETENDTOJUMPANYWHERE",
      "b/fR",
      "be/%r0/%r0/fR",
      "be/%r0/%r1/fR",
      "be/%r0/%rR/fR",
      "be/%r0/n0/fR",
      "be/%r0/nR/fR",
      "be/%r1/%r0/fR",
      "be/%r1/%r1/fR",
      "be/%r1/%rR/fR",
      "be/%r1/n0/fR",
      "be/%r1/nR/fR",
      "be/%rR/%r0/fR",
      "be/%rR/%r1/fR",
      "be/%rR/%rR/fR",
      "be/%rR/n0/fR",
      "be/%rR/nR/fR",
      "be/n0/%r0/fR",
      "be/n0/%r1/fR",
      "be/n0/%rR/fR",
      "be/n0/n0/fR",
      "be/n0/nR/fR",
      "be/nR/%r0/fR",
      "be/nR/%r1/fR",
      "be/nR/%rR/fR",
      "be/nR/n0/fR",
      "be/nR/nR/fR",
      "beqi-stack/n-1/fR",
      "beqi-stack/n0/fR",
      "beqi-stack/n1/fR",
      "beqi-stack/n2/fR",
      "beqi-stack/nR/fR",
      "bf-stack/fR",
      "bg/%r0/%r0/fR",
      "bg/%r0/%r1/fR",
      "bg/%r0/%rR/fR",
      "bg/%r0/n0/fR",
      "bg/%r0/nR/fR",
      "bg/%r1/%r0/fR",
      "bg/%r1/%r1/fR",
      "bg/%r1/%rR/fR",
      "bg/%r1/n0/fR",
      "bg/%r1/nR/fR",
      "bg/%rR/%r0/fR",
      "bg/%rR/%r1/fR",
      "bg/%rR/%rR/fR",
      "bg/%rR/n0/fR",
      "bg/%rR/nR/fR",
      "bg/n0/%r0/fR",
      "bg/n0/%r1/fR",
      "bg/n0/%rR/fR",
      "bg/n0/n0/fR",
      "bg/n0/nR/fR",
      "bg/nR/%r0/fR",
      "bg/nR/%r1/fR",
      "bg/nR/%rR/fR",
      "bg/nR/n0/fR",
      "bg/nR/nR/fR",
      "bge/%r0/%r0/fR",
      "bge/%r0/%r1/fR",
      "bge/%r0/%rR/fR",
      "bge/%r0/n0/fR",
      "bge/%r0/nR/fR",
      "bge/%r1/%r0/fR",
      "bge/%r1/%r1/fR",
      "bge/%r1/%rR/fR",
      "bge/%r1/n0/fR",
      "bge/%r1/nR/fR",
      "bge/%rR/%r0/fR",
      "bge/%rR/%r1/fR",
      "bge/%rR/%rR/fR",
      "bge/%rR/n0/fR",
      "bge/%rR/nR/fR",
      "bge/n0/%r0/fR",
      "bge/n0/%r1/fR",
      "bge/n0/%rR/fR",
      "bge/n0/n0/fR",
      "bge/n0/nR/fR",
      "bge/nR/%r0/fR",
      "bge/nR/%r1/fR",
      "bge/nR/%rR/fR",
      "bge/nR/n0/fR",
      "bge/nR/nR/fR",
      "bl/%r0/%r0/fR",
      "bl/%r0/%r1/fR",
      "bl/%r0/%rR/fR",
      "bl/%r0/n0/fR",
      "bl/%r0/nR/fR",
      "bl/%r1/%r0/fR",
      "bl/%r1/%r1/fR",
      "bl/%r1/%rR/fR",
      "bl/%r1/n0/fR",
      "bl/%r1/nR/fR",
      "bl/%rR/%r0/fR",
      "bl/%rR/%r1/fR",
      "bl/%rR/%rR/fR",
      "bl/%rR/n0/fR",
      "bl/%rR/nR/fR",
      "bl/n0/%r0/fR",
      "bl/n0/%r1/fR",
      "bl/n0/%rR/fR",
      "bl/n0/n0/fR",
      "bl/n0/nR/fR",
      "bl/nR/%r0/fR",
      "bl/nR/%r1/fR",
      "bl/nR/%rR/fR",
      "bl/nR/n0/fR",
      "bl/nR/nR/fR",
      "ble/%r0/%r0/fR",
      "ble/%r0/%r1/fR",
      "ble/%r0/%rR/fR",
      "ble/%r0/n0/fR",
      "ble/%r0/nR/fR",
      "ble/%r1/%r0/fR",
      "ble/%r1/%r1/fR",
      "ble/%r1/%rR/fR",
      "ble/%r1/n0/fR",
      "ble/%r1/nR/fR",
      "ble/%rR/%r0/fR",
      "ble/%rR/%r1/fR",
      "ble/%rR/%rR/fR",
      "ble/%rR/n0/fR",
      "ble/%rR/nR/fR",
      "ble/n0/%r0/fR",
      "ble/n0/%r1/fR",
      "ble/n0/%rR/fR",
      "ble/n0/n0/fR",
      "ble/n0/nR/fR",
      "ble/nR/%r0/fR",
      "ble/nR/%r1/fR",
      "ble/nR/%rR/fR",
      "ble/nR/n0/fR",
      "ble/nR/nR/fR",
      "bne/%r0/%r0/fR",
      "bne/%r0/%r1/fR",
      "bne/%r0/%rR/fR",
      "bne/%r0/n0/fR",
      "bne/%r0/nR/fR",
      "bne/%r1/%r0/fR",
      "bne/%r1/%r1/fR",
      "bne/%r1/%rR/fR",
      "bne/%r1/n0/fR",
      "bne/%r1/nR/fR",
      "bne/%rR/%r0/fR",
      "bne/%rR/%r1/fR",
      "bne/%rR/%rR/fR",
      "bne/%rR/n0/fR",
      "bne/%rR/nR/fR",
      "bne/n0/%r0/fR",
      "bne/n0/%r1/fR",
      "bne/n0/%rR/fR",
      "bne/n0/n0/fR",
      "bne/n0/nR/fR",
      "bne/nR/%r0/fR",
      "bne/nR/%r1/fR",
      "bne/nR/%rR/fR",
      "bne/nR/n0/fR",
      "bne/nR/nR/fR",
      "bneqi-stack/n-1/fR",
      "bneqi-stack/n0/fR",
      "bneqi-stack/n1/fR",
      "bneqi-stack/n2/fR",
      "bneqi-stack/nR/fR",
      "bt-stack/fR",
      "call/fR/retR",
      "copy-to-r-stack/%r0",
      "copy-to-r-stack/%r1",
      "copy-to-r-stack/%rR",
      "different-stack",
      "divided/%r0/%r0/%r0/retR",
      "divided/%r0/%r0/%r1/retR",
      "divided/%r0/%r0/%rR/retR",
      "divided/%r0/%r1/%r0/retR",
      "divided/%r0/%r1/%r1/retR",
      "divided/%r0/%r1/%rR/retR",
      "divided/%r0/%rR/%r0/retR",
      "divided/%r0/%rR/%r1/retR",
      "divided/%r0/%rR/%rR/retR",
      "divided/%r0/n2/%r0/retR",
      "divided/%r0/n2/%r1/retR",
      "divided/%r0/n2/%rR/retR",
      "divided/%r0/nR/%r0/retR",
      "divided/%r0/nR/%r1/retR",
      "divided/%r0/nR/%rR/retR",
      "divided/%r1/%r0/%r0/retR",
      "divided/%r1/%r0/%r1/retR",
      "divided/%r1/%r0/%rR/retR",
      "divided/%r1/%r1/%r0/retR",
      "divided/%r1/%r1/%r1/retR",
      "divided/%r1/%r1/%rR/retR",
      "divided/%r1/%rR/%r0/retR",
      "divided/%r1/%rR/%r1/retR",
      "divided/%r1/%rR/%rR/retR",
      "divided/%r1/n2/%r0/retR",
      "divided/%r1/n2/%r1/retR",
      "divided/%r1/n2/%rR/retR",
      "divided/%r1/nR/%r0/retR",
      "divided/%r1/nR/%r1/retR",
      "divided/%r1/nR/%rR/retR",
      "divided/%rR/%r0/%r0/retR",
      "divided/%rR/%r0/%r1/retR",
      "divided/%rR/%r0/%rR/retR",
      "divided/%rR/%r1/%r0/retR",
      "divided/%rR/%r1/%r1/retR",
      "divided/%rR/%r1/%rR/retR",
      "divided/%rR/%rR/%r0/retR",
      "divided/%rR/%rR/%r1/retR",
      "divided/%rR/%rR/%rR/retR",
      "divided/%rR/n2/%r0/retR",
      "divided/%rR/n2/%r1/retR",
      "divided/%rR/n2/%rR/retR",
      "divided/%rR/nR/%r0/retR",
      "divided/%rR/nR/%r1/retR",
      "divided/%rR/nR/%rR/retR",
      "divided/nR/%r0/%r0/retR",
      "divided/nR/%r0/%r1/retR",
      "divided/nR/%r0/%rR/retR",
      "divided/nR/%r1/%r0/retR",
      "divided/nR/%r1/%r1/retR",
      "divided/nR/%r1/%rR/retR",
      "divided/nR/%rR/%r0/retR",
      "divided/nR/%rR/%r1/retR",
      "divided/nR/%rR/%rR/retR",
      "divided/nR/n2/%r0/retR",
      "divided/nR/n2/%r1/retR",
      "divided/nR/n2/%rR/retR",
      "divided/nR/nR/%r0/retR",
      "divided/nR/nR/%r1/retR",
      "divided/nR/nR/%rR/retR",
      "divided-stack/retR",
      "drop-stack",
      "dup-stack",
      "equal-stack",
      "equali-stack/n0",
      "equali-stack/n1",
      "equali-stack/n2",
      "equali-stack/nR",
      "exitvm",
      "greater-stack",
      "greaterorequal-stack",
      "input/%r0/retR",
      "input/%r1/retR",
      "input/%rR/retR",
      "input-stack/retR",
      "isnonzero-stack",
      "less-stack",
      "lessorequal-stack",
      "load-boxed-literal/n0/%r0",
      "load-boxed-literal/n0/%r1",
      "load-boxed-literal/n0/%rR",
      "load-boxed-literal/n1/%r0",
      "load-boxed-literal/n1/%r1",
      "load-boxed-literal/n1/%rR",
      "load-boxed-literal/n2/%r0",
      "load-boxed-literal/n2/%r1",
      "load-boxed-literal/n2/%rR",
      "load-boxed-literal/n3/%r0",
      "load-boxed-literal/n3/%r1",
      "load-boxed-literal/n3/%rR",
      "load-boxed-literal/n4/%r0",
      "load-boxed-literal/n4/%r1",
      "load-boxed-literal/n4/%rR",
      "load-boxed-literal/n5/%r0",
      "load-boxed-literal/n5/%r1",
      "load-boxed-literal/n5/%rR",
      "load-boxed-literal/n6/%r0",
      "load-boxed-literal/n6/%r1",
      "load-boxed-literal/n6/%rR",
      "load-boxed-literal/n7/%r0",
      "load-boxed-literal/n7/%r1",
      "load-boxed-literal/n7/%rR",
      "load-boxed-literal/n8/%r0",
      "load-boxed-literal/n8/%r1",
      "load-boxed-literal/n8/%rR",
      "load-boxed-literal/n9/%r0",
      "load-boxed-literal/n9/%r1",
      "load-boxed-literal/n9/%rR",
      "load-boxed-literal/n10/%r0",
      "load-boxed-literal/n10/%r1",
      "load-boxed-literal/n10/%rR",
      "load-boxed-literal/nR/%r0",
      "load-boxed-literal/nR/%r1",
      "load-boxed-literal/nR/%rR",
      "logicaland-stack",
      "logicalnot-stack",
      "logicalor-stack",
      "minus/%r0/%r0/%r0",
      "minus/%r0/%r0/%r1",
      "minus/%r0/%r0/%rR",
      "minus/%r0/%r1/%r0",
      "minus/%r0/%r1/%r1",
      "minus/%r0/%r1/%rR",
      "minus/%r0/%rR/%r0",
      "minus/%r0/%rR/%r1",
      "minus/%r0/%rR/%rR",
      "minus/%r0/n1/%r0",
      "minus/%r0/n1/%r1",
      "minus/%r0/n1/%rR",
      "minus/%r0/n2/%r0",
      "minus/%r0/n2/%r1",
      "minus/%r0/n2/%rR",
      "minus/%r0/nR/%r0",
      "minus/%r0/nR/%r1",
      "minus/%r0/nR/%rR",
      "minus/%r1/%r0/%r0",
      "minus/%r1/%r0/%r1",
      "minus/%r1/%r0/%rR",
      "minus/%r1/%r1/%r0",
      "minus/%r1/%r1/%r1",
      "minus/%r1/%r1/%rR",
      "minus/%r1/%rR/%r0",
      "minus/%r1/%rR/%r1",
      "minus/%r1/%rR/%rR",
      "minus/%r1/n1/%r0",
      "minus/%r1/n1/%r1",
      "minus/%r1/n1/%rR",
      "minus/%r1/n2/%r0",
      "minus/%r1/n2/%r1",
      "minus/%r1/n2/%rR",
      "minus/%r1/nR/%r0",
      "minus/%r1/nR/%r1",
      "minus/%r1/nR/%rR",
      "minus/%rR/%r0/%r0",
      "minus/%rR/%r0/%r1",
      "minus/%rR/%r0/%rR",
      "minus/%rR/%r1/%r0",
      "minus/%rR/%r1/%r1",
      "minus/%rR/%r1/%rR",
      "minus/%rR/%rR/%r0",
      "minus/%rR/%rR/%r1",
      "minus/%rR/%rR/%rR",
      "minus/%rR/n1/%r0",
      "minus/%rR/n1/%r1",
      "minus/%rR/n1/%rR",
      "minus/%rR/n2/%r0",
      "minus/%rR/n2/%r1",
      "minus/%rR/n2/%rR",
      "minus/%rR/nR/%r0",
      "minus/%rR/nR/%r1",
      "minus/%rR/nR/%rR",
      "minus/nR/%r0/%r0",
      "minus/nR/%r0/%r1",
      "minus/nR/%r0/%rR",
      "minus/nR/%r1/%r0",
      "minus/nR/%r1/%r1",
      "minus/nR/%r1/%rR",
      "minus/nR/%rR/%r0",
      "minus/nR/%rR/%r1",
      "minus/nR/%rR/%rR",
      "minus/nR/n1/%r0",
      "minus/nR/n1/%r1",
      "minus/nR/n1/%rR",
      "minus/nR/n2/%r0",
      "minus/nR/n2/%r1",
      "minus/nR/n2/%rR",
      "minus/nR/nR/%r0",
      "minus/nR/nR/%r1",
      "minus/nR/nR/%rR",
      "minus-stack",
      "minusi-stack/n1",
      "minusi-stack/n2",
      "minusi-stack/nR",
      "mov/%r0/%r0",
      "mov/%r0/%r1",
      "mov/%r0/%rR",
      "mov/%r1/%r0",
      "mov/%r1/%r1",
      "mov/%r1/%rR",
      "mov/%rR/%r0",
      "mov/%rR/%r1",
      "mov/%rR/%rR",
      "mov/n0/%r0",
      "mov/n0/%r1",
      "mov/n0/%rR",
      "mov/n1/%r0",
      "mov/n1/%r1",
      "mov/n1/%rR",
      "mov/n-1/%r0",
      "mov/n-1/%r1",
      "mov/n-1/%rR",
      "mov/n2/%r0",
      "mov/n2/%r1",
      "mov/n2/%rR",
      "mov/nR/%r0",
      "mov/nR/%r1",
      "mov/nR/%rR",
      "plus/%r0/%r0/%r0",
      "plus/%r0/%r0/%r1",
      "plus/%r0/%r0/%rR",
      "plus/%r0/%r1/%r0",
      "plus/%r0/%r1/%r1",
      "plus/%r0/%r1/%rR",
      "plus/%r0/%rR/%r0",
      "plus/%r0/%rR/%r1",
      "plus/%r0/%rR/%rR",
      "plus/%r0/n1/%r0",
      "plus/%r0/n1/%r1",
      "plus/%r0/n1/%rR",
      "plus/%r0/n2/%r0",
      "plus/%r0/n2/%r1",
      "plus/%r0/n2/%rR",
      "plus/%r0/nR/%r0",
      "plus/%r0/nR/%r1",
      "plus/%r0/nR/%rR",
      "plus/%r1/%r0/%r0",
      "plus/%r1/%r0/%r1",
      "plus/%r1/%r0/%rR",
      "plus/%r1/%r1/%r0",
      "plus/%r1/%r1/%r1",
      "plus/%r1/%r1/%rR",
      "plus/%r1/%rR/%r0",
      "plus/%r1/%rR/%r1",
      "plus/%r1/%rR/%rR",
      "plus/%r1/n1/%r0",
      "plus/%r1/n1/%r1",
      "plus/%r1/n1/%rR",
      "plus/%r1/n2/%r0",
      "plus/%r1/n2/%r1",
      "plus/%r1/n2/%rR",
      "plus/%r1/nR/%r0",
      "plus/%r1/nR/%r1",
      "plus/%r1/nR/%rR",
      "plus/%rR/%r0/%r0",
      "plus/%rR/%r0/%r1",
      "plus/%rR/%r0/%rR",
      "plus/%rR/%r1/%r0",
      "plus/%rR/%r1/%r1",
      "plus/%rR/%r1/%rR",
      "plus/%rR/%rR/%r0",
      "plus/%rR/%rR/%r1",
      "plus/%rR/%rR/%rR",
      "plus/%rR/n1/%r0",
      "plus/%rR/n1/%r1",
      "plus/%rR/n1/%rR",
      "plus/%rR/n2/%r0",
      "plus/%rR/n2/%r1",
      "plus/%rR/n2/%rR",
      "plus/%rR/nR/%r0",
      "plus/%rR/nR/%r1",
      "plus/%rR/nR/%rR",
      "plus/n1/%r0/%r0",
      "plus/n1/%r0/%r1",
      "plus/n1/%r0/%rR",
      "plus/n1/%r1/%r0",
      "plus/n1/%r1/%r1",
      "plus/n1/%r1/%rR",
      "plus/n1/%rR/%r0",
      "plus/n1/%rR/%r1",
      "plus/n1/%rR/%rR",
      "plus/n1/n1/%r0",
      "plus/n1/n1/%r1",
      "plus/n1/n1/%rR",
      "plus/n1/n2/%r0",
      "plus/n1/n2/%r1",
      "plus/n1/n2/%rR",
      "plus/n1/nR/%r0",
      "plus/n1/nR/%r1",
      "plus/n1/nR/%rR",
      "plus/n2/%r0/%r0",
      "plus/n2/%r0/%r1",
      "plus/n2/%r0/%rR",
      "plus/n2/%r1/%r0",
      "plus/n2/%r1/%r1",
      "plus/n2/%r1/%rR",
      "plus/n2/%rR/%r0",
      "plus/n2/%rR/%r1",
      "plus/n2/%rR/%rR",
      "plus/n2/n1/%r0",
      "plus/n2/n1/%r1",
      "plus/n2/n1/%rR",
      "plus/n2/n2/%r0",
      "plus/n2/n2/%r1",
      "plus/n2/n2/%rR",
      "plus/n2/nR/%r0",
      "plus/n2/nR/%r1",
      "plus/n2/nR/%rR",
      "plus/nR/%r0/%r0",
      "plus/nR/%r0/%r1",
      "plus/nR/%r0/%rR",
      "plus/nR/%r1/%r0",
      "plus/nR/%r1/%r1",
      "plus/nR/%r1/%rR",
      "plus/nR/%rR/%r0",
      "plus/nR/%rR/%r1",
      "plus/nR/%rR/%rR",
      "plus/nR/n1/%r0",
      "plus/nR/n1/%r1",
      "plus/nR/n1/%rR",
      "plus/nR/n2/%r0",
      "plus/nR/n2/%r1",
      "plus/nR/n2/%rR",
      "plus/nR/nR/%r0",
      "plus/nR/nR/%r1",
      "plus/nR/nR/%rR",
      "plus-stack",
      "plusi-stack/n-1",
      "plusi-stack/n1",
      "plusi-stack/n2",
      "plusi-stack/nR",
      "pop-stack/%r0",
      "pop-stack/%r1",
      "pop-stack/%rR",
      "print/%r0/retR",
      "print/%r1/retR",
      "print/%rR/retR",
      "print/nR/retR",
      "print-stack/retR",
      "procedure-prolog",
      "push-boxed-literal/n0",
      "push-boxed-literal/n1",
      "push-boxed-literal/n2",
      "push-boxed-literal/n3",
      "push-boxed-literal/n4",
      "push-boxed-literal/n5",
      "push-boxed-literal/n6",
      "push-boxed-literal/n7",
      "push-boxed-literal/n8",
      "push-boxed-literal/n9",
      "push-boxed-literal/n10",
      "push-boxed-literal/nR",
      "push-stack/%r0",
      "push-stack/%r1",
      "push-stack/%rR",
      "push-stack/n0",
      "push-stack/n1",
      "push-stack/n-1",
      "push-stack/n2",
      "push-stack/nR",
      "push-stack/lR",
      "push-unspecified-stack",
      "remainder/%r0/%r0/%r0/retR",
      "remainder/%r0/%r0/%r1/retR",
      "remainder/%r0/%r0/%rR/retR",
      "remainder/%r0/%r1/%r0/retR",
      "remainder/%r0/%r1/%r1/retR",
      "remainder/%r0/%r1/%rR/retR",
      "remainder/%r0/%rR/%r0/retR",
      "remainder/%r0/%rR/%r1/retR",
      "remainder/%r0/%rR/%rR/retR",
      "remainder/%r0/n2/%r0/retR",
      "remainder/%r0/n2/%r1/retR",
      "remainder/%r0/n2/%rR/retR",
      "remainder/%r0/nR/%r0/retR",
      "remainder/%r0/nR/%r1/retR",
      "remainder/%r0/nR/%rR/retR",
      "remainder/%r1/%r0/%r0/retR",
      "remainder/%r1/%r0/%r1/retR",
      "remainder/%r1/%r0/%rR/retR",
      "remainder/%r1/%r1/%r0/retR",
      "remainder/%r1/%r1/%r1/retR",
      "remainder/%r1/%r1/%rR/retR",
      "remainder/%r1/%rR/%r0/retR",
      "remainder/%r1/%rR/%r1/retR",
      "remainder/%r1/%rR/%rR/retR",
      "remainder/%r1/n2/%r0/retR",
      "remainder/%r1/n2/%r1/retR",
      "remainder/%r1/n2/%rR/retR",
      "remainder/%r1/nR/%r0/retR",
      "remainder/%r1/nR/%r1/retR",
      "remainder/%r1/nR/%rR/retR",
      "remainder/%rR/%r0/%r0/retR",
      "remainder/%rR/%r0/%r1/retR",
      "remainder/%rR/%r0/%rR/retR",
      "remainder/%rR/%r1/%r0/retR",
      "remainder/%rR/%r1/%r1/retR",
      "remainder/%rR/%r1/%rR/retR",
      "remainder/%rR/%rR/%r0/retR",
      "remainder/%rR/%rR/%r1/retR",
      "remainder/%rR/%rR/%rR/retR",
      "remainder/%rR/n2/%r0/retR",
      "remainder/%rR/n2/%r1/retR",
      "remainder/%rR/n2/%rR/retR",
      "remainder/%rR/nR/%r0/retR",
      "remainder/%rR/nR/%r1/retR",
      "remainder/%rR/nR/%rR/retR",
      "remainder/nR/%r0/%r0/retR",
      "remainder/nR/%r0/%r1/retR",
      "remainder/nR/%r0/%rR/retR",
      "remainder/nR/%r1/%r0/retR",
      "remainder/nR/%r1/%r1/retR",
      "remainder/nR/%r1/%rR/retR",
      "remainder/nR/%rR/%r0/retR",
      "remainder/nR/%rR/%r1/retR",
      "remainder/nR/%rR/%rR/retR",
      "remainder/nR/n2/%r0/retR",
      "remainder/nR/n2/%r1/retR",
      "remainder/nR/n2/%rR/retR",
      "remainder/nR/nR/%r0/retR",
      "remainder/nR/nR/%r1/retR",
      "remainder/nR/nR/%rR/retR",
      "remainder-stack/retR",
      "return-to-undertop",
      "swap-stack",
      "times/%r0/%r0/%r0",
      "times/%r0/%r0/%r1",
      "times/%r0/%r0/%rR",
      "times/%r0/%r1/%r0",
      "times/%r0/%r1/%r1",
      "times/%r0/%r1/%rR",
      "times/%r0/%rR/%r0",
      "times/%r0/%rR/%r1",
      "times/%r0/%rR/%rR",
      "times/%r0/n2/%r0",
      "times/%r0/n2/%r1",
      "times/%r0/n2/%rR",
      "times/%r0/nR/%r0",
      "times/%r0/nR/%r1",
      "times/%r0/nR/%rR",
      "times/%r1/%r0/%r0",
      "times/%r1/%r0/%r1",
      "times/%r1/%r0/%rR",
      "times/%r1/%r1/%r0",
      "times/%r1/%r1/%r1",
      "times/%r1/%r1/%rR",
      "times/%r1/%rR/%r0",
      "times/%r1/%rR/%r1",
      "times/%r1/%rR/%rR",
      "times/%r1/n2/%r0",
      "times/%r1/n2/%r1",
      "times/%r1/n2/%rR",
      "times/%r1/nR/%r0",
      "times/%r1/nR/%r1",
      "times/%r1/nR/%rR",
      "times/%rR/%r0/%r0",
      "times/%rR/%r0/%r1",
      "times/%rR/%r0/%rR",
      "times/%rR/%r1/%r0",
      "times/%rR/%r1/%r1",
      "times/%rR/%r1/%rR",
      "times/%rR/%rR/%r0",
      "times/%rR/%rR/%r1",
      "times/%rR/%rR/%rR",
      "times/%rR/n2/%r0",
      "times/%rR/n2/%r1",
      "times/%rR/n2/%rR",
      "times/%rR/nR/%r0",
      "times/%rR/nR/%r1",
      "times/%rR/nR/%rR",
      "times/nR/%r0/%r0",
      "times/nR/%r0/%r1",
      "times/nR/%r0/%rR",
      "times/nR/%r1/%r0",
      "times/nR/%r1/%r1",
      "times/nR/%r1/%rR",
      "times/nR/%rR/%r0",
      "times/nR/%rR/%r1",
      "times/nR/%rR/%rR",
      "times/nR/n2/%r0",
      "times/nR/n2/%r1",
      "times/nR/n2/%rR",
      "times/nR/nR/%r0",
      "times/nR/nR/%r1",
      "times/nR/nR/%rR",
      "times-stack",
      "uminus/%r0/%r0",
      "uminus/%r0/%r1",
      "uminus/%r0/%rR",
      "uminus/%r1/%r0",
      "uminus/%r1/%r1",
      "uminus/%r1/%rR",
      "uminus/%rR/%r0",
      "uminus/%rR/%r1",
      "uminus/%rR/%rR",
      "uminus/nR/%r0",
      "uminus/nR/%r1",
      "uminus/nR/%rR",
      "uminus-stack",
      "underpop-stack/%r0",
      "underpop-stack/%r1",
      "underpop-stack/%rR",
      "underpush-stack/%r0",
      "underpush-stack/%r1",
      "underpush-stack/%rR",
      "underpush-stack/nR",
      "unreachable",
      "!REPLACEMENT-b/fR/retR",
      "!REPLACEMENT-be/%r0/%r0/fR/retR",
      "!REPLACEMENT-be/%r0/%r1/fR/retR",
      "!REPLACEMENT-be/%r0/%rR/fR/retR",
      "!REPLACEMENT-be/%r0/n0/fR/retR",
      "!REPLACEMENT-be/%r0/nR/fR/retR",
      "!REPLACEMENT-be/%r1/%r0/fR/retR",
      "!REPLACEMENT-be/%r1/%r1/fR/retR",
      "!REPLACEMENT-be/%r1/%rR/fR/retR",
      "!REPLACEMENT-be/%r1/n0/fR/retR",
      "!REPLACEMENT-be/%r1/nR/fR/retR",
      "!REPLACEMENT-be/%rR/%r0/fR/retR",
      "!REPLACEMENT-be/%rR/%r1/fR/retR",
      "!REPLACEMENT-be/%rR/%rR/fR/retR",
      "!REPLACEMENT-be/%rR/n0/fR/retR",
      "!REPLACEMENT-be/%rR/nR/fR/retR",
      "!REPLACEMENT-be/n0/%r0/fR/retR",
      "!REPLACEMENT-be/n0/%r1/fR/retR",
      "!REPLACEMENT-be/n0/%rR/fR/retR",
      "!REPLACEMENT-be/n0/n0/fR/retR",
      "!REPLACEMENT-be/n0/nR/fR/retR",
      "!REPLACEMENT-be/nR/%r0/fR/retR",
      "!REPLACEMENT-be/nR/%r1/fR/retR",
      "!REPLACEMENT-be/nR/%rR/fR/retR",
      "!REPLACEMENT-be/nR/n0/fR/retR",
      "!REPLACEMENT-be/nR/nR/fR/retR",
      "!REPLACEMENT-beqi-stack/n-1/fR/retR",
      "!REPLACEMENT-beqi-stack/n0/fR/retR",
      "!REPLACEMENT-beqi-stack/n1/fR/retR",
      "!REPLACEMENT-beqi-stack/n2/fR/retR",
      "!REPLACEMENT-beqi-stack/nR/fR/retR",
      "!REPLACEMENT-bf-stack/fR/retR",
      "!REPLACEMENT-bg/%r0/%r0/fR/retR",
      "!REPLACEMENT-bg/%r0/%r1/fR/retR",
      "!REPLACEMENT-bg/%r0/%rR/fR/retR",
      "!REPLACEMENT-bg/%r0/n0/fR/retR",
      "!REPLACEMENT-bg/%r0/nR/fR/retR",
      "!REPLACEMENT-bg/%r1/%r0/fR/retR",
      "!REPLACEMENT-bg/%r1/%r1/fR/retR",
      "!REPLACEMENT-bg/%r1/%rR/fR/retR",
      "!REPLACEMENT-bg/%r1/n0/fR/retR",
      "!REPLACEMENT-bg/%r1/nR/fR/retR",
      "!REPLACEMENT-bg/%rR/%r0/fR/retR",
      "!REPLACEMENT-bg/%rR/%r1/fR/retR",
      "!REPLACEMENT-bg/%rR/%rR/fR/retR",
      "!REPLACEMENT-bg/%rR/n0/fR/retR",
      "!REPLACEMENT-bg/%rR/nR/fR/retR",
      "!REPLACEMENT-bg/n0/%r0/fR/retR",
      "!REPLACEMENT-bg/n0/%r1/fR/retR",
      "!REPLACEMENT-bg/n0/%rR/fR/retR",
      "!REPLACEMENT-bg/n0/n0/fR/retR",
      "!REPLACEMENT-bg/n0/nR/fR/retR",
      "!REPLACEMENT-bg/nR/%r0/fR/retR",
      "!REPLACEMENT-bg/nR/%r1/fR/retR",
      "!REPLACEMENT-bg/nR/%rR/fR/retR",
      "!REPLACEMENT-bg/nR/n0/fR/retR",
      "!REPLACEMENT-bg/nR/nR/fR/retR",
      "!REPLACEMENT-bge/%r0/%r0/fR/retR",
      "!REPLACEMENT-bge/%r0/%r1/fR/retR",
      "!REPLACEMENT-bge/%r0/%rR/fR/retR",
      "!REPLACEMENT-bge/%r0/n0/fR/retR",
      "!REPLACEMENT-bge/%r0/nR/fR/retR",
      "!REPLACEMENT-bge/%r1/%r0/fR/retR",
      "!REPLACEMENT-bge/%r1/%r1/fR/retR",
      "!REPLACEMENT-bge/%r1/%rR/fR/retR",
      "!REPLACEMENT-bge/%r1/n0/fR/retR",
      "!REPLACEMENT-bge/%r1/nR/fR/retR",
      "!REPLACEMENT-bge/%rR/%r0/fR/retR",
      "!REPLACEMENT-bge/%rR/%r1/fR/retR",
      "!REPLACEMENT-bge/%rR/%rR/fR/retR",
      "!REPLACEMENT-bge/%rR/n0/fR/retR",
      "!REPLACEMENT-bge/%rR/nR/fR/retR",
      "!REPLACEMENT-bge/n0/%r0/fR/retR",
      "!REPLACEMENT-bge/n0/%r1/fR/retR",
      "!REPLACEMENT-bge/n0/%rR/fR/retR",
      "!REPLACEMENT-bge/n0/n0/fR/retR",
      "!REPLACEMENT-bge/n0/nR/fR/retR",
      "!REPLACEMENT-bge/nR/%r0/fR/retR",
      "!REPLACEMENT-bge/nR/%r1/fR/retR",
      "!REPLACEMENT-bge/nR/%rR/fR/retR",
      "!REPLACEMENT-bge/nR/n0/fR/retR",
      "!REPLACEMENT-bge/nR/nR/fR/retR",
      "!REPLACEMENT-bl/%r0/%r0/fR/retR",
      "!REPLACEMENT-bl/%r0/%r1/fR/retR",
      "!REPLACEMENT-bl/%r0/%rR/fR/retR",
      "!REPLACEMENT-bl/%r0/n0/fR/retR",
      "!REPLACEMENT-bl/%r0/nR/fR/retR",
      "!REPLACEMENT-bl/%r1/%r0/fR/retR",
      "!REPLACEMENT-bl/%r1/%r1/fR/retR",
      "!REPLACEMENT-bl/%r1/%rR/fR/retR",
      "!REPLACEMENT-bl/%r1/n0/fR/retR",
      "!REPLACEMENT-bl/%r1/nR/fR/retR",
      "!REPLACEMENT-bl/%rR/%r0/fR/retR",
      "!REPLACEMENT-bl/%rR/%r1/fR/retR",
      "!REPLACEMENT-bl/%rR/%rR/fR/retR",
      "!REPLACEMENT-bl/%rR/n0/fR/retR",
      "!REPLACEMENT-bl/%rR/nR/fR/retR",
      "!REPLACEMENT-bl/n0/%r0/fR/retR",
      "!REPLACEMENT-bl/n0/%r1/fR/retR",
      "!REPLACEMENT-bl/n0/%rR/fR/retR",
      "!REPLACEMENT-bl/n0/n0/fR/retR",
      "!REPLACEMENT-bl/n0/nR/fR/retR",
      "!REPLACEMENT-bl/nR/%r0/fR/retR",
      "!REPLACEMENT-bl/nR/%r1/fR/retR",
      "!REPLACEMENT-bl/nR/%rR/fR/retR",
      "!REPLACEMENT-bl/nR/n0/fR/retR",
      "!REPLACEMENT-bl/nR/nR/fR/retR",
      "!REPLACEMENT-ble/%r0/%r0/fR/retR",
      "!REPLACEMENT-ble/%r0/%r1/fR/retR",
      "!REPLACEMENT-ble/%r0/%rR/fR/retR",
      "!REPLACEMENT-ble/%r0/n0/fR/retR",
      "!REPLACEMENT-ble/%r0/nR/fR/retR",
      "!REPLACEMENT-ble/%r1/%r0/fR/retR",
      "!REPLACEMENT-ble/%r1/%r1/fR/retR",
      "!REPLACEMENT-ble/%r1/%rR/fR/retR",
      "!REPLACEMENT-ble/%r1/n0/fR/retR",
      "!REPLACEMENT-ble/%r1/nR/fR/retR",
      "!REPLACEMENT-ble/%rR/%r0/fR/retR",
      "!REPLACEMENT-ble/%rR/%r1/fR/retR",
      "!REPLACEMENT-ble/%rR/%rR/fR/retR",
      "!REPLACEMENT-ble/%rR/n0/fR/retR",
      "!REPLACEMENT-ble/%rR/nR/fR/retR",
      "!REPLACEMENT-ble/n0/%r0/fR/retR",
      "!REPLACEMENT-ble/n0/%r1/fR/retR",
      "!REPLACEMENT-ble/n0/%rR/fR/retR",
      "!REPLACEMENT-ble/n0/n0/fR/retR",
      "!REPLACEMENT-ble/n0/nR/fR/retR",
      "!REPLACEMENT-ble/nR/%r0/fR/retR",
      "!REPLACEMENT-ble/nR/%r1/fR/retR",
      "!REPLACEMENT-ble/nR/%rR/fR/retR",
      "!REPLACEMENT-ble/nR/n0/fR/retR",
      "!REPLACEMENT-ble/nR/nR/fR/retR",
      "!REPLACEMENT-bne/%r0/%r0/fR/retR",
      "!REPLACEMENT-bne/%r0/%r1/fR/retR",
      "!REPLACEMENT-bne/%r0/%rR/fR/retR",
      "!REPLACEMENT-bne/%r0/n0/fR/retR",
      "!REPLACEMENT-bne/%r0/nR/fR/retR",
      "!REPLACEMENT-bne/%r1/%r0/fR/retR",
      "!REPLACEMENT-bne/%r1/%r1/fR/retR",
      "!REPLACEMENT-bne/%r1/%rR/fR/retR",
      "!REPLACEMENT-bne/%r1/n0/fR/retR",
      "!REPLACEMENT-bne/%r1/nR/fR/retR",
      "!REPLACEMENT-bne/%rR/%r0/fR/retR",
      "!REPLACEMENT-bne/%rR/%r1/fR/retR",
      "!REPLACEMENT-bne/%rR/%rR/fR/retR",
      "!REPLACEMENT-bne/%rR/n0/fR/retR",
      "!REPLACEMENT-bne/%rR/nR/fR/retR",
      "!REPLACEMENT-bne/n0/%r0/fR/retR",
      "!REPLACEMENT-bne/n0/%r1/fR/retR",
      "!REPLACEMENT-bne/n0/%rR/fR/retR",
      "!REPLACEMENT-bne/n0/n0/fR/retR",
      "!REPLACEMENT-bne/n0/nR/fR/retR",
      "!REPLACEMENT-bne/nR/%r0/fR/retR",
      "!REPLACEMENT-bne/nR/%r1/fR/retR",
      "!REPLACEMENT-bne/nR/%rR/fR/retR",
      "!REPLACEMENT-bne/nR/n0/fR/retR",
      "!REPLACEMENT-bne/nR/nR/fR/retR",
      "!REPLACEMENT-bneqi-stack/n-1/fR/retR",
      "!REPLACEMENT-bneqi-stack/n0/fR/retR",
      "!REPLACEMENT-bneqi-stack/n1/fR/retR",
      "!REPLACEMENT-bneqi-stack/n2/fR/retR",
      "!REPLACEMENT-bneqi-stack/nR/fR/retR",
      "!REPLACEMENT-bt-stack/fR/retR",
      "!REPLACEMENT-call/fR/retR",
      "!REPLACEMENT-exitvm/retR",
      "!REPLACEMENT-procedure-prolog/retR",
      "!REPLACEMENT-return-to-undertop/retR",
      "!REPLACEMENT-unreachable/retR"
    };
// #include <stdlib.h>

// #include "structuredvm-specialized-instructions.h"
const size_t
structuredvm_specialized_instruction_residual_arities [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
      0, /* !INVALID */
      1, /* !BEGINBASICBLOCK */
      0, /* !EXITVM */
      0, /* !DATALOCATIONS */
      0, /* !NOP */
      0, /* !UNREACHABLE0 */
      0, /* !UNREACHABLE1 */
      0, /* !PRETENDTOJUMPANYWHERE */
      1, /* b/fR */
      1, /* be/%r0/%r0/fR */
      1, /* be/%r0/%r1/fR */
      2, /* be/%r0/%rR/fR */
      1, /* be/%r0/n0/fR */
      2, /* be/%r0/nR/fR */
      1, /* be/%r1/%r0/fR */
      1, /* be/%r1/%r1/fR */
      2, /* be/%r1/%rR/fR */
      1, /* be/%r1/n0/fR */
      2, /* be/%r1/nR/fR */
      2, /* be/%rR/%r0/fR */
      2, /* be/%rR/%r1/fR */
      3, /* be/%rR/%rR/fR */
      2, /* be/%rR/n0/fR */
      3, /* be/%rR/nR/fR */
      1, /* be/n0/%r0/fR */
      1, /* be/n0/%r1/fR */
      2, /* be/n0/%rR/fR */
      1, /* be/n0/n0/fR */
      2, /* be/n0/nR/fR */
      2, /* be/nR/%r0/fR */
      2, /* be/nR/%r1/fR */
      3, /* be/nR/%rR/fR */
      2, /* be/nR/n0/fR */
      3, /* be/nR/nR/fR */
      1, /* beqi-stack/n-1/fR */
      1, /* beqi-stack/n0/fR */
      1, /* beqi-stack/n1/fR */
      1, /* beqi-stack/n2/fR */
      2, /* beqi-stack/nR/fR */
      1, /* bf-stack/fR */
      1, /* bg/%r0/%r0/fR */
      1, /* bg/%r0/%r1/fR */
      2, /* bg/%r0/%rR/fR */
      1, /* bg/%r0/n0/fR */
      2, /* bg/%r0/nR/fR */
      1, /* bg/%r1/%r0/fR */
      1, /* bg/%r1/%r1/fR */
      2, /* bg/%r1/%rR/fR */
      1, /* bg/%r1/n0/fR */
      2, /* bg/%r1/nR/fR */
      2, /* bg/%rR/%r0/fR */
      2, /* bg/%rR/%r1/fR */
      3, /* bg/%rR/%rR/fR */
      2, /* bg/%rR/n0/fR */
      3, /* bg/%rR/nR/fR */
      1, /* bg/n0/%r0/fR */
      1, /* bg/n0/%r1/fR */
      2, /* bg/n0/%rR/fR */
      1, /* bg/n0/n0/fR */
      2, /* bg/n0/nR/fR */
      2, /* bg/nR/%r0/fR */
      2, /* bg/nR/%r1/fR */
      3, /* bg/nR/%rR/fR */
      2, /* bg/nR/n0/fR */
      3, /* bg/nR/nR/fR */
      1, /* bge/%r0/%r0/fR */
      1, /* bge/%r0/%r1/fR */
      2, /* bge/%r0/%rR/fR */
      1, /* bge/%r0/n0/fR */
      2, /* bge/%r0/nR/fR */
      1, /* bge/%r1/%r0/fR */
      1, /* bge/%r1/%r1/fR */
      2, /* bge/%r1/%rR/fR */
      1, /* bge/%r1/n0/fR */
      2, /* bge/%r1/nR/fR */
      2, /* bge/%rR/%r0/fR */
      2, /* bge/%rR/%r1/fR */
      3, /* bge/%rR/%rR/fR */
      2, /* bge/%rR/n0/fR */
      3, /* bge/%rR/nR/fR */
      1, /* bge/n0/%r0/fR */
      1, /* bge/n0/%r1/fR */
      2, /* bge/n0/%rR/fR */
      1, /* bge/n0/n0/fR */
      2, /* bge/n0/nR/fR */
      2, /* bge/nR/%r0/fR */
      2, /* bge/nR/%r1/fR */
      3, /* bge/nR/%rR/fR */
      2, /* bge/nR/n0/fR */
      3, /* bge/nR/nR/fR */
      1, /* bl/%r0/%r0/fR */
      1, /* bl/%r0/%r1/fR */
      2, /* bl/%r0/%rR/fR */
      1, /* bl/%r0/n0/fR */
      2, /* bl/%r0/nR/fR */
      1, /* bl/%r1/%r0/fR */
      1, /* bl/%r1/%r1/fR */
      2, /* bl/%r1/%rR/fR */
      1, /* bl/%r1/n0/fR */
      2, /* bl/%r1/nR/fR */
      2, /* bl/%rR/%r0/fR */
      2, /* bl/%rR/%r1/fR */
      3, /* bl/%rR/%rR/fR */
      2, /* bl/%rR/n0/fR */
      3, /* bl/%rR/nR/fR */
      1, /* bl/n0/%r0/fR */
      1, /* bl/n0/%r1/fR */
      2, /* bl/n0/%rR/fR */
      1, /* bl/n0/n0/fR */
      2, /* bl/n0/nR/fR */
      2, /* bl/nR/%r0/fR */
      2, /* bl/nR/%r1/fR */
      3, /* bl/nR/%rR/fR */
      2, /* bl/nR/n0/fR */
      3, /* bl/nR/nR/fR */
      1, /* ble/%r0/%r0/fR */
      1, /* ble/%r0/%r1/fR */
      2, /* ble/%r0/%rR/fR */
      1, /* ble/%r0/n0/fR */
      2, /* ble/%r0/nR/fR */
      1, /* ble/%r1/%r0/fR */
      1, /* ble/%r1/%r1/fR */
      2, /* ble/%r1/%rR/fR */
      1, /* ble/%r1/n0/fR */
      2, /* ble/%r1/nR/fR */
      2, /* ble/%rR/%r0/fR */
      2, /* ble/%rR/%r1/fR */
      3, /* ble/%rR/%rR/fR */
      2, /* ble/%rR/n0/fR */
      3, /* ble/%rR/nR/fR */
      1, /* ble/n0/%r0/fR */
      1, /* ble/n0/%r1/fR */
      2, /* ble/n0/%rR/fR */
      1, /* ble/n0/n0/fR */
      2, /* ble/n0/nR/fR */
      2, /* ble/nR/%r0/fR */
      2, /* ble/nR/%r1/fR */
      3, /* ble/nR/%rR/fR */
      2, /* ble/nR/n0/fR */
      3, /* ble/nR/nR/fR */
      1, /* bne/%r0/%r0/fR */
      1, /* bne/%r0/%r1/fR */
      2, /* bne/%r0/%rR/fR */
      1, /* bne/%r0/n0/fR */
      2, /* bne/%r0/nR/fR */
      1, /* bne/%r1/%r0/fR */
      1, /* bne/%r1/%r1/fR */
      2, /* bne/%r1/%rR/fR */
      1, /* bne/%r1/n0/fR */
      2, /* bne/%r1/nR/fR */
      2, /* bne/%rR/%r0/fR */
      2, /* bne/%rR/%r1/fR */
      3, /* bne/%rR/%rR/fR */
      2, /* bne/%rR/n0/fR */
      3, /* bne/%rR/nR/fR */
      1, /* bne/n0/%r0/fR */
      1, /* bne/n0/%r1/fR */
      2, /* bne/n0/%rR/fR */
      1, /* bne/n0/n0/fR */
      2, /* bne/n0/nR/fR */
      2, /* bne/nR/%r0/fR */
      2, /* bne/nR/%r1/fR */
      3, /* bne/nR/%rR/fR */
      2, /* bne/nR/n0/fR */
      3, /* bne/nR/nR/fR */
      1, /* bneqi-stack/n-1/fR */
      1, /* bneqi-stack/n0/fR */
      1, /* bneqi-stack/n1/fR */
      1, /* bneqi-stack/n2/fR */
      2, /* bneqi-stack/nR/fR */
      1, /* bt-stack/fR */
      2, /* call/fR/retR */
      0, /* copy-to-r-stack/%r0 */
      0, /* copy-to-r-stack/%r1 */
      1, /* copy-to-r-stack/%rR */
      0, /* different-stack */
      1, /* divided/%r0/%r0/%r0/retR */
      1, /* divided/%r0/%r0/%r1/retR */
      2, /* divided/%r0/%r0/%rR/retR */
      1, /* divided/%r0/%r1/%r0/retR */
      1, /* divided/%r0/%r1/%r1/retR */
      2, /* divided/%r0/%r1/%rR/retR */
      2, /* divided/%r0/%rR/%r0/retR */
      2, /* divided/%r0/%rR/%r1/retR */
      3, /* divided/%r0/%rR/%rR/retR */
      1, /* divided/%r0/n2/%r0/retR */
      1, /* divided/%r0/n2/%r1/retR */
      2, /* divided/%r0/n2/%rR/retR */
      2, /* divided/%r0/nR/%r0/retR */
      2, /* divided/%r0/nR/%r1/retR */
      3, /* divided/%r0/nR/%rR/retR */
      1, /* divided/%r1/%r0/%r0/retR */
      1, /* divided/%r1/%r0/%r1/retR */
      2, /* divided/%r1/%r0/%rR/retR */
      1, /* divided/%r1/%r1/%r0/retR */
      1, /* divided/%r1/%r1/%r1/retR */
      2, /* divided/%r1/%r1/%rR/retR */
      2, /* divided/%r1/%rR/%r0/retR */
      2, /* divided/%r1/%rR/%r1/retR */
      3, /* divided/%r1/%rR/%rR/retR */
      1, /* divided/%r1/n2/%r0/retR */
      1, /* divided/%r1/n2/%r1/retR */
      2, /* divided/%r1/n2/%rR/retR */
      2, /* divided/%r1/nR/%r0/retR */
      2, /* divided/%r1/nR/%r1/retR */
      3, /* divided/%r1/nR/%rR/retR */
      2, /* divided/%rR/%r0/%r0/retR */
      2, /* divided/%rR/%r0/%r1/retR */
      3, /* divided/%rR/%r0/%rR/retR */
      2, /* divided/%rR/%r1/%r0/retR */
      2, /* divided/%rR/%r1/%r1/retR */
      3, /* divided/%rR/%r1/%rR/retR */
      3, /* divided/%rR/%rR/%r0/retR */
      3, /* divided/%rR/%rR/%r1/retR */
      4, /* divided/%rR/%rR/%rR/retR */
      2, /* divided/%rR/n2/%r0/retR */
      2, /* divided/%rR/n2/%r1/retR */
      3, /* divided/%rR/n2/%rR/retR */
      3, /* divided/%rR/nR/%r0/retR */
      3, /* divided/%rR/nR/%r1/retR */
      4, /* divided/%rR/nR/%rR/retR */
      2, /* divided/nR/%r0/%r0/retR */
      2, /* divided/nR/%r0/%r1/retR */
      3, /* divided/nR/%r0/%rR/retR */
      2, /* divided/nR/%r1/%r0/retR */
      2, /* divided/nR/%r1/%r1/retR */
      3, /* divided/nR/%r1/%rR/retR */
      3, /* divided/nR/%rR/%r0/retR */
      3, /* divided/nR/%rR/%r1/retR */
      4, /* divided/nR/%rR/%rR/retR */
      2, /* divided/nR/n2/%r0/retR */
      2, /* divided/nR/n2/%r1/retR */
      3, /* divided/nR/n2/%rR/retR */
      3, /* divided/nR/nR/%r0/retR */
      3, /* divided/nR/nR/%r1/retR */
      4, /* divided/nR/nR/%rR/retR */
      1, /* divided-stack/retR */
      0, /* drop-stack */
      0, /* dup-stack */
      0, /* equal-stack */
      0, /* equali-stack/n0 */
      0, /* equali-stack/n1 */
      0, /* equali-stack/n2 */
      1, /* equali-stack/nR */
      0, /* exitvm */
      0, /* greater-stack */
      0, /* greaterorequal-stack */
      1, /* input/%r0/retR */
      1, /* input/%r1/retR */
      2, /* input/%rR/retR */
      1, /* input-stack/retR */
      0, /* isnonzero-stack */
      0, /* less-stack */
      0, /* lessorequal-stack */
      0, /* load-boxed-literal/n0/%r0 */
      0, /* load-boxed-literal/n0/%r1 */
      1, /* load-boxed-literal/n0/%rR */
      0, /* load-boxed-literal/n1/%r0 */
      0, /* load-boxed-literal/n1/%r1 */
      1, /* load-boxed-literal/n1/%rR */
      0, /* load-boxed-literal/n2/%r0 */
      0, /* load-boxed-literal/n2/%r1 */
      1, /* load-boxed-literal/n2/%rR */
      0, /* load-boxed-literal/n3/%r0 */
      0, /* load-boxed-literal/n3/%r1 */
      1, /* load-boxed-literal/n3/%rR */
      0, /* load-boxed-literal/n4/%r0 */
      0, /* load-boxed-literal/n4/%r1 */
      1, /* load-boxed-literal/n4/%rR */
      0, /* load-boxed-literal/n5/%r0 */
      0, /* load-boxed-literal/n5/%r1 */
      1, /* load-boxed-literal/n5/%rR */
      0, /* load-boxed-literal/n6/%r0 */
      0, /* load-boxed-literal/n6/%r1 */
      1, /* load-boxed-literal/n6/%rR */
      0, /* load-boxed-literal/n7/%r0 */
      0, /* load-boxed-literal/n7/%r1 */
      1, /* load-boxed-literal/n7/%rR */
      0, /* load-boxed-literal/n8/%r0 */
      0, /* load-boxed-literal/n8/%r1 */
      1, /* load-boxed-literal/n8/%rR */
      0, /* load-boxed-literal/n9/%r0 */
      0, /* load-boxed-literal/n9/%r1 */
      1, /* load-boxed-literal/n9/%rR */
      0, /* load-boxed-literal/n10/%r0 */
      0, /* load-boxed-literal/n10/%r1 */
      1, /* load-boxed-literal/n10/%rR */
      1, /* load-boxed-literal/nR/%r0 */
      1, /* load-boxed-literal/nR/%r1 */
      2, /* load-boxed-literal/nR/%rR */
      0, /* logicaland-stack */
      0, /* logicalnot-stack */
      0, /* logicalor-stack */
      0, /* minus/%r0/%r0/%r0 */
      0, /* minus/%r0/%r0/%r1 */
      1, /* minus/%r0/%r0/%rR */
      0, /* minus/%r0/%r1/%r0 */
      0, /* minus/%r0/%r1/%r1 */
      1, /* minus/%r0/%r1/%rR */
      1, /* minus/%r0/%rR/%r0 */
      1, /* minus/%r0/%rR/%r1 */
      2, /* minus/%r0/%rR/%rR */
      0, /* minus/%r0/n1/%r0 */
      0, /* minus/%r0/n1/%r1 */
      1, /* minus/%r0/n1/%rR */
      0, /* minus/%r0/n2/%r0 */
      0, /* minus/%r0/n2/%r1 */
      1, /* minus/%r0/n2/%rR */
      1, /* minus/%r0/nR/%r0 */
      1, /* minus/%r0/nR/%r1 */
      2, /* minus/%r0/nR/%rR */
      0, /* minus/%r1/%r0/%r0 */
      0, /* minus/%r1/%r0/%r1 */
      1, /* minus/%r1/%r0/%rR */
      0, /* minus/%r1/%r1/%r0 */
      0, /* minus/%r1/%r1/%r1 */
      1, /* minus/%r1/%r1/%rR */
      1, /* minus/%r1/%rR/%r0 */
      1, /* minus/%r1/%rR/%r1 */
      2, /* minus/%r1/%rR/%rR */
      0, /* minus/%r1/n1/%r0 */
      0, /* minus/%r1/n1/%r1 */
      1, /* minus/%r1/n1/%rR */
      0, /* minus/%r1/n2/%r0 */
      0, /* minus/%r1/n2/%r1 */
      1, /* minus/%r1/n2/%rR */
      1, /* minus/%r1/nR/%r0 */
      1, /* minus/%r1/nR/%r1 */
      2, /* minus/%r1/nR/%rR */
      1, /* minus/%rR/%r0/%r0 */
      1, /* minus/%rR/%r0/%r1 */
      2, /* minus/%rR/%r0/%rR */
      1, /* minus/%rR/%r1/%r0 */
      1, /* minus/%rR/%r1/%r1 */
      2, /* minus/%rR/%r1/%rR */
      2, /* minus/%rR/%rR/%r0 */
      2, /* minus/%rR/%rR/%r1 */
      3, /* minus/%rR/%rR/%rR */
      1, /* minus/%rR/n1/%r0 */
      1, /* minus/%rR/n1/%r1 */
      2, /* minus/%rR/n1/%rR */
      1, /* minus/%rR/n2/%r0 */
      1, /* minus/%rR/n2/%r1 */
      2, /* minus/%rR/n2/%rR */
      2, /* minus/%rR/nR/%r0 */
      2, /* minus/%rR/nR/%r1 */
      3, /* minus/%rR/nR/%rR */
      1, /* minus/nR/%r0/%r0 */
      1, /* minus/nR/%r0/%r1 */
      2, /* minus/nR/%r0/%rR */
      1, /* minus/nR/%r1/%r0 */
      1, /* minus/nR/%r1/%r1 */
      2, /* minus/nR/%r1/%rR */
      2, /* minus/nR/%rR/%r0 */
      2, /* minus/nR/%rR/%r1 */
      3, /* minus/nR/%rR/%rR */
      1, /* minus/nR/n1/%r0 */
      1, /* minus/nR/n1/%r1 */
      2, /* minus/nR/n1/%rR */
      1, /* minus/nR/n2/%r0 */
      1, /* minus/nR/n2/%r1 */
      2, /* minus/nR/n2/%rR */
      2, /* minus/nR/nR/%r0 */
      2, /* minus/nR/nR/%r1 */
      3, /* minus/nR/nR/%rR */
      0, /* minus-stack */
      0, /* minusi-stack/n1 */
      0, /* minusi-stack/n2 */
      1, /* minusi-stack/nR */
      0, /* mov/%r0/%r0 */
      0, /* mov/%r0/%r1 */
      1, /* mov/%r0/%rR */
      0, /* mov/%r1/%r0 */
      0, /* mov/%r1/%r1 */
      1, /* mov/%r1/%rR */
      1, /* mov/%rR/%r0 */
      1, /* mov/%rR/%r1 */
      2, /* mov/%rR/%rR */
      0, /* mov/n0/%r0 */
      0, /* mov/n0/%r1 */
      1, /* mov/n0/%rR */
      0, /* mov/n1/%r0 */
      0, /* mov/n1/%r1 */
      1, /* mov/n1/%rR */
      0, /* mov/n-1/%r0 */
      0, /* mov/n-1/%r1 */
      1, /* mov/n-1/%rR */
      0, /* mov/n2/%r0 */
      0, /* mov/n2/%r1 */
      1, /* mov/n2/%rR */
      1, /* mov/nR/%r0 */
      1, /* mov/nR/%r1 */
      2, /* mov/nR/%rR */
      0, /* plus/%r0/%r0/%r0 */
      0, /* plus/%r0/%r0/%r1 */
      1, /* plus/%r0/%r0/%rR */
      0, /* plus/%r0/%r1/%r0 */
      0, /* plus/%r0/%r1/%r1 */
      1, /* plus/%r0/%r1/%rR */
      1, /* plus/%r0/%rR/%r0 */
      1, /* plus/%r0/%rR/%r1 */
      2, /* plus/%r0/%rR/%rR */
      0, /* plus/%r0/n1/%r0 */
      0, /* plus/%r0/n1/%r1 */
      1, /* plus/%r0/n1/%rR */
      0, /* plus/%r0/n2/%r0 */
      0, /* plus/%r0/n2/%r1 */
      1, /* plus/%r0/n2/%rR */
      1, /* plus/%r0/nR/%r0 */
      1, /* plus/%r0/nR/%r1 */
      2, /* plus/%r0/nR/%rR */
      0, /* plus/%r1/%r0/%r0 */
      0, /* plus/%r1/%r0/%r1 */
      1, /* plus/%r1/%r0/%rR */
      0, /* plus/%r1/%r1/%r0 */
      0, /* plus/%r1/%r1/%r1 */
      1, /* plus/%r1/%r1/%rR */
      1, /* plus/%r1/%rR/%r0 */
      1, /* plus/%r1/%rR/%r1 */
      2, /* plus/%r1/%rR/%rR */
      0, /* plus/%r1/n1/%r0 */
      0, /* plus/%r1/n1/%r1 */
      1, /* plus/%r1/n1/%rR */
      0, /* plus/%r1/n2/%r0 */
      0, /* plus/%r1/n2/%r1 */
      1, /* plus/%r1/n2/%rR */
      1, /* plus/%r1/nR/%r0 */
      1, /* plus/%r1/nR/%r1 */
      2, /* plus/%r1/nR/%rR */
      1, /* plus/%rR/%r0/%r0 */
      1, /* plus/%rR/%r0/%r1 */
      2, /* plus/%rR/%r0/%rR */
      1, /* plus/%rR/%r1/%r0 */
      1, /* plus/%rR/%r1/%r1 */
      2, /* plus/%rR/%r1/%rR */
      2, /* plus/%rR/%rR/%r0 */
      2, /* plus/%rR/%rR/%r1 */
      3, /* plus/%rR/%rR/%rR */
      1, /* plus/%rR/n1/%r0 */
      1, /* plus/%rR/n1/%r1 */
      2, /* plus/%rR/n1/%rR */
      1, /* plus/%rR/n2/%r0 */
      1, /* plus/%rR/n2/%r1 */
      2, /* plus/%rR/n2/%rR */
      2, /* plus/%rR/nR/%r0 */
      2, /* plus/%rR/nR/%r1 */
      3, /* plus/%rR/nR/%rR */
      0, /* plus/n1/%r0/%r0 */
      0, /* plus/n1/%r0/%r1 */
      1, /* plus/n1/%r0/%rR */
      0, /* plus/n1/%r1/%r0 */
      0, /* plus/n1/%r1/%r1 */
      1, /* plus/n1/%r1/%rR */
      1, /* plus/n1/%rR/%r0 */
      1, /* plus/n1/%rR/%r1 */
      2, /* plus/n1/%rR/%rR */
      0, /* plus/n1/n1/%r0 */
      0, /* plus/n1/n1/%r1 */
      1, /* plus/n1/n1/%rR */
      0, /* plus/n1/n2/%r0 */
      0, /* plus/n1/n2/%r1 */
      1, /* plus/n1/n2/%rR */
      1, /* plus/n1/nR/%r0 */
      1, /* plus/n1/nR/%r1 */
      2, /* plus/n1/nR/%rR */
      0, /* plus/n2/%r0/%r0 */
      0, /* plus/n2/%r0/%r1 */
      1, /* plus/n2/%r0/%rR */
      0, /* plus/n2/%r1/%r0 */
      0, /* plus/n2/%r1/%r1 */
      1, /* plus/n2/%r1/%rR */
      1, /* plus/n2/%rR/%r0 */
      1, /* plus/n2/%rR/%r1 */
      2, /* plus/n2/%rR/%rR */
      0, /* plus/n2/n1/%r0 */
      0, /* plus/n2/n1/%r1 */
      1, /* plus/n2/n1/%rR */
      0, /* plus/n2/n2/%r0 */
      0, /* plus/n2/n2/%r1 */
      1, /* plus/n2/n2/%rR */
      1, /* plus/n2/nR/%r0 */
      1, /* plus/n2/nR/%r1 */
      2, /* plus/n2/nR/%rR */
      1, /* plus/nR/%r0/%r0 */
      1, /* plus/nR/%r0/%r1 */
      2, /* plus/nR/%r0/%rR */
      1, /* plus/nR/%r1/%r0 */
      1, /* plus/nR/%r1/%r1 */
      2, /* plus/nR/%r1/%rR */
      2, /* plus/nR/%rR/%r0 */
      2, /* plus/nR/%rR/%r1 */
      3, /* plus/nR/%rR/%rR */
      1, /* plus/nR/n1/%r0 */
      1, /* plus/nR/n1/%r1 */
      2, /* plus/nR/n1/%rR */
      1, /* plus/nR/n2/%r0 */
      1, /* plus/nR/n2/%r1 */
      2, /* plus/nR/n2/%rR */
      2, /* plus/nR/nR/%r0 */
      2, /* plus/nR/nR/%r1 */
      3, /* plus/nR/nR/%rR */
      0, /* plus-stack */
      0, /* plusi-stack/n-1 */
      0, /* plusi-stack/n1 */
      0, /* plusi-stack/n2 */
      1, /* plusi-stack/nR */
      0, /* pop-stack/%r0 */
      0, /* pop-stack/%r1 */
      1, /* pop-stack/%rR */
      1, /* print/%r0/retR */
      1, /* print/%r1/retR */
      2, /* print/%rR/retR */
      2, /* print/nR/retR */
      1, /* print-stack/retR */
      0, /* procedure-prolog */
      0, /* push-boxed-literal/n0 */
      0, /* push-boxed-literal/n1 */
      0, /* push-boxed-literal/n2 */
      0, /* push-boxed-literal/n3 */
      0, /* push-boxed-literal/n4 */
      0, /* push-boxed-literal/n5 */
      0, /* push-boxed-literal/n6 */
      0, /* push-boxed-literal/n7 */
      0, /* push-boxed-literal/n8 */
      0, /* push-boxed-literal/n9 */
      0, /* push-boxed-literal/n10 */
      1, /* push-boxed-literal/nR */
      0, /* push-stack/%r0 */
      0, /* push-stack/%r1 */
      1, /* push-stack/%rR */
      0, /* push-stack/n0 */
      0, /* push-stack/n1 */
      0, /* push-stack/n-1 */
      0, /* push-stack/n2 */
      1, /* push-stack/nR */
      1, /* push-stack/lR */
      0, /* push-unspecified-stack */
      1, /* remainder/%r0/%r0/%r0/retR */
      1, /* remainder/%r0/%r0/%r1/retR */
      2, /* remainder/%r0/%r0/%rR/retR */
      1, /* remainder/%r0/%r1/%r0/retR */
      1, /* remainder/%r0/%r1/%r1/retR */
      2, /* remainder/%r0/%r1/%rR/retR */
      2, /* remainder/%r0/%rR/%r0/retR */
      2, /* remainder/%r0/%rR/%r1/retR */
      3, /* remainder/%r0/%rR/%rR/retR */
      1, /* remainder/%r0/n2/%r0/retR */
      1, /* remainder/%r0/n2/%r1/retR */
      2, /* remainder/%r0/n2/%rR/retR */
      2, /* remainder/%r0/nR/%r0/retR */
      2, /* remainder/%r0/nR/%r1/retR */
      3, /* remainder/%r0/nR/%rR/retR */
      1, /* remainder/%r1/%r0/%r0/retR */
      1, /* remainder/%r1/%r0/%r1/retR */
      2, /* remainder/%r1/%r0/%rR/retR */
      1, /* remainder/%r1/%r1/%r0/retR */
      1, /* remainder/%r1/%r1/%r1/retR */
      2, /* remainder/%r1/%r1/%rR/retR */
      2, /* remainder/%r1/%rR/%r0/retR */
      2, /* remainder/%r1/%rR/%r1/retR */
      3, /* remainder/%r1/%rR/%rR/retR */
      1, /* remainder/%r1/n2/%r0/retR */
      1, /* remainder/%r1/n2/%r1/retR */
      2, /* remainder/%r1/n2/%rR/retR */
      2, /* remainder/%r1/nR/%r0/retR */
      2, /* remainder/%r1/nR/%r1/retR */
      3, /* remainder/%r1/nR/%rR/retR */
      2, /* remainder/%rR/%r0/%r0/retR */
      2, /* remainder/%rR/%r0/%r1/retR */
      3, /* remainder/%rR/%r0/%rR/retR */
      2, /* remainder/%rR/%r1/%r0/retR */
      2, /* remainder/%rR/%r1/%r1/retR */
      3, /* remainder/%rR/%r1/%rR/retR */
      3, /* remainder/%rR/%rR/%r0/retR */
      3, /* remainder/%rR/%rR/%r1/retR */
      4, /* remainder/%rR/%rR/%rR/retR */
      2, /* remainder/%rR/n2/%r0/retR */
      2, /* remainder/%rR/n2/%r1/retR */
      3, /* remainder/%rR/n2/%rR/retR */
      3, /* remainder/%rR/nR/%r0/retR */
      3, /* remainder/%rR/nR/%r1/retR */
      4, /* remainder/%rR/nR/%rR/retR */
      2, /* remainder/nR/%r0/%r0/retR */
      2, /* remainder/nR/%r0/%r1/retR */
      3, /* remainder/nR/%r0/%rR/retR */
      2, /* remainder/nR/%r1/%r0/retR */
      2, /* remainder/nR/%r1/%r1/retR */
      3, /* remainder/nR/%r1/%rR/retR */
      3, /* remainder/nR/%rR/%r0/retR */
      3, /* remainder/nR/%rR/%r1/retR */
      4, /* remainder/nR/%rR/%rR/retR */
      2, /* remainder/nR/n2/%r0/retR */
      2, /* remainder/nR/n2/%r1/retR */
      3, /* remainder/nR/n2/%rR/retR */
      3, /* remainder/nR/nR/%r0/retR */
      3, /* remainder/nR/nR/%r1/retR */
      4, /* remainder/nR/nR/%rR/retR */
      1, /* remainder-stack/retR */
      0, /* return-to-undertop */
      0, /* swap-stack */
      0, /* times/%r0/%r0/%r0 */
      0, /* times/%r0/%r0/%r1 */
      1, /* times/%r0/%r0/%rR */
      0, /* times/%r0/%r1/%r0 */
      0, /* times/%r0/%r1/%r1 */
      1, /* times/%r0/%r1/%rR */
      1, /* times/%r0/%rR/%r0 */
      1, /* times/%r0/%rR/%r1 */
      2, /* times/%r0/%rR/%rR */
      0, /* times/%r0/n2/%r0 */
      0, /* times/%r0/n2/%r1 */
      1, /* times/%r0/n2/%rR */
      1, /* times/%r0/nR/%r0 */
      1, /* times/%r0/nR/%r1 */
      2, /* times/%r0/nR/%rR */
      0, /* times/%r1/%r0/%r0 */
      0, /* times/%r1/%r0/%r1 */
      1, /* times/%r1/%r0/%rR */
      0, /* times/%r1/%r1/%r0 */
      0, /* times/%r1/%r1/%r1 */
      1, /* times/%r1/%r1/%rR */
      1, /* times/%r1/%rR/%r0 */
      1, /* times/%r1/%rR/%r1 */
      2, /* times/%r1/%rR/%rR */
      0, /* times/%r1/n2/%r0 */
      0, /* times/%r1/n2/%r1 */
      1, /* times/%r1/n2/%rR */
      1, /* times/%r1/nR/%r0 */
      1, /* times/%r1/nR/%r1 */
      2, /* times/%r1/nR/%rR */
      1, /* times/%rR/%r0/%r0 */
      1, /* times/%rR/%r0/%r1 */
      2, /* times/%rR/%r0/%rR */
      1, /* times/%rR/%r1/%r0 */
      1, /* times/%rR/%r1/%r1 */
      2, /* times/%rR/%r1/%rR */
      2, /* times/%rR/%rR/%r0 */
      2, /* times/%rR/%rR/%r1 */
      3, /* times/%rR/%rR/%rR */
      1, /* times/%rR/n2/%r0 */
      1, /* times/%rR/n2/%r1 */
      2, /* times/%rR/n2/%rR */
      2, /* times/%rR/nR/%r0 */
      2, /* times/%rR/nR/%r1 */
      3, /* times/%rR/nR/%rR */
      1, /* times/nR/%r0/%r0 */
      1, /* times/nR/%r0/%r1 */
      2, /* times/nR/%r0/%rR */
      1, /* times/nR/%r1/%r0 */
      1, /* times/nR/%r1/%r1 */
      2, /* times/nR/%r1/%rR */
      2, /* times/nR/%rR/%r0 */
      2, /* times/nR/%rR/%r1 */
      3, /* times/nR/%rR/%rR */
      1, /* times/nR/n2/%r0 */
      1, /* times/nR/n2/%r1 */
      2, /* times/nR/n2/%rR */
      2, /* times/nR/nR/%r0 */
      2, /* times/nR/nR/%r1 */
      3, /* times/nR/nR/%rR */
      0, /* times-stack */
      0, /* uminus/%r0/%r0 */
      0, /* uminus/%r0/%r1 */
      1, /* uminus/%r0/%rR */
      0, /* uminus/%r1/%r0 */
      0, /* uminus/%r1/%r1 */
      1, /* uminus/%r1/%rR */
      1, /* uminus/%rR/%r0 */
      1, /* uminus/%rR/%r1 */
      2, /* uminus/%rR/%rR */
      1, /* uminus/nR/%r0 */
      1, /* uminus/nR/%r1 */
      2, /* uminus/nR/%rR */
      0, /* uminus-stack */
      0, /* underpop-stack/%r0 */
      0, /* underpop-stack/%r1 */
      1, /* underpop-stack/%rR */
      0, /* underpush-stack/%r0 */
      0, /* underpush-stack/%r1 */
      1, /* underpush-stack/%rR */
      1, /* underpush-stack/nR */
      0, /* unreachable */
      2, /* !REPLACEMENT-b/fR/retR */
      2, /* !REPLACEMENT-be/%r0/%r0/fR/retR */
      2, /* !REPLACEMENT-be/%r0/%r1/fR/retR */
      3, /* !REPLACEMENT-be/%r0/%rR/fR/retR */
      2, /* !REPLACEMENT-be/%r0/n0/fR/retR */
      3, /* !REPLACEMENT-be/%r0/nR/fR/retR */
      2, /* !REPLACEMENT-be/%r1/%r0/fR/retR */
      2, /* !REPLACEMENT-be/%r1/%r1/fR/retR */
      3, /* !REPLACEMENT-be/%r1/%rR/fR/retR */
      2, /* !REPLACEMENT-be/%r1/n0/fR/retR */
      3, /* !REPLACEMENT-be/%r1/nR/fR/retR */
      3, /* !REPLACEMENT-be/%rR/%r0/fR/retR */
      3, /* !REPLACEMENT-be/%rR/%r1/fR/retR */
      4, /* !REPLACEMENT-be/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-be/%rR/n0/fR/retR */
      4, /* !REPLACEMENT-be/%rR/nR/fR/retR */
      2, /* !REPLACEMENT-be/n0/%r0/fR/retR */
      2, /* !REPLACEMENT-be/n0/%r1/fR/retR */
      3, /* !REPLACEMENT-be/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-be/n0/n0/fR/retR */
      3, /* !REPLACEMENT-be/n0/nR/fR/retR */
      3, /* !REPLACEMENT-be/nR/%r0/fR/retR */
      3, /* !REPLACEMENT-be/nR/%r1/fR/retR */
      4, /* !REPLACEMENT-be/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-be/nR/n0/fR/retR */
      4, /* !REPLACEMENT-be/nR/nR/fR/retR */
      2, /* !REPLACEMENT-beqi-stack/n-1/fR/retR */
      2, /* !REPLACEMENT-beqi-stack/n0/fR/retR */
      2, /* !REPLACEMENT-beqi-stack/n1/fR/retR */
      2, /* !REPLACEMENT-beqi-stack/n2/fR/retR */
      3, /* !REPLACEMENT-beqi-stack/nR/fR/retR */
      2, /* !REPLACEMENT-bf-stack/fR/retR */
      2, /* !REPLACEMENT-bg/%r0/%r0/fR/retR */
      2, /* !REPLACEMENT-bg/%r0/%r1/fR/retR */
      3, /* !REPLACEMENT-bg/%r0/%rR/fR/retR */
      2, /* !REPLACEMENT-bg/%r0/n0/fR/retR */
      3, /* !REPLACEMENT-bg/%r0/nR/fR/retR */
      2, /* !REPLACEMENT-bg/%r1/%r0/fR/retR */
      2, /* !REPLACEMENT-bg/%r1/%r1/fR/retR */
      3, /* !REPLACEMENT-bg/%r1/%rR/fR/retR */
      2, /* !REPLACEMENT-bg/%r1/n0/fR/retR */
      3, /* !REPLACEMENT-bg/%r1/nR/fR/retR */
      3, /* !REPLACEMENT-bg/%rR/%r0/fR/retR */
      3, /* !REPLACEMENT-bg/%rR/%r1/fR/retR */
      4, /* !REPLACEMENT-bg/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-bg/%rR/n0/fR/retR */
      4, /* !REPLACEMENT-bg/%rR/nR/fR/retR */
      2, /* !REPLACEMENT-bg/n0/%r0/fR/retR */
      2, /* !REPLACEMENT-bg/n0/%r1/fR/retR */
      3, /* !REPLACEMENT-bg/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-bg/n0/n0/fR/retR */
      3, /* !REPLACEMENT-bg/n0/nR/fR/retR */
      3, /* !REPLACEMENT-bg/nR/%r0/fR/retR */
      3, /* !REPLACEMENT-bg/nR/%r1/fR/retR */
      4, /* !REPLACEMENT-bg/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-bg/nR/n0/fR/retR */
      4, /* !REPLACEMENT-bg/nR/nR/fR/retR */
      2, /* !REPLACEMENT-bge/%r0/%r0/fR/retR */
      2, /* !REPLACEMENT-bge/%r0/%r1/fR/retR */
      3, /* !REPLACEMENT-bge/%r0/%rR/fR/retR */
      2, /* !REPLACEMENT-bge/%r0/n0/fR/retR */
      3, /* !REPLACEMENT-bge/%r0/nR/fR/retR */
      2, /* !REPLACEMENT-bge/%r1/%r0/fR/retR */
      2, /* !REPLACEMENT-bge/%r1/%r1/fR/retR */
      3, /* !REPLACEMENT-bge/%r1/%rR/fR/retR */
      2, /* !REPLACEMENT-bge/%r1/n0/fR/retR */
      3, /* !REPLACEMENT-bge/%r1/nR/fR/retR */
      3, /* !REPLACEMENT-bge/%rR/%r0/fR/retR */
      3, /* !REPLACEMENT-bge/%rR/%r1/fR/retR */
      4, /* !REPLACEMENT-bge/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-bge/%rR/n0/fR/retR */
      4, /* !REPLACEMENT-bge/%rR/nR/fR/retR */
      2, /* !REPLACEMENT-bge/n0/%r0/fR/retR */
      2, /* !REPLACEMENT-bge/n0/%r1/fR/retR */
      3, /* !REPLACEMENT-bge/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-bge/n0/n0/fR/retR */
      3, /* !REPLACEMENT-bge/n0/nR/fR/retR */
      3, /* !REPLACEMENT-bge/nR/%r0/fR/retR */
      3, /* !REPLACEMENT-bge/nR/%r1/fR/retR */
      4, /* !REPLACEMENT-bge/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-bge/nR/n0/fR/retR */
      4, /* !REPLACEMENT-bge/nR/nR/fR/retR */
      2, /* !REPLACEMENT-bl/%r0/%r0/fR/retR */
      2, /* !REPLACEMENT-bl/%r0/%r1/fR/retR */
      3, /* !REPLACEMENT-bl/%r0/%rR/fR/retR */
      2, /* !REPLACEMENT-bl/%r0/n0/fR/retR */
      3, /* !REPLACEMENT-bl/%r0/nR/fR/retR */
      2, /* !REPLACEMENT-bl/%r1/%r0/fR/retR */
      2, /* !REPLACEMENT-bl/%r1/%r1/fR/retR */
      3, /* !REPLACEMENT-bl/%r1/%rR/fR/retR */
      2, /* !REPLACEMENT-bl/%r1/n0/fR/retR */
      3, /* !REPLACEMENT-bl/%r1/nR/fR/retR */
      3, /* !REPLACEMENT-bl/%rR/%r0/fR/retR */
      3, /* !REPLACEMENT-bl/%rR/%r1/fR/retR */
      4, /* !REPLACEMENT-bl/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-bl/%rR/n0/fR/retR */
      4, /* !REPLACEMENT-bl/%rR/nR/fR/retR */
      2, /* !REPLACEMENT-bl/n0/%r0/fR/retR */
      2, /* !REPLACEMENT-bl/n0/%r1/fR/retR */
      3, /* !REPLACEMENT-bl/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-bl/n0/n0/fR/retR */
      3, /* !REPLACEMENT-bl/n0/nR/fR/retR */
      3, /* !REPLACEMENT-bl/nR/%r0/fR/retR */
      3, /* !REPLACEMENT-bl/nR/%r1/fR/retR */
      4, /* !REPLACEMENT-bl/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-bl/nR/n0/fR/retR */
      4, /* !REPLACEMENT-bl/nR/nR/fR/retR */
      2, /* !REPLACEMENT-ble/%r0/%r0/fR/retR */
      2, /* !REPLACEMENT-ble/%r0/%r1/fR/retR */
      3, /* !REPLACEMENT-ble/%r0/%rR/fR/retR */
      2, /* !REPLACEMENT-ble/%r0/n0/fR/retR */
      3, /* !REPLACEMENT-ble/%r0/nR/fR/retR */
      2, /* !REPLACEMENT-ble/%r1/%r0/fR/retR */
      2, /* !REPLACEMENT-ble/%r1/%r1/fR/retR */
      3, /* !REPLACEMENT-ble/%r1/%rR/fR/retR */
      2, /* !REPLACEMENT-ble/%r1/n0/fR/retR */
      3, /* !REPLACEMENT-ble/%r1/nR/fR/retR */
      3, /* !REPLACEMENT-ble/%rR/%r0/fR/retR */
      3, /* !REPLACEMENT-ble/%rR/%r1/fR/retR */
      4, /* !REPLACEMENT-ble/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-ble/%rR/n0/fR/retR */
      4, /* !REPLACEMENT-ble/%rR/nR/fR/retR */
      2, /* !REPLACEMENT-ble/n0/%r0/fR/retR */
      2, /* !REPLACEMENT-ble/n0/%r1/fR/retR */
      3, /* !REPLACEMENT-ble/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-ble/n0/n0/fR/retR */
      3, /* !REPLACEMENT-ble/n0/nR/fR/retR */
      3, /* !REPLACEMENT-ble/nR/%r0/fR/retR */
      3, /* !REPLACEMENT-ble/nR/%r1/fR/retR */
      4, /* !REPLACEMENT-ble/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-ble/nR/n0/fR/retR */
      4, /* !REPLACEMENT-ble/nR/nR/fR/retR */
      2, /* !REPLACEMENT-bne/%r0/%r0/fR/retR */
      2, /* !REPLACEMENT-bne/%r0/%r1/fR/retR */
      3, /* !REPLACEMENT-bne/%r0/%rR/fR/retR */
      2, /* !REPLACEMENT-bne/%r0/n0/fR/retR */
      3, /* !REPLACEMENT-bne/%r0/nR/fR/retR */
      2, /* !REPLACEMENT-bne/%r1/%r0/fR/retR */
      2, /* !REPLACEMENT-bne/%r1/%r1/fR/retR */
      3, /* !REPLACEMENT-bne/%r1/%rR/fR/retR */
      2, /* !REPLACEMENT-bne/%r1/n0/fR/retR */
      3, /* !REPLACEMENT-bne/%r1/nR/fR/retR */
      3, /* !REPLACEMENT-bne/%rR/%r0/fR/retR */
      3, /* !REPLACEMENT-bne/%rR/%r1/fR/retR */
      4, /* !REPLACEMENT-bne/%rR/%rR/fR/retR */
      3, /* !REPLACEMENT-bne/%rR/n0/fR/retR */
      4, /* !REPLACEMENT-bne/%rR/nR/fR/retR */
      2, /* !REPLACEMENT-bne/n0/%r0/fR/retR */
      2, /* !REPLACEMENT-bne/n0/%r1/fR/retR */
      3, /* !REPLACEMENT-bne/n0/%rR/fR/retR */
      2, /* !REPLACEMENT-bne/n0/n0/fR/retR */
      3, /* !REPLACEMENT-bne/n0/nR/fR/retR */
      3, /* !REPLACEMENT-bne/nR/%r0/fR/retR */
      3, /* !REPLACEMENT-bne/nR/%r1/fR/retR */
      4, /* !REPLACEMENT-bne/nR/%rR/fR/retR */
      3, /* !REPLACEMENT-bne/nR/n0/fR/retR */
      4, /* !REPLACEMENT-bne/nR/nR/fR/retR */
      2, /* !REPLACEMENT-bneqi-stack/n-1/fR/retR */
      2, /* !REPLACEMENT-bneqi-stack/n0/fR/retR */
      2, /* !REPLACEMENT-bneqi-stack/n1/fR/retR */
      2, /* !REPLACEMENT-bneqi-stack/n2/fR/retR */
      3, /* !REPLACEMENT-bneqi-stack/nR/fR/retR */
      2, /* !REPLACEMENT-bt-stack/fR/retR */
      2, /* !REPLACEMENT-call/fR/retR */
      1, /* !REPLACEMENT-exitvm/retR */
      1, /* !REPLACEMENT-procedure-prolog/retR */
      1, /* !REPLACEMENT-return-to-undertop/retR */
      1 /* !REPLACEMENT-unreachable/retR */
    };
const unsigned long // FIXME: shall I use a shorter type when possible?
structuredvm_specialized_instruction_label_bitmasks [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
      /* It's important that !BEGINBASICBLOCK has a zero here: it does not need residual patching. */
      0, /* !INVALID */
      0, /* !BEGINBASICBLOCK */
      0, /* !EXITVM */
      0, /* !DATALOCATIONS */
      0, /* !NOP */
      0, /* !UNREACHABLE0 */
      0, /* !UNREACHABLE1 */
      0, /* !PRETENDTOJUMPANYWHERE */
      0 | (1UL << 0), /* b/fR */
      0 | (1UL << 0), /* be/%r0/%r0/fR */
      0 | (1UL << 0), /* be/%r0/%r1/fR */
      0 | (1UL << 1), /* be/%r0/%rR/fR */
      0 | (1UL << 0), /* be/%r0/n0/fR */
      0 | (1UL << 1), /* be/%r0/nR/fR */
      0 | (1UL << 0), /* be/%r1/%r0/fR */
      0 | (1UL << 0), /* be/%r1/%r1/fR */
      0 | (1UL << 1), /* be/%r1/%rR/fR */
      0 | (1UL << 0), /* be/%r1/n0/fR */
      0 | (1UL << 1), /* be/%r1/nR/fR */
      0 | (1UL << 1), /* be/%rR/%r0/fR */
      0 | (1UL << 1), /* be/%rR/%r1/fR */
      0 | (1UL << 2), /* be/%rR/%rR/fR */
      0 | (1UL << 1), /* be/%rR/n0/fR */
      0 | (1UL << 2), /* be/%rR/nR/fR */
      0 | (1UL << 0), /* be/n0/%r0/fR */
      0 | (1UL << 0), /* be/n0/%r1/fR */
      0 | (1UL << 1), /* be/n0/%rR/fR */
      0 | (1UL << 0), /* be/n0/n0/fR */
      0 | (1UL << 1), /* be/n0/nR/fR */
      0 | (1UL << 1), /* be/nR/%r0/fR */
      0 | (1UL << 1), /* be/nR/%r1/fR */
      0 | (1UL << 2), /* be/nR/%rR/fR */
      0 | (1UL << 1), /* be/nR/n0/fR */
      0 | (1UL << 2), /* be/nR/nR/fR */
      0 | (1UL << 0), /* beqi-stack/n-1/fR */
      0 | (1UL << 0), /* beqi-stack/n0/fR */
      0 | (1UL << 0), /* beqi-stack/n1/fR */
      0 | (1UL << 0), /* beqi-stack/n2/fR */
      0 | (1UL << 1), /* beqi-stack/nR/fR */
      0 | (1UL << 0), /* bf-stack/fR */
      0 | (1UL << 0), /* bg/%r0/%r0/fR */
      0 | (1UL << 0), /* bg/%r0/%r1/fR */
      0 | (1UL << 1), /* bg/%r0/%rR/fR */
      0 | (1UL << 0), /* bg/%r0/n0/fR */
      0 | (1UL << 1), /* bg/%r0/nR/fR */
      0 | (1UL << 0), /* bg/%r1/%r0/fR */
      0 | (1UL << 0), /* bg/%r1/%r1/fR */
      0 | (1UL << 1), /* bg/%r1/%rR/fR */
      0 | (1UL << 0), /* bg/%r1/n0/fR */
      0 | (1UL << 1), /* bg/%r1/nR/fR */
      0 | (1UL << 1), /* bg/%rR/%r0/fR */
      0 | (1UL << 1), /* bg/%rR/%r1/fR */
      0 | (1UL << 2), /* bg/%rR/%rR/fR */
      0 | (1UL << 1), /* bg/%rR/n0/fR */
      0 | (1UL << 2), /* bg/%rR/nR/fR */
      0 | (1UL << 0), /* bg/n0/%r0/fR */
      0 | (1UL << 0), /* bg/n0/%r1/fR */
      0 | (1UL << 1), /* bg/n0/%rR/fR */
      0 | (1UL << 0), /* bg/n0/n0/fR */
      0 | (1UL << 1), /* bg/n0/nR/fR */
      0 | (1UL << 1), /* bg/nR/%r0/fR */
      0 | (1UL << 1), /* bg/nR/%r1/fR */
      0 | (1UL << 2), /* bg/nR/%rR/fR */
      0 | (1UL << 1), /* bg/nR/n0/fR */
      0 | (1UL << 2), /* bg/nR/nR/fR */
      0 | (1UL << 0), /* bge/%r0/%r0/fR */
      0 | (1UL << 0), /* bge/%r0/%r1/fR */
      0 | (1UL << 1), /* bge/%r0/%rR/fR */
      0 | (1UL << 0), /* bge/%r0/n0/fR */
      0 | (1UL << 1), /* bge/%r0/nR/fR */
      0 | (1UL << 0), /* bge/%r1/%r0/fR */
      0 | (1UL << 0), /* bge/%r1/%r1/fR */
      0 | (1UL << 1), /* bge/%r1/%rR/fR */
      0 | (1UL << 0), /* bge/%r1/n0/fR */
      0 | (1UL << 1), /* bge/%r1/nR/fR */
      0 | (1UL << 1), /* bge/%rR/%r0/fR */
      0 | (1UL << 1), /* bge/%rR/%r1/fR */
      0 | (1UL << 2), /* bge/%rR/%rR/fR */
      0 | (1UL << 1), /* bge/%rR/n0/fR */
      0 | (1UL << 2), /* bge/%rR/nR/fR */
      0 | (1UL << 0), /* bge/n0/%r0/fR */
      0 | (1UL << 0), /* bge/n0/%r1/fR */
      0 | (1UL << 1), /* bge/n0/%rR/fR */
      0 | (1UL << 0), /* bge/n0/n0/fR */
      0 | (1UL << 1), /* bge/n0/nR/fR */
      0 | (1UL << 1), /* bge/nR/%r0/fR */
      0 | (1UL << 1), /* bge/nR/%r1/fR */
      0 | (1UL << 2), /* bge/nR/%rR/fR */
      0 | (1UL << 1), /* bge/nR/n0/fR */
      0 | (1UL << 2), /* bge/nR/nR/fR */
      0 | (1UL << 0), /* bl/%r0/%r0/fR */
      0 | (1UL << 0), /* bl/%r0/%r1/fR */
      0 | (1UL << 1), /* bl/%r0/%rR/fR */
      0 | (1UL << 0), /* bl/%r0/n0/fR */
      0 | (1UL << 1), /* bl/%r0/nR/fR */
      0 | (1UL << 0), /* bl/%r1/%r0/fR */
      0 | (1UL << 0), /* bl/%r1/%r1/fR */
      0 | (1UL << 1), /* bl/%r1/%rR/fR */
      0 | (1UL << 0), /* bl/%r1/n0/fR */
      0 | (1UL << 1), /* bl/%r1/nR/fR */
      0 | (1UL << 1), /* bl/%rR/%r0/fR */
      0 | (1UL << 1), /* bl/%rR/%r1/fR */
      0 | (1UL << 2), /* bl/%rR/%rR/fR */
      0 | (1UL << 1), /* bl/%rR/n0/fR */
      0 | (1UL << 2), /* bl/%rR/nR/fR */
      0 | (1UL << 0), /* bl/n0/%r0/fR */
      0 | (1UL << 0), /* bl/n0/%r1/fR */
      0 | (1UL << 1), /* bl/n0/%rR/fR */
      0 | (1UL << 0), /* bl/n0/n0/fR */
      0 | (1UL << 1), /* bl/n0/nR/fR */
      0 | (1UL << 1), /* bl/nR/%r0/fR */
      0 | (1UL << 1), /* bl/nR/%r1/fR */
      0 | (1UL << 2), /* bl/nR/%rR/fR */
      0 | (1UL << 1), /* bl/nR/n0/fR */
      0 | (1UL << 2), /* bl/nR/nR/fR */
      0 | (1UL << 0), /* ble/%r0/%r0/fR */
      0 | (1UL << 0), /* ble/%r0/%r1/fR */
      0 | (1UL << 1), /* ble/%r0/%rR/fR */
      0 | (1UL << 0), /* ble/%r0/n0/fR */
      0 | (1UL << 1), /* ble/%r0/nR/fR */
      0 | (1UL << 0), /* ble/%r1/%r0/fR */
      0 | (1UL << 0), /* ble/%r1/%r1/fR */
      0 | (1UL << 1), /* ble/%r1/%rR/fR */
      0 | (1UL << 0), /* ble/%r1/n0/fR */
      0 | (1UL << 1), /* ble/%r1/nR/fR */
      0 | (1UL << 1), /* ble/%rR/%r0/fR */
      0 | (1UL << 1), /* ble/%rR/%r1/fR */
      0 | (1UL << 2), /* ble/%rR/%rR/fR */
      0 | (1UL << 1), /* ble/%rR/n0/fR */
      0 | (1UL << 2), /* ble/%rR/nR/fR */
      0 | (1UL << 0), /* ble/n0/%r0/fR */
      0 | (1UL << 0), /* ble/n0/%r1/fR */
      0 | (1UL << 1), /* ble/n0/%rR/fR */
      0 | (1UL << 0), /* ble/n0/n0/fR */
      0 | (1UL << 1), /* ble/n0/nR/fR */
      0 | (1UL << 1), /* ble/nR/%r0/fR */
      0 | (1UL << 1), /* ble/nR/%r1/fR */
      0 | (1UL << 2), /* ble/nR/%rR/fR */
      0 | (1UL << 1), /* ble/nR/n0/fR */
      0 | (1UL << 2), /* ble/nR/nR/fR */
      0 | (1UL << 0), /* bne/%r0/%r0/fR */
      0 | (1UL << 0), /* bne/%r0/%r1/fR */
      0 | (1UL << 1), /* bne/%r0/%rR/fR */
      0 | (1UL << 0), /* bne/%r0/n0/fR */
      0 | (1UL << 1), /* bne/%r0/nR/fR */
      0 | (1UL << 0), /* bne/%r1/%r0/fR */
      0 | (1UL << 0), /* bne/%r1/%r1/fR */
      0 | (1UL << 1), /* bne/%r1/%rR/fR */
      0 | (1UL << 0), /* bne/%r1/n0/fR */
      0 | (1UL << 1), /* bne/%r1/nR/fR */
      0 | (1UL << 1), /* bne/%rR/%r0/fR */
      0 | (1UL << 1), /* bne/%rR/%r1/fR */
      0 | (1UL << 2), /* bne/%rR/%rR/fR */
      0 | (1UL << 1), /* bne/%rR/n0/fR */
      0 | (1UL << 2), /* bne/%rR/nR/fR */
      0 | (1UL << 0), /* bne/n0/%r0/fR */
      0 | (1UL << 0), /* bne/n0/%r1/fR */
      0 | (1UL << 1), /* bne/n0/%rR/fR */
      0 | (1UL << 0), /* bne/n0/n0/fR */
      0 | (1UL << 1), /* bne/n0/nR/fR */
      0 | (1UL << 1), /* bne/nR/%r0/fR */
      0 | (1UL << 1), /* bne/nR/%r1/fR */
      0 | (1UL << 2), /* bne/nR/%rR/fR */
      0 | (1UL << 1), /* bne/nR/n0/fR */
      0 | (1UL << 2), /* bne/nR/nR/fR */
      0 | (1UL << 0), /* bneqi-stack/n-1/fR */
      0 | (1UL << 0), /* bneqi-stack/n0/fR */
      0 | (1UL << 0), /* bneqi-stack/n1/fR */
      0 | (1UL << 0), /* bneqi-stack/n2/fR */
      0 | (1UL << 1), /* bneqi-stack/nR/fR */
      0 | (1UL << 0), /* bt-stack/fR */
      0 | (1UL << 0), /* call/fR/retR */
      0, /* copy-to-r-stack/%r0 */
      0, /* copy-to-r-stack/%r1 */
      0, /* copy-to-r-stack/%rR */
      0, /* different-stack */
      0, /* divided/%r0/%r0/%r0/retR */
      0, /* divided/%r0/%r0/%r1/retR */
      0, /* divided/%r0/%r0/%rR/retR */
      0, /* divided/%r0/%r1/%r0/retR */
      0, /* divided/%r0/%r1/%r1/retR */
      0, /* divided/%r0/%r1/%rR/retR */
      0, /* divided/%r0/%rR/%r0/retR */
      0, /* divided/%r0/%rR/%r1/retR */
      0, /* divided/%r0/%rR/%rR/retR */
      0, /* divided/%r0/n2/%r0/retR */
      0, /* divided/%r0/n2/%r1/retR */
      0, /* divided/%r0/n2/%rR/retR */
      0, /* divided/%r0/nR/%r0/retR */
      0, /* divided/%r0/nR/%r1/retR */
      0, /* divided/%r0/nR/%rR/retR */
      0, /* divided/%r1/%r0/%r0/retR */
      0, /* divided/%r1/%r0/%r1/retR */
      0, /* divided/%r1/%r0/%rR/retR */
      0, /* divided/%r1/%r1/%r0/retR */
      0, /* divided/%r1/%r1/%r1/retR */
      0, /* divided/%r1/%r1/%rR/retR */
      0, /* divided/%r1/%rR/%r0/retR */
      0, /* divided/%r1/%rR/%r1/retR */
      0, /* divided/%r1/%rR/%rR/retR */
      0, /* divided/%r1/n2/%r0/retR */
      0, /* divided/%r1/n2/%r1/retR */
      0, /* divided/%r1/n2/%rR/retR */
      0, /* divided/%r1/nR/%r0/retR */
      0, /* divided/%r1/nR/%r1/retR */
      0, /* divided/%r1/nR/%rR/retR */
      0, /* divided/%rR/%r0/%r0/retR */
      0, /* divided/%rR/%r0/%r1/retR */
      0, /* divided/%rR/%r0/%rR/retR */
      0, /* divided/%rR/%r1/%r0/retR */
      0, /* divided/%rR/%r1/%r1/retR */
      0, /* divided/%rR/%r1/%rR/retR */
      0, /* divided/%rR/%rR/%r0/retR */
      0, /* divided/%rR/%rR/%r1/retR */
      0, /* divided/%rR/%rR/%rR/retR */
      0, /* divided/%rR/n2/%r0/retR */
      0, /* divided/%rR/n2/%r1/retR */
      0, /* divided/%rR/n2/%rR/retR */
      0, /* divided/%rR/nR/%r0/retR */
      0, /* divided/%rR/nR/%r1/retR */
      0, /* divided/%rR/nR/%rR/retR */
      0, /* divided/nR/%r0/%r0/retR */
      0, /* divided/nR/%r0/%r1/retR */
      0, /* divided/nR/%r0/%rR/retR */
      0, /* divided/nR/%r1/%r0/retR */
      0, /* divided/nR/%r1/%r1/retR */
      0, /* divided/nR/%r1/%rR/retR */
      0, /* divided/nR/%rR/%r0/retR */
      0, /* divided/nR/%rR/%r1/retR */
      0, /* divided/nR/%rR/%rR/retR */
      0, /* divided/nR/n2/%r0/retR */
      0, /* divided/nR/n2/%r1/retR */
      0, /* divided/nR/n2/%rR/retR */
      0, /* divided/nR/nR/%r0/retR */
      0, /* divided/nR/nR/%r1/retR */
      0, /* divided/nR/nR/%rR/retR */
      0, /* divided-stack/retR */
      0, /* drop-stack */
      0, /* dup-stack */
      0, /* equal-stack */
      0, /* equali-stack/n0 */
      0, /* equali-stack/n1 */
      0, /* equali-stack/n2 */
      0, /* equali-stack/nR */
      0, /* exitvm */
      0, /* greater-stack */
      0, /* greaterorequal-stack */
      0, /* input/%r0/retR */
      0, /* input/%r1/retR */
      0, /* input/%rR/retR */
      0, /* input-stack/retR */
      0, /* isnonzero-stack */
      0, /* less-stack */
      0, /* lessorequal-stack */
      0, /* load-boxed-literal/n0/%r0 */
      0, /* load-boxed-literal/n0/%r1 */
      0, /* load-boxed-literal/n0/%rR */
      0, /* load-boxed-literal/n1/%r0 */
      0, /* load-boxed-literal/n1/%r1 */
      0, /* load-boxed-literal/n1/%rR */
      0, /* load-boxed-literal/n2/%r0 */
      0, /* load-boxed-literal/n2/%r1 */
      0, /* load-boxed-literal/n2/%rR */
      0, /* load-boxed-literal/n3/%r0 */
      0, /* load-boxed-literal/n3/%r1 */
      0, /* load-boxed-literal/n3/%rR */
      0, /* load-boxed-literal/n4/%r0 */
      0, /* load-boxed-literal/n4/%r1 */
      0, /* load-boxed-literal/n4/%rR */
      0, /* load-boxed-literal/n5/%r0 */
      0, /* load-boxed-literal/n5/%r1 */
      0, /* load-boxed-literal/n5/%rR */
      0, /* load-boxed-literal/n6/%r0 */
      0, /* load-boxed-literal/n6/%r1 */
      0, /* load-boxed-literal/n6/%rR */
      0, /* load-boxed-literal/n7/%r0 */
      0, /* load-boxed-literal/n7/%r1 */
      0, /* load-boxed-literal/n7/%rR */
      0, /* load-boxed-literal/n8/%r0 */
      0, /* load-boxed-literal/n8/%r1 */
      0, /* load-boxed-literal/n8/%rR */
      0, /* load-boxed-literal/n9/%r0 */
      0, /* load-boxed-literal/n9/%r1 */
      0, /* load-boxed-literal/n9/%rR */
      0, /* load-boxed-literal/n10/%r0 */
      0, /* load-boxed-literal/n10/%r1 */
      0, /* load-boxed-literal/n10/%rR */
      0, /* load-boxed-literal/nR/%r0 */
      0, /* load-boxed-literal/nR/%r1 */
      0, /* load-boxed-literal/nR/%rR */
      0, /* logicaland-stack */
      0, /* logicalnot-stack */
      0, /* logicalor-stack */
      0, /* minus/%r0/%r0/%r0 */
      0, /* minus/%r0/%r0/%r1 */
      0, /* minus/%r0/%r0/%rR */
      0, /* minus/%r0/%r1/%r0 */
      0, /* minus/%r0/%r1/%r1 */
      0, /* minus/%r0/%r1/%rR */
      0, /* minus/%r0/%rR/%r0 */
      0, /* minus/%r0/%rR/%r1 */
      0, /* minus/%r0/%rR/%rR */
      0, /* minus/%r0/n1/%r0 */
      0, /* minus/%r0/n1/%r1 */
      0, /* minus/%r0/n1/%rR */
      0, /* minus/%r0/n2/%r0 */
      0, /* minus/%r0/n2/%r1 */
      0, /* minus/%r0/n2/%rR */
      0, /* minus/%r0/nR/%r0 */
      0, /* minus/%r0/nR/%r1 */
      0, /* minus/%r0/nR/%rR */
      0, /* minus/%r1/%r0/%r0 */
      0, /* minus/%r1/%r0/%r1 */
      0, /* minus/%r1/%r0/%rR */
      0, /* minus/%r1/%r1/%r0 */
      0, /* minus/%r1/%r1/%r1 */
      0, /* minus/%r1/%r1/%rR */
      0, /* minus/%r1/%rR/%r0 */
      0, /* minus/%r1/%rR/%r1 */
      0, /* minus/%r1/%rR/%rR */
      0, /* minus/%r1/n1/%r0 */
      0, /* minus/%r1/n1/%r1 */
      0, /* minus/%r1/n1/%rR */
      0, /* minus/%r1/n2/%r0 */
      0, /* minus/%r1/n2/%r1 */
      0, /* minus/%r1/n2/%rR */
      0, /* minus/%r1/nR/%r0 */
      0, /* minus/%r1/nR/%r1 */
      0, /* minus/%r1/nR/%rR */
      0, /* minus/%rR/%r0/%r0 */
      0, /* minus/%rR/%r0/%r1 */
      0, /* minus/%rR/%r0/%rR */
      0, /* minus/%rR/%r1/%r0 */
      0, /* minus/%rR/%r1/%r1 */
      0, /* minus/%rR/%r1/%rR */
      0, /* minus/%rR/%rR/%r0 */
      0, /* minus/%rR/%rR/%r1 */
      0, /* minus/%rR/%rR/%rR */
      0, /* minus/%rR/n1/%r0 */
      0, /* minus/%rR/n1/%r1 */
      0, /* minus/%rR/n1/%rR */
      0, /* minus/%rR/n2/%r0 */
      0, /* minus/%rR/n2/%r1 */
      0, /* minus/%rR/n2/%rR */
      0, /* minus/%rR/nR/%r0 */
      0, /* minus/%rR/nR/%r1 */
      0, /* minus/%rR/nR/%rR */
      0, /* minus/nR/%r0/%r0 */
      0, /* minus/nR/%r0/%r1 */
      0, /* minus/nR/%r0/%rR */
      0, /* minus/nR/%r1/%r0 */
      0, /* minus/nR/%r1/%r1 */
      0, /* minus/nR/%r1/%rR */
      0, /* minus/nR/%rR/%r0 */
      0, /* minus/nR/%rR/%r1 */
      0, /* minus/nR/%rR/%rR */
      0, /* minus/nR/n1/%r0 */
      0, /* minus/nR/n1/%r1 */
      0, /* minus/nR/n1/%rR */
      0, /* minus/nR/n2/%r0 */
      0, /* minus/nR/n2/%r1 */
      0, /* minus/nR/n2/%rR */
      0, /* minus/nR/nR/%r0 */
      0, /* minus/nR/nR/%r1 */
      0, /* minus/nR/nR/%rR */
      0, /* minus-stack */
      0, /* minusi-stack/n1 */
      0, /* minusi-stack/n2 */
      0, /* minusi-stack/nR */
      0, /* mov/%r0/%r0 */
      0, /* mov/%r0/%r1 */
      0, /* mov/%r0/%rR */
      0, /* mov/%r1/%r0 */
      0, /* mov/%r1/%r1 */
      0, /* mov/%r1/%rR */
      0, /* mov/%rR/%r0 */
      0, /* mov/%rR/%r1 */
      0, /* mov/%rR/%rR */
      0, /* mov/n0/%r0 */
      0, /* mov/n0/%r1 */
      0, /* mov/n0/%rR */
      0, /* mov/n1/%r0 */
      0, /* mov/n1/%r1 */
      0, /* mov/n1/%rR */
      0, /* mov/n-1/%r0 */
      0, /* mov/n-1/%r1 */
      0, /* mov/n-1/%rR */
      0, /* mov/n2/%r0 */
      0, /* mov/n2/%r1 */
      0, /* mov/n2/%rR */
      0, /* mov/nR/%r0 */
      0, /* mov/nR/%r1 */
      0, /* mov/nR/%rR */
      0, /* plus/%r0/%r0/%r0 */
      0, /* plus/%r0/%r0/%r1 */
      0, /* plus/%r0/%r0/%rR */
      0, /* plus/%r0/%r1/%r0 */
      0, /* plus/%r0/%r1/%r1 */
      0, /* plus/%r0/%r1/%rR */
      0, /* plus/%r0/%rR/%r0 */
      0, /* plus/%r0/%rR/%r1 */
      0, /* plus/%r0/%rR/%rR */
      0, /* plus/%r0/n1/%r0 */
      0, /* plus/%r0/n1/%r1 */
      0, /* plus/%r0/n1/%rR */
      0, /* plus/%r0/n2/%r0 */
      0, /* plus/%r0/n2/%r1 */
      0, /* plus/%r0/n2/%rR */
      0, /* plus/%r0/nR/%r0 */
      0, /* plus/%r0/nR/%r1 */
      0, /* plus/%r0/nR/%rR */
      0, /* plus/%r1/%r0/%r0 */
      0, /* plus/%r1/%r0/%r1 */
      0, /* plus/%r1/%r0/%rR */
      0, /* plus/%r1/%r1/%r0 */
      0, /* plus/%r1/%r1/%r1 */
      0, /* plus/%r1/%r1/%rR */
      0, /* plus/%r1/%rR/%r0 */
      0, /* plus/%r1/%rR/%r1 */
      0, /* plus/%r1/%rR/%rR */
      0, /* plus/%r1/n1/%r0 */
      0, /* plus/%r1/n1/%r1 */
      0, /* plus/%r1/n1/%rR */
      0, /* plus/%r1/n2/%r0 */
      0, /* plus/%r1/n2/%r1 */
      0, /* plus/%r1/n2/%rR */
      0, /* plus/%r1/nR/%r0 */
      0, /* plus/%r1/nR/%r1 */
      0, /* plus/%r1/nR/%rR */
      0, /* plus/%rR/%r0/%r0 */
      0, /* plus/%rR/%r0/%r1 */
      0, /* plus/%rR/%r0/%rR */
      0, /* plus/%rR/%r1/%r0 */
      0, /* plus/%rR/%r1/%r1 */
      0, /* plus/%rR/%r1/%rR */
      0, /* plus/%rR/%rR/%r0 */
      0, /* plus/%rR/%rR/%r1 */
      0, /* plus/%rR/%rR/%rR */
      0, /* plus/%rR/n1/%r0 */
      0, /* plus/%rR/n1/%r1 */
      0, /* plus/%rR/n1/%rR */
      0, /* plus/%rR/n2/%r0 */
      0, /* plus/%rR/n2/%r1 */
      0, /* plus/%rR/n2/%rR */
      0, /* plus/%rR/nR/%r0 */
      0, /* plus/%rR/nR/%r1 */
      0, /* plus/%rR/nR/%rR */
      0, /* plus/n1/%r0/%r0 */
      0, /* plus/n1/%r0/%r1 */
      0, /* plus/n1/%r0/%rR */
      0, /* plus/n1/%r1/%r0 */
      0, /* plus/n1/%r1/%r1 */
      0, /* plus/n1/%r1/%rR */
      0, /* plus/n1/%rR/%r0 */
      0, /* plus/n1/%rR/%r1 */
      0, /* plus/n1/%rR/%rR */
      0, /* plus/n1/n1/%r0 */
      0, /* plus/n1/n1/%r1 */
      0, /* plus/n1/n1/%rR */
      0, /* plus/n1/n2/%r0 */
      0, /* plus/n1/n2/%r1 */
      0, /* plus/n1/n2/%rR */
      0, /* plus/n1/nR/%r0 */
      0, /* plus/n1/nR/%r1 */
      0, /* plus/n1/nR/%rR */
      0, /* plus/n2/%r0/%r0 */
      0, /* plus/n2/%r0/%r1 */
      0, /* plus/n2/%r0/%rR */
      0, /* plus/n2/%r1/%r0 */
      0, /* plus/n2/%r1/%r1 */
      0, /* plus/n2/%r1/%rR */
      0, /* plus/n2/%rR/%r0 */
      0, /* plus/n2/%rR/%r1 */
      0, /* plus/n2/%rR/%rR */
      0, /* plus/n2/n1/%r0 */
      0, /* plus/n2/n1/%r1 */
      0, /* plus/n2/n1/%rR */
      0, /* plus/n2/n2/%r0 */
      0, /* plus/n2/n2/%r1 */
      0, /* plus/n2/n2/%rR */
      0, /* plus/n2/nR/%r0 */
      0, /* plus/n2/nR/%r1 */
      0, /* plus/n2/nR/%rR */
      0, /* plus/nR/%r0/%r0 */
      0, /* plus/nR/%r0/%r1 */
      0, /* plus/nR/%r0/%rR */
      0, /* plus/nR/%r1/%r0 */
      0, /* plus/nR/%r1/%r1 */
      0, /* plus/nR/%r1/%rR */
      0, /* plus/nR/%rR/%r0 */
      0, /* plus/nR/%rR/%r1 */
      0, /* plus/nR/%rR/%rR */
      0, /* plus/nR/n1/%r0 */
      0, /* plus/nR/n1/%r1 */
      0, /* plus/nR/n1/%rR */
      0, /* plus/nR/n2/%r0 */
      0, /* plus/nR/n2/%r1 */
      0, /* plus/nR/n2/%rR */
      0, /* plus/nR/nR/%r0 */
      0, /* plus/nR/nR/%r1 */
      0, /* plus/nR/nR/%rR */
      0, /* plus-stack */
      0, /* plusi-stack/n-1 */
      0, /* plusi-stack/n1 */
      0, /* plusi-stack/n2 */
      0, /* plusi-stack/nR */
      0, /* pop-stack/%r0 */
      0, /* pop-stack/%r1 */
      0, /* pop-stack/%rR */
      0, /* print/%r0/retR */
      0, /* print/%r1/retR */
      0, /* print/%rR/retR */
      0, /* print/nR/retR */
      0, /* print-stack/retR */
      0, /* procedure-prolog */
      0, /* push-boxed-literal/n0 */
      0, /* push-boxed-literal/n1 */
      0, /* push-boxed-literal/n2 */
      0, /* push-boxed-literal/n3 */
      0, /* push-boxed-literal/n4 */
      0, /* push-boxed-literal/n5 */
      0, /* push-boxed-literal/n6 */
      0, /* push-boxed-literal/n7 */
      0, /* push-boxed-literal/n8 */
      0, /* push-boxed-literal/n9 */
      0, /* push-boxed-literal/n10 */
      0, /* push-boxed-literal/nR */
      0, /* push-stack/%r0 */
      0, /* push-stack/%r1 */
      0, /* push-stack/%rR */
      0, /* push-stack/n0 */
      0, /* push-stack/n1 */
      0, /* push-stack/n-1 */
      0, /* push-stack/n2 */
      0, /* push-stack/nR */
      0 | (1UL << 0), /* push-stack/lR */
      0, /* push-unspecified-stack */
      0, /* remainder/%r0/%r0/%r0/retR */
      0, /* remainder/%r0/%r0/%r1/retR */
      0, /* remainder/%r0/%r0/%rR/retR */
      0, /* remainder/%r0/%r1/%r0/retR */
      0, /* remainder/%r0/%r1/%r1/retR */
      0, /* remainder/%r0/%r1/%rR/retR */
      0, /* remainder/%r0/%rR/%r0/retR */
      0, /* remainder/%r0/%rR/%r1/retR */
      0, /* remainder/%r0/%rR/%rR/retR */
      0, /* remainder/%r0/n2/%r0/retR */
      0, /* remainder/%r0/n2/%r1/retR */
      0, /* remainder/%r0/n2/%rR/retR */
      0, /* remainder/%r0/nR/%r0/retR */
      0, /* remainder/%r0/nR/%r1/retR */
      0, /* remainder/%r0/nR/%rR/retR */
      0, /* remainder/%r1/%r0/%r0/retR */
      0, /* remainder/%r1/%r0/%r1/retR */
      0, /* remainder/%r1/%r0/%rR/retR */
      0, /* remainder/%r1/%r1/%r0/retR */
      0, /* remainder/%r1/%r1/%r1/retR */
      0, /* remainder/%r1/%r1/%rR/retR */
      0, /* remainder/%r1/%rR/%r0/retR */
      0, /* remainder/%r1/%rR/%r1/retR */
      0, /* remainder/%r1/%rR/%rR/retR */
      0, /* remainder/%r1/n2/%r0/retR */
      0, /* remainder/%r1/n2/%r1/retR */
      0, /* remainder/%r1/n2/%rR/retR */
      0, /* remainder/%r1/nR/%r0/retR */
      0, /* remainder/%r1/nR/%r1/retR */
      0, /* remainder/%r1/nR/%rR/retR */
      0, /* remainder/%rR/%r0/%r0/retR */
      0, /* remainder/%rR/%r0/%r1/retR */
      0, /* remainder/%rR/%r0/%rR/retR */
      0, /* remainder/%rR/%r1/%r0/retR */
      0, /* remainder/%rR/%r1/%r1/retR */
      0, /* remainder/%rR/%r1/%rR/retR */
      0, /* remainder/%rR/%rR/%r0/retR */
      0, /* remainder/%rR/%rR/%r1/retR */
      0, /* remainder/%rR/%rR/%rR/retR */
      0, /* remainder/%rR/n2/%r0/retR */
      0, /* remainder/%rR/n2/%r1/retR */
      0, /* remainder/%rR/n2/%rR/retR */
      0, /* remainder/%rR/nR/%r0/retR */
      0, /* remainder/%rR/nR/%r1/retR */
      0, /* remainder/%rR/nR/%rR/retR */
      0, /* remainder/nR/%r0/%r0/retR */
      0, /* remainder/nR/%r0/%r1/retR */
      0, /* remainder/nR/%r0/%rR/retR */
      0, /* remainder/nR/%r1/%r0/retR */
      0, /* remainder/nR/%r1/%r1/retR */
      0, /* remainder/nR/%r1/%rR/retR */
      0, /* remainder/nR/%rR/%r0/retR */
      0, /* remainder/nR/%rR/%r1/retR */
      0, /* remainder/nR/%rR/%rR/retR */
      0, /* remainder/nR/n2/%r0/retR */
      0, /* remainder/nR/n2/%r1/retR */
      0, /* remainder/nR/n2/%rR/retR */
      0, /* remainder/nR/nR/%r0/retR */
      0, /* remainder/nR/nR/%r1/retR */
      0, /* remainder/nR/nR/%rR/retR */
      0, /* remainder-stack/retR */
      0, /* return-to-undertop */
      0, /* swap-stack */
      0, /* times/%r0/%r0/%r0 */
      0, /* times/%r0/%r0/%r1 */
      0, /* times/%r0/%r0/%rR */
      0, /* times/%r0/%r1/%r0 */
      0, /* times/%r0/%r1/%r1 */
      0, /* times/%r0/%r1/%rR */
      0, /* times/%r0/%rR/%r0 */
      0, /* times/%r0/%rR/%r1 */
      0, /* times/%r0/%rR/%rR */
      0, /* times/%r0/n2/%r0 */
      0, /* times/%r0/n2/%r1 */
      0, /* times/%r0/n2/%rR */
      0, /* times/%r0/nR/%r0 */
      0, /* times/%r0/nR/%r1 */
      0, /* times/%r0/nR/%rR */
      0, /* times/%r1/%r0/%r0 */
      0, /* times/%r1/%r0/%r1 */
      0, /* times/%r1/%r0/%rR */
      0, /* times/%r1/%r1/%r0 */
      0, /* times/%r1/%r1/%r1 */
      0, /* times/%r1/%r1/%rR */
      0, /* times/%r1/%rR/%r0 */
      0, /* times/%r1/%rR/%r1 */
      0, /* times/%r1/%rR/%rR */
      0, /* times/%r1/n2/%r0 */
      0, /* times/%r1/n2/%r1 */
      0, /* times/%r1/n2/%rR */
      0, /* times/%r1/nR/%r0 */
      0, /* times/%r1/nR/%r1 */
      0, /* times/%r1/nR/%rR */
      0, /* times/%rR/%r0/%r0 */
      0, /* times/%rR/%r0/%r1 */
      0, /* times/%rR/%r0/%rR */
      0, /* times/%rR/%r1/%r0 */
      0, /* times/%rR/%r1/%r1 */
      0, /* times/%rR/%r1/%rR */
      0, /* times/%rR/%rR/%r0 */
      0, /* times/%rR/%rR/%r1 */
      0, /* times/%rR/%rR/%rR */
      0, /* times/%rR/n2/%r0 */
      0, /* times/%rR/n2/%r1 */
      0, /* times/%rR/n2/%rR */
      0, /* times/%rR/nR/%r0 */
      0, /* times/%rR/nR/%r1 */
      0, /* times/%rR/nR/%rR */
      0, /* times/nR/%r0/%r0 */
      0, /* times/nR/%r0/%r1 */
      0, /* times/nR/%r0/%rR */
      0, /* times/nR/%r1/%r0 */
      0, /* times/nR/%r1/%r1 */
      0, /* times/nR/%r1/%rR */
      0, /* times/nR/%rR/%r0 */
      0, /* times/nR/%rR/%r1 */
      0, /* times/nR/%rR/%rR */
      0, /* times/nR/n2/%r0 */
      0, /* times/nR/n2/%r1 */
      0, /* times/nR/n2/%rR */
      0, /* times/nR/nR/%r0 */
      0, /* times/nR/nR/%r1 */
      0, /* times/nR/nR/%rR */
      0, /* times-stack */
      0, /* uminus/%r0/%r0 */
      0, /* uminus/%r0/%r1 */
      0, /* uminus/%r0/%rR */
      0, /* uminus/%r1/%r0 */
      0, /* uminus/%r1/%r1 */
      0, /* uminus/%r1/%rR */
      0, /* uminus/%rR/%r0 */
      0, /* uminus/%rR/%r1 */
      0, /* uminus/%rR/%rR */
      0, /* uminus/nR/%r0 */
      0, /* uminus/nR/%r1 */
      0, /* uminus/nR/%rR */
      0, /* uminus-stack */
      0, /* underpop-stack/%r0 */
      0, /* underpop-stack/%r1 */
      0, /* underpop-stack/%rR */
      0, /* underpush-stack/%r0 */
      0, /* underpush-stack/%r1 */
      0, /* underpush-stack/%rR */
      0, /* underpush-stack/nR */
      0, /* unreachable */
      0 | (1UL << 0), /* !REPLACEMENT-b/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-be/%r0/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-be/%r0/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-be/%r0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-be/%r0/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-be/%r0/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-be/%r1/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-be/%r1/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-be/%r1/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-be/%r1/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-be/%r1/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-be/%rR/%r0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-be/%rR/%r1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-be/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-be/%rR/n0/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-be/%rR/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-be/n0/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-be/n0/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-be/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-be/n0/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-be/n0/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-be/nR/%r0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-be/nR/%r1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-be/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-be/nR/n0/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-be/nR/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-beqi-stack/n-1/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-beqi-stack/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-beqi-stack/n1/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-beqi-stack/n2/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-beqi-stack/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bf-stack/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bg/%r0/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bg/%r0/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bg/%r0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bg/%r0/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bg/%r0/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bg/%r1/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bg/%r1/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bg/%r1/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bg/%r1/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bg/%r1/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bg/%rR/%r0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bg/%rR/%r1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bg/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bg/%rR/n0/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bg/%rR/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bg/n0/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bg/n0/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bg/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bg/n0/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bg/n0/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bg/nR/%r0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bg/nR/%r1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bg/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bg/nR/n0/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bg/nR/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bge/%r0/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bge/%r0/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/%r0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bge/%r0/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/%r0/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bge/%r1/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bge/%r1/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/%r1/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bge/%r1/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/%r1/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/%rR/%r0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/%rR/%r1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bge/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/%rR/n0/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bge/%rR/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bge/n0/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bge/n0/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bge/n0/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/n0/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/nR/%r0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/nR/%r1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bge/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bge/nR/n0/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bge/nR/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bl/%r0/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bl/%r0/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bl/%r0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bl/%r0/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bl/%r0/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bl/%r1/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bl/%r1/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bl/%r1/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bl/%r1/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bl/%r1/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bl/%rR/%r0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bl/%rR/%r1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bl/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bl/%rR/n0/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bl/%rR/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bl/n0/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bl/n0/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bl/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bl/n0/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bl/n0/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bl/nR/%r0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bl/nR/%r1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bl/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bl/nR/n0/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bl/nR/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-ble/%r0/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-ble/%r0/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/%r0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-ble/%r0/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/%r0/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-ble/%r1/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-ble/%r1/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/%r1/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-ble/%r1/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/%r1/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/%rR/%r0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/%rR/%r1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-ble/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/%rR/n0/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-ble/%rR/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-ble/n0/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-ble/n0/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-ble/n0/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/n0/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/nR/%r0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/nR/%r1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-ble/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-ble/nR/n0/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-ble/nR/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bne/%r0/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bne/%r0/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/%r0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bne/%r0/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/%r0/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bne/%r1/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bne/%r1/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/%r1/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bne/%r1/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/%r1/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/%rR/%r0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/%rR/%r1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bne/%rR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/%rR/n0/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bne/%rR/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bne/n0/%r0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bne/n0/%r1/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/n0/%rR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bne/n0/n0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/n0/nR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/nR/%r0/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/nR/%r1/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bne/nR/%rR/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bne/nR/n0/fR/retR */
      0 | (1UL << 2), /* !REPLACEMENT-bne/nR/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bneqi-stack/n-1/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bneqi-stack/n0/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bneqi-stack/n1/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bneqi-stack/n2/fR/retR */
      0 | (1UL << 1), /* !REPLACEMENT-bneqi-stack/nR/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-bt-stack/fR/retR */
      0 | (1UL << 0), /* !REPLACEMENT-call/fR/retR */
      0, /* !REPLACEMENT-exitvm/retR */
      0, /* !REPLACEMENT-procedure-prolog/retR */
      0, /* !REPLACEMENT-return-to-undertop/retR */
      0 /* !REPLACEMENT-unreachable/retR */
    };
#ifdef JITTER_HAVE_PATCH_IN
const unsigned long // FIXME: shall I use a shorter type when possible?
structuredvm_specialized_instruction_fast_label_bitmasks [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
      /* It's important that !BEGINBASICBLOCK has a zero here: it does not need residual patching. */
      0, /* !INVALID */
      0, /* !BEGINBASICBLOCK */
      0, /* !EXITVM */
      0, /* !DATALOCATIONS */
      0, /* !NOP */
      0, /* !UNREACHABLE0 */
      0, /* !UNREACHABLE1 */
      0, /* !PRETENDTOJUMPANYWHERE */
      0 | (1UL << 0), /* b/fR */
      0 | (1UL << 0), /* be/%r0/%r0/fR */
      0 | (1UL << 0), /* be/%r0/%r1/fR */
      0 | (1UL << 1), /* be/%r0/%rR/fR */
      0 | (1UL << 0), /* be/%r0/n0/fR */
      0 | (1UL << 1), /* be/%r0/nR/fR */
      0 | (1UL << 0), /* be/%r1/%r0/fR */
      0 | (1UL << 0), /* be/%r1/%r1/fR */
      0 | (1UL << 1), /* be/%r1/%rR/fR */
      0 | (1UL << 0), /* be/%r1/n0/fR */
      0 | (1UL << 1), /* be/%r1/nR/fR */
      0 | (1UL << 1), /* be/%rR/%r0/fR */
      0 | (1UL << 1), /* be/%rR/%r1/fR */
      0 | (1UL << 2), /* be/%rR/%rR/fR */
      0 | (1UL << 1), /* be/%rR/n0/fR */
      0 | (1UL << 2), /* be/%rR/nR/fR */
      0 | (1UL << 0), /* be/n0/%r0/fR */
      0 | (1UL << 0), /* be/n0/%r1/fR */
      0 | (1UL << 1), /* be/n0/%rR/fR */
      0 | (1UL << 0), /* be/n0/n0/fR */
      0 | (1UL << 1), /* be/n0/nR/fR */
      0 | (1UL << 1), /* be/nR/%r0/fR */
      0 | (1UL << 1), /* be/nR/%r1/fR */
      0 | (1UL << 2), /* be/nR/%rR/fR */
      0 | (1UL << 1), /* be/nR/n0/fR */
      0 | (1UL << 2), /* be/nR/nR/fR */
      0 | (1UL << 0), /* beqi-stack/n-1/fR */
      0 | (1UL << 0), /* beqi-stack/n0/fR */
      0 | (1UL << 0), /* beqi-stack/n1/fR */
      0 | (1UL << 0), /* beqi-stack/n2/fR */
      0 | (1UL << 1), /* beqi-stack/nR/fR */
      0 | (1UL << 0), /* bf-stack/fR */
      0 | (1UL << 0), /* bg/%r0/%r0/fR */
      0 | (1UL << 0), /* bg/%r0/%r1/fR */
      0 | (1UL << 1), /* bg/%r0/%rR/fR */
      0 | (1UL << 0), /* bg/%r0/n0/fR */
      0 | (1UL << 1), /* bg/%r0/nR/fR */
      0 | (1UL << 0), /* bg/%r1/%r0/fR */
      0 | (1UL << 0), /* bg/%r1/%r1/fR */
      0 | (1UL << 1), /* bg/%r1/%rR/fR */
      0 | (1UL << 0), /* bg/%r1/n0/fR */
      0 | (1UL << 1), /* bg/%r1/nR/fR */
      0 | (1UL << 1), /* bg/%rR/%r0/fR */
      0 | (1UL << 1), /* bg/%rR/%r1/fR */
      0 | (1UL << 2), /* bg/%rR/%rR/fR */
      0 | (1UL << 1), /* bg/%rR/n0/fR */
      0 | (1UL << 2), /* bg/%rR/nR/fR */
      0 | (1UL << 0), /* bg/n0/%r0/fR */
      0 | (1UL << 0), /* bg/n0/%r1/fR */
      0 | (1UL << 1), /* bg/n0/%rR/fR */
      0 | (1UL << 0), /* bg/n0/n0/fR */
      0 | (1UL << 1), /* bg/n0/nR/fR */
      0 | (1UL << 1), /* bg/nR/%r0/fR */
      0 | (1UL << 1), /* bg/nR/%r1/fR */
      0 | (1UL << 2), /* bg/nR/%rR/fR */
      0 | (1UL << 1), /* bg/nR/n0/fR */
      0 | (1UL << 2), /* bg/nR/nR/fR */
      0 | (1UL << 0), /* bge/%r0/%r0/fR */
      0 | (1UL << 0), /* bge/%r0/%r1/fR */
      0 | (1UL << 1), /* bge/%r0/%rR/fR */
      0 | (1UL << 0), /* bge/%r0/n0/fR */
      0 | (1UL << 1), /* bge/%r0/nR/fR */
      0 | (1UL << 0), /* bge/%r1/%r0/fR */
      0 | (1UL << 0), /* bge/%r1/%r1/fR */
      0 | (1UL << 1), /* bge/%r1/%rR/fR */
      0 | (1UL << 0), /* bge/%r1/n0/fR */
      0 | (1UL << 1), /* bge/%r1/nR/fR */
      0 | (1UL << 1), /* bge/%rR/%r0/fR */
      0 | (1UL << 1), /* bge/%rR/%r1/fR */
      0 | (1UL << 2), /* bge/%rR/%rR/fR */
      0 | (1UL << 1), /* bge/%rR/n0/fR */
      0 | (1UL << 2), /* bge/%rR/nR/fR */
      0 | (1UL << 0), /* bge/n0/%r0/fR */
      0 | (1UL << 0), /* bge/n0/%r1/fR */
      0 | (1UL << 1), /* bge/n0/%rR/fR */
      0 | (1UL << 0), /* bge/n0/n0/fR */
      0 | (1UL << 1), /* bge/n0/nR/fR */
      0 | (1UL << 1), /* bge/nR/%r0/fR */
      0 | (1UL << 1), /* bge/nR/%r1/fR */
      0 | (1UL << 2), /* bge/nR/%rR/fR */
      0 | (1UL << 1), /* bge/nR/n0/fR */
      0 | (1UL << 2), /* bge/nR/nR/fR */
      0 | (1UL << 0), /* bl/%r0/%r0/fR */
      0 | (1UL << 0), /* bl/%r0/%r1/fR */
      0 | (1UL << 1), /* bl/%r0/%rR/fR */
      0 | (1UL << 0), /* bl/%r0/n0/fR */
      0 | (1UL << 1), /* bl/%r0/nR/fR */
      0 | (1UL << 0), /* bl/%r1/%r0/fR */
      0 | (1UL << 0), /* bl/%r1/%r1/fR */
      0 | (1UL << 1), /* bl/%r1/%rR/fR */
      0 | (1UL << 0), /* bl/%r1/n0/fR */
      0 | (1UL << 1), /* bl/%r1/nR/fR */
      0 | (1UL << 1), /* bl/%rR/%r0/fR */
      0 | (1UL << 1), /* bl/%rR/%r1/fR */
      0 | (1UL << 2), /* bl/%rR/%rR/fR */
      0 | (1UL << 1), /* bl/%rR/n0/fR */
      0 | (1UL << 2), /* bl/%rR/nR/fR */
      0 | (1UL << 0), /* bl/n0/%r0/fR */
      0 | (1UL << 0), /* bl/n0/%r1/fR */
      0 | (1UL << 1), /* bl/n0/%rR/fR */
      0 | (1UL << 0), /* bl/n0/n0/fR */
      0 | (1UL << 1), /* bl/n0/nR/fR */
      0 | (1UL << 1), /* bl/nR/%r0/fR */
      0 | (1UL << 1), /* bl/nR/%r1/fR */
      0 | (1UL << 2), /* bl/nR/%rR/fR */
      0 | (1UL << 1), /* bl/nR/n0/fR */
      0 | (1UL << 2), /* bl/nR/nR/fR */
      0 | (1UL << 0), /* ble/%r0/%r0/fR */
      0 | (1UL << 0), /* ble/%r0/%r1/fR */
      0 | (1UL << 1), /* ble/%r0/%rR/fR */
      0 | (1UL << 0), /* ble/%r0/n0/fR */
      0 | (1UL << 1), /* ble/%r0/nR/fR */
      0 | (1UL << 0), /* ble/%r1/%r0/fR */
      0 | (1UL << 0), /* ble/%r1/%r1/fR */
      0 | (1UL << 1), /* ble/%r1/%rR/fR */
      0 | (1UL << 0), /* ble/%r1/n0/fR */
      0 | (1UL << 1), /* ble/%r1/nR/fR */
      0 | (1UL << 1), /* ble/%rR/%r0/fR */
      0 | (1UL << 1), /* ble/%rR/%r1/fR */
      0 | (1UL << 2), /* ble/%rR/%rR/fR */
      0 | (1UL << 1), /* ble/%rR/n0/fR */
      0 | (1UL << 2), /* ble/%rR/nR/fR */
      0 | (1UL << 0), /* ble/n0/%r0/fR */
      0 | (1UL << 0), /* ble/n0/%r1/fR */
      0 | (1UL << 1), /* ble/n0/%rR/fR */
      0 | (1UL << 0), /* ble/n0/n0/fR */
      0 | (1UL << 1), /* ble/n0/nR/fR */
      0 | (1UL << 1), /* ble/nR/%r0/fR */
      0 | (1UL << 1), /* ble/nR/%r1/fR */
      0 | (1UL << 2), /* ble/nR/%rR/fR */
      0 | (1UL << 1), /* ble/nR/n0/fR */
      0 | (1UL << 2), /* ble/nR/nR/fR */
      0 | (1UL << 0), /* bne/%r0/%r0/fR */
      0 | (1UL << 0), /* bne/%r0/%r1/fR */
      0 | (1UL << 1), /* bne/%r0/%rR/fR */
      0 | (1UL << 0), /* bne/%r0/n0/fR */
      0 | (1UL << 1), /* bne/%r0/nR/fR */
      0 | (1UL << 0), /* bne/%r1/%r0/fR */
      0 | (1UL << 0), /* bne/%r1/%r1/fR */
      0 | (1UL << 1), /* bne/%r1/%rR/fR */
      0 | (1UL << 0), /* bne/%r1/n0/fR */
      0 | (1UL << 1), /* bne/%r1/nR/fR */
      0 | (1UL << 1), /* bne/%rR/%r0/fR */
      0 | (1UL << 1), /* bne/%rR/%r1/fR */
      0 | (1UL << 2), /* bne/%rR/%rR/fR */
      0 | (1UL << 1), /* bne/%rR/n0/fR */
      0 | (1UL << 2), /* bne/%rR/nR/fR */
      0 | (1UL << 0), /* bne/n0/%r0/fR */
      0 | (1UL << 0), /* bne/n0/%r1/fR */
      0 | (1UL << 1), /* bne/n0/%rR/fR */
      0 | (1UL << 0), /* bne/n0/n0/fR */
      0 | (1UL << 1), /* bne/n0/nR/fR */
      0 | (1UL << 1), /* bne/nR/%r0/fR */
      0 | (1UL << 1), /* bne/nR/%r1/fR */
      0 | (1UL << 2), /* bne/nR/%rR/fR */
      0 | (1UL << 1), /* bne/nR/n0/fR */
      0 | (1UL << 2), /* bne/nR/nR/fR */
      0 | (1UL << 0), /* bneqi-stack/n-1/fR */
      0 | (1UL << 0), /* bneqi-stack/n0/fR */
      0 | (1UL << 0), /* bneqi-stack/n1/fR */
      0 | (1UL << 0), /* bneqi-stack/n2/fR */
      0 | (1UL << 1), /* bneqi-stack/nR/fR */
      0 | (1UL << 0), /* bt-stack/fR */
      0 | (1UL << 0), /* call/fR/retR */
      0, /* copy-to-r-stack/%r0 */
      0, /* copy-to-r-stack/%r1 */
      0, /* copy-to-r-stack/%rR */
      0, /* different-stack */
      0, /* divided/%r0/%r0/%r0/retR */
      0, /* divided/%r0/%r0/%r1/retR */
      0, /* divided/%r0/%r0/%rR/retR */
      0, /* divided/%r0/%r1/%r0/retR */
      0, /* divided/%r0/%r1/%r1/retR */
      0, /* divided/%r0/%r1/%rR/retR */
      0, /* divided/%r0/%rR/%r0/retR */
      0, /* divided/%r0/%rR/%r1/retR */
      0, /* divided/%r0/%rR/%rR/retR */
      0, /* divided/%r0/n2/%r0/retR */
      0, /* divided/%r0/n2/%r1/retR */
      0, /* divided/%r0/n2/%rR/retR */
      0, /* divided/%r0/nR/%r0/retR */
      0, /* divided/%r0/nR/%r1/retR */
      0, /* divided/%r0/nR/%rR/retR */
      0, /* divided/%r1/%r0/%r0/retR */
      0, /* divided/%r1/%r0/%r1/retR */
      0, /* divided/%r1/%r0/%rR/retR */
      0, /* divided/%r1/%r1/%r0/retR */
      0, /* divided/%r1/%r1/%r1/retR */
      0, /* divided/%r1/%r1/%rR/retR */
      0, /* divided/%r1/%rR/%r0/retR */
      0, /* divided/%r1/%rR/%r1/retR */
      0, /* divided/%r1/%rR/%rR/retR */
      0, /* divided/%r1/n2/%r0/retR */
      0, /* divided/%r1/n2/%r1/retR */
      0, /* divided/%r1/n2/%rR/retR */
      0, /* divided/%r1/nR/%r0/retR */
      0, /* divided/%r1/nR/%r1/retR */
      0, /* divided/%r1/nR/%rR/retR */
      0, /* divided/%rR/%r0/%r0/retR */
      0, /* divided/%rR/%r0/%r1/retR */
      0, /* divided/%rR/%r0/%rR/retR */
      0, /* divided/%rR/%r1/%r0/retR */
      0, /* divided/%rR/%r1/%r1/retR */
      0, /* divided/%rR/%r1/%rR/retR */
      0, /* divided/%rR/%rR/%r0/retR */
      0, /* divided/%rR/%rR/%r1/retR */
      0, /* divided/%rR/%rR/%rR/retR */
      0, /* divided/%rR/n2/%r0/retR */
      0, /* divided/%rR/n2/%r1/retR */
      0, /* divided/%rR/n2/%rR/retR */
      0, /* divided/%rR/nR/%r0/retR */
      0, /* divided/%rR/nR/%r1/retR */
      0, /* divided/%rR/nR/%rR/retR */
      0, /* divided/nR/%r0/%r0/retR */
      0, /* divided/nR/%r0/%r1/retR */
      0, /* divided/nR/%r0/%rR/retR */
      0, /* divided/nR/%r1/%r0/retR */
      0, /* divided/nR/%r1/%r1/retR */
      0, /* divided/nR/%r1/%rR/retR */
      0, /* divided/nR/%rR/%r0/retR */
      0, /* divided/nR/%rR/%r1/retR */
      0, /* divided/nR/%rR/%rR/retR */
      0, /* divided/nR/n2/%r0/retR */
      0, /* divided/nR/n2/%r1/retR */
      0, /* divided/nR/n2/%rR/retR */
      0, /* divided/nR/nR/%r0/retR */
      0, /* divided/nR/nR/%r1/retR */
      0, /* divided/nR/nR/%rR/retR */
      0, /* divided-stack/retR */
      0, /* drop-stack */
      0, /* dup-stack */
      0, /* equal-stack */
      0, /* equali-stack/n0 */
      0, /* equali-stack/n1 */
      0, /* equali-stack/n2 */
      0, /* equali-stack/nR */
      0, /* exitvm */
      0, /* greater-stack */
      0, /* greaterorequal-stack */
      0, /* input/%r0/retR */
      0, /* input/%r1/retR */
      0, /* input/%rR/retR */
      0, /* input-stack/retR */
      0, /* isnonzero-stack */
      0, /* less-stack */
      0, /* lessorequal-stack */
      0, /* load-boxed-literal/n0/%r0 */
      0, /* load-boxed-literal/n0/%r1 */
      0, /* load-boxed-literal/n0/%rR */
      0, /* load-boxed-literal/n1/%r0 */
      0, /* load-boxed-literal/n1/%r1 */
      0, /* load-boxed-literal/n1/%rR */
      0, /* load-boxed-literal/n2/%r0 */
      0, /* load-boxed-literal/n2/%r1 */
      0, /* load-boxed-literal/n2/%rR */
      0, /* load-boxed-literal/n3/%r0 */
      0, /* load-boxed-literal/n3/%r1 */
      0, /* load-boxed-literal/n3/%rR */
      0, /* load-boxed-literal/n4/%r0 */
      0, /* load-boxed-literal/n4/%r1 */
      0, /* load-boxed-literal/n4/%rR */
      0, /* load-boxed-literal/n5/%r0 */
      0, /* load-boxed-literal/n5/%r1 */
      0, /* load-boxed-literal/n5/%rR */
      0, /* load-boxed-literal/n6/%r0 */
      0, /* load-boxed-literal/n6/%r1 */
      0, /* load-boxed-literal/n6/%rR */
      0, /* load-boxed-literal/n7/%r0 */
      0, /* load-boxed-literal/n7/%r1 */
      0, /* load-boxed-literal/n7/%rR */
      0, /* load-boxed-literal/n8/%r0 */
      0, /* load-boxed-literal/n8/%r1 */
      0, /* load-boxed-literal/n8/%rR */
      0, /* load-boxed-literal/n9/%r0 */
      0, /* load-boxed-literal/n9/%r1 */
      0, /* load-boxed-literal/n9/%rR */
      0, /* load-boxed-literal/n10/%r0 */
      0, /* load-boxed-literal/n10/%r1 */
      0, /* load-boxed-literal/n10/%rR */
      0, /* load-boxed-literal/nR/%r0 */
      0, /* load-boxed-literal/nR/%r1 */
      0, /* load-boxed-literal/nR/%rR */
      0, /* logicaland-stack */
      0, /* logicalnot-stack */
      0, /* logicalor-stack */
      0, /* minus/%r0/%r0/%r0 */
      0, /* minus/%r0/%r0/%r1 */
      0, /* minus/%r0/%r0/%rR */
      0, /* minus/%r0/%r1/%r0 */
      0, /* minus/%r0/%r1/%r1 */
      0, /* minus/%r0/%r1/%rR */
      0, /* minus/%r0/%rR/%r0 */
      0, /* minus/%r0/%rR/%r1 */
      0, /* minus/%r0/%rR/%rR */
      0, /* minus/%r0/n1/%r0 */
      0, /* minus/%r0/n1/%r1 */
      0, /* minus/%r0/n1/%rR */
      0, /* minus/%r0/n2/%r0 */
      0, /* minus/%r0/n2/%r1 */
      0, /* minus/%r0/n2/%rR */
      0, /* minus/%r0/nR/%r0 */
      0, /* minus/%r0/nR/%r1 */
      0, /* minus/%r0/nR/%rR */
      0, /* minus/%r1/%r0/%r0 */
      0, /* minus/%r1/%r0/%r1 */
      0, /* minus/%r1/%r0/%rR */
      0, /* minus/%r1/%r1/%r0 */
      0, /* minus/%r1/%r1/%r1 */
      0, /* minus/%r1/%r1/%rR */
      0, /* minus/%r1/%rR/%r0 */
      0, /* minus/%r1/%rR/%r1 */
      0, /* minus/%r1/%rR/%rR */
      0, /* minus/%r1/n1/%r0 */
      0, /* minus/%r1/n1/%r1 */
      0, /* minus/%r1/n1/%rR */
      0, /* minus/%r1/n2/%r0 */
      0, /* minus/%r1/n2/%r1 */
      0, /* minus/%r1/n2/%rR */
      0, /* minus/%r1/nR/%r0 */
      0, /* minus/%r1/nR/%r1 */
      0, /* minus/%r1/nR/%rR */
      0, /* minus/%rR/%r0/%r0 */
      0, /* minus/%rR/%r0/%r1 */
      0, /* minus/%rR/%r0/%rR */
      0, /* minus/%rR/%r1/%r0 */
      0, /* minus/%rR/%r1/%r1 */
      0, /* minus/%rR/%r1/%rR */
      0, /* minus/%rR/%rR/%r0 */
      0, /* minus/%rR/%rR/%r1 */
      0, /* minus/%rR/%rR/%rR */
      0, /* minus/%rR/n1/%r0 */
      0, /* minus/%rR/n1/%r1 */
      0, /* minus/%rR/n1/%rR */
      0, /* minus/%rR/n2/%r0 */
      0, /* minus/%rR/n2/%r1 */
      0, /* minus/%rR/n2/%rR */
      0, /* minus/%rR/nR/%r0 */
      0, /* minus/%rR/nR/%r1 */
      0, /* minus/%rR/nR/%rR */
      0, /* minus/nR/%r0/%r0 */
      0, /* minus/nR/%r0/%r1 */
      0, /* minus/nR/%r0/%rR */
      0, /* minus/nR/%r1/%r0 */
      0, /* minus/nR/%r1/%r1 */
      0, /* minus/nR/%r1/%rR */
      0, /* minus/nR/%rR/%r0 */
      0, /* minus/nR/%rR/%r1 */
      0, /* minus/nR/%rR/%rR */
      0, /* minus/nR/n1/%r0 */
      0, /* minus/nR/n1/%r1 */
      0, /* minus/nR/n1/%rR */
      0, /* minus/nR/n2/%r0 */
      0, /* minus/nR/n2/%r1 */
      0, /* minus/nR/n2/%rR */
      0, /* minus/nR/nR/%r0 */
      0, /* minus/nR/nR/%r1 */
      0, /* minus/nR/nR/%rR */
      0, /* minus-stack */
      0, /* minusi-stack/n1 */
      0, /* minusi-stack/n2 */
      0, /* minusi-stack/nR */
      0, /* mov/%r0/%r0 */
      0, /* mov/%r0/%r1 */
      0, /* mov/%r0/%rR */
      0, /* mov/%r1/%r0 */
      0, /* mov/%r1/%r1 */
      0, /* mov/%r1/%rR */
      0, /* mov/%rR/%r0 */
      0, /* mov/%rR/%r1 */
      0, /* mov/%rR/%rR */
      0, /* mov/n0/%r0 */
      0, /* mov/n0/%r1 */
      0, /* mov/n0/%rR */
      0, /* mov/n1/%r0 */
      0, /* mov/n1/%r1 */
      0, /* mov/n1/%rR */
      0, /* mov/n-1/%r0 */
      0, /* mov/n-1/%r1 */
      0, /* mov/n-1/%rR */
      0, /* mov/n2/%r0 */
      0, /* mov/n2/%r1 */
      0, /* mov/n2/%rR */
      0, /* mov/nR/%r0 */
      0, /* mov/nR/%r1 */
      0, /* mov/nR/%rR */
      0, /* plus/%r0/%r0/%r0 */
      0, /* plus/%r0/%r0/%r1 */
      0, /* plus/%r0/%r0/%rR */
      0, /* plus/%r0/%r1/%r0 */
      0, /* plus/%r0/%r1/%r1 */
      0, /* plus/%r0/%r1/%rR */
      0, /* plus/%r0/%rR/%r0 */
      0, /* plus/%r0/%rR/%r1 */
      0, /* plus/%r0/%rR/%rR */
      0, /* plus/%r0/n1/%r0 */
      0, /* plus/%r0/n1/%r1 */
      0, /* plus/%r0/n1/%rR */
      0, /* plus/%r0/n2/%r0 */
      0, /* plus/%r0/n2/%r1 */
      0, /* plus/%r0/n2/%rR */
      0, /* plus/%r0/nR/%r0 */
      0, /* plus/%r0/nR/%r1 */
      0, /* plus/%r0/nR/%rR */
      0, /* plus/%r1/%r0/%r0 */
      0, /* plus/%r1/%r0/%r1 */
      0, /* plus/%r1/%r0/%rR */
      0, /* plus/%r1/%r1/%r0 */
      0, /* plus/%r1/%r1/%r1 */
      0, /* plus/%r1/%r1/%rR */
      0, /* plus/%r1/%rR/%r0 */
      0, /* plus/%r1/%rR/%r1 */
      0, /* plus/%r1/%rR/%rR */
      0, /* plus/%r1/n1/%r0 */
      0, /* plus/%r1/n1/%r1 */
      0, /* plus/%r1/n1/%rR */
      0, /* plus/%r1/n2/%r0 */
      0, /* plus/%r1/n2/%r1 */
      0, /* plus/%r1/n2/%rR */
      0, /* plus/%r1/nR/%r0 */
      0, /* plus/%r1/nR/%r1 */
      0, /* plus/%r1/nR/%rR */
      0, /* plus/%rR/%r0/%r0 */
      0, /* plus/%rR/%r0/%r1 */
      0, /* plus/%rR/%r0/%rR */
      0, /* plus/%rR/%r1/%r0 */
      0, /* plus/%rR/%r1/%r1 */
      0, /* plus/%rR/%r1/%rR */
      0, /* plus/%rR/%rR/%r0 */
      0, /* plus/%rR/%rR/%r1 */
      0, /* plus/%rR/%rR/%rR */
      0, /* plus/%rR/n1/%r0 */
      0, /* plus/%rR/n1/%r1 */
      0, /* plus/%rR/n1/%rR */
      0, /* plus/%rR/n2/%r0 */
      0, /* plus/%rR/n2/%r1 */
      0, /* plus/%rR/n2/%rR */
      0, /* plus/%rR/nR/%r0 */
      0, /* plus/%rR/nR/%r1 */
      0, /* plus/%rR/nR/%rR */
      0, /* plus/n1/%r0/%r0 */
      0, /* plus/n1/%r0/%r1 */
      0, /* plus/n1/%r0/%rR */
      0, /* plus/n1/%r1/%r0 */
      0, /* plus/n1/%r1/%r1 */
      0, /* plus/n1/%r1/%rR */
      0, /* plus/n1/%rR/%r0 */
      0, /* plus/n1/%rR/%r1 */
      0, /* plus/n1/%rR/%rR */
      0, /* plus/n1/n1/%r0 */
      0, /* plus/n1/n1/%r1 */
      0, /* plus/n1/n1/%rR */
      0, /* plus/n1/n2/%r0 */
      0, /* plus/n1/n2/%r1 */
      0, /* plus/n1/n2/%rR */
      0, /* plus/n1/nR/%r0 */
      0, /* plus/n1/nR/%r1 */
      0, /* plus/n1/nR/%rR */
      0, /* plus/n2/%r0/%r0 */
      0, /* plus/n2/%r0/%r1 */
      0, /* plus/n2/%r0/%rR */
      0, /* plus/n2/%r1/%r0 */
      0, /* plus/n2/%r1/%r1 */
      0, /* plus/n2/%r1/%rR */
      0, /* plus/n2/%rR/%r0 */
      0, /* plus/n2/%rR/%r1 */
      0, /* plus/n2/%rR/%rR */
      0, /* plus/n2/n1/%r0 */
      0, /* plus/n2/n1/%r1 */
      0, /* plus/n2/n1/%rR */
      0, /* plus/n2/n2/%r0 */
      0, /* plus/n2/n2/%r1 */
      0, /* plus/n2/n2/%rR */
      0, /* plus/n2/nR/%r0 */
      0, /* plus/n2/nR/%r1 */
      0, /* plus/n2/nR/%rR */
      0, /* plus/nR/%r0/%r0 */
      0, /* plus/nR/%r0/%r1 */
      0, /* plus/nR/%r0/%rR */
      0, /* plus/nR/%r1/%r0 */
      0, /* plus/nR/%r1/%r1 */
      0, /* plus/nR/%r1/%rR */
      0, /* plus/nR/%rR/%r0 */
      0, /* plus/nR/%rR/%r1 */
      0, /* plus/nR/%rR/%rR */
      0, /* plus/nR/n1/%r0 */
      0, /* plus/nR/n1/%r1 */
      0, /* plus/nR/n1/%rR */
      0, /* plus/nR/n2/%r0 */
      0, /* plus/nR/n2/%r1 */
      0, /* plus/nR/n2/%rR */
      0, /* plus/nR/nR/%r0 */
      0, /* plus/nR/nR/%r1 */
      0, /* plus/nR/nR/%rR */
      0, /* plus-stack */
      0, /* plusi-stack/n-1 */
      0, /* plusi-stack/n1 */
      0, /* plusi-stack/n2 */
      0, /* plusi-stack/nR */
      0, /* pop-stack/%r0 */
      0, /* pop-stack/%r1 */
      0, /* pop-stack/%rR */
      0, /* print/%r0/retR */
      0, /* print/%r1/retR */
      0, /* print/%rR/retR */
      0, /* print/nR/retR */
      0, /* print-stack/retR */
      0, /* procedure-prolog */
      0, /* push-boxed-literal/n0 */
      0, /* push-boxed-literal/n1 */
      0, /* push-boxed-literal/n2 */
      0, /* push-boxed-literal/n3 */
      0, /* push-boxed-literal/n4 */
      0, /* push-boxed-literal/n5 */
      0, /* push-boxed-literal/n6 */
      0, /* push-boxed-literal/n7 */
      0, /* push-boxed-literal/n8 */
      0, /* push-boxed-literal/n9 */
      0, /* push-boxed-literal/n10 */
      0, /* push-boxed-literal/nR */
      0, /* push-stack/%r0 */
      0, /* push-stack/%r1 */
      0, /* push-stack/%rR */
      0, /* push-stack/n0 */
      0, /* push-stack/n1 */
      0, /* push-stack/n-1 */
      0, /* push-stack/n2 */
      0, /* push-stack/nR */
      0, /* push-stack/lR */
      0, /* push-unspecified-stack */
      0, /* remainder/%r0/%r0/%r0/retR */
      0, /* remainder/%r0/%r0/%r1/retR */
      0, /* remainder/%r0/%r0/%rR/retR */
      0, /* remainder/%r0/%r1/%r0/retR */
      0, /* remainder/%r0/%r1/%r1/retR */
      0, /* remainder/%r0/%r1/%rR/retR */
      0, /* remainder/%r0/%rR/%r0/retR */
      0, /* remainder/%r0/%rR/%r1/retR */
      0, /* remainder/%r0/%rR/%rR/retR */
      0, /* remainder/%r0/n2/%r0/retR */
      0, /* remainder/%r0/n2/%r1/retR */
      0, /* remainder/%r0/n2/%rR/retR */
      0, /* remainder/%r0/nR/%r0/retR */
      0, /* remainder/%r0/nR/%r1/retR */
      0, /* remainder/%r0/nR/%rR/retR */
      0, /* remainder/%r1/%r0/%r0/retR */
      0, /* remainder/%r1/%r0/%r1/retR */
      0, /* remainder/%r1/%r0/%rR/retR */
      0, /* remainder/%r1/%r1/%r0/retR */
      0, /* remainder/%r1/%r1/%r1/retR */
      0, /* remainder/%r1/%r1/%rR/retR */
      0, /* remainder/%r1/%rR/%r0/retR */
      0, /* remainder/%r1/%rR/%r1/retR */
      0, /* remainder/%r1/%rR/%rR/retR */
      0, /* remainder/%r1/n2/%r0/retR */
      0, /* remainder/%r1/n2/%r1/retR */
      0, /* remainder/%r1/n2/%rR/retR */
      0, /* remainder/%r1/nR/%r0/retR */
      0, /* remainder/%r1/nR/%r1/retR */
      0, /* remainder/%r1/nR/%rR/retR */
      0, /* remainder/%rR/%r0/%r0/retR */
      0, /* remainder/%rR/%r0/%r1/retR */
      0, /* remainder/%rR/%r0/%rR/retR */
      0, /* remainder/%rR/%r1/%r0/retR */
      0, /* remainder/%rR/%r1/%r1/retR */
      0, /* remainder/%rR/%r1/%rR/retR */
      0, /* remainder/%rR/%rR/%r0/retR */
      0, /* remainder/%rR/%rR/%r1/retR */
      0, /* remainder/%rR/%rR/%rR/retR */
      0, /* remainder/%rR/n2/%r0/retR */
      0, /* remainder/%rR/n2/%r1/retR */
      0, /* remainder/%rR/n2/%rR/retR */
      0, /* remainder/%rR/nR/%r0/retR */
      0, /* remainder/%rR/nR/%r1/retR */
      0, /* remainder/%rR/nR/%rR/retR */
      0, /* remainder/nR/%r0/%r0/retR */
      0, /* remainder/nR/%r0/%r1/retR */
      0, /* remainder/nR/%r0/%rR/retR */
      0, /* remainder/nR/%r1/%r0/retR */
      0, /* remainder/nR/%r1/%r1/retR */
      0, /* remainder/nR/%r1/%rR/retR */
      0, /* remainder/nR/%rR/%r0/retR */
      0, /* remainder/nR/%rR/%r1/retR */
      0, /* remainder/nR/%rR/%rR/retR */
      0, /* remainder/nR/n2/%r0/retR */
      0, /* remainder/nR/n2/%r1/retR */
      0, /* remainder/nR/n2/%rR/retR */
      0, /* remainder/nR/nR/%r0/retR */
      0, /* remainder/nR/nR/%r1/retR */
      0, /* remainder/nR/nR/%rR/retR */
      0, /* remainder-stack/retR */
      0, /* return-to-undertop */
      0, /* swap-stack */
      0, /* times/%r0/%r0/%r0 */
      0, /* times/%r0/%r0/%r1 */
      0, /* times/%r0/%r0/%rR */
      0, /* times/%r0/%r1/%r0 */
      0, /* times/%r0/%r1/%r1 */
      0, /* times/%r0/%r1/%rR */
      0, /* times/%r0/%rR/%r0 */
      0, /* times/%r0/%rR/%r1 */
      0, /* times/%r0/%rR/%rR */
      0, /* times/%r0/n2/%r0 */
      0, /* times/%r0/n2/%r1 */
      0, /* times/%r0/n2/%rR */
      0, /* times/%r0/nR/%r0 */
      0, /* times/%r0/nR/%r1 */
      0, /* times/%r0/nR/%rR */
      0, /* times/%r1/%r0/%r0 */
      0, /* times/%r1/%r0/%r1 */
      0, /* times/%r1/%r0/%rR */
      0, /* times/%r1/%r1/%r0 */
      0, /* times/%r1/%r1/%r1 */
      0, /* times/%r1/%r1/%rR */
      0, /* times/%r1/%rR/%r0 */
      0, /* times/%r1/%rR/%r1 */
      0, /* times/%r1/%rR/%rR */
      0, /* times/%r1/n2/%r0 */
      0, /* times/%r1/n2/%r1 */
      0, /* times/%r1/n2/%rR */
      0, /* times/%r1/nR/%r0 */
      0, /* times/%r1/nR/%r1 */
      0, /* times/%r1/nR/%rR */
      0, /* times/%rR/%r0/%r0 */
      0, /* times/%rR/%r0/%r1 */
      0, /* times/%rR/%r0/%rR */
      0, /* times/%rR/%r1/%r0 */
      0, /* times/%rR/%r1/%r1 */
      0, /* times/%rR/%r1/%rR */
      0, /* times/%rR/%rR/%r0 */
      0, /* times/%rR/%rR/%r1 */
      0, /* times/%rR/%rR/%rR */
      0, /* times/%rR/n2/%r0 */
      0, /* times/%rR/n2/%r1 */
      0, /* times/%rR/n2/%rR */
      0, /* times/%rR/nR/%r0 */
      0, /* times/%rR/nR/%r1 */
      0, /* times/%rR/nR/%rR */
      0, /* times/nR/%r0/%r0 */
      0, /* times/nR/%r0/%r1 */
      0, /* times/nR/%r0/%rR */
      0, /* times/nR/%r1/%r0 */
      0, /* times/nR/%r1/%r1 */
      0, /* times/nR/%r1/%rR */
      0, /* times/nR/%rR/%r0 */
      0, /* times/nR/%rR/%r1 */
      0, /* times/nR/%rR/%rR */
      0, /* times/nR/n2/%r0 */
      0, /* times/nR/n2/%r1 */
      0, /* times/nR/n2/%rR */
      0, /* times/nR/nR/%r0 */
      0, /* times/nR/nR/%r1 */
      0, /* times/nR/nR/%rR */
      0, /* times-stack */
      0, /* uminus/%r0/%r0 */
      0, /* uminus/%r0/%r1 */
      0, /* uminus/%r0/%rR */
      0, /* uminus/%r1/%r0 */
      0, /* uminus/%r1/%r1 */
      0, /* uminus/%r1/%rR */
      0, /* uminus/%rR/%r0 */
      0, /* uminus/%rR/%r1 */
      0, /* uminus/%rR/%rR */
      0, /* uminus/nR/%r0 */
      0, /* uminus/nR/%r1 */
      0, /* uminus/nR/%rR */
      0, /* uminus-stack */
      0, /* underpop-stack/%r0 */
      0, /* underpop-stack/%r1 */
      0, /* underpop-stack/%rR */
      0, /* underpush-stack/%r0 */
      0, /* underpush-stack/%r1 */
      0, /* underpush-stack/%rR */
      0, /* underpush-stack/nR */
      0, /* unreachable */
      0, /* !REPLACEMENT-b/fR/retR */
      0, /* !REPLACEMENT-be/%r0/%r0/fR/retR */
      0, /* !REPLACEMENT-be/%r0/%r1/fR/retR */
      0, /* !REPLACEMENT-be/%r0/%rR/fR/retR */
      0, /* !REPLACEMENT-be/%r0/n0/fR/retR */
      0, /* !REPLACEMENT-be/%r0/nR/fR/retR */
      0, /* !REPLACEMENT-be/%r1/%r0/fR/retR */
      0, /* !REPLACEMENT-be/%r1/%r1/fR/retR */
      0, /* !REPLACEMENT-be/%r1/%rR/fR/retR */
      0, /* !REPLACEMENT-be/%r1/n0/fR/retR */
      0, /* !REPLACEMENT-be/%r1/nR/fR/retR */
      0, /* !REPLACEMENT-be/%rR/%r0/fR/retR */
      0, /* !REPLACEMENT-be/%rR/%r1/fR/retR */
      0, /* !REPLACEMENT-be/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-be/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-be/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-be/n0/%r0/fR/retR */
      0, /* !REPLACEMENT-be/n0/%r1/fR/retR */
      0, /* !REPLACEMENT-be/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-be/n0/n0/fR/retR */
      0, /* !REPLACEMENT-be/n0/nR/fR/retR */
      0, /* !REPLACEMENT-be/nR/%r0/fR/retR */
      0, /* !REPLACEMENT-be/nR/%r1/fR/retR */
      0, /* !REPLACEMENT-be/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-be/nR/n0/fR/retR */
      0, /* !REPLACEMENT-be/nR/nR/fR/retR */
      0, /* !REPLACEMENT-beqi-stack/n-1/fR/retR */
      0, /* !REPLACEMENT-beqi-stack/n0/fR/retR */
      0, /* !REPLACEMENT-beqi-stack/n1/fR/retR */
      0, /* !REPLACEMENT-beqi-stack/n2/fR/retR */
      0, /* !REPLACEMENT-beqi-stack/nR/fR/retR */
      0, /* !REPLACEMENT-bf-stack/fR/retR */
      0, /* !REPLACEMENT-bg/%r0/%r0/fR/retR */
      0, /* !REPLACEMENT-bg/%r0/%r1/fR/retR */
      0, /* !REPLACEMENT-bg/%r0/%rR/fR/retR */
      0, /* !REPLACEMENT-bg/%r0/n0/fR/retR */
      0, /* !REPLACEMENT-bg/%r0/nR/fR/retR */
      0, /* !REPLACEMENT-bg/%r1/%r0/fR/retR */
      0, /* !REPLACEMENT-bg/%r1/%r1/fR/retR */
      0, /* !REPLACEMENT-bg/%r1/%rR/fR/retR */
      0, /* !REPLACEMENT-bg/%r1/n0/fR/retR */
      0, /* !REPLACEMENT-bg/%r1/nR/fR/retR */
      0, /* !REPLACEMENT-bg/%rR/%r0/fR/retR */
      0, /* !REPLACEMENT-bg/%rR/%r1/fR/retR */
      0, /* !REPLACEMENT-bg/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-bg/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-bg/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-bg/n0/%r0/fR/retR */
      0, /* !REPLACEMENT-bg/n0/%r1/fR/retR */
      0, /* !REPLACEMENT-bg/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-bg/n0/n0/fR/retR */
      0, /* !REPLACEMENT-bg/n0/nR/fR/retR */
      0, /* !REPLACEMENT-bg/nR/%r0/fR/retR */
      0, /* !REPLACEMENT-bg/nR/%r1/fR/retR */
      0, /* !REPLACEMENT-bg/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-bg/nR/n0/fR/retR */
      0, /* !REPLACEMENT-bg/nR/nR/fR/retR */
      0, /* !REPLACEMENT-bge/%r0/%r0/fR/retR */
      0, /* !REPLACEMENT-bge/%r0/%r1/fR/retR */
      0, /* !REPLACEMENT-bge/%r0/%rR/fR/retR */
      0, /* !REPLACEMENT-bge/%r0/n0/fR/retR */
      0, /* !REPLACEMENT-bge/%r0/nR/fR/retR */
      0, /* !REPLACEMENT-bge/%r1/%r0/fR/retR */
      0, /* !REPLACEMENT-bge/%r1/%r1/fR/retR */
      0, /* !REPLACEMENT-bge/%r1/%rR/fR/retR */
      0, /* !REPLACEMENT-bge/%r1/n0/fR/retR */
      0, /* !REPLACEMENT-bge/%r1/nR/fR/retR */
      0, /* !REPLACEMENT-bge/%rR/%r0/fR/retR */
      0, /* !REPLACEMENT-bge/%rR/%r1/fR/retR */
      0, /* !REPLACEMENT-bge/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-bge/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-bge/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-bge/n0/%r0/fR/retR */
      0, /* !REPLACEMENT-bge/n0/%r1/fR/retR */
      0, /* !REPLACEMENT-bge/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-bge/n0/n0/fR/retR */
      0, /* !REPLACEMENT-bge/n0/nR/fR/retR */
      0, /* !REPLACEMENT-bge/nR/%r0/fR/retR */
      0, /* !REPLACEMENT-bge/nR/%r1/fR/retR */
      0, /* !REPLACEMENT-bge/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-bge/nR/n0/fR/retR */
      0, /* !REPLACEMENT-bge/nR/nR/fR/retR */
      0, /* !REPLACEMENT-bl/%r0/%r0/fR/retR */
      0, /* !REPLACEMENT-bl/%r0/%r1/fR/retR */
      0, /* !REPLACEMENT-bl/%r0/%rR/fR/retR */
      0, /* !REPLACEMENT-bl/%r0/n0/fR/retR */
      0, /* !REPLACEMENT-bl/%r0/nR/fR/retR */
      0, /* !REPLACEMENT-bl/%r1/%r0/fR/retR */
      0, /* !REPLACEMENT-bl/%r1/%r1/fR/retR */
      0, /* !REPLACEMENT-bl/%r1/%rR/fR/retR */
      0, /* !REPLACEMENT-bl/%r1/n0/fR/retR */
      0, /* !REPLACEMENT-bl/%r1/nR/fR/retR */
      0, /* !REPLACEMENT-bl/%rR/%r0/fR/retR */
      0, /* !REPLACEMENT-bl/%rR/%r1/fR/retR */
      0, /* !REPLACEMENT-bl/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-bl/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-bl/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-bl/n0/%r0/fR/retR */
      0, /* !REPLACEMENT-bl/n0/%r1/fR/retR */
      0, /* !REPLACEMENT-bl/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-bl/n0/n0/fR/retR */
      0, /* !REPLACEMENT-bl/n0/nR/fR/retR */
      0, /* !REPLACEMENT-bl/nR/%r0/fR/retR */
      0, /* !REPLACEMENT-bl/nR/%r1/fR/retR */
      0, /* !REPLACEMENT-bl/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-bl/nR/n0/fR/retR */
      0, /* !REPLACEMENT-bl/nR/nR/fR/retR */
      0, /* !REPLACEMENT-ble/%r0/%r0/fR/retR */
      0, /* !REPLACEMENT-ble/%r0/%r1/fR/retR */
      0, /* !REPLACEMENT-ble/%r0/%rR/fR/retR */
      0, /* !REPLACEMENT-ble/%r0/n0/fR/retR */
      0, /* !REPLACEMENT-ble/%r0/nR/fR/retR */
      0, /* !REPLACEMENT-ble/%r1/%r0/fR/retR */
      0, /* !REPLACEMENT-ble/%r1/%r1/fR/retR */
      0, /* !REPLACEMENT-ble/%r1/%rR/fR/retR */
      0, /* !REPLACEMENT-ble/%r1/n0/fR/retR */
      0, /* !REPLACEMENT-ble/%r1/nR/fR/retR */
      0, /* !REPLACEMENT-ble/%rR/%r0/fR/retR */
      0, /* !REPLACEMENT-ble/%rR/%r1/fR/retR */
      0, /* !REPLACEMENT-ble/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-ble/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-ble/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-ble/n0/%r0/fR/retR */
      0, /* !REPLACEMENT-ble/n0/%r1/fR/retR */
      0, /* !REPLACEMENT-ble/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-ble/n0/n0/fR/retR */
      0, /* !REPLACEMENT-ble/n0/nR/fR/retR */
      0, /* !REPLACEMENT-ble/nR/%r0/fR/retR */
      0, /* !REPLACEMENT-ble/nR/%r1/fR/retR */
      0, /* !REPLACEMENT-ble/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-ble/nR/n0/fR/retR */
      0, /* !REPLACEMENT-ble/nR/nR/fR/retR */
      0, /* !REPLACEMENT-bne/%r0/%r0/fR/retR */
      0, /* !REPLACEMENT-bne/%r0/%r1/fR/retR */
      0, /* !REPLACEMENT-bne/%r0/%rR/fR/retR */
      0, /* !REPLACEMENT-bne/%r0/n0/fR/retR */
      0, /* !REPLACEMENT-bne/%r0/nR/fR/retR */
      0, /* !REPLACEMENT-bne/%r1/%r0/fR/retR */
      0, /* !REPLACEMENT-bne/%r1/%r1/fR/retR */
      0, /* !REPLACEMENT-bne/%r1/%rR/fR/retR */
      0, /* !REPLACEMENT-bne/%r1/n0/fR/retR */
      0, /* !REPLACEMENT-bne/%r1/nR/fR/retR */
      0, /* !REPLACEMENT-bne/%rR/%r0/fR/retR */
      0, /* !REPLACEMENT-bne/%rR/%r1/fR/retR */
      0, /* !REPLACEMENT-bne/%rR/%rR/fR/retR */
      0, /* !REPLACEMENT-bne/%rR/n0/fR/retR */
      0, /* !REPLACEMENT-bne/%rR/nR/fR/retR */
      0, /* !REPLACEMENT-bne/n0/%r0/fR/retR */
      0, /* !REPLACEMENT-bne/n0/%r1/fR/retR */
      0, /* !REPLACEMENT-bne/n0/%rR/fR/retR */
      0, /* !REPLACEMENT-bne/n0/n0/fR/retR */
      0, /* !REPLACEMENT-bne/n0/nR/fR/retR */
      0, /* !REPLACEMENT-bne/nR/%r0/fR/retR */
      0, /* !REPLACEMENT-bne/nR/%r1/fR/retR */
      0, /* !REPLACEMENT-bne/nR/%rR/fR/retR */
      0, /* !REPLACEMENT-bne/nR/n0/fR/retR */
      0, /* !REPLACEMENT-bne/nR/nR/fR/retR */
      0, /* !REPLACEMENT-bneqi-stack/n-1/fR/retR */
      0, /* !REPLACEMENT-bneqi-stack/n0/fR/retR */
      0, /* !REPLACEMENT-bneqi-stack/n1/fR/retR */
      0, /* !REPLACEMENT-bneqi-stack/n2/fR/retR */
      0, /* !REPLACEMENT-bneqi-stack/nR/fR/retR */
      0, /* !REPLACEMENT-bt-stack/fR/retR */
      0, /* !REPLACEMENT-call/fR/retR */
      0, /* !REPLACEMENT-exitvm/retR */
      0, /* !REPLACEMENT-procedure-prolog/retR */
      0, /* !REPLACEMENT-return-to-undertop/retR */
      0 /* !REPLACEMENT-unreachable/retR */
    };
#endif // #ifdef JITTER_HAVE_PATCH_IN

// FIXME: I may want to conditionalize this.
const bool
structuredvm_specialized_instruction_relocatables [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
      true, // !INVALID
      true, // !BEGINBASICBLOCK
      true, // !EXITVM
      true, // !DATALOCATIONS
      true, // !NOP
      true, // !UNREACHABLE0
      true, // !UNREACHABLE1
      true, // !PRETENDTOJUMPANYWHERE
      true, // b/fR
      true, // be/%r0/%r0/fR
      true, // be/%r0/%r1/fR
      true, // be/%r0/%rR/fR
      true, // be/%r0/n0/fR
      true, // be/%r0/nR/fR
      true, // be/%r1/%r0/fR
      true, // be/%r1/%r1/fR
      true, // be/%r1/%rR/fR
      true, // be/%r1/n0/fR
      true, // be/%r1/nR/fR
      true, // be/%rR/%r0/fR
      true, // be/%rR/%r1/fR
      true, // be/%rR/%rR/fR
      true, // be/%rR/n0/fR
      true, // be/%rR/nR/fR
      true, // be/n0/%r0/fR
      true, // be/n0/%r1/fR
      true, // be/n0/%rR/fR
      true, // be/n0/n0/fR
      true, // be/n0/nR/fR
      true, // be/nR/%r0/fR
      true, // be/nR/%r1/fR
      true, // be/nR/%rR/fR
      true, // be/nR/n0/fR
      true, // be/nR/nR/fR
      true, // beqi-stack/n-1/fR
      true, // beqi-stack/n0/fR
      true, // beqi-stack/n1/fR
      true, // beqi-stack/n2/fR
      true, // beqi-stack/nR/fR
      true, // bf-stack/fR
      true, // bg/%r0/%r0/fR
      true, // bg/%r0/%r1/fR
      true, // bg/%r0/%rR/fR
      true, // bg/%r0/n0/fR
      true, // bg/%r0/nR/fR
      true, // bg/%r1/%r0/fR
      true, // bg/%r1/%r1/fR
      true, // bg/%r1/%rR/fR
      true, // bg/%r1/n0/fR
      true, // bg/%r1/nR/fR
      true, // bg/%rR/%r0/fR
      true, // bg/%rR/%r1/fR
      true, // bg/%rR/%rR/fR
      true, // bg/%rR/n0/fR
      true, // bg/%rR/nR/fR
      true, // bg/n0/%r0/fR
      true, // bg/n0/%r1/fR
      true, // bg/n0/%rR/fR
      true, // bg/n0/n0/fR
      true, // bg/n0/nR/fR
      true, // bg/nR/%r0/fR
      true, // bg/nR/%r1/fR
      true, // bg/nR/%rR/fR
      true, // bg/nR/n0/fR
      true, // bg/nR/nR/fR
      true, // bge/%r0/%r0/fR
      true, // bge/%r0/%r1/fR
      true, // bge/%r0/%rR/fR
      true, // bge/%r0/n0/fR
      true, // bge/%r0/nR/fR
      true, // bge/%r1/%r0/fR
      true, // bge/%r1/%r1/fR
      true, // bge/%r1/%rR/fR
      true, // bge/%r1/n0/fR
      true, // bge/%r1/nR/fR
      true, // bge/%rR/%r0/fR
      true, // bge/%rR/%r1/fR
      true, // bge/%rR/%rR/fR
      true, // bge/%rR/n0/fR
      true, // bge/%rR/nR/fR
      true, // bge/n0/%r0/fR
      true, // bge/n0/%r1/fR
      true, // bge/n0/%rR/fR
      true, // bge/n0/n0/fR
      true, // bge/n0/nR/fR
      true, // bge/nR/%r0/fR
      true, // bge/nR/%r1/fR
      true, // bge/nR/%rR/fR
      true, // bge/nR/n0/fR
      true, // bge/nR/nR/fR
      true, // bl/%r0/%r0/fR
      true, // bl/%r0/%r1/fR
      true, // bl/%r0/%rR/fR
      true, // bl/%r0/n0/fR
      true, // bl/%r0/nR/fR
      true, // bl/%r1/%r0/fR
      true, // bl/%r1/%r1/fR
      true, // bl/%r1/%rR/fR
      true, // bl/%r1/n0/fR
      true, // bl/%r1/nR/fR
      true, // bl/%rR/%r0/fR
      true, // bl/%rR/%r1/fR
      true, // bl/%rR/%rR/fR
      true, // bl/%rR/n0/fR
      true, // bl/%rR/nR/fR
      true, // bl/n0/%r0/fR
      true, // bl/n0/%r1/fR
      true, // bl/n0/%rR/fR
      true, // bl/n0/n0/fR
      true, // bl/n0/nR/fR
      true, // bl/nR/%r0/fR
      true, // bl/nR/%r1/fR
      true, // bl/nR/%rR/fR
      true, // bl/nR/n0/fR
      true, // bl/nR/nR/fR
      true, // ble/%r0/%r0/fR
      true, // ble/%r0/%r1/fR
      true, // ble/%r0/%rR/fR
      true, // ble/%r0/n0/fR
      true, // ble/%r0/nR/fR
      true, // ble/%r1/%r0/fR
      true, // ble/%r1/%r1/fR
      true, // ble/%r1/%rR/fR
      true, // ble/%r1/n0/fR
      true, // ble/%r1/nR/fR
      true, // ble/%rR/%r0/fR
      true, // ble/%rR/%r1/fR
      true, // ble/%rR/%rR/fR
      true, // ble/%rR/n0/fR
      true, // ble/%rR/nR/fR
      true, // ble/n0/%r0/fR
      true, // ble/n0/%r1/fR
      true, // ble/n0/%rR/fR
      true, // ble/n0/n0/fR
      true, // ble/n0/nR/fR
      true, // ble/nR/%r0/fR
      true, // ble/nR/%r1/fR
      true, // ble/nR/%rR/fR
      true, // ble/nR/n0/fR
      true, // ble/nR/nR/fR
      true, // bne/%r0/%r0/fR
      true, // bne/%r0/%r1/fR
      true, // bne/%r0/%rR/fR
      true, // bne/%r0/n0/fR
      true, // bne/%r0/nR/fR
      true, // bne/%r1/%r0/fR
      true, // bne/%r1/%r1/fR
      true, // bne/%r1/%rR/fR
      true, // bne/%r1/n0/fR
      true, // bne/%r1/nR/fR
      true, // bne/%rR/%r0/fR
      true, // bne/%rR/%r1/fR
      true, // bne/%rR/%rR/fR
      true, // bne/%rR/n0/fR
      true, // bne/%rR/nR/fR
      true, // bne/n0/%r0/fR
      true, // bne/n0/%r1/fR
      true, // bne/n0/%rR/fR
      true, // bne/n0/n0/fR
      true, // bne/n0/nR/fR
      true, // bne/nR/%r0/fR
      true, // bne/nR/%r1/fR
      true, // bne/nR/%rR/fR
      true, // bne/nR/n0/fR
      true, // bne/nR/nR/fR
      true, // bneqi-stack/n-1/fR
      true, // bneqi-stack/n0/fR
      true, // bneqi-stack/n1/fR
      true, // bneqi-stack/n2/fR
      true, // bneqi-stack/nR/fR
      true, // bt-stack/fR
      true, // call/fR/retR
      true, // copy-to-r-stack/%r0
      true, // copy-to-r-stack/%r1
      true, // copy-to-r-stack/%rR
      true, // different-stack
      false, // divided/%r0/%r0/%r0/retR
      false, // divided/%r0/%r0/%r1/retR
      false, // divided/%r0/%r0/%rR/retR
      false, // divided/%r0/%r1/%r0/retR
      false, // divided/%r0/%r1/%r1/retR
      false, // divided/%r0/%r1/%rR/retR
      false, // divided/%r0/%rR/%r0/retR
      false, // divided/%r0/%rR/%r1/retR
      false, // divided/%r0/%rR/%rR/retR
      false, // divided/%r0/n2/%r0/retR
      false, // divided/%r0/n2/%r1/retR
      false, // divided/%r0/n2/%rR/retR
      false, // divided/%r0/nR/%r0/retR
      false, // divided/%r0/nR/%r1/retR
      false, // divided/%r0/nR/%rR/retR
      false, // divided/%r1/%r0/%r0/retR
      false, // divided/%r1/%r0/%r1/retR
      false, // divided/%r1/%r0/%rR/retR
      false, // divided/%r1/%r1/%r0/retR
      false, // divided/%r1/%r1/%r1/retR
      false, // divided/%r1/%r1/%rR/retR
      false, // divided/%r1/%rR/%r0/retR
      false, // divided/%r1/%rR/%r1/retR
      false, // divided/%r1/%rR/%rR/retR
      false, // divided/%r1/n2/%r0/retR
      false, // divided/%r1/n2/%r1/retR
      false, // divided/%r1/n2/%rR/retR
      false, // divided/%r1/nR/%r0/retR
      false, // divided/%r1/nR/%r1/retR
      false, // divided/%r1/nR/%rR/retR
      false, // divided/%rR/%r0/%r0/retR
      false, // divided/%rR/%r0/%r1/retR
      false, // divided/%rR/%r0/%rR/retR
      false, // divided/%rR/%r1/%r0/retR
      false, // divided/%rR/%r1/%r1/retR
      false, // divided/%rR/%r1/%rR/retR
      false, // divided/%rR/%rR/%r0/retR
      false, // divided/%rR/%rR/%r1/retR
      false, // divided/%rR/%rR/%rR/retR
      false, // divided/%rR/n2/%r0/retR
      false, // divided/%rR/n2/%r1/retR
      false, // divided/%rR/n2/%rR/retR
      false, // divided/%rR/nR/%r0/retR
      false, // divided/%rR/nR/%r1/retR
      false, // divided/%rR/nR/%rR/retR
      false, // divided/nR/%r0/%r0/retR
      false, // divided/nR/%r0/%r1/retR
      false, // divided/nR/%r0/%rR/retR
      false, // divided/nR/%r1/%r0/retR
      false, // divided/nR/%r1/%r1/retR
      false, // divided/nR/%r1/%rR/retR
      false, // divided/nR/%rR/%r0/retR
      false, // divided/nR/%rR/%r1/retR
      false, // divided/nR/%rR/%rR/retR
      false, // divided/nR/n2/%r0/retR
      false, // divided/nR/n2/%r1/retR
      false, // divided/nR/n2/%rR/retR
      false, // divided/nR/nR/%r0/retR
      false, // divided/nR/nR/%r1/retR
      false, // divided/nR/nR/%rR/retR
      false, // divided-stack/retR
      true, // drop-stack
      true, // dup-stack
      true, // equal-stack
      true, // equali-stack/n0
      true, // equali-stack/n1
      true, // equali-stack/n2
      true, // equali-stack/nR
      true, // exitvm
      true, // greater-stack
      true, // greaterorequal-stack
      false, // input/%r0/retR
      false, // input/%r1/retR
      false, // input/%rR/retR
      false, // input-stack/retR
      true, // isnonzero-stack
      true, // less-stack
      true, // lessorequal-stack
      true, // load-boxed-literal/n0/%r0
      true, // load-boxed-literal/n0/%r1
      true, // load-boxed-literal/n0/%rR
      true, // load-boxed-literal/n1/%r0
      true, // load-boxed-literal/n1/%r1
      true, // load-boxed-literal/n1/%rR
      true, // load-boxed-literal/n2/%r0
      true, // load-boxed-literal/n2/%r1
      true, // load-boxed-literal/n2/%rR
      true, // load-boxed-literal/n3/%r0
      true, // load-boxed-literal/n3/%r1
      true, // load-boxed-literal/n3/%rR
      true, // load-boxed-literal/n4/%r0
      true, // load-boxed-literal/n4/%r1
      true, // load-boxed-literal/n4/%rR
      true, // load-boxed-literal/n5/%r0
      true, // load-boxed-literal/n5/%r1
      true, // load-boxed-literal/n5/%rR
      true, // load-boxed-literal/n6/%r0
      true, // load-boxed-literal/n6/%r1
      true, // load-boxed-literal/n6/%rR
      true, // load-boxed-literal/n7/%r0
      true, // load-boxed-literal/n7/%r1
      true, // load-boxed-literal/n7/%rR
      true, // load-boxed-literal/n8/%r0
      true, // load-boxed-literal/n8/%r1
      true, // load-boxed-literal/n8/%rR
      true, // load-boxed-literal/n9/%r0
      true, // load-boxed-literal/n9/%r1
      true, // load-boxed-literal/n9/%rR
      true, // load-boxed-literal/n10/%r0
      true, // load-boxed-literal/n10/%r1
      true, // load-boxed-literal/n10/%rR
      true, // load-boxed-literal/nR/%r0
      true, // load-boxed-literal/nR/%r1
      true, // load-boxed-literal/nR/%rR
      true, // logicaland-stack
      true, // logicalnot-stack
      true, // logicalor-stack
      true, // minus/%r0/%r0/%r0
      true, // minus/%r0/%r0/%r1
      true, // minus/%r0/%r0/%rR
      true, // minus/%r0/%r1/%r0
      true, // minus/%r0/%r1/%r1
      true, // minus/%r0/%r1/%rR
      true, // minus/%r0/%rR/%r0
      true, // minus/%r0/%rR/%r1
      true, // minus/%r0/%rR/%rR
      true, // minus/%r0/n1/%r0
      true, // minus/%r0/n1/%r1
      true, // minus/%r0/n1/%rR
      true, // minus/%r0/n2/%r0
      true, // minus/%r0/n2/%r1
      true, // minus/%r0/n2/%rR
      true, // minus/%r0/nR/%r0
      true, // minus/%r0/nR/%r1
      true, // minus/%r0/nR/%rR
      true, // minus/%r1/%r0/%r0
      true, // minus/%r1/%r0/%r1
      true, // minus/%r1/%r0/%rR
      true, // minus/%r1/%r1/%r0
      true, // minus/%r1/%r1/%r1
      true, // minus/%r1/%r1/%rR
      true, // minus/%r1/%rR/%r0
      true, // minus/%r1/%rR/%r1
      true, // minus/%r1/%rR/%rR
      true, // minus/%r1/n1/%r0
      true, // minus/%r1/n1/%r1
      true, // minus/%r1/n1/%rR
      true, // minus/%r1/n2/%r0
      true, // minus/%r1/n2/%r1
      true, // minus/%r1/n2/%rR
      true, // minus/%r1/nR/%r0
      true, // minus/%r1/nR/%r1
      true, // minus/%r1/nR/%rR
      true, // minus/%rR/%r0/%r0
      true, // minus/%rR/%r0/%r1
      true, // minus/%rR/%r0/%rR
      true, // minus/%rR/%r1/%r0
      true, // minus/%rR/%r1/%r1
      true, // minus/%rR/%r1/%rR
      true, // minus/%rR/%rR/%r0
      true, // minus/%rR/%rR/%r1
      true, // minus/%rR/%rR/%rR
      true, // minus/%rR/n1/%r0
      true, // minus/%rR/n1/%r1
      true, // minus/%rR/n1/%rR
      true, // minus/%rR/n2/%r0
      true, // minus/%rR/n2/%r1
      true, // minus/%rR/n2/%rR
      true, // minus/%rR/nR/%r0
      true, // minus/%rR/nR/%r1
      true, // minus/%rR/nR/%rR
      true, // minus/nR/%r0/%r0
      true, // minus/nR/%r0/%r1
      true, // minus/nR/%r0/%rR
      true, // minus/nR/%r1/%r0
      true, // minus/nR/%r1/%r1
      true, // minus/nR/%r1/%rR
      true, // minus/nR/%rR/%r0
      true, // minus/nR/%rR/%r1
      true, // minus/nR/%rR/%rR
      true, // minus/nR/n1/%r0
      true, // minus/nR/n1/%r1
      true, // minus/nR/n1/%rR
      true, // minus/nR/n2/%r0
      true, // minus/nR/n2/%r1
      true, // minus/nR/n2/%rR
      true, // minus/nR/nR/%r0
      true, // minus/nR/nR/%r1
      true, // minus/nR/nR/%rR
      true, // minus-stack
      true, // minusi-stack/n1
      true, // minusi-stack/n2
      true, // minusi-stack/nR
      true, // mov/%r0/%r0
      true, // mov/%r0/%r1
      true, // mov/%r0/%rR
      true, // mov/%r1/%r0
      true, // mov/%r1/%r1
      true, // mov/%r1/%rR
      true, // mov/%rR/%r0
      true, // mov/%rR/%r1
      true, // mov/%rR/%rR
      true, // mov/n0/%r0
      true, // mov/n0/%r1
      true, // mov/n0/%rR
      true, // mov/n1/%r0
      true, // mov/n1/%r1
      true, // mov/n1/%rR
      true, // mov/n-1/%r0
      true, // mov/n-1/%r1
      true, // mov/n-1/%rR
      true, // mov/n2/%r0
      true, // mov/n2/%r1
      true, // mov/n2/%rR
      true, // mov/nR/%r0
      true, // mov/nR/%r1
      true, // mov/nR/%rR
      true, // plus/%r0/%r0/%r0
      true, // plus/%r0/%r0/%r1
      true, // plus/%r0/%r0/%rR
      true, // plus/%r0/%r1/%r0
      true, // plus/%r0/%r1/%r1
      true, // plus/%r0/%r1/%rR
      true, // plus/%r0/%rR/%r0
      true, // plus/%r0/%rR/%r1
      true, // plus/%r0/%rR/%rR
      true, // plus/%r0/n1/%r0
      true, // plus/%r0/n1/%r1
      true, // plus/%r0/n1/%rR
      true, // plus/%r0/n2/%r0
      true, // plus/%r0/n2/%r1
      true, // plus/%r0/n2/%rR
      true, // plus/%r0/nR/%r0
      true, // plus/%r0/nR/%r1
      true, // plus/%r0/nR/%rR
      true, // plus/%r1/%r0/%r0
      true, // plus/%r1/%r0/%r1
      true, // plus/%r1/%r0/%rR
      true, // plus/%r1/%r1/%r0
      true, // plus/%r1/%r1/%r1
      true, // plus/%r1/%r1/%rR
      true, // plus/%r1/%rR/%r0
      true, // plus/%r1/%rR/%r1
      true, // plus/%r1/%rR/%rR
      true, // plus/%r1/n1/%r0
      true, // plus/%r1/n1/%r1
      true, // plus/%r1/n1/%rR
      true, // plus/%r1/n2/%r0
      true, // plus/%r1/n2/%r1
      true, // plus/%r1/n2/%rR
      true, // plus/%r1/nR/%r0
      true, // plus/%r1/nR/%r1
      true, // plus/%r1/nR/%rR
      true, // plus/%rR/%r0/%r0
      true, // plus/%rR/%r0/%r1
      true, // plus/%rR/%r0/%rR
      true, // plus/%rR/%r1/%r0
      true, // plus/%rR/%r1/%r1
      true, // plus/%rR/%r1/%rR
      true, // plus/%rR/%rR/%r0
      true, // plus/%rR/%rR/%r1
      true, // plus/%rR/%rR/%rR
      true, // plus/%rR/n1/%r0
      true, // plus/%rR/n1/%r1
      true, // plus/%rR/n1/%rR
      true, // plus/%rR/n2/%r0
      true, // plus/%rR/n2/%r1
      true, // plus/%rR/n2/%rR
      true, // plus/%rR/nR/%r0
      true, // plus/%rR/nR/%r1
      true, // plus/%rR/nR/%rR
      true, // plus/n1/%r0/%r0
      true, // plus/n1/%r0/%r1
      true, // plus/n1/%r0/%rR
      true, // plus/n1/%r1/%r0
      true, // plus/n1/%r1/%r1
      true, // plus/n1/%r1/%rR
      true, // plus/n1/%rR/%r0
      true, // plus/n1/%rR/%r1
      true, // plus/n1/%rR/%rR
      true, // plus/n1/n1/%r0
      true, // plus/n1/n1/%r1
      true, // plus/n1/n1/%rR
      true, // plus/n1/n2/%r0
      true, // plus/n1/n2/%r1
      true, // plus/n1/n2/%rR
      true, // plus/n1/nR/%r0
      true, // plus/n1/nR/%r1
      true, // plus/n1/nR/%rR
      true, // plus/n2/%r0/%r0
      true, // plus/n2/%r0/%r1
      true, // plus/n2/%r0/%rR
      true, // plus/n2/%r1/%r0
      true, // plus/n2/%r1/%r1
      true, // plus/n2/%r1/%rR
      true, // plus/n2/%rR/%r0
      true, // plus/n2/%rR/%r1
      true, // plus/n2/%rR/%rR
      true, // plus/n2/n1/%r0
      true, // plus/n2/n1/%r1
      true, // plus/n2/n1/%rR
      true, // plus/n2/n2/%r0
      true, // plus/n2/n2/%r1
      true, // plus/n2/n2/%rR
      true, // plus/n2/nR/%r0
      true, // plus/n2/nR/%r1
      true, // plus/n2/nR/%rR
      true, // plus/nR/%r0/%r0
      true, // plus/nR/%r0/%r1
      true, // plus/nR/%r0/%rR
      true, // plus/nR/%r1/%r0
      true, // plus/nR/%r1/%r1
      true, // plus/nR/%r1/%rR
      true, // plus/nR/%rR/%r0
      true, // plus/nR/%rR/%r1
      true, // plus/nR/%rR/%rR
      true, // plus/nR/n1/%r0
      true, // plus/nR/n1/%r1
      true, // plus/nR/n1/%rR
      true, // plus/nR/n2/%r0
      true, // plus/nR/n2/%r1
      true, // plus/nR/n2/%rR
      true, // plus/nR/nR/%r0
      true, // plus/nR/nR/%r1
      true, // plus/nR/nR/%rR
      true, // plus-stack
      true, // plusi-stack/n-1
      true, // plusi-stack/n1
      true, // plusi-stack/n2
      true, // plusi-stack/nR
      true, // pop-stack/%r0
      true, // pop-stack/%r1
      true, // pop-stack/%rR
      false, // print/%r0/retR
      false, // print/%r1/retR
      false, // print/%rR/retR
      false, // print/nR/retR
      false, // print-stack/retR
      true, // procedure-prolog
      true, // push-boxed-literal/n0
      true, // push-boxed-literal/n1
      true, // push-boxed-literal/n2
      true, // push-boxed-literal/n3
      true, // push-boxed-literal/n4
      true, // push-boxed-literal/n5
      true, // push-boxed-literal/n6
      true, // push-boxed-literal/n7
      true, // push-boxed-literal/n8
      true, // push-boxed-literal/n9
      true, // push-boxed-literal/n10
      true, // push-boxed-literal/nR
      true, // push-stack/%r0
      true, // push-stack/%r1
      true, // push-stack/%rR
      true, // push-stack/n0
      true, // push-stack/n1
      true, // push-stack/n-1
      true, // push-stack/n2
      true, // push-stack/nR
      true, // push-stack/lR
      true, // push-unspecified-stack
      false, // remainder/%r0/%r0/%r0/retR
      false, // remainder/%r0/%r0/%r1/retR
      false, // remainder/%r0/%r0/%rR/retR
      false, // remainder/%r0/%r1/%r0/retR
      false, // remainder/%r0/%r1/%r1/retR
      false, // remainder/%r0/%r1/%rR/retR
      false, // remainder/%r0/%rR/%r0/retR
      false, // remainder/%r0/%rR/%r1/retR
      false, // remainder/%r0/%rR/%rR/retR
      false, // remainder/%r0/n2/%r0/retR
      false, // remainder/%r0/n2/%r1/retR
      false, // remainder/%r0/n2/%rR/retR
      false, // remainder/%r0/nR/%r0/retR
      false, // remainder/%r0/nR/%r1/retR
      false, // remainder/%r0/nR/%rR/retR
      false, // remainder/%r1/%r0/%r0/retR
      false, // remainder/%r1/%r0/%r1/retR
      false, // remainder/%r1/%r0/%rR/retR
      false, // remainder/%r1/%r1/%r0/retR
      false, // remainder/%r1/%r1/%r1/retR
      false, // remainder/%r1/%r1/%rR/retR
      false, // remainder/%r1/%rR/%r0/retR
      false, // remainder/%r1/%rR/%r1/retR
      false, // remainder/%r1/%rR/%rR/retR
      false, // remainder/%r1/n2/%r0/retR
      false, // remainder/%r1/n2/%r1/retR
      false, // remainder/%r1/n2/%rR/retR
      false, // remainder/%r1/nR/%r0/retR
      false, // remainder/%r1/nR/%r1/retR
      false, // remainder/%r1/nR/%rR/retR
      false, // remainder/%rR/%r0/%r0/retR
      false, // remainder/%rR/%r0/%r1/retR
      false, // remainder/%rR/%r0/%rR/retR
      false, // remainder/%rR/%r1/%r0/retR
      false, // remainder/%rR/%r1/%r1/retR
      false, // remainder/%rR/%r1/%rR/retR
      false, // remainder/%rR/%rR/%r0/retR
      false, // remainder/%rR/%rR/%r1/retR
      false, // remainder/%rR/%rR/%rR/retR
      false, // remainder/%rR/n2/%r0/retR
      false, // remainder/%rR/n2/%r1/retR
      false, // remainder/%rR/n2/%rR/retR
      false, // remainder/%rR/nR/%r0/retR
      false, // remainder/%rR/nR/%r1/retR
      false, // remainder/%rR/nR/%rR/retR
      false, // remainder/nR/%r0/%r0/retR
      false, // remainder/nR/%r0/%r1/retR
      false, // remainder/nR/%r0/%rR/retR
      false, // remainder/nR/%r1/%r0/retR
      false, // remainder/nR/%r1/%r1/retR
      false, // remainder/nR/%r1/%rR/retR
      false, // remainder/nR/%rR/%r0/retR
      false, // remainder/nR/%rR/%r1/retR
      false, // remainder/nR/%rR/%rR/retR
      false, // remainder/nR/n2/%r0/retR
      false, // remainder/nR/n2/%r1/retR
      false, // remainder/nR/n2/%rR/retR
      false, // remainder/nR/nR/%r0/retR
      false, // remainder/nR/nR/%r1/retR
      false, // remainder/nR/nR/%rR/retR
      false, // remainder-stack/retR
      true, // return-to-undertop
      true, // swap-stack
      true, // times/%r0/%r0/%r0
      true, // times/%r0/%r0/%r1
      true, // times/%r0/%r0/%rR
      true, // times/%r0/%r1/%r0
      true, // times/%r0/%r1/%r1
      true, // times/%r0/%r1/%rR
      true, // times/%r0/%rR/%r0
      true, // times/%r0/%rR/%r1
      true, // times/%r0/%rR/%rR
      true, // times/%r0/n2/%r0
      true, // times/%r0/n2/%r1
      true, // times/%r0/n2/%rR
      true, // times/%r0/nR/%r0
      true, // times/%r0/nR/%r1
      true, // times/%r0/nR/%rR
      true, // times/%r1/%r0/%r0
      true, // times/%r1/%r0/%r1
      true, // times/%r1/%r0/%rR
      true, // times/%r1/%r1/%r0
      true, // times/%r1/%r1/%r1
      true, // times/%r1/%r1/%rR
      true, // times/%r1/%rR/%r0
      true, // times/%r1/%rR/%r1
      true, // times/%r1/%rR/%rR
      true, // times/%r1/n2/%r0
      true, // times/%r1/n2/%r1
      true, // times/%r1/n2/%rR
      true, // times/%r1/nR/%r0
      true, // times/%r1/nR/%r1
      true, // times/%r1/nR/%rR
      true, // times/%rR/%r0/%r0
      true, // times/%rR/%r0/%r1
      true, // times/%rR/%r0/%rR
      true, // times/%rR/%r1/%r0
      true, // times/%rR/%r1/%r1
      true, // times/%rR/%r1/%rR
      true, // times/%rR/%rR/%r0
      true, // times/%rR/%rR/%r1
      true, // times/%rR/%rR/%rR
      true, // times/%rR/n2/%r0
      true, // times/%rR/n2/%r1
      true, // times/%rR/n2/%rR
      true, // times/%rR/nR/%r0
      true, // times/%rR/nR/%r1
      true, // times/%rR/nR/%rR
      true, // times/nR/%r0/%r0
      true, // times/nR/%r0/%r1
      true, // times/nR/%r0/%rR
      true, // times/nR/%r1/%r0
      true, // times/nR/%r1/%r1
      true, // times/nR/%r1/%rR
      true, // times/nR/%rR/%r0
      true, // times/nR/%rR/%r1
      true, // times/nR/%rR/%rR
      true, // times/nR/n2/%r0
      true, // times/nR/n2/%r1
      true, // times/nR/n2/%rR
      true, // times/nR/nR/%r0
      true, // times/nR/nR/%r1
      true, // times/nR/nR/%rR
      true, // times-stack
      true, // uminus/%r0/%r0
      true, // uminus/%r0/%r1
      true, // uminus/%r0/%rR
      true, // uminus/%r1/%r0
      true, // uminus/%r1/%r1
      true, // uminus/%r1/%rR
      true, // uminus/%rR/%r0
      true, // uminus/%rR/%r1
      true, // uminus/%rR/%rR
      true, // uminus/nR/%r0
      true, // uminus/nR/%r1
      true, // uminus/nR/%rR
      true, // uminus-stack
      true, // underpop-stack/%r0
      true, // underpop-stack/%r1
      true, // underpop-stack/%rR
      true, // underpush-stack/%r0
      true, // underpush-stack/%r1
      true, // underpush-stack/%rR
      true, // underpush-stack/nR
      true, // unreachable
      false, // !REPLACEMENT-b/fR/retR
      false, // !REPLACEMENT-be/%r0/%r0/fR/retR
      false, // !REPLACEMENT-be/%r0/%r1/fR/retR
      false, // !REPLACEMENT-be/%r0/%rR/fR/retR
      false, // !REPLACEMENT-be/%r0/n0/fR/retR
      false, // !REPLACEMENT-be/%r0/nR/fR/retR
      false, // !REPLACEMENT-be/%r1/%r0/fR/retR
      false, // !REPLACEMENT-be/%r1/%r1/fR/retR
      false, // !REPLACEMENT-be/%r1/%rR/fR/retR
      false, // !REPLACEMENT-be/%r1/n0/fR/retR
      false, // !REPLACEMENT-be/%r1/nR/fR/retR
      false, // !REPLACEMENT-be/%rR/%r0/fR/retR
      false, // !REPLACEMENT-be/%rR/%r1/fR/retR
      false, // !REPLACEMENT-be/%rR/%rR/fR/retR
      false, // !REPLACEMENT-be/%rR/n0/fR/retR
      false, // !REPLACEMENT-be/%rR/nR/fR/retR
      false, // !REPLACEMENT-be/n0/%r0/fR/retR
      false, // !REPLACEMENT-be/n0/%r1/fR/retR
      false, // !REPLACEMENT-be/n0/%rR/fR/retR
      false, // !REPLACEMENT-be/n0/n0/fR/retR
      false, // !REPLACEMENT-be/n0/nR/fR/retR
      false, // !REPLACEMENT-be/nR/%r0/fR/retR
      false, // !REPLACEMENT-be/nR/%r1/fR/retR
      false, // !REPLACEMENT-be/nR/%rR/fR/retR
      false, // !REPLACEMENT-be/nR/n0/fR/retR
      false, // !REPLACEMENT-be/nR/nR/fR/retR
      false, // !REPLACEMENT-beqi-stack/n-1/fR/retR
      false, // !REPLACEMENT-beqi-stack/n0/fR/retR
      false, // !REPLACEMENT-beqi-stack/n1/fR/retR
      false, // !REPLACEMENT-beqi-stack/n2/fR/retR
      false, // !REPLACEMENT-beqi-stack/nR/fR/retR
      false, // !REPLACEMENT-bf-stack/fR/retR
      false, // !REPLACEMENT-bg/%r0/%r0/fR/retR
      false, // !REPLACEMENT-bg/%r0/%r1/fR/retR
      false, // !REPLACEMENT-bg/%r0/%rR/fR/retR
      false, // !REPLACEMENT-bg/%r0/n0/fR/retR
      false, // !REPLACEMENT-bg/%r0/nR/fR/retR
      false, // !REPLACEMENT-bg/%r1/%r0/fR/retR
      false, // !REPLACEMENT-bg/%r1/%r1/fR/retR
      false, // !REPLACEMENT-bg/%r1/%rR/fR/retR
      false, // !REPLACEMENT-bg/%r1/n0/fR/retR
      false, // !REPLACEMENT-bg/%r1/nR/fR/retR
      false, // !REPLACEMENT-bg/%rR/%r0/fR/retR
      false, // !REPLACEMENT-bg/%rR/%r1/fR/retR
      false, // !REPLACEMENT-bg/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bg/%rR/n0/fR/retR
      false, // !REPLACEMENT-bg/%rR/nR/fR/retR
      false, // !REPLACEMENT-bg/n0/%r0/fR/retR
      false, // !REPLACEMENT-bg/n0/%r1/fR/retR
      false, // !REPLACEMENT-bg/n0/%rR/fR/retR
      false, // !REPLACEMENT-bg/n0/n0/fR/retR
      false, // !REPLACEMENT-bg/n0/nR/fR/retR
      false, // !REPLACEMENT-bg/nR/%r0/fR/retR
      false, // !REPLACEMENT-bg/nR/%r1/fR/retR
      false, // !REPLACEMENT-bg/nR/%rR/fR/retR
      false, // !REPLACEMENT-bg/nR/n0/fR/retR
      false, // !REPLACEMENT-bg/nR/nR/fR/retR
      false, // !REPLACEMENT-bge/%r0/%r0/fR/retR
      false, // !REPLACEMENT-bge/%r0/%r1/fR/retR
      false, // !REPLACEMENT-bge/%r0/%rR/fR/retR
      false, // !REPLACEMENT-bge/%r0/n0/fR/retR
      false, // !REPLACEMENT-bge/%r0/nR/fR/retR
      false, // !REPLACEMENT-bge/%r1/%r0/fR/retR
      false, // !REPLACEMENT-bge/%r1/%r1/fR/retR
      false, // !REPLACEMENT-bge/%r1/%rR/fR/retR
      false, // !REPLACEMENT-bge/%r1/n0/fR/retR
      false, // !REPLACEMENT-bge/%r1/nR/fR/retR
      false, // !REPLACEMENT-bge/%rR/%r0/fR/retR
      false, // !REPLACEMENT-bge/%rR/%r1/fR/retR
      false, // !REPLACEMENT-bge/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bge/%rR/n0/fR/retR
      false, // !REPLACEMENT-bge/%rR/nR/fR/retR
      false, // !REPLACEMENT-bge/n0/%r0/fR/retR
      false, // !REPLACEMENT-bge/n0/%r1/fR/retR
      false, // !REPLACEMENT-bge/n0/%rR/fR/retR
      false, // !REPLACEMENT-bge/n0/n0/fR/retR
      false, // !REPLACEMENT-bge/n0/nR/fR/retR
      false, // !REPLACEMENT-bge/nR/%r0/fR/retR
      false, // !REPLACEMENT-bge/nR/%r1/fR/retR
      false, // !REPLACEMENT-bge/nR/%rR/fR/retR
      false, // !REPLACEMENT-bge/nR/n0/fR/retR
      false, // !REPLACEMENT-bge/nR/nR/fR/retR
      false, // !REPLACEMENT-bl/%r0/%r0/fR/retR
      false, // !REPLACEMENT-bl/%r0/%r1/fR/retR
      false, // !REPLACEMENT-bl/%r0/%rR/fR/retR
      false, // !REPLACEMENT-bl/%r0/n0/fR/retR
      false, // !REPLACEMENT-bl/%r0/nR/fR/retR
      false, // !REPLACEMENT-bl/%r1/%r0/fR/retR
      false, // !REPLACEMENT-bl/%r1/%r1/fR/retR
      false, // !REPLACEMENT-bl/%r1/%rR/fR/retR
      false, // !REPLACEMENT-bl/%r1/n0/fR/retR
      false, // !REPLACEMENT-bl/%r1/nR/fR/retR
      false, // !REPLACEMENT-bl/%rR/%r0/fR/retR
      false, // !REPLACEMENT-bl/%rR/%r1/fR/retR
      false, // !REPLACEMENT-bl/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bl/%rR/n0/fR/retR
      false, // !REPLACEMENT-bl/%rR/nR/fR/retR
      false, // !REPLACEMENT-bl/n0/%r0/fR/retR
      false, // !REPLACEMENT-bl/n0/%r1/fR/retR
      false, // !REPLACEMENT-bl/n0/%rR/fR/retR
      false, // !REPLACEMENT-bl/n0/n0/fR/retR
      false, // !REPLACEMENT-bl/n0/nR/fR/retR
      false, // !REPLACEMENT-bl/nR/%r0/fR/retR
      false, // !REPLACEMENT-bl/nR/%r1/fR/retR
      false, // !REPLACEMENT-bl/nR/%rR/fR/retR
      false, // !REPLACEMENT-bl/nR/n0/fR/retR
      false, // !REPLACEMENT-bl/nR/nR/fR/retR
      false, // !REPLACEMENT-ble/%r0/%r0/fR/retR
      false, // !REPLACEMENT-ble/%r0/%r1/fR/retR
      false, // !REPLACEMENT-ble/%r0/%rR/fR/retR
      false, // !REPLACEMENT-ble/%r0/n0/fR/retR
      false, // !REPLACEMENT-ble/%r0/nR/fR/retR
      false, // !REPLACEMENT-ble/%r1/%r0/fR/retR
      false, // !REPLACEMENT-ble/%r1/%r1/fR/retR
      false, // !REPLACEMENT-ble/%r1/%rR/fR/retR
      false, // !REPLACEMENT-ble/%r1/n0/fR/retR
      false, // !REPLACEMENT-ble/%r1/nR/fR/retR
      false, // !REPLACEMENT-ble/%rR/%r0/fR/retR
      false, // !REPLACEMENT-ble/%rR/%r1/fR/retR
      false, // !REPLACEMENT-ble/%rR/%rR/fR/retR
      false, // !REPLACEMENT-ble/%rR/n0/fR/retR
      false, // !REPLACEMENT-ble/%rR/nR/fR/retR
      false, // !REPLACEMENT-ble/n0/%r0/fR/retR
      false, // !REPLACEMENT-ble/n0/%r1/fR/retR
      false, // !REPLACEMENT-ble/n0/%rR/fR/retR
      false, // !REPLACEMENT-ble/n0/n0/fR/retR
      false, // !REPLACEMENT-ble/n0/nR/fR/retR
      false, // !REPLACEMENT-ble/nR/%r0/fR/retR
      false, // !REPLACEMENT-ble/nR/%r1/fR/retR
      false, // !REPLACEMENT-ble/nR/%rR/fR/retR
      false, // !REPLACEMENT-ble/nR/n0/fR/retR
      false, // !REPLACEMENT-ble/nR/nR/fR/retR
      false, // !REPLACEMENT-bne/%r0/%r0/fR/retR
      false, // !REPLACEMENT-bne/%r0/%r1/fR/retR
      false, // !REPLACEMENT-bne/%r0/%rR/fR/retR
      false, // !REPLACEMENT-bne/%r0/n0/fR/retR
      false, // !REPLACEMENT-bne/%r0/nR/fR/retR
      false, // !REPLACEMENT-bne/%r1/%r0/fR/retR
      false, // !REPLACEMENT-bne/%r1/%r1/fR/retR
      false, // !REPLACEMENT-bne/%r1/%rR/fR/retR
      false, // !REPLACEMENT-bne/%r1/n0/fR/retR
      false, // !REPLACEMENT-bne/%r1/nR/fR/retR
      false, // !REPLACEMENT-bne/%rR/%r0/fR/retR
      false, // !REPLACEMENT-bne/%rR/%r1/fR/retR
      false, // !REPLACEMENT-bne/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bne/%rR/n0/fR/retR
      false, // !REPLACEMENT-bne/%rR/nR/fR/retR
      false, // !REPLACEMENT-bne/n0/%r0/fR/retR
      false, // !REPLACEMENT-bne/n0/%r1/fR/retR
      false, // !REPLACEMENT-bne/n0/%rR/fR/retR
      false, // !REPLACEMENT-bne/n0/n0/fR/retR
      false, // !REPLACEMENT-bne/n0/nR/fR/retR
      false, // !REPLACEMENT-bne/nR/%r0/fR/retR
      false, // !REPLACEMENT-bne/nR/%r1/fR/retR
      false, // !REPLACEMENT-bne/nR/%rR/fR/retR
      false, // !REPLACEMENT-bne/nR/n0/fR/retR
      false, // !REPLACEMENT-bne/nR/nR/fR/retR
      false, // !REPLACEMENT-bneqi-stack/n-1/fR/retR
      false, // !REPLACEMENT-bneqi-stack/n0/fR/retR
      false, // !REPLACEMENT-bneqi-stack/n1/fR/retR
      false, // !REPLACEMENT-bneqi-stack/n2/fR/retR
      false, // !REPLACEMENT-bneqi-stack/nR/fR/retR
      false, // !REPLACEMENT-bt-stack/fR/retR
      false, // !REPLACEMENT-call/fR/retR
      false, // !REPLACEMENT-exitvm/retR
      false, // !REPLACEMENT-procedure-prolog/retR
      false, // !REPLACEMENT-return-to-undertop/retR
      false // !REPLACEMENT-unreachable/retR
    };

// FIXME: this is not currently accessed, and in fact may be useless.
const bool
structuredvm_specialized_instruction_callers [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
      false, // !INVALID
      false, // !BEGINBASICBLOCK
      false, // !EXITVM
      false, // !DATALOCATIONS
      false, // !NOP
      false, // !UNREACHABLE0
      false, // !UNREACHABLE1
      false, // !PRETENDTOJUMPANYWHERE
      false, // b/fR
      false, // be/%r0/%r0/fR
      false, // be/%r0/%r1/fR
      false, // be/%r0/%rR/fR
      false, // be/%r0/n0/fR
      false, // be/%r0/nR/fR
      false, // be/%r1/%r0/fR
      false, // be/%r1/%r1/fR
      false, // be/%r1/%rR/fR
      false, // be/%r1/n0/fR
      false, // be/%r1/nR/fR
      false, // be/%rR/%r0/fR
      false, // be/%rR/%r1/fR
      false, // be/%rR/%rR/fR
      false, // be/%rR/n0/fR
      false, // be/%rR/nR/fR
      false, // be/n0/%r0/fR
      false, // be/n0/%r1/fR
      false, // be/n0/%rR/fR
      false, // be/n0/n0/fR
      false, // be/n0/nR/fR
      false, // be/nR/%r0/fR
      false, // be/nR/%r1/fR
      false, // be/nR/%rR/fR
      false, // be/nR/n0/fR
      false, // be/nR/nR/fR
      false, // beqi-stack/n-1/fR
      false, // beqi-stack/n0/fR
      false, // beqi-stack/n1/fR
      false, // beqi-stack/n2/fR
      false, // beqi-stack/nR/fR
      false, // bf-stack/fR
      false, // bg/%r0/%r0/fR
      false, // bg/%r0/%r1/fR
      false, // bg/%r0/%rR/fR
      false, // bg/%r0/n0/fR
      false, // bg/%r0/nR/fR
      false, // bg/%r1/%r0/fR
      false, // bg/%r1/%r1/fR
      false, // bg/%r1/%rR/fR
      false, // bg/%r1/n0/fR
      false, // bg/%r1/nR/fR
      false, // bg/%rR/%r0/fR
      false, // bg/%rR/%r1/fR
      false, // bg/%rR/%rR/fR
      false, // bg/%rR/n0/fR
      false, // bg/%rR/nR/fR
      false, // bg/n0/%r0/fR
      false, // bg/n0/%r1/fR
      false, // bg/n0/%rR/fR
      false, // bg/n0/n0/fR
      false, // bg/n0/nR/fR
      false, // bg/nR/%r0/fR
      false, // bg/nR/%r1/fR
      false, // bg/nR/%rR/fR
      false, // bg/nR/n0/fR
      false, // bg/nR/nR/fR
      false, // bge/%r0/%r0/fR
      false, // bge/%r0/%r1/fR
      false, // bge/%r0/%rR/fR
      false, // bge/%r0/n0/fR
      false, // bge/%r0/nR/fR
      false, // bge/%r1/%r0/fR
      false, // bge/%r1/%r1/fR
      false, // bge/%r1/%rR/fR
      false, // bge/%r1/n0/fR
      false, // bge/%r1/nR/fR
      false, // bge/%rR/%r0/fR
      false, // bge/%rR/%r1/fR
      false, // bge/%rR/%rR/fR
      false, // bge/%rR/n0/fR
      false, // bge/%rR/nR/fR
      false, // bge/n0/%r0/fR
      false, // bge/n0/%r1/fR
      false, // bge/n0/%rR/fR
      false, // bge/n0/n0/fR
      false, // bge/n0/nR/fR
      false, // bge/nR/%r0/fR
      false, // bge/nR/%r1/fR
      false, // bge/nR/%rR/fR
      false, // bge/nR/n0/fR
      false, // bge/nR/nR/fR
      false, // bl/%r0/%r0/fR
      false, // bl/%r0/%r1/fR
      false, // bl/%r0/%rR/fR
      false, // bl/%r0/n0/fR
      false, // bl/%r0/nR/fR
      false, // bl/%r1/%r0/fR
      false, // bl/%r1/%r1/fR
      false, // bl/%r1/%rR/fR
      false, // bl/%r1/n0/fR
      false, // bl/%r1/nR/fR
      false, // bl/%rR/%r0/fR
      false, // bl/%rR/%r1/fR
      false, // bl/%rR/%rR/fR
      false, // bl/%rR/n0/fR
      false, // bl/%rR/nR/fR
      false, // bl/n0/%r0/fR
      false, // bl/n0/%r1/fR
      false, // bl/n0/%rR/fR
      false, // bl/n0/n0/fR
      false, // bl/n0/nR/fR
      false, // bl/nR/%r0/fR
      false, // bl/nR/%r1/fR
      false, // bl/nR/%rR/fR
      false, // bl/nR/n0/fR
      false, // bl/nR/nR/fR
      false, // ble/%r0/%r0/fR
      false, // ble/%r0/%r1/fR
      false, // ble/%r0/%rR/fR
      false, // ble/%r0/n0/fR
      false, // ble/%r0/nR/fR
      false, // ble/%r1/%r0/fR
      false, // ble/%r1/%r1/fR
      false, // ble/%r1/%rR/fR
      false, // ble/%r1/n0/fR
      false, // ble/%r1/nR/fR
      false, // ble/%rR/%r0/fR
      false, // ble/%rR/%r1/fR
      false, // ble/%rR/%rR/fR
      false, // ble/%rR/n0/fR
      false, // ble/%rR/nR/fR
      false, // ble/n0/%r0/fR
      false, // ble/n0/%r1/fR
      false, // ble/n0/%rR/fR
      false, // ble/n0/n0/fR
      false, // ble/n0/nR/fR
      false, // ble/nR/%r0/fR
      false, // ble/nR/%r1/fR
      false, // ble/nR/%rR/fR
      false, // ble/nR/n0/fR
      false, // ble/nR/nR/fR
      false, // bne/%r0/%r0/fR
      false, // bne/%r0/%r1/fR
      false, // bne/%r0/%rR/fR
      false, // bne/%r0/n0/fR
      false, // bne/%r0/nR/fR
      false, // bne/%r1/%r0/fR
      false, // bne/%r1/%r1/fR
      false, // bne/%r1/%rR/fR
      false, // bne/%r1/n0/fR
      false, // bne/%r1/nR/fR
      false, // bne/%rR/%r0/fR
      false, // bne/%rR/%r1/fR
      false, // bne/%rR/%rR/fR
      false, // bne/%rR/n0/fR
      false, // bne/%rR/nR/fR
      false, // bne/n0/%r0/fR
      false, // bne/n0/%r1/fR
      false, // bne/n0/%rR/fR
      false, // bne/n0/n0/fR
      false, // bne/n0/nR/fR
      false, // bne/nR/%r0/fR
      false, // bne/nR/%r1/fR
      false, // bne/nR/%rR/fR
      false, // bne/nR/n0/fR
      false, // bne/nR/nR/fR
      false, // bneqi-stack/n-1/fR
      false, // bneqi-stack/n0/fR
      false, // bneqi-stack/n1/fR
      false, // bneqi-stack/n2/fR
      false, // bneqi-stack/nR/fR
      false, // bt-stack/fR
      true, // call/fR/retR
      false, // copy-to-r-stack/%r0
      false, // copy-to-r-stack/%r1
      false, // copy-to-r-stack/%rR
      false, // different-stack
      false, // divided/%r0/%r0/%r0/retR
      false, // divided/%r0/%r0/%r1/retR
      false, // divided/%r0/%r0/%rR/retR
      false, // divided/%r0/%r1/%r0/retR
      false, // divided/%r0/%r1/%r1/retR
      false, // divided/%r0/%r1/%rR/retR
      false, // divided/%r0/%rR/%r0/retR
      false, // divided/%r0/%rR/%r1/retR
      false, // divided/%r0/%rR/%rR/retR
      false, // divided/%r0/n2/%r0/retR
      false, // divided/%r0/n2/%r1/retR
      false, // divided/%r0/n2/%rR/retR
      false, // divided/%r0/nR/%r0/retR
      false, // divided/%r0/nR/%r1/retR
      false, // divided/%r0/nR/%rR/retR
      false, // divided/%r1/%r0/%r0/retR
      false, // divided/%r1/%r0/%r1/retR
      false, // divided/%r1/%r0/%rR/retR
      false, // divided/%r1/%r1/%r0/retR
      false, // divided/%r1/%r1/%r1/retR
      false, // divided/%r1/%r1/%rR/retR
      false, // divided/%r1/%rR/%r0/retR
      false, // divided/%r1/%rR/%r1/retR
      false, // divided/%r1/%rR/%rR/retR
      false, // divided/%r1/n2/%r0/retR
      false, // divided/%r1/n2/%r1/retR
      false, // divided/%r1/n2/%rR/retR
      false, // divided/%r1/nR/%r0/retR
      false, // divided/%r1/nR/%r1/retR
      false, // divided/%r1/nR/%rR/retR
      false, // divided/%rR/%r0/%r0/retR
      false, // divided/%rR/%r0/%r1/retR
      false, // divided/%rR/%r0/%rR/retR
      false, // divided/%rR/%r1/%r0/retR
      false, // divided/%rR/%r1/%r1/retR
      false, // divided/%rR/%r1/%rR/retR
      false, // divided/%rR/%rR/%r0/retR
      false, // divided/%rR/%rR/%r1/retR
      false, // divided/%rR/%rR/%rR/retR
      false, // divided/%rR/n2/%r0/retR
      false, // divided/%rR/n2/%r1/retR
      false, // divided/%rR/n2/%rR/retR
      false, // divided/%rR/nR/%r0/retR
      false, // divided/%rR/nR/%r1/retR
      false, // divided/%rR/nR/%rR/retR
      false, // divided/nR/%r0/%r0/retR
      false, // divided/nR/%r0/%r1/retR
      false, // divided/nR/%r0/%rR/retR
      false, // divided/nR/%r1/%r0/retR
      false, // divided/nR/%r1/%r1/retR
      false, // divided/nR/%r1/%rR/retR
      false, // divided/nR/%rR/%r0/retR
      false, // divided/nR/%rR/%r1/retR
      false, // divided/nR/%rR/%rR/retR
      false, // divided/nR/n2/%r0/retR
      false, // divided/nR/n2/%r1/retR
      false, // divided/nR/n2/%rR/retR
      false, // divided/nR/nR/%r0/retR
      false, // divided/nR/nR/%r1/retR
      false, // divided/nR/nR/%rR/retR
      false, // divided-stack/retR
      false, // drop-stack
      false, // dup-stack
      false, // equal-stack
      false, // equali-stack/n0
      false, // equali-stack/n1
      false, // equali-stack/n2
      false, // equali-stack/nR
      false, // exitvm
      false, // greater-stack
      false, // greaterorequal-stack
      false, // input/%r0/retR
      false, // input/%r1/retR
      false, // input/%rR/retR
      false, // input-stack/retR
      false, // isnonzero-stack
      false, // less-stack
      false, // lessorequal-stack
      false, // load-boxed-literal/n0/%r0
      false, // load-boxed-literal/n0/%r1
      false, // load-boxed-literal/n0/%rR
      false, // load-boxed-literal/n1/%r0
      false, // load-boxed-literal/n1/%r1
      false, // load-boxed-literal/n1/%rR
      false, // load-boxed-literal/n2/%r0
      false, // load-boxed-literal/n2/%r1
      false, // load-boxed-literal/n2/%rR
      false, // load-boxed-literal/n3/%r0
      false, // load-boxed-literal/n3/%r1
      false, // load-boxed-literal/n3/%rR
      false, // load-boxed-literal/n4/%r0
      false, // load-boxed-literal/n4/%r1
      false, // load-boxed-literal/n4/%rR
      false, // load-boxed-literal/n5/%r0
      false, // load-boxed-literal/n5/%r1
      false, // load-boxed-literal/n5/%rR
      false, // load-boxed-literal/n6/%r0
      false, // load-boxed-literal/n6/%r1
      false, // load-boxed-literal/n6/%rR
      false, // load-boxed-literal/n7/%r0
      false, // load-boxed-literal/n7/%r1
      false, // load-boxed-literal/n7/%rR
      false, // load-boxed-literal/n8/%r0
      false, // load-boxed-literal/n8/%r1
      false, // load-boxed-literal/n8/%rR
      false, // load-boxed-literal/n9/%r0
      false, // load-boxed-literal/n9/%r1
      false, // load-boxed-literal/n9/%rR
      false, // load-boxed-literal/n10/%r0
      false, // load-boxed-literal/n10/%r1
      false, // load-boxed-literal/n10/%rR
      false, // load-boxed-literal/nR/%r0
      false, // load-boxed-literal/nR/%r1
      false, // load-boxed-literal/nR/%rR
      false, // logicaland-stack
      false, // logicalnot-stack
      false, // logicalor-stack
      false, // minus/%r0/%r0/%r0
      false, // minus/%r0/%r0/%r1
      false, // minus/%r0/%r0/%rR
      false, // minus/%r0/%r1/%r0
      false, // minus/%r0/%r1/%r1
      false, // minus/%r0/%r1/%rR
      false, // minus/%r0/%rR/%r0
      false, // minus/%r0/%rR/%r1
      false, // minus/%r0/%rR/%rR
      false, // minus/%r0/n1/%r0
      false, // minus/%r0/n1/%r1
      false, // minus/%r0/n1/%rR
      false, // minus/%r0/n2/%r0
      false, // minus/%r0/n2/%r1
      false, // minus/%r0/n2/%rR
      false, // minus/%r0/nR/%r0
      false, // minus/%r0/nR/%r1
      false, // minus/%r0/nR/%rR
      false, // minus/%r1/%r0/%r0
      false, // minus/%r1/%r0/%r1
      false, // minus/%r1/%r0/%rR
      false, // minus/%r1/%r1/%r0
      false, // minus/%r1/%r1/%r1
      false, // minus/%r1/%r1/%rR
      false, // minus/%r1/%rR/%r0
      false, // minus/%r1/%rR/%r1
      false, // minus/%r1/%rR/%rR
      false, // minus/%r1/n1/%r0
      false, // minus/%r1/n1/%r1
      false, // minus/%r1/n1/%rR
      false, // minus/%r1/n2/%r0
      false, // minus/%r1/n2/%r1
      false, // minus/%r1/n2/%rR
      false, // minus/%r1/nR/%r0
      false, // minus/%r1/nR/%r1
      false, // minus/%r1/nR/%rR
      false, // minus/%rR/%r0/%r0
      false, // minus/%rR/%r0/%r1
      false, // minus/%rR/%r0/%rR
      false, // minus/%rR/%r1/%r0
      false, // minus/%rR/%r1/%r1
      false, // minus/%rR/%r1/%rR
      false, // minus/%rR/%rR/%r0
      false, // minus/%rR/%rR/%r1
      false, // minus/%rR/%rR/%rR
      false, // minus/%rR/n1/%r0
      false, // minus/%rR/n1/%r1
      false, // minus/%rR/n1/%rR
      false, // minus/%rR/n2/%r0
      false, // minus/%rR/n2/%r1
      false, // minus/%rR/n2/%rR
      false, // minus/%rR/nR/%r0
      false, // minus/%rR/nR/%r1
      false, // minus/%rR/nR/%rR
      false, // minus/nR/%r0/%r0
      false, // minus/nR/%r0/%r1
      false, // minus/nR/%r0/%rR
      false, // minus/nR/%r1/%r0
      false, // minus/nR/%r1/%r1
      false, // minus/nR/%r1/%rR
      false, // minus/nR/%rR/%r0
      false, // minus/nR/%rR/%r1
      false, // minus/nR/%rR/%rR
      false, // minus/nR/n1/%r0
      false, // minus/nR/n1/%r1
      false, // minus/nR/n1/%rR
      false, // minus/nR/n2/%r0
      false, // minus/nR/n2/%r1
      false, // minus/nR/n2/%rR
      false, // minus/nR/nR/%r0
      false, // minus/nR/nR/%r1
      false, // minus/nR/nR/%rR
      false, // minus-stack
      false, // minusi-stack/n1
      false, // minusi-stack/n2
      false, // minusi-stack/nR
      false, // mov/%r0/%r0
      false, // mov/%r0/%r1
      false, // mov/%r0/%rR
      false, // mov/%r1/%r0
      false, // mov/%r1/%r1
      false, // mov/%r1/%rR
      false, // mov/%rR/%r0
      false, // mov/%rR/%r1
      false, // mov/%rR/%rR
      false, // mov/n0/%r0
      false, // mov/n0/%r1
      false, // mov/n0/%rR
      false, // mov/n1/%r0
      false, // mov/n1/%r1
      false, // mov/n1/%rR
      false, // mov/n-1/%r0
      false, // mov/n-1/%r1
      false, // mov/n-1/%rR
      false, // mov/n2/%r0
      false, // mov/n2/%r1
      false, // mov/n2/%rR
      false, // mov/nR/%r0
      false, // mov/nR/%r1
      false, // mov/nR/%rR
      false, // plus/%r0/%r0/%r0
      false, // plus/%r0/%r0/%r1
      false, // plus/%r0/%r0/%rR
      false, // plus/%r0/%r1/%r0
      false, // plus/%r0/%r1/%r1
      false, // plus/%r0/%r1/%rR
      false, // plus/%r0/%rR/%r0
      false, // plus/%r0/%rR/%r1
      false, // plus/%r0/%rR/%rR
      false, // plus/%r0/n1/%r0
      false, // plus/%r0/n1/%r1
      false, // plus/%r0/n1/%rR
      false, // plus/%r0/n2/%r0
      false, // plus/%r0/n2/%r1
      false, // plus/%r0/n2/%rR
      false, // plus/%r0/nR/%r0
      false, // plus/%r0/nR/%r1
      false, // plus/%r0/nR/%rR
      false, // plus/%r1/%r0/%r0
      false, // plus/%r1/%r0/%r1
      false, // plus/%r1/%r0/%rR
      false, // plus/%r1/%r1/%r0
      false, // plus/%r1/%r1/%r1
      false, // plus/%r1/%r1/%rR
      false, // plus/%r1/%rR/%r0
      false, // plus/%r1/%rR/%r1
      false, // plus/%r1/%rR/%rR
      false, // plus/%r1/n1/%r0
      false, // plus/%r1/n1/%r1
      false, // plus/%r1/n1/%rR
      false, // plus/%r1/n2/%r0
      false, // plus/%r1/n2/%r1
      false, // plus/%r1/n2/%rR
      false, // plus/%r1/nR/%r0
      false, // plus/%r1/nR/%r1
      false, // plus/%r1/nR/%rR
      false, // plus/%rR/%r0/%r0
      false, // plus/%rR/%r0/%r1
      false, // plus/%rR/%r0/%rR
      false, // plus/%rR/%r1/%r0
      false, // plus/%rR/%r1/%r1
      false, // plus/%rR/%r1/%rR
      false, // plus/%rR/%rR/%r0
      false, // plus/%rR/%rR/%r1
      false, // plus/%rR/%rR/%rR
      false, // plus/%rR/n1/%r0
      false, // plus/%rR/n1/%r1
      false, // plus/%rR/n1/%rR
      false, // plus/%rR/n2/%r0
      false, // plus/%rR/n2/%r1
      false, // plus/%rR/n2/%rR
      false, // plus/%rR/nR/%r0
      false, // plus/%rR/nR/%r1
      false, // plus/%rR/nR/%rR
      false, // plus/n1/%r0/%r0
      false, // plus/n1/%r0/%r1
      false, // plus/n1/%r0/%rR
      false, // plus/n1/%r1/%r0
      false, // plus/n1/%r1/%r1
      false, // plus/n1/%r1/%rR
      false, // plus/n1/%rR/%r0
      false, // plus/n1/%rR/%r1
      false, // plus/n1/%rR/%rR
      false, // plus/n1/n1/%r0
      false, // plus/n1/n1/%r1
      false, // plus/n1/n1/%rR
      false, // plus/n1/n2/%r0
      false, // plus/n1/n2/%r1
      false, // plus/n1/n2/%rR
      false, // plus/n1/nR/%r0
      false, // plus/n1/nR/%r1
      false, // plus/n1/nR/%rR
      false, // plus/n2/%r0/%r0
      false, // plus/n2/%r0/%r1
      false, // plus/n2/%r0/%rR
      false, // plus/n2/%r1/%r0
      false, // plus/n2/%r1/%r1
      false, // plus/n2/%r1/%rR
      false, // plus/n2/%rR/%r0
      false, // plus/n2/%rR/%r1
      false, // plus/n2/%rR/%rR
      false, // plus/n2/n1/%r0
      false, // plus/n2/n1/%r1
      false, // plus/n2/n1/%rR
      false, // plus/n2/n2/%r0
      false, // plus/n2/n2/%r1
      false, // plus/n2/n2/%rR
      false, // plus/n2/nR/%r0
      false, // plus/n2/nR/%r1
      false, // plus/n2/nR/%rR
      false, // plus/nR/%r0/%r0
      false, // plus/nR/%r0/%r1
      false, // plus/nR/%r0/%rR
      false, // plus/nR/%r1/%r0
      false, // plus/nR/%r1/%r1
      false, // plus/nR/%r1/%rR
      false, // plus/nR/%rR/%r0
      false, // plus/nR/%rR/%r1
      false, // plus/nR/%rR/%rR
      false, // plus/nR/n1/%r0
      false, // plus/nR/n1/%r1
      false, // plus/nR/n1/%rR
      false, // plus/nR/n2/%r0
      false, // plus/nR/n2/%r1
      false, // plus/nR/n2/%rR
      false, // plus/nR/nR/%r0
      false, // plus/nR/nR/%r1
      false, // plus/nR/nR/%rR
      false, // plus-stack
      false, // plusi-stack/n-1
      false, // plusi-stack/n1
      false, // plusi-stack/n2
      false, // plusi-stack/nR
      false, // pop-stack/%r0
      false, // pop-stack/%r1
      false, // pop-stack/%rR
      false, // print/%r0/retR
      false, // print/%r1/retR
      false, // print/%rR/retR
      false, // print/nR/retR
      false, // print-stack/retR
      false, // procedure-prolog
      false, // push-boxed-literal/n0
      false, // push-boxed-literal/n1
      false, // push-boxed-literal/n2
      false, // push-boxed-literal/n3
      false, // push-boxed-literal/n4
      false, // push-boxed-literal/n5
      false, // push-boxed-literal/n6
      false, // push-boxed-literal/n7
      false, // push-boxed-literal/n8
      false, // push-boxed-literal/n9
      false, // push-boxed-literal/n10
      false, // push-boxed-literal/nR
      false, // push-stack/%r0
      false, // push-stack/%r1
      false, // push-stack/%rR
      false, // push-stack/n0
      false, // push-stack/n1
      false, // push-stack/n-1
      false, // push-stack/n2
      false, // push-stack/nR
      false, // push-stack/lR
      false, // push-unspecified-stack
      false, // remainder/%r0/%r0/%r0/retR
      false, // remainder/%r0/%r0/%r1/retR
      false, // remainder/%r0/%r0/%rR/retR
      false, // remainder/%r0/%r1/%r0/retR
      false, // remainder/%r0/%r1/%r1/retR
      false, // remainder/%r0/%r1/%rR/retR
      false, // remainder/%r0/%rR/%r0/retR
      false, // remainder/%r0/%rR/%r1/retR
      false, // remainder/%r0/%rR/%rR/retR
      false, // remainder/%r0/n2/%r0/retR
      false, // remainder/%r0/n2/%r1/retR
      false, // remainder/%r0/n2/%rR/retR
      false, // remainder/%r0/nR/%r0/retR
      false, // remainder/%r0/nR/%r1/retR
      false, // remainder/%r0/nR/%rR/retR
      false, // remainder/%r1/%r0/%r0/retR
      false, // remainder/%r1/%r0/%r1/retR
      false, // remainder/%r1/%r0/%rR/retR
      false, // remainder/%r1/%r1/%r0/retR
      false, // remainder/%r1/%r1/%r1/retR
      false, // remainder/%r1/%r1/%rR/retR
      false, // remainder/%r1/%rR/%r0/retR
      false, // remainder/%r1/%rR/%r1/retR
      false, // remainder/%r1/%rR/%rR/retR
      false, // remainder/%r1/n2/%r0/retR
      false, // remainder/%r1/n2/%r1/retR
      false, // remainder/%r1/n2/%rR/retR
      false, // remainder/%r1/nR/%r0/retR
      false, // remainder/%r1/nR/%r1/retR
      false, // remainder/%r1/nR/%rR/retR
      false, // remainder/%rR/%r0/%r0/retR
      false, // remainder/%rR/%r0/%r1/retR
      false, // remainder/%rR/%r0/%rR/retR
      false, // remainder/%rR/%r1/%r0/retR
      false, // remainder/%rR/%r1/%r1/retR
      false, // remainder/%rR/%r1/%rR/retR
      false, // remainder/%rR/%rR/%r0/retR
      false, // remainder/%rR/%rR/%r1/retR
      false, // remainder/%rR/%rR/%rR/retR
      false, // remainder/%rR/n2/%r0/retR
      false, // remainder/%rR/n2/%r1/retR
      false, // remainder/%rR/n2/%rR/retR
      false, // remainder/%rR/nR/%r0/retR
      false, // remainder/%rR/nR/%r1/retR
      false, // remainder/%rR/nR/%rR/retR
      false, // remainder/nR/%r0/%r0/retR
      false, // remainder/nR/%r0/%r1/retR
      false, // remainder/nR/%r0/%rR/retR
      false, // remainder/nR/%r1/%r0/retR
      false, // remainder/nR/%r1/%r1/retR
      false, // remainder/nR/%r1/%rR/retR
      false, // remainder/nR/%rR/%r0/retR
      false, // remainder/nR/%rR/%r1/retR
      false, // remainder/nR/%rR/%rR/retR
      false, // remainder/nR/n2/%r0/retR
      false, // remainder/nR/n2/%r1/retR
      false, // remainder/nR/n2/%rR/retR
      false, // remainder/nR/nR/%r0/retR
      false, // remainder/nR/nR/%r1/retR
      false, // remainder/nR/nR/%rR/retR
      false, // remainder-stack/retR
      false, // return-to-undertop
      false, // swap-stack
      false, // times/%r0/%r0/%r0
      false, // times/%r0/%r0/%r1
      false, // times/%r0/%r0/%rR
      false, // times/%r0/%r1/%r0
      false, // times/%r0/%r1/%r1
      false, // times/%r0/%r1/%rR
      false, // times/%r0/%rR/%r0
      false, // times/%r0/%rR/%r1
      false, // times/%r0/%rR/%rR
      false, // times/%r0/n2/%r0
      false, // times/%r0/n2/%r1
      false, // times/%r0/n2/%rR
      false, // times/%r0/nR/%r0
      false, // times/%r0/nR/%r1
      false, // times/%r0/nR/%rR
      false, // times/%r1/%r0/%r0
      false, // times/%r1/%r0/%r1
      false, // times/%r1/%r0/%rR
      false, // times/%r1/%r1/%r0
      false, // times/%r1/%r1/%r1
      false, // times/%r1/%r1/%rR
      false, // times/%r1/%rR/%r0
      false, // times/%r1/%rR/%r1
      false, // times/%r1/%rR/%rR
      false, // times/%r1/n2/%r0
      false, // times/%r1/n2/%r1
      false, // times/%r1/n2/%rR
      false, // times/%r1/nR/%r0
      false, // times/%r1/nR/%r1
      false, // times/%r1/nR/%rR
      false, // times/%rR/%r0/%r0
      false, // times/%rR/%r0/%r1
      false, // times/%rR/%r0/%rR
      false, // times/%rR/%r1/%r0
      false, // times/%rR/%r1/%r1
      false, // times/%rR/%r1/%rR
      false, // times/%rR/%rR/%r0
      false, // times/%rR/%rR/%r1
      false, // times/%rR/%rR/%rR
      false, // times/%rR/n2/%r0
      false, // times/%rR/n2/%r1
      false, // times/%rR/n2/%rR
      false, // times/%rR/nR/%r0
      false, // times/%rR/nR/%r1
      false, // times/%rR/nR/%rR
      false, // times/nR/%r0/%r0
      false, // times/nR/%r0/%r1
      false, // times/nR/%r0/%rR
      false, // times/nR/%r1/%r0
      false, // times/nR/%r1/%r1
      false, // times/nR/%r1/%rR
      false, // times/nR/%rR/%r0
      false, // times/nR/%rR/%r1
      false, // times/nR/%rR/%rR
      false, // times/nR/n2/%r0
      false, // times/nR/n2/%r1
      false, // times/nR/n2/%rR
      false, // times/nR/nR/%r0
      false, // times/nR/nR/%r1
      false, // times/nR/nR/%rR
      false, // times-stack
      false, // uminus/%r0/%r0
      false, // uminus/%r0/%r1
      false, // uminus/%r0/%rR
      false, // uminus/%r1/%r0
      false, // uminus/%r1/%r1
      false, // uminus/%r1/%rR
      false, // uminus/%rR/%r0
      false, // uminus/%rR/%r1
      false, // uminus/%rR/%rR
      false, // uminus/nR/%r0
      false, // uminus/nR/%r1
      false, // uminus/nR/%rR
      false, // uminus-stack
      false, // underpop-stack/%r0
      false, // underpop-stack/%r1
      false, // underpop-stack/%rR
      false, // underpush-stack/%r0
      false, // underpush-stack/%r1
      false, // underpush-stack/%rR
      false, // underpush-stack/nR
      false, // unreachable
      false, // !REPLACEMENT-b/fR/retR
      false, // !REPLACEMENT-be/%r0/%r0/fR/retR
      false, // !REPLACEMENT-be/%r0/%r1/fR/retR
      false, // !REPLACEMENT-be/%r0/%rR/fR/retR
      false, // !REPLACEMENT-be/%r0/n0/fR/retR
      false, // !REPLACEMENT-be/%r0/nR/fR/retR
      false, // !REPLACEMENT-be/%r1/%r0/fR/retR
      false, // !REPLACEMENT-be/%r1/%r1/fR/retR
      false, // !REPLACEMENT-be/%r1/%rR/fR/retR
      false, // !REPLACEMENT-be/%r1/n0/fR/retR
      false, // !REPLACEMENT-be/%r1/nR/fR/retR
      false, // !REPLACEMENT-be/%rR/%r0/fR/retR
      false, // !REPLACEMENT-be/%rR/%r1/fR/retR
      false, // !REPLACEMENT-be/%rR/%rR/fR/retR
      false, // !REPLACEMENT-be/%rR/n0/fR/retR
      false, // !REPLACEMENT-be/%rR/nR/fR/retR
      false, // !REPLACEMENT-be/n0/%r0/fR/retR
      false, // !REPLACEMENT-be/n0/%r1/fR/retR
      false, // !REPLACEMENT-be/n0/%rR/fR/retR
      false, // !REPLACEMENT-be/n0/n0/fR/retR
      false, // !REPLACEMENT-be/n0/nR/fR/retR
      false, // !REPLACEMENT-be/nR/%r0/fR/retR
      false, // !REPLACEMENT-be/nR/%r1/fR/retR
      false, // !REPLACEMENT-be/nR/%rR/fR/retR
      false, // !REPLACEMENT-be/nR/n0/fR/retR
      false, // !REPLACEMENT-be/nR/nR/fR/retR
      false, // !REPLACEMENT-beqi-stack/n-1/fR/retR
      false, // !REPLACEMENT-beqi-stack/n0/fR/retR
      false, // !REPLACEMENT-beqi-stack/n1/fR/retR
      false, // !REPLACEMENT-beqi-stack/n2/fR/retR
      false, // !REPLACEMENT-beqi-stack/nR/fR/retR
      false, // !REPLACEMENT-bf-stack/fR/retR
      false, // !REPLACEMENT-bg/%r0/%r0/fR/retR
      false, // !REPLACEMENT-bg/%r0/%r1/fR/retR
      false, // !REPLACEMENT-bg/%r0/%rR/fR/retR
      false, // !REPLACEMENT-bg/%r0/n0/fR/retR
      false, // !REPLACEMENT-bg/%r0/nR/fR/retR
      false, // !REPLACEMENT-bg/%r1/%r0/fR/retR
      false, // !REPLACEMENT-bg/%r1/%r1/fR/retR
      false, // !REPLACEMENT-bg/%r1/%rR/fR/retR
      false, // !REPLACEMENT-bg/%r1/n0/fR/retR
      false, // !REPLACEMENT-bg/%r1/nR/fR/retR
      false, // !REPLACEMENT-bg/%rR/%r0/fR/retR
      false, // !REPLACEMENT-bg/%rR/%r1/fR/retR
      false, // !REPLACEMENT-bg/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bg/%rR/n0/fR/retR
      false, // !REPLACEMENT-bg/%rR/nR/fR/retR
      false, // !REPLACEMENT-bg/n0/%r0/fR/retR
      false, // !REPLACEMENT-bg/n0/%r1/fR/retR
      false, // !REPLACEMENT-bg/n0/%rR/fR/retR
      false, // !REPLACEMENT-bg/n0/n0/fR/retR
      false, // !REPLACEMENT-bg/n0/nR/fR/retR
      false, // !REPLACEMENT-bg/nR/%r0/fR/retR
      false, // !REPLACEMENT-bg/nR/%r1/fR/retR
      false, // !REPLACEMENT-bg/nR/%rR/fR/retR
      false, // !REPLACEMENT-bg/nR/n0/fR/retR
      false, // !REPLACEMENT-bg/nR/nR/fR/retR
      false, // !REPLACEMENT-bge/%r0/%r0/fR/retR
      false, // !REPLACEMENT-bge/%r0/%r1/fR/retR
      false, // !REPLACEMENT-bge/%r0/%rR/fR/retR
      false, // !REPLACEMENT-bge/%r0/n0/fR/retR
      false, // !REPLACEMENT-bge/%r0/nR/fR/retR
      false, // !REPLACEMENT-bge/%r1/%r0/fR/retR
      false, // !REPLACEMENT-bge/%r1/%r1/fR/retR
      false, // !REPLACEMENT-bge/%r1/%rR/fR/retR
      false, // !REPLACEMENT-bge/%r1/n0/fR/retR
      false, // !REPLACEMENT-bge/%r1/nR/fR/retR
      false, // !REPLACEMENT-bge/%rR/%r0/fR/retR
      false, // !REPLACEMENT-bge/%rR/%r1/fR/retR
      false, // !REPLACEMENT-bge/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bge/%rR/n0/fR/retR
      false, // !REPLACEMENT-bge/%rR/nR/fR/retR
      false, // !REPLACEMENT-bge/n0/%r0/fR/retR
      false, // !REPLACEMENT-bge/n0/%r1/fR/retR
      false, // !REPLACEMENT-bge/n0/%rR/fR/retR
      false, // !REPLACEMENT-bge/n0/n0/fR/retR
      false, // !REPLACEMENT-bge/n0/nR/fR/retR
      false, // !REPLACEMENT-bge/nR/%r0/fR/retR
      false, // !REPLACEMENT-bge/nR/%r1/fR/retR
      false, // !REPLACEMENT-bge/nR/%rR/fR/retR
      false, // !REPLACEMENT-bge/nR/n0/fR/retR
      false, // !REPLACEMENT-bge/nR/nR/fR/retR
      false, // !REPLACEMENT-bl/%r0/%r0/fR/retR
      false, // !REPLACEMENT-bl/%r0/%r1/fR/retR
      false, // !REPLACEMENT-bl/%r0/%rR/fR/retR
      false, // !REPLACEMENT-bl/%r0/n0/fR/retR
      false, // !REPLACEMENT-bl/%r0/nR/fR/retR
      false, // !REPLACEMENT-bl/%r1/%r0/fR/retR
      false, // !REPLACEMENT-bl/%r1/%r1/fR/retR
      false, // !REPLACEMENT-bl/%r1/%rR/fR/retR
      false, // !REPLACEMENT-bl/%r1/n0/fR/retR
      false, // !REPLACEMENT-bl/%r1/nR/fR/retR
      false, // !REPLACEMENT-bl/%rR/%r0/fR/retR
      false, // !REPLACEMENT-bl/%rR/%r1/fR/retR
      false, // !REPLACEMENT-bl/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bl/%rR/n0/fR/retR
      false, // !REPLACEMENT-bl/%rR/nR/fR/retR
      false, // !REPLACEMENT-bl/n0/%r0/fR/retR
      false, // !REPLACEMENT-bl/n0/%r1/fR/retR
      false, // !REPLACEMENT-bl/n0/%rR/fR/retR
      false, // !REPLACEMENT-bl/n0/n0/fR/retR
      false, // !REPLACEMENT-bl/n0/nR/fR/retR
      false, // !REPLACEMENT-bl/nR/%r0/fR/retR
      false, // !REPLACEMENT-bl/nR/%r1/fR/retR
      false, // !REPLACEMENT-bl/nR/%rR/fR/retR
      false, // !REPLACEMENT-bl/nR/n0/fR/retR
      false, // !REPLACEMENT-bl/nR/nR/fR/retR
      false, // !REPLACEMENT-ble/%r0/%r0/fR/retR
      false, // !REPLACEMENT-ble/%r0/%r1/fR/retR
      false, // !REPLACEMENT-ble/%r0/%rR/fR/retR
      false, // !REPLACEMENT-ble/%r0/n0/fR/retR
      false, // !REPLACEMENT-ble/%r0/nR/fR/retR
      false, // !REPLACEMENT-ble/%r1/%r0/fR/retR
      false, // !REPLACEMENT-ble/%r1/%r1/fR/retR
      false, // !REPLACEMENT-ble/%r1/%rR/fR/retR
      false, // !REPLACEMENT-ble/%r1/n0/fR/retR
      false, // !REPLACEMENT-ble/%r1/nR/fR/retR
      false, // !REPLACEMENT-ble/%rR/%r0/fR/retR
      false, // !REPLACEMENT-ble/%rR/%r1/fR/retR
      false, // !REPLACEMENT-ble/%rR/%rR/fR/retR
      false, // !REPLACEMENT-ble/%rR/n0/fR/retR
      false, // !REPLACEMENT-ble/%rR/nR/fR/retR
      false, // !REPLACEMENT-ble/n0/%r0/fR/retR
      false, // !REPLACEMENT-ble/n0/%r1/fR/retR
      false, // !REPLACEMENT-ble/n0/%rR/fR/retR
      false, // !REPLACEMENT-ble/n0/n0/fR/retR
      false, // !REPLACEMENT-ble/n0/nR/fR/retR
      false, // !REPLACEMENT-ble/nR/%r0/fR/retR
      false, // !REPLACEMENT-ble/nR/%r1/fR/retR
      false, // !REPLACEMENT-ble/nR/%rR/fR/retR
      false, // !REPLACEMENT-ble/nR/n0/fR/retR
      false, // !REPLACEMENT-ble/nR/nR/fR/retR
      false, // !REPLACEMENT-bne/%r0/%r0/fR/retR
      false, // !REPLACEMENT-bne/%r0/%r1/fR/retR
      false, // !REPLACEMENT-bne/%r0/%rR/fR/retR
      false, // !REPLACEMENT-bne/%r0/n0/fR/retR
      false, // !REPLACEMENT-bne/%r0/nR/fR/retR
      false, // !REPLACEMENT-bne/%r1/%r0/fR/retR
      false, // !REPLACEMENT-bne/%r1/%r1/fR/retR
      false, // !REPLACEMENT-bne/%r1/%rR/fR/retR
      false, // !REPLACEMENT-bne/%r1/n0/fR/retR
      false, // !REPLACEMENT-bne/%r1/nR/fR/retR
      false, // !REPLACEMENT-bne/%rR/%r0/fR/retR
      false, // !REPLACEMENT-bne/%rR/%r1/fR/retR
      false, // !REPLACEMENT-bne/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bne/%rR/n0/fR/retR
      false, // !REPLACEMENT-bne/%rR/nR/fR/retR
      false, // !REPLACEMENT-bne/n0/%r0/fR/retR
      false, // !REPLACEMENT-bne/n0/%r1/fR/retR
      false, // !REPLACEMENT-bne/n0/%rR/fR/retR
      false, // !REPLACEMENT-bne/n0/n0/fR/retR
      false, // !REPLACEMENT-bne/n0/nR/fR/retR
      false, // !REPLACEMENT-bne/nR/%r0/fR/retR
      false, // !REPLACEMENT-bne/nR/%r1/fR/retR
      false, // !REPLACEMENT-bne/nR/%rR/fR/retR
      false, // !REPLACEMENT-bne/nR/n0/fR/retR
      false, // !REPLACEMENT-bne/nR/nR/fR/retR
      false, // !REPLACEMENT-bneqi-stack/n-1/fR/retR
      false, // !REPLACEMENT-bneqi-stack/n0/fR/retR
      false, // !REPLACEMENT-bneqi-stack/n1/fR/retR
      false, // !REPLACEMENT-bneqi-stack/n2/fR/retR
      false, // !REPLACEMENT-bneqi-stack/nR/fR/retR
      false, // !REPLACEMENT-bt-stack/fR/retR
      true, // !REPLACEMENT-call/fR/retR
      false, // !REPLACEMENT-exitvm/retR
      false, // !REPLACEMENT-procedure-prolog/retR
      false, // !REPLACEMENT-return-to-undertop/retR
      false // !REPLACEMENT-unreachable/retR
    };

// FIXME: this is not currently accessed, and in fact may be useless.
const bool
structuredvm_specialized_instruction_callees [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
      false, // !INVALID
      false, // !BEGINBASICBLOCK
      false, // !EXITVM
      false, // !DATALOCATIONS
      false, // !NOP
      false, // !UNREACHABLE0
      false, // !UNREACHABLE1
      false, // !PRETENDTOJUMPANYWHERE
      false, // b/fR
      false, // be/%r0/%r0/fR
      false, // be/%r0/%r1/fR
      false, // be/%r0/%rR/fR
      false, // be/%r0/n0/fR
      false, // be/%r0/nR/fR
      false, // be/%r1/%r0/fR
      false, // be/%r1/%r1/fR
      false, // be/%r1/%rR/fR
      false, // be/%r1/n0/fR
      false, // be/%r1/nR/fR
      false, // be/%rR/%r0/fR
      false, // be/%rR/%r1/fR
      false, // be/%rR/%rR/fR
      false, // be/%rR/n0/fR
      false, // be/%rR/nR/fR
      false, // be/n0/%r0/fR
      false, // be/n0/%r1/fR
      false, // be/n0/%rR/fR
      false, // be/n0/n0/fR
      false, // be/n0/nR/fR
      false, // be/nR/%r0/fR
      false, // be/nR/%r1/fR
      false, // be/nR/%rR/fR
      false, // be/nR/n0/fR
      false, // be/nR/nR/fR
      false, // beqi-stack/n-1/fR
      false, // beqi-stack/n0/fR
      false, // beqi-stack/n1/fR
      false, // beqi-stack/n2/fR
      false, // beqi-stack/nR/fR
      false, // bf-stack/fR
      false, // bg/%r0/%r0/fR
      false, // bg/%r0/%r1/fR
      false, // bg/%r0/%rR/fR
      false, // bg/%r0/n0/fR
      false, // bg/%r0/nR/fR
      false, // bg/%r1/%r0/fR
      false, // bg/%r1/%r1/fR
      false, // bg/%r1/%rR/fR
      false, // bg/%r1/n0/fR
      false, // bg/%r1/nR/fR
      false, // bg/%rR/%r0/fR
      false, // bg/%rR/%r1/fR
      false, // bg/%rR/%rR/fR
      false, // bg/%rR/n0/fR
      false, // bg/%rR/nR/fR
      false, // bg/n0/%r0/fR
      false, // bg/n0/%r1/fR
      false, // bg/n0/%rR/fR
      false, // bg/n0/n0/fR
      false, // bg/n0/nR/fR
      false, // bg/nR/%r0/fR
      false, // bg/nR/%r1/fR
      false, // bg/nR/%rR/fR
      false, // bg/nR/n0/fR
      false, // bg/nR/nR/fR
      false, // bge/%r0/%r0/fR
      false, // bge/%r0/%r1/fR
      false, // bge/%r0/%rR/fR
      false, // bge/%r0/n0/fR
      false, // bge/%r0/nR/fR
      false, // bge/%r1/%r0/fR
      false, // bge/%r1/%r1/fR
      false, // bge/%r1/%rR/fR
      false, // bge/%r1/n0/fR
      false, // bge/%r1/nR/fR
      false, // bge/%rR/%r0/fR
      false, // bge/%rR/%r1/fR
      false, // bge/%rR/%rR/fR
      false, // bge/%rR/n0/fR
      false, // bge/%rR/nR/fR
      false, // bge/n0/%r0/fR
      false, // bge/n0/%r1/fR
      false, // bge/n0/%rR/fR
      false, // bge/n0/n0/fR
      false, // bge/n0/nR/fR
      false, // bge/nR/%r0/fR
      false, // bge/nR/%r1/fR
      false, // bge/nR/%rR/fR
      false, // bge/nR/n0/fR
      false, // bge/nR/nR/fR
      false, // bl/%r0/%r0/fR
      false, // bl/%r0/%r1/fR
      false, // bl/%r0/%rR/fR
      false, // bl/%r0/n0/fR
      false, // bl/%r0/nR/fR
      false, // bl/%r1/%r0/fR
      false, // bl/%r1/%r1/fR
      false, // bl/%r1/%rR/fR
      false, // bl/%r1/n0/fR
      false, // bl/%r1/nR/fR
      false, // bl/%rR/%r0/fR
      false, // bl/%rR/%r1/fR
      false, // bl/%rR/%rR/fR
      false, // bl/%rR/n0/fR
      false, // bl/%rR/nR/fR
      false, // bl/n0/%r0/fR
      false, // bl/n0/%r1/fR
      false, // bl/n0/%rR/fR
      false, // bl/n0/n0/fR
      false, // bl/n0/nR/fR
      false, // bl/nR/%r0/fR
      false, // bl/nR/%r1/fR
      false, // bl/nR/%rR/fR
      false, // bl/nR/n0/fR
      false, // bl/nR/nR/fR
      false, // ble/%r0/%r0/fR
      false, // ble/%r0/%r1/fR
      false, // ble/%r0/%rR/fR
      false, // ble/%r0/n0/fR
      false, // ble/%r0/nR/fR
      false, // ble/%r1/%r0/fR
      false, // ble/%r1/%r1/fR
      false, // ble/%r1/%rR/fR
      false, // ble/%r1/n0/fR
      false, // ble/%r1/nR/fR
      false, // ble/%rR/%r0/fR
      false, // ble/%rR/%r1/fR
      false, // ble/%rR/%rR/fR
      false, // ble/%rR/n0/fR
      false, // ble/%rR/nR/fR
      false, // ble/n0/%r0/fR
      false, // ble/n0/%r1/fR
      false, // ble/n0/%rR/fR
      false, // ble/n0/n0/fR
      false, // ble/n0/nR/fR
      false, // ble/nR/%r0/fR
      false, // ble/nR/%r1/fR
      false, // ble/nR/%rR/fR
      false, // ble/nR/n0/fR
      false, // ble/nR/nR/fR
      false, // bne/%r0/%r0/fR
      false, // bne/%r0/%r1/fR
      false, // bne/%r0/%rR/fR
      false, // bne/%r0/n0/fR
      false, // bne/%r0/nR/fR
      false, // bne/%r1/%r0/fR
      false, // bne/%r1/%r1/fR
      false, // bne/%r1/%rR/fR
      false, // bne/%r1/n0/fR
      false, // bne/%r1/nR/fR
      false, // bne/%rR/%r0/fR
      false, // bne/%rR/%r1/fR
      false, // bne/%rR/%rR/fR
      false, // bne/%rR/n0/fR
      false, // bne/%rR/nR/fR
      false, // bne/n0/%r0/fR
      false, // bne/n0/%r1/fR
      false, // bne/n0/%rR/fR
      false, // bne/n0/n0/fR
      false, // bne/n0/nR/fR
      false, // bne/nR/%r0/fR
      false, // bne/nR/%r1/fR
      false, // bne/nR/%rR/fR
      false, // bne/nR/n0/fR
      false, // bne/nR/nR/fR
      false, // bneqi-stack/n-1/fR
      false, // bneqi-stack/n0/fR
      false, // bneqi-stack/n1/fR
      false, // bneqi-stack/n2/fR
      false, // bneqi-stack/nR/fR
      false, // bt-stack/fR
      false, // call/fR/retR
      false, // copy-to-r-stack/%r0
      false, // copy-to-r-stack/%r1
      false, // copy-to-r-stack/%rR
      false, // different-stack
      false, // divided/%r0/%r0/%r0/retR
      false, // divided/%r0/%r0/%r1/retR
      false, // divided/%r0/%r0/%rR/retR
      false, // divided/%r0/%r1/%r0/retR
      false, // divided/%r0/%r1/%r1/retR
      false, // divided/%r0/%r1/%rR/retR
      false, // divided/%r0/%rR/%r0/retR
      false, // divided/%r0/%rR/%r1/retR
      false, // divided/%r0/%rR/%rR/retR
      false, // divided/%r0/n2/%r0/retR
      false, // divided/%r0/n2/%r1/retR
      false, // divided/%r0/n2/%rR/retR
      false, // divided/%r0/nR/%r0/retR
      false, // divided/%r0/nR/%r1/retR
      false, // divided/%r0/nR/%rR/retR
      false, // divided/%r1/%r0/%r0/retR
      false, // divided/%r1/%r0/%r1/retR
      false, // divided/%r1/%r0/%rR/retR
      false, // divided/%r1/%r1/%r0/retR
      false, // divided/%r1/%r1/%r1/retR
      false, // divided/%r1/%r1/%rR/retR
      false, // divided/%r1/%rR/%r0/retR
      false, // divided/%r1/%rR/%r1/retR
      false, // divided/%r1/%rR/%rR/retR
      false, // divided/%r1/n2/%r0/retR
      false, // divided/%r1/n2/%r1/retR
      false, // divided/%r1/n2/%rR/retR
      false, // divided/%r1/nR/%r0/retR
      false, // divided/%r1/nR/%r1/retR
      false, // divided/%r1/nR/%rR/retR
      false, // divided/%rR/%r0/%r0/retR
      false, // divided/%rR/%r0/%r1/retR
      false, // divided/%rR/%r0/%rR/retR
      false, // divided/%rR/%r1/%r0/retR
      false, // divided/%rR/%r1/%r1/retR
      false, // divided/%rR/%r1/%rR/retR
      false, // divided/%rR/%rR/%r0/retR
      false, // divided/%rR/%rR/%r1/retR
      false, // divided/%rR/%rR/%rR/retR
      false, // divided/%rR/n2/%r0/retR
      false, // divided/%rR/n2/%r1/retR
      false, // divided/%rR/n2/%rR/retR
      false, // divided/%rR/nR/%r0/retR
      false, // divided/%rR/nR/%r1/retR
      false, // divided/%rR/nR/%rR/retR
      false, // divided/nR/%r0/%r0/retR
      false, // divided/nR/%r0/%r1/retR
      false, // divided/nR/%r0/%rR/retR
      false, // divided/nR/%r1/%r0/retR
      false, // divided/nR/%r1/%r1/retR
      false, // divided/nR/%r1/%rR/retR
      false, // divided/nR/%rR/%r0/retR
      false, // divided/nR/%rR/%r1/retR
      false, // divided/nR/%rR/%rR/retR
      false, // divided/nR/n2/%r0/retR
      false, // divided/nR/n2/%r1/retR
      false, // divided/nR/n2/%rR/retR
      false, // divided/nR/nR/%r0/retR
      false, // divided/nR/nR/%r1/retR
      false, // divided/nR/nR/%rR/retR
      false, // divided-stack/retR
      false, // drop-stack
      false, // dup-stack
      false, // equal-stack
      false, // equali-stack/n0
      false, // equali-stack/n1
      false, // equali-stack/n2
      false, // equali-stack/nR
      false, // exitvm
      false, // greater-stack
      false, // greaterorequal-stack
      false, // input/%r0/retR
      false, // input/%r1/retR
      false, // input/%rR/retR
      false, // input-stack/retR
      false, // isnonzero-stack
      false, // less-stack
      false, // lessorequal-stack
      false, // load-boxed-literal/n0/%r0
      false, // load-boxed-literal/n0/%r1
      false, // load-boxed-literal/n0/%rR
      false, // load-boxed-literal/n1/%r0
      false, // load-boxed-literal/n1/%r1
      false, // load-boxed-literal/n1/%rR
      false, // load-boxed-literal/n2/%r0
      false, // load-boxed-literal/n2/%r1
      false, // load-boxed-literal/n2/%rR
      false, // load-boxed-literal/n3/%r0
      false, // load-boxed-literal/n3/%r1
      false, // load-boxed-literal/n3/%rR
      false, // load-boxed-literal/n4/%r0
      false, // load-boxed-literal/n4/%r1
      false, // load-boxed-literal/n4/%rR
      false, // load-boxed-literal/n5/%r0
      false, // load-boxed-literal/n5/%r1
      false, // load-boxed-literal/n5/%rR
      false, // load-boxed-literal/n6/%r0
      false, // load-boxed-literal/n6/%r1
      false, // load-boxed-literal/n6/%rR
      false, // load-boxed-literal/n7/%r0
      false, // load-boxed-literal/n7/%r1
      false, // load-boxed-literal/n7/%rR
      false, // load-boxed-literal/n8/%r0
      false, // load-boxed-literal/n8/%r1
      false, // load-boxed-literal/n8/%rR
      false, // load-boxed-literal/n9/%r0
      false, // load-boxed-literal/n9/%r1
      false, // load-boxed-literal/n9/%rR
      false, // load-boxed-literal/n10/%r0
      false, // load-boxed-literal/n10/%r1
      false, // load-boxed-literal/n10/%rR
      false, // load-boxed-literal/nR/%r0
      false, // load-boxed-literal/nR/%r1
      false, // load-boxed-literal/nR/%rR
      false, // logicaland-stack
      false, // logicalnot-stack
      false, // logicalor-stack
      false, // minus/%r0/%r0/%r0
      false, // minus/%r0/%r0/%r1
      false, // minus/%r0/%r0/%rR
      false, // minus/%r0/%r1/%r0
      false, // minus/%r0/%r1/%r1
      false, // minus/%r0/%r1/%rR
      false, // minus/%r0/%rR/%r0
      false, // minus/%r0/%rR/%r1
      false, // minus/%r0/%rR/%rR
      false, // minus/%r0/n1/%r0
      false, // minus/%r0/n1/%r1
      false, // minus/%r0/n1/%rR
      false, // minus/%r0/n2/%r0
      false, // minus/%r0/n2/%r1
      false, // minus/%r0/n2/%rR
      false, // minus/%r0/nR/%r0
      false, // minus/%r0/nR/%r1
      false, // minus/%r0/nR/%rR
      false, // minus/%r1/%r0/%r0
      false, // minus/%r1/%r0/%r1
      false, // minus/%r1/%r0/%rR
      false, // minus/%r1/%r1/%r0
      false, // minus/%r1/%r1/%r1
      false, // minus/%r1/%r1/%rR
      false, // minus/%r1/%rR/%r0
      false, // minus/%r1/%rR/%r1
      false, // minus/%r1/%rR/%rR
      false, // minus/%r1/n1/%r0
      false, // minus/%r1/n1/%r1
      false, // minus/%r1/n1/%rR
      false, // minus/%r1/n2/%r0
      false, // minus/%r1/n2/%r1
      false, // minus/%r1/n2/%rR
      false, // minus/%r1/nR/%r0
      false, // minus/%r1/nR/%r1
      false, // minus/%r1/nR/%rR
      false, // minus/%rR/%r0/%r0
      false, // minus/%rR/%r0/%r1
      false, // minus/%rR/%r0/%rR
      false, // minus/%rR/%r1/%r0
      false, // minus/%rR/%r1/%r1
      false, // minus/%rR/%r1/%rR
      false, // minus/%rR/%rR/%r0
      false, // minus/%rR/%rR/%r1
      false, // minus/%rR/%rR/%rR
      false, // minus/%rR/n1/%r0
      false, // minus/%rR/n1/%r1
      false, // minus/%rR/n1/%rR
      false, // minus/%rR/n2/%r0
      false, // minus/%rR/n2/%r1
      false, // minus/%rR/n2/%rR
      false, // minus/%rR/nR/%r0
      false, // minus/%rR/nR/%r1
      false, // minus/%rR/nR/%rR
      false, // minus/nR/%r0/%r0
      false, // minus/nR/%r0/%r1
      false, // minus/nR/%r0/%rR
      false, // minus/nR/%r1/%r0
      false, // minus/nR/%r1/%r1
      false, // minus/nR/%r1/%rR
      false, // minus/nR/%rR/%r0
      false, // minus/nR/%rR/%r1
      false, // minus/nR/%rR/%rR
      false, // minus/nR/n1/%r0
      false, // minus/nR/n1/%r1
      false, // minus/nR/n1/%rR
      false, // minus/nR/n2/%r0
      false, // minus/nR/n2/%r1
      false, // minus/nR/n2/%rR
      false, // minus/nR/nR/%r0
      false, // minus/nR/nR/%r1
      false, // minus/nR/nR/%rR
      false, // minus-stack
      false, // minusi-stack/n1
      false, // minusi-stack/n2
      false, // minusi-stack/nR
      false, // mov/%r0/%r0
      false, // mov/%r0/%r1
      false, // mov/%r0/%rR
      false, // mov/%r1/%r0
      false, // mov/%r1/%r1
      false, // mov/%r1/%rR
      false, // mov/%rR/%r0
      false, // mov/%rR/%r1
      false, // mov/%rR/%rR
      false, // mov/n0/%r0
      false, // mov/n0/%r1
      false, // mov/n0/%rR
      false, // mov/n1/%r0
      false, // mov/n1/%r1
      false, // mov/n1/%rR
      false, // mov/n-1/%r0
      false, // mov/n-1/%r1
      false, // mov/n-1/%rR
      false, // mov/n2/%r0
      false, // mov/n2/%r1
      false, // mov/n2/%rR
      false, // mov/nR/%r0
      false, // mov/nR/%r1
      false, // mov/nR/%rR
      false, // plus/%r0/%r0/%r0
      false, // plus/%r0/%r0/%r1
      false, // plus/%r0/%r0/%rR
      false, // plus/%r0/%r1/%r0
      false, // plus/%r0/%r1/%r1
      false, // plus/%r0/%r1/%rR
      false, // plus/%r0/%rR/%r0
      false, // plus/%r0/%rR/%r1
      false, // plus/%r0/%rR/%rR
      false, // plus/%r0/n1/%r0
      false, // plus/%r0/n1/%r1
      false, // plus/%r0/n1/%rR
      false, // plus/%r0/n2/%r0
      false, // plus/%r0/n2/%r1
      false, // plus/%r0/n2/%rR
      false, // plus/%r0/nR/%r0
      false, // plus/%r0/nR/%r1
      false, // plus/%r0/nR/%rR
      false, // plus/%r1/%r0/%r0
      false, // plus/%r1/%r0/%r1
      false, // plus/%r1/%r0/%rR
      false, // plus/%r1/%r1/%r0
      false, // plus/%r1/%r1/%r1
      false, // plus/%r1/%r1/%rR
      false, // plus/%r1/%rR/%r0
      false, // plus/%r1/%rR/%r1
      false, // plus/%r1/%rR/%rR
      false, // plus/%r1/n1/%r0
      false, // plus/%r1/n1/%r1
      false, // plus/%r1/n1/%rR
      false, // plus/%r1/n2/%r0
      false, // plus/%r1/n2/%r1
      false, // plus/%r1/n2/%rR
      false, // plus/%r1/nR/%r0
      false, // plus/%r1/nR/%r1
      false, // plus/%r1/nR/%rR
      false, // plus/%rR/%r0/%r0
      false, // plus/%rR/%r0/%r1
      false, // plus/%rR/%r0/%rR
      false, // plus/%rR/%r1/%r0
      false, // plus/%rR/%r1/%r1
      false, // plus/%rR/%r1/%rR
      false, // plus/%rR/%rR/%r0
      false, // plus/%rR/%rR/%r1
      false, // plus/%rR/%rR/%rR
      false, // plus/%rR/n1/%r0
      false, // plus/%rR/n1/%r1
      false, // plus/%rR/n1/%rR
      false, // plus/%rR/n2/%r0
      false, // plus/%rR/n2/%r1
      false, // plus/%rR/n2/%rR
      false, // plus/%rR/nR/%r0
      false, // plus/%rR/nR/%r1
      false, // plus/%rR/nR/%rR
      false, // plus/n1/%r0/%r0
      false, // plus/n1/%r0/%r1
      false, // plus/n1/%r0/%rR
      false, // plus/n1/%r1/%r0
      false, // plus/n1/%r1/%r1
      false, // plus/n1/%r1/%rR
      false, // plus/n1/%rR/%r0
      false, // plus/n1/%rR/%r1
      false, // plus/n1/%rR/%rR
      false, // plus/n1/n1/%r0
      false, // plus/n1/n1/%r1
      false, // plus/n1/n1/%rR
      false, // plus/n1/n2/%r0
      false, // plus/n1/n2/%r1
      false, // plus/n1/n2/%rR
      false, // plus/n1/nR/%r0
      false, // plus/n1/nR/%r1
      false, // plus/n1/nR/%rR
      false, // plus/n2/%r0/%r0
      false, // plus/n2/%r0/%r1
      false, // plus/n2/%r0/%rR
      false, // plus/n2/%r1/%r0
      false, // plus/n2/%r1/%r1
      false, // plus/n2/%r1/%rR
      false, // plus/n2/%rR/%r0
      false, // plus/n2/%rR/%r1
      false, // plus/n2/%rR/%rR
      false, // plus/n2/n1/%r0
      false, // plus/n2/n1/%r1
      false, // plus/n2/n1/%rR
      false, // plus/n2/n2/%r0
      false, // plus/n2/n2/%r1
      false, // plus/n2/n2/%rR
      false, // plus/n2/nR/%r0
      false, // plus/n2/nR/%r1
      false, // plus/n2/nR/%rR
      false, // plus/nR/%r0/%r0
      false, // plus/nR/%r0/%r1
      false, // plus/nR/%r0/%rR
      false, // plus/nR/%r1/%r0
      false, // plus/nR/%r1/%r1
      false, // plus/nR/%r1/%rR
      false, // plus/nR/%rR/%r0
      false, // plus/nR/%rR/%r1
      false, // plus/nR/%rR/%rR
      false, // plus/nR/n1/%r0
      false, // plus/nR/n1/%r1
      false, // plus/nR/n1/%rR
      false, // plus/nR/n2/%r0
      false, // plus/nR/n2/%r1
      false, // plus/nR/n2/%rR
      false, // plus/nR/nR/%r0
      false, // plus/nR/nR/%r1
      false, // plus/nR/nR/%rR
      false, // plus-stack
      false, // plusi-stack/n-1
      false, // plusi-stack/n1
      false, // plusi-stack/n2
      false, // plusi-stack/nR
      false, // pop-stack/%r0
      false, // pop-stack/%r1
      false, // pop-stack/%rR
      false, // print/%r0/retR
      false, // print/%r1/retR
      false, // print/%rR/retR
      false, // print/nR/retR
      false, // print-stack/retR
      true, // procedure-prolog
      false, // push-boxed-literal/n0
      false, // push-boxed-literal/n1
      false, // push-boxed-literal/n2
      false, // push-boxed-literal/n3
      false, // push-boxed-literal/n4
      false, // push-boxed-literal/n5
      false, // push-boxed-literal/n6
      false, // push-boxed-literal/n7
      false, // push-boxed-literal/n8
      false, // push-boxed-literal/n9
      false, // push-boxed-literal/n10
      false, // push-boxed-literal/nR
      false, // push-stack/%r0
      false, // push-stack/%r1
      false, // push-stack/%rR
      false, // push-stack/n0
      false, // push-stack/n1
      false, // push-stack/n-1
      false, // push-stack/n2
      false, // push-stack/nR
      false, // push-stack/lR
      false, // push-unspecified-stack
      false, // remainder/%r0/%r0/%r0/retR
      false, // remainder/%r0/%r0/%r1/retR
      false, // remainder/%r0/%r0/%rR/retR
      false, // remainder/%r0/%r1/%r0/retR
      false, // remainder/%r0/%r1/%r1/retR
      false, // remainder/%r0/%r1/%rR/retR
      false, // remainder/%r0/%rR/%r0/retR
      false, // remainder/%r0/%rR/%r1/retR
      false, // remainder/%r0/%rR/%rR/retR
      false, // remainder/%r0/n2/%r0/retR
      false, // remainder/%r0/n2/%r1/retR
      false, // remainder/%r0/n2/%rR/retR
      false, // remainder/%r0/nR/%r0/retR
      false, // remainder/%r0/nR/%r1/retR
      false, // remainder/%r0/nR/%rR/retR
      false, // remainder/%r1/%r0/%r0/retR
      false, // remainder/%r1/%r0/%r1/retR
      false, // remainder/%r1/%r0/%rR/retR
      false, // remainder/%r1/%r1/%r0/retR
      false, // remainder/%r1/%r1/%r1/retR
      false, // remainder/%r1/%r1/%rR/retR
      false, // remainder/%r1/%rR/%r0/retR
      false, // remainder/%r1/%rR/%r1/retR
      false, // remainder/%r1/%rR/%rR/retR
      false, // remainder/%r1/n2/%r0/retR
      false, // remainder/%r1/n2/%r1/retR
      false, // remainder/%r1/n2/%rR/retR
      false, // remainder/%r1/nR/%r0/retR
      false, // remainder/%r1/nR/%r1/retR
      false, // remainder/%r1/nR/%rR/retR
      false, // remainder/%rR/%r0/%r0/retR
      false, // remainder/%rR/%r0/%r1/retR
      false, // remainder/%rR/%r0/%rR/retR
      false, // remainder/%rR/%r1/%r0/retR
      false, // remainder/%rR/%r1/%r1/retR
      false, // remainder/%rR/%r1/%rR/retR
      false, // remainder/%rR/%rR/%r0/retR
      false, // remainder/%rR/%rR/%r1/retR
      false, // remainder/%rR/%rR/%rR/retR
      false, // remainder/%rR/n2/%r0/retR
      false, // remainder/%rR/n2/%r1/retR
      false, // remainder/%rR/n2/%rR/retR
      false, // remainder/%rR/nR/%r0/retR
      false, // remainder/%rR/nR/%r1/retR
      false, // remainder/%rR/nR/%rR/retR
      false, // remainder/nR/%r0/%r0/retR
      false, // remainder/nR/%r0/%r1/retR
      false, // remainder/nR/%r0/%rR/retR
      false, // remainder/nR/%r1/%r0/retR
      false, // remainder/nR/%r1/%r1/retR
      false, // remainder/nR/%r1/%rR/retR
      false, // remainder/nR/%rR/%r0/retR
      false, // remainder/nR/%rR/%r1/retR
      false, // remainder/nR/%rR/%rR/retR
      false, // remainder/nR/n2/%r0/retR
      false, // remainder/nR/n2/%r1/retR
      false, // remainder/nR/n2/%rR/retR
      false, // remainder/nR/nR/%r0/retR
      false, // remainder/nR/nR/%r1/retR
      false, // remainder/nR/nR/%rR/retR
      false, // remainder-stack/retR
      false, // return-to-undertop
      false, // swap-stack
      false, // times/%r0/%r0/%r0
      false, // times/%r0/%r0/%r1
      false, // times/%r0/%r0/%rR
      false, // times/%r0/%r1/%r0
      false, // times/%r0/%r1/%r1
      false, // times/%r0/%r1/%rR
      false, // times/%r0/%rR/%r0
      false, // times/%r0/%rR/%r1
      false, // times/%r0/%rR/%rR
      false, // times/%r0/n2/%r0
      false, // times/%r0/n2/%r1
      false, // times/%r0/n2/%rR
      false, // times/%r0/nR/%r0
      false, // times/%r0/nR/%r1
      false, // times/%r0/nR/%rR
      false, // times/%r1/%r0/%r0
      false, // times/%r1/%r0/%r1
      false, // times/%r1/%r0/%rR
      false, // times/%r1/%r1/%r0
      false, // times/%r1/%r1/%r1
      false, // times/%r1/%r1/%rR
      false, // times/%r1/%rR/%r0
      false, // times/%r1/%rR/%r1
      false, // times/%r1/%rR/%rR
      false, // times/%r1/n2/%r0
      false, // times/%r1/n2/%r1
      false, // times/%r1/n2/%rR
      false, // times/%r1/nR/%r0
      false, // times/%r1/nR/%r1
      false, // times/%r1/nR/%rR
      false, // times/%rR/%r0/%r0
      false, // times/%rR/%r0/%r1
      false, // times/%rR/%r0/%rR
      false, // times/%rR/%r1/%r0
      false, // times/%rR/%r1/%r1
      false, // times/%rR/%r1/%rR
      false, // times/%rR/%rR/%r0
      false, // times/%rR/%rR/%r1
      false, // times/%rR/%rR/%rR
      false, // times/%rR/n2/%r0
      false, // times/%rR/n2/%r1
      false, // times/%rR/n2/%rR
      false, // times/%rR/nR/%r0
      false, // times/%rR/nR/%r1
      false, // times/%rR/nR/%rR
      false, // times/nR/%r0/%r0
      false, // times/nR/%r0/%r1
      false, // times/nR/%r0/%rR
      false, // times/nR/%r1/%r0
      false, // times/nR/%r1/%r1
      false, // times/nR/%r1/%rR
      false, // times/nR/%rR/%r0
      false, // times/nR/%rR/%r1
      false, // times/nR/%rR/%rR
      false, // times/nR/n2/%r0
      false, // times/nR/n2/%r1
      false, // times/nR/n2/%rR
      false, // times/nR/nR/%r0
      false, // times/nR/nR/%r1
      false, // times/nR/nR/%rR
      false, // times-stack
      false, // uminus/%r0/%r0
      false, // uminus/%r0/%r1
      false, // uminus/%r0/%rR
      false, // uminus/%r1/%r0
      false, // uminus/%r1/%r1
      false, // uminus/%r1/%rR
      false, // uminus/%rR/%r0
      false, // uminus/%rR/%r1
      false, // uminus/%rR/%rR
      false, // uminus/nR/%r0
      false, // uminus/nR/%r1
      false, // uminus/nR/%rR
      false, // uminus-stack
      false, // underpop-stack/%r0
      false, // underpop-stack/%r1
      false, // underpop-stack/%rR
      false, // underpush-stack/%r0
      false, // underpush-stack/%r1
      false, // underpush-stack/%rR
      false, // underpush-stack/nR
      false, // unreachable
      false, // !REPLACEMENT-b/fR/retR
      false, // !REPLACEMENT-be/%r0/%r0/fR/retR
      false, // !REPLACEMENT-be/%r0/%r1/fR/retR
      false, // !REPLACEMENT-be/%r0/%rR/fR/retR
      false, // !REPLACEMENT-be/%r0/n0/fR/retR
      false, // !REPLACEMENT-be/%r0/nR/fR/retR
      false, // !REPLACEMENT-be/%r1/%r0/fR/retR
      false, // !REPLACEMENT-be/%r1/%r1/fR/retR
      false, // !REPLACEMENT-be/%r1/%rR/fR/retR
      false, // !REPLACEMENT-be/%r1/n0/fR/retR
      false, // !REPLACEMENT-be/%r1/nR/fR/retR
      false, // !REPLACEMENT-be/%rR/%r0/fR/retR
      false, // !REPLACEMENT-be/%rR/%r1/fR/retR
      false, // !REPLACEMENT-be/%rR/%rR/fR/retR
      false, // !REPLACEMENT-be/%rR/n0/fR/retR
      false, // !REPLACEMENT-be/%rR/nR/fR/retR
      false, // !REPLACEMENT-be/n0/%r0/fR/retR
      false, // !REPLACEMENT-be/n0/%r1/fR/retR
      false, // !REPLACEMENT-be/n0/%rR/fR/retR
      false, // !REPLACEMENT-be/n0/n0/fR/retR
      false, // !REPLACEMENT-be/n0/nR/fR/retR
      false, // !REPLACEMENT-be/nR/%r0/fR/retR
      false, // !REPLACEMENT-be/nR/%r1/fR/retR
      false, // !REPLACEMENT-be/nR/%rR/fR/retR
      false, // !REPLACEMENT-be/nR/n0/fR/retR
      false, // !REPLACEMENT-be/nR/nR/fR/retR
      false, // !REPLACEMENT-beqi-stack/n-1/fR/retR
      false, // !REPLACEMENT-beqi-stack/n0/fR/retR
      false, // !REPLACEMENT-beqi-stack/n1/fR/retR
      false, // !REPLACEMENT-beqi-stack/n2/fR/retR
      false, // !REPLACEMENT-beqi-stack/nR/fR/retR
      false, // !REPLACEMENT-bf-stack/fR/retR
      false, // !REPLACEMENT-bg/%r0/%r0/fR/retR
      false, // !REPLACEMENT-bg/%r0/%r1/fR/retR
      false, // !REPLACEMENT-bg/%r0/%rR/fR/retR
      false, // !REPLACEMENT-bg/%r0/n0/fR/retR
      false, // !REPLACEMENT-bg/%r0/nR/fR/retR
      false, // !REPLACEMENT-bg/%r1/%r0/fR/retR
      false, // !REPLACEMENT-bg/%r1/%r1/fR/retR
      false, // !REPLACEMENT-bg/%r1/%rR/fR/retR
      false, // !REPLACEMENT-bg/%r1/n0/fR/retR
      false, // !REPLACEMENT-bg/%r1/nR/fR/retR
      false, // !REPLACEMENT-bg/%rR/%r0/fR/retR
      false, // !REPLACEMENT-bg/%rR/%r1/fR/retR
      false, // !REPLACEMENT-bg/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bg/%rR/n0/fR/retR
      false, // !REPLACEMENT-bg/%rR/nR/fR/retR
      false, // !REPLACEMENT-bg/n0/%r0/fR/retR
      false, // !REPLACEMENT-bg/n0/%r1/fR/retR
      false, // !REPLACEMENT-bg/n0/%rR/fR/retR
      false, // !REPLACEMENT-bg/n0/n0/fR/retR
      false, // !REPLACEMENT-bg/n0/nR/fR/retR
      false, // !REPLACEMENT-bg/nR/%r0/fR/retR
      false, // !REPLACEMENT-bg/nR/%r1/fR/retR
      false, // !REPLACEMENT-bg/nR/%rR/fR/retR
      false, // !REPLACEMENT-bg/nR/n0/fR/retR
      false, // !REPLACEMENT-bg/nR/nR/fR/retR
      false, // !REPLACEMENT-bge/%r0/%r0/fR/retR
      false, // !REPLACEMENT-bge/%r0/%r1/fR/retR
      false, // !REPLACEMENT-bge/%r0/%rR/fR/retR
      false, // !REPLACEMENT-bge/%r0/n0/fR/retR
      false, // !REPLACEMENT-bge/%r0/nR/fR/retR
      false, // !REPLACEMENT-bge/%r1/%r0/fR/retR
      false, // !REPLACEMENT-bge/%r1/%r1/fR/retR
      false, // !REPLACEMENT-bge/%r1/%rR/fR/retR
      false, // !REPLACEMENT-bge/%r1/n0/fR/retR
      false, // !REPLACEMENT-bge/%r1/nR/fR/retR
      false, // !REPLACEMENT-bge/%rR/%r0/fR/retR
      false, // !REPLACEMENT-bge/%rR/%r1/fR/retR
      false, // !REPLACEMENT-bge/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bge/%rR/n0/fR/retR
      false, // !REPLACEMENT-bge/%rR/nR/fR/retR
      false, // !REPLACEMENT-bge/n0/%r0/fR/retR
      false, // !REPLACEMENT-bge/n0/%r1/fR/retR
      false, // !REPLACEMENT-bge/n0/%rR/fR/retR
      false, // !REPLACEMENT-bge/n0/n0/fR/retR
      false, // !REPLACEMENT-bge/n0/nR/fR/retR
      false, // !REPLACEMENT-bge/nR/%r0/fR/retR
      false, // !REPLACEMENT-bge/nR/%r1/fR/retR
      false, // !REPLACEMENT-bge/nR/%rR/fR/retR
      false, // !REPLACEMENT-bge/nR/n0/fR/retR
      false, // !REPLACEMENT-bge/nR/nR/fR/retR
      false, // !REPLACEMENT-bl/%r0/%r0/fR/retR
      false, // !REPLACEMENT-bl/%r0/%r1/fR/retR
      false, // !REPLACEMENT-bl/%r0/%rR/fR/retR
      false, // !REPLACEMENT-bl/%r0/n0/fR/retR
      false, // !REPLACEMENT-bl/%r0/nR/fR/retR
      false, // !REPLACEMENT-bl/%r1/%r0/fR/retR
      false, // !REPLACEMENT-bl/%r1/%r1/fR/retR
      false, // !REPLACEMENT-bl/%r1/%rR/fR/retR
      false, // !REPLACEMENT-bl/%r1/n0/fR/retR
      false, // !REPLACEMENT-bl/%r1/nR/fR/retR
      false, // !REPLACEMENT-bl/%rR/%r0/fR/retR
      false, // !REPLACEMENT-bl/%rR/%r1/fR/retR
      false, // !REPLACEMENT-bl/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bl/%rR/n0/fR/retR
      false, // !REPLACEMENT-bl/%rR/nR/fR/retR
      false, // !REPLACEMENT-bl/n0/%r0/fR/retR
      false, // !REPLACEMENT-bl/n0/%r1/fR/retR
      false, // !REPLACEMENT-bl/n0/%rR/fR/retR
      false, // !REPLACEMENT-bl/n0/n0/fR/retR
      false, // !REPLACEMENT-bl/n0/nR/fR/retR
      false, // !REPLACEMENT-bl/nR/%r0/fR/retR
      false, // !REPLACEMENT-bl/nR/%r1/fR/retR
      false, // !REPLACEMENT-bl/nR/%rR/fR/retR
      false, // !REPLACEMENT-bl/nR/n0/fR/retR
      false, // !REPLACEMENT-bl/nR/nR/fR/retR
      false, // !REPLACEMENT-ble/%r0/%r0/fR/retR
      false, // !REPLACEMENT-ble/%r0/%r1/fR/retR
      false, // !REPLACEMENT-ble/%r0/%rR/fR/retR
      false, // !REPLACEMENT-ble/%r0/n0/fR/retR
      false, // !REPLACEMENT-ble/%r0/nR/fR/retR
      false, // !REPLACEMENT-ble/%r1/%r0/fR/retR
      false, // !REPLACEMENT-ble/%r1/%r1/fR/retR
      false, // !REPLACEMENT-ble/%r1/%rR/fR/retR
      false, // !REPLACEMENT-ble/%r1/n0/fR/retR
      false, // !REPLACEMENT-ble/%r1/nR/fR/retR
      false, // !REPLACEMENT-ble/%rR/%r0/fR/retR
      false, // !REPLACEMENT-ble/%rR/%r1/fR/retR
      false, // !REPLACEMENT-ble/%rR/%rR/fR/retR
      false, // !REPLACEMENT-ble/%rR/n0/fR/retR
      false, // !REPLACEMENT-ble/%rR/nR/fR/retR
      false, // !REPLACEMENT-ble/n0/%r0/fR/retR
      false, // !REPLACEMENT-ble/n0/%r1/fR/retR
      false, // !REPLACEMENT-ble/n0/%rR/fR/retR
      false, // !REPLACEMENT-ble/n0/n0/fR/retR
      false, // !REPLACEMENT-ble/n0/nR/fR/retR
      false, // !REPLACEMENT-ble/nR/%r0/fR/retR
      false, // !REPLACEMENT-ble/nR/%r1/fR/retR
      false, // !REPLACEMENT-ble/nR/%rR/fR/retR
      false, // !REPLACEMENT-ble/nR/n0/fR/retR
      false, // !REPLACEMENT-ble/nR/nR/fR/retR
      false, // !REPLACEMENT-bne/%r0/%r0/fR/retR
      false, // !REPLACEMENT-bne/%r0/%r1/fR/retR
      false, // !REPLACEMENT-bne/%r0/%rR/fR/retR
      false, // !REPLACEMENT-bne/%r0/n0/fR/retR
      false, // !REPLACEMENT-bne/%r0/nR/fR/retR
      false, // !REPLACEMENT-bne/%r1/%r0/fR/retR
      false, // !REPLACEMENT-bne/%r1/%r1/fR/retR
      false, // !REPLACEMENT-bne/%r1/%rR/fR/retR
      false, // !REPLACEMENT-bne/%r1/n0/fR/retR
      false, // !REPLACEMENT-bne/%r1/nR/fR/retR
      false, // !REPLACEMENT-bne/%rR/%r0/fR/retR
      false, // !REPLACEMENT-bne/%rR/%r1/fR/retR
      false, // !REPLACEMENT-bne/%rR/%rR/fR/retR
      false, // !REPLACEMENT-bne/%rR/n0/fR/retR
      false, // !REPLACEMENT-bne/%rR/nR/fR/retR
      false, // !REPLACEMENT-bne/n0/%r0/fR/retR
      false, // !REPLACEMENT-bne/n0/%r1/fR/retR
      false, // !REPLACEMENT-bne/n0/%rR/fR/retR
      false, // !REPLACEMENT-bne/n0/n0/fR/retR
      false, // !REPLACEMENT-bne/n0/nR/fR/retR
      false, // !REPLACEMENT-bne/nR/%r0/fR/retR
      false, // !REPLACEMENT-bne/nR/%r1/fR/retR
      false, // !REPLACEMENT-bne/nR/%rR/fR/retR
      false, // !REPLACEMENT-bne/nR/n0/fR/retR
      false, // !REPLACEMENT-bne/nR/nR/fR/retR
      false, // !REPLACEMENT-bneqi-stack/n-1/fR/retR
      false, // !REPLACEMENT-bneqi-stack/n0/fR/retR
      false, // !REPLACEMENT-bneqi-stack/n1/fR/retR
      false, // !REPLACEMENT-bneqi-stack/n2/fR/retR
      false, // !REPLACEMENT-bneqi-stack/nR/fR/retR
      false, // !REPLACEMENT-bt-stack/fR/retR
      false, // !REPLACEMENT-call/fR/retR
      false, // !REPLACEMENT-exitvm/retR
      true, // !REPLACEMENT-procedure-prolog/retR
      false, // !REPLACEMENT-return-to-undertop/retR
      false // !REPLACEMENT-unreachable/retR
    };

/* An array whose indices are specialised instruction opcodes, and
   whose elements are the corresponding unspecialised instructions
   opcodes -- or -1 when there is no mapping mapping having */
const int
structuredvm_specialized_instruction_to_unspecialized_instruction
   [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
  = {
    -1, /* !INVALID */
    -1, /* !BEGINBASICBLOCK */
    -1, /* !EXITVM */
    -1, /* !DATALOCATIONS */
    -1, /* !NOP */
    -1, /* !UNREACHABLE0 */
    -1, /* !UNREACHABLE1 */
    -1, /* !PRETENDTOJUMPANYWHERE */
    structuredvm_meta_instruction_id_b, /* b/fR */
    structuredvm_meta_instruction_id_be, /* be/%r0/%r0/fR */
    structuredvm_meta_instruction_id_be, /* be/%r0/%r1/fR */
    structuredvm_meta_instruction_id_be, /* be/%r0/%rR/fR */
    structuredvm_meta_instruction_id_be, /* be/%r0/n0/fR */
    structuredvm_meta_instruction_id_be, /* be/%r0/nR/fR */
    structuredvm_meta_instruction_id_be, /* be/%r1/%r0/fR */
    structuredvm_meta_instruction_id_be, /* be/%r1/%r1/fR */
    structuredvm_meta_instruction_id_be, /* be/%r1/%rR/fR */
    structuredvm_meta_instruction_id_be, /* be/%r1/n0/fR */
    structuredvm_meta_instruction_id_be, /* be/%r1/nR/fR */
    structuredvm_meta_instruction_id_be, /* be/%rR/%r0/fR */
    structuredvm_meta_instruction_id_be, /* be/%rR/%r1/fR */
    structuredvm_meta_instruction_id_be, /* be/%rR/%rR/fR */
    structuredvm_meta_instruction_id_be, /* be/%rR/n0/fR */
    structuredvm_meta_instruction_id_be, /* be/%rR/nR/fR */
    structuredvm_meta_instruction_id_be, /* be/n0/%r0/fR */
    structuredvm_meta_instruction_id_be, /* be/n0/%r1/fR */
    structuredvm_meta_instruction_id_be, /* be/n0/%rR/fR */
    structuredvm_meta_instruction_id_be, /* be/n0/n0/fR */
    structuredvm_meta_instruction_id_be, /* be/n0/nR/fR */
    structuredvm_meta_instruction_id_be, /* be/nR/%r0/fR */
    structuredvm_meta_instruction_id_be, /* be/nR/%r1/fR */
    structuredvm_meta_instruction_id_be, /* be/nR/%rR/fR */
    structuredvm_meta_instruction_id_be, /* be/nR/n0/fR */
    structuredvm_meta_instruction_id_be, /* be/nR/nR/fR */
    structuredvm_meta_instruction_id_beqi_mstack, /* beqi-stack/n-1/fR */
    structuredvm_meta_instruction_id_beqi_mstack, /* beqi-stack/n0/fR */
    structuredvm_meta_instruction_id_beqi_mstack, /* beqi-stack/n1/fR */
    structuredvm_meta_instruction_id_beqi_mstack, /* beqi-stack/n2/fR */
    structuredvm_meta_instruction_id_beqi_mstack, /* beqi-stack/nR/fR */
    structuredvm_meta_instruction_id_bf_mstack, /* bf-stack/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r0/%r0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r0/%r1/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r0/%rR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r0/n0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r0/nR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r1/%r0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r1/%r1/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r1/%rR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r1/n0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%r1/nR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%rR/%r0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%rR/%r1/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%rR/%rR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%rR/n0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/%rR/nR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/n0/%r0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/n0/%r1/fR */
    structuredvm_meta_instruction_id_bg, /* bg/n0/%rR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/n0/n0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/n0/nR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/nR/%r0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/nR/%r1/fR */
    structuredvm_meta_instruction_id_bg, /* bg/nR/%rR/fR */
    structuredvm_meta_instruction_id_bg, /* bg/nR/n0/fR */
    structuredvm_meta_instruction_id_bg, /* bg/nR/nR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r0/%r0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r0/%r1/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r0/%rR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r0/n0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r0/nR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r1/%r0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r1/%r1/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r1/%rR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r1/n0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%r1/nR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%rR/%r0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%rR/%r1/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%rR/%rR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%rR/n0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/%rR/nR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/n0/%r0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/n0/%r1/fR */
    structuredvm_meta_instruction_id_bge, /* bge/n0/%rR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/n0/n0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/n0/nR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/nR/%r0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/nR/%r1/fR */
    structuredvm_meta_instruction_id_bge, /* bge/nR/%rR/fR */
    structuredvm_meta_instruction_id_bge, /* bge/nR/n0/fR */
    structuredvm_meta_instruction_id_bge, /* bge/nR/nR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r0/%r0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r0/%r1/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r0/%rR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r0/n0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r0/nR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r1/%r0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r1/%r1/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r1/%rR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r1/n0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%r1/nR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%rR/%r0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%rR/%r1/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%rR/%rR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%rR/n0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/%rR/nR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/n0/%r0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/n0/%r1/fR */
    structuredvm_meta_instruction_id_bl, /* bl/n0/%rR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/n0/n0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/n0/nR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/nR/%r0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/nR/%r1/fR */
    structuredvm_meta_instruction_id_bl, /* bl/nR/%rR/fR */
    structuredvm_meta_instruction_id_bl, /* bl/nR/n0/fR */
    structuredvm_meta_instruction_id_bl, /* bl/nR/nR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r0/%r0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r0/%r1/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r0/%rR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r0/n0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r0/nR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r1/%r0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r1/%r1/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r1/%rR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r1/n0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%r1/nR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%rR/%r0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%rR/%r1/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%rR/%rR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%rR/n0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/%rR/nR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/n0/%r0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/n0/%r1/fR */
    structuredvm_meta_instruction_id_ble, /* ble/n0/%rR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/n0/n0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/n0/nR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/nR/%r0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/nR/%r1/fR */
    structuredvm_meta_instruction_id_ble, /* ble/nR/%rR/fR */
    structuredvm_meta_instruction_id_ble, /* ble/nR/n0/fR */
    structuredvm_meta_instruction_id_ble, /* ble/nR/nR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r0/%r0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r0/%r1/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r0/%rR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r0/n0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r0/nR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r1/%r0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r1/%r1/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r1/%rR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r1/n0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%r1/nR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%rR/%r0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%rR/%r1/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%rR/%rR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%rR/n0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/%rR/nR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/n0/%r0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/n0/%r1/fR */
    structuredvm_meta_instruction_id_bne, /* bne/n0/%rR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/n0/n0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/n0/nR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/nR/%r0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/nR/%r1/fR */
    structuredvm_meta_instruction_id_bne, /* bne/nR/%rR/fR */
    structuredvm_meta_instruction_id_bne, /* bne/nR/n0/fR */
    structuredvm_meta_instruction_id_bne, /* bne/nR/nR/fR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* bneqi-stack/n-1/fR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* bneqi-stack/n0/fR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* bneqi-stack/n1/fR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* bneqi-stack/n2/fR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* bneqi-stack/nR/fR */
    structuredvm_meta_instruction_id_bt_mstack, /* bt-stack/fR */
    structuredvm_meta_instruction_id_call, /* call/fR/retR */
    structuredvm_meta_instruction_id_copy_mto_mr_mstack, /* copy-to-r-stack/%r0 */
    structuredvm_meta_instruction_id_copy_mto_mr_mstack, /* copy-to-r-stack/%r1 */
    structuredvm_meta_instruction_id_copy_mto_mr_mstack, /* copy-to-r-stack/%rR */
    structuredvm_meta_instruction_id_different_mstack, /* different-stack */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%r0/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%r0/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%r0/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%r1/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%r1/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%r1/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%rR/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%rR/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/%rR/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/n2/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/n2/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/n2/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/nR/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/nR/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r0/nR/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%r0/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%r0/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%r0/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%r1/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%r1/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%r1/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%rR/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%rR/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/%rR/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/n2/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/n2/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/n2/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/nR/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/nR/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%r1/nR/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%r0/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%r0/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%r0/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%r1/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%r1/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%r1/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%rR/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%rR/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/%rR/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/n2/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/n2/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/n2/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/nR/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/nR/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/%rR/nR/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%r0/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%r0/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%r0/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%r1/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%r1/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%r1/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%rR/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%rR/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/%rR/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/n2/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/n2/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/n2/%rR/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/nR/%r0/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/nR/%r1/retR */
    structuredvm_meta_instruction_id_divided, /* divided/nR/nR/%rR/retR */
    structuredvm_meta_instruction_id_divided_mstack, /* divided-stack/retR */
    structuredvm_meta_instruction_id_drop_mstack, /* drop-stack */
    structuredvm_meta_instruction_id_dup_mstack, /* dup-stack */
    structuredvm_meta_instruction_id_equal_mstack, /* equal-stack */
    structuredvm_meta_instruction_id_equali_mstack, /* equali-stack/n0 */
    structuredvm_meta_instruction_id_equali_mstack, /* equali-stack/n1 */
    structuredvm_meta_instruction_id_equali_mstack, /* equali-stack/n2 */
    structuredvm_meta_instruction_id_equali_mstack, /* equali-stack/nR */
    structuredvm_meta_instruction_id_exitvm, /* exitvm */
    structuredvm_meta_instruction_id_greater_mstack, /* greater-stack */
    structuredvm_meta_instruction_id_greaterorequal_mstack, /* greaterorequal-stack */
    structuredvm_meta_instruction_id_input, /* input/%r0/retR */
    structuredvm_meta_instruction_id_input, /* input/%r1/retR */
    structuredvm_meta_instruction_id_input, /* input/%rR/retR */
    structuredvm_meta_instruction_id_input_mstack, /* input-stack/retR */
    structuredvm_meta_instruction_id_isnonzero_mstack, /* isnonzero-stack */
    structuredvm_meta_instruction_id_less_mstack, /* less-stack */
    structuredvm_meta_instruction_id_lessorequal_mstack, /* lessorequal-stack */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n0/%r0 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n0/%r1 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n0/%rR */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n1/%r0 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n1/%r1 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n1/%rR */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n2/%r0 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n2/%r1 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n2/%rR */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n3/%r0 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n3/%r1 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n3/%rR */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n4/%r0 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n4/%r1 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n4/%rR */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n5/%r0 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n5/%r1 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n5/%rR */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n6/%r0 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n6/%r1 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n6/%rR */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n7/%r0 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n7/%r1 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n7/%rR */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n8/%r0 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n8/%r1 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n8/%rR */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n9/%r0 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n9/%r1 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n9/%rR */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n10/%r0 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n10/%r1 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/n10/%rR */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/nR/%r0 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/nR/%r1 */
    structuredvm_meta_instruction_id_load_mboxed_mliteral, /* load-boxed-literal/nR/%rR */
    structuredvm_meta_instruction_id_logicaland_mstack, /* logicaland-stack */
    structuredvm_meta_instruction_id_logicalnot_mstack, /* logicalnot-stack */
    structuredvm_meta_instruction_id_logicalor_mstack, /* logicalor-stack */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%r0/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%r0/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%r0/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%r1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%r1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%r1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%rR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%rR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/%rR/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/n1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/n1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/n1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/n2/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/n2/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/n2/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/nR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/nR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r0/nR/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%r0/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%r0/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%r0/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%r1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%r1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%r1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%rR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%rR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/%rR/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/n1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/n1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/n1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/n2/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/n2/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/n2/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/nR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/nR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%r1/nR/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%r0/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%r0/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%r0/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%r1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%r1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%r1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%rR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%rR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/%rR/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/n1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/n1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/n1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/n2/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/n2/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/n2/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/nR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/nR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/%rR/nR/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%r0/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%r0/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%r0/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%r1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%r1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%r1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%rR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%rR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/%rR/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/nR/n1/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/n1/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/n1/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/nR/n2/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/n2/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/n2/%rR */
    structuredvm_meta_instruction_id_minus, /* minus/nR/nR/%r0 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/nR/%r1 */
    structuredvm_meta_instruction_id_minus, /* minus/nR/nR/%rR */
    structuredvm_meta_instruction_id_minus_mstack, /* minus-stack */
    structuredvm_meta_instruction_id_minusi_mstack, /* minusi-stack/n1 */
    structuredvm_meta_instruction_id_minusi_mstack, /* minusi-stack/n2 */
    structuredvm_meta_instruction_id_minusi_mstack, /* minusi-stack/nR */
    structuredvm_meta_instruction_id_mov, /* mov/%r0/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/%r0/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/%r0/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/%r1/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/%r1/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/%r1/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/%rR/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/%rR/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/%rR/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/n0/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/n0/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/n0/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/n1/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/n1/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/n1/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/n-1/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/n-1/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/n-1/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/n2/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/n2/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/n2/%rR */
    structuredvm_meta_instruction_id_mov, /* mov/nR/%r0 */
    structuredvm_meta_instruction_id_mov, /* mov/nR/%r1 */
    structuredvm_meta_instruction_id_mov, /* mov/nR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%r0/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%r0/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%r0/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%r1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%r1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%r1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%rR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%rR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/%rR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/n1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/n1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/n1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/n2/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/n2/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/n2/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/nR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/nR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r0/nR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%r0/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%r0/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%r0/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%r1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%r1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%r1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%rR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%rR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/%rR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/n1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/n1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/n1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/n2/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/n2/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/n2/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/nR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/nR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%r1/nR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%r0/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%r0/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%r0/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%r1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%r1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%r1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%rR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%rR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/%rR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/n1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/n1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/n1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/n2/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/n2/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/n2/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/nR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/nR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/%rR/nR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/n1/%r0/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/n1/%r0/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/n1/%r0/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/n1/%r1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/n1/%r1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/n1/%r1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/n1/%rR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/n1/%rR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/n1/%rR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/n1/n1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/n1/n1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/n1/n1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/n1/n2/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/n1/n2/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/n1/n2/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/n1/nR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/n1/nR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/n1/nR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/n2/%r0/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/n2/%r0/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/n2/%r0/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/n2/%r1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/n2/%r1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/n2/%r1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/n2/%rR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/n2/%rR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/n2/%rR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/n2/n1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/n2/n1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/n2/n1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/n2/n2/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/n2/n2/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/n2/n2/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/n2/nR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/n2/nR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/n2/nR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%r0/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%r0/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%r0/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%r1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%r1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%r1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%rR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%rR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/%rR/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/nR/n1/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/n1/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/n1/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/nR/n2/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/n2/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/n2/%rR */
    structuredvm_meta_instruction_id_plus, /* plus/nR/nR/%r0 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/nR/%r1 */
    structuredvm_meta_instruction_id_plus, /* plus/nR/nR/%rR */
    structuredvm_meta_instruction_id_plus_mstack, /* plus-stack */
    structuredvm_meta_instruction_id_plusi_mstack, /* plusi-stack/n-1 */
    structuredvm_meta_instruction_id_plusi_mstack, /* plusi-stack/n1 */
    structuredvm_meta_instruction_id_plusi_mstack, /* plusi-stack/n2 */
    structuredvm_meta_instruction_id_plusi_mstack, /* plusi-stack/nR */
    structuredvm_meta_instruction_id_pop_mstack, /* pop-stack/%r0 */
    structuredvm_meta_instruction_id_pop_mstack, /* pop-stack/%r1 */
    structuredvm_meta_instruction_id_pop_mstack, /* pop-stack/%rR */
    structuredvm_meta_instruction_id_print, /* print/%r0/retR */
    structuredvm_meta_instruction_id_print, /* print/%r1/retR */
    structuredvm_meta_instruction_id_print, /* print/%rR/retR */
    structuredvm_meta_instruction_id_print, /* print/nR/retR */
    structuredvm_meta_instruction_id_print_mstack, /* print-stack/retR */
    structuredvm_meta_instruction_id_procedure_mprolog, /* procedure-prolog */
    structuredvm_meta_instruction_id_push_mboxed_mliteral, /* push-boxed-literal/n0 */
    structuredvm_meta_instruction_id_push_mboxed_mliteral, /* push-boxed-literal/n1 */
    structuredvm_meta_instruction_id_push_mboxed_mliteral, /* push-boxed-literal/n2 */
    structuredvm_meta_instruction_id_push_mboxed_mliteral, /* push-boxed-literal/n3 */
    structuredvm_meta_instruction_id_push_mboxed_mliteral, /* push-boxed-literal/n4 */
    structuredvm_meta_instruction_id_push_mboxed_mliteral, /* push-boxed-literal/n5 */
    structuredvm_meta_instruction_id_push_mboxed_mliteral, /* push-boxed-literal/n6 */
    structuredvm_meta_instruction_id_push_mboxed_mliteral, /* push-boxed-literal/n7 */
    structuredvm_meta_instruction_id_push_mboxed_mliteral, /* push-boxed-literal/n8 */
    structuredvm_meta_instruction_id_push_mboxed_mliteral, /* push-boxed-literal/n9 */
    structuredvm_meta_instruction_id_push_mboxed_mliteral, /* push-boxed-literal/n10 */
    structuredvm_meta_instruction_id_push_mboxed_mliteral, /* push-boxed-literal/nR */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/%r0 */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/%r1 */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/%rR */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/n0 */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/n1 */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/n-1 */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/n2 */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/nR */
    structuredvm_meta_instruction_id_push_mstack, /* push-stack/lR */
    structuredvm_meta_instruction_id_push_munspecified_mstack, /* push-unspecified-stack */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%r0/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%r0/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%r0/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%r1/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%r1/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%r1/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%rR/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%rR/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/%rR/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/n2/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/n2/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/n2/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/nR/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/nR/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r0/nR/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%r0/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%r0/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%r0/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%r1/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%r1/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%r1/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%rR/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%rR/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/%rR/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/n2/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/n2/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/n2/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/nR/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/nR/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%r1/nR/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%r0/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%r0/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%r0/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%r1/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%r1/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%r1/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%rR/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%rR/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/%rR/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/n2/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/n2/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/n2/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/nR/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/nR/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/%rR/nR/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%r0/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%r0/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%r0/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%r1/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%r1/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%r1/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%rR/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%rR/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/%rR/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/n2/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/n2/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/n2/%rR/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/nR/%r0/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/nR/%r1/retR */
    structuredvm_meta_instruction_id_remainder, /* remainder/nR/nR/%rR/retR */
    structuredvm_meta_instruction_id_remainder_mstack, /* remainder-stack/retR */
    structuredvm_meta_instruction_id_return_mto_mundertop, /* return-to-undertop */
    structuredvm_meta_instruction_id_swap_mstack, /* swap-stack */
    structuredvm_meta_instruction_id_times, /* times/%r0/%r0/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r0/%r0/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r0/%r0/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r0/%r1/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r0/%r1/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r0/%r1/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r0/%rR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r0/%rR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r0/%rR/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r0/n2/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r0/n2/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r0/n2/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r0/nR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r0/nR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r0/nR/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r1/%r0/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r1/%r0/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r1/%r0/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r1/%r1/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r1/%r1/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r1/%r1/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r1/%rR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r1/%rR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r1/%rR/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r1/n2/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r1/n2/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r1/n2/%rR */
    structuredvm_meta_instruction_id_times, /* times/%r1/nR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%r1/nR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%r1/nR/%rR */
    structuredvm_meta_instruction_id_times, /* times/%rR/%r0/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%rR/%r0/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%rR/%r0/%rR */
    structuredvm_meta_instruction_id_times, /* times/%rR/%r1/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%rR/%r1/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%rR/%r1/%rR */
    structuredvm_meta_instruction_id_times, /* times/%rR/%rR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%rR/%rR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%rR/%rR/%rR */
    structuredvm_meta_instruction_id_times, /* times/%rR/n2/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%rR/n2/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%rR/n2/%rR */
    structuredvm_meta_instruction_id_times, /* times/%rR/nR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/%rR/nR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/%rR/nR/%rR */
    structuredvm_meta_instruction_id_times, /* times/nR/%r0/%r0 */
    structuredvm_meta_instruction_id_times, /* times/nR/%r0/%r1 */
    structuredvm_meta_instruction_id_times, /* times/nR/%r0/%rR */
    structuredvm_meta_instruction_id_times, /* times/nR/%r1/%r0 */
    structuredvm_meta_instruction_id_times, /* times/nR/%r1/%r1 */
    structuredvm_meta_instruction_id_times, /* times/nR/%r1/%rR */
    structuredvm_meta_instruction_id_times, /* times/nR/%rR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/nR/%rR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/nR/%rR/%rR */
    structuredvm_meta_instruction_id_times, /* times/nR/n2/%r0 */
    structuredvm_meta_instruction_id_times, /* times/nR/n2/%r1 */
    structuredvm_meta_instruction_id_times, /* times/nR/n2/%rR */
    structuredvm_meta_instruction_id_times, /* times/nR/nR/%r0 */
    structuredvm_meta_instruction_id_times, /* times/nR/nR/%r1 */
    structuredvm_meta_instruction_id_times, /* times/nR/nR/%rR */
    structuredvm_meta_instruction_id_times_mstack, /* times-stack */
    structuredvm_meta_instruction_id_uminus, /* uminus/%r0/%r0 */
    structuredvm_meta_instruction_id_uminus, /* uminus/%r0/%r1 */
    structuredvm_meta_instruction_id_uminus, /* uminus/%r0/%rR */
    structuredvm_meta_instruction_id_uminus, /* uminus/%r1/%r0 */
    structuredvm_meta_instruction_id_uminus, /* uminus/%r1/%r1 */
    structuredvm_meta_instruction_id_uminus, /* uminus/%r1/%rR */
    structuredvm_meta_instruction_id_uminus, /* uminus/%rR/%r0 */
    structuredvm_meta_instruction_id_uminus, /* uminus/%rR/%r1 */
    structuredvm_meta_instruction_id_uminus, /* uminus/%rR/%rR */
    structuredvm_meta_instruction_id_uminus, /* uminus/nR/%r0 */
    structuredvm_meta_instruction_id_uminus, /* uminus/nR/%r1 */
    structuredvm_meta_instruction_id_uminus, /* uminus/nR/%rR */
    structuredvm_meta_instruction_id_uminus_mstack, /* uminus-stack */
    structuredvm_meta_instruction_id_underpop_mstack, /* underpop-stack/%r0 */
    structuredvm_meta_instruction_id_underpop_mstack, /* underpop-stack/%r1 */
    structuredvm_meta_instruction_id_underpop_mstack, /* underpop-stack/%rR */
    structuredvm_meta_instruction_id_underpush_mstack, /* underpush-stack/%r0 */
    structuredvm_meta_instruction_id_underpush_mstack, /* underpush-stack/%r1 */
    structuredvm_meta_instruction_id_underpush_mstack, /* underpush-stack/%rR */
    structuredvm_meta_instruction_id_underpush_mstack, /* underpush-stack/nR */
    structuredvm_meta_instruction_id_unreachable, /* unreachable */
    structuredvm_meta_instruction_id_b, /* !REPLACEMENT-b/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%r0/%r0/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%r0/%r1/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%r0/%rR/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%r0/n0/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%r0/nR/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%r1/%r0/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%r1/%r1/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%r1/%rR/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%r1/n0/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%r1/nR/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%rR/%r0/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%rR/%r1/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%rR/%rR/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%rR/n0/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/%rR/nR/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/n0/%r0/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/n0/%r1/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/n0/%rR/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/n0/n0/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/n0/nR/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/nR/%r0/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/nR/%r1/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/nR/%rR/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/nR/n0/fR/retR */
    structuredvm_meta_instruction_id_be, /* !REPLACEMENT-be/nR/nR/fR/retR */
    structuredvm_meta_instruction_id_beqi_mstack, /* !REPLACEMENT-beqi-stack/n-1/fR/retR */
    structuredvm_meta_instruction_id_beqi_mstack, /* !REPLACEMENT-beqi-stack/n0/fR/retR */
    structuredvm_meta_instruction_id_beqi_mstack, /* !REPLACEMENT-beqi-stack/n1/fR/retR */
    structuredvm_meta_instruction_id_beqi_mstack, /* !REPLACEMENT-beqi-stack/n2/fR/retR */
    structuredvm_meta_instruction_id_beqi_mstack, /* !REPLACEMENT-beqi-stack/nR/fR/retR */
    structuredvm_meta_instruction_id_bf_mstack, /* !REPLACEMENT-bf-stack/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%r0/%r0/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%r0/%r1/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%r0/%rR/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%r0/n0/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%r0/nR/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%r1/%r0/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%r1/%r1/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%r1/%rR/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%r1/n0/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%r1/nR/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%rR/%r0/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%rR/%r1/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%rR/%rR/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%rR/n0/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/%rR/nR/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/n0/%r0/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/n0/%r1/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/n0/%rR/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/n0/n0/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/n0/nR/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/nR/%r0/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/nR/%r1/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/nR/%rR/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/nR/n0/fR/retR */
    structuredvm_meta_instruction_id_bg, /* !REPLACEMENT-bg/nR/nR/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%r0/%r0/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%r0/%r1/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%r0/%rR/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%r0/n0/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%r0/nR/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%r1/%r0/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%r1/%r1/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%r1/%rR/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%r1/n0/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%r1/nR/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%rR/%r0/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%rR/%r1/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%rR/%rR/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%rR/n0/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/%rR/nR/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/n0/%r0/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/n0/%r1/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/n0/%rR/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/n0/n0/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/n0/nR/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/nR/%r0/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/nR/%r1/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/nR/%rR/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/nR/n0/fR/retR */
    structuredvm_meta_instruction_id_bge, /* !REPLACEMENT-bge/nR/nR/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%r0/%r0/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%r0/%r1/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%r0/%rR/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%r0/n0/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%r0/nR/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%r1/%r0/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%r1/%r1/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%r1/%rR/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%r1/n0/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%r1/nR/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%rR/%r0/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%rR/%r1/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%rR/%rR/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%rR/n0/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/%rR/nR/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/n0/%r0/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/n0/%r1/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/n0/%rR/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/n0/n0/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/n0/nR/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/nR/%r0/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/nR/%r1/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/nR/%rR/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/nR/n0/fR/retR */
    structuredvm_meta_instruction_id_bl, /* !REPLACEMENT-bl/nR/nR/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%r0/%r0/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%r0/%r1/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%r0/%rR/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%r0/n0/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%r0/nR/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%r1/%r0/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%r1/%r1/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%r1/%rR/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%r1/n0/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%r1/nR/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%rR/%r0/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%rR/%r1/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%rR/%rR/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%rR/n0/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/%rR/nR/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/n0/%r0/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/n0/%r1/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/n0/%rR/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/n0/n0/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/n0/nR/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/nR/%r0/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/nR/%r1/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/nR/%rR/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/nR/n0/fR/retR */
    structuredvm_meta_instruction_id_ble, /* !REPLACEMENT-ble/nR/nR/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%r0/%r0/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%r0/%r1/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%r0/%rR/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%r0/n0/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%r0/nR/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%r1/%r0/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%r1/%r1/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%r1/%rR/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%r1/n0/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%r1/nR/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%rR/%r0/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%rR/%r1/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%rR/%rR/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%rR/n0/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/%rR/nR/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/n0/%r0/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/n0/%r1/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/n0/%rR/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/n0/n0/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/n0/nR/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/nR/%r0/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/nR/%r1/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/nR/%rR/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/nR/n0/fR/retR */
    structuredvm_meta_instruction_id_bne, /* !REPLACEMENT-bne/nR/nR/fR/retR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* !REPLACEMENT-bneqi-stack/n-1/fR/retR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* !REPLACEMENT-bneqi-stack/n0/fR/retR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* !REPLACEMENT-bneqi-stack/n1/fR/retR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* !REPLACEMENT-bneqi-stack/n2/fR/retR */
    structuredvm_meta_instruction_id_bneqi_mstack, /* !REPLACEMENT-bneqi-stack/nR/fR/retR */
    structuredvm_meta_instruction_id_bt_mstack, /* !REPLACEMENT-bt-stack/fR/retR */
    structuredvm_meta_instruction_id_call, /* !REPLACEMENT-call/fR/retR */
    structuredvm_meta_instruction_id_exitvm, /* !REPLACEMENT-exitvm/retR */
    structuredvm_meta_instruction_id_procedure_mprolog, /* !REPLACEMENT-procedure-prolog/retR */
    structuredvm_meta_instruction_id_return_mto_mundertop, /* !REPLACEMENT-return-to-undertop/retR */
    structuredvm_meta_instruction_id_unreachable /* !REPLACEMENT-unreachable/retR */
    };

#ifdef JITTER_HAVE_DEFECT_REPLACEMENT
/* Worst-case replacement table. */
const jitter_uint
structuredvm_worst_case_replacement_table [] =
  {
    structuredvm_specialized_instruction_opcode__eINVALID, /* !INVALID is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eBEGINBASICBLOCK, /* !BEGINBASICBLOCK is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eEXITVM, /* !EXITVM is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eDATALOCATIONS, /* !DATALOCATIONS is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eNOP, /* !NOP is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eUNREACHABLE0, /* !UNREACHABLE0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eUNREACHABLE1, /* !UNREACHABLE1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__ePRETENDTOJUMPANYWHERE, /* !PRETENDTOJUMPANYWHERE is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mb__fR__retR, /* b/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-b/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr0___rr0__fR__retR, /* be/%r0/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%r0/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr0___rr1__fR__retR, /* be/%r0/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%r0/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr0___rrR__fR__retR, /* be/%r0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%r0/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr0__n0__fR__retR, /* be/%r0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%r0/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr0__nR__fR__retR, /* be/%r0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%r0/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr1___rr0__fR__retR, /* be/%r1/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%r1/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr1___rr1__fR__retR, /* be/%r1/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%r1/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr1___rrR__fR__retR, /* be/%r1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%r1/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr1__n0__fR__retR, /* be/%r1/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%r1/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr1__nR__fR__retR, /* be/%r1/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%r1/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rrR___rr0__fR__retR, /* be/%rR/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%rR/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rrR___rr1__fR__retR, /* be/%rR/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%rR/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rrR___rrR__fR__retR, /* be/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%rR/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rrR__n0__fR__retR, /* be/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%rR/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rrR__nR__fR__retR, /* be/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/%rR/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__n0___rr0__fR__retR, /* be/n0/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/n0/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__n0___rr1__fR__retR, /* be/n0/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/n0/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__n0___rrR__fR__retR, /* be/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/n0/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__n0__n0__fR__retR, /* be/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/n0/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__n0__nR__fR__retR, /* be/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/n0/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__nR___rr0__fR__retR, /* be/nR/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/nR/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__nR___rr1__fR__retR, /* be/nR/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/nR/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__nR___rrR__fR__retR, /* be/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/nR/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__nR__n0__fR__retR, /* be/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/nR/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__nR__nR__fR__retR, /* be/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-be/nR/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbeqi_mstack__n_m1__fR__retR, /* beqi-stack/n-1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-beqi-stack/n-1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbeqi_mstack__n0__fR__retR, /* beqi-stack/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-beqi-stack/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbeqi_mstack__n1__fR__retR, /* beqi-stack/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-beqi-stack/n1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbeqi_mstack__n2__fR__retR, /* beqi-stack/n2/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-beqi-stack/n2/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbeqi_mstack__nR__fR__retR, /* beqi-stack/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-beqi-stack/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbf_mstack__fR__retR, /* bf-stack/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bf-stack/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr0___rr0__fR__retR, /* bg/%r0/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%r0/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr0___rr1__fR__retR, /* bg/%r0/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%r0/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr0___rrR__fR__retR, /* bg/%r0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%r0/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr0__n0__fR__retR, /* bg/%r0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%r0/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr0__nR__fR__retR, /* bg/%r0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%r0/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr1___rr0__fR__retR, /* bg/%r1/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%r1/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr1___rr1__fR__retR, /* bg/%r1/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%r1/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr1___rrR__fR__retR, /* bg/%r1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%r1/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr1__n0__fR__retR, /* bg/%r1/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%r1/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr1__nR__fR__retR, /* bg/%r1/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%r1/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rrR___rr0__fR__retR, /* bg/%rR/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%rR/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rrR___rr1__fR__retR, /* bg/%rR/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%rR/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rrR___rrR__fR__retR, /* bg/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%rR/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rrR__n0__fR__retR, /* bg/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%rR/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rrR__nR__fR__retR, /* bg/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/%rR/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__n0___rr0__fR__retR, /* bg/n0/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/n0/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__n0___rr1__fR__retR, /* bg/n0/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/n0/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__n0___rrR__fR__retR, /* bg/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/n0/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__n0__n0__fR__retR, /* bg/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/n0/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__n0__nR__fR__retR, /* bg/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/n0/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__nR___rr0__fR__retR, /* bg/nR/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/nR/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__nR___rr1__fR__retR, /* bg/nR/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/nR/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__nR___rrR__fR__retR, /* bg/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/nR/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__nR__n0__fR__retR, /* bg/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/nR/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__nR__nR__fR__retR, /* bg/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bg/nR/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr0___rr0__fR__retR, /* bge/%r0/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%r0/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr0___rr1__fR__retR, /* bge/%r0/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%r0/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr0___rrR__fR__retR, /* bge/%r0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%r0/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr0__n0__fR__retR, /* bge/%r0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%r0/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr0__nR__fR__retR, /* bge/%r0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%r0/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr1___rr0__fR__retR, /* bge/%r1/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%r1/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr1___rr1__fR__retR, /* bge/%r1/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%r1/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr1___rrR__fR__retR, /* bge/%r1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%r1/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr1__n0__fR__retR, /* bge/%r1/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%r1/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr1__nR__fR__retR, /* bge/%r1/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%r1/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR___rr0__fR__retR, /* bge/%rR/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%rR/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR___rr1__fR__retR, /* bge/%rR/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%rR/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR___rrR__fR__retR, /* bge/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%rR/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR__n0__fR__retR, /* bge/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%rR/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR__nR__fR__retR, /* bge/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/%rR/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__n0___rr0__fR__retR, /* bge/n0/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/n0/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__n0___rr1__fR__retR, /* bge/n0/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/n0/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__n0___rrR__fR__retR, /* bge/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/n0/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__n0__n0__fR__retR, /* bge/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/n0/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__n0__nR__fR__retR, /* bge/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/n0/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__nR___rr0__fR__retR, /* bge/nR/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/nR/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__nR___rr1__fR__retR, /* bge/nR/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/nR/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__nR___rrR__fR__retR, /* bge/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/nR/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__nR__n0__fR__retR, /* bge/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/nR/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__nR__nR__fR__retR, /* bge/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bge/nR/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr0___rr0__fR__retR, /* bl/%r0/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%r0/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr0___rr1__fR__retR, /* bl/%r0/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%r0/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr0___rrR__fR__retR, /* bl/%r0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%r0/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr0__n0__fR__retR, /* bl/%r0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%r0/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr0__nR__fR__retR, /* bl/%r0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%r0/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr1___rr0__fR__retR, /* bl/%r1/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%r1/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr1___rr1__fR__retR, /* bl/%r1/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%r1/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr1___rrR__fR__retR, /* bl/%r1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%r1/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr1__n0__fR__retR, /* bl/%r1/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%r1/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr1__nR__fR__retR, /* bl/%r1/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%r1/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rrR___rr0__fR__retR, /* bl/%rR/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%rR/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rrR___rr1__fR__retR, /* bl/%rR/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%rR/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rrR___rrR__fR__retR, /* bl/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%rR/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rrR__n0__fR__retR, /* bl/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%rR/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rrR__nR__fR__retR, /* bl/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/%rR/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__n0___rr0__fR__retR, /* bl/n0/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/n0/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__n0___rr1__fR__retR, /* bl/n0/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/n0/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__n0___rrR__fR__retR, /* bl/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/n0/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__n0__n0__fR__retR, /* bl/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/n0/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__n0__nR__fR__retR, /* bl/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/n0/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__nR___rr0__fR__retR, /* bl/nR/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/nR/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__nR___rr1__fR__retR, /* bl/nR/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/nR/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__nR___rrR__fR__retR, /* bl/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/nR/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__nR__n0__fR__retR, /* bl/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/nR/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__nR__nR__fR__retR, /* bl/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bl/nR/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr0___rr0__fR__retR, /* ble/%r0/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%r0/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr0___rr1__fR__retR, /* ble/%r0/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%r0/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr0___rrR__fR__retR, /* ble/%r0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%r0/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr0__n0__fR__retR, /* ble/%r0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%r0/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr0__nR__fR__retR, /* ble/%r0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%r0/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr1___rr0__fR__retR, /* ble/%r1/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%r1/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr1___rr1__fR__retR, /* ble/%r1/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%r1/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr1___rrR__fR__retR, /* ble/%r1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%r1/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr1__n0__fR__retR, /* ble/%r1/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%r1/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr1__nR__fR__retR, /* ble/%r1/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%r1/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rrR___rr0__fR__retR, /* ble/%rR/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%rR/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rrR___rr1__fR__retR, /* ble/%rR/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%rR/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rrR___rrR__fR__retR, /* ble/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%rR/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rrR__n0__fR__retR, /* ble/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%rR/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rrR__nR__fR__retR, /* ble/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/%rR/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__n0___rr0__fR__retR, /* ble/n0/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/n0/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__n0___rr1__fR__retR, /* ble/n0/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/n0/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__n0___rrR__fR__retR, /* ble/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/n0/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__n0__n0__fR__retR, /* ble/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/n0/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__n0__nR__fR__retR, /* ble/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/n0/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__nR___rr0__fR__retR, /* ble/nR/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/nR/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__nR___rr1__fR__retR, /* ble/nR/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/nR/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__nR___rrR__fR__retR, /* ble/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/nR/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__nR__n0__fR__retR, /* ble/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/nR/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__nR__nR__fR__retR, /* ble/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-ble/nR/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr0___rr0__fR__retR, /* bne/%r0/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%r0/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr0___rr1__fR__retR, /* bne/%r0/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%r0/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr0___rrR__fR__retR, /* bne/%r0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%r0/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr0__n0__fR__retR, /* bne/%r0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%r0/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr0__nR__fR__retR, /* bne/%r0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%r0/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr1___rr0__fR__retR, /* bne/%r1/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%r1/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr1___rr1__fR__retR, /* bne/%r1/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%r1/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr1___rrR__fR__retR, /* bne/%r1/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%r1/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr1__n0__fR__retR, /* bne/%r1/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%r1/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr1__nR__fR__retR, /* bne/%r1/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%r1/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR___rr0__fR__retR, /* bne/%rR/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%rR/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR___rr1__fR__retR, /* bne/%rR/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%rR/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR___rrR__fR__retR, /* bne/%rR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%rR/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR__n0__fR__retR, /* bne/%rR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%rR/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR__nR__fR__retR, /* bne/%rR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/%rR/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__n0___rr0__fR__retR, /* bne/n0/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/n0/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__n0___rr1__fR__retR, /* bne/n0/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/n0/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__n0___rrR__fR__retR, /* bne/n0/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/n0/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__n0__n0__fR__retR, /* bne/n0/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/n0/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__n0__nR__fR__retR, /* bne/n0/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/n0/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__nR___rr0__fR__retR, /* bne/nR/%r0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/nR/%r0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__nR___rr1__fR__retR, /* bne/nR/%r1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/nR/%r1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__nR___rrR__fR__retR, /* bne/nR/%rR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/nR/%rR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__nR__n0__fR__retR, /* bne/nR/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/nR/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__nR__nR__fR__retR, /* bne/nR/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bne/nR/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbneqi_mstack__n_m1__fR__retR, /* bneqi-stack/n-1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bneqi-stack/n-1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbneqi_mstack__n0__fR__retR, /* bneqi-stack/n0/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bneqi-stack/n0/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbneqi_mstack__n1__fR__retR, /* bneqi-stack/n1/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bneqi-stack/n1/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbneqi_mstack__n2__fR__retR, /* bneqi-stack/n2/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bneqi-stack/n2/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbneqi_mstack__nR__fR__retR, /* bneqi-stack/nR/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bneqi-stack/nR/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbt_mstack__fR__retR, /* bt-stack/fR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-bt-stack/fR/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mcall__fR__retR, /* call/fR/retR is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-call/fR/retR. */
    structuredvm_specialized_instruction_opcode_copy_mto_mr_mstack___rr0, /* copy-to-r-stack/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_copy_mto_mr_mstack___rr1, /* copy-to-r-stack/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_copy_mto_mr_mstack___rrR, /* copy-to-r-stack/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_different_mstack, /* different-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rr0___rr0__retR, /* divided/%r0/%r0/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rr0___rr1__retR, /* divided/%r0/%r0/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rr0___rrR__retR, /* divided/%r0/%r0/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rr1___rr0__retR, /* divided/%r0/%r1/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rr1___rr1__retR, /* divided/%r0/%r1/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rr1___rrR__retR, /* divided/%r0/%r1/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rrR___rr0__retR, /* divided/%r0/%rR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rrR___rr1__retR, /* divided/%r0/%rR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0___rrR___rrR__retR, /* divided/%r0/%rR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0__n2___rr0__retR, /* divided/%r0/n2/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0__n2___rr1__retR, /* divided/%r0/n2/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0__n2___rrR__retR, /* divided/%r0/n2/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0__nR___rr0__retR, /* divided/%r0/nR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0__nR___rr1__retR, /* divided/%r0/nR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr0__nR___rrR__retR, /* divided/%r0/nR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rr0___rr0__retR, /* divided/%r1/%r0/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rr0___rr1__retR, /* divided/%r1/%r0/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rr0___rrR__retR, /* divided/%r1/%r0/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rr1___rr0__retR, /* divided/%r1/%r1/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rr1___rr1__retR, /* divided/%r1/%r1/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rr1___rrR__retR, /* divided/%r1/%r1/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rrR___rr0__retR, /* divided/%r1/%rR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rrR___rr1__retR, /* divided/%r1/%rR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1___rrR___rrR__retR, /* divided/%r1/%rR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1__n2___rr0__retR, /* divided/%r1/n2/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1__n2___rr1__retR, /* divided/%r1/n2/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1__n2___rrR__retR, /* divided/%r1/n2/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1__nR___rr0__retR, /* divided/%r1/nR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1__nR___rr1__retR, /* divided/%r1/nR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rr1__nR___rrR__retR, /* divided/%r1/nR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rr0___rr0__retR, /* divided/%rR/%r0/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rr0___rr1__retR, /* divided/%rR/%r0/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rr0___rrR__retR, /* divided/%rR/%r0/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rr1___rr0__retR, /* divided/%rR/%r1/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rr1___rr1__retR, /* divided/%rR/%r1/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rr1___rrR__retR, /* divided/%rR/%r1/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rrR___rr0__retR, /* divided/%rR/%rR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rrR___rr1__retR, /* divided/%rR/%rR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR___rrR___rrR__retR, /* divided/%rR/%rR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR__n2___rr0__retR, /* divided/%rR/n2/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR__n2___rr1__retR, /* divided/%rR/n2/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR__n2___rrR__retR, /* divided/%rR/n2/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR__nR___rr0__retR, /* divided/%rR/nR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR__nR___rr1__retR, /* divided/%rR/nR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided___rrR__nR___rrR__retR, /* divided/%rR/nR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rr0___rr0__retR, /* divided/nR/%r0/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rr0___rr1__retR, /* divided/nR/%r0/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rr0___rrR__retR, /* divided/nR/%r0/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rr1___rr0__retR, /* divided/nR/%r1/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rr1___rr1__retR, /* divided/nR/%r1/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rr1___rrR__retR, /* divided/nR/%r1/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rrR___rr0__retR, /* divided/nR/%rR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rrR___rr1__retR, /* divided/nR/%rR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR___rrR___rrR__retR, /* divided/nR/%rR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR__n2___rr0__retR, /* divided/nR/n2/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR__n2___rr1__retR, /* divided/nR/n2/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR__n2___rrR__retR, /* divided/nR/n2/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR__nR___rr0__retR, /* divided/nR/nR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR__nR___rr1__retR, /* divided/nR/nR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided__nR__nR___rrR__retR, /* divided/nR/nR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_divided_mstack__retR, /* divided-stack/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_drop_mstack, /* drop-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_dup_mstack, /* dup-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_equal_mstack, /* equal-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_equali_mstack__n0, /* equali-stack/n0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_equali_mstack__n1, /* equali-stack/n1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_equali_mstack__n2, /* equali-stack/n2 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_equali_mstack__nR, /* equali-stack/nR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mexitvm__retR, /* exitvm is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-exitvm/retR. */
    structuredvm_specialized_instruction_opcode_greater_mstack, /* greater-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_greaterorequal_mstack, /* greaterorequal-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_input___rr0__retR, /* input/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_input___rr1__retR, /* input/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_input___rrR__retR, /* input/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_input_mstack__retR, /* input-stack/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_isnonzero_mstack, /* isnonzero-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_less_mstack, /* less-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_lessorequal_mstack, /* lessorequal-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n0___rr0, /* load-boxed-literal/n0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n0___rr1, /* load-boxed-literal/n0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n0___rrR, /* load-boxed-literal/n0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n1___rr0, /* load-boxed-literal/n1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n1___rr1, /* load-boxed-literal/n1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n1___rrR, /* load-boxed-literal/n1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n2___rr0, /* load-boxed-literal/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n2___rr1, /* load-boxed-literal/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n2___rrR, /* load-boxed-literal/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n3___rr0, /* load-boxed-literal/n3/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n3___rr1, /* load-boxed-literal/n3/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n3___rrR, /* load-boxed-literal/n3/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n4___rr0, /* load-boxed-literal/n4/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n4___rr1, /* load-boxed-literal/n4/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n4___rrR, /* load-boxed-literal/n4/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n5___rr0, /* load-boxed-literal/n5/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n5___rr1, /* load-boxed-literal/n5/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n5___rrR, /* load-boxed-literal/n5/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n6___rr0, /* load-boxed-literal/n6/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n6___rr1, /* load-boxed-literal/n6/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n6___rrR, /* load-boxed-literal/n6/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n7___rr0, /* load-boxed-literal/n7/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n7___rr1, /* load-boxed-literal/n7/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n7___rrR, /* load-boxed-literal/n7/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n8___rr0, /* load-boxed-literal/n8/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n8___rr1, /* load-boxed-literal/n8/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n8___rrR, /* load-boxed-literal/n8/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n9___rr0, /* load-boxed-literal/n9/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n9___rr1, /* load-boxed-literal/n9/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n9___rrR, /* load-boxed-literal/n9/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n10___rr0, /* load-boxed-literal/n10/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n10___rr1, /* load-boxed-literal/n10/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__n10___rrR, /* load-boxed-literal/n10/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__nR___rr0, /* load-boxed-literal/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__nR___rr1, /* load-boxed-literal/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_load_mboxed_mliteral__nR___rrR, /* load-boxed-literal/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_logicaland_mstack, /* logicaland-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_logicalnot_mstack, /* logicalnot-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_logicalor_mstack, /* logicalor-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rr0___rr0, /* minus/%r0/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rr0___rr1, /* minus/%r0/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rr0___rrR, /* minus/%r0/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rr1___rr0, /* minus/%r0/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rr1___rr1, /* minus/%r0/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rr1___rrR, /* minus/%r0/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rrR___rr0, /* minus/%r0/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rrR___rr1, /* minus/%r0/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0___rrR___rrR, /* minus/%r0/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__n1___rr0, /* minus/%r0/n1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__n1___rr1, /* minus/%r0/n1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__n1___rrR, /* minus/%r0/n1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__n2___rr0, /* minus/%r0/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__n2___rr1, /* minus/%r0/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__n2___rrR, /* minus/%r0/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__nR___rr0, /* minus/%r0/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__nR___rr1, /* minus/%r0/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr0__nR___rrR, /* minus/%r0/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rr0___rr0, /* minus/%r1/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rr0___rr1, /* minus/%r1/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rr0___rrR, /* minus/%r1/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rr1___rr0, /* minus/%r1/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rr1___rr1, /* minus/%r1/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rr1___rrR, /* minus/%r1/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rrR___rr0, /* minus/%r1/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rrR___rr1, /* minus/%r1/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1___rrR___rrR, /* minus/%r1/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__n1___rr0, /* minus/%r1/n1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__n1___rr1, /* minus/%r1/n1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__n1___rrR, /* minus/%r1/n1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__n2___rr0, /* minus/%r1/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__n2___rr1, /* minus/%r1/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__n2___rrR, /* minus/%r1/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__nR___rr0, /* minus/%r1/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__nR___rr1, /* minus/%r1/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rr1__nR___rrR, /* minus/%r1/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rr0___rr0, /* minus/%rR/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rr0___rr1, /* minus/%rR/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rr0___rrR, /* minus/%rR/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rr1___rr0, /* minus/%rR/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rr1___rr1, /* minus/%rR/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rr1___rrR, /* minus/%rR/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rrR___rr0, /* minus/%rR/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rrR___rr1, /* minus/%rR/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR___rrR___rrR, /* minus/%rR/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__n1___rr0, /* minus/%rR/n1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__n1___rr1, /* minus/%rR/n1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__n1___rrR, /* minus/%rR/n1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__n2___rr0, /* minus/%rR/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__n2___rr1, /* minus/%rR/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__n2___rrR, /* minus/%rR/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__nR___rr0, /* minus/%rR/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__nR___rr1, /* minus/%rR/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus___rrR__nR___rrR, /* minus/%rR/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rr0___rr0, /* minus/nR/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rr0___rr1, /* minus/nR/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rr0___rrR, /* minus/nR/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rr1___rr0, /* minus/nR/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rr1___rr1, /* minus/nR/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rr1___rrR, /* minus/nR/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rrR___rr0, /* minus/nR/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rrR___rr1, /* minus/nR/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR___rrR___rrR, /* minus/nR/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__n1___rr0, /* minus/nR/n1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__n1___rr1, /* minus/nR/n1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__n1___rrR, /* minus/nR/n1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__n2___rr0, /* minus/nR/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__n2___rr1, /* minus/nR/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__n2___rrR, /* minus/nR/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__nR___rr0, /* minus/nR/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__nR___rr1, /* minus/nR/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus__nR__nR___rrR, /* minus/nR/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minus_mstack, /* minus-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minusi_mstack__n1, /* minusi-stack/n1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minusi_mstack__n2, /* minusi-stack/n2 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_minusi_mstack__nR, /* minusi-stack/nR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rr0___rr0, /* mov/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rr0___rr1, /* mov/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rr0___rrR, /* mov/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rr1___rr0, /* mov/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rr1___rr1, /* mov/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rr1___rrR, /* mov/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rrR___rr0, /* mov/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rrR___rr1, /* mov/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov___rrR___rrR, /* mov/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n0___rr0, /* mov/n0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n0___rr1, /* mov/n0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n0___rrR, /* mov/n0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n1___rr0, /* mov/n1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n1___rr1, /* mov/n1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n1___rrR, /* mov/n1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n_m1___rr0, /* mov/n-1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n_m1___rr1, /* mov/n-1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n_m1___rrR, /* mov/n-1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n2___rr0, /* mov/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n2___rr1, /* mov/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__n2___rrR, /* mov/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__nR___rr0, /* mov/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__nR___rr1, /* mov/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_mov__nR___rrR, /* mov/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rr0___rr0, /* plus/%r0/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rr0___rr1, /* plus/%r0/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rr0___rrR, /* plus/%r0/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rr1___rr0, /* plus/%r0/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rr1___rr1, /* plus/%r0/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rr1___rrR, /* plus/%r0/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rrR___rr0, /* plus/%r0/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rrR___rr1, /* plus/%r0/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0___rrR___rrR, /* plus/%r0/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__n1___rr0, /* plus/%r0/n1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__n1___rr1, /* plus/%r0/n1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__n1___rrR, /* plus/%r0/n1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__n2___rr0, /* plus/%r0/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__n2___rr1, /* plus/%r0/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__n2___rrR, /* plus/%r0/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__nR___rr0, /* plus/%r0/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__nR___rr1, /* plus/%r0/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr0__nR___rrR, /* plus/%r0/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rr0___rr0, /* plus/%r1/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rr0___rr1, /* plus/%r1/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rr0___rrR, /* plus/%r1/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rr1___rr0, /* plus/%r1/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rr1___rr1, /* plus/%r1/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rr1___rrR, /* plus/%r1/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rrR___rr0, /* plus/%r1/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rrR___rr1, /* plus/%r1/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1___rrR___rrR, /* plus/%r1/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__n1___rr0, /* plus/%r1/n1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__n1___rr1, /* plus/%r1/n1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__n1___rrR, /* plus/%r1/n1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__n2___rr0, /* plus/%r1/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__n2___rr1, /* plus/%r1/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__n2___rrR, /* plus/%r1/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__nR___rr0, /* plus/%r1/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__nR___rr1, /* plus/%r1/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rr1__nR___rrR, /* plus/%r1/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rr0___rr0, /* plus/%rR/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rr0___rr1, /* plus/%rR/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rr0___rrR, /* plus/%rR/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rr1___rr0, /* plus/%rR/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rr1___rr1, /* plus/%rR/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rr1___rrR, /* plus/%rR/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rrR___rr0, /* plus/%rR/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rrR___rr1, /* plus/%rR/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR___rrR___rrR, /* plus/%rR/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__n1___rr0, /* plus/%rR/n1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__n1___rr1, /* plus/%rR/n1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__n1___rrR, /* plus/%rR/n1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__n2___rr0, /* plus/%rR/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__n2___rr1, /* plus/%rR/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__n2___rrR, /* plus/%rR/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__nR___rr0, /* plus/%rR/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__nR___rr1, /* plus/%rR/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus___rrR__nR___rrR, /* plus/%rR/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1___rr0___rr0, /* plus/n1/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1___rr0___rr1, /* plus/n1/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1___rr0___rrR, /* plus/n1/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1___rr1___rr0, /* plus/n1/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1___rr1___rr1, /* plus/n1/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1___rr1___rrR, /* plus/n1/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1___rrR___rr0, /* plus/n1/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1___rrR___rr1, /* plus/n1/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1___rrR___rrR, /* plus/n1/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1__n1___rr0, /* plus/n1/n1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1__n1___rr1, /* plus/n1/n1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1__n1___rrR, /* plus/n1/n1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1__n2___rr0, /* plus/n1/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1__n2___rr1, /* plus/n1/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1__n2___rrR, /* plus/n1/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1__nR___rr0, /* plus/n1/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1__nR___rr1, /* plus/n1/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n1__nR___rrR, /* plus/n1/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2___rr0___rr0, /* plus/n2/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2___rr0___rr1, /* plus/n2/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2___rr0___rrR, /* plus/n2/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2___rr1___rr0, /* plus/n2/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2___rr1___rr1, /* plus/n2/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2___rr1___rrR, /* plus/n2/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2___rrR___rr0, /* plus/n2/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2___rrR___rr1, /* plus/n2/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2___rrR___rrR, /* plus/n2/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2__n1___rr0, /* plus/n2/n1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2__n1___rr1, /* plus/n2/n1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2__n1___rrR, /* plus/n2/n1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2__n2___rr0, /* plus/n2/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2__n2___rr1, /* plus/n2/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2__n2___rrR, /* plus/n2/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2__nR___rr0, /* plus/n2/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2__nR___rr1, /* plus/n2/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__n2__nR___rrR, /* plus/n2/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rr0___rr0, /* plus/nR/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rr0___rr1, /* plus/nR/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rr0___rrR, /* plus/nR/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rr1___rr0, /* plus/nR/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rr1___rr1, /* plus/nR/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rr1___rrR, /* plus/nR/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rrR___rr0, /* plus/nR/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rrR___rr1, /* plus/nR/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR___rrR___rrR, /* plus/nR/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__n1___rr0, /* plus/nR/n1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__n1___rr1, /* plus/nR/n1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__n1___rrR, /* plus/nR/n1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__n2___rr0, /* plus/nR/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__n2___rr1, /* plus/nR/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__n2___rrR, /* plus/nR/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__nR___rr0, /* plus/nR/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__nR___rr1, /* plus/nR/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus__nR__nR___rrR, /* plus/nR/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plus_mstack, /* plus-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plusi_mstack__n_m1, /* plusi-stack/n-1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plusi_mstack__n1, /* plusi-stack/n1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plusi_mstack__n2, /* plusi-stack/n2 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_plusi_mstack__nR, /* plusi-stack/nR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pop_mstack___rr0, /* pop-stack/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pop_mstack___rr1, /* pop-stack/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_pop_mstack___rrR, /* pop-stack/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_print___rr0__retR, /* print/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_print___rr1__retR, /* print/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_print___rrR__retR, /* print/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_print__nR__retR, /* print/nR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_print_mstack__retR, /* print-stack/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mprocedure_mprolog__retR, /* procedure-prolog is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-procedure-prolog/retR. */
    structuredvm_specialized_instruction_opcode_push_mboxed_mliteral__n0, /* push-boxed-literal/n0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mboxed_mliteral__n1, /* push-boxed-literal/n1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mboxed_mliteral__n2, /* push-boxed-literal/n2 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mboxed_mliteral__n3, /* push-boxed-literal/n3 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mboxed_mliteral__n4, /* push-boxed-literal/n4 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mboxed_mliteral__n5, /* push-boxed-literal/n5 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mboxed_mliteral__n6, /* push-boxed-literal/n6 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mboxed_mliteral__n7, /* push-boxed-literal/n7 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mboxed_mliteral__n8, /* push-boxed-literal/n8 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mboxed_mliteral__n9, /* push-boxed-literal/n9 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mboxed_mliteral__n10, /* push-boxed-literal/n10 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mboxed_mliteral__nR, /* push-boxed-literal/nR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack___rr0, /* push-stack/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack___rr1, /* push-stack/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack___rrR, /* push-stack/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack__n0, /* push-stack/n0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack__n1, /* push-stack/n1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack__n_m1, /* push-stack/n-1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack__n2, /* push-stack/n2 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack__nR, /* push-stack/nR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_mstack__lR, /* push-stack/lR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_push_munspecified_mstack, /* push-unspecified-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rr0___rr0__retR, /* remainder/%r0/%r0/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rr0___rr1__retR, /* remainder/%r0/%r0/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rr0___rrR__retR, /* remainder/%r0/%r0/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rr1___rr0__retR, /* remainder/%r0/%r1/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rr1___rr1__retR, /* remainder/%r0/%r1/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rr1___rrR__retR, /* remainder/%r0/%r1/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rrR___rr0__retR, /* remainder/%r0/%rR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rrR___rr1__retR, /* remainder/%r0/%rR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0___rrR___rrR__retR, /* remainder/%r0/%rR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0__n2___rr0__retR, /* remainder/%r0/n2/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0__n2___rr1__retR, /* remainder/%r0/n2/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0__n2___rrR__retR, /* remainder/%r0/n2/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0__nR___rr0__retR, /* remainder/%r0/nR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0__nR___rr1__retR, /* remainder/%r0/nR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr0__nR___rrR__retR, /* remainder/%r0/nR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rr0___rr0__retR, /* remainder/%r1/%r0/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rr0___rr1__retR, /* remainder/%r1/%r0/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rr0___rrR__retR, /* remainder/%r1/%r0/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rr1___rr0__retR, /* remainder/%r1/%r1/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rr1___rr1__retR, /* remainder/%r1/%r1/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rr1___rrR__retR, /* remainder/%r1/%r1/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rrR___rr0__retR, /* remainder/%r1/%rR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rrR___rr1__retR, /* remainder/%r1/%rR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1___rrR___rrR__retR, /* remainder/%r1/%rR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1__n2___rr0__retR, /* remainder/%r1/n2/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1__n2___rr1__retR, /* remainder/%r1/n2/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1__n2___rrR__retR, /* remainder/%r1/n2/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1__nR___rr0__retR, /* remainder/%r1/nR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1__nR___rr1__retR, /* remainder/%r1/nR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rr1__nR___rrR__retR, /* remainder/%r1/nR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rr0___rr0__retR, /* remainder/%rR/%r0/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rr0___rr1__retR, /* remainder/%rR/%r0/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rr0___rrR__retR, /* remainder/%rR/%r0/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rr1___rr0__retR, /* remainder/%rR/%r1/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rr1___rr1__retR, /* remainder/%rR/%r1/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rr1___rrR__retR, /* remainder/%rR/%r1/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rrR___rr0__retR, /* remainder/%rR/%rR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rrR___rr1__retR, /* remainder/%rR/%rR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR___rrR___rrR__retR, /* remainder/%rR/%rR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR__n2___rr0__retR, /* remainder/%rR/n2/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR__n2___rr1__retR, /* remainder/%rR/n2/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR__n2___rrR__retR, /* remainder/%rR/n2/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR__nR___rr0__retR, /* remainder/%rR/nR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR__nR___rr1__retR, /* remainder/%rR/nR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder___rrR__nR___rrR__retR, /* remainder/%rR/nR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rr0___rr0__retR, /* remainder/nR/%r0/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rr0___rr1__retR, /* remainder/nR/%r0/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rr0___rrR__retR, /* remainder/nR/%r0/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rr1___rr0__retR, /* remainder/nR/%r1/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rr1___rr1__retR, /* remainder/nR/%r1/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rr1___rrR__retR, /* remainder/nR/%r1/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rrR___rr0__retR, /* remainder/nR/%rR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rrR___rr1__retR, /* remainder/nR/%rR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR___rrR___rrR__retR, /* remainder/nR/%rR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR__n2___rr0__retR, /* remainder/nR/n2/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR__n2___rr1__retR, /* remainder/nR/n2/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR__n2___rrR__retR, /* remainder/nR/n2/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR__nR___rr0__retR, /* remainder/nR/nR/%r0/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR__nR___rr1__retR, /* remainder/nR/nR/%r1/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder__nR__nR___rrR__retR, /* remainder/nR/nR/%rR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_remainder_mstack__retR, /* remainder-stack/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mreturn_mto_mundertop__retR, /* return-to-undertop is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-return-to-undertop/retR. */
    structuredvm_specialized_instruction_opcode_swap_mstack, /* swap-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rr0___rr0, /* times/%r0/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rr0___rr1, /* times/%r0/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rr0___rrR, /* times/%r0/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rr1___rr0, /* times/%r0/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rr1___rr1, /* times/%r0/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rr1___rrR, /* times/%r0/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rrR___rr0, /* times/%r0/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rrR___rr1, /* times/%r0/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0___rrR___rrR, /* times/%r0/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0__n2___rr0, /* times/%r0/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0__n2___rr1, /* times/%r0/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0__n2___rrR, /* times/%r0/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0__nR___rr0, /* times/%r0/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0__nR___rr1, /* times/%r0/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr0__nR___rrR, /* times/%r0/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rr0___rr0, /* times/%r1/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rr0___rr1, /* times/%r1/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rr0___rrR, /* times/%r1/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rr1___rr0, /* times/%r1/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rr1___rr1, /* times/%r1/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rr1___rrR, /* times/%r1/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rrR___rr0, /* times/%r1/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rrR___rr1, /* times/%r1/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1___rrR___rrR, /* times/%r1/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1__n2___rr0, /* times/%r1/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1__n2___rr1, /* times/%r1/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1__n2___rrR, /* times/%r1/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1__nR___rr0, /* times/%r1/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1__nR___rr1, /* times/%r1/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rr1__nR___rrR, /* times/%r1/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rr0___rr0, /* times/%rR/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rr0___rr1, /* times/%rR/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rr0___rrR, /* times/%rR/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rr1___rr0, /* times/%rR/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rr1___rr1, /* times/%rR/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rr1___rrR, /* times/%rR/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rrR___rr0, /* times/%rR/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rrR___rr1, /* times/%rR/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR___rrR___rrR, /* times/%rR/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR__n2___rr0, /* times/%rR/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR__n2___rr1, /* times/%rR/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR__n2___rrR, /* times/%rR/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR__nR___rr0, /* times/%rR/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR__nR___rr1, /* times/%rR/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times___rrR__nR___rrR, /* times/%rR/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rr0___rr0, /* times/nR/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rr0___rr1, /* times/nR/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rr0___rrR, /* times/nR/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rr1___rr0, /* times/nR/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rr1___rr1, /* times/nR/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rr1___rrR, /* times/nR/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rrR___rr0, /* times/nR/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rrR___rr1, /* times/nR/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR___rrR___rrR, /* times/nR/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR__n2___rr0, /* times/nR/n2/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR__n2___rr1, /* times/nR/n2/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR__n2___rrR, /* times/nR/n2/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR__nR___rr0, /* times/nR/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR__nR___rr1, /* times/nR/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times__nR__nR___rrR, /* times/nR/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_times_mstack, /* times-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rr0___rr0, /* uminus/%r0/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rr0___rr1, /* uminus/%r0/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rr0___rrR, /* uminus/%r0/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rr1___rr0, /* uminus/%r1/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rr1___rr1, /* uminus/%r1/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rr1___rrR, /* uminus/%r1/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rrR___rr0, /* uminus/%rR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rrR___rr1, /* uminus/%rR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus___rrR___rrR, /* uminus/%rR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus__nR___rr0, /* uminus/nR/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus__nR___rr1, /* uminus/nR/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus__nR___rrR, /* uminus/nR/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_uminus_mstack, /* uminus-stack is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_underpop_mstack___rr0, /* underpop-stack/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_underpop_mstack___rr1, /* underpop-stack/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_underpop_mstack___rrR, /* underpop-stack/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_underpush_mstack___rr0, /* underpush-stack/%r0 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_underpush_mstack___rr1, /* underpush-stack/%r1 is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_underpush_mstack___rrR, /* underpush-stack/%rR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode_underpush_mstack__nR, /* underpush-stack/nR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_munreachable__retR, /* unreachable is POTENTIALLY DEFECTIVE, and replaced by !REPLACEMENT-unreachable/retR. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mb__fR__retR, /* !REPLACEMENT-b/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr0___rr0__fR__retR, /* !REPLACEMENT-be/%r0/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr0___rr1__fR__retR, /* !REPLACEMENT-be/%r0/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr0___rrR__fR__retR, /* !REPLACEMENT-be/%r0/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr0__n0__fR__retR, /* !REPLACEMENT-be/%r0/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr0__nR__fR__retR, /* !REPLACEMENT-be/%r0/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr1___rr0__fR__retR, /* !REPLACEMENT-be/%r1/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr1___rr1__fR__retR, /* !REPLACEMENT-be/%r1/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr1___rrR__fR__retR, /* !REPLACEMENT-be/%r1/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr1__n0__fR__retR, /* !REPLACEMENT-be/%r1/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rr1__nR__fR__retR, /* !REPLACEMENT-be/%r1/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rrR___rr0__fR__retR, /* !REPLACEMENT-be/%rR/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rrR___rr1__fR__retR, /* !REPLACEMENT-be/%rR/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rrR___rrR__fR__retR, /* !REPLACEMENT-be/%rR/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rrR__n0__fR__retR, /* !REPLACEMENT-be/%rR/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe___rrR__nR__fR__retR, /* !REPLACEMENT-be/%rR/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__n0___rr0__fR__retR, /* !REPLACEMENT-be/n0/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__n0___rr1__fR__retR, /* !REPLACEMENT-be/n0/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__n0___rrR__fR__retR, /* !REPLACEMENT-be/n0/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__n0__n0__fR__retR, /* !REPLACEMENT-be/n0/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__n0__nR__fR__retR, /* !REPLACEMENT-be/n0/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__nR___rr0__fR__retR, /* !REPLACEMENT-be/nR/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__nR___rr1__fR__retR, /* !REPLACEMENT-be/nR/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__nR___rrR__fR__retR, /* !REPLACEMENT-be/nR/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__nR__n0__fR__retR, /* !REPLACEMENT-be/nR/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbe__nR__nR__fR__retR, /* !REPLACEMENT-be/nR/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbeqi_mstack__n_m1__fR__retR, /* !REPLACEMENT-beqi-stack/n-1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbeqi_mstack__n0__fR__retR, /* !REPLACEMENT-beqi-stack/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbeqi_mstack__n1__fR__retR, /* !REPLACEMENT-beqi-stack/n1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbeqi_mstack__n2__fR__retR, /* !REPLACEMENT-beqi-stack/n2/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbeqi_mstack__nR__fR__retR, /* !REPLACEMENT-beqi-stack/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbf_mstack__fR__retR, /* !REPLACEMENT-bf-stack/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr0___rr0__fR__retR, /* !REPLACEMENT-bg/%r0/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr0___rr1__fR__retR, /* !REPLACEMENT-bg/%r0/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr0___rrR__fR__retR, /* !REPLACEMENT-bg/%r0/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr0__n0__fR__retR, /* !REPLACEMENT-bg/%r0/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr0__nR__fR__retR, /* !REPLACEMENT-bg/%r0/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr1___rr0__fR__retR, /* !REPLACEMENT-bg/%r1/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr1___rr1__fR__retR, /* !REPLACEMENT-bg/%r1/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr1___rrR__fR__retR, /* !REPLACEMENT-bg/%r1/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr1__n0__fR__retR, /* !REPLACEMENT-bg/%r1/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rr1__nR__fR__retR, /* !REPLACEMENT-bg/%r1/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rrR___rr0__fR__retR, /* !REPLACEMENT-bg/%rR/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rrR___rr1__fR__retR, /* !REPLACEMENT-bg/%rR/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rrR___rrR__fR__retR, /* !REPLACEMENT-bg/%rR/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rrR__n0__fR__retR, /* !REPLACEMENT-bg/%rR/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg___rrR__nR__fR__retR, /* !REPLACEMENT-bg/%rR/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__n0___rr0__fR__retR, /* !REPLACEMENT-bg/n0/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__n0___rr1__fR__retR, /* !REPLACEMENT-bg/n0/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__n0___rrR__fR__retR, /* !REPLACEMENT-bg/n0/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__n0__n0__fR__retR, /* !REPLACEMENT-bg/n0/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__n0__nR__fR__retR, /* !REPLACEMENT-bg/n0/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__nR___rr0__fR__retR, /* !REPLACEMENT-bg/nR/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__nR___rr1__fR__retR, /* !REPLACEMENT-bg/nR/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__nR___rrR__fR__retR, /* !REPLACEMENT-bg/nR/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__nR__n0__fR__retR, /* !REPLACEMENT-bg/nR/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbg__nR__nR__fR__retR, /* !REPLACEMENT-bg/nR/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr0___rr0__fR__retR, /* !REPLACEMENT-bge/%r0/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr0___rr1__fR__retR, /* !REPLACEMENT-bge/%r0/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr0___rrR__fR__retR, /* !REPLACEMENT-bge/%r0/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr0__n0__fR__retR, /* !REPLACEMENT-bge/%r0/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr0__nR__fR__retR, /* !REPLACEMENT-bge/%r0/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr1___rr0__fR__retR, /* !REPLACEMENT-bge/%r1/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr1___rr1__fR__retR, /* !REPLACEMENT-bge/%r1/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr1___rrR__fR__retR, /* !REPLACEMENT-bge/%r1/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr1__n0__fR__retR, /* !REPLACEMENT-bge/%r1/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rr1__nR__fR__retR, /* !REPLACEMENT-bge/%r1/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR___rr0__fR__retR, /* !REPLACEMENT-bge/%rR/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR___rr1__fR__retR, /* !REPLACEMENT-bge/%rR/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR___rrR__fR__retR, /* !REPLACEMENT-bge/%rR/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR__n0__fR__retR, /* !REPLACEMENT-bge/%rR/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge___rrR__nR__fR__retR, /* !REPLACEMENT-bge/%rR/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__n0___rr0__fR__retR, /* !REPLACEMENT-bge/n0/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__n0___rr1__fR__retR, /* !REPLACEMENT-bge/n0/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__n0___rrR__fR__retR, /* !REPLACEMENT-bge/n0/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__n0__n0__fR__retR, /* !REPLACEMENT-bge/n0/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__n0__nR__fR__retR, /* !REPLACEMENT-bge/n0/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__nR___rr0__fR__retR, /* !REPLACEMENT-bge/nR/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__nR___rr1__fR__retR, /* !REPLACEMENT-bge/nR/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__nR___rrR__fR__retR, /* !REPLACEMENT-bge/nR/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__nR__n0__fR__retR, /* !REPLACEMENT-bge/nR/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbge__nR__nR__fR__retR, /* !REPLACEMENT-bge/nR/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr0___rr0__fR__retR, /* !REPLACEMENT-bl/%r0/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr0___rr1__fR__retR, /* !REPLACEMENT-bl/%r0/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr0___rrR__fR__retR, /* !REPLACEMENT-bl/%r0/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr0__n0__fR__retR, /* !REPLACEMENT-bl/%r0/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr0__nR__fR__retR, /* !REPLACEMENT-bl/%r0/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr1___rr0__fR__retR, /* !REPLACEMENT-bl/%r1/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr1___rr1__fR__retR, /* !REPLACEMENT-bl/%r1/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr1___rrR__fR__retR, /* !REPLACEMENT-bl/%r1/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr1__n0__fR__retR, /* !REPLACEMENT-bl/%r1/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rr1__nR__fR__retR, /* !REPLACEMENT-bl/%r1/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rrR___rr0__fR__retR, /* !REPLACEMENT-bl/%rR/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rrR___rr1__fR__retR, /* !REPLACEMENT-bl/%rR/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rrR___rrR__fR__retR, /* !REPLACEMENT-bl/%rR/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rrR__n0__fR__retR, /* !REPLACEMENT-bl/%rR/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl___rrR__nR__fR__retR, /* !REPLACEMENT-bl/%rR/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__n0___rr0__fR__retR, /* !REPLACEMENT-bl/n0/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__n0___rr1__fR__retR, /* !REPLACEMENT-bl/n0/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__n0___rrR__fR__retR, /* !REPLACEMENT-bl/n0/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__n0__n0__fR__retR, /* !REPLACEMENT-bl/n0/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__n0__nR__fR__retR, /* !REPLACEMENT-bl/n0/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__nR___rr0__fR__retR, /* !REPLACEMENT-bl/nR/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__nR___rr1__fR__retR, /* !REPLACEMENT-bl/nR/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__nR___rrR__fR__retR, /* !REPLACEMENT-bl/nR/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__nR__n0__fR__retR, /* !REPLACEMENT-bl/nR/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbl__nR__nR__fR__retR, /* !REPLACEMENT-bl/nR/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr0___rr0__fR__retR, /* !REPLACEMENT-ble/%r0/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr0___rr1__fR__retR, /* !REPLACEMENT-ble/%r0/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr0___rrR__fR__retR, /* !REPLACEMENT-ble/%r0/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr0__n0__fR__retR, /* !REPLACEMENT-ble/%r0/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr0__nR__fR__retR, /* !REPLACEMENT-ble/%r0/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr1___rr0__fR__retR, /* !REPLACEMENT-ble/%r1/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr1___rr1__fR__retR, /* !REPLACEMENT-ble/%r1/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr1___rrR__fR__retR, /* !REPLACEMENT-ble/%r1/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr1__n0__fR__retR, /* !REPLACEMENT-ble/%r1/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rr1__nR__fR__retR, /* !REPLACEMENT-ble/%r1/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rrR___rr0__fR__retR, /* !REPLACEMENT-ble/%rR/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rrR___rr1__fR__retR, /* !REPLACEMENT-ble/%rR/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rrR___rrR__fR__retR, /* !REPLACEMENT-ble/%rR/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rrR__n0__fR__retR, /* !REPLACEMENT-ble/%rR/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble___rrR__nR__fR__retR, /* !REPLACEMENT-ble/%rR/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__n0___rr0__fR__retR, /* !REPLACEMENT-ble/n0/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__n0___rr1__fR__retR, /* !REPLACEMENT-ble/n0/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__n0___rrR__fR__retR, /* !REPLACEMENT-ble/n0/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__n0__n0__fR__retR, /* !REPLACEMENT-ble/n0/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__n0__nR__fR__retR, /* !REPLACEMENT-ble/n0/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__nR___rr0__fR__retR, /* !REPLACEMENT-ble/nR/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__nR___rr1__fR__retR, /* !REPLACEMENT-ble/nR/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__nR___rrR__fR__retR, /* !REPLACEMENT-ble/nR/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__nR__n0__fR__retR, /* !REPLACEMENT-ble/nR/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mble__nR__nR__fR__retR, /* !REPLACEMENT-ble/nR/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr0___rr0__fR__retR, /* !REPLACEMENT-bne/%r0/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr0___rr1__fR__retR, /* !REPLACEMENT-bne/%r0/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr0___rrR__fR__retR, /* !REPLACEMENT-bne/%r0/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr0__n0__fR__retR, /* !REPLACEMENT-bne/%r0/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr0__nR__fR__retR, /* !REPLACEMENT-bne/%r0/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr1___rr0__fR__retR, /* !REPLACEMENT-bne/%r1/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr1___rr1__fR__retR, /* !REPLACEMENT-bne/%r1/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr1___rrR__fR__retR, /* !REPLACEMENT-bne/%r1/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr1__n0__fR__retR, /* !REPLACEMENT-bne/%r1/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rr1__nR__fR__retR, /* !REPLACEMENT-bne/%r1/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR___rr0__fR__retR, /* !REPLACEMENT-bne/%rR/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR___rr1__fR__retR, /* !REPLACEMENT-bne/%rR/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR___rrR__fR__retR, /* !REPLACEMENT-bne/%rR/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR__n0__fR__retR, /* !REPLACEMENT-bne/%rR/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne___rrR__nR__fR__retR, /* !REPLACEMENT-bne/%rR/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__n0___rr0__fR__retR, /* !REPLACEMENT-bne/n0/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__n0___rr1__fR__retR, /* !REPLACEMENT-bne/n0/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__n0___rrR__fR__retR, /* !REPLACEMENT-bne/n0/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__n0__n0__fR__retR, /* !REPLACEMENT-bne/n0/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__n0__nR__fR__retR, /* !REPLACEMENT-bne/n0/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__nR___rr0__fR__retR, /* !REPLACEMENT-bne/nR/%r0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__nR___rr1__fR__retR, /* !REPLACEMENT-bne/nR/%r1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__nR___rrR__fR__retR, /* !REPLACEMENT-bne/nR/%rR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__nR__n0__fR__retR, /* !REPLACEMENT-bne/nR/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbne__nR__nR__fR__retR, /* !REPLACEMENT-bne/nR/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbneqi_mstack__n_m1__fR__retR, /* !REPLACEMENT-bneqi-stack/n-1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbneqi_mstack__n0__fR__retR, /* !REPLACEMENT-bneqi-stack/n0/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbneqi_mstack__n1__fR__retR, /* !REPLACEMENT-bneqi-stack/n1/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbneqi_mstack__n2__fR__retR, /* !REPLACEMENT-bneqi-stack/n2/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbneqi_mstack__nR__fR__retR, /* !REPLACEMENT-bneqi-stack/nR/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mbt_mstack__fR__retR, /* !REPLACEMENT-bt-stack/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mcall__fR__retR, /* !REPLACEMENT-call/fR/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mexitvm__retR, /* !REPLACEMENT-exitvm/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mprocedure_mprolog__retR, /* !REPLACEMENT-procedure-prolog/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_mreturn_mto_mundertop__retR, /* !REPLACEMENT-return-to-undertop/retR is NOT potentially defective. */
    structuredvm_specialized_instruction_opcode__eREPLACEMENT_munreachable__retR /* !REPLACEMENT-unreachable/retR is NOT potentially defective. */
  };
#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT


#ifdef JITTER_HAVE_DEFECT_REPLACEMENT
const jitter_uint
structuredvm_call_related_specialized_instruction_ids []
= {
    structuredvm_specialized_instruction_opcode_call__fR__retR,
    structuredvm_specialized_instruction_opcode_procedure_mprolog,
    structuredvm_specialized_instruction_opcode_return_mto_mundertop
  };

const jitter_uint
structuredvm_call_related_specialized_instruction_id_no
= sizeof (structuredvm_call_related_specialized_instruction_ids) / sizeof (jitter_uint);

const bool
structuredvm_specialized_instruction_call_relateds []
= {
    0, /* !INVALID */
    0, /* !BEGINBASICBLOCK */
    0, /* !EXITVM */
    0, /* !DATALOCATIONS */
    0, /* !NOP */
    0, /* !UNREACHABLE0 */
    0, /* !UNREACHABLE1 */
    0, /* !PRETENDTOJUMPANYWHERE */
    0, /* b/fR */
    0, /* be/%r0/%r0/fR */
    0, /* be/%r0/%r1/fR */
    0, /* be/%r0/%rR/fR */
    0, /* be/%r0/n0/fR */
    0, /* be/%r0/nR/fR */
    0, /* be/%r1/%r0/fR */
    0, /* be/%r1/%r1/fR */
    0, /* be/%r1/%rR/fR */
    0, /* be/%r1/n0/fR */
    0, /* be/%r1/nR/fR */
    0, /* be/%rR/%r0/fR */
    0, /* be/%rR/%r1/fR */
    0, /* be/%rR/%rR/fR */
    0, /* be/%rR/n0/fR */
    0, /* be/%rR/nR/fR */
    0, /* be/n0/%r0/fR */
    0, /* be/n0/%r1/fR */
    0, /* be/n0/%rR/fR */
    0, /* be/n0/n0/fR */
    0, /* be/n0/nR/fR */
    0, /* be/nR/%r0/fR */
    0, /* be/nR/%r1/fR */
    0, /* be/nR/%rR/fR */
    0, /* be/nR/n0/fR */
    0, /* be/nR/nR/fR */
    0, /* beqi-stack/n-1/fR */
    0, /* beqi-stack/n0/fR */
    0, /* beqi-stack/n1/fR */
    0, /* beqi-stack/n2/fR */
    0, /* beqi-stack/nR/fR */
    0, /* bf-stack/fR */
    0, /* bg/%r0/%r0/fR */
    0, /* bg/%r0/%r1/fR */
    0, /* bg/%r0/%rR/fR */
    0, /* bg/%r0/n0/fR */
    0, /* bg/%r0/nR/fR */
    0, /* bg/%r1/%r0/fR */
    0, /* bg/%r1/%r1/fR */
    0, /* bg/%r1/%rR/fR */
    0, /* bg/%r1/n0/fR */
    0, /* bg/%r1/nR/fR */
    0, /* bg/%rR/%r0/fR */
    0, /* bg/%rR/%r1/fR */
    0, /* bg/%rR/%rR/fR */
    0, /* bg/%rR/n0/fR */
    0, /* bg/%rR/nR/fR */
    0, /* bg/n0/%r0/fR */
    0, /* bg/n0/%r1/fR */
    0, /* bg/n0/%rR/fR */
    0, /* bg/n0/n0/fR */
    0, /* bg/n0/nR/fR */
    0, /* bg/nR/%r0/fR */
    0, /* bg/nR/%r1/fR */
    0, /* bg/nR/%rR/fR */
    0, /* bg/nR/n0/fR */
    0, /* bg/nR/nR/fR */
    0, /* bge/%r0/%r0/fR */
    0, /* bge/%r0/%r1/fR */
    0, /* bge/%r0/%rR/fR */
    0, /* bge/%r0/n0/fR */
    0, /* bge/%r0/nR/fR */
    0, /* bge/%r1/%r0/fR */
    0, /* bge/%r1/%r1/fR */
    0, /* bge/%r1/%rR/fR */
    0, /* bge/%r1/n0/fR */
    0, /* bge/%r1/nR/fR */
    0, /* bge/%rR/%r0/fR */
    0, /* bge/%rR/%r1/fR */
    0, /* bge/%rR/%rR/fR */
    0, /* bge/%rR/n0/fR */
    0, /* bge/%rR/nR/fR */
    0, /* bge/n0/%r0/fR */
    0, /* bge/n0/%r1/fR */
    0, /* bge/n0/%rR/fR */
    0, /* bge/n0/n0/fR */
    0, /* bge/n0/nR/fR */
    0, /* bge/nR/%r0/fR */
    0, /* bge/nR/%r1/fR */
    0, /* bge/nR/%rR/fR */
    0, /* bge/nR/n0/fR */
    0, /* bge/nR/nR/fR */
    0, /* bl/%r0/%r0/fR */
    0, /* bl/%r0/%r1/fR */
    0, /* bl/%r0/%rR/fR */
    0, /* bl/%r0/n0/fR */
    0, /* bl/%r0/nR/fR */
    0, /* bl/%r1/%r0/fR */
    0, /* bl/%r1/%r1/fR */
    0, /* bl/%r1/%rR/fR */
    0, /* bl/%r1/n0/fR */
    0, /* bl/%r1/nR/fR */
    0, /* bl/%rR/%r0/fR */
    0, /* bl/%rR/%r1/fR */
    0, /* bl/%rR/%rR/fR */
    0, /* bl/%rR/n0/fR */
    0, /* bl/%rR/nR/fR */
    0, /* bl/n0/%r0/fR */
    0, /* bl/n0/%r1/fR */
    0, /* bl/n0/%rR/fR */
    0, /* bl/n0/n0/fR */
    0, /* bl/n0/nR/fR */
    0, /* bl/nR/%r0/fR */
    0, /* bl/nR/%r1/fR */
    0, /* bl/nR/%rR/fR */
    0, /* bl/nR/n0/fR */
    0, /* bl/nR/nR/fR */
    0, /* ble/%r0/%r0/fR */
    0, /* ble/%r0/%r1/fR */
    0, /* ble/%r0/%rR/fR */
    0, /* ble/%r0/n0/fR */
    0, /* ble/%r0/nR/fR */
    0, /* ble/%r1/%r0/fR */
    0, /* ble/%r1/%r1/fR */
    0, /* ble/%r1/%rR/fR */
    0, /* ble/%r1/n0/fR */
    0, /* ble/%r1/nR/fR */
    0, /* ble/%rR/%r0/fR */
    0, /* ble/%rR/%r1/fR */
    0, /* ble/%rR/%rR/fR */
    0, /* ble/%rR/n0/fR */
    0, /* ble/%rR/nR/fR */
    0, /* ble/n0/%r0/fR */
    0, /* ble/n0/%r1/fR */
    0, /* ble/n0/%rR/fR */
    0, /* ble/n0/n0/fR */
    0, /* ble/n0/nR/fR */
    0, /* ble/nR/%r0/fR */
    0, /* ble/nR/%r1/fR */
    0, /* ble/nR/%rR/fR */
    0, /* ble/nR/n0/fR */
    0, /* ble/nR/nR/fR */
    0, /* bne/%r0/%r0/fR */
    0, /* bne/%r0/%r1/fR */
    0, /* bne/%r0/%rR/fR */
    0, /* bne/%r0/n0/fR */
    0, /* bne/%r0/nR/fR */
    0, /* bne/%r1/%r0/fR */
    0, /* bne/%r1/%r1/fR */
    0, /* bne/%r1/%rR/fR */
    0, /* bne/%r1/n0/fR */
    0, /* bne/%r1/nR/fR */
    0, /* bne/%rR/%r0/fR */
    0, /* bne/%rR/%r1/fR */
    0, /* bne/%rR/%rR/fR */
    0, /* bne/%rR/n0/fR */
    0, /* bne/%rR/nR/fR */
    0, /* bne/n0/%r0/fR */
    0, /* bne/n0/%r1/fR */
    0, /* bne/n0/%rR/fR */
    0, /* bne/n0/n0/fR */
    0, /* bne/n0/nR/fR */
    0, /* bne/nR/%r0/fR */
    0, /* bne/nR/%r1/fR */
    0, /* bne/nR/%rR/fR */
    0, /* bne/nR/n0/fR */
    0, /* bne/nR/nR/fR */
    0, /* bneqi-stack/n-1/fR */
    0, /* bneqi-stack/n0/fR */
    0, /* bneqi-stack/n1/fR */
    0, /* bneqi-stack/n2/fR */
    0, /* bneqi-stack/nR/fR */
    0, /* bt-stack/fR */
    1, /* call/fR/retR */
    0, /* copy-to-r-stack/%r0 */
    0, /* copy-to-r-stack/%r1 */
    0, /* copy-to-r-stack/%rR */
    0, /* different-stack */
    0, /* divided/%r0/%r0/%r0/retR */
    0, /* divided/%r0/%r0/%r1/retR */
    0, /* divided/%r0/%r0/%rR/retR */
    0, /* divided/%r0/%r1/%r0/retR */
    0, /* divided/%r0/%r1/%r1/retR */
    0, /* divided/%r0/%r1/%rR/retR */
    0, /* divided/%r0/%rR/%r0/retR */
    0, /* divided/%r0/%rR/%r1/retR */
    0, /* divided/%r0/%rR/%rR/retR */
    0, /* divided/%r0/n2/%r0/retR */
    0, /* divided/%r0/n2/%r1/retR */
    0, /* divided/%r0/n2/%rR/retR */
    0, /* divided/%r0/nR/%r0/retR */
    0, /* divided/%r0/nR/%r1/retR */
    0, /* divided/%r0/nR/%rR/retR */
    0, /* divided/%r1/%r0/%r0/retR */
    0, /* divided/%r1/%r0/%r1/retR */
    0, /* divided/%r1/%r0/%rR/retR */
    0, /* divided/%r1/%r1/%r0/retR */
    0, /* divided/%r1/%r1/%r1/retR */
    0, /* divided/%r1/%r1/%rR/retR */
    0, /* divided/%r1/%rR/%r0/retR */
    0, /* divided/%r1/%rR/%r1/retR */
    0, /* divided/%r1/%rR/%rR/retR */
    0, /* divided/%r1/n2/%r0/retR */
    0, /* divided/%r1/n2/%r1/retR */
    0, /* divided/%r1/n2/%rR/retR */
    0, /* divided/%r1/nR/%r0/retR */
    0, /* divided/%r1/nR/%r1/retR */
    0, /* divided/%r1/nR/%rR/retR */
    0, /* divided/%rR/%r0/%r0/retR */
    0, /* divided/%rR/%r0/%r1/retR */
    0, /* divided/%rR/%r0/%rR/retR */
    0, /* divided/%rR/%r1/%r0/retR */
    0, /* divided/%rR/%r1/%r1/retR */
    0, /* divided/%rR/%r1/%rR/retR */
    0, /* divided/%rR/%rR/%r0/retR */
    0, /* divided/%rR/%rR/%r1/retR */
    0, /* divided/%rR/%rR/%rR/retR */
    0, /* divided/%rR/n2/%r0/retR */
    0, /* divided/%rR/n2/%r1/retR */
    0, /* divided/%rR/n2/%rR/retR */
    0, /* divided/%rR/nR/%r0/retR */
    0, /* divided/%rR/nR/%r1/retR */
    0, /* divided/%rR/nR/%rR/retR */
    0, /* divided/nR/%r0/%r0/retR */
    0, /* divided/nR/%r0/%r1/retR */
    0, /* divided/nR/%r0/%rR/retR */
    0, /* divided/nR/%r1/%r0/retR */
    0, /* divided/nR/%r1/%r1/retR */
    0, /* divided/nR/%r1/%rR/retR */
    0, /* divided/nR/%rR/%r0/retR */
    0, /* divided/nR/%rR/%r1/retR */
    0, /* divided/nR/%rR/%rR/retR */
    0, /* divided/nR/n2/%r0/retR */
    0, /* divided/nR/n2/%r1/retR */
    0, /* divided/nR/n2/%rR/retR */
    0, /* divided/nR/nR/%r0/retR */
    0, /* divided/nR/nR/%r1/retR */
    0, /* divided/nR/nR/%rR/retR */
    0, /* divided-stack/retR */
    0, /* drop-stack */
    0, /* dup-stack */
    0, /* equal-stack */
    0, /* equali-stack/n0 */
    0, /* equali-stack/n1 */
    0, /* equali-stack/n2 */
    0, /* equali-stack/nR */
    0, /* exitvm */
    0, /* greater-stack */
    0, /* greaterorequal-stack */
    0, /* input/%r0/retR */
    0, /* input/%r1/retR */
    0, /* input/%rR/retR */
    0, /* input-stack/retR */
    0, /* isnonzero-stack */
    0, /* less-stack */
    0, /* lessorequal-stack */
    0, /* load-boxed-literal/n0/%r0 */
    0, /* load-boxed-literal/n0/%r1 */
    0, /* load-boxed-literal/n0/%rR */
    0, /* load-boxed-literal/n1/%r0 */
    0, /* load-boxed-literal/n1/%r1 */
    0, /* load-boxed-literal/n1/%rR */
    0, /* load-boxed-literal/n2/%r0 */
    0, /* load-boxed-literal/n2/%r1 */
    0, /* load-boxed-literal/n2/%rR */
    0, /* load-boxed-literal/n3/%r0 */
    0, /* load-boxed-literal/n3/%r1 */
    0, /* load-boxed-literal/n3/%rR */
    0, /* load-boxed-literal/n4/%r0 */
    0, /* load-boxed-literal/n4/%r1 */
    0, /* load-boxed-literal/n4/%rR */
    0, /* load-boxed-literal/n5/%r0 */
    0, /* load-boxed-literal/n5/%r1 */
    0, /* load-boxed-literal/n5/%rR */
    0, /* load-boxed-literal/n6/%r0 */
    0, /* load-boxed-literal/n6/%r1 */
    0, /* load-boxed-literal/n6/%rR */
    0, /* load-boxed-literal/n7/%r0 */
    0, /* load-boxed-literal/n7/%r1 */
    0, /* load-boxed-literal/n7/%rR */
    0, /* load-boxed-literal/n8/%r0 */
    0, /* load-boxed-literal/n8/%r1 */
    0, /* load-boxed-literal/n8/%rR */
    0, /* load-boxed-literal/n9/%r0 */
    0, /* load-boxed-literal/n9/%r1 */
    0, /* load-boxed-literal/n9/%rR */
    0, /* load-boxed-literal/n10/%r0 */
    0, /* load-boxed-literal/n10/%r1 */
    0, /* load-boxed-literal/n10/%rR */
    0, /* load-boxed-literal/nR/%r0 */
    0, /* load-boxed-literal/nR/%r1 */
    0, /* load-boxed-literal/nR/%rR */
    0, /* logicaland-stack */
    0, /* logicalnot-stack */
    0, /* logicalor-stack */
    0, /* minus/%r0/%r0/%r0 */
    0, /* minus/%r0/%r0/%r1 */
    0, /* minus/%r0/%r0/%rR */
    0, /* minus/%r0/%r1/%r0 */
    0, /* minus/%r0/%r1/%r1 */
    0, /* minus/%r0/%r1/%rR */
    0, /* minus/%r0/%rR/%r0 */
    0, /* minus/%r0/%rR/%r1 */
    0, /* minus/%r0/%rR/%rR */
    0, /* minus/%r0/n1/%r0 */
    0, /* minus/%r0/n1/%r1 */
    0, /* minus/%r0/n1/%rR */
    0, /* minus/%r0/n2/%r0 */
    0, /* minus/%r0/n2/%r1 */
    0, /* minus/%r0/n2/%rR */
    0, /* minus/%r0/nR/%r0 */
    0, /* minus/%r0/nR/%r1 */
    0, /* minus/%r0/nR/%rR */
    0, /* minus/%r1/%r0/%r0 */
    0, /* minus/%r1/%r0/%r1 */
    0, /* minus/%r1/%r0/%rR */
    0, /* minus/%r1/%r1/%r0 */
    0, /* minus/%r1/%r1/%r1 */
    0, /* minus/%r1/%r1/%rR */
    0, /* minus/%r1/%rR/%r0 */
    0, /* minus/%r1/%rR/%r1 */
    0, /* minus/%r1/%rR/%rR */
    0, /* minus/%r1/n1/%r0 */
    0, /* minus/%r1/n1/%r1 */
    0, /* minus/%r1/n1/%rR */
    0, /* minus/%r1/n2/%r0 */
    0, /* minus/%r1/n2/%r1 */
    0, /* minus/%r1/n2/%rR */
    0, /* minus/%r1/nR/%r0 */
    0, /* minus/%r1/nR/%r1 */
    0, /* minus/%r1/nR/%rR */
    0, /* minus/%rR/%r0/%r0 */
    0, /* minus/%rR/%r0/%r1 */
    0, /* minus/%rR/%r0/%rR */
    0, /* minus/%rR/%r1/%r0 */
    0, /* minus/%rR/%r1/%r1 */
    0, /* minus/%rR/%r1/%rR */
    0, /* minus/%rR/%rR/%r0 */
    0, /* minus/%rR/%rR/%r1 */
    0, /* minus/%rR/%rR/%rR */
    0, /* minus/%rR/n1/%r0 */
    0, /* minus/%rR/n1/%r1 */
    0, /* minus/%rR/n1/%rR */
    0, /* minus/%rR/n2/%r0 */
    0, /* minus/%rR/n2/%r1 */
    0, /* minus/%rR/n2/%rR */
    0, /* minus/%rR/nR/%r0 */
    0, /* minus/%rR/nR/%r1 */
    0, /* minus/%rR/nR/%rR */
    0, /* minus/nR/%r0/%r0 */
    0, /* minus/nR/%r0/%r1 */
    0, /* minus/nR/%r0/%rR */
    0, /* minus/nR/%r1/%r0 */
    0, /* minus/nR/%r1/%r1 */
    0, /* minus/nR/%r1/%rR */
    0, /* minus/nR/%rR/%r0 */
    0, /* minus/nR/%rR/%r1 */
    0, /* minus/nR/%rR/%rR */
    0, /* minus/nR/n1/%r0 */
    0, /* minus/nR/n1/%r1 */
    0, /* minus/nR/n1/%rR */
    0, /* minus/nR/n2/%r0 */
    0, /* minus/nR/n2/%r1 */
    0, /* minus/nR/n2/%rR */
    0, /* minus/nR/nR/%r0 */
    0, /* minus/nR/nR/%r1 */
    0, /* minus/nR/nR/%rR */
    0, /* minus-stack */
    0, /* minusi-stack/n1 */
    0, /* minusi-stack/n2 */
    0, /* minusi-stack/nR */
    0, /* mov/%r0/%r0 */
    0, /* mov/%r0/%r1 */
    0, /* mov/%r0/%rR */
    0, /* mov/%r1/%r0 */
    0, /* mov/%r1/%r1 */
    0, /* mov/%r1/%rR */
    0, /* mov/%rR/%r0 */
    0, /* mov/%rR/%r1 */
    0, /* mov/%rR/%rR */
    0, /* mov/n0/%r0 */
    0, /* mov/n0/%r1 */
    0, /* mov/n0/%rR */
    0, /* mov/n1/%r0 */
    0, /* mov/n1/%r1 */
    0, /* mov/n1/%rR */
    0, /* mov/n-1/%r0 */
    0, /* mov/n-1/%r1 */
    0, /* mov/n-1/%rR */
    0, /* mov/n2/%r0 */
    0, /* mov/n2/%r1 */
    0, /* mov/n2/%rR */
    0, /* mov/nR/%r0 */
    0, /* mov/nR/%r1 */
    0, /* mov/nR/%rR */
    0, /* plus/%r0/%r0/%r0 */
    0, /* plus/%r0/%r0/%r1 */
    0, /* plus/%r0/%r0/%rR */
    0, /* plus/%r0/%r1/%r0 */
    0, /* plus/%r0/%r1/%r1 */
    0, /* plus/%r0/%r1/%rR */
    0, /* plus/%r0/%rR/%r0 */
    0, /* plus/%r0/%rR/%r1 */
    0, /* plus/%r0/%rR/%rR */
    0, /* plus/%r0/n1/%r0 */
    0, /* plus/%r0/n1/%r1 */
    0, /* plus/%r0/n1/%rR */
    0, /* plus/%r0/n2/%r0 */
    0, /* plus/%r0/n2/%r1 */
    0, /* plus/%r0/n2/%rR */
    0, /* plus/%r0/nR/%r0 */
    0, /* plus/%r0/nR/%r1 */
    0, /* plus/%r0/nR/%rR */
    0, /* plus/%r1/%r0/%r0 */
    0, /* plus/%r1/%r0/%r1 */
    0, /* plus/%r1/%r0/%rR */
    0, /* plus/%r1/%r1/%r0 */
    0, /* plus/%r1/%r1/%r1 */
    0, /* plus/%r1/%r1/%rR */
    0, /* plus/%r1/%rR/%r0 */
    0, /* plus/%r1/%rR/%r1 */
    0, /* plus/%r1/%rR/%rR */
    0, /* plus/%r1/n1/%r0 */
    0, /* plus/%r1/n1/%r1 */
    0, /* plus/%r1/n1/%rR */
    0, /* plus/%r1/n2/%r0 */
    0, /* plus/%r1/n2/%r1 */
    0, /* plus/%r1/n2/%rR */
    0, /* plus/%r1/nR/%r0 */
    0, /* plus/%r1/nR/%r1 */
    0, /* plus/%r1/nR/%rR */
    0, /* plus/%rR/%r0/%r0 */
    0, /* plus/%rR/%r0/%r1 */
    0, /* plus/%rR/%r0/%rR */
    0, /* plus/%rR/%r1/%r0 */
    0, /* plus/%rR/%r1/%r1 */
    0, /* plus/%rR/%r1/%rR */
    0, /* plus/%rR/%rR/%r0 */
    0, /* plus/%rR/%rR/%r1 */
    0, /* plus/%rR/%rR/%rR */
    0, /* plus/%rR/n1/%r0 */
    0, /* plus/%rR/n1/%r1 */
    0, /* plus/%rR/n1/%rR */
    0, /* plus/%rR/n2/%r0 */
    0, /* plus/%rR/n2/%r1 */
    0, /* plus/%rR/n2/%rR */
    0, /* plus/%rR/nR/%r0 */
    0, /* plus/%rR/nR/%r1 */
    0, /* plus/%rR/nR/%rR */
    0, /* plus/n1/%r0/%r0 */
    0, /* plus/n1/%r0/%r1 */
    0, /* plus/n1/%r0/%rR */
    0, /* plus/n1/%r1/%r0 */
    0, /* plus/n1/%r1/%r1 */
    0, /* plus/n1/%r1/%rR */
    0, /* plus/n1/%rR/%r0 */
    0, /* plus/n1/%rR/%r1 */
    0, /* plus/n1/%rR/%rR */
    0, /* plus/n1/n1/%r0 */
    0, /* plus/n1/n1/%r1 */
    0, /* plus/n1/n1/%rR */
    0, /* plus/n1/n2/%r0 */
    0, /* plus/n1/n2/%r1 */
    0, /* plus/n1/n2/%rR */
    0, /* plus/n1/nR/%r0 */
    0, /* plus/n1/nR/%r1 */
    0, /* plus/n1/nR/%rR */
    0, /* plus/n2/%r0/%r0 */
    0, /* plus/n2/%r0/%r1 */
    0, /* plus/n2/%r0/%rR */
    0, /* plus/n2/%r1/%r0 */
    0, /* plus/n2/%r1/%r1 */
    0, /* plus/n2/%r1/%rR */
    0, /* plus/n2/%rR/%r0 */
    0, /* plus/n2/%rR/%r1 */
    0, /* plus/n2/%rR/%rR */
    0, /* plus/n2/n1/%r0 */
    0, /* plus/n2/n1/%r1 */
    0, /* plus/n2/n1/%rR */
    0, /* plus/n2/n2/%r0 */
    0, /* plus/n2/n2/%r1 */
    0, /* plus/n2/n2/%rR */
    0, /* plus/n2/nR/%r0 */
    0, /* plus/n2/nR/%r1 */
    0, /* plus/n2/nR/%rR */
    0, /* plus/nR/%r0/%r0 */
    0, /* plus/nR/%r0/%r1 */
    0, /* plus/nR/%r0/%rR */
    0, /* plus/nR/%r1/%r0 */
    0, /* plus/nR/%r1/%r1 */
    0, /* plus/nR/%r1/%rR */
    0, /* plus/nR/%rR/%r0 */
    0, /* plus/nR/%rR/%r1 */
    0, /* plus/nR/%rR/%rR */
    0, /* plus/nR/n1/%r0 */
    0, /* plus/nR/n1/%r1 */
    0, /* plus/nR/n1/%rR */
    0, /* plus/nR/n2/%r0 */
    0, /* plus/nR/n2/%r1 */
    0, /* plus/nR/n2/%rR */
    0, /* plus/nR/nR/%r0 */
    0, /* plus/nR/nR/%r1 */
    0, /* plus/nR/nR/%rR */
    0, /* plus-stack */
    0, /* plusi-stack/n-1 */
    0, /* plusi-stack/n1 */
    0, /* plusi-stack/n2 */
    0, /* plusi-stack/nR */
    0, /* pop-stack/%r0 */
    0, /* pop-stack/%r1 */
    0, /* pop-stack/%rR */
    0, /* print/%r0/retR */
    0, /* print/%r1/retR */
    0, /* print/%rR/retR */
    0, /* print/nR/retR */
    0, /* print-stack/retR */
    1, /* procedure-prolog */
    0, /* push-boxed-literal/n0 */
    0, /* push-boxed-literal/n1 */
    0, /* push-boxed-literal/n2 */
    0, /* push-boxed-literal/n3 */
    0, /* push-boxed-literal/n4 */
    0, /* push-boxed-literal/n5 */
    0, /* push-boxed-literal/n6 */
    0, /* push-boxed-literal/n7 */
    0, /* push-boxed-literal/n8 */
    0, /* push-boxed-literal/n9 */
    0, /* push-boxed-literal/n10 */
    0, /* push-boxed-literal/nR */
    0, /* push-stack/%r0 */
    0, /* push-stack/%r1 */
    0, /* push-stack/%rR */
    0, /* push-stack/n0 */
    0, /* push-stack/n1 */
    0, /* push-stack/n-1 */
    0, /* push-stack/n2 */
    0, /* push-stack/nR */
    0, /* push-stack/lR */
    0, /* push-unspecified-stack */
    0, /* remainder/%r0/%r0/%r0/retR */
    0, /* remainder/%r0/%r0/%r1/retR */
    0, /* remainder/%r0/%r0/%rR/retR */
    0, /* remainder/%r0/%r1/%r0/retR */
    0, /* remainder/%r0/%r1/%r1/retR */
    0, /* remainder/%r0/%r1/%rR/retR */
    0, /* remainder/%r0/%rR/%r0/retR */
    0, /* remainder/%r0/%rR/%r1/retR */
    0, /* remainder/%r0/%rR/%rR/retR */
    0, /* remainder/%r0/n2/%r0/retR */
    0, /* remainder/%r0/n2/%r1/retR */
    0, /* remainder/%r0/n2/%rR/retR */
    0, /* remainder/%r0/nR/%r0/retR */
    0, /* remainder/%r0/nR/%r1/retR */
    0, /* remainder/%r0/nR/%rR/retR */
    0, /* remainder/%r1/%r0/%r0/retR */
    0, /* remainder/%r1/%r0/%r1/retR */
    0, /* remainder/%r1/%r0/%rR/retR */
    0, /* remainder/%r1/%r1/%r0/retR */
    0, /* remainder/%r1/%r1/%r1/retR */
    0, /* remainder/%r1/%r1/%rR/retR */
    0, /* remainder/%r1/%rR/%r0/retR */
    0, /* remainder/%r1/%rR/%r1/retR */
    0, /* remainder/%r1/%rR/%rR/retR */
    0, /* remainder/%r1/n2/%r0/retR */
    0, /* remainder/%r1/n2/%r1/retR */
    0, /* remainder/%r1/n2/%rR/retR */
    0, /* remainder/%r1/nR/%r0/retR */
    0, /* remainder/%r1/nR/%r1/retR */
    0, /* remainder/%r1/nR/%rR/retR */
    0, /* remainder/%rR/%r0/%r0/retR */
    0, /* remainder/%rR/%r0/%r1/retR */
    0, /* remainder/%rR/%r0/%rR/retR */
    0, /* remainder/%rR/%r1/%r0/retR */
    0, /* remainder/%rR/%r1/%r1/retR */
    0, /* remainder/%rR/%r1/%rR/retR */
    0, /* remainder/%rR/%rR/%r0/retR */
    0, /* remainder/%rR/%rR/%r1/retR */
    0, /* remainder/%rR/%rR/%rR/retR */
    0, /* remainder/%rR/n2/%r0/retR */
    0, /* remainder/%rR/n2/%r1/retR */
    0, /* remainder/%rR/n2/%rR/retR */
    0, /* remainder/%rR/nR/%r0/retR */
    0, /* remainder/%rR/nR/%r1/retR */
    0, /* remainder/%rR/nR/%rR/retR */
    0, /* remainder/nR/%r0/%r0/retR */
    0, /* remainder/nR/%r0/%r1/retR */
    0, /* remainder/nR/%r0/%rR/retR */
    0, /* remainder/nR/%r1/%r0/retR */
    0, /* remainder/nR/%r1/%r1/retR */
    0, /* remainder/nR/%r1/%rR/retR */
    0, /* remainder/nR/%rR/%r0/retR */
    0, /* remainder/nR/%rR/%r1/retR */
    0, /* remainder/nR/%rR/%rR/retR */
    0, /* remainder/nR/n2/%r0/retR */
    0, /* remainder/nR/n2/%r1/retR */
    0, /* remainder/nR/n2/%rR/retR */
    0, /* remainder/nR/nR/%r0/retR */
    0, /* remainder/nR/nR/%r1/retR */
    0, /* remainder/nR/nR/%rR/retR */
    0, /* remainder-stack/retR */
    1, /* return-to-undertop */
    0, /* swap-stack */
    0, /* times/%r0/%r0/%r0 */
    0, /* times/%r0/%r0/%r1 */
    0, /* times/%r0/%r0/%rR */
    0, /* times/%r0/%r1/%r0 */
    0, /* times/%r0/%r1/%r1 */
    0, /* times/%r0/%r1/%rR */
    0, /* times/%r0/%rR/%r0 */
    0, /* times/%r0/%rR/%r1 */
    0, /* times/%r0/%rR/%rR */
    0, /* times/%r0/n2/%r0 */
    0, /* times/%r0/n2/%r1 */
    0, /* times/%r0/n2/%rR */
    0, /* times/%r0/nR/%r0 */
    0, /* times/%r0/nR/%r1 */
    0, /* times/%r0/nR/%rR */
    0, /* times/%r1/%r0/%r0 */
    0, /* times/%r1/%r0/%r1 */
    0, /* times/%r1/%r0/%rR */
    0, /* times/%r1/%r1/%r0 */
    0, /* times/%r1/%r1/%r1 */
    0, /* times/%r1/%r1/%rR */
    0, /* times/%r1/%rR/%r0 */
    0, /* times/%r1/%rR/%r1 */
    0, /* times/%r1/%rR/%rR */
    0, /* times/%r1/n2/%r0 */
    0, /* times/%r1/n2/%r1 */
    0, /* times/%r1/n2/%rR */
    0, /* times/%r1/nR/%r0 */
    0, /* times/%r1/nR/%r1 */
    0, /* times/%r1/nR/%rR */
    0, /* times/%rR/%r0/%r0 */
    0, /* times/%rR/%r0/%r1 */
    0, /* times/%rR/%r0/%rR */
    0, /* times/%rR/%r1/%r0 */
    0, /* times/%rR/%r1/%r1 */
    0, /* times/%rR/%r1/%rR */
    0, /* times/%rR/%rR/%r0 */
    0, /* times/%rR/%rR/%r1 */
    0, /* times/%rR/%rR/%rR */
    0, /* times/%rR/n2/%r0 */
    0, /* times/%rR/n2/%r1 */
    0, /* times/%rR/n2/%rR */
    0, /* times/%rR/nR/%r0 */
    0, /* times/%rR/nR/%r1 */
    0, /* times/%rR/nR/%rR */
    0, /* times/nR/%r0/%r0 */
    0, /* times/nR/%r0/%r1 */
    0, /* times/nR/%r0/%rR */
    0, /* times/nR/%r1/%r0 */
    0, /* times/nR/%r1/%r1 */
    0, /* times/nR/%r1/%rR */
    0, /* times/nR/%rR/%r0 */
    0, /* times/nR/%rR/%r1 */
    0, /* times/nR/%rR/%rR */
    0, /* times/nR/n2/%r0 */
    0, /* times/nR/n2/%r1 */
    0, /* times/nR/n2/%rR */
    0, /* times/nR/nR/%r0 */
    0, /* times/nR/nR/%r1 */
    0, /* times/nR/nR/%rR */
    0, /* times-stack */
    0, /* uminus/%r0/%r0 */
    0, /* uminus/%r0/%r1 */
    0, /* uminus/%r0/%rR */
    0, /* uminus/%r1/%r0 */
    0, /* uminus/%r1/%r1 */
    0, /* uminus/%r1/%rR */
    0, /* uminus/%rR/%r0 */
    0, /* uminus/%rR/%r1 */
    0, /* uminus/%rR/%rR */
    0, /* uminus/nR/%r0 */
    0, /* uminus/nR/%r1 */
    0, /* uminus/nR/%rR */
    0, /* uminus-stack */
    0, /* underpop-stack/%r0 */
    0, /* underpop-stack/%r1 */
    0, /* underpop-stack/%rR */
    0, /* underpush-stack/%r0 */
    0, /* underpush-stack/%r1 */
    0, /* underpush-stack/%rR */
    0, /* underpush-stack/nR */
    0, /* unreachable */
    0, /* !REPLACEMENT-b/fR/retR */
    0, /* !REPLACEMENT-be/%r0/%r0/fR/retR */
    0, /* !REPLACEMENT-be/%r0/%r1/fR/retR */
    0, /* !REPLACEMENT-be/%r0/%rR/fR/retR */
    0, /* !REPLACEMENT-be/%r0/n0/fR/retR */
    0, /* !REPLACEMENT-be/%r0/nR/fR/retR */
    0, /* !REPLACEMENT-be/%r1/%r0/fR/retR */
    0, /* !REPLACEMENT-be/%r1/%r1/fR/retR */
    0, /* !REPLACEMENT-be/%r1/%rR/fR/retR */
    0, /* !REPLACEMENT-be/%r1/n0/fR/retR */
    0, /* !REPLACEMENT-be/%r1/nR/fR/retR */
    0, /* !REPLACEMENT-be/%rR/%r0/fR/retR */
    0, /* !REPLACEMENT-be/%rR/%r1/fR/retR */
    0, /* !REPLACEMENT-be/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-be/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-be/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-be/n0/%r0/fR/retR */
    0, /* !REPLACEMENT-be/n0/%r1/fR/retR */
    0, /* !REPLACEMENT-be/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-be/n0/n0/fR/retR */
    0, /* !REPLACEMENT-be/n0/nR/fR/retR */
    0, /* !REPLACEMENT-be/nR/%r0/fR/retR */
    0, /* !REPLACEMENT-be/nR/%r1/fR/retR */
    0, /* !REPLACEMENT-be/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-be/nR/n0/fR/retR */
    0, /* !REPLACEMENT-be/nR/nR/fR/retR */
    0, /* !REPLACEMENT-beqi-stack/n-1/fR/retR */
    0, /* !REPLACEMENT-beqi-stack/n0/fR/retR */
    0, /* !REPLACEMENT-beqi-stack/n1/fR/retR */
    0, /* !REPLACEMENT-beqi-stack/n2/fR/retR */
    0, /* !REPLACEMENT-beqi-stack/nR/fR/retR */
    0, /* !REPLACEMENT-bf-stack/fR/retR */
    0, /* !REPLACEMENT-bg/%r0/%r0/fR/retR */
    0, /* !REPLACEMENT-bg/%r0/%r1/fR/retR */
    0, /* !REPLACEMENT-bg/%r0/%rR/fR/retR */
    0, /* !REPLACEMENT-bg/%r0/n0/fR/retR */
    0, /* !REPLACEMENT-bg/%r0/nR/fR/retR */
    0, /* !REPLACEMENT-bg/%r1/%r0/fR/retR */
    0, /* !REPLACEMENT-bg/%r1/%r1/fR/retR */
    0, /* !REPLACEMENT-bg/%r1/%rR/fR/retR */
    0, /* !REPLACEMENT-bg/%r1/n0/fR/retR */
    0, /* !REPLACEMENT-bg/%r1/nR/fR/retR */
    0, /* !REPLACEMENT-bg/%rR/%r0/fR/retR */
    0, /* !REPLACEMENT-bg/%rR/%r1/fR/retR */
    0, /* !REPLACEMENT-bg/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-bg/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-bg/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-bg/n0/%r0/fR/retR */
    0, /* !REPLACEMENT-bg/n0/%r1/fR/retR */
    0, /* !REPLACEMENT-bg/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-bg/n0/n0/fR/retR */
    0, /* !REPLACEMENT-bg/n0/nR/fR/retR */
    0, /* !REPLACEMENT-bg/nR/%r0/fR/retR */
    0, /* !REPLACEMENT-bg/nR/%r1/fR/retR */
    0, /* !REPLACEMENT-bg/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-bg/nR/n0/fR/retR */
    0, /* !REPLACEMENT-bg/nR/nR/fR/retR */
    0, /* !REPLACEMENT-bge/%r0/%r0/fR/retR */
    0, /* !REPLACEMENT-bge/%r0/%r1/fR/retR */
    0, /* !REPLACEMENT-bge/%r0/%rR/fR/retR */
    0, /* !REPLACEMENT-bge/%r0/n0/fR/retR */
    0, /* !REPLACEMENT-bge/%r0/nR/fR/retR */
    0, /* !REPLACEMENT-bge/%r1/%r0/fR/retR */
    0, /* !REPLACEMENT-bge/%r1/%r1/fR/retR */
    0, /* !REPLACEMENT-bge/%r1/%rR/fR/retR */
    0, /* !REPLACEMENT-bge/%r1/n0/fR/retR */
    0, /* !REPLACEMENT-bge/%r1/nR/fR/retR */
    0, /* !REPLACEMENT-bge/%rR/%r0/fR/retR */
    0, /* !REPLACEMENT-bge/%rR/%r1/fR/retR */
    0, /* !REPLACEMENT-bge/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-bge/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-bge/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-bge/n0/%r0/fR/retR */
    0, /* !REPLACEMENT-bge/n0/%r1/fR/retR */
    0, /* !REPLACEMENT-bge/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-bge/n0/n0/fR/retR */
    0, /* !REPLACEMENT-bge/n0/nR/fR/retR */
    0, /* !REPLACEMENT-bge/nR/%r0/fR/retR */
    0, /* !REPLACEMENT-bge/nR/%r1/fR/retR */
    0, /* !REPLACEMENT-bge/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-bge/nR/n0/fR/retR */
    0, /* !REPLACEMENT-bge/nR/nR/fR/retR */
    0, /* !REPLACEMENT-bl/%r0/%r0/fR/retR */
    0, /* !REPLACEMENT-bl/%r0/%r1/fR/retR */
    0, /* !REPLACEMENT-bl/%r0/%rR/fR/retR */
    0, /* !REPLACEMENT-bl/%r0/n0/fR/retR */
    0, /* !REPLACEMENT-bl/%r0/nR/fR/retR */
    0, /* !REPLACEMENT-bl/%r1/%r0/fR/retR */
    0, /* !REPLACEMENT-bl/%r1/%r1/fR/retR */
    0, /* !REPLACEMENT-bl/%r1/%rR/fR/retR */
    0, /* !REPLACEMENT-bl/%r1/n0/fR/retR */
    0, /* !REPLACEMENT-bl/%r1/nR/fR/retR */
    0, /* !REPLACEMENT-bl/%rR/%r0/fR/retR */
    0, /* !REPLACEMENT-bl/%rR/%r1/fR/retR */
    0, /* !REPLACEMENT-bl/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-bl/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-bl/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-bl/n0/%r0/fR/retR */
    0, /* !REPLACEMENT-bl/n0/%r1/fR/retR */
    0, /* !REPLACEMENT-bl/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-bl/n0/n0/fR/retR */
    0, /* !REPLACEMENT-bl/n0/nR/fR/retR */
    0, /* !REPLACEMENT-bl/nR/%r0/fR/retR */
    0, /* !REPLACEMENT-bl/nR/%r1/fR/retR */
    0, /* !REPLACEMENT-bl/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-bl/nR/n0/fR/retR */
    0, /* !REPLACEMENT-bl/nR/nR/fR/retR */
    0, /* !REPLACEMENT-ble/%r0/%r0/fR/retR */
    0, /* !REPLACEMENT-ble/%r0/%r1/fR/retR */
    0, /* !REPLACEMENT-ble/%r0/%rR/fR/retR */
    0, /* !REPLACEMENT-ble/%r0/n0/fR/retR */
    0, /* !REPLACEMENT-ble/%r0/nR/fR/retR */
    0, /* !REPLACEMENT-ble/%r1/%r0/fR/retR */
    0, /* !REPLACEMENT-ble/%r1/%r1/fR/retR */
    0, /* !REPLACEMENT-ble/%r1/%rR/fR/retR */
    0, /* !REPLACEMENT-ble/%r1/n0/fR/retR */
    0, /* !REPLACEMENT-ble/%r1/nR/fR/retR */
    0, /* !REPLACEMENT-ble/%rR/%r0/fR/retR */
    0, /* !REPLACEMENT-ble/%rR/%r1/fR/retR */
    0, /* !REPLACEMENT-ble/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-ble/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-ble/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-ble/n0/%r0/fR/retR */
    0, /* !REPLACEMENT-ble/n0/%r1/fR/retR */
    0, /* !REPLACEMENT-ble/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-ble/n0/n0/fR/retR */
    0, /* !REPLACEMENT-ble/n0/nR/fR/retR */
    0, /* !REPLACEMENT-ble/nR/%r0/fR/retR */
    0, /* !REPLACEMENT-ble/nR/%r1/fR/retR */
    0, /* !REPLACEMENT-ble/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-ble/nR/n0/fR/retR */
    0, /* !REPLACEMENT-ble/nR/nR/fR/retR */
    0, /* !REPLACEMENT-bne/%r0/%r0/fR/retR */
    0, /* !REPLACEMENT-bne/%r0/%r1/fR/retR */
    0, /* !REPLACEMENT-bne/%r0/%rR/fR/retR */
    0, /* !REPLACEMENT-bne/%r0/n0/fR/retR */
    0, /* !REPLACEMENT-bne/%r0/nR/fR/retR */
    0, /* !REPLACEMENT-bne/%r1/%r0/fR/retR */
    0, /* !REPLACEMENT-bne/%r1/%r1/fR/retR */
    0, /* !REPLACEMENT-bne/%r1/%rR/fR/retR */
    0, /* !REPLACEMENT-bne/%r1/n0/fR/retR */
    0, /* !REPLACEMENT-bne/%r1/nR/fR/retR */
    0, /* !REPLACEMENT-bne/%rR/%r0/fR/retR */
    0, /* !REPLACEMENT-bne/%rR/%r1/fR/retR */
    0, /* !REPLACEMENT-bne/%rR/%rR/fR/retR */
    0, /* !REPLACEMENT-bne/%rR/n0/fR/retR */
    0, /* !REPLACEMENT-bne/%rR/nR/fR/retR */
    0, /* !REPLACEMENT-bne/n0/%r0/fR/retR */
    0, /* !REPLACEMENT-bne/n0/%r1/fR/retR */
    0, /* !REPLACEMENT-bne/n0/%rR/fR/retR */
    0, /* !REPLACEMENT-bne/n0/n0/fR/retR */
    0, /* !REPLACEMENT-bne/n0/nR/fR/retR */
    0, /* !REPLACEMENT-bne/nR/%r0/fR/retR */
    0, /* !REPLACEMENT-bne/nR/%r1/fR/retR */
    0, /* !REPLACEMENT-bne/nR/%rR/fR/retR */
    0, /* !REPLACEMENT-bne/nR/n0/fR/retR */
    0, /* !REPLACEMENT-bne/nR/nR/fR/retR */
    0, /* !REPLACEMENT-bneqi-stack/n-1/fR/retR */
    0, /* !REPLACEMENT-bneqi-stack/n0/fR/retR */
    0, /* !REPLACEMENT-bneqi-stack/n1/fR/retR */
    0, /* !REPLACEMENT-bneqi-stack/n2/fR/retR */
    0, /* !REPLACEMENT-bneqi-stack/nR/fR/retR */
    0, /* !REPLACEMENT-bt-stack/fR/retR */
    0, /* !REPLACEMENT-call/fR/retR */
    0, /* !REPLACEMENT-exitvm/retR */
    0, /* !REPLACEMENT-procedure-prolog/retR */
    0, /* !REPLACEMENT-return-to-undertop/retR */
    0 /* !REPLACEMENT-unreachable/retR */
  };

#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT


void
structuredvm_rewrite (struct jitter_mutable_routine *jitter_mutable_routine_p)
{
  JITTTER_REWRITE_FUNCTION_PROLOG_;

/* User-specified code, rewriter part: beginning. */

/* User-specified code, rewriter part: end */


//asm volatile ("\n# checking not-not--nothing");
//fprintf (stderr, "Trying rule 1 of 25, \"not-not--nothing\" (line 350)\n");
/* Rewrite rule "not-not--nothing" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, logicalnot_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, logicalnot_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule not-not--nothing (line 350) fires...\n");
    //fprintf (stderr, "  ...End of the rule not-not--nothing\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking not-bf--bt");
//fprintf (stderr, "Trying rule 2 of 25, \"not-bf--bt\" (line 351)\n");
/* Rewrite rule "not-bf--bt" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, logicalnot_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, bf_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule not-bf--bt (line 351) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction bt-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(bt_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of bt-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule not-bf--bt\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking not-bt--bf");
//fprintf (stderr, "Trying rule 3 of 25, \"not-bt--bf\" (line 352)\n");
/* Rewrite rule "not-bt--bf" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, logicalnot_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, bt_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule not-bt--bf (line 352) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction bf-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(bf_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of bf-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule not-bt--bf\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking less-not--greaterorequal");
//fprintf (stderr, "Trying rule 4 of 25, \"less-not--greaterorequal\" (line 353)\n");
/* Rewrite rule "less-not--greaterorequal" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, less_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, logicalnot_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule less-not--greaterorequal (line 353) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction greaterorequal-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(greaterorequal_mstack);
    //fprintf (stderr, "  ...End of the rule less-not--greaterorequal\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking lessorequal-not--greater");
//fprintf (stderr, "Trying rule 5 of 25, \"lessorequal-not--greater\" (line 354)\n");
/* Rewrite rule "lessorequal-not--greater" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, lessorequal_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, logicalnot_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule lessorequal-not--greater (line 354) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction greater-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(greater_mstack);
    //fprintf (stderr, "  ...End of the rule lessorequal-not--greater\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking greater-not--lessorequal");
//fprintf (stderr, "Trying rule 6 of 25, \"greater-not--lessorequal\" (line 355)\n");
/* Rewrite rule "greater-not--lessorequal" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, greater_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, logicalnot_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule greater-not--lessorequal (line 355) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction lessorequal-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(lessorequal_mstack);
    //fprintf (stderr, "  ...End of the rule greater-not--lessorequal\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking greaterorequal-not--less");
//fprintf (stderr, "Trying rule 7 of 25, \"greaterorequal-not--less\" (line 356)\n");
/* Rewrite rule "greaterorequal-not--less" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, greaterorequal_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, logicalnot_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule greaterorequal-not--less (line 356) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction less-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(less_mstack);
    //fprintf (stderr, "  ...End of the rule greaterorequal-not--less\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking pop-push--copytor");
//fprintf (stderr, "Trying rule 8 of 25, \"pop-push--copytor\" (line 357)\n");
/* Rewrite rule "pop-push--copytor" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, pop_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, push_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_REGISTER(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_REGISTER(1, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule pop-push--copytor (line 357) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction copy-to-r-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(copy_mto_mr_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of copy-to-r-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule pop-push--copytor\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-pop--");
//fprintf (stderr, "Trying rule 9 of 25, \"push-pop--\" (line 358)\n");
/* Rewrite rule "push-pop--" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, pop_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_REGISTER(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_REGISTER(1, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-pop-- (line 358) fires...\n");
    //fprintf (stderr, "  ...End of the rule push-pop--\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-pop--movr");
//fprintf (stderr, "Trying rule 10 of 25, \"push-pop--movr\" (line 359)\n");
/* Rewrite rule "push-pop--movr" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
    JITTER_RULE_DECLARE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, pop_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_REGISTER(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_REGISTER(1, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, b)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
    JITTER_RULE_CLONE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-pop--movr (line 359) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction mov\n");
    JITTER_RULE_APPEND_INSTRUCTION_(mov);
    //fprintf (stderr, "    instantiating the 0-th argument of mov\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "    instantiating the 1-th argument of mov\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(b)
                                 );
    //fprintf (stderr, "  ...End of the rule push-pop--movr\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
    JITTER_RULE_DESTROY_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-pop--movn");
//fprintf (stderr, "Trying rule 11 of 25, \"push-pop--movn\" (line 360)\n");
/* Rewrite rule "push-pop--movn" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
    JITTER_RULE_DECLARE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, pop_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_REGISTER(1, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, b)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
    JITTER_RULE_CLONE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-pop--movn (line 360) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction mov\n");
    JITTER_RULE_APPEND_INSTRUCTION_(mov);
    //fprintf (stderr, "    instantiating the 0-th argument of mov\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "    instantiating the 1-th argument of mov\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(b)
                                 );
    //fprintf (stderr, "  ...End of the rule push-pop--movn\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
    JITTER_RULE_DESTROY_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-plus--plusi");
//fprintf (stderr, "Trying rule 12 of 25, \"push-plus--plusi\" (line 361)\n");
/* Rewrite rule "push-plus--plusi" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, plus_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-plus--plusi (line 361) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction plusi-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(plusi_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of plusi-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule push-plus--plusi\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-minus--minusi");
//fprintf (stderr, "Trying rule 13 of 25, \"push-minus--minusi\" (line 362)\n");
/* Rewrite rule "push-minus--minusi" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, minus_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-minus--minusi (line 362) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction minusi-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(minusi_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of minusi-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule push-minus--minusi\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-equal--equali");
//fprintf (stderr, "Trying rule 14 of 25, \"push-equal--equali\" (line 365)\n");
/* Rewrite rule "push-equal--equali" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, equal_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-equal--equali (line 365) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction equali-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(equali_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of equali-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule push-equal--equali\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking equali-bt--beqi");
//fprintf (stderr, "Trying rule 15 of 25, \"equali-bt--beqi\" (line 366)\n");
/* Rewrite rule "equali-bt--beqi" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
    JITTER_RULE_DECLARE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, equali_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, bt_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, b)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
    JITTER_RULE_CLONE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule equali-bt--beqi (line 366) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction beqi-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(beqi_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of beqi-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "    instantiating the 1-th argument of beqi-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(b)
                                 );
    //fprintf (stderr, "  ...End of the rule equali-bt--beqi\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
    JITTER_RULE_DESTROY_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking equali-bf--bneqi");
//fprintf (stderr, "Trying rule 16 of 25, \"equali-bf--bneqi\" (line 367)\n");
/* Rewrite rule "equali-bf--bneqi" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
    JITTER_RULE_DECLARE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, equali_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, bf_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, b)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
    JITTER_RULE_CLONE_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule equali-bf--bneqi (line 367) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction bneqi-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(bneqi_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of bneqi-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "    instantiating the 1-th argument of bneqi-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(b)
                                 );
    //fprintf (stderr, "  ...End of the rule equali-bf--bneqi\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
    JITTER_RULE_DESTROY_PLACEHOLDER_(b);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-drop--");
//fprintf (stderr, "Trying rule 17 of 25, \"push-drop--\" (line 369)\n");
/* Rewrite rule "push-drop--" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, drop_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-drop-- (line 369) fires...\n");
    //fprintf (stderr, "  ...End of the rule push-drop--\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-push--push-dup");
//fprintf (stderr, "Trying rule 18 of 25, \"push-push--push-dup\" (line 370)\n");
/* Rewrite rule "push-push--push-dup" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, push_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-push--push-dup (line 370) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction push-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(push_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of push-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "    rewrite: adding instruction dup-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(dup_mstack);
    //fprintf (stderr, "  ...End of the rule push-push--push-dup\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-bf--b");
//fprintf (stderr, "Trying rule 19 of 25, \"push-bf--b\" (line 373)\n");
/* Rewrite rule "push-bf--b" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, bf_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_LITERAL_ARGUMENT(0, 0, 0)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-bf--b (line 373) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction b\n");
    JITTER_RULE_APPEND_INSTRUCTION_(b);
    //fprintf (stderr, "    instantiating the 0-th argument of b\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule push-bf--b\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-bt--");
//fprintf (stderr, "Trying rule 20 of 25, \"push-bt--\" (line 375)\n");
/* Rewrite rule "push-bt--" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, bt_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_LITERAL_ARGUMENT(0, 0, 0)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-bt-- (line 375) fires...\n");
    //fprintf (stderr, "  ...End of the rule push-bt--\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking plusi-minusi--");
//fprintf (stderr, "Trying rule 21 of 25, \"plusi-minusi--\" (line 377)\n");
/* Rewrite rule "plusi-minusi--" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, plusi_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, minusi_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule plusi-minusi-- (line 377) fires...\n");
    //fprintf (stderr, "  ...End of the rule plusi-minusi--\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking minusi-plusi--");
//fprintf (stderr, "Trying rule 22 of 25, \"minusi-plusi--\" (line 378)\n");
/* Rewrite rule "minusi-plusi--" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, minusi_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, plusi_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(1, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule minusi-plusi-- (line 378) fires...\n");
    //fprintf (stderr, "  ...End of the rule minusi-plusi--\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking plusi--");
//fprintf (stderr, "Trying rule 23 of 25, \"plusi--\" (line 379)\n");
/* Rewrite rule "plusi--" */
JITTER_RULE_BEGIN(1)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, plusi_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_LITERAL_ARGUMENT(0, 0, 0)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule plusi-- (line 379) fires...\n");
    //fprintf (stderr, "  ...End of the rule plusi--\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking minusi--");
//fprintf (stderr, "Trying rule 24 of 25, \"minusi--\" (line 380)\n");
/* Rewrite rule "minusi--" */
JITTER_RULE_BEGIN(1)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, minusi_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_LITERAL_ARGUMENT(0, 0, 0)
    JITTER_RULE_CONDITION(false
                          || JITTER_RULE_ARGUMENT_IS_A_LITERAL(0, 0)
                         )
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule minusi-- (line 380) fires...\n");
    //fprintf (stderr, "  ...End of the rule minusi--\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//asm volatile ("\n# checking push-swap--underpush");
//fprintf (stderr, "Trying rule 25 of 25, \"push-swap--underpush\" (line 384)\n");
/* Rewrite rule "push-swap--underpush" */
JITTER_RULE_BEGIN(2)
  JITTER_RULE_BEGIN_PLACEHOLDER_DECLARATIONS
    JITTER_RULE_DECLARE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DECLARATIONS
  JITTER_RULE_BEGIN_CONDITIONS
    /* Check opcodes first: they are likely not to match, and in */
    /* that case we want to fail as early as possible. */
    JITTER_RULE_CONDITION_MATCH_OPCODE(0, push_mstack)
    JITTER_RULE_CONDITION_MATCH_OPCODE(1, swap_mstack)
    /* Check arguments, binding placeholders.  We don't have to worry */
    /* about arity, since the opcodes match if we're here. */
    JITTER_RULE_CONDITION_MATCH_PLACEHOLDER(0, 0, a)
    /* Rule guard. */
    JITTER_RULE_CONDITION(
      true
                         )
  JITTER_RULE_END_CONDITIONS
  JITTER_RULE_BEGIN_PLACEHOLDER_CLONING
    JITTER_RULE_CLONE_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_CLONING
  JITTER_RULE_BEGIN_BODY
  //fprintf (stderr, "* The rule push-swap--underpush (line 384) fires...\n");
    //fprintf (stderr, "    rewrite: adding instruction underpush-stack\n");
    JITTER_RULE_APPEND_INSTRUCTION_(underpush_mstack);
    //fprintf (stderr, "    instantiating the 0-th argument of underpush-stack\n");
    jitter_mutable_routine_append_parameter_copy (jitter_mutable_routine_p,
      JITTER_PLACEHOLDER_NAME(a)
                                 );
    //fprintf (stderr, "  ...End of the rule push-swap--underpush\n");
  JITTER_RULE_END_BODY
  JITTER_RULE_BEGIN_PLACEHOLDER_DESTRUCTION
    JITTER_RULE_DESTROY_PLACEHOLDER_(a);
  JITTER_RULE_END_PLACEHOLDER_DESTRUCTION
JITTER_RULE_END

//fprintf (stderr, "No more rules to try\n");
}


//#include <jitter/jitter-fatal.h>

//#include <jitter/jitter.h>
//#include <jitter/jitter-instruction.h>
//#include <jitter/jitter-specialize.h>

//#include "structuredvm-vm.h"
//#include "structuredvm-meta-instructions.h"
//#include "structuredvm-specialized-instructions.h"


/* Recognizer function prototypes. */
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_b (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_b__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n_m1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n2__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bf_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bf_mstack__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n_m1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__n2__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bneqi_mstack__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bt_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bt_mstack__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_call (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_call__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_copy_mto_mr_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_different_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr0__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rr1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_divided_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_drop_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_dup_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_equal_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_equali_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_equali_mstack__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_equali_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_equali_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_equali_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_exitvm (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_greater_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_greaterorequal_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_input (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_input___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_input___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_input___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_input_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_isnonzero_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_less_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_lessorequal_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n3___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n3___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n3___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n4 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n4___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n4___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n4___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n5 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n5___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n5___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n5___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n6 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n6___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n6___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n6___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n7 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n7___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n7___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n7___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n8 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n8___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n8___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n8___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n9 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n9___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n9___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n9___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n10 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n10___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n10___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__n10___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_load_mboxed_mliteral__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_logicaland_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_logicalnot_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_logicalor_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr0__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rr1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minus_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minusi_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minusi_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minusi_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_minusi_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n_m1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n_m1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n_m1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_mov__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr0__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rr1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__n2__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plus_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plusi_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plusi_mstack__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plusi_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plusi_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_plusi_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pop_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pop_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pop_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_pop_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_print (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_print___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_print___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_print___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_print__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_print_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_procedure_mprolog (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mboxed_mliteral (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mboxed_mliteral__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mboxed_mliteral__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mboxed_mliteral__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mboxed_mliteral__n3 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mboxed_mliteral__n4 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mboxed_mliteral__n5 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mboxed_mliteral__n6 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mboxed_mliteral__n7 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mboxed_mliteral__n8 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mboxed_mliteral__n9 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mboxed_mliteral__n10 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mboxed_mliteral__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_mstack__lR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_push_munspecified_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr0__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rr1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_remainder_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_return_mto_mundertop (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_swap_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr0__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rr1__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times___rrR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__n2___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__n2___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__n2___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times__nR__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_times_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_uminus_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_underpop_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_underpop_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_underpop_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_underpop_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_underpush_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_underpush_mstack___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_underpush_mstack___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_underpush_mstack___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_underpush_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_unreachable (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
  __attribute__ ((pure));


/* Recognizer function definitions. */
inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_b (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_b__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_b__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_b__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_be__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_be__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr1___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr1___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr1___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr1__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rr1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rr1__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rrR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rrR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rrR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rrR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be___rrR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_be__n0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_be__n0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_be__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_be__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_be__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__n0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__n0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__n0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__n0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__n0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__n0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__n0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_be__nR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_be__nR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_be__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_be__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_be__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__nR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__nR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__nR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__nR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__nR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__nR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_be__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_be__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_be__nR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == -1 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n_m1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 1 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 2 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n2 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n_m1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n_m1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n_m1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_beqi_mstack__n_m1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_beqi_mstack__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_beqi_mstack__n1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n2 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__n2__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__n2__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_beqi_mstack__n2__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_beqi_mstack__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_beqi_mstack__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_beqi_mstack__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bf_mstack (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bf_mstack__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bf_mstack__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bf_mstack__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr1___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr1___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr1___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr1__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rr1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rr1__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rrR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rrR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rrR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rrR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg___rrR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__n0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__n0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__n0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__n0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__n0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__nR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__nR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__nR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__nR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bg__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bg__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bg__nR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr1___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr1___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr1___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr1__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rr1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rr1__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rrR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rrR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rrR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rrR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge___rrR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__n0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__n0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__n0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__n0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__n0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__nR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__nR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__nR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__nR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bge__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bge__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bge__nR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr1___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr1___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr1___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr1__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rr1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rr1__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rrR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rrR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rrR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rrR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl___rrR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__n0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__n0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__n0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__n0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__n0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__nR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__nR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__nR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__nR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bl__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bl__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bl__nR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr1___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr1___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr1___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr1__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rr1__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rr1__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rr1__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rrR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rrR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rrR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rrR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble___rrR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble___rrR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble___rrR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__n0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__n0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__n0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__n0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__n0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__n0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__n0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__nR___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__nR___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__nR___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__nR__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_ble__nR__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_ble__nR__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_ble__nR__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bne___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bne__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bne__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0__nR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0___rr0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr0___rr0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0___rr1__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rr1__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr0___rr1__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rrR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0___rrR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0___rrR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr0___rrR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__n0 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0__n0__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__n0__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr0__n0__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__nR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_label)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr0__nR__fR (ps + 1, enable_fast_literals)))
    goto done;
done:
  return res;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr0__nR__fR (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  /* The prefix is a full specialized instruction.  We're done recognizing it. */
  return structuredvm_specialized_instruction_opcode_bne___rr0__nR__fR;
}

inline static enum structuredvm_specialized_instruction_opcode
structuredvm_recognize_specialized_instruction_bne___rr1 (struct jitter_parameter ** const ps,
                                               bool enable_fast_literals)
{
  enum structuredvm_specialized_instruction_opcode res = structuredvm_specialized_instruction_opcode__eINVALID;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 0)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1___rr0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id && (* ps)->register_index == 1)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1___rr1 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_register_id)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1___rrR (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_literal && (* ps)->literal.fixnum == 0 && enable_fast_literals)
      && (res = structuredvm_recognize_specialized_instruction_bne___rr1__n0 (ps + 1, enable_fast_literals)))
    goto done;
  if (((* ps)->type == jitter_parameter_type_l