/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 2

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Substitute the type names.  */
#define YYSTYPE         PKL_TAB_STYPE
#define YYLTYPE         PKL_TAB_LTYPE
/* Substitute the variable and function names.  */
#define yyparse         pkl_tab_parse
#define yylex           pkl_tab_lex
#define yyerror         pkl_tab_error
#define yydebug         pkl_tab_debug
#define yynerrs         pkl_tab_nerrs

/* First part of user prologue.  */
#line 36 "pkl-tab.y"

#include <config.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <gettext.h>
#define _(str) gettext (str)

#include "pk-utils.h"

#include "pkl.h"
#include "pkl-diag.h"
#include "pkl-ast.h"
#include "pkl-parser.h" /* For struct pkl_parser.  */

#include "pvm.h"

#define PKL_TAB_LTYPE pkl_ast_loc
#define YYDEBUG 1
#include "pkl-tab.h"
#include "pkl-lex.h"

#define scanner (pkl_parser->scanner)

/* YYLLOC_DEFAULT -> default code for computing locations.  */

#define PKL_AST_CHILDREN_STEP 12


/* Emit an error.  */

static void
pkl_tab_error (YYLTYPE *llocp,
               struct pkl_parser *pkl_parser,
               char const *err)
{
    pkl_error (pkl_parser->compiler, pkl_parser->ast, *llocp, "%s", err);
}

/* These are used in the defun_or_method rule.  */

#define IS_DEFUN 0
#define IS_METHOD 1

/* Register an argument in the compile-time environment.  This is used
   by function specifiers and try-catch statements.

   Return 0 if there was an error registering, 1 otherwise.  */

static int
pkl_register_arg (struct pkl_parser *parser, pkl_ast_node arg)
{
  pkl_ast_node arg_decl;
  pkl_ast_node arg_identifier = PKL_AST_FUNC_ARG_IDENTIFIER (arg);

  pkl_ast_node dummy
    = pkl_ast_make_integer (parser->ast, 0);
  PKL_AST_TYPE (dummy) = ASTREF (PKL_AST_FUNC_ARG_TYPE (arg));

  arg_decl = pkl_ast_make_decl (parser->ast,
                                PKL_AST_DECL_KIND_VAR,
                                arg_identifier,
                                dummy,
                                NULL /* source */);
  PKL_AST_LOC (arg_decl) = PKL_AST_LOC (arg);

  if (!pkl_env_register (parser->env,
                         parser->ast,
                         PKL_ENV_NS_MAIN,
                         PKL_AST_IDENTIFIER_POINTER (arg_identifier),
                         arg_decl))
    {
      pkl_error (parser->compiler, parser->ast,PKL_AST_LOC (arg_identifier),
                 "duplicated argument name `%s' in function declaration",
                 PKL_AST_IDENTIFIER_POINTER (arg_identifier));
      /* Make sure to pop the function frame.  */
      parser->env = pkl_env_pop_frame (parser->env);
      return 0;
    }

  return 1;
}

/* Assert statement is a syntactic sugar that transforms to invocation
   of _pkl_assert function with appropriate arguments.

   This function accepts AST nodes corresponding to the condition and
   optional message of the assert statement, and also the location info
   of the statement.

   Returns NULL on failure, and expression statement AST node on success.  */

static pkl_ast_node
pkl_make_assertion (struct pkl_parser *parser, pkl_ast_node cond, pkl_ast_node msg,
                    struct pkl_ast_loc stmt_loc)
{
  pkl_ast_node vfunc, call, call_arg;
  /* _pkl_assert args */
  pkl_ast_node arg_cond, arg_msg, arg_fname, arg_line, arg_col;

  /* Make variable for `_pkl_assert` function */
  {
    const char *name = "_pkl_assert";
    pkl_ast_node vfunc_init;
    int back, over;

    vfunc_init = pkl_env_lookup (parser->env, PKL_ENV_NS_MAIN, name, &back, &over);
    if (!vfunc_init
        || (PKL_AST_DECL_KIND (vfunc_init) != PKL_AST_DECL_KIND_FUNC))
      {
        pkl_error (parser->compiler, parser->ast, stmt_loc, "undefined function '%s'",
                   name);
        return NULL;
      }
    vfunc = pkl_ast_make_var (parser->ast,
                              pkl_ast_make_identifier (parser->ast, name),
                              vfunc_init, -1, -1);
  }

  /* First argument of _pkl_assert: condition */
  arg_cond = pkl_ast_make_funcall_arg (parser->ast, cond, NULL);
  PKL_AST_LOC (arg_cond) = PKL_AST_LOC (cond);

  /* Second argument of _pkl_assert: user message */
  if (msg == NULL)
    {
      /* Use the source code of the condition as the user message.  */
      struct pkl_ast_loc exp_loc = PKL_AST_LOC (cond);
      char *loc_source = pkl_loc_to_source (parser, exp_loc, 80);
      char *escaped_loc_source = NULL;

      /* Escape backslash characters in loc_source, since we are using
         it in a Poke string literal.  */
      {
        size_t escaped_size = 0, i, j;

        for (i = 0; i < strlen (loc_source); ++i)
          escaped_size += (loc_source[i] == '\\' ? 2 : 1);

        escaped_loc_source = malloc (escaped_size + 1);

        for (i = 0, j = 0; i < strlen (loc_source); ++i)
          {
            if (loc_source[i] == '\\')
              {
                escaped_loc_source[j++] = '\\';
                escaped_loc_source[j++] = '\\';
              }
            else
              escaped_loc_source[j++] = loc_source[i];
          }
        escaped_loc_source[j] = '\0';
      }

      msg = pkl_ast_make_string (parser->ast, escaped_loc_source);
      free (loc_source);
      free (escaped_loc_source);
      PKL_AST_TYPE (msg) = ASTREF (pkl_ast_make_string_type (parser->ast));
    }
  arg_msg = pkl_ast_make_funcall_arg (parser->ast, msg, NULL);
  arg_msg = ASTREF (arg_msg);
  PKL_AST_LOC (arg_msg) = PKL_AST_LOC (msg);

  /* Third argument of _pkl_assert: file name */
  {
    pkl_ast_node fname
        = pkl_ast_make_string (parser->ast,
                               parser->filename ? parser->filename : "<stdin>");

    PKL_AST_TYPE (fname) = ASTREF (pkl_ast_make_string_type (parser->ast));
    arg_fname = pkl_ast_make_funcall_arg (parser->ast, fname, NULL);
    arg_fname = ASTREF (arg_fname);
  }

  /* Fourth argument of _pkl_assert: line */
  {
    pkl_ast_node line = pkl_ast_make_integer (parser->ast, stmt_loc.first_line);

    PKL_AST_TYPE (line) = ASTREF (pkl_ast_make_integral_type (parser->ast, 64, 0));
    arg_line = pkl_ast_make_funcall_arg (parser->ast, line, NULL);
    arg_line = ASTREF (arg_line);
  }

  /* Fifth argument of _pkl_assert: column */
  {
    pkl_ast_node col = pkl_ast_make_integer (parser->ast, stmt_loc.first_column);

    PKL_AST_TYPE (col) = ASTREF (pkl_ast_make_integral_type (parser->ast, 64, 0));
    arg_col = pkl_ast_make_funcall_arg (parser->ast, col, NULL);
    arg_col = ASTREF (arg_col);
  }

  call_arg = pkl_ast_chainon (arg_line, arg_col);
  call_arg = pkl_ast_chainon (arg_fname, call_arg);
  call_arg = pkl_ast_chainon (arg_msg, call_arg);
  call_arg = pkl_ast_chainon (arg_cond, call_arg);
  call = pkl_ast_make_funcall (parser->ast, vfunc, call_arg);
  return pkl_ast_make_exp_stmt (parser->ast, call);
}

#if 0
/* Register a list of arguments in the compile-time environment.  This
   is used by function specifiers and try-catch statements.

   Return 0 if there was an error registering, 1 otherwise.  */

static int
pkl_register_args (struct pkl_parser *parser, pkl_ast_node arg_list)
{
  pkl_ast_node arg;

  for (arg = arg_list; arg; arg = PKL_AST_CHAIN (arg))
    {
      pkl_ast_node arg_decl;
      pkl_ast_node arg_identifier = PKL_AST_FUNC_ARG_IDENTIFIER (arg);

      pkl_ast_node dummy
        = pkl_ast_make_integer (parser->ast, 0);
      PKL_AST_TYPE (dummy) = ASTREF (PKL_AST_FUNC_ARG_TYPE (arg));

      arg_decl = pkl_ast_make_decl (parser->ast,
                                    PKL_AST_DECL_KIND_VAR,
                                    arg_identifier,
                                    dummy,
                                    NULL /* source */);
      PKL_AST_LOC (arg_decl) = PKL_AST_LOC (arg);

      if (!pkl_env_register (parser->env,
                             PKL_ENV_NS_MAIN,
                             PKL_AST_IDENTIFIER_POINTER (arg_identifier),
                             arg_decl))
        {
          pkl_error (parser->compiler, parser->ast, PKL_AST_LOC (arg_identifier),
                     "duplicated argument name `%s' in function declaration",
                     PKL_AST_IDENTIFIER_POINTER (arg_identifier));
          /* Make sure to pop the function frame.  */
          parser->env = pkl_env_pop_frame (parser->env);
          return 0;
        }
    }

  return 1;
}
#endif

/* Register N dummy entries in the compilation environment.  */

static void
pkl_register_dummies (struct pkl_parser *parser, int n)
{
  int i;
  for (i = 0; i < n; ++i)
    {
      char *name;
      pkl_ast_node id;
      pkl_ast_node decl;
      int r;

      asprintf (&name, "@*UNUSABLE_OFF_%d*@", i);
      id = pkl_ast_make_identifier (parser->ast, name);
      decl = pkl_ast_make_decl (parser->ast,
                                PKL_AST_DECL_KIND_VAR,
                                id, NULL /* initial */,
                                NULL /* source */);

      r = pkl_env_register (parser->env, parser->ast, PKL_ENV_NS_MAIN, name, decl);
      assert (r);
    }
}

/* Load a module, given its name.
   If the module file cannot be read, return 1.
   If there is a parse error loading the module, return 2.
   Otherwise, return 0.  */

static int
load_module (struct pkl_parser *parser,
             const char *module, pkl_ast_node *node,
             int filename_p, char **filename)
{
  char *module_filename = NULL;
  pkl_ast ast;
  FILE *fp;

  module_filename = pkl_resolve_module (parser->compiler,
                                        module,
                                        filename_p);
  if (module_filename == NULL)
    /* No file found.  */
    return 1;

  fp = fopen (module_filename, "rb");
  if (!fp)
    {
      free (module_filename);
      return 1;
    }

  /* Parse the file, using the given environment.  The declarations
     found in the parsed file are appended to that environment, so
     nothing extra should be done about that.  */
  if (pkl_parse_file (parser->compiler, &parser->env, &ast, fp,
                      module_filename)
      != 0)
    {
      fclose (fp);
      free (module_filename);
      return 2;
    }

  /* However, the AST nodes shall be appended explicitly, which is
     achieved by returning them to the caller in the NODE
     argument.  */
  *node = PKL_AST_PROGRAM_ELEMS (ast->ast);

  /* Dirty hack is dirty, but it works.  */
  PKL_AST_PROGRAM_ELEMS (ast->ast) = NULL;
  pkl_ast_free (ast);

  /* Set the `filename' output argument if needed.  */
  if (filename)
    *filename = strdup (module_filename);

  fclose (fp);
  free (module_filename);
  return 0;
}


#line 409 "pkl-tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "pkl-tab.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_INTEGER = 3,                    /* "integer literal"  */
  YYSYMBOL_LEXER_EXCEPTION = 4,            /* LEXER_EXCEPTION  */
  YYSYMBOL_CHAR = 5,                       /* "character literal"  */
  YYSYMBOL_STR = 6,                        /* "string"  */
  YYSYMBOL_IDENTIFIER = 7,                 /* "identifier"  */
  YYSYMBOL_TYPENAME = 8,                   /* "type name"  */
  YYSYMBOL_UNIT = 9,                       /* "offset unit"  */
  YYSYMBOL_OFFSET = 10,                    /* "offset"  */
  YYSYMBOL_ASM = 11,                       /* "keyword `asm'"  */
  YYSYMBOL_ENUM = 12,                      /* "keyword `enum'"  */
  YYSYMBOL_PINNED = 13,                    /* "keyword `pinned'"  */
  YYSYMBOL_STRUCT = 14,                    /* "keyword `struct'"  */
  YYSYMBOL_UNION = 15,                     /* "keyword `union'"  */
  YYSYMBOL_CONST = 16,                     /* "keyword `const'"  */
  YYSYMBOL_CONTINUE = 17,                  /* "keyword `continue'"  */
  YYSYMBOL_ELSE = 18,                      /* "keyword `else'"  */
  YYSYMBOL_IF = 19,                        /* "keyword `if'"  */
  YYSYMBOL_WHILE = 20,                     /* "keyword `while'"  */
  YYSYMBOL_UNTIL = 21,                     /* "keyword `until'"  */
  YYSYMBOL_FOR = 22,                       /* "keyword `for'"  */
  YYSYMBOL_IN = 23,                        /* "keyword `in'"  */
  YYSYMBOL_WHERE = 24,                     /* "keyword `where'"  */
  YYSYMBOL_SIZEOF = 25,                    /* "keyword `sizeof'"  */
  YYSYMBOL_TYPEOF = 26,                    /* "keyword `typeof'"  */
  YYSYMBOL_ASSERT = 27,                    /* "keyword `assert'"  */
  YYSYMBOL_APUSH = 28,                     /* "keyword `apush'"  */
  YYSYMBOL_APOP = 29,                      /* "keyword `apop'"  */
  YYSYMBOL_ERR = 30,                       /* "token"  */
  YYSYMBOL_ALIEN = 31,                     /* ALIEN  */
  YYSYMBOL_INTCONSTR = 32,                 /* "int type constructor"  */
  YYSYMBOL_UINTCONSTR = 33,                /* "uint type constructor"  */
  YYSYMBOL_OFFSETCONSTR = 34,              /* "offset type constructor"  */
  YYSYMBOL_DEFUN = 35,                     /* "keyword `fun'"  */
  YYSYMBOL_DEFSET = 36,                    /* "keyword `defset'"  */
  YYSYMBOL_DEFTYPE = 37,                   /* "keyword `type'"  */
  YYSYMBOL_DEFVAR = 38,                    /* "keyword `var'"  */
  YYSYMBOL_DEFUNIT = 39,                   /* "keyword `unit'"  */
  YYSYMBOL_METHOD = 40,                    /* "keyword `method'"  */
  YYSYMBOL_RETURN = 41,                    /* "keyword `return'"  */
  YYSYMBOL_BREAK = 42,                     /* "keyword `break'"  */
  YYSYMBOL_STRING = 43,                    /* "string type specifier"  */
  YYSYMBOL_TRY = 44,                       /* "keyword `try'"  */
  YYSYMBOL_CATCH = 45,                     /* "keyword `catch'"  */
  YYSYMBOL_RAISE = 46,                     /* "keyword `raise'"  */
  YYSYMBOL_VOID = 47,                      /* "void type specifier"  */
  YYSYMBOL_ANY = 48,                       /* "any type specifier"  */
  YYSYMBOL_PRINT = 49,                     /* "keyword `print'"  */
  YYSYMBOL_PRINTF = 50,                    /* "keyword `printf'"  */
  YYSYMBOL_LOAD = 51,                      /* "keyword `load'"  */
  YYSYMBOL_LAMBDA = 52,                    /* "keyword `lambda'"  */
  YYSYMBOL_FORMAT = 53,                    /* "keyword `format'"  */
  YYSYMBOL_COMPUTED = 54,                  /* "keyword `computed'"  */
  YYSYMBOL_IMMUTABLE = 55,                 /* IMMUTABLE  */
  YYSYMBOL_POWA = 56,                      /* "power-and-assign operator"  */
  YYSYMBOL_MULA = 57,                      /* "multiply-and-assign operator"  */
  YYSYMBOL_DIVA = 58,                      /* "divide-and-assing operator"  */
  YYSYMBOL_MODA = 59,                      /* "modulus-and-assign operator"  */
  YYSYMBOL_ADDA = 60,                      /* "add-and-assing operator"  */
  YYSYMBOL_SUBA = 61,                      /* "subtract-and-assign operator"  */
  YYSYMBOL_SLA = 62,                       /* "shift-left-and-assign operator"  */
  YYSYMBOL_SRA = 63,                       /* "shift-right-and-assign operator"  */
  YYSYMBOL_BANDA = 64,                     /* "bit-and-and-assign operator"  */
  YYSYMBOL_XORA = 65,                      /* "bit-xor-and-assign operator"  */
  YYSYMBOL_IORA = 66,                      /* "bit-or-and-assign operator"  */
  YYSYMBOL_RANGEA = 67,                    /* "range separator"  */
  YYSYMBOL_OR = 68,                        /* "logical or operator"  */
  YYSYMBOL_AND = 69,                       /* "logical and operator"  */
  YYSYMBOL_IMPL = 70,                      /* "logical implication operator"  */
  YYSYMBOL_71_bit_wise_or_operator_ = 71,  /* "bit-wise or operator"  */
  YYSYMBOL_72_bit_wise_xor_operator_ = 72, /* "bit-wise xor operator"  */
  YYSYMBOL_73_bit_wise_and_operator_ = 73, /* "bit-wise and operator"  */
  YYSYMBOL_EQ = 74,                        /* "equality operator"  */
  YYSYMBOL_NE = 75,                        /* "inequality operator"  */
  YYSYMBOL_LE = 76,                        /* "less-or-equal operator"  */
  YYSYMBOL_GE = 77,                        /* "bigger-or-equal-than operator"  */
  YYSYMBOL_78_less_than_operator_ = 78,    /* "less-than operator"  */
  YYSYMBOL_79_bigger_than_operator_ = 79,  /* "bigger-than operator"  */
  YYSYMBOL_SL = 80,                        /* "left shift operator"  */
  YYSYMBOL_SR = 81,                        /* "right shift operator"  */
  YYSYMBOL_82_addition_operator_ = 82,     /* "addition operator"  */
  YYSYMBOL_83_subtraction_operator_ = 83,  /* "subtraction operator"  */
  YYSYMBOL_84_multiplication_operator_ = 84, /* "multiplication operator"  */
  YYSYMBOL_85_division_operator_ = 85,     /* "division operator"  */
  YYSYMBOL_CEILDIV = 86,                   /* "ceiling division operator"  */
  YYSYMBOL_87_modulus_operator_ = 87,      /* "modulus operator"  */
  YYSYMBOL_POW = 88,                       /* "power operator"  */
  YYSYMBOL_BCONC = 89,                     /* "bit-concatenation operator"  */
  YYSYMBOL_90_map_operator_ = 90,          /* "map operator"  */
  YYSYMBOL_NSMAP = 91,                     /* "non-strict map operator"  */
  YYSYMBOL_INC = 92,                       /* "increment operator"  */
  YYSYMBOL_DEC = 93,                       /* "decrement operator"  */
  YYSYMBOL_AS = 94,                        /* "cast operator"  */
  YYSYMBOL_ISA = 95,                       /* "type identification operator"  */
  YYSYMBOL_96_dot_operator_ = 96,          /* "dot operator"  */
  YYSYMBOL_IND = 97,                       /* "indirection operator"  */
  YYSYMBOL_ATTR = 98,                      /* "attribute"  */
  YYSYMBOL_UNMAP = 99,                     /* "unmap operator"  */
  YYSYMBOL_REMAP = 100,                    /* "remap operator"  */
  YYSYMBOL_EXCOND = 101,                   /* "conditional on exception operator"  */
  YYSYMBOL_BIG = 102,                      /* "keyword `big'"  */
  YYSYMBOL_LITTLE = 103,                   /* "keyword `little'"  */
  YYSYMBOL_SIGNED = 104,                   /* "keyword `signed'"  */
  YYSYMBOL_UNSIGNED = 105,                 /* "keyword `unsigned'"  */
  YYSYMBOL_THREEDOTS = 106,                /* "varargs indicator"  */
  YYSYMBOL_ARRSUF = 107,                   /* "array suffix"  */
  YYSYMBOL_THEN = 108,                     /* THEN  */
  YYSYMBOL_109_ = 109,                     /* '?'  */
  YYSYMBOL_110_ = 110,                     /* ':'  */
  YYSYMBOL_UNARY = 111,                    /* UNARY  */
  YYSYMBOL_HYPERUNARY = 112,               /* HYPERUNARY  */
  YYSYMBOL_START_EXP = 113,                /* START_EXP  */
  YYSYMBOL_START_DECL = 114,               /* START_DECL  */
  YYSYMBOL_START_STMT = 115,               /* START_STMT  */
  YYSYMBOL_START_PROGRAM = 116,            /* START_PROGRAM  */
  YYSYMBOL_117_ = 117,                     /* ','  */
  YYSYMBOL_118_ = 118,                     /* ';'  */
  YYSYMBOL_119_ = 119,                     /* '('  */
  YYSYMBOL_120_ = 120,                     /* ')'  */
  YYSYMBOL_121_ = 121,                     /* '~'  */
  YYSYMBOL_122_ = 122,                     /* '!'  */
  YYSYMBOL_123_ = 123,                     /* ".>"  */
  YYSYMBOL_124_ = 124,                     /* '['  */
  YYSYMBOL_125_ = 125,                     /* ']'  */
  YYSYMBOL_126_ = 126,                     /* '{'  */
  YYSYMBOL_127_ = 127,                     /* '}'  */
  YYSYMBOL_128_ = 128,                     /* '='  */
  YYSYMBOL_YYACCEPT = 129,                 /* $accept  */
  YYSYMBOL_pushlevel = 130,                /* pushlevel  */
  YYSYMBOL_start = 131,                    /* start  */
  YYSYMBOL_program = 132,                  /* program  */
  YYSYMBOL_program_elem_list = 133,        /* program_elem_list  */
  YYSYMBOL_program_elem = 134,             /* program_elem  */
  YYSYMBOL_load = 135,                     /* load  */
  YYSYMBOL_integer = 136,                  /* integer  */
  YYSYMBOL_identifier = 137,               /* identifier  */
  YYSYMBOL_expression_list = 138,          /* expression_list  */
  YYSYMBOL_expression_opt = 139,           /* expression_opt  */
  YYSYMBOL_expression = 140,               /* expression  */
  YYSYMBOL_bconc = 141,                    /* bconc  */
  YYSYMBOL_mapop = 142,                    /* mapop  */
  YYSYMBOL_map = 143,                      /* map  */
  YYSYMBOL_unary_operator = 144,           /* unary_operator  */
  YYSYMBOL_primary = 145,                  /* primary  */
  YYSYMBOL_146_1 = 146,                    /* $@1  */
  YYSYMBOL_funcall = 147,                  /* funcall  */
  YYSYMBOL_funcall_arg_list = 148,         /* funcall_arg_list  */
  YYSYMBOL_funcall_arg = 149,              /* funcall_arg  */
  YYSYMBOL_format_arg_list = 150,          /* format_arg_list  */
  YYSYMBOL_format_arg = 151,               /* format_arg  */
  YYSYMBOL_opt_comma = 152,                /* opt_comma  */
  YYSYMBOL_struct_field_list = 153,        /* struct_field_list  */
  YYSYMBOL_struct_field = 154,             /* struct_field  */
  YYSYMBOL_array = 155,                    /* array  */
  YYSYMBOL_array_initializer_list = 156,   /* array_initializer_list  */
  YYSYMBOL_array_initializer = 157,        /* array_initializer  */
  YYSYMBOL_pushlevel_args = 158,           /* pushlevel_args  */
  YYSYMBOL_function_specifier = 159,       /* function_specifier  */
  YYSYMBOL_function_arg_list = 160,        /* function_arg_list  */
  YYSYMBOL_function_arg = 161,             /* function_arg  */
  YYSYMBOL_function_arg_initial = 162,     /* function_arg_initial  */
  YYSYMBOL_type_specifier = 163,           /* type_specifier  */
  YYSYMBOL_typename = 164,                 /* typename  */
  YYSYMBOL_string_type_specifier = 165,    /* string_type_specifier  */
  YYSYMBOL_simple_type_specifier = 166,    /* simple_type_specifier  */
  YYSYMBOL_cons_type_specifier = 167,      /* cons_type_specifier  */
  YYSYMBOL_integral_type_specifier = 168,  /* integral_type_specifier  */
  YYSYMBOL_dynamic_integral_type_specifier = 169, /* dynamic_integral_type_specifier  */
  YYSYMBOL_integral_type_sign = 170,       /* integral_type_sign  */
  YYSYMBOL_ref_type = 171,                 /* ref_type  */
  YYSYMBOL_offset_type_specifier = 172,    /* offset_type_specifier  */
  YYSYMBOL_array_type_specifier = 173,     /* array_type_specifier  */
  YYSYMBOL_function_type_specifier = 174,  /* function_type_specifier  */
  YYSYMBOL_function_type_arg_list = 175,   /* function_type_arg_list  */
  YYSYMBOL_function_type_arg = 176,        /* function_type_arg  */
  YYSYMBOL_struct_type_specifier = 177,    /* struct_type_specifier  */
  YYSYMBOL_178_2 = 178,                    /* $@2  */
  YYSYMBOL_struct_or_union = 179,          /* struct_or_union  */
  YYSYMBOL_struct_type_pinned = 180,       /* struct_type_pinned  */
  YYSYMBOL_integral_struct = 181,          /* integral_struct  */
  YYSYMBOL_struct_type_elem_list = 182,    /* struct_type_elem_list  */
  YYSYMBOL_endianness = 183,               /* endianness  */
  YYSYMBOL_struct_type_computed_field = 184, /* struct_type_computed_field  */
  YYSYMBOL_struct_type_field = 185,        /* struct_type_field  */
  YYSYMBOL_186_3 = 186,                    /* $@3  */
  YYSYMBOL_struct_type_field_identifier = 187, /* struct_type_field_identifier  */
  YYSYMBOL_struct_type_field_label = 188,  /* struct_type_field_label  */
  YYSYMBOL_struct_type_field_constraint_and_init = 189, /* struct_type_field_constraint_and_init  */
  YYSYMBOL_struct_type_field_optcond_pre = 190, /* struct_type_field_optcond_pre  */
  YYSYMBOL_struct_type_field_optcond_post = 191, /* struct_type_field_optcond_post  */
  YYSYMBOL_simple_declaration = 192,       /* simple_declaration  */
  YYSYMBOL_declaration = 193,              /* declaration  */
  YYSYMBOL_194_4 = 194,                    /* @4  */
  YYSYMBOL_defun_or_method = 195,          /* defun_or_method  */
  YYSYMBOL_defvar_list = 196,              /* defvar_list  */
  YYSYMBOL_defvar = 197,                   /* defvar  */
  YYSYMBOL_deftype_list = 198,             /* deftype_list  */
  YYSYMBOL_deftype = 199,                  /* deftype  */
  YYSYMBOL_defunit_list = 200,             /* defunit_list  */
  YYSYMBOL_defunit = 201,                  /* defunit  */
  YYSYMBOL_comp_stmt = 202,                /* comp_stmt  */
  YYSYMBOL_stmt_decl_list = 203,           /* stmt_decl_list  */
  YYSYMBOL_ass_exp_op = 204,               /* ass_exp_op  */
  YYSYMBOL_simple_stmt_list = 205,         /* simple_stmt_list  */
  YYSYMBOL_simple_stmt = 206,              /* simple_stmt  */
  YYSYMBOL_stmt = 207,                     /* stmt  */
  YYSYMBOL_208_5 = 208,                    /* @5  */
  YYSYMBOL_209_6 = 209,                    /* @6  */
  YYSYMBOL_funcall_stmt = 210,             /* funcall_stmt  */
  YYSYMBOL_funcall_stmt_arg_list = 211,    /* funcall_stmt_arg_list  */
  YYSYMBOL_funcall_stmt_arg = 212          /* funcall_stmt_arg  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif

#ifndef N_
# define N_(Msgid) Msgid
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
# define YYCOPY_NEEDED 1
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined PKL_TAB_LTYPE_IS_TRIVIAL && PKL_TAB_LTYPE_IS_TRIVIAL \
             && defined PKL_TAB_STYPE_IS_TRIVIAL && PKL_TAB_STYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  93
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   5132

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  129
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  84
/* YYNRULES -- Number of rules.  */
#define YYNRULES  286
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  541

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   358


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   122,     2,     2,     2,    87,    73,     2,
     119,   120,    84,    82,   117,    83,    96,    85,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   110,   118,
      78,   128,    79,   109,    90,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   124,     2,   125,    72,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   126,    71,   127,   121,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    74,    75,    76,    77,
      80,    81,    86,    88,    89,    91,    92,    93,    94,    95,
      97,    98,    99,   100,   101,   102,   103,   104,   105,   106,
     107,   108,   111,   112,   113,   114,   115,   116,   123
};

#if PKL_TAB_DEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   593,   593,   608,   614,   621,   627,   633,   639,   649,
     655,   661,   670,   674,   678,   679,   689,   690,   695,   699,
     733,   773,   774,   789,   790,   798,   800,   801,   808,   809,
     813,   814,   820,   827,   834,   840,   846,   852,   858,   863,
     868,   874,   880,   886,   892,   898,   904,   910,   916,   922,
     928,   934,   940,   946,   952,   958,   964,   969,   974,   980,
     986,   992,  1007,  1012,  1027,  1033,  1039,  1040,  1044,  1053,
    1054,  1058,  1064,  1073,  1074,  1075,  1076,  1077,  1078,  1082,
    1111,  1117,  1123,  1129,  1137,  1138,  1144,  1150,  1157,  1162,
    1168,  1174,  1180,  1186,  1192,  1193,  1198,  1197,  1209,  1214,
    1219,  1227,  1233,  1239,  1244,  1249,  1254,  1260,  1266,  1280,
    1303,  1312,  1314,  1315,  1322,  1331,  1333,  1334,  1341,  1349,
    1350,  1354,  1356,  1357,  1364,  1371,  1382,  1390,  1402,  1403,
    1410,  1416,  1429,  1458,  1468,  1481,  1482,  1489,  1499,  1525,
    1526,  1534,  1535,  1536,  1540,  1560,  1568,  1573,  1578,  1579,
    1580,  1581,  1582,  1586,  1587,  1588,  1592,  1603,  1612,  1613,
    1617,  1618,  1622,  1654,  1665,  1671,  1679,  1686,  1696,  1697,
    1704,  1710,  1717,  1736,  1756,  1754,  1818,  1819,  1823,  1824,
    1828,  1829,  1830,  1834,  1835,  1836,  1837,  1839,  1841,  1846,
    1847,  1848,  1852,  1869,  1867,  1996,  1997,  2001,  2005,  2013,
    2019,  2026,  2033,  2041,  2049,  2059,  2063,  2071,  2075,  2087,
    2088,  2089,  2094,  2093,  2148,  2152,  2153,  2157,  2158,  2163,
    2186,  2187,  2192,  2216,  2217,  2222,  2262,  2270,  2281,  2282,
    2284,  2285,  2290,  2291,  2292,  2293,  2294,  2295,  2296,  2297,
    2298,  2299,  2300,  2304,  2305,  2306,  2311,  2317,  2328,  2334,
    2340,  2346,  2359,  2366,  2373,  2379,  2385,  2391,  2400,  2401,
    2406,  2410,  2416,  2422,  2433,  2448,  2461,  2460,  2510,  2509,
    2558,  2564,  2570,  2576,  2582,  2596,  2610,  2628,  2640,  2646,
    2652,  2658,  2671,  2675,  2684,  2685,  2692
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  static const char *const yy_sname[] =
  {
  N_("end of file"), N_("error"), N_("invalid token"),
  N_("integer literal"), "LEXER_EXCEPTION", N_("character literal"),
  N_("string"), N_("identifier"), N_("type name"), N_("offset unit"),
  N_("offset"), N_("keyword `asm'"), N_("keyword `enum'"),
  N_("keyword `pinned'"), N_("keyword `struct'"), N_("keyword `union'"),
  N_("keyword `const'"), N_("keyword `continue'"), N_("keyword `else'"),
  N_("keyword `if'"), N_("keyword `while'"), N_("keyword `until'"),
  N_("keyword `for'"), N_("keyword `in'"), N_("keyword `where'"),
  N_("keyword `sizeof'"), N_("keyword `typeof'"), N_("keyword `assert'"),
  N_("keyword `apush'"), N_("keyword `apop'"), N_("token"), "ALIEN",
  N_("int type constructor"), N_("uint type constructor"),
  N_("offset type constructor"), N_("keyword `fun'"),
  N_("keyword `defset'"), N_("keyword `type'"), N_("keyword `var'"),
  N_("keyword `unit'"), N_("keyword `method'"), N_("keyword `return'"),
  N_("keyword `break'"), N_("string type specifier"), N_("keyword `try'"),
  N_("keyword `catch'"), N_("keyword `raise'"), N_("void type specifier"),
  N_("any type specifier"), N_("keyword `print'"), N_("keyword `printf'"),
  N_("keyword `load'"), N_("keyword `lambda'"), N_("keyword `format'"),
  N_("keyword `computed'"), "IMMUTABLE", N_("power-and-assign operator"),
  N_("multiply-and-assign operator"), N_("divide-and-assing operator"),
  N_("modulus-and-assign operator"), N_("add-and-assing operator"),
  N_("subtract-and-assign operator"), N_("shift-left-and-assign operator"),
  N_("shift-right-and-assign operator"), N_("bit-and-and-assign operator"),
  N_("bit-xor-and-assign operator"), N_("bit-or-and-assign operator"),
  N_("range separator"), N_("logical or operator"),
  N_("logical and operator"), N_("logical implication operator"),
  N_("bit-wise or operator"), N_("bit-wise xor operator"),
  N_("bit-wise and operator"), N_("equality operator"),
  N_("inequality operator"), N_("less-or-equal operator"),
  N_("bigger-or-equal-than operator"), N_("less-than operator"),
  N_("bigger-than operator"), N_("left shift operator"),
  N_("right shift operator"), N_("addition operator"),
  N_("subtraction operator"), N_("multiplication operator"),
  N_("division operator"), N_("ceiling division operator"),
  N_("modulus operator"), N_("power operator"),
  N_("bit-concatenation operator"), N_("map operator"),
  N_("non-strict map operator"), N_("increment operator"),
  N_("decrement operator"), N_("cast operator"),
  N_("type identification operator"), N_("dot operator"),
  N_("indirection operator"), N_("attribute"), N_("unmap operator"),
  N_("remap operator"), N_("conditional on exception operator"),
  N_("keyword `big'"), N_("keyword `little'"), N_("keyword `signed'"),
  N_("keyword `unsigned'"), N_("varargs indicator"), N_("array suffix"),
  "THEN", "'?'", "':'", "UNARY", "HYPERUNARY", "START_EXP", "START_DECL",
  "START_STMT", "START_PROGRAM", "','", "';'", "'('", "')'", "'~'", "'!'",
  ".>", "'['", "']'", "'{'", "'}'", "'='", "$accept", "pushlevel", "start",
  "program", "program_elem_list", "program_elem", "load", "integer",
  "identifier", "expression_list", "expression_opt", "expression", "bconc",
  "mapop", "map", "unary_operator", "primary", "$@1", "funcall",
  "funcall_arg_list", "funcall_arg", "format_arg_list", "format_arg",
  "opt_comma", "struct_field_list", "struct_field", "array",
  "array_initializer_list", "array_initializer", "pushlevel_args",
  "function_specifier", "function_arg_list", "function_arg",
  "function_arg_initial", "type_specifier", "typename",
  "string_type_specifier", "simple_type_specifier", "cons_type_specifier",
  "integral_type_specifier", "dynamic_integral_type_specifier",
  "integral_type_sign", "ref_type", "offset_type_specifier",
  "array_type_specifier", "function_type_specifier",
  "function_type_arg_list", "function_type_arg", "struct_type_specifier",
  "$@2", "struct_or_union", "struct_type_pinned", "integral_struct",
  "struct_type_elem_list", "endianness", "struct_type_computed_field",
  "struct_type_field", "$@3", "struct_type_field_identifier",
  "struct_type_field_label", "struct_type_field_constraint_and_init",
  "struct_type_field_optcond_pre", "struct_type_field_optcond_post",
  "simple_declaration", "declaration", "@4", "defun_or_method",
  "defvar_list", "defvar", "deftype_list", "deftype", "defunit_list",
  "defunit", "comp_stmt", "stmt_decl_list", "ass_exp_op",
  "simple_stmt_list", "simple_stmt", "stmt", "@5", "@6", "funcall_stmt",
  "funcall_stmt_arg_list", "funcall_stmt_arg", YY_NULLPTR
  };
  /* YYTRANSLATABLE[SYMBOL-NUM] -- Whether YY_SNAME[SYMBOL-NUM] is
     internationalizable.  */
  static yytype_int8 yytranslatable[] =
  {
       1,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     0,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0
  };
  return (yysymbol < YYNTOKENS && yytranslatable[yysymbol]
          ? _(yy_sname[yysymbol])
          : yy_sname[yysymbol]);
}
#endif

#define YYPACT_NINF (-480)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-269)

#define yytable_value_is_error(Yyn) \
  ((Yyn) == YYTABLE_NINF)

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     188,  2508,   338,  1904,   867,     7,  -480,  -480,  -480,  -480,
    -480,  -480,  -480,  -480,   374,   -73,   -65,   -42,   -40,  -480,
    -480,   374,  -480,  -480,  -480,  -480,   -34,  -480,  -480,  2508,
    2508,  -480,  -480,  2508,  -480,  -480,  2028,   -33,  -480,  4509,
    -480,  -480,  2508,    85,  -480,  -480,    44,   -24,   -74,   -16,
    -480,   243,  -480,    27,    59,  -480,   254,   254,   254,  -480,
      36,    45,   254,    49,    46,    47,    64,    86,    96,  2128,
      54,  1904,  2190,  2508,    21,   264,  -480,    80,  4838,    74,
      90,  5004,    59,    95,   108,  -480,   338,  -480,   992,  -480,
    -480,  -480,  -480,  -480,  -480,  -480,   -66,  -480,   374,  2508,
    2508,  2508,    67,   187,   217,   185,   185,  3375,   203,   109,
     114,  4838,   123,  -480,  1098,  -480,  2508,  2508,  2508,  2508,
    2508,  2508,  2508,  2508,  2508,  2508,  2508,  2508,  2508,  2508,
    2508,  2508,  2508,  2508,  2508,  2508,  2508,  2508,  2508,  -480,
    -480,   374,   374,   136,  2508,  2508,  -480,   160,   254,   254,
    1533,   254,  2252,  1595,  -480,  -480,  1657,  2508,  1533,   194,
    2508,  -480,  -480,   154,   167,  -480,   161,   180,  -480,   181,
     195,  -480,  -480,  -480,  -480,  2508,  -480,  2508,  2508,    23,
    2508,  -480,  4185,  -480,     3,  -480,  4266,  4347,  1533,   305,
     201,   206,  -480,  2508,  2508,  -480,  -480,  -480,  -480,  -480,
    -480,  -480,  -480,  -480,  -480,  -480,   318,  2508,  2508,   219,
    -480,  -480,  -480,  -480,  -480,   211,   -11,  3456,   -81,  4590,
    3537,   229,  -480,  -480,   -57,  1533,  -480,  -480,  2508,  1431,
    -102,  -480,  -480,  1204,  -480,   853,  4919,  4958,  4838,   978,
    1081,  2602,   766,   766,  1252,  1252,  1252,  1252,  1414,  1414,
     708,   708,   156,   156,   156,   156,   171,   258,   208,   208,
    2508,   766,  4671,  -480,  -480,  4838,   -58,  -480,  -480,  1719,
    2646,   212,   -95,   216,  4838,   248,  -480,  -480,  2727,  4714,
     249,  4838,  -480,   766,   209,   254,  2508,   254,  2508,   254,
     239,  3132,  3618,  3699,   346,  2374,   310,  3213,  -480,  2508,
     -15,  -480,  -480,  4838,   158,  -480,  1533,  -480,  -480,  4838,
    4838,  2508,  4838,  4838,  -480,  2508,  -480,  -480,  -480,  2508,
    -480,   266,   266,   347,  -480,    -6,  2808,  -480,  -480,  -480,
    -480,  -480,  -480,  3780,  2508,  2508,  -480,  -480,  2889,  2508,
    1781,  -480,  2508,  1266,   257,  -480,  2508,  2386,   250,    41,
     373,  -480,   208,  -480,  -480,  -480,  4838,  -480,  4838,  -480,
     187,  1533,  -480,  1904,  1904,  2508,   270,  4838,   271,  2508,
    -480,  4428,  2508,  -480,  -480,  2508,  -480,    28,  4838,  3294,
    3861,   374,   312,   314,   290,   279,   283,    14,  -480,  -480,
     275,  -480,  4877,  -480,  -480,  2970,  -480,  3051,  4838,  -480,
    -480,  4838,  4838,  -480,  -480,   374,   -84,   284,   292,  -480,
     281,  -480,    79,   392,  -480,  4838,  1369,  2374,  3942,  -480,
    4838,   347,  -480,  -480,  1533,  -480,  -480,   208,  -480,  -480,
    -480,   374,   347,   285,  -480,  2508,  -480,  -480,   208,  -480,
     374,     4,  -480,  -480,   374,  1533,  2508,  -480,  1904,   387,
     293,    68,  -480,   297,  -480,  -480,   298,    83,   -54,  -480,
    2508,  -480,  4838,   208,  -480,   208,  -480,    10,   300,    94,
    -480,   299,   403,  1966,  1904,  1369,  -480,  -480,  -480,  4838,
     349,   302,  -480,  1904,  2508,  -480,  -480,   105,  -480,  -480,
    -480,  -480,   253,  -480,  4023,  1904,   311,   209,    26,  -480,
    -480,   214,  -480,  1904,  -480,  2508,   254,  -480,  -480,  -480,
    -480,  -480,  -480,   209,  -480,  4104,   313,   254,  -480,  -480,
    -480,  -480,   -68,  2508,  2508,  2508,   342,  4838,  2565,  4795,
    2508,   414,  2508,  2508,  4838,  2508,   319,  4838,  4838,  4838,
    -480
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       0,     2,     0,     2,     2,     0,    21,    22,    81,    82,
      79,   144,    61,    62,     0,     0,     0,     0,     0,   158,
     159,     0,   145,   147,   146,    96,     0,    74,    73,     2,
       2,    77,    78,     2,    75,    76,     2,     0,    80,     3,
      66,    67,     2,    30,    94,    84,   148,   152,     0,     0,
     149,     0,   150,   151,     0,   215,     0,     0,     0,   216,
       0,     5,     0,     0,     0,     0,     0,     0,     0,     2,
       0,     2,     2,     2,     0,     0,   259,     9,   250,    66,
      67,    30,   258,     0,     7,   254,     0,    11,     2,    14,
     282,    16,    18,     1,   148,   152,     0,   151,     0,     2,
       2,     2,     0,     0,     0,    64,    65,     0,    30,     0,
       0,   130,   119,   128,     2,    63,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,   101,
     102,     0,     0,    32,     2,     2,     4,    31,     0,     0,
     111,     0,     2,   121,    69,    70,     2,     2,    25,     0,
       2,    24,    23,     0,   210,   220,     0,   209,   217,     0,
     211,   223,   214,     6,   212,     2,   271,     2,     2,     2,
       2,   272,     0,   270,     0,   278,     0,     0,   115,     0,
       0,     0,    10,     2,     2,   232,   233,   234,   235,   236,
     237,   238,   239,   240,   242,   241,     0,     2,     2,   283,
     284,   260,     8,    17,    15,     0,     0,     0,     0,     0,
       0,     0,   132,    97,     0,   115,    83,    95,     2,   120,
       0,   226,   230,     2,   228,    55,    53,    52,    54,    49,
      50,    51,    43,    44,    47,    48,    45,    46,    41,    42,
      34,    35,    36,    37,    38,    40,    39,    68,    56,    57,
       2,    60,     0,    86,    87,   114,     0,   112,    85,     2,
       0,    79,   144,     0,   124,   119,   122,   164,     0,    71,
     119,    26,   156,    59,     2,     0,     2,     0,     2,     0,
       0,     0,     0,     0,     0,     2,     0,     0,   273,     2,
       2,   279,   280,   118,     0,   116,   115,    20,    19,   248,
     249,     2,   246,   247,   285,     2,   105,   103,   104,     2,
     107,   160,   160,     0,   132,     0,     0,   129,   127,   126,
     227,   231,   229,     0,     2,     2,   110,    91,     0,     2,
       2,    88,     2,     2,     0,   165,     2,     2,     0,     0,
     178,   222,   141,   143,   142,   221,   219,   218,   225,   224,
       0,    25,   255,     2,     2,     2,     0,    29,     0,     2,
     252,     0,     2,     2,   274,     2,   281,     0,   286,     0,
       0,     0,     0,     0,     0,     0,   135,     0,     2,   100,
       0,    33,    58,   113,    92,     0,    93,     0,   125,   123,
     109,    72,    27,   108,   172,     0,   170,     0,   168,   179,
       0,   213,     0,   261,   263,     2,   243,     2,     0,   277,
       2,     0,   117,   251,    25,    98,   106,   161,   163,   162,
     138,     0,     0,   139,   134,     2,    89,    90,   167,   171,
       0,     0,   176,   177,   180,    25,     2,   256,     2,   266,
       0,     0,   244,     0,   253,   275,     0,     0,     0,   136,
       2,   137,   131,   166,   169,   181,   182,     0,     0,     0,
     262,     0,     0,     2,     2,   243,     2,    99,     2,   140,
       0,   174,   257,     2,     2,   245,   265,     0,   276,   133,
     157,   173,   205,   267,     0,     2,     0,     2,   205,   184,
     183,   189,   185,     2,   264,     2,     0,   175,   188,   187,
     186,   191,   190,     2,   269,     0,     0,   195,   206,   192,
     196,   193,   199,     2,     2,     2,   197,   204,   200,   201,
       2,   207,     2,     2,   198,     2,     0,   203,   202,   208,
     194
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -480,  -176,  -480,  -480,  -480,   350,   436,   -43,   498,  -274,
      24,    -1,    98,  -480,   102,  -480,    -2,  -480,  -480,  -480,
     107,  -199,    65,  -260,  -480,   100,  -480,  -480,   220,   124,
      92,    22,    32,  -480,  -479,   294,   322,   260,  -480,  -480,
    -480,    11,   134,  -480,   384,  -480,    16,  -480,  -480,  -480,
    -480,  -480,  -480,  -480,  -480,   -38,   -31,  -480,  -480,  -480,
    -480,  -480,  -480,   162,    53,  -480,  -480,  -480,   182,  -480,
     183,  -480,   189,    87,  -480,  -480,    -5,  -397,   139,  -480,
    -480,   441,  -480,   267
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,    37,     5,    87,    88,    89,    90,    38,   384,   280,
     366,    78,    40,   157,    41,    42,    43,   103,    44,   266,
     267,   304,   305,   230,   275,   276,    45,   112,   113,   323,
     223,   385,   386,   461,   351,    46,    47,    48,    49,    50,
     466,    51,   382,    52,    53,   353,   407,   408,   354,   492,
     444,   410,   468,   498,   513,   499,   500,   522,   521,   531,
     526,   501,   536,    60,    91,   290,    62,   167,   168,   164,
     165,   170,   171,    54,   233,   208,   451,    83,    92,   471,
     472,    85,   209,   210
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      39,    81,    81,   296,   372,   328,   523,    93,   159,   154,
     155,   -23,    11,     6,     7,   344,   154,   155,   506,   452,
     348,   161,   162,   329,   299,   439,   325,   188,   105,   106,
     294,   108,   107,   -23,   517,   111,    19,    20,    21,   318,
     156,   147,   524,   156,   215,   496,    98,    22,   300,    11,
     156,    23,    24,   324,    99,    61,   478,    11,   156,   335,
     525,    55,   336,    56,    57,    58,    59,   156,   182,    81,
     156,   186,   187,    19,    20,    21,   485,   100,   452,   101,
     497,    19,    20,    21,    22,   104,    81,   412,    23,    24,
      82,    82,    22,   114,   480,  -155,    23,    24,   217,   219,
     220,    79,    79,   158,   373,    80,    80,   377,   350,   316,
     404,   375,    81,   156,   389,   235,   236,   237,   238,   239,
     240,   241,   242,   243,   244,   245,   246,   247,   248,   249,
     250,   251,   252,   253,   254,   255,   256,   257,   156,   213,
     189,   295,    84,   261,   262,   375,  -154,   404,   423,   265,
     457,   270,   274,   507,   172,   278,   279,   281,    82,   283,
     160,   405,   173,  -153,   176,   115,   177,   232,   175,    79,
     153,   469,   183,    80,   291,    82,   292,   293,   321,   297,
     115,   148,   149,   178,   221,   473,    79,   303,   474,   445,
      80,   156,   309,   310,  -269,    11,   446,   421,   192,   447,
     446,    82,   193,   477,   150,   179,   312,   313,   151,   152,
     184,   446,    79,   211,   482,   180,    80,    11,   194,    19,
      20,    21,   473,   225,   303,   495,   212,   326,   111,   227,
      22,    81,     6,     7,    23,    24,   161,   162,   228,   449,
     229,    19,    20,    21,   137,   138,     6,     7,   139,   140,
     141,   142,    22,   234,   143,   260,    23,    24,   143,   333,
     138,   161,   162,   139,   140,   141,   142,   115,   338,   143,
     190,   191,   496,   282,    96,   375,   376,  -269,  -269,   141,
     142,   102,   284,   143,   285,   356,   331,   358,    55,   286,
      56,    57,    58,    59,   367,   442,   443,   287,   371,   148,
     149,     1,     2,     3,     4,   303,   222,   497,    94,   288,
     378,   306,   289,   206,   379,    94,   511,   512,   380,   307,
      82,   350,   150,    96,   308,   311,   151,   152,   349,   206,
     315,    79,   156,   392,   265,    80,    95,   350,   395,   397,
     -24,   398,   274,    95,   342,   401,   402,    56,    57,    58,
     139,   140,   141,   142,   161,   272,   143,    94,   216,   218,
     281,    81,    81,   224,   415,   343,   347,   360,   418,   365,
     403,   420,   332,    55,   303,    56,    57,    58,    59,    19,
      20,    21,    11,   381,   400,    95,   409,   374,   416,   417,
      22,   428,    94,   429,    23,    24,   430,    94,    97,   431,
     432,   258,   259,   435,   440,    97,    19,    20,    21,   441,
     448,  -268,   189,   460,    81,   475,   367,    22,   476,   483,
      95,    23,    24,   281,   159,    95,   481,   484,   490,   491,
     505,   519,   530,   535,   462,    94,    94,   540,   214,    77,
     422,   453,   393,   399,   281,   402,    81,    97,   388,   327,
      82,    82,   411,   456,   459,   467,   383,   464,   368,   479,
     508,    79,    79,    95,    95,    80,    80,   509,   355,   357,
     487,    81,    81,    81,   109,   434,   314,     0,   359,     0,
       0,    81,    97,   494,     0,     0,     0,    97,     0,     0,
       0,     0,     0,    81,     0,     0,     0,     0,     0,     0,
       0,    81,   413,   414,   515,     0,     0,   455,     0,     0,
       0,     0,     0,     0,    79,     0,     0,     0,    80,     0,
       0,     0,   527,   528,   529,    97,    97,     0,     0,   534,
       0,   537,   538,     0,   539,    82,     0,     0,     0,     0,
       0,     0,     0,     0,   352,   502,    79,     0,     0,     0,
      80,   510,     0,     0,   163,   166,   169,     0,     0,     0,
     174,    82,     0,   488,     0,   489,     0,     0,     0,     0,
      82,    79,    79,    79,     0,    80,    80,    80,    94,     0,
       0,    79,    82,   387,     0,    80,     0,   470,     0,     0,
      82,     0,     0,    79,     0,     0,     0,    80,     0,     0,
       0,    79,     0,     0,     0,    80,    95,     0,     0,   406,
       0,     0,     0,   486,     0,     0,     0,    94,     0,     0,
     224,     0,   493,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   504,     0,     0,     0,     0,     0,
       0,   427,   514,    94,     0,    95,   263,   264,     0,   268,
       0,   273,     0,     0,    94,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   438,     0,     0,    97,     0,
       0,    95,     0,     0,     0,    94,     0,     0,     0,     0,
       0,   387,    95,     0,     0,     0,     0,     0,     0,     0,
       0,   458,   387,     0,     0,     0,     0,     0,     0,    94,
     463,   406,     0,    95,   465,     0,     0,    97,     0,     0,
       0,     0,     0,     0,     0,    94,     0,   115,     0,   322,
       0,     0,     0,     0,     0,    94,    94,    95,     0,     0,
       0,     0,     0,    97,    94,    94,     0,     0,    94,     0,
       0,     0,     0,    95,    97,     0,     0,     0,     0,     0,
       0,     0,     0,    95,    95,     0,     0,   352,     0,     0,
       0,     0,    95,    95,     0,    97,    95,     0,     0,     0,
       0,     0,     0,   352,     0,   115,     0,     0,     0,     0,
       0,     0,     0,   163,     0,   166,     0,   169,     0,    97,
       0,    94,   133,   134,   135,   136,   137,   138,     0,     0,
     139,   140,   141,   142,     0,    97,   143,    94,     0,     0,
       0,     0,     0,     0,     0,    97,    97,     0,     0,    95,
       0,     0,     0,     0,    97,    97,     0,     0,    97,     0,
       0,     0,     0,     0,     0,    95,     0,     0,     0,     0,
       0,   273,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,     0,     0,   139,   140,
     141,   142,   115,     0,   143,     0,     0,   -12,     0,     0,
       6,     7,     8,     9,    10,    11,    12,    13,    63,     0,
       0,    97,     0,     0,    64,   433,    65,    66,     0,    67,
       0,     0,    15,    16,    68,    17,    18,    97,     0,    19,
      20,    21,    55,     0,    56,    57,    58,    59,    69,    70,
      22,    71,     0,    72,    23,    24,    73,    74,    75,    25,
      26,     0,    86,     0,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,     0,     0,   139,   140,   141,   142,    27,
      28,   143,     0,     0,   144,     0,     0,     0,     0,    29,
      30,     0,     0,     0,     0,     0,    31,    32,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    76,    33,   115,    34,    35,
       0,    36,   -13,     0,     0,     6,     7,     8,     9,    10,
      11,    12,    13,    63,   516,     0,     0,     0,     0,    64,
       0,    65,    66,     0,    67,   520,     0,    15,    16,    68,
      17,    18,     0,     0,    19,    20,    21,    55,     0,    56,
      57,    58,    59,    69,    70,    22,    71,     0,    72,    23,
      24,    73,    74,    75,    25,    26,     0,    86,     0,     0,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,     0,     0,
     139,   140,   141,   142,    27,    28,   143,     0,     0,   144,
       0,     0,     0,     0,    29,    30,     0,     0,     0,     0,
     115,    31,    32,     0,     0,     0,     0,     0,     0,     0,
       0,     6,     7,     8,     9,    10,    11,    12,    13,    63,
      76,    33,     0,    34,    35,    64,    36,    65,    66,     0,
      67,     0,     0,    15,    16,    68,    17,    18,     0,     0,
      19,    20,    21,    55,     0,    56,    57,    58,    59,    69,
      70,    22,    71,     0,    72,    23,    24,    73,    74,    75,
      25,    26,     0,     0,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,     0,     0,   139,   140,   141,   142,     0,     0,   143,
      27,    28,   144,     0,     0,     0,     0,     0,     0,     0,
      29,    30,     0,     0,     0,     0,     0,    31,    32,     0,
       0,     0,     0,     0,     0,     0,     0,     6,     7,     8,
       9,    10,    11,    12,    13,    63,    76,    33,     0,    34,
      35,    64,    36,    65,    66,   231,    67,     0,     0,    15,
      16,    68,    17,    18,     0,     0,    19,    20,    21,    55,
       0,    56,    57,    58,    59,    69,    70,    22,    71,     0,
      72,    23,    24,    73,    74,    75,    25,    26,     0,     0,
       0,   115,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     8,     9,   271,   272,    12,    13,    14,     0,     0,
       0,     0,     0,     0,     0,     0,    27,    28,     0,     0,
       0,    15,    16,     0,    17,    18,    29,    30,    19,    20,
      21,     0,     0,    31,    32,     0,     0,     0,     0,    22,
       0,     0,     0,    23,    24,     0,     0,     0,    25,    26,
       0,     0,    76,    33,     0,    34,    35,     0,    36,     0,
       0,   330,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,     0,     0,   139,   140,   141,   142,    27,    28,
     143,     0,     0,     0,     0,     0,     0,     0,    29,    30,
       0,     0,     0,     0,     0,    31,    32,     0,     0,     0,
       0,     0,     6,     7,     8,     9,    10,    11,    12,    13,
      63,     0,     0,     0,     0,    33,     0,    34,    35,     0,
      36,     0,     0,  -120,    15,    16,    68,    17,    18,     0,
       0,    19,    20,    21,     0,     0,     0,     0,     0,     0,
       0,     0,    22,     0,     0,     0,    23,    24,     0,   450,
       0,    25,    26,   115,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     6,     7,     8,     9,    10,    11,
      12,    13,    14,     0,     0,     0,     0,     0,     0,     0,
       0,    27,    28,     0,     0,     0,    15,    16,     0,    17,
      18,    29,    30,    19,    20,    21,     0,     0,    31,    32,
       0,     0,     0,     0,    22,     0,     0,     0,    23,    24,
       0,     0,     0,    25,    26,     0,     0,     0,    33,     0,
      34,    35,     0,    36,     0,    -2,   131,   132,   133,   134,
     135,   136,   137,   138,     0,     0,   139,   140,   141,   142,
       0,     0,   143,    27,    28,     0,     0,     0,     0,     0,
       0,     0,     0,    29,    30,     0,     0,   110,     0,     0,
      31,    32,     0,     0,     0,     0,     6,     7,     8,     9,
      10,    11,    12,    13,    14,     0,     0,     0,     0,     0,
      33,     0,    34,    35,     0,    36,     0,    -2,    15,    16,
       0,    17,    18,     0,     0,    19,    20,    21,     0,     0,
       0,     0,     0,     0,     0,     0,    22,     0,     0,     0,
      23,    24,     0,     0,     0,    25,    26,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       8,     9,   271,   272,    12,    13,    14,     0,     0,     0,
       0,     0,     0,     0,     0,    27,    28,     0,     0,     0,
      15,    16,     0,    17,    18,    29,    30,    19,    20,    21,
       0,     0,    31,    32,     0,     0,     0,     0,    22,     0,
       0,     0,    23,    24,     0,     0,     0,    25,    26,     0,
       0,     0,    33,     0,    34,    35,     0,    36,     0,    -2,
       6,     7,     8,     9,    10,    11,    12,    13,    14,     0,
       0,     0,     0,     0,     0,     0,     0,    27,    28,     0,
       0,     0,    15,    16,     0,    17,    18,    29,    30,    19,
      20,    21,     0,     0,    31,    32,     0,     0,     0,     0,
      22,     0,     0,     0,    23,    24,     0,     0,     0,    25,
      26,     0,     0,     0,    33,     0,    34,    35,     0,    36,
       0,    -2,     6,     7,     8,     9,    10,    11,    12,    13,
      14,     0,     0,     0,     0,     0,     0,     0,     0,    27,
      28,     0,     0,     0,    15,    16,     0,    17,    18,    29,
      30,    19,    20,    21,     0,     0,    31,    32,     0,     0,
       0,     0,    22,     0,     0,     0,    23,    24,     0,     0,
       0,    25,    26,     0,     0,     0,    33,     0,    34,    35,
       0,    36,   277,     0,     6,     7,     8,     9,    10,    11,
      12,    13,    14,     0,     0,     0,     0,     0,     0,     0,
       0,    27,    28,     0,     0,     0,    15,    16,     0,    17,
      18,    29,    30,    19,    20,    21,     0,     0,    31,    32,
       0,     0,     0,     0,    22,     0,     0,     0,    23,    24,
       0,     0,     0,    25,    26,     0,     0,     0,    33,     0,
      34,    35,     0,    36,   337,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    27,    28,     0,     0,     0,     0,     0,
       0,     0,     0,    29,    30,     0,     0,     0,     0,     0,
      31,    32,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      33,     0,    34,    35,     0,    36,   396,     6,     7,     8,
       9,    10,    11,    12,    13,    63,     0,     0,     0,     0,
       0,    64,     0,    65,    66,     0,    67,     0,     0,    15,
      16,    68,    17,    18,     0,     0,    19,    20,    21,     0,
       0,     0,     0,     0,     0,    69,    70,    22,    71,     0,
      72,    23,    24,    73,    74,    75,    25,    26,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     6,
       7,     8,     9,    10,    11,    12,    13,    63,     0,     0,
       0,     0,     0,     0,     0,     0,    27,    28,     0,     0,
       0,    15,    16,    68,    17,    18,    29,    30,    19,    20,
      21,     0,     0,    31,    32,     0,     0,     0,     0,    22,
       0,     0,     0,    23,    24,     0,   450,     0,    25,    26,
       0,     0,    76,    33,     0,    34,    35,     0,    36,     0,
       0,     6,     7,     8,     9,    10,    11,    12,    13,    14,
       0,     0,     0,     0,     0,     0,     0,     0,    27,    28,
       0,     0,     0,    15,    16,     0,    17,    18,    29,    30,
      19,    20,    21,     0,     0,    31,    32,     0,     0,     0,
       0,    22,     0,     0,     0,    23,    24,     0,     0,     0,
      25,    26,     0,     0,     0,    33,     0,    34,    35,     0,
      36,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      27,    28,     0,     0,     0,     0,     0,     0,     0,     0,
      29,    30,     0,     0,   110,     0,     0,    31,    32,     0,
       0,     6,     7,     8,     9,    10,    11,    12,    13,    14,
       0,     0,     0,     0,     0,     0,     0,    33,     0,    34,
      35,     0,    36,    15,    16,     0,    17,    18,     0,     0,
      19,    20,    21,     0,     0,     0,     0,     0,     0,     0,
       0,    22,     0,     0,     0,    23,    24,     0,     0,     0,
      25,    26,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     6,     7,     8,     9,    10,    11,    12,
      13,    14,     0,     0,     0,     0,     0,     0,     0,     0,
      27,    28,     0,     0,     0,    15,    16,     0,    17,    18,
      29,    30,    19,    20,    21,     0,     0,    31,    32,     0,
       0,     0,     0,    22,     0,     0,     0,    23,    24,     0,
       0,     0,    25,    26,     0,     0,   181,    33,     0,    34,
      35,     0,    36,     0,     0,     6,     7,     8,     9,    10,
      11,    12,    13,    14,     0,     0,     0,     0,     0,     0,
       0,     0,    27,    28,     0,     0,     0,    15,    16,     0,
      17,    18,    29,    30,    19,    20,    21,     0,     0,    31,
      32,     0,     0,     0,     0,    22,     0,     0,     0,    23,
      24,     0,     0,     0,    25,    26,     0,     0,   185,    33,
       0,    34,    35,     0,    36,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    27,    28,     0,     0,     0,     0,
       0,     0,     0,     0,    29,    30,     0,     0,     0,     0,
       0,    31,    32,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   269,     0,     0,     0,     0,     0,     0,     0,
       0,    33,     0,    34,    35,     0,    36,     6,     7,     8,
       9,    10,    11,    12,    13,    14,     0,     0,     0,     6,
       7,     8,     9,    10,    11,    12,    13,    14,     0,    15,
      16,     0,    17,    18,     0,     0,    19,    20,    21,     0,
       0,    15,    16,     0,    17,    18,     0,    22,    19,    20,
      21,    23,    24,     0,     0,     0,    25,    26,     0,    22,
       0,     0,     0,    23,    24,     0,     0,     0,    25,    26,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    27,    28,     0,     0,
       0,     0,     0,     0,     0,     0,    29,    30,    27,    28,
       0,     0,     0,    31,    32,     0,     0,     0,    29,    30,
       0,     0,     0,     0,     0,    31,    32,     0,     0,     0,
       0,     0,   -28,    33,     0,    34,    35,     0,    36,     0,
       0,     0,     0,     0,     0,    33,  -120,    34,    35,     0,
      36,     6,     7,     8,     9,    10,    11,    12,    13,    14,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    15,    16,     0,    17,    18,     0,     0,
      19,    20,    21,     0,     0,     0,     0,     0,     0,     0,
       0,    22,     0,     0,     0,    23,    24,     0,     0,     0,
      25,    26,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   115,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   116,     0,
      27,    28,     0,     0,     0,     0,     0,     0,     0,     0,
      29,    30,     0,     0,     0,     0,     0,    31,    32,     0,
       0,   115,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    33,     0,    34,
      35,     0,    36,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   115,     0,   139,   140,   141,
     142,     0,     0,   143,     0,     0,   144,     0,     0,   116,
       0,     0,     0,     0,   145,     0,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,     0,   532,   139,   140,   141,   142,     0,     0,
     143,     0,     0,   144,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   339,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   115,     0,   139,   140,
     141,   142,     0,     0,   143,     0,     0,   144,     0,     0,
     116,     0,     0,     0,     0,   145,   340,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   341,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   115,     0,   139,
     140,   141,   142,     0,     0,   143,     0,     0,   144,     0,
       0,   116,     0,     0,     0,     0,   145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   345,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   115,     0,
     139,   140,   141,   142,     0,     0,   143,     0,     0,   144,
       0,     0,   116,     0,     0,     0,     0,   145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   390,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   115,
       0,   139,   140,   141,   142,     0,     0,   143,     0,     0,
     144,     0,     0,   116,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   394,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     115,     0,   139,   140,   141,   142,     0,     0,   143,     0,
       0,   144,     0,     0,   116,     0,     0,     0,     0,   145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   436,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   115,     0,   139,   140,   141,   142,     0,     0,   143,
       0,     0,   144,     0,     0,   116,     0,     0,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   437,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   115,     0,   139,   140,   141,   142,     0,     0,
     143,     0,     0,   144,     0,     0,   116,     0,     0,     0,
       0,   145,   361,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   362,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   115,     0,   139,   140,   141,   142,     0,
       0,   143,     0,     0,   144,     0,     0,   116,     0,     0,
       0,     0,   145,     0,     0,     0,     0,     0,     0,     0,
     369,     0,     0,   370,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   115,     0,   139,   140,   141,   142,
       0,     0,   143,     0,     0,   144,     0,     0,   116,     0,
       0,     0,     0,   145,   424,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   425,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   115,     0,   139,   140,   141,
     142,     0,     0,   143,     0,     0,   144,     0,     0,   116,
       0,     0,     0,     0,   145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   226,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   115,     0,   139,   140,
     141,   142,     0,     0,   143,     0,     0,   144,     0,     0,
     116,     0,     0,     0,     0,   145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   317,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   115,     0,   139,
     140,   141,   142,     0,     0,   143,     0,     0,   144,     0,
       0,   116,     0,     0,     0,     0,   145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   320,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   115,     0,
     139,   140,   141,   142,     0,     0,   143,     0,     0,   144,
       0,     0,   116,     0,     0,     0,     0,   145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   363,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   115,
       0,   139,   140,   141,   142,     0,     0,   143,     0,     0,
     144,     0,     0,   116,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   364,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     115,     0,   139,   140,   141,   142,     0,     0,   143,     0,
       0,   144,     0,     0,   116,     0,     0,     0,     0,   145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     391,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,   115,     0,   139,   140,   141,   142,     0,     0,   143,
       0,     0,   144,     0,     0,   116,     0,     0,     0,     0,
     145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   426,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     117,   118,   119,   120,   121,   122,   123,   124,   125,   126,
     127,   128,   129,   130,   131,   132,   133,   134,   135,   136,
     137,   138,   115,     0,   139,   140,   141,   142,     0,     0,
     143,     0,     0,   144,     0,     0,   116,     0,     0,     0,
       0,   145,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   454,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   117,   118,   119,   120,   121,   122,   123,   124,   125,
     126,   127,   128,   129,   130,   131,   132,   133,   134,   135,
     136,   137,   138,   115,     0,   139,   140,   141,   142,     0,
       0,   143,     0,     0,   144,     0,     0,   116,     0,     0,
       0,     0,   145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   503,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   115,     0,   139,   140,   141,   142,
       0,     0,   143,     0,     0,   144,     0,     0,   116,     0,
       0,     0,     0,   145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   518,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,   115,     0,   139,   140,   141,
     142,     0,     0,   143,     0,     0,   144,     0,     0,   116,
       0,     0,     0,     0,   145,     0,     0,     0,     0,     0,
       0,     0,     0,   298,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   117,   118,   119,   120,   121,   122,
     123,   124,   125,   126,   127,   128,   129,   130,   131,   132,
     133,   134,   135,   136,   137,   138,   115,     0,   139,   140,
     141,   142,     0,     0,   143,     0,     0,   144,     0,     0,
     116,     0,     0,     0,     0,   145,     0,     0,     0,     0,
       0,     0,     0,     0,   301,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   117,   118,   119,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   115,     0,   139,
     140,   141,   142,     0,     0,   143,     0,     0,   144,     0,
       0,   116,     0,     0,     0,     0,   145,     0,     0,     0,
       0,     0,     0,     0,     0,   302,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   115,     0,
     139,   140,   141,   142,     0,     0,   143,     0,     0,   144,
       0,     0,   116,     0,     0,     0,     0,   145,     0,     0,
       0,     0,     0,     0,     0,     0,   419,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   117,   118,   119,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   115,
       0,   139,   140,   141,   142,     0,     0,   143,     0,     0,
     144,     0,     0,   116,     0,     0,     0,     0,   145,     0,
       0,     0,     0,     0,     0,     0,   146,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   117,   118,
     119,   120,   121,   122,   123,   124,   125,   126,   127,   128,
     129,   130,   131,   132,   133,   134,   135,   136,   137,   138,
     115,     0,   139,   140,   141,   142,     0,     0,   143,     0,
       0,   144,     0,     0,   116,     0,     0,     0,     0,   145,
       0,     0,     0,     0,     0,     0,     0,   319,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   115,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   116,     0,   117,
     118,   119,   120,   121,   122,   123,   124,   125,   126,   127,
     128,   129,   130,   131,   132,   133,   134,   135,   136,   137,
     138,     0,     0,   139,   140,   141,   142,     0,     0,   143,
       0,     0,   144,     0,     0,     0,     0,     0,     0,     0,
     145,   334,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   115,     0,   139,   140,   141,   142,
       0,     0,   143,     0,     0,   144,     0,     0,   116,     0,
       0,     0,     0,   145,   346,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   115,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   116,     0,   117,   118,   119,   120,   121,   122,   123,
     124,   125,   126,   127,   128,   129,   130,   131,   132,   133,
     134,   135,   136,   137,   138,     0,   115,   139,   140,   141,
     142,     0,     0,   143,     0,     0,   144,     0,     0,     0,
     116,     0,     0,     0,   145,   533,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   115,     0,
     139,   140,   141,   142,     0,     0,   143,     0,     0,   144,
       0,     0,   116,     0,     0,   117,   118,   145,   120,   121,
     122,   123,   124,   125,   126,   127,   128,   129,   130,   131,
     132,   133,   134,   135,   136,   137,   138,   115,     0,   139,
     140,   141,   142,     0,     0,   143,     0,     0,   144,     0,
       0,   116,     0,     0,     0,     0,   145,     0,   118,     0,
     120,   121,   122,   123,   124,   125,   126,   127,   128,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,     0,
       0,   139,   140,   141,   142,     0,     0,   143,     0,     0,
     144,     0,     0,     0,     0,     0,     0,     0,     0,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,     0,     0,
     139,   140,   141,   142,     0,     0,   143,     0,     0,   144,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     148,   149,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   206,     0,     0,     0,     0,     0,
       0,     0,     0,   150,     0,     0,     0,   151,   152,     0,
       0,     0,   207
};

static const yytype_int16 yycheck[] =
{
       1,     3,     4,   179,    19,   107,    74,     0,    51,    90,
      91,   106,     8,     3,     4,   275,    90,    91,   497,   416,
     280,     7,     8,   125,    21,   109,   225,     6,    29,    30,
       7,    33,    33,   128,   513,    36,    32,    33,    34,   120,
     124,    42,   110,   124,   110,    19,   119,    43,    45,     8,
     124,    47,    48,   110,   119,     2,   110,     8,   124,   117,
     128,    35,   120,    37,    38,    39,    40,   124,    69,    71,
     124,    72,    73,    32,    33,    34,   473,   119,   475,   119,
      54,    32,    33,    34,    43,   119,    88,   361,    47,    48,
       3,     4,    43,   126,    84,   119,    47,    48,    99,   100,
     101,     3,     4,   119,   119,     3,     4,   306,   284,   120,
     106,   117,   114,   124,   120,   116,   117,   118,   119,   120,
     121,   122,   123,   124,   125,   126,   127,   128,   129,   130,
     131,   132,   133,   134,   135,   136,   137,   138,   124,    86,
     119,   118,     3,   144,   145,   117,   119,   106,   120,   150,
     424,   152,   153,   127,   118,   156,   157,   158,    71,   160,
     101,   120,   117,   119,   118,     9,   119,   114,   119,    71,
     126,   445,   118,    71,   175,    88,   177,   178,   221,   180,
       9,    96,    97,   119,   117,   117,    88,   188,   120,   110,
      88,   124,   193,   194,     9,     8,   117,   373,   118,   120,
     117,   114,   128,   120,   119,   119,   207,   208,   123,   124,
      71,   117,   114,   118,   120,   119,   114,     8,   128,    32,
      33,    34,   117,     6,   225,   120,   118,   228,   229,   120,
      43,   233,     3,     4,    47,    48,     7,     8,   124,   415,
     117,    32,    33,    34,    88,    89,     3,     4,    92,    93,
      94,    95,    43,   114,    98,   119,    47,    48,    98,   260,
      89,     7,     8,    92,    93,    94,    95,     9,   269,    98,
       6,     7,    19,    79,    14,   117,   118,    92,    93,    94,
      95,    21,   128,    98,   117,   286,   233,   288,    35,   128,
      37,    38,    39,    40,   295,    14,    15,   117,   299,    96,
      97,   113,   114,   115,   116,   306,   119,    54,    14,   128,
     311,     6,   117,   110,   315,    21,   102,   103,   319,   118,
     233,   497,   119,    63,   118,     7,   123,   124,   119,   110,
     119,   233,   124,   334,   335,   233,    14,   513,   339,   340,
     128,   342,   343,    21,   128,   346,   347,    37,    38,    39,
      92,    93,    94,    95,     7,     8,    98,    63,    98,    99,
     361,   363,   364,   103,   365,   117,   117,   128,   369,    23,
     120,   372,   233,    35,   375,    37,    38,    39,    40,    32,
      33,    34,     8,   117,   127,    63,    13,   300,   118,   118,
      43,    79,    98,    79,    47,    48,   106,   103,    14,   120,
     117,   141,   142,   128,   120,    21,    32,    33,    34,   117,
      18,    24,   119,   128,   416,   118,   417,    43,   120,   120,
      98,    47,    48,   424,   467,   103,   126,    24,    79,   127,
     119,   118,    90,    19,   435,   141,   142,   118,    88,     3,
     375,   417,   335,   343,   445,   446,   448,    63,   324,   229,
     363,   364,   360,   421,   432,   444,   322,   441,   296,   460,
     498,   363,   364,   141,   142,   363,   364,   498,   285,   287,
     475,   473,   474,   475,    33,   388,   209,    -1,   289,    -1,
      -1,   483,    98,   484,    -1,    -1,    -1,   103,    -1,    -1,
      -1,    -1,    -1,   495,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   503,   363,   364,   505,    -1,    -1,   420,    -1,    -1,
      -1,    -1,    -1,    -1,   416,    -1,    -1,    -1,   416,    -1,
      -1,    -1,   523,   524,   525,   141,   142,    -1,    -1,   530,
      -1,   532,   533,    -1,   535,   448,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   284,   492,   448,    -1,    -1,    -1,
     448,   498,    -1,    -1,    56,    57,    58,    -1,    -1,    -1,
      62,   474,    -1,   476,    -1,   478,    -1,    -1,    -1,    -1,
     483,   473,   474,   475,    -1,   473,   474,   475,   284,    -1,
      -1,   483,   495,   323,    -1,   483,    -1,   448,    -1,    -1,
     503,    -1,    -1,   495,    -1,    -1,    -1,   495,    -1,    -1,
      -1,   503,    -1,    -1,    -1,   503,   284,    -1,    -1,   349,
      -1,    -1,    -1,   474,    -1,    -1,    -1,   323,    -1,    -1,
     360,    -1,   483,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   495,    -1,    -1,    -1,    -1,    -1,
      -1,   381,   503,   349,    -1,   323,   148,   149,    -1,   151,
      -1,   153,    -1,    -1,   360,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   405,    -1,    -1,   284,    -1,
      -1,   349,    -1,    -1,    -1,   381,    -1,    -1,    -1,    -1,
      -1,   421,   360,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   431,   432,    -1,    -1,    -1,    -1,    -1,    -1,   405,
     440,   441,    -1,   381,   444,    -1,    -1,   323,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   421,    -1,     9,    -1,   221,
      -1,    -1,    -1,    -1,    -1,   431,   432,   405,    -1,    -1,
      -1,    -1,    -1,   349,   440,   441,    -1,    -1,   444,    -1,
      -1,    -1,    -1,   421,   360,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   431,   432,    -1,    -1,   497,    -1,    -1,
      -1,    -1,   440,   441,    -1,   381,   444,    -1,    -1,    -1,
      -1,    -1,    -1,   513,    -1,     9,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   285,    -1,   287,    -1,   289,    -1,   405,
      -1,   497,    84,    85,    86,    87,    88,    89,    -1,    -1,
      92,    93,    94,    95,    -1,   421,    98,   513,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   431,   432,    -1,    -1,   497,
      -1,    -1,    -1,    -1,   440,   441,    -1,    -1,   444,    -1,
      -1,    -1,    -1,    -1,    -1,   513,    -1,    -1,    -1,    -1,
      -1,   343,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,    -1,    -1,    92,    93,
      94,    95,     9,    -1,    98,    -1,    -1,     0,    -1,    -1,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    -1,
      -1,   497,    -1,    -1,    17,   387,    19,    20,    -1,    22,
      -1,    -1,    25,    26,    27,    28,    29,   513,    -1,    32,
      33,    34,    35,    -1,    37,    38,    39,    40,    41,    42,
      43,    44,    -1,    46,    47,    48,    49,    50,    51,    52,
      53,    -1,    55,    -1,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,    -1,    -1,    92,    93,    94,    95,    82,
      83,    98,    -1,    -1,   101,    -1,    -1,    -1,    -1,    92,
      93,    -1,    -1,    -1,    -1,    -1,    99,   100,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   118,   119,     9,   121,   122,
      -1,   124,     0,    -1,    -1,     3,     4,     5,     6,     7,
       8,     9,    10,    11,   506,    -1,    -1,    -1,    -1,    17,
      -1,    19,    20,    -1,    22,   517,    -1,    25,    26,    27,
      28,    29,    -1,    -1,    32,    33,    34,    35,    -1,    37,
      38,    39,    40,    41,    42,    43,    44,    -1,    46,    47,
      48,    49,    50,    51,    52,    53,    -1,    55,    -1,    -1,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    -1,
      92,    93,    94,    95,    82,    83,    98,    -1,    -1,   101,
      -1,    -1,    -1,    -1,    92,    93,    -1,    -1,    -1,    -1,
       9,    99,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,     3,     4,     5,     6,     7,     8,     9,    10,    11,
     118,   119,    -1,   121,   122,    17,   124,    19,    20,    -1,
      22,    -1,    -1,    25,    26,    27,    28,    29,    -1,    -1,
      32,    33,    34,    35,    -1,    37,    38,    39,    40,    41,
      42,    43,    44,    -1,    46,    47,    48,    49,    50,    51,
      52,    53,    -1,    -1,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    -1,    92,    93,    94,    95,    -1,    -1,    98,
      82,    83,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      92,    93,    -1,    -1,    -1,    -1,    -1,    99,   100,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,     5,
       6,     7,     8,     9,    10,    11,   118,   119,    -1,   121,
     122,    17,   124,    19,    20,   127,    22,    -1,    -1,    25,
      26,    27,    28,    29,    -1,    -1,    32,    33,    34,    35,
      -1,    37,    38,    39,    40,    41,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    52,    53,    -1,    -1,
      -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    82,    83,    -1,    -1,
      -1,    25,    26,    -1,    28,    29,    92,    93,    32,    33,
      34,    -1,    -1,    99,   100,    -1,    -1,    -1,    -1,    43,
      -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,   118,   119,    -1,   121,   122,    -1,   124,    -1,
      -1,   127,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,    -1,    92,    93,    94,    95,    82,    83,
      98,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    92,    93,
      -1,    -1,    -1,    -1,    -1,    99,   100,    -1,    -1,    -1,
      -1,    -1,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,   119,    -1,   121,   122,    -1,
     124,    -1,    -1,   127,    25,    26,    27,    28,    29,    -1,
      -1,    32,    33,    34,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    43,    -1,    -1,    -1,    47,    48,    -1,    50,
      -1,    52,    53,     9,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    82,    83,    -1,    -1,    -1,    25,    26,    -1,    28,
      29,    92,    93,    32,    33,    34,    -1,    -1,    99,   100,
      -1,    -1,    -1,    -1,    43,    -1,    -1,    -1,    47,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,   119,    -1,
     121,   122,    -1,   124,    -1,   126,    82,    83,    84,    85,
      86,    87,    88,    89,    -1,    -1,    92,    93,    94,    95,
      -1,    -1,    98,    82,    83,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    92,    93,    -1,    -1,    96,    -1,    -1,
      99,   100,    -1,    -1,    -1,    -1,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,
     119,    -1,   121,   122,    -1,   124,    -1,   126,    25,    26,
      -1,    28,    29,    -1,    -1,    32,    33,    34,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    43,    -1,    -1,    -1,
      47,    48,    -1,    -1,    -1,    52,    53,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    82,    83,    -1,    -1,    -1,
      25,    26,    -1,    28,    29,    92,    93,    32,    33,    34,
      -1,    -1,    99,   100,    -1,    -1,    -1,    -1,    43,    -1,
      -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,    -1,
      -1,    -1,   119,    -1,   121,   122,    -1,   124,    -1,   126,
       3,     4,     5,     6,     7,     8,     9,    10,    11,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    82,    83,    -1,
      -1,    -1,    25,    26,    -1,    28,    29,    92,    93,    32,
      33,    34,    -1,    -1,    99,   100,    -1,    -1,    -1,    -1,
      43,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,
      53,    -1,    -1,    -1,   119,    -1,   121,   122,    -1,   124,
      -1,   126,     3,     4,     5,     6,     7,     8,     9,    10,
      11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    82,
      83,    -1,    -1,    -1,    25,    26,    -1,    28,    29,    92,
      93,    32,    33,    34,    -1,    -1,    99,   100,    -1,    -1,
      -1,    -1,    43,    -1,    -1,    -1,    47,    48,    -1,    -1,
      -1,    52,    53,    -1,    -1,    -1,   119,    -1,   121,   122,
      -1,   124,   125,    -1,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    82,    83,    -1,    -1,    -1,    25,    26,    -1,    28,
      29,    92,    93,    32,    33,    34,    -1,    -1,    99,   100,
      -1,    -1,    -1,    -1,    43,    -1,    -1,    -1,    47,    48,
      -1,    -1,    -1,    52,    53,    -1,    -1,    -1,   119,    -1,
     121,   122,    -1,   124,   125,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    82,    83,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    92,    93,    -1,    -1,    -1,    -1,    -1,
      99,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     119,    -1,   121,   122,    -1,   124,   125,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    -1,    -1,    -1,    -1,
      -1,    17,    -1,    19,    20,    -1,    22,    -1,    -1,    25,
      26,    27,    28,    29,    -1,    -1,    32,    33,    34,    -1,
      -1,    -1,    -1,    -1,    -1,    41,    42,    43,    44,    -1,
      46,    47,    48,    49,    50,    51,    52,    53,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    82,    83,    -1,    -1,
      -1,    25,    26,    27,    28,    29,    92,    93,    32,    33,
      34,    -1,    -1,    99,   100,    -1,    -1,    -1,    -1,    43,
      -1,    -1,    -1,    47,    48,    -1,    50,    -1,    52,    53,
      -1,    -1,   118,   119,    -1,   121,   122,    -1,   124,    -1,
      -1,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    82,    83,
      -1,    -1,    -1,    25,    26,    -1,    28,    29,    92,    93,
      32,    33,    34,    -1,    -1,    99,   100,    -1,    -1,    -1,
      -1,    43,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,   119,    -1,   121,   122,    -1,
     124,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      92,    93,    -1,    -1,    96,    -1,    -1,    99,   100,    -1,
      -1,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,   121,
     122,    -1,   124,    25,    26,    -1,    28,    29,    -1,    -1,
      32,    33,    34,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    43,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      82,    83,    -1,    -1,    -1,    25,    26,    -1,    28,    29,
      92,    93,    32,    33,    34,    -1,    -1,    99,   100,    -1,
      -1,    -1,    -1,    43,    -1,    -1,    -1,    47,    48,    -1,
      -1,    -1,    52,    53,    -1,    -1,   118,   119,    -1,   121,
     122,    -1,   124,    -1,    -1,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    82,    83,    -1,    -1,    -1,    25,    26,    -1,
      28,    29,    92,    93,    32,    33,    34,    -1,    -1,    99,
     100,    -1,    -1,    -1,    -1,    43,    -1,    -1,    -1,    47,
      48,    -1,    -1,    -1,    52,    53,    -1,    -1,   118,   119,
      -1,   121,   122,    -1,   124,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    82,    83,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    92,    93,    -1,    -1,    -1,    -1,
      -1,    99,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   119,    -1,   121,   122,    -1,   124,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    -1,    -1,    -1,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    -1,    25,
      26,    -1,    28,    29,    -1,    -1,    32,    33,    34,    -1,
      -1,    25,    26,    -1,    28,    29,    -1,    43,    32,    33,
      34,    47,    48,    -1,    -1,    -1,    52,    53,    -1,    43,
      -1,    -1,    -1,    47,    48,    -1,    -1,    -1,    52,    53,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    82,    83,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    92,    93,    82,    83,
      -1,    -1,    -1,    99,   100,    -1,    -1,    -1,    92,    93,
      -1,    -1,    -1,    -1,    -1,    99,   100,    -1,    -1,    -1,
      -1,    -1,   118,   119,    -1,   121,   122,    -1,   124,    -1,
      -1,    -1,    -1,    -1,    -1,   119,   120,   121,   122,    -1,
     124,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    25,    26,    -1,    28,    29,    -1,    -1,
      32,    33,    34,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    43,    -1,    -1,    -1,    47,    48,    -1,    -1,    -1,
      52,    53,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    23,    -1,
      82,    83,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      92,    93,    -1,    -1,    -1,    -1,    -1,    99,   100,    -1,
      -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   119,    -1,   121,
     122,    -1,   124,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,     9,    -1,    92,    93,    94,
      95,    -1,    -1,    98,    -1,    -1,   101,    -1,    -1,    23,
      -1,    -1,    -1,    -1,   109,    -1,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,    -1,   128,    92,    93,    94,    95,    -1,    -1,
      98,    -1,    -1,   101,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,     9,    -1,    92,    93,
      94,    95,    -1,    -1,    98,    -1,    -1,   101,    -1,    -1,
      23,    -1,    -1,    -1,    -1,   109,   110,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   125,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,     9,    -1,    92,
      93,    94,    95,    -1,    -1,    98,    -1,    -1,   101,    -1,
      -1,    23,    -1,    -1,    -1,    -1,   109,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   125,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,     9,    -1,
      92,    93,    94,    95,    -1,    -1,    98,    -1,    -1,   101,
      -1,    -1,    23,    -1,    -1,    -1,    -1,   109,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   125,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,     9,
      -1,    92,    93,    94,    95,    -1,    -1,    98,    -1,    -1,
     101,    -1,    -1,    23,    -1,    -1,    -1,    -1,   109,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   125,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
       9,    -1,    92,    93,    94,    95,    -1,    -1,    98,    -1,
      -1,   101,    -1,    -1,    23,    -1,    -1,    -1,    -1,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   125,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,     9,    -1,    92,    93,    94,    95,    -1,    -1,    98,
      -1,    -1,   101,    -1,    -1,    23,    -1,    -1,    -1,    -1,
     109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   125,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,     9,    -1,    92,    93,    94,    95,    -1,    -1,
      98,    -1,    -1,   101,    -1,    -1,    23,    -1,    -1,    -1,
      -1,   109,   110,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,     9,    -1,    92,    93,    94,    95,    -1,
      -1,    98,    -1,    -1,   101,    -1,    -1,    23,    -1,    -1,
      -1,    -1,   109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     117,    -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,     9,    -1,    92,    93,    94,    95,
      -1,    -1,    98,    -1,    -1,   101,    -1,    -1,    23,    -1,
      -1,    -1,    -1,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,     9,    -1,    92,    93,    94,
      95,    -1,    -1,    98,    -1,    -1,   101,    -1,    -1,    23,
      -1,    -1,    -1,    -1,   109,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,     9,    -1,    92,    93,
      94,    95,    -1,    -1,    98,    -1,    -1,   101,    -1,    -1,
      23,    -1,    -1,    -1,    -1,   109,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,     9,    -1,    92,
      93,    94,    95,    -1,    -1,    98,    -1,    -1,   101,    -1,
      -1,    23,    -1,    -1,    -1,    -1,   109,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,     9,    -1,
      92,    93,    94,    95,    -1,    -1,    98,    -1,    -1,   101,
      -1,    -1,    23,    -1,    -1,    -1,    -1,   109,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,     9,
      -1,    92,    93,    94,    95,    -1,    -1,    98,    -1,    -1,
     101,    -1,    -1,    23,    -1,    -1,    -1,    -1,   109,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   120,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
       9,    -1,    92,    93,    94,    95,    -1,    -1,    98,    -1,
      -1,   101,    -1,    -1,    23,    -1,    -1,    -1,    -1,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,     9,    -1,    92,    93,    94,    95,    -1,    -1,    98,
      -1,    -1,   101,    -1,    -1,    23,    -1,    -1,    -1,    -1,
     109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    89,     9,    -1,    92,    93,    94,    95,    -1,    -1,
      98,    -1,    -1,   101,    -1,    -1,    23,    -1,    -1,    -1,
      -1,   109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    68,    69,    70,    71,    72,    73,    74,    75,    76,
      77,    78,    79,    80,    81,    82,    83,    84,    85,    86,
      87,    88,    89,     9,    -1,    92,    93,    94,    95,    -1,
      -1,    98,    -1,    -1,   101,    -1,    -1,    23,    -1,    -1,
      -1,    -1,   109,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,     9,    -1,    92,    93,    94,    95,
      -1,    -1,    98,    -1,    -1,   101,    -1,    -1,    23,    -1,
      -1,    -1,    -1,   109,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   120,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,     9,    -1,    92,    93,    94,
      95,    -1,    -1,    98,    -1,    -1,   101,    -1,    -1,    23,
      -1,    -1,    -1,    -1,   109,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    82,    83,
      84,    85,    86,    87,    88,    89,     9,    -1,    92,    93,
      94,    95,    -1,    -1,    98,    -1,    -1,   101,    -1,    -1,
      23,    -1,    -1,    -1,    -1,   109,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,     9,    -1,    92,
      93,    94,    95,    -1,    -1,    98,    -1,    -1,   101,    -1,
      -1,    23,    -1,    -1,    -1,    -1,   109,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,     9,    -1,
      92,    93,    94,    95,    -1,    -1,    98,    -1,    -1,   101,
      -1,    -1,    23,    -1,    -1,    -1,    -1,   109,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   118,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,     9,
      -1,    92,    93,    94,    95,    -1,    -1,    98,    -1,    -1,
     101,    -1,    -1,    23,    -1,    -1,    -1,    -1,   109,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    82,    83,    84,    85,    86,    87,    88,    89,
       9,    -1,    92,    93,    94,    95,    -1,    -1,    98,    -1,
      -1,   101,    -1,    -1,    23,    -1,    -1,    -1,    -1,   109,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   117,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    23,    -1,    68,
      69,    70,    71,    72,    73,    74,    75,    76,    77,    78,
      79,    80,    81,    82,    83,    84,    85,    86,    87,    88,
      89,    -1,    -1,    92,    93,    94,    95,    -1,    -1,    98,
      -1,    -1,   101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     109,   110,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    82,    83,    84,    85,
      86,    87,    88,    89,     9,    -1,    92,    93,    94,    95,
      -1,    -1,    98,    -1,    -1,   101,    -1,    -1,    23,    -1,
      -1,    -1,    -1,   109,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,     9,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    23,    -1,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    -1,     9,    92,    93,    94,
      95,    -1,    -1,    98,    -1,    -1,   101,    -1,    -1,    -1,
      23,    -1,    -1,    -1,   109,   110,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,     9,    -1,
      92,    93,    94,    95,    -1,    -1,    98,    -1,    -1,   101,
      -1,    -1,    23,    -1,    -1,    68,    69,   109,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,    81,    82,
      83,    84,    85,    86,    87,    88,    89,     9,    -1,    92,
      93,    94,    95,    -1,    -1,    98,    -1,    -1,   101,    -1,
      -1,    23,    -1,    -1,    -1,    -1,   109,    -1,    69,    -1,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    -1,
      -1,    92,    93,    94,    95,    -1,    -1,    98,    -1,    -1,
     101,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    -1,    -1,
      92,    93,    94,    95,    -1,    -1,    98,    -1,    -1,   101,
      56,    57,    58,    59,    60,    61,    62,    63,    64,    65,
      66,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      96,    97,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   110,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   119,    -1,    -1,    -1,   123,   124,    -1,
      -1,    -1,   128
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,   113,   114,   115,   116,   131,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    25,    26,    28,    29,    32,
      33,    34,    43,    47,    48,    52,    53,    82,    83,    92,
      93,    99,   100,   119,   121,   122,   124,   130,   136,   140,
     141,   143,   144,   145,   147,   155,   164,   165,   166,   167,
     168,   170,   172,   173,   202,    35,    37,    38,    39,    40,
     192,   193,   195,    11,    17,    19,    20,    22,    27,    41,
      42,    44,    46,    49,    50,    51,   118,   135,   140,   141,
     143,   145,   202,   206,   207,   210,    55,   132,   133,   134,
     135,   193,   207,     0,   164,   165,   166,   173,   119,   119,
     119,   119,   166,   146,   119,   140,   140,   140,   145,   210,
      96,   140,   156,   157,   126,     9,    23,    68,    69,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    88,    89,    92,
      93,    94,    95,    98,   101,   109,   117,   140,    96,    97,
     119,   123,   124,   126,    90,    91,   124,   142,   119,   136,
     101,     7,     8,   137,   198,   199,   137,   196,   197,   137,
     200,   201,   118,   117,   137,   119,   118,   119,   119,   119,
     119,   118,   140,   118,   207,   118,   140,   140,     6,   119,
       6,     7,   118,   128,   128,    56,    57,    58,    59,    60,
      61,    62,    63,    64,    65,    66,   110,   128,   204,   211,
     212,   118,   118,   193,   134,   110,   166,   140,   166,   140,
     140,   117,   119,   159,   166,     6,   120,   120,   124,   117,
     152,   127,   193,   203,   207,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   166,   166,
     119,   140,   140,   137,   137,   140,   148,   149,   137,   110,
     140,     7,     8,   137,   140,   153,   154,   125,   140,   140,
     138,   140,    79,   140,   128,   117,   128,   117,   128,   117,
     194,   140,   140,   140,     7,   118,   130,   140,   118,    21,
      45,   118,   118,   140,   150,   151,     6,   118,   118,   140,
     140,     7,   140,   140,   212,   119,   120,   120,   120,   117,
     120,   136,   137,   158,   110,   150,   140,   157,   107,   125,
     127,   193,   207,   140,   110,   117,   120,   125,   140,    67,
     110,   125,   128,   117,   152,   125,   110,   117,   152,   119,
     130,   163,   166,   174,   177,   199,   140,   197,   140,   201,
     128,   110,   120,   120,   120,    23,   139,   140,   192,   117,
     120,   140,    19,   119,   202,   117,   118,   150,   140,   140,
     140,   117,   171,   171,   137,   160,   161,   166,   158,   120,
     125,   120,   140,   149,   125,   140,   125,   140,   140,   154,
     127,   140,   140,   120,   106,   120,   166,   175,   176,    13,
     180,   159,   138,   207,   207,   140,   118,   118,   140,   118,
     140,   130,   151,   120,   110,   120,   120,   166,    79,    79,
     106,   120,   117,   137,   202,   128,   125,   125,   166,   109,
     120,   117,    14,    15,   179,   110,   117,   120,    18,   130,
      50,   205,   206,   139,   120,   202,   161,   138,   166,   160,
     128,   162,   140,   166,   175,   166,   169,   170,   181,   138,
     207,   208,   209,   117,   120,   118,   120,   120,   110,   140,
      84,   126,   120,   120,    24,   206,   207,   205,   202,   202,
      79,   127,   178,   207,   140,   120,    19,    54,   182,   184,
     185,   190,   193,   120,   207,   119,   163,   127,   184,   185,
     193,   102,   103,   183,   207,   140,   137,   163,   120,   118,
     137,   187,   186,    74,   110,   128,   189,   140,   140,   140,
      90,   188,   128,   110,   140,    19,   191,   140,   140,   140,
     118
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_uint8 yyr1[] =
{
       0,   129,   130,   131,   131,   131,   131,   131,   131,   131,
     131,   131,   132,   132,   133,   133,   134,   134,   134,   135,
     135,   136,   136,   137,   137,   138,   138,   138,   139,   139,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   140,   140,
     140,   140,   140,   140,   140,   140,   140,   140,   141,   142,
     142,   143,   143,   144,   144,   144,   144,   144,   144,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   145,   145,   145,   146,   145,   145,   145,
     145,   145,   145,   145,   145,   145,   145,   145,   145,   145,
     147,   148,   148,   148,   149,   150,   150,   150,   151,   152,
     152,   153,   153,   153,   154,   154,   155,   155,   156,   156,
     157,   157,   158,   159,   159,   160,   160,   161,   161,   162,
     162,   163,   163,   163,   164,   165,   166,   166,   166,   166,
     166,   166,   166,   167,   167,   167,   168,   169,   170,   170,
     171,   171,   172,   172,   173,   173,   174,   174,   175,   175,
     176,   176,   176,   177,   178,   177,   179,   179,   180,   180,
     181,   181,   181,   182,   182,   182,   182,   182,   182,   183,
     183,   183,   184,   186,   185,   187,   187,   188,   188,   189,
     189,   189,   189,   189,   189,   190,   190,   191,   191,   192,
     192,   192,   194,   193,   193,   195,   195,   196,   196,   197,
     198,   198,   199,   200,   200,   201,   202,   202,   203,   203,
     203,   203,   204,   204,   204,   204,   204,   204,   204,   204,
     204,   204,   204,   205,   205,   205,   206,   206,   206,   206,
     206,   206,   206,   206,   206,   206,   206,   206,   207,   207,
     207,   207,   207,   207,   207,   207,   208,   207,   209,   207,
     207,   207,   207,   207,   207,   207,   207,   207,   207,   207,
     207,   207,   207,   210,   211,   211,   212
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     3,     2,     3,     2,     3,     2,
       3,     2,     0,     1,     1,     2,     1,     2,     1,     3,
       3,     1,     1,     1,     1,     0,     1,     3,     0,     1,
       1,     2,     2,     5,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     5,     3,
       3,     1,     1,     2,     2,     2,     1,     1,     3,     1,
       1,     3,     5,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     1,     3,     3,     3,     4,     6,
       6,     4,     5,     5,     1,     3,     0,     3,     6,     8,
       5,     2,     2,     4,     4,     4,     6,     4,     5,     5,
       4,     0,     1,     3,     1,     0,     1,     3,     1,     0,
       1,     0,     1,     3,     1,     3,     4,     4,     1,     3,
       1,     6,     0,     7,     4,     1,     3,     3,     2,     0,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     3,     1,     1,
       0,     2,     6,     6,     3,     4,     4,     3,     1,     3,
       1,     2,     1,     6,     0,     8,     1,     1,     0,     1,
       0,     1,     1,     1,     1,     1,     2,     2,     2,     0,
       1,     1,     4,     0,     9,     0,     1,     0,     2,     0,
       2,     2,     4,     4,     2,     0,     4,     0,     2,     2,
       2,     2,     0,     5,     2,     1,     1,     1,     3,     3,
       1,     3,     3,     1,     3,     3,     3,     4,     1,     2,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     3,     3,     3,     3,     3,
       1,     5,     4,     6,     1,     4,     6,     8,     1,     1,
       2,     5,     7,     5,    10,     8,     0,     9,     0,    11,
       2,     2,     2,     3,     4,     6,     8,     5,     2,     3,
       3,     4,     1,     2,     1,     2,     3
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = PKL_TAB_EMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == PKL_TAB_EMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        YY_LAC_DISCARD ("YYBACKUP");                              \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, pkl_parser, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use PKL_TAB_error or PKL_TAB_UNDEF. */
#define YYERRCODE PKL_TAB_UNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if PKL_TAB_DEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined PKL_TAB_LTYPE_IS_TRIVIAL && PKL_TAB_LTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location, pkl_parser); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, struct pkl_parser *pkl_parser)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  YY_USE (pkl_parser);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, struct pkl_parser *pkl_parser)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, pkl_parser);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule, struct pkl_parser *pkl_parser)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]), pkl_parser);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, pkl_parser); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !PKL_TAB_DEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !PKL_TAB_DEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Given a state stack such that *YYBOTTOM is its bottom, such that
   *YYTOP is either its top or is YYTOP_EMPTY to indicate an empty
   stack, and such that *YYCAPACITY is the maximum number of elements it
   can hold without a reallocation, make sure there is enough room to
   store YYADD more elements.  If not, allocate a new stack using
   YYSTACK_ALLOC, copy the existing elements, and adjust *YYBOTTOM,
   *YYTOP, and *YYCAPACITY to reflect the new capacity and memory
   location.  If *YYBOTTOM != YYBOTTOM_NO_FREE, then free the old stack
   using YYSTACK_FREE.  Return 0 if successful or if no reallocation is
   required.  Return YYENOMEM if memory is exhausted.  */
static int
yy_lac_stack_realloc (YYPTRDIFF_T *yycapacity, YYPTRDIFF_T yyadd,
#if PKL_TAB_DEBUG
                      char const *yydebug_prefix,
                      char const *yydebug_suffix,
#endif
                      yy_state_t **yybottom,
                      yy_state_t *yybottom_no_free,
                      yy_state_t **yytop, yy_state_t *yytop_empty)
{
  YYPTRDIFF_T yysize_old =
    *yytop == yytop_empty ? 0 : *yytop - *yybottom + 1;
  YYPTRDIFF_T yysize_new = yysize_old + yyadd;
  if (*yycapacity < yysize_new)
    {
      YYPTRDIFF_T yyalloc = 2 * yysize_new;
      yy_state_t *yybottom_new;
      /* Use YYMAXDEPTH for maximum stack size given that the stack
         should never need to grow larger than the main state stack
         needs to grow without LAC.  */
      if (YYMAXDEPTH < yysize_new)
        {
          YYDPRINTF ((stderr, "%smax size exceeded%s", yydebug_prefix,
                      yydebug_suffix));
          return YYENOMEM;
        }
      if (YYMAXDEPTH < yyalloc)
        yyalloc = YYMAXDEPTH;
      yybottom_new =
        YY_CAST (yy_state_t *,
                 YYSTACK_ALLOC (YY_CAST (YYSIZE_T,
                                         yyalloc * YYSIZEOF (*yybottom_new))));
      if (!yybottom_new)
        {
          YYDPRINTF ((stderr, "%srealloc failed%s", yydebug_prefix,
                      yydebug_suffix));
          return YYENOMEM;
        }
      if (*yytop != yytop_empty)
        {
          YYCOPY (yybottom_new, *yybottom, yysize_old);
          *yytop = yybottom_new + (yysize_old - 1);
        }
      if (*yybottom != yybottom_no_free)
        YYSTACK_FREE (*yybottom);
      *yybottom = yybottom_new;
      *yycapacity = yyalloc;
    }
  return 0;
}

/* Establish the initial context for the current lookahead if no initial
   context is currently established.

   We define a context as a snapshot of the parser stacks.  We define
   the initial context for a lookahead as the context in which the
   parser initially examines that lookahead in order to select a
   syntactic action.  Thus, if the lookahead eventually proves
   syntactically unacceptable (possibly in a later context reached via a
   series of reductions), the initial context can be used to determine
   the exact set of tokens that would be syntactically acceptable in the
   lookahead's place.  Moreover, it is the context after which any
   further semantic actions would be erroneous because they would be
   determined by a syntactically unacceptable token.

   YY_LAC_ESTABLISH should be invoked when a reduction is about to be
   performed in an inconsistent state (which, for the purposes of LAC,
   includes consistent states that don't know they're consistent because
   their default reductions have been disabled).  Iff there is a
   lookahead token, it should also be invoked before reporting a syntax
   error.  This latter case is for the sake of the debugging output.

   For parse.lac=full, the implementation of YY_LAC_ESTABLISH is as
   follows.  If no initial context is currently established for the
   current lookahead, then check if that lookahead can eventually be
   shifted if syntactic actions continue from the current context.
   Report a syntax error if it cannot.  */
#define YY_LAC_ESTABLISH                                                \
do {                                                                    \
  if (!yy_lac_established)                                              \
    {                                                                   \
      YYDPRINTF ((stderr,                                               \
                  "LAC: initial context established for %s\n",          \
                  yysymbol_name (yytoken)));                            \
      yy_lac_established = 1;                                           \
      switch (yy_lac (yyesa, &yyes, &yyes_capacity, yyssp, yytoken))    \
        {                                                               \
        case YYENOMEM:                                                  \
          YYNOMEM;                                                      \
        case 1:                                                         \
          goto yyerrlab;                                                \
        }                                                               \
    }                                                                   \
} while (0)

/* Discard any previous initial lookahead context because of Event,
   which may be a lookahead change or an invalidation of the currently
   established initial context for the current lookahead.

   The most common example of a lookahead change is a shift.  An example
   of both cases is syntax error recovery.  That is, a syntax error
   occurs when the lookahead is syntactically erroneous for the
   currently established initial context, so error recovery manipulates
   the parser stacks to try to find a new initial context in which the
   current lookahead is syntactically acceptable.  If it fails to find
   such a context, it discards the lookahead.  */
#if PKL_TAB_DEBUG
# define YY_LAC_DISCARD(Event)                                           \
do {                                                                     \
  if (yy_lac_established)                                                \
    {                                                                    \
      YYDPRINTF ((stderr, "LAC: initial context discarded due to "       \
                  Event "\n"));                                          \
      yy_lac_established = 0;                                            \
    }                                                                    \
} while (0)
#else
# define YY_LAC_DISCARD(Event) yy_lac_established = 0
#endif

/* Given the stack whose top is *YYSSP, return 0 iff YYTOKEN can
   eventually (after perhaps some reductions) be shifted, return 1 if
   not, or return YYENOMEM if memory is exhausted.  As preconditions and
   postconditions: *YYES_CAPACITY is the allocated size of the array to
   which *YYES points, and either *YYES = YYESA or *YYES points to an
   array allocated with YYSTACK_ALLOC.  yy_lac may overwrite the
   contents of either array, alter *YYES and *YYES_CAPACITY, and free
   any old *YYES other than YYESA.  */
static int
yy_lac (yy_state_t *yyesa, yy_state_t **yyes,
        YYPTRDIFF_T *yyes_capacity, yy_state_t *yyssp, yysymbol_kind_t yytoken)
{
  yy_state_t *yyes_prev = yyssp;
  yy_state_t *yyesp = yyes_prev;
  /* Reduce until we encounter a shift and thereby accept the token.  */
  YYDPRINTF ((stderr, "LAC: checking lookahead %s:", yysymbol_name (yytoken)));
  if (yytoken == YYSYMBOL_YYUNDEF)
    {
      YYDPRINTF ((stderr, " Always Err\n"));
      return 1;
    }
  while (1)
    {
      int yyrule = yypact[+*yyesp];
      if (yypact_value_is_default (yyrule)
          || (yyrule += yytoken) < 0 || YYLAST < yyrule
          || yycheck[yyrule] != yytoken)
        {
          /* Use the default action.  */
          yyrule = yydefact[+*yyesp];
          if (yyrule == 0)
            {
              YYDPRINTF ((stderr, " Err\n"));
              return 1;
            }
        }
      else
        {
          /* Use the action from yytable.  */
          yyrule = yytable[yyrule];
          if (yytable_value_is_error (yyrule))
            {
              YYDPRINTF ((stderr, " Err\n"));
              return 1;
            }
          if (0 < yyrule)
            {
              YYDPRINTF ((stderr, " S%d\n", yyrule));
              return 0;
            }
          yyrule = -yyrule;
        }
      /* By now we know we have to simulate a reduce.  */
      YYDPRINTF ((stderr, " R%d", yyrule - 1));
      {
        /* Pop the corresponding number of values from the stack.  */
        YYPTRDIFF_T yylen = yyr2[yyrule];
        /* First pop from the LAC stack as many tokens as possible.  */
        if (yyesp != yyes_prev)
          {
            YYPTRDIFF_T yysize = yyesp - *yyes + 1;
            if (yylen < yysize)
              {
                yyesp -= yylen;
                yylen = 0;
              }
            else
              {
                yyesp = yyes_prev;
                yylen -= yysize;
              }
          }
        /* Only afterwards look at the main stack.  */
        if (yylen)
          yyesp = yyes_prev -= yylen;
      }
      /* Push the resulting state of the reduction.  */
      {
        yy_state_fast_t yystate;
        {
          const int yylhs = yyr1[yyrule] - YYNTOKENS;
          const int yyi = yypgoto[yylhs] + *yyesp;
          yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyesp
                     ? yytable[yyi]
                     : yydefgoto[yylhs]);
        }
        if (yyesp == yyes_prev)
          {
            yyesp = *yyes;
            YY_IGNORE_USELESS_CAST_BEGIN
            *yyesp = YY_CAST (yy_state_t, yystate);
            YY_IGNORE_USELESS_CAST_END
          }
        else
          {
            if (yy_lac_stack_realloc (yyes_capacity, 1,
#if PKL_TAB_DEBUG
                                      " (", ")",
#endif
                                      yyes, yyesa, &yyesp, yyes_prev))
              {
                YYDPRINTF ((stderr, "\n"));
                return YYENOMEM;
              }
            YY_IGNORE_USELESS_CAST_BEGIN
            *++yyesp = YY_CAST (yy_state_t, yystate);
            YY_IGNORE_USELESS_CAST_END
          }
        YYDPRINTF ((stderr, " G%d", yystate));
      }
    }
}

/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yy_state_t *yyesa;
  yy_state_t **yyes;
  YYPTRDIFF_T *yyes_capacity;
  yysymbol_kind_t yytoken;
  YYLTYPE *yylloc;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;

  int yyx;
  for (yyx = 0; yyx < YYNTOKENS; ++yyx)
    {
      yysymbol_kind_t yysym = YY_CAST (yysymbol_kind_t, yyx);
      if (yysym != YYSYMBOL_YYerror && yysym != YYSYMBOL_YYUNDEF)
        switch (yy_lac (yyctx->yyesa, yyctx->yyes, yyctx->yyes_capacity, yyctx->yyssp, yysym))
          {
          case YYENOMEM:
            return YYENOMEM;
          case 1:
            continue;
          default:
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = yysym;
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




/* The kind of the lookahead of this context.  */
static yysymbol_kind_t
yypcontext_token (const yypcontext_t *yyctx) YY_ATTRIBUTE_UNUSED;

static yysymbol_kind_t
yypcontext_token (const yypcontext_t *yyctx)
{
  return yyctx->yytoken;
}

/* The location of the lookahead of this context.  */
static YYLTYPE *
yypcontext_location (const yypcontext_t *yyctx) YY_ATTRIBUTE_UNUSED;

static YYLTYPE *
yypcontext_location (const yypcontext_t *yyctx)
{
  return yyctx->yylloc;
}

/* User defined function to report a syntax error.  */
static int
yyreport_syntax_error (const yypcontext_t *yyctx, struct pkl_parser *pkl_parser);

/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, struct pkl_parser *pkl_parser)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  YY_USE (pkl_parser);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_INTEGER: /* "integer literal"  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3128 "pkl-tab.c"
        break;

    case YYSYMBOL_CHAR: /* "character literal"  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3156 "pkl-tab.c"
        break;

    case YYSYMBOL_STR: /* "string"  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3184 "pkl-tab.c"
        break;

    case YYSYMBOL_IDENTIFIER: /* "identifier"  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3212 "pkl-tab.c"
        break;

    case YYSYMBOL_TYPENAME: /* "type name"  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3240 "pkl-tab.c"
        break;

    case YYSYMBOL_UNIT: /* "offset unit"  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3268 "pkl-tab.c"
        break;

    case YYSYMBOL_OFFSET: /* "offset"  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3296 "pkl-tab.c"
        break;

    case YYSYMBOL_ATTR: /* "attribute"  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3324 "pkl-tab.c"
        break;

    case YYSYMBOL_ARRSUF: /* "array suffix"  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3352 "pkl-tab.c"
        break;

    case YYSYMBOL_start: /* start  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3380 "pkl-tab.c"
        break;

    case YYSYMBOL_program: /* program  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3408 "pkl-tab.c"
        break;

    case YYSYMBOL_program_elem_list: /* program_elem_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3436 "pkl-tab.c"
        break;

    case YYSYMBOL_program_elem: /* program_elem  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3464 "pkl-tab.c"
        break;

    case YYSYMBOL_load: /* load  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3492 "pkl-tab.c"
        break;

    case YYSYMBOL_integer: /* integer  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3520 "pkl-tab.c"
        break;

    case YYSYMBOL_identifier: /* identifier  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3548 "pkl-tab.c"
        break;

    case YYSYMBOL_expression_list: /* expression_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3576 "pkl-tab.c"
        break;

    case YYSYMBOL_expression_opt: /* expression_opt  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3604 "pkl-tab.c"
        break;

    case YYSYMBOL_expression: /* expression  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3632 "pkl-tab.c"
        break;

    case YYSYMBOL_bconc: /* bconc  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3660 "pkl-tab.c"
        break;

    case YYSYMBOL_map: /* map  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3688 "pkl-tab.c"
        break;

    case YYSYMBOL_primary: /* primary  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3716 "pkl-tab.c"
        break;

    case YYSYMBOL_funcall: /* funcall  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3744 "pkl-tab.c"
        break;

    case YYSYMBOL_funcall_arg_list: /* funcall_arg_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3772 "pkl-tab.c"
        break;

    case YYSYMBOL_funcall_arg: /* funcall_arg  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3800 "pkl-tab.c"
        break;

    case YYSYMBOL_format_arg_list: /* format_arg_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3828 "pkl-tab.c"
        break;

    case YYSYMBOL_format_arg: /* format_arg  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3856 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_field_list: /* struct_field_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3884 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_field: /* struct_field  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3912 "pkl-tab.c"
        break;

    case YYSYMBOL_array: /* array  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3940 "pkl-tab.c"
        break;

    case YYSYMBOL_array_initializer_list: /* array_initializer_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3968 "pkl-tab.c"
        break;

    case YYSYMBOL_array_initializer: /* array_initializer  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 3996 "pkl-tab.c"
        break;

    case YYSYMBOL_function_specifier: /* function_specifier  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4024 "pkl-tab.c"
        break;

    case YYSYMBOL_function_arg_list: /* function_arg_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4052 "pkl-tab.c"
        break;

    case YYSYMBOL_function_arg: /* function_arg  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4080 "pkl-tab.c"
        break;

    case YYSYMBOL_function_arg_initial: /* function_arg_initial  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4108 "pkl-tab.c"
        break;

    case YYSYMBOL_type_specifier: /* type_specifier  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4136 "pkl-tab.c"
        break;

    case YYSYMBOL_typename: /* typename  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4164 "pkl-tab.c"
        break;

    case YYSYMBOL_string_type_specifier: /* string_type_specifier  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4192 "pkl-tab.c"
        break;

    case YYSYMBOL_simple_type_specifier: /* simple_type_specifier  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4220 "pkl-tab.c"
        break;

    case YYSYMBOL_cons_type_specifier: /* cons_type_specifier  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4248 "pkl-tab.c"
        break;

    case YYSYMBOL_integral_type_specifier: /* integral_type_specifier  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4276 "pkl-tab.c"
        break;

    case YYSYMBOL_dynamic_integral_type_specifier: /* dynamic_integral_type_specifier  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4304 "pkl-tab.c"
        break;

    case YYSYMBOL_ref_type: /* ref_type  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4332 "pkl-tab.c"
        break;

    case YYSYMBOL_offset_type_specifier: /* offset_type_specifier  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4360 "pkl-tab.c"
        break;

    case YYSYMBOL_array_type_specifier: /* array_type_specifier  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4388 "pkl-tab.c"
        break;

    case YYSYMBOL_function_type_specifier: /* function_type_specifier  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4416 "pkl-tab.c"
        break;

    case YYSYMBOL_function_type_arg_list: /* function_type_arg_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4444 "pkl-tab.c"
        break;

    case YYSYMBOL_function_type_arg: /* function_type_arg  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4472 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_specifier: /* struct_type_specifier  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4500 "pkl-tab.c"
        break;

    case YYSYMBOL_integral_struct: /* integral_struct  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4528 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_elem_list: /* struct_type_elem_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4556 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_computed_field: /* struct_type_computed_field  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4584 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_field: /* struct_type_field  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4612 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_field_identifier: /* struct_type_field_identifier  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4640 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_field_label: /* struct_type_field_label  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4668 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_field_optcond_pre: /* struct_type_field_optcond_pre  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4696 "pkl-tab.c"
        break;

    case YYSYMBOL_struct_type_field_optcond_post: /* struct_type_field_optcond_post  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4724 "pkl-tab.c"
        break;

    case YYSYMBOL_simple_declaration: /* simple_declaration  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4752 "pkl-tab.c"
        break;

    case YYSYMBOL_declaration: /* declaration  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4780 "pkl-tab.c"
        break;

    case YYSYMBOL_defvar_list: /* defvar_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4808 "pkl-tab.c"
        break;

    case YYSYMBOL_defvar: /* defvar  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4836 "pkl-tab.c"
        break;

    case YYSYMBOL_deftype_list: /* deftype_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4864 "pkl-tab.c"
        break;

    case YYSYMBOL_deftype: /* deftype  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4892 "pkl-tab.c"
        break;

    case YYSYMBOL_defunit_list: /* defunit_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4920 "pkl-tab.c"
        break;

    case YYSYMBOL_defunit: /* defunit  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4948 "pkl-tab.c"
        break;

    case YYSYMBOL_comp_stmt: /* comp_stmt  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 4976 "pkl-tab.c"
        break;

    case YYSYMBOL_stmt_decl_list: /* stmt_decl_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 5004 "pkl-tab.c"
        break;

    case YYSYMBOL_simple_stmt_list: /* simple_stmt_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 5032 "pkl-tab.c"
        break;

    case YYSYMBOL_simple_stmt: /* simple_stmt  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 5060 "pkl-tab.c"
        break;

    case YYSYMBOL_stmt: /* stmt  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 5088 "pkl-tab.c"
        break;

    case YYSYMBOL_funcall_stmt: /* funcall_stmt  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 5116 "pkl-tab.c"
        break;

    case YYSYMBOL_funcall_stmt_arg_list: /* funcall_stmt_arg_list  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 5144 "pkl-tab.c"
        break;

    case YYSYMBOL_funcall_stmt_arg: /* funcall_stmt_arg  */
#line 380 "pkl-tab.y"
            {
  if (((*yyvaluep).ast))
    {
      switch (PKL_AST_CODE (((*yyvaluep).ast)))
        {
        case PKL_AST_COMP_STMT:
            /*          pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        case PKL_AST_TYPE:
          /*          if (PKL_AST_TYPE_CODE ($$) == PKL_TYPE_STRUCT)
                      pkl_parser->env = pkl_env_pop_frame (pkl_parser->env); */
          break;
        case PKL_AST_FUNC:
            /*          if (PKL_AST_FUNC_ARGS ($$))
                        pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);*/
          break;
        default:
          break;
        }
    }

  ((*yyvaluep).ast) = ASTREF (((*yyvaluep).ast)); pkl_ast_node_free (((*yyvaluep).ast));
 }
#line 5172 "pkl-tab.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (struct pkl_parser *pkl_parser)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined PKL_TAB_LTYPE_IS_TRIVIAL && PKL_TAB_LTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

    yy_state_t yyesa[20];
    yy_state_t *yyes = yyesa;
    YYPTRDIFF_T yyes_capacity = 20 < YYMAXDEPTH ? 20 : YYMAXDEPTH;

  /* Whether LAC context is established.  A Boolean.  */
  int yy_lac_established = 0;
  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = PKL_TAB_EMPTY; /* Cause a token to be read.  */


/* User initialization code.  */
#line 31 "pkl-tab.y"
{
    yylloc.first_line = yylloc.last_line = pkl_parser->init_line;
    yylloc.first_column = yylloc.last_column = pkl_parser->init_column;
}

#line 5278 "pkl-tab.c"

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == PKL_TAB_EMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc, scanner);
    }

  if (yychar <= PKL_TAB_EOF)
    {
      yychar = PKL_TAB_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == PKL_TAB_error)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = PKL_TAB_UNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    {
      YY_LAC_ESTABLISH;
      goto yydefault;
    }
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      YY_LAC_ESTABLISH;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = PKL_TAB_EMPTY;
  YY_LAC_DISCARD ("shift");
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  {
    int yychar_backup = yychar;
    switch (yyn)
      {
  case 2: /* pushlevel: %empty  */
#line 594 "pkl-tab.y"
                {
                  pkl_parser->env = pkl_env_push_frame (pkl_parser->env);
                }
#line 5500 "pkl-tab.c"
    break;

  case 3: /* start: START_EXP expression  */
#line 609 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5510 "pkl-tab.c"
    break;

  case 4: /* start: START_EXP expression ','  */
#line 615 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                  YYACCEPT;
                }
#line 5521 "pkl-tab.c"
    break;

  case 5: /* start: START_DECL declaration  */
#line 622 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5531 "pkl-tab.c"
    break;

  case 6: /* start: START_DECL declaration ','  */
#line 628 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5541 "pkl-tab.c"
    break;

  case 7: /* start: START_STMT stmt  */
#line 634 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5551 "pkl-tab.c"
    break;

  case 8: /* start: START_STMT stmt ';'  */
#line 640 "pkl-tab.y"
                {
                  /* This rule is to allow the presence of an extra
                     ';' after the sentence.  This to allow the poke
                     command manager to ease the handling of
                     semicolons in the command line.  */
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5565 "pkl-tab.c"
    break;

  case 9: /* start: START_STMT load  */
#line 650 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5575 "pkl-tab.c"
    break;

  case 10: /* start: START_STMT load ';'  */
#line 656 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5585 "pkl-tab.c"
    break;

  case 11: /* start: START_PROGRAM program  */
#line 662 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_program (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  pkl_parser->ast->ast = ASTREF ((yyval.ast));
                }
#line 5595 "pkl-tab.c"
    break;

  case 12: /* program: %empty  */
#line 671 "pkl-tab.y"
                {
                  (yyval.ast) = NULL;
                }
#line 5603 "pkl-tab.c"
    break;

  case 15: /* program_elem_list: program_elem_list program_elem  */
#line 680 "pkl-tab.y"
                {
                  if ((yyvsp[0].ast) != NULL)
                    (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast));
                  else
                    (yyval.ast) = (yyvsp[-1].ast);
                }
#line 5614 "pkl-tab.c"
    break;

  case 17: /* program_elem: IMMUTABLE declaration  */
#line 691 "pkl-tab.y"
          {
            PKL_AST_DECL_IMMUTABLE_P ((yyvsp[0].ast)) = 1;
            (yyval.ast) = (yyvsp[0].ast);
          }
#line 5623 "pkl-tab.c"
    break;

  case 19: /* load: "keyword `load'" "identifier" ';'  */
#line 700 "pkl-tab.y"
                {
                  char *filename = NULL;
                  int ret = load_module (pkl_parser,
                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[-1].ast)),
                                         &(yyval.ast), 0 /* filename_p */, &filename);
                  if (ret == 2)
                    /* The sub-parser should have emitted proper error
                       messages.  No need to be verbose here.  */
                    YYERROR;
                  else if (ret == 1)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-1]),
                                 "cannot load `%s'",
                                 PKL_AST_IDENTIFIER_POINTER ((yyvsp[-1].ast)));
                      YYERROR;
                    }

                  /* Prepend and append SRC nodes to handle the change of
                     source files.  */
                  {
                      pkl_ast_node src1 = pkl_ast_make_src (pkl_parser->ast,
                                                            filename);
                      pkl_ast_node src2 = pkl_ast_make_src (pkl_parser->ast,
                                                            pkl_parser->filename);

                      (yyval.ast) = pkl_ast_chainon (src1, (yyval.ast));
                      (yyval.ast) = pkl_ast_chainon ((yyval.ast), src2);
                  }

                  (yyvsp[-1].ast) = ASTREF ((yyvsp[-1].ast));
                  pkl_ast_node_free ((yyvsp[-1].ast));
                  free (filename);
                }
#line 5661 "pkl-tab.c"
    break;

  case 20: /* load: "keyword `load'" "string" ';'  */
#line 734 "pkl-tab.y"
                {
                  char *filename = PKL_AST_STRING_POINTER ((yyvsp[-1].ast));
                  int ret = load_module (pkl_parser,
                                         filename,
                                         &(yyval.ast), 1 /* filename_p */, NULL);
                  if (ret == 2)
                    /* The sub-parser should have emitted proper error
                       messages.  No need to be verbose here.  */
                    YYERROR;
                  else if (ret == 1)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-1]),
                                 "cannot load module from file `%s'",
                                 filename);
                      YYERROR;
                    }

                  /* Prepend and append SRC nodes to handle the change of
                     source files.  */
                  {
                      pkl_ast_node src1 = pkl_ast_make_src (pkl_parser->ast,
                                                            filename);
                      pkl_ast_node src2 = pkl_ast_make_src (pkl_parser->ast,
                                                            pkl_parser->filename);

                      (yyval.ast) = pkl_ast_chainon (src1, (yyval.ast));
                      (yyval.ast) = pkl_ast_chainon ((yyval.ast), src2);
                  }

                  (yyvsp[-1].ast) = ASTREF ((yyvsp[-1].ast));
                  pkl_ast_node_free ((yyvsp[-1].ast));
                }
#line 5698 "pkl-tab.c"
    break;

  case 22: /* integer: LEXER_EXCEPTION  */
#line 775 "pkl-tab.y"
          {
            (yyval.ast) = NULL; /* To avoid bison warning.  */
            pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                       (yyvsp[0].exception_msg));
            free ((yyvsp[0].exception_msg));
            YYERROR;
          }
#line 5710 "pkl-tab.c"
    break;

  case 25: /* expression_list: %empty  */
#line 799 "pkl-tab.y"
                  { (yyval.ast) = NULL; }
#line 5716 "pkl-tab.c"
    break;

  case 27: /* expression_list: expression_list ',' expression  */
#line 802 "pkl-tab.y"
                  {
                    (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                  }
#line 5724 "pkl-tab.c"
    break;

  case 28: /* expression_opt: %empty  */
#line 808 "pkl-tab.y"
                 { (yyval.ast) = NULL; }
#line 5730 "pkl-tab.c"
    break;

  case 31: /* expression: unary_operator expression  */
#line 815 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_unary_exp (pkl_parser->ast,
                                               (yyvsp[-1].opcode), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5740 "pkl-tab.c"
    break;

  case 32: /* expression: expression "attribute"  */
#line 821 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_ATTR,
                                                (yyvsp[-1].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5751 "pkl-tab.c"
    break;

  case 33: /* expression: expression "attribute" '(' expression ')'  */
#line 828 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_ternary_exp (pkl_parser->ast, PKL_AST_OP_ATTR,
                                                 (yyvsp[-4].ast), (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyvsp[-3].ast)) = (yylsp[-3]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5762 "pkl-tab.c"
    break;

  case 34: /* expression: expression "addition operator" expression  */
#line 835 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_ADD,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5772 "pkl-tab.c"
    break;

  case 35: /* expression: expression "subtraction operator" expression  */
#line 841 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_SUB,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5782 "pkl-tab.c"
    break;

  case 36: /* expression: expression "multiplication operator" expression  */
#line 847 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_MUL,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5792 "pkl-tab.c"
    break;

  case 37: /* expression: expression "division operator" expression  */
#line 853 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_DIV,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5802 "pkl-tab.c"
    break;

  case 38: /* expression: expression "ceiling division operator" expression  */
#line 859 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_CEILDIV, (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5811 "pkl-tab.c"
    break;

  case 39: /* expression: expression "power operator" expression  */
#line 864 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_POW, (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5820 "pkl-tab.c"
    break;

  case 40: /* expression: expression "modulus operator" expression  */
#line 869 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_MOD,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5830 "pkl-tab.c"
    break;

  case 41: /* expression: expression "left shift operator" expression  */
#line 875 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_SL,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5840 "pkl-tab.c"
    break;

  case 42: /* expression: expression "right shift operator" expression  */
#line 881 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_SR,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5850 "pkl-tab.c"
    break;

  case 43: /* expression: expression "equality operator" expression  */
#line 887 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_EQ,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5860 "pkl-tab.c"
    break;

  case 44: /* expression: expression "inequality operator" expression  */
#line 893 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_NE,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5870 "pkl-tab.c"
    break;

  case 45: /* expression: expression "less-than operator" expression  */
#line 899 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_LT,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5880 "pkl-tab.c"
    break;

  case 46: /* expression: expression "bigger-than operator" expression  */
#line 905 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_GT,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5890 "pkl-tab.c"
    break;

  case 47: /* expression: expression "less-or-equal operator" expression  */
#line 911 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_LE,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5900 "pkl-tab.c"
    break;

  case 48: /* expression: expression "bigger-or-equal-than operator" expression  */
#line 917 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_GE,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5910 "pkl-tab.c"
    break;

  case 49: /* expression: expression "bit-wise or operator" expression  */
#line 923 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_IOR,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5920 "pkl-tab.c"
    break;

  case 50: /* expression: expression "bit-wise xor operator" expression  */
#line 929 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_XOR,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5930 "pkl-tab.c"
    break;

  case 51: /* expression: expression "bit-wise and operator" expression  */
#line 935 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_BAND,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5940 "pkl-tab.c"
    break;

  case 52: /* expression: expression "logical and operator" expression  */
#line 941 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_AND,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5950 "pkl-tab.c"
    break;

  case 53: /* expression: expression "logical or operator" expression  */
#line 947 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_OR,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5960 "pkl-tab.c"
    break;

  case 54: /* expression: expression "logical implication operator" expression  */
#line 953 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_IMPL,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5970 "pkl-tab.c"
    break;

  case 55: /* expression: expression "keyword `in'" expression  */
#line 959 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_IN,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5980 "pkl-tab.c"
    break;

  case 56: /* expression: expression "cast operator" simple_type_specifier  */
#line 965 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_cast (pkl_parser->ast, (yyvsp[0].ast), (yyvsp[-2].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5989 "pkl-tab.c"
    break;

  case 57: /* expression: expression "type identification operator" simple_type_specifier  */
#line 970 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_isa (pkl_parser->ast, (yyvsp[0].ast), (yyvsp[-2].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 5998 "pkl-tab.c"
    break;

  case 58: /* expression: expression '?' expression ':' expression  */
#line 975 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_cond_exp (pkl_parser->ast,
                                              (yyvsp[-4].ast), (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6008 "pkl-tab.c"
    break;

  case 59: /* expression: comp_stmt "conditional on exception operator" expression  */
#line 981 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_EXCOND,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6018 "pkl-tab.c"
    break;

  case 60: /* expression: expression "conditional on exception operator" expression  */
#line 987 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_EXCOND,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6028 "pkl-tab.c"
    break;

  case 61: /* expression: "offset unit"  */
#line 993 "pkl-tab.y"
                {
                  if ((yyvsp[0].ast) == NULL)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                 "invalid unit in offset");
                      YYERROR;
                    }

                    (yyval.ast) = pkl_ast_make_offset (pkl_parser->ast, NULL, (yyvsp[0].ast));
                    PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                    if (PKL_AST_TYPE ((yyvsp[0].ast)))
                        PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[0].ast))) = (yylsp[0]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6047 "pkl-tab.c"
    break;

  case 62: /* expression: "offset"  */
#line 1008 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6056 "pkl-tab.c"
    break;

  case 63: /* expression: expression "offset unit"  */
#line 1013 "pkl-tab.y"
                {
                  if ((yyvsp[0].ast) == NULL)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                 "invalid unit in offset");
                      YYERROR;
                    }

                    (yyval.ast) = pkl_ast_make_offset (pkl_parser->ast, (yyvsp[-1].ast), (yyvsp[0].ast));
                    PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                    if (PKL_AST_TYPE ((yyvsp[0].ast)))
                        PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[0].ast))) = (yylsp[0]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6075 "pkl-tab.c"
    break;

  case 64: /* expression: "increment operator" expression  */
#line 1028 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_incrdecr (pkl_parser->ast, (yyvsp[0].ast),
                                              PKL_AST_ORDER_PRE, PKL_AST_SIGN_INCR);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6085 "pkl-tab.c"
    break;

  case 65: /* expression: "decrement operator" expression  */
#line 1034 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_incrdecr (pkl_parser->ast, (yyvsp[0].ast),
                                              PKL_AST_ORDER_PRE, PKL_AST_SIGN_DECR);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6095 "pkl-tab.c"
    break;

  case 68: /* bconc: expression "bit-concatenation operator" expression  */
#line 1045 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_BCONC,
                                                (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6105 "pkl-tab.c"
    break;

  case 69: /* mapop: "map operator"  */
#line 1053 "pkl-tab.y"
             { (yyval.integer) = 1; }
#line 6111 "pkl-tab.c"
    break;

  case 70: /* mapop: "non-strict map operator"  */
#line 1054 "pkl-tab.y"
                { (yyval.integer) = 0; }
#line 6117 "pkl-tab.c"
    break;

  case 71: /* map: simple_type_specifier mapop expression  */
#line 1059 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_map (pkl_parser->ast, (yyvsp[-1].integer),
                                         (yyvsp[-2].ast), NULL, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6127 "pkl-tab.c"
    break;

  case 72: /* map: simple_type_specifier mapop expression ':' expression  */
#line 1065 "pkl-tab.y"
                 {
                   (yyval.ast) = pkl_ast_make_map (pkl_parser->ast, (yyvsp[-3].integer),
                                          (yyvsp[-4].ast), (yyvsp[-2].ast), (yyvsp[0].ast));
                   PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6137 "pkl-tab.c"
    break;

  case 73: /* unary_operator: "subtraction operator"  */
#line 1073 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_NEG; }
#line 6143 "pkl-tab.c"
    break;

  case 74: /* unary_operator: "addition operator"  */
#line 1074 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_POS; }
#line 6149 "pkl-tab.c"
    break;

  case 75: /* unary_operator: '~'  */
#line 1075 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_BNOT; }
#line 6155 "pkl-tab.c"
    break;

  case 76: /* unary_operator: '!'  */
#line 1076 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_NOT; }
#line 6161 "pkl-tab.c"
    break;

  case 77: /* unary_operator: "unmap operator"  */
#line 1077 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_UNMAP; }
#line 6167 "pkl-tab.c"
    break;

  case 78: /* unary_operator: "remap operator"  */
#line 1078 "pkl-tab.y"
                             { (yyval.opcode) = PKL_AST_OP_REMAP; }
#line 6173 "pkl-tab.c"
    break;

  case 79: /* primary: "identifier"  */
#line 1083 "pkl-tab.y"
                  {
                  /* Search for a variable definition in the
                     compile-time environment, and create a
                     PKL_AST_VAR node with it's lexical environment,
                     annotated with its initialization.  */

                  int back, over;
                  const char *name = PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast));

                  pkl_ast_node decl
                    = pkl_env_lookup (pkl_parser->env,
                                      PKL_ENV_NS_MAIN,
                                      name, &back, &over);
                  if (!decl
                      || (PKL_AST_DECL_KIND (decl) != PKL_AST_DECL_KIND_VAR
                          && PKL_AST_DECL_KIND (decl) != PKL_AST_DECL_KIND_FUNC))
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                 "undefined variable '%s'", name);
                      YYERROR;
                    }

                  (yyval.ast) = pkl_ast_make_var (pkl_parser->ast,
                                         (yyvsp[0].ast), /* name.  */
                                         decl,
                                         -1, -1);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[0]);
                }
#line 6206 "pkl-tab.c"
    break;

  case 80: /* primary: integer  */
#line 1112 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_LOC (PKL_AST_TYPE ((yyval.ast))) = (yyloc);
                }
#line 6216 "pkl-tab.c"
    break;

  case 81: /* primary: "character literal"  */
#line 1118 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_LOC (PKL_AST_TYPE ((yyval.ast))) = (yyloc);
                }
#line 6226 "pkl-tab.c"
    break;

  case 82: /* primary: "string"  */
#line 1124 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_LOC (PKL_AST_TYPE ((yyval.ast))) = (yyloc);
                }
#line 6236 "pkl-tab.c"
    break;

  case 83: /* primary: '(' expression ')'  */
#line 1130 "pkl-tab.y"
                {
                  if (PKL_AST_CODE ((yyvsp[-1].ast)) == PKL_AST_VAR)
                    PKL_AST_VAR_IS_PARENTHESIZED ((yyvsp[-1].ast)) = 1;
                  else if (PKL_AST_CODE ((yyvsp[-1].ast)) == PKL_AST_STRUCT_REF)
                    PKL_AST_STRUCT_REF_IS_PARENTHESIZED ((yyvsp[-1].ast)) = 1;
                  (yyval.ast) = (yyvsp[-1].ast);
                }
#line 6248 "pkl-tab.c"
    break;

  case 85: /* primary: primary ".>" identifier  */
#line 1139 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_struct_ref (pkl_parser->ast, (yyvsp[-2].ast), (yyvsp[0].ast));
                    PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6258 "pkl-tab.c"
    break;

  case 86: /* primary: primary "dot operator" identifier  */
#line 1145 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_struct_ref (pkl_parser->ast, (yyvsp[-2].ast), (yyvsp[0].ast));
                    PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6268 "pkl-tab.c"
    break;

  case 87: /* primary: primary "indirection operator" identifier  */
#line 1151 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_struct_ref (pkl_parser->ast, (yyvsp[-2].ast), (yyvsp[0].ast));
                    PKL_AST_STRUCT_REF_INDIRECTION_P ((yyval.ast)) = 1;
                    PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6279 "pkl-tab.c"
    break;

  case 88: /* primary: primary '[' expression ']'  */
#line 1158 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_indexer (pkl_parser->ast, (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6288 "pkl-tab.c"
    break;

  case 89: /* primary: primary '[' expression "range separator" expression ']'  */
#line 1163 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-5].ast), (yyvsp[-3].ast), NULL, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6298 "pkl-tab.c"
    break;

  case 90: /* primary: primary '[' expression ':' expression ']'  */
#line 1169 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-5].ast), (yyvsp[-3].ast), (yyvsp[-1].ast), NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6308 "pkl-tab.c"
    break;

  case 91: /* primary: primary '[' ':' ']'  */
#line 1175 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-3].ast), NULL, NULL, NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6318 "pkl-tab.c"
    break;

  case 92: /* primary: primary '[' ':' expression ']'  */
#line 1181 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-4].ast), NULL, (yyvsp[-1].ast), NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6328 "pkl-tab.c"
    break;

  case 93: /* primary: primary '[' expression ':' ']'  */
#line 1187 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_trimmer (pkl_parser->ast,
                                             (yyvsp[-4].ast), (yyvsp[-2].ast), NULL, NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6338 "pkl-tab.c"
    break;

  case 95: /* primary: '(' funcall_stmt ')'  */
#line 1194 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[-1].ast);
                }
#line 6346 "pkl-tab.c"
    break;

  case 96: /* $@1: %empty  */
#line 1198 "pkl-tab.y"
                {
                  /* function_specifier needs to know whether we are
                     in a function declaration or a method
                     declaration.  */
                  pkl_parser->in_method_decl_p = 0;
                }
#line 6357 "pkl-tab.c"
    break;

  case 97: /* primary: "keyword `lambda'" $@1 function_specifier  */
#line 1205 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_lambda (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6366 "pkl-tab.c"
    break;

  case 98: /* primary: "keyword `asm'" simple_type_specifier ':' '(' expression ')'  */
#line 1210 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_asm_exp (pkl_parser->ast, (yyvsp[-4].ast), (yyvsp[-1].ast), NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6375 "pkl-tab.c"
    break;

  case 99: /* primary: "keyword `asm'" simple_type_specifier ':' '(' expression ':' expression_list ')'  */
#line 1215 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_asm_exp (pkl_parser->ast, (yyvsp[-6].ast), (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6384 "pkl-tab.c"
    break;

  case 100: /* primary: "keyword `format'" '(' "string" format_arg_list ')'  */
#line 1220 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_format (pkl_parser->ast, (yyvsp[-2].ast), (yyvsp[-1].ast),
                                            0 /* printf_p */);
                  PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                }
#line 6396 "pkl-tab.c"
    break;

  case 101: /* primary: expression "increment operator"  */
#line 1228 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_incrdecr (pkl_parser->ast, (yyvsp[-1].ast),
                                              PKL_AST_ORDER_POST, PKL_AST_SIGN_INCR);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6406 "pkl-tab.c"
    break;

  case 102: /* primary: expression "decrement operator"  */
#line 1234 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_incrdecr (pkl_parser->ast, (yyvsp[-1].ast),
                                              PKL_AST_ORDER_POST, PKL_AST_SIGN_DECR);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6416 "pkl-tab.c"
    break;

  case 103: /* primary: "keyword `typeof'" '(' expression ')'  */
#line 1240 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_unary_exp (pkl_parser->ast, PKL_AST_OP_TYPEOF, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);
                }
#line 6425 "pkl-tab.c"
    break;

  case 104: /* primary: "keyword `typeof'" '(' simple_type_specifier ')'  */
#line 1245 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_unary_exp (pkl_parser->ast, PKL_AST_OP_TYPEOF, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);
                }
#line 6434 "pkl-tab.c"
    break;

  case 105: /* primary: "keyword `sizeof'" '(' simple_type_specifier ')'  */
#line 1250 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_unary_exp (pkl_parser->ast, PKL_AST_OP_SIZEOF, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);
                }
#line 6443 "pkl-tab.c"
    break;

  case 106: /* primary: "keyword `apush'" '(' expression ',' expression ')'  */
#line 1255 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_binary_exp (pkl_parser->ast, PKL_AST_OP_APUSH,
                                                (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-5]);
                }
#line 6453 "pkl-tab.c"
    break;

  case 107: /* primary: "keyword `apop'" '(' expression ')'  */
#line 1261 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_unary_exp (pkl_parser->ast, PKL_AST_OP_APOP,
                                               (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);
                }
#line 6463 "pkl-tab.c"
    break;

  case 108: /* primary: cons_type_specifier '(' expression_list opt_comma ')'  */
#line 1267 "pkl-tab.y"
                {
                  /* This syntax is only used for array
                     constructors.  */
                  if (PKL_AST_TYPE_CODE ((yyvsp[-4].ast)) != PKL_TYPE_ARRAY)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-4]),
                                 "expected array type in constructor");
                      YYERROR;
                    }

                  (yyval.ast) = pkl_ast_make_cons (pkl_parser->ast, (yyvsp[-4].ast), (yyvsp[-2].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6481 "pkl-tab.c"
    break;

  case 109: /* primary: typename '{' struct_field_list opt_comma '}'  */
#line 1281 "pkl-tab.y"
                {
                  pkl_ast_node astruct;

                  /* This syntax is only used for struct
                     constructors.  */
                  if (PKL_AST_TYPE_CODE ((yyvsp[-4].ast)) != PKL_TYPE_STRUCT)
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-4]),
                                 "expected struct type in constructor");
                      YYERROR;
                    }

                  astruct = pkl_ast_make_struct (pkl_parser->ast,
                                           0 /* nelem */, (yyvsp[-2].ast));
                  PKL_AST_LOC (astruct) = (yyloc);

                  (yyval.ast) = pkl_ast_make_cons (pkl_parser->ast, (yyvsp[-4].ast), astruct);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6505 "pkl-tab.c"
    break;

  case 110: /* funcall: primary '(' funcall_arg_list ')'  */
#line 1304 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_funcall (pkl_parser->ast,
                                             (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6515 "pkl-tab.c"
    break;

  case 111: /* funcall_arg_list: %empty  */
#line 1313 "pkl-tab.y"
                { (yyval.ast) = NULL; }
#line 6521 "pkl-tab.c"
    break;

  case 113: /* funcall_arg_list: funcall_arg_list ',' funcall_arg  */
#line 1316 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 6529 "pkl-tab.c"
    break;

  case 114: /* funcall_arg: expression  */
#line 1323 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_funcall_arg (pkl_parser->ast,
                                                 (yyvsp[0].ast), NULL /* name */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6539 "pkl-tab.c"
    break;

  case 115: /* format_arg_list: %empty  */
#line 1332 "pkl-tab.y"
                { (yyval.ast) = NULL; }
#line 6545 "pkl-tab.c"
    break;

  case 117: /* format_arg_list: format_arg_list ',' format_arg  */
#line 1335 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 6553 "pkl-tab.c"
    break;

  case 118: /* format_arg: expression  */
#line 1342 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_format_arg (pkl_parser->ast, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6562 "pkl-tab.c"
    break;

  case 121: /* struct_field_list: %empty  */
#line 1355 "pkl-tab.y"
                { (yyval.ast) = NULL; }
#line 6568 "pkl-tab.c"
    break;

  case 123: /* struct_field_list: struct_field_list ',' struct_field  */
#line 1358 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 6576 "pkl-tab.c"
    break;

  case 124: /* struct_field: expression  */
#line 1365 "pkl-tab.y"
                  {
                    (yyval.ast) = pkl_ast_make_struct_field (pkl_parser->ast,
                                                    NULL /* name */,
                                                    (yyvsp[0].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6587 "pkl-tab.c"
    break;

  case 125: /* struct_field: identifier '=' expression  */
#line 1372 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_struct_field (pkl_parser->ast,
                                                    (yyvsp[-2].ast),
                                                    (yyvsp[0].ast));
                    PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6599 "pkl-tab.c"
    break;

  case 126: /* array: '[' array_initializer_list opt_comma ']'  */
#line 1383 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_array (pkl_parser->ast,
                                             0 /* nelem */,
                                             0 /* ninitializer */,
                                             (yyvsp[-2].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6611 "pkl-tab.c"
    break;

  case 127: /* array: '[' array_initializer_list opt_comma "array suffix"  */
#line 1391 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_array (pkl_parser->ast,
                                             0 /* nelem */,
                                             0 /* ninitializer */,
                                             (yyvsp[-2].ast));
                    PKL_AST_ARRAY_ELEM_CAST ((yyval.ast)) = (yyvsp[0].ast);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6624 "pkl-tab.c"
    break;

  case 129: /* array_initializer_list: array_initializer_list ',' array_initializer  */
#line 1404 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 6632 "pkl-tab.c"
    break;

  case 130: /* array_initializer: expression  */
#line 1411 "pkl-tab.y"
                  {
                    (yyval.ast) = pkl_ast_make_array_initializer (pkl_parser->ast,
                                                         NULL, (yyvsp[0].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6642 "pkl-tab.c"
    break;

  case 131: /* array_initializer: "dot operator" '[' expression ']' '=' expression  */
#line 1417 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_array_initializer (pkl_parser->ast,
                                                         (yyvsp[-3].ast), (yyvsp[0].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6652 "pkl-tab.c"
    break;

  case 132: /* pushlevel_args: %empty  */
#line 1430 "pkl-tab.y"
                {
                  /* Push the lexical frame for the function's
                     arguments.  */
                  pkl_parser->env = pkl_env_push_frame (pkl_parser->env);

                  /* If in a method, register an argument SELF for the
                     initial implicit argument.  */
                  if (pkl_parser->in_method_decl_p)
                    {
                      pkl_ast_node arg_type
                        = pkl_ast_make_any_type (pkl_parser->ast);
                      pkl_ast_node arg_name
                        = pkl_ast_make_identifier (pkl_parser->ast,
                                                   "SELF");
                      int registered_p __attribute__ ((unused));

                      pkl_ast_node arg
                        = pkl_ast_make_func_arg (pkl_parser->ast,
                                                 arg_type, arg_name,
                                                 NULL /* initial */);

                      registered_p = pkl_register_arg (pkl_parser, arg);
                      assert (registered_p);
                    }
                }
#line 6682 "pkl-tab.c"
    break;

  case 133: /* function_specifier: '(' pushlevel_args function_arg_list ')' simple_type_specifier ':' comp_stmt  */
#line 1459 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_func (pkl_parser->ast,
                                          (yyvsp[-2].ast), (yyvsp[-4].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 6696 "pkl-tab.c"
    break;

  case 134: /* function_specifier: simple_type_specifier ':' pushlevel_args comp_stmt  */
#line 1469 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_func (pkl_parser->ast,
                                          (yyvsp[-3].ast), NULL, (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 6710 "pkl-tab.c"
    break;

  case 136: /* function_arg_list: function_arg ',' function_arg_list  */
#line 1483 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 6718 "pkl-tab.c"
    break;

  case 137: /* function_arg: simple_type_specifier identifier function_arg_initial  */
#line 1490 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_func_arg (pkl_parser->ast,
                                              (yyvsp[-2].ast), (yyvsp[-1].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyvsp[-1].ast)) = (yylsp[-1]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  if (!pkl_register_arg (pkl_parser, (yyval.ast)))
                      YYERROR;
                }
#line 6732 "pkl-tab.c"
    break;

  case 138: /* function_arg: identifier "varargs indicator"  */
#line 1500 "pkl-tab.y"
                {
                  pkl_ast_node type
                    = pkl_ast_make_any_type (pkl_parser->ast);
                  pkl_ast_node array_type
                    = pkl_ast_make_array_type (pkl_parser->ast,
                                               type,
                                               NULL /* bound */);

                  PKL_AST_LOC (type) = (yylsp[-1]);
                  PKL_AST_LOC (array_type) = (yylsp[-1]);

                  (yyval.ast) = pkl_ast_make_func_arg (pkl_parser->ast,
                                              array_type,
                                              (yyvsp[-1].ast),
                                              NULL /* initial */);
                  PKL_AST_FUNC_ARG_VARARG ((yyval.ast)) = 1;
                  PKL_AST_LOC ((yyvsp[-1].ast)) = (yylsp[-1]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  if (!pkl_register_arg (pkl_parser, (yyval.ast)))
                      YYERROR;
                }
#line 6759 "pkl-tab.c"
    break;

  case 139: /* function_arg_initial: %empty  */
#line 1525 "pkl-tab.y"
                                      { (yyval.ast) = NULL; }
#line 6765 "pkl-tab.c"
    break;

  case 140: /* function_arg_initial: '=' expression  */
#line 1526 "pkl-tab.y"
                                { (yyval.ast) = (yyvsp[0].ast); }
#line 6771 "pkl-tab.c"
    break;

  case 144: /* typename: "type name"  */
#line 1541 "pkl-tab.y"
                  {
                    pkl_ast_node alias;
                    pkl_ast_node decl;

                    decl = pkl_env_lookup (pkl_parser->env,
                                           PKL_ENV_NS_MAIN,
                                           PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast)),
                                           NULL, NULL);
                    assert (decl != NULL
                            && PKL_AST_DECL_KIND (decl) == PKL_AST_DECL_KIND_TYPE);
                    alias = pkl_ast_make_named_type (pkl_parser->ast,
                                                     (yyvsp[0].ast), PKL_AST_DECL_INITIAL (decl));
                    pkl_ast_add_type_name_to_decl (decl, alias);
                    (yyval.ast) = alias;
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6792 "pkl-tab.c"
    break;

  case 145: /* string_type_specifier: "string type specifier"  */
#line 1561 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_string_type (pkl_parser->ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6801 "pkl-tab.c"
    break;

  case 146: /* simple_type_specifier: "any type specifier"  */
#line 1569 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_any_type (pkl_parser->ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6810 "pkl-tab.c"
    break;

  case 147: /* simple_type_specifier: "void type specifier"  */
#line 1574 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_void_type (pkl_parser->ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6819 "pkl-tab.c"
    break;

  case 156: /* integral_type_specifier: integral_type_sign integer "bigger-than operator"  */
#line 1593 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_integral_type (pkl_parser->ast,
                                                     PKL_AST_INTEGER_VALUE ((yyvsp[-1].ast)),
                                                     (yyvsp[-2].integer));
                    (yyvsp[-1].ast) = ASTREF ((yyvsp[-1].ast)); pkl_ast_node_free ((yyvsp[-1].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6831 "pkl-tab.c"
    break;

  case 157: /* dynamic_integral_type_specifier: integral_type_sign "multiplication operator" "bigger-than operator"  */
#line 1604 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_integral_type (pkl_parser->ast, 0, (yyvsp[-2].integer));
                    PKL_AST_TYPE_I_DYN_P ((yyval.ast)) = 1;
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6841 "pkl-tab.c"
    break;

  case 158: /* integral_type_sign: "int type constructor"  */
#line 1612 "pkl-tab.y"
                           { (yyval.integer) = 1; }
#line 6847 "pkl-tab.c"
    break;

  case 159: /* integral_type_sign: "uint type constructor"  */
#line 1613 "pkl-tab.y"
                            { (yyval.integer) = 0; }
#line 6853 "pkl-tab.c"
    break;

  case 160: /* ref_type: %empty  */
#line 1617 "pkl-tab.y"
                                      { (yyval.ast) = NULL; }
#line 6859 "pkl-tab.c"
    break;

  case 161: /* ref_type: ',' simple_type_specifier  */
#line 1618 "pkl-tab.y"
                                    { (yyval.ast) = (yyvsp[0].ast); }
#line 6865 "pkl-tab.c"
    break;

  case 162: /* offset_type_specifier: "offset type constructor" simple_type_specifier ',' identifier ref_type "bigger-than operator"  */
#line 1623 "pkl-tab.y"
                {
                  pkl_ast_node decl
                    = pkl_env_lookup (pkl_parser->env,
                                      PKL_ENV_NS_UNITS,
                                      PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)),
                                      NULL, NULL);

                  if (!decl)
                    {
                      /* This could be the name of a type.  Try it out.  */
                      decl = pkl_env_lookup (pkl_parser->env,
                                             PKL_ENV_NS_MAIN,
                                             PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)),
                                             NULL, NULL);

                      if (!decl)
                        {
                          pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-2]),
                                     "invalid unit in offset type");
                          YYERROR;
                        }
                    }

                  (yyval.ast) = pkl_ast_make_offset_type (pkl_parser->ast,
                                                 (yyvsp[-4].ast),
                                                 PKL_AST_DECL_INITIAL (decl),
                                                 (yyvsp[-1].ast));

                  (yyvsp[-2].ast) = ASTREF ((yyvsp[-2].ast)); pkl_ast_node_free ((yyvsp[-2].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6901 "pkl-tab.c"
    break;

  case 163: /* offset_type_specifier: "offset type constructor" simple_type_specifier ',' integer ref_type "bigger-than operator"  */
#line 1655 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_offset_type (pkl_parser->ast,
                                                   (yyvsp[-4].ast), (yyvsp[-2].ast), (yyvsp[-1].ast));
                    PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[-2].ast))) = (yylsp[-2]);
                    PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6913 "pkl-tab.c"
    break;

  case 164: /* array_type_specifier: simple_type_specifier '[' ']'  */
#line 1666 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_array_type (pkl_parser->ast, (yyvsp[-2].ast),
                                                NULL /* bound */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6923 "pkl-tab.c"
    break;

  case 165: /* array_type_specifier: simple_type_specifier '[' expression ']'  */
#line 1672 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_array_type (pkl_parser->ast, (yyvsp[-3].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6932 "pkl-tab.c"
    break;

  case 166: /* function_type_specifier: '(' function_type_arg_list ')' simple_type_specifier  */
#line 1680 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_function_type (pkl_parser->ast,
                                                   (yyvsp[0].ast), 0 /* narg */,
                                                   (yyvsp[-2].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6943 "pkl-tab.c"
    break;

  case 167: /* function_type_specifier: '(' ')' simple_type_specifier  */
#line 1687 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_function_type (pkl_parser->ast,
                                                   (yyvsp[0].ast), 0 /* narg */,
                                                   NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6954 "pkl-tab.c"
    break;

  case 169: /* function_type_arg_list: function_type_arg ',' function_type_arg_list  */
#line 1698 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast));
                }
#line 6962 "pkl-tab.c"
    break;

  case 170: /* function_type_arg: simple_type_specifier  */
#line 1705 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_func_type_arg (pkl_parser->ast,
                                                   (yyvsp[0].ast), NULL /* name */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 6972 "pkl-tab.c"
    break;

  case 171: /* function_type_arg: simple_type_specifier '?'  */
#line 1711 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_func_type_arg (pkl_parser->ast,
                                                   (yyvsp[-1].ast), NULL /* name */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_FUNC_TYPE_ARG_OPTIONAL ((yyval.ast)) = 1;
                }
#line 6983 "pkl-tab.c"
    break;

  case 172: /* function_type_arg: "varargs indicator"  */
#line 1718 "pkl-tab.y"
                {
                  pkl_ast_node type
                    = pkl_ast_make_any_type (pkl_parser->ast);
                  pkl_ast_node array_type
                    = pkl_ast_make_array_type (pkl_parser->ast,
                                               type, NULL /* bound */);

                  PKL_AST_LOC (type) = (yylsp[0]);
                  PKL_AST_LOC (array_type) = (yylsp[0]);

                  (yyval.ast) = pkl_ast_make_func_type_arg (pkl_parser->ast,
                                                   array_type, NULL /* name */);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  PKL_AST_FUNC_TYPE_ARG_VARARG ((yyval.ast)) = 1;
                }
#line 7003 "pkl-tab.c"
    break;

  case 173: /* struct_type_specifier: pushlevel struct_type_pinned struct_or_union integral_struct '{' '}'  */
#line 1738 "pkl-tab.y"
                  {
                    (yyval.ast) = pkl_ast_make_struct_type (pkl_parser->ast,
                                                   0 /* nelem */,
                                                   0 /* nfield */,
                                                   0 /* ndecl */,
                                                   (yyvsp[-2].ast),
                                                   NULL /* elems */,
                                                   (yyvsp[-4].integer), (yyvsp[-3].integer));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);

                    /* The pushlevel in this rule and the subsequent
                       pop_frame, while not strictly needed, is to
                       avoid shift/reduce conflicts with the next
                       rule.  */
                    pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 7024 "pkl-tab.c"
    break;

  case 174: /* $@2: %empty  */
#line 1756 "pkl-tab.y"
                {
                  /* Register dummies for the locals used in
                     pkl-gen.pks:struct_mapper (not counting
                     OFFSET).  */
                  pkl_register_dummies (pkl_parser, 5);

                  /* Now register OFFSET with a type of
                     offset<uint<64>,1> */
                  {
                    pkl_ast_node decl, type;
                    pkl_ast_node offset_identifier
                      = pkl_ast_make_identifier (pkl_parser->ast, "OFFSET");
                    pkl_ast_node offset_magnitude
                      = pkl_ast_make_integer (pkl_parser->ast, 0);
                    pkl_ast_node offset_unit
                      = pkl_ast_make_integer (pkl_parser->ast, 1);
                    pkl_ast_node offset;

                    type = pkl_ast_make_integral_type (pkl_parser->ast, 64, 0);
                    PKL_AST_TYPE (offset_magnitude) = ASTREF (type);
                    PKL_AST_TYPE (offset_unit) = ASTREF (type);

                    offset = pkl_ast_make_offset (pkl_parser->ast,
                                                  offset_magnitude,
                                                  offset_unit);
                    type = pkl_ast_make_offset_type (pkl_parser->ast,
                                                     type,
                                                     offset_unit,
                                                     NULL /* ref_type */);
                    PKL_AST_TYPE (offset) = ASTREF (type);

                    decl = pkl_ast_make_decl (pkl_parser->ast,
                                              PKL_AST_DECL_KIND_VAR,
                                              offset_identifier,
                                              offset,
                                              NULL /* source */);

                    if (!pkl_env_register (pkl_parser->env,
                                           pkl_parser->ast,
                                           PKL_ENV_NS_MAIN,
                                           PKL_AST_IDENTIFIER_POINTER (offset_identifier),
                                           decl))
                      PK_UNREACHABLE ();
                  }
                }
#line 7074 "pkl-tab.c"
    break;

  case 175: /* struct_type_specifier: pushlevel struct_type_pinned struct_or_union integral_struct '{' $@2 struct_type_elem_list '}'  */
#line 1802 "pkl-tab.y"
                {
                    (yyval.ast) = pkl_ast_make_struct_type (pkl_parser->ast,
                                                   0 /* nelem */,
                                                   0 /* nfield */,
                                                   0 /* ndecl */,
                                                   (yyvsp[-4].ast),
                                                   (yyvsp[-1].ast),
                                                   (yyvsp[-6].integer), (yyvsp[-5].integer));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);

                    /* Pop the frame pushed in the `pushlevel' above.  */
                    pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 7092 "pkl-tab.c"
    break;

  case 176: /* struct_or_union: "keyword `struct'"  */
#line 1818 "pkl-tab.y"
                        { (yyval.integer) = 0; }
#line 7098 "pkl-tab.c"
    break;

  case 177: /* struct_or_union: "keyword `union'"  */
#line 1819 "pkl-tab.y"
                        { (yyval.integer) = 1; }
#line 7104 "pkl-tab.c"
    break;

  case 178: /* struct_type_pinned: %empty  */
#line 1823 "pkl-tab.y"
                        { (yyval.integer) = 0; }
#line 7110 "pkl-tab.c"
    break;

  case 179: /* struct_type_pinned: "keyword `pinned'"  */
#line 1824 "pkl-tab.y"
                        { (yyval.integer) = 1; }
#line 7116 "pkl-tab.c"
    break;

  case 180: /* integral_struct: %empty  */
#line 1828 "pkl-tab.y"
                         { (yyval.ast) = NULL; }
#line 7122 "pkl-tab.c"
    break;

  case 181: /* integral_struct: simple_type_specifier  */
#line 1829 "pkl-tab.y"
                                { (yyval.ast) = (yyvsp[0].ast); }
#line 7128 "pkl-tab.c"
    break;

  case 182: /* integral_struct: dynamic_integral_type_specifier  */
#line 1830 "pkl-tab.y"
                                          { (yyval.ast) = (yyvsp[0].ast); }
#line 7134 "pkl-tab.c"
    break;

  case 186: /* struct_type_elem_list: struct_type_elem_list declaration  */
#line 1838 "pkl-tab.y"
                  { (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast)); }
#line 7140 "pkl-tab.c"
    break;

  case 187: /* struct_type_elem_list: struct_type_elem_list struct_type_field  */
#line 1840 "pkl-tab.y"
                { (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast)); }
#line 7146 "pkl-tab.c"
    break;

  case 188: /* struct_type_elem_list: struct_type_elem_list struct_type_computed_field  */
#line 1842 "pkl-tab.y"
                { (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast)); }
#line 7152 "pkl-tab.c"
    break;

  case 189: /* endianness: %empty  */
#line 1846 "pkl-tab.y"
                        { (yyval.integer) = PKL_AST_ENDIAN_DFL; }
#line 7158 "pkl-tab.c"
    break;

  case 190: /* endianness: "keyword `little'"  */
#line 1847 "pkl-tab.y"
                        { (yyval.integer) = PKL_AST_ENDIAN_LSB; }
#line 7164 "pkl-tab.c"
    break;

  case 191: /* endianness: "keyword `big'"  */
#line 1848 "pkl-tab.y"
                             { (yyval.integer) = PKL_AST_ENDIAN_MSB; }
#line 7170 "pkl-tab.c"
    break;

  case 192: /* struct_type_computed_field: "keyword `computed'" type_specifier identifier ';'  */
#line 1853 "pkl-tab.y"
                  {
                    (yyval.ast) = pkl_ast_make_struct_type_field (pkl_parser->ast, (yyvsp[-1].ast), (yyvsp[-2].ast),
                                                         NULL /* constraint */,
                                                         NULL /* initializer */,
                                                         NULL /* label */,
                                                         PKL_AST_ENDIAN_DFL,
                                                         NULL /* optcond_pre */,
                                                         NULL /* optcond_post */);
                    PKL_AST_STRUCT_TYPE_FIELD_COMPUTED_P ((yyval.ast)) = 1;
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);
                  }
#line 7186 "pkl-tab.c"
    break;

  case 193: /* $@3: %empty  */
#line 1869 "pkl-tab.y"
                  {
                    /* Register a variable in the current environment
                       for the field.  We do it in this mid-rule so
                       the element can be used in the constraint.  */

                    pkl_ast_node dummy, decl;
                    pkl_ast_node identifier
                      = ((yyvsp[0].ast) != NULL
                         ? (yyvsp[0].ast)
                         : pkl_ast_make_identifier (pkl_parser->ast, ""));


                    dummy = pkl_ast_make_integer (pkl_parser->ast, 0);
                    PKL_AST_TYPE (dummy) = ASTREF ((yyvsp[-1].ast));
                    decl = pkl_ast_make_decl (pkl_parser->ast,
                                              PKL_AST_DECL_KIND_VAR,
                                              identifier, dummy,
                                              NULL /* source */);
                    PKL_AST_DECL_STRUCT_FIELD_P (decl) = 1;
                    PKL_AST_LOC (decl) = (yyloc);

                    if (!pkl_env_register (pkl_parser->env,
                                           pkl_parser->ast,
                                           PKL_ENV_NS_MAIN,
                                           PKL_AST_IDENTIFIER_POINTER (identifier),
                                           decl))
                      {
                        pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                   "duplicated struct element '%s'",
                                   PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast)));
                        YYERROR;
                      }

                    if (identifier)
                      {
                        identifier = ASTREF (identifier);
                        pkl_ast_node_free (identifier);
                      }
                  }
#line 7230 "pkl-tab.c"
    break;

  case 194: /* struct_type_field: struct_type_field_optcond_pre endianness type_specifier struct_type_field_identifier $@3 struct_type_field_constraint_and_init struct_type_field_label struct_type_field_optcond_post ';'  */
#line 1910 "pkl-tab.y"
                  {
                    pkl_ast_node constraint = (yyvsp[-3].field_const_init).constraint;
                    pkl_ast_node initializer = (yyvsp[-3].field_const_init).initializer;
                    int impl_constraint_p = (yyvsp[-3].field_const_init).impl_constraint_p;

                    if (initializer)
                      {
                        pkl_ast_node field_decl, field_var;
                        int back, over;

                        /* We need a field name.  */
                        if ((yyvsp[-5].ast) == NULL)
                          {
                            pkl_error (pkl_parser->compiler, pkl_parser->ast, (yyloc),
                                       "no initializer allowed in anonymous field");
                            YYERROR;
                          }

                        /* Build a constraint derived from the
                           initializer if a constraint has not been
                           specified.  */
                        if (impl_constraint_p)
                          {
                            field_decl = pkl_env_lookup (pkl_parser->env,
                                                         PKL_ENV_NS_MAIN,
                                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[-5].ast)),
                                                         &back, &over);
                            assert (field_decl);

                            field_var = pkl_ast_make_var (pkl_parser->ast,
                                                          (yyvsp[-5].ast),
                                                          field_decl,
                                                          -1, -1);
                            PKL_AST_LOC (field_var) = PKL_AST_LOC (initializer);

                            constraint = pkl_ast_make_binary_exp (pkl_parser->ast,
                                                                  PKL_AST_OP_EQ,
                                                                  field_var,
                                                                  initializer);
                            PKL_AST_LOC (constraint) = PKL_AST_LOC (initializer);
                          }
                      }

                    (yyval.ast) = pkl_ast_make_struct_type_field (pkl_parser->ast, (yyvsp[-5].ast), (yyvsp[-6].ast),
                                                         constraint, initializer,
                                                         (yyvsp[-2].ast), (yyvsp[-7].integer), (yyvsp[-8].ast), (yyvsp[-1].ast));
                    PKL_AST_LOC ((yyval.ast)) = (yyloc);

                    if (constraint)
                      {
                        char *code = pkl_loc_to_source (pkl_parser,
                                                        PKL_AST_LOC (constraint),
                                                        256);
                        if (impl_constraint_p)
                          {
                            assert ((yyvsp[-5].ast) != NULL);
                            code = pk_str_concat (PKL_AST_IDENTIFIER_POINTER ((yyvsp[-5].ast)),
                                                  " == ", code, NULL);
                          }

                        PKL_AST_STRUCT_TYPE_FIELD_CONSTRAINT_SRC ((yyval.ast))
                          = code;
                      }

                    /* If endianness is empty or there is no
                       pre-condition in the field, bison includes the
                       blank characters before the type field as if
                       they were part of this rule.  Therefore the
                       location should be adjusted here.  */
                    if ((yyvsp[-7].integer) == PKL_AST_ENDIAN_DFL || (yyvsp[-8].ast) == NULL)
                      {
                        PKL_AST_LOC ((yyval.ast)).first_line = (yylsp[-5]).first_line;
                        PKL_AST_LOC ((yyval.ast)).first_column = (yylsp[-5]).first_column;
                      }

                    if ((yyvsp[-5].ast) != NULL)
                      {
                        PKL_AST_LOC ((yyvsp[-5].ast)) = (yylsp[-5]);
                        PKL_AST_TYPE ((yyvsp[-5].ast)) = pkl_ast_make_string_type (pkl_parser->ast);
                        PKL_AST_TYPE ((yyvsp[-5].ast)) = ASTREF (PKL_AST_TYPE ((yyvsp[-5].ast)));
                        PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[-5].ast))) = (yylsp[-5]);
                      }
                  }
#line 7318 "pkl-tab.c"
    break;

  case 195: /* struct_type_field_identifier: %empty  */
#line 1996 "pkl-tab.y"
                        { (yyval.ast) = NULL; }
#line 7324 "pkl-tab.c"
    break;

  case 196: /* struct_type_field_identifier: identifier  */
#line 1997 "pkl-tab.y"
                            { (yyval.ast) = (yyvsp[0].ast); }
#line 7330 "pkl-tab.c"
    break;

  case 197: /* struct_type_field_label: %empty  */
#line 2002 "pkl-tab.y"
                {
                  (yyval.ast) = NULL;
                }
#line 7338 "pkl-tab.c"
    break;

  case 198: /* struct_type_field_label: "map operator" expression  */
#line 2006 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[0]);
                }
#line 7347 "pkl-tab.c"
    break;

  case 199: /* struct_type_field_constraint_and_init: %empty  */
#line 2014 "pkl-tab.y"
                {
                  (yyval.field_const_init).constraint = NULL;
                  (yyval.field_const_init).initializer = NULL;
                  (yyval.field_const_init).impl_constraint_p = 0;
                }
#line 7357 "pkl-tab.c"
    break;

  case 200: /* struct_type_field_constraint_and_init: ':' expression  */
#line 2020 "pkl-tab.y"
                {
                  (yyval.field_const_init).constraint = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.field_const_init).constraint) = (yylsp[0]);
                  (yyval.field_const_init).initializer = NULL;
                  (yyval.field_const_init).impl_constraint_p = 0;
                }
#line 7368 "pkl-tab.c"
    break;

  case 201: /* struct_type_field_constraint_and_init: '=' expression  */
#line 2027 "pkl-tab.y"
                {
                  (yyval.field_const_init).constraint = NULL;
                  (yyval.field_const_init).initializer = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.field_const_init).initializer) = (yylsp[0]);
                  (yyval.field_const_init).impl_constraint_p = 0;
                }
#line 7379 "pkl-tab.c"
    break;

  case 202: /* struct_type_field_constraint_and_init: '=' expression ':' expression  */
#line 2034 "pkl-tab.y"
                {
                  (yyval.field_const_init).constraint = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.field_const_init).constraint) = (yylsp[0]);
                  (yyval.field_const_init).initializer = (yyvsp[-2].ast);
                  PKL_AST_LOC ((yyval.field_const_init).initializer) = (yylsp[-2]);
                  (yyval.field_const_init).impl_constraint_p = 0;
                }
#line 7391 "pkl-tab.c"
    break;

  case 203: /* struct_type_field_constraint_and_init: ':' expression '=' expression  */
#line 2042 "pkl-tab.y"
                {
                  (yyval.field_const_init).constraint = (yyvsp[-2].ast);
                  PKL_AST_LOC ((yyval.field_const_init).constraint) = (yylsp[-2]);
                  (yyval.field_const_init).initializer = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.field_const_init).initializer) = (yylsp[0]);
                  (yyval.field_const_init).impl_constraint_p = 0;
                }
#line 7403 "pkl-tab.c"
    break;

  case 204: /* struct_type_field_constraint_and_init: "equality operator" expression  */
#line 2050 "pkl-tab.y"
                {
                  (yyval.field_const_init).constraint = NULL;
                  (yyval.field_const_init).initializer = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.field_const_init).initializer) = (yylsp[0]);
                  (yyval.field_const_init).impl_constraint_p = 1;
                }
#line 7414 "pkl-tab.c"
    break;

  case 205: /* struct_type_field_optcond_pre: %empty  */
#line 2060 "pkl-tab.y"
                {
                  (yyval.ast) = NULL;
                }
#line 7422 "pkl-tab.c"
    break;

  case 206: /* struct_type_field_optcond_pre: "keyword `if'" '(' expression ')'  */
#line 2064 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[-1].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-1]);
                }
#line 7431 "pkl-tab.c"
    break;

  case 207: /* struct_type_field_optcond_post: %empty  */
#line 2072 "pkl-tab.y"
                {
                  (yyval.ast) = NULL;
                }
#line 7439 "pkl-tab.c"
    break;

  case 208: /* struct_type_field_optcond_post: "keyword `if'" expression  */
#line 2076 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[0].ast);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[0]);
                }
#line 7448 "pkl-tab.c"
    break;

  case 209: /* simple_declaration: "keyword `var'" defvar_list  */
#line 2087 "pkl-tab.y"
                               { (yyval.ast) = (yyvsp[0].ast); }
#line 7454 "pkl-tab.c"
    break;

  case 210: /* simple_declaration: "keyword `type'" deftype_list  */
#line 2088 "pkl-tab.y"
                               { (yyval.ast) = (yyvsp[0].ast); }
#line 7460 "pkl-tab.c"
    break;

  case 211: /* simple_declaration: "keyword `unit'" defunit_list  */
#line 2089 "pkl-tab.y"
                               { (yyval.ast) = (yyvsp[0].ast); }
#line 7466 "pkl-tab.c"
    break;

  case 212: /* @4: %empty  */
#line 2094 "pkl-tab.y"
                {
                  /* In order to allow for the function to be called
                     from within itself (recursive calls) we should
                     register a partial declaration in the
                     compile-time environment before processing the
                     `function_specifier' below.  */

                  (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                               PKL_AST_DECL_KIND_FUNC, (yyvsp[0].ast),
                                               NULL /* initial */,
                                               pkl_parser->filename);
                  PKL_AST_LOC ((yyvsp[0].ast)) = (yylsp[0]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  if (!pkl_env_register (pkl_parser->env,
                                         pkl_parser->ast,
                                         PKL_ENV_NS_MAIN,
                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast)),
                                         (yyval.ast)))
                    {
                      pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[0]),
                                 "function, method or variable `%s' already defined",
                                 PKL_AST_IDENTIFIER_POINTER ((yyvsp[0].ast)));
                      YYERROR;
                    }

                  /* function_specifier needs to know whether we are
                     in a function declaration or a method
                     declaration.  */
                  pkl_parser->in_method_decl_p = ((yyvsp[-1].integer) == IS_METHOD);
                }
#line 7502 "pkl-tab.c"
    break;

  case 213: /* declaration: defun_or_method identifier @4 '=' function_specifier  */
#line 2126 "pkl-tab.y"
                {
                  /* Complete the declaration registered above with
                     it's initial value, which is the specifier of the
                     function being defined.  */
                  PKL_AST_DECL_INITIAL ((yyvsp[-2].ast))
                    = ASTREF ((yyvsp[0].ast));
                  (yyval.ast) = (yyvsp[-2].ast);

                  /* If the reference counting of the declaration is
                     bigger than 1, this means there are recursive
                     calls in the function body.  Reset the refcount
                     to 1, since these references are weak.  */
                  if (PKL_AST_REFCOUNT ((yyvsp[-2].ast)) > 1)
                    PKL_AST_REFCOUNT ((yyvsp[-2].ast)) = 1;

                  /* Annotate the function to be a method whenever
                     appropriate.  */
                  if ((yyvsp[-4].integer) == IS_METHOD)
                    PKL_AST_FUNC_METHOD_P ((yyvsp[0].ast)) = 1;

                  pkl_parser->in_method_decl_p = 0;
                }
#line 7529 "pkl-tab.c"
    break;

  case 214: /* declaration: simple_declaration ';'  */
#line 2148 "pkl-tab.y"
                                 { (yyval.ast) = (yyvsp[-1].ast); }
#line 7535 "pkl-tab.c"
    break;

  case 215: /* defun_or_method: "keyword `fun'"  */
#line 2152 "pkl-tab.y"
                               { (yyval.integer) = IS_DEFUN; }
#line 7541 "pkl-tab.c"
    break;

  case 216: /* defun_or_method: "keyword `method'"  */
#line 2153 "pkl-tab.y"
                        { (yyval.integer) = IS_METHOD; }
#line 7547 "pkl-tab.c"
    break;

  case 218: /* defvar_list: defvar_list ',' defvar  */
#line 2159 "pkl-tab.y"
          { (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 7553 "pkl-tab.c"
    break;

  case 219: /* defvar: identifier '=' expression  */
#line 2164 "pkl-tab.y"
            {
                (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                        PKL_AST_DECL_KIND_VAR, (yyvsp[-2].ast), (yyvsp[0].ast),
                                        pkl_parser->filename);
                PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                PKL_AST_LOC ((yyval.ast)) = (yyloc);

                if (!pkl_env_register (pkl_parser->env,
                                       pkl_parser->ast,
                                       PKL_ENV_NS_MAIN,
                                       PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)),
                                       (yyval.ast)))
                  {
                    pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-2]),
                               "the variable `%s' is already defined",
                               PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)));
                    YYERROR;
                  }
          }
#line 7577 "pkl-tab.c"
    break;

  case 221: /* deftype_list: deftype_list ',' deftype  */
#line 2188 "pkl-tab.y"
          { (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 7583 "pkl-tab.c"
    break;

  case 222: /* deftype: identifier '=' type_specifier  */
#line 2193 "pkl-tab.y"
          {
            (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                    PKL_AST_DECL_KIND_TYPE, (yyvsp[-2].ast), (yyvsp[0].ast),
                                    pkl_parser->filename);
            PKL_AST_LOC ((yyval.ast)) = (yyloc);

            if (!pkl_env_register (pkl_parser->env,
                                   pkl_parser->ast,
                                   PKL_ENV_NS_MAIN,
                                   PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)),
                                   (yyval.ast)))
              {
                pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-2]),
                           "the type `%s' is already defined",
                           PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)));
                YYERROR;
              }

            (yyvsp[-2].ast) = ASTREF ((yyvsp[-2].ast)); pkl_ast_node_free ((yyvsp[-2].ast));
          }
#line 7608 "pkl-tab.c"
    break;

  case 224: /* defunit_list: defunit_list ',' defunit  */
#line 2218 "pkl-tab.y"
          { (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 7614 "pkl-tab.c"
    break;

  case 225: /* defunit: identifier '=' expression  */
#line 2223 "pkl-tab.y"
            {
              /* We need to cast the expression to uint<64> here,
                 instead of pkl-promo, because the installed
                 initializer is used as earlier as in the lexer.  Not
                 pretty.  */
              pkl_ast_node type
                = pkl_ast_make_integral_type (pkl_parser->ast,
                                              64, 0);
              pkl_ast_node cast
                = pkl_ast_make_cast (pkl_parser->ast,
                                     type, (yyvsp[0].ast));

              (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                      PKL_AST_DECL_KIND_UNIT, (yyvsp[-2].ast), cast,
                                      pkl_parser->filename);

              PKL_AST_LOC (type) = (yylsp[0]);
              PKL_AST_LOC (cast) = (yylsp[0]);
              PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
              PKL_AST_LOC ((yyval.ast)) = (yyloc);

              if (!pkl_env_register (pkl_parser->env,
                                     pkl_parser->ast,
                                     PKL_ENV_NS_UNITS,
                                     PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)),
                                     (yyval.ast)))
                {
                  pkl_error (pkl_parser->compiler, pkl_parser->ast, (yylsp[-2]),
                             "the unit `%s' is already defined",
                             PKL_AST_IDENTIFIER_POINTER ((yyvsp[-2].ast)));
                  YYERROR;
                }
            }
#line 7652 "pkl-tab.c"
    break;

  case 226: /* comp_stmt: pushlevel '{' '}'  */
#line 2263 "pkl-tab.y"
            {
              (yyval.ast) = pkl_ast_make_comp_stmt (pkl_parser->ast, NULL);
              PKL_AST_LOC ((yyval.ast)) = (yyloc);

              /* Pop the frame pushed by the `pushlevel' above.  */
              pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
            }
#line 7664 "pkl-tab.c"
    break;

  case 227: /* comp_stmt: pushlevel '{' stmt_decl_list '}'  */
#line 2271 "pkl-tab.y"
            {
              (yyval.ast) = pkl_ast_make_comp_stmt (pkl_parser->ast, (yyvsp[-1].ast));
              PKL_AST_LOC ((yyval.ast)) = (yyloc);

              /* Pop the frame pushed by the `pushlevel' above.  */
              pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
            }
#line 7676 "pkl-tab.c"
    break;

  case 229: /* stmt_decl_list: stmt_decl_list stmt  */
#line 2283 "pkl-tab.y"
                  { (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast)); }
#line 7682 "pkl-tab.c"
    break;

  case 231: /* stmt_decl_list: stmt_decl_list declaration  */
#line 2286 "pkl-tab.y"
                  { (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast)); }
#line 7688 "pkl-tab.c"
    break;

  case 232: /* ass_exp_op: "power-and-assign operator"  */
#line 2290 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_POW; }
#line 7694 "pkl-tab.c"
    break;

  case 233: /* ass_exp_op: "multiply-and-assign operator"  */
#line 2291 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_MUL; }
#line 7700 "pkl-tab.c"
    break;

  case 234: /* ass_exp_op: "divide-and-assing operator"  */
#line 2292 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_DIV; }
#line 7706 "pkl-tab.c"
    break;

  case 235: /* ass_exp_op: "modulus-and-assign operator"  */
#line 2293 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_MOD; }
#line 7712 "pkl-tab.c"
    break;

  case 236: /* ass_exp_op: "add-and-assing operator"  */
#line 2294 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_ADD; }
#line 7718 "pkl-tab.c"
    break;

  case 237: /* ass_exp_op: "subtract-and-assign operator"  */
#line 2295 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_SUB; }
#line 7724 "pkl-tab.c"
    break;

  case 238: /* ass_exp_op: "shift-left-and-assign operator"  */
#line 2296 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_SL; }
#line 7730 "pkl-tab.c"
    break;

  case 239: /* ass_exp_op: "shift-right-and-assign operator"  */
#line 2297 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_SR; }
#line 7736 "pkl-tab.c"
    break;

  case 240: /* ass_exp_op: "bit-and-and-assign operator"  */
#line 2298 "pkl-tab.y"
                { (yyval.integer) = PKL_AST_OP_BAND; }
#line 7742 "pkl-tab.c"
    break;

  case 241: /* ass_exp_op: "bit-or-and-assign operator"  */
#line 2299 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_IOR; }
#line 7748 "pkl-tab.c"
    break;

  case 242: /* ass_exp_op: "bit-xor-and-assign operator"  */
#line 2300 "pkl-tab.y"
               { (yyval.integer) = PKL_AST_OP_XOR; }
#line 7754 "pkl-tab.c"
    break;

  case 243: /* simple_stmt_list: %empty  */
#line 2304 "pkl-tab.y"
                 { (yyval.ast) = NULL; }
#line 7760 "pkl-tab.c"
    break;

  case 245: /* simple_stmt_list: simple_stmt_list ',' simple_stmt  */
#line 2307 "pkl-tab.y"
                 { (yyval.ast) = pkl_ast_chainon ((yyvsp[-2].ast), (yyvsp[0].ast)); }
#line 7766 "pkl-tab.c"
    break;

  case 246: /* simple_stmt: primary '=' expression  */
#line 2312 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_ass_stmt (pkl_parser->ast,
                                              (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7776 "pkl-tab.c"
    break;

  case 247: /* simple_stmt: primary ass_exp_op expression  */
#line 2318 "pkl-tab.y"
                {
                  pkl_ast_node exp
                    = pkl_ast_make_binary_exp (pkl_parser->ast,
                                               (yyvsp[-1].integer), (yyvsp[-2].ast), (yyvsp[0].ast));

                  (yyval.ast) = pkl_ast_make_ass_stmt (pkl_parser->ast,
                                              (yyvsp[-2].ast), exp);
                  PKL_AST_LOC (exp) = (yyloc);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7791 "pkl-tab.c"
    break;

  case 248: /* simple_stmt: bconc '=' expression  */
#line 2329 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_ass_stmt (pkl_parser->ast,
                                              (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7801 "pkl-tab.c"
    break;

  case 249: /* simple_stmt: map '=' expression  */
#line 2335 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_ass_stmt (pkl_parser->ast,
                                              (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7811 "pkl-tab.c"
    break;

  case 250: /* simple_stmt: expression  */
#line 2341 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_exp_stmt (pkl_parser->ast,
                                              (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7821 "pkl-tab.c"
    break;

  case 251: /* simple_stmt: "keyword `printf'" '(' "string" format_arg_list ')'  */
#line 2347 "pkl-tab.y"
                {
                  pkl_ast_node format =
                    pkl_ast_make_format (pkl_parser->ast, (yyvsp[-2].ast), (yyvsp[-1].ast),
                                         1 /* printf_p */);
                  (yyval.ast) = pkl_ast_make_print_stmt (pkl_parser->ast,
                                                1 /* printf_p */, format);
                  PKL_AST_LOC (format) = (yyloc);
                  PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                  if (PKL_AST_TYPE ((yyvsp[-2].ast)))
                    PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[-2].ast))) = (yylsp[-2]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7838 "pkl-tab.c"
    break;

  case 252: /* simple_stmt: "keyword `assert'" '(' expression ')'  */
#line 2360 "pkl-tab.y"
                {
                  if (((yyval.ast) = pkl_make_assertion (pkl_parser, (yyvsp[-1].ast), NULL, (yyloc)))
                      == NULL)
                    YYERROR;
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7849 "pkl-tab.c"
    break;

  case 253: /* simple_stmt: "keyword `assert'" '(' expression ',' expression ')'  */
#line 2367 "pkl-tab.y"
                {
                  if (((yyval.ast) = pkl_make_assertion (pkl_parser, (yyvsp[-3].ast), (yyvsp[-1].ast), (yyloc)))
                      == NULL)
                    YYERROR;
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7860 "pkl-tab.c"
    break;

  case 254: /* simple_stmt: funcall_stmt  */
#line 2374 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_exp_stmt (pkl_parser->ast,
                                              (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7870 "pkl-tab.c"
    break;

  case 255: /* simple_stmt: "keyword `asm'" '(' expression ')'  */
#line 2380 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_asm_stmt (pkl_parser->ast,
                                              (yyvsp[-1].ast), NULL, NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7880 "pkl-tab.c"
    break;

  case 256: /* simple_stmt: "keyword `asm'" '(' expression ':' expression_list ')'  */
#line 2386 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_asm_stmt (pkl_parser->ast,
                                              (yyvsp[-3].ast), NULL, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7890 "pkl-tab.c"
    break;

  case 257: /* simple_stmt: "keyword `asm'" '(' expression ':' expression_list ':' expression_list ')'  */
#line 2392 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_asm_stmt (pkl_parser->ast,
                                              (yyvsp[-5].ast), (yyvsp[-1].ast), (yyvsp[-3].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7900 "pkl-tab.c"
    break;

  case 259: /* stmt: ';'  */
#line 2402 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_null_stmt (pkl_parser->ast);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7909 "pkl-tab.c"
    break;

  case 260: /* stmt: simple_stmt ';'  */
#line 2407 "pkl-tab.y"
                {
                  (yyval.ast) = (yyvsp[-1].ast);
                }
#line 7917 "pkl-tab.c"
    break;

  case 261: /* stmt: "keyword `if'" '(' expression ')' stmt  */
#line 2411 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_if_stmt (pkl_parser->ast,
                                             (yyvsp[-2].ast), (yyvsp[0].ast), NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7927 "pkl-tab.c"
    break;

  case 262: /* stmt: "keyword `if'" '(' expression ')' stmt "keyword `else'" stmt  */
#line 2417 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_if_stmt (pkl_parser->ast,
                                             (yyvsp[-4].ast), (yyvsp[-2].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7937 "pkl-tab.c"
    break;

  case 263: /* stmt: "keyword `while'" '(' expression ')' stmt  */
#line 2423 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_WHILE,
                                               NULL, /* iterator */
                                               (yyvsp[-2].ast),   /* condition */
                                               NULL, /* head */
                                               NULL, /* tail */
                                               (yyvsp[0].ast));  /* body */
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7952 "pkl-tab.c"
    break;

  case 264: /* stmt: "keyword `for'" '(' pushlevel simple_declaration ';' expression_opt ';' simple_stmt_list ')' stmt  */
#line 2434 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_FOR,
                                               NULL, /* iterator */
                                               (yyvsp[-4].ast),   /* condition */
                                               (yyvsp[-6].ast),   /* head */
                                               (yyvsp[-2].ast),   /* tail */
                                               (yyvsp[0].ast)); /* body */
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 7971 "pkl-tab.c"
    break;

  case 265: /* stmt: "keyword `for'" '(' ';' expression_opt ';' simple_stmt_list ')' stmt  */
#line 2449 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_FOR,
                                               NULL, /* iterator */
                                               (yyvsp[-4].ast),   /* condition */
                                               NULL, /* head */
                                               (yyvsp[-2].ast),   /* tail */
                                               (yyvsp[0].ast));  /* body */

                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 7987 "pkl-tab.c"
    break;

  case 266: /* @5: %empty  */
#line 2461 "pkl-tab.y"
                {
                  /* Push a new lexical level and register a variable
                     with name IDENTIFIER.  Note that the variable is
                     created with a dummy INITIAL, as there is none.  */

                  pkl_ast_node dummy = pkl_ast_make_integer (pkl_parser->ast,
                                                             0);
                  PKL_AST_LOC (dummy) = (yylsp[-3]);

                  (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                               PKL_AST_DECL_KIND_VAR,
                                               (yyvsp[-3].ast),
                                               dummy,
                                               pkl_parser->filename);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);

                  if (!pkl_env_register (pkl_parser->env,
                                         pkl_parser->ast,
                                         PKL_ENV_NS_MAIN,
                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[-3].ast)),
                                         (yyval.ast)))
                    /* This should never happen.  */
                    PK_UNREACHABLE ();
                }
#line 8016 "pkl-tab.c"
    break;

  case 267: /* stmt: "keyword `for'" '(' "identifier" "keyword `in'" expression pushlevel @5 ')' stmt  */
#line 2486 "pkl-tab.y"
                {
                  pkl_ast_node iterator
                    = pkl_ast_make_loop_stmt_iterator (pkl_parser->ast,
                                                       (yyvsp[-2].ast), /* decl */
                                                       (yyvsp[-4].ast)); /* container */
                  PKL_AST_LOC (iterator) = (yyloc);

                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_FOR_IN,
                                               iterator,
                                               NULL, /* condition */
                                               NULL, /* head */
                                               NULL, /* tail */
                                               (yyvsp[0].ast));  /* body */
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Free the identifier.  */
                  (yyvsp[-6].ast) = ASTREF ((yyvsp[-6].ast)); pkl_ast_node_free ((yyvsp[-6].ast));

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 8044 "pkl-tab.c"
    break;

  case 268: /* @6: %empty  */
#line 2510 "pkl-tab.y"
                {
                  /* XXX: avoid code replication here.  */

                  /* Push a new lexical level and register a variable
                     with name IDENTIFIER.  Note that the variable is
                     created with a dummy INITIAL, as there is none.  */

                  pkl_ast_node dummy = pkl_ast_make_integer (pkl_parser->ast,
                                                             0);
                  PKL_AST_LOC (dummy) = (yylsp[-3]);

                  (yyval.ast) = pkl_ast_make_decl (pkl_parser->ast,
                                               PKL_AST_DECL_KIND_VAR,
                                               (yyvsp[-3].ast),
                                               dummy,
                                               pkl_parser->filename);
                  PKL_AST_LOC ((yyval.ast)) = (yylsp[-3]);

                  if (!pkl_env_register (pkl_parser->env,
                                         pkl_parser->ast,
                                         PKL_ENV_NS_MAIN,
                                         PKL_AST_IDENTIFIER_POINTER ((yyvsp[-3].ast)),
                                         (yyval.ast)))
                    /* This should never happen.  */
                    PK_UNREACHABLE ();
                }
#line 8075 "pkl-tab.c"
    break;

  case 269: /* stmt: "keyword `for'" '(' "identifier" "keyword `in'" expression pushlevel @6 "keyword `where'" expression ')' stmt  */
#line 2537 "pkl-tab.y"
                {
                  pkl_ast_node iterator
                    = pkl_ast_make_loop_stmt_iterator (pkl_parser->ast,
                                                       (yyvsp[-4].ast), /* decl */
                                                       (yyvsp[-6].ast)); /* container */
                  PKL_AST_LOC (iterator) = (yyloc);

                  (yyval.ast) = pkl_ast_make_loop_stmt (pkl_parser->ast,
                                               PKL_AST_LOOP_STMT_KIND_FOR_IN,
                                               iterator,
                                               (yyvsp[-2].ast), /* condition */
                                               NULL, /* head */
                                               NULL, /* tail */
                                               (yyvsp[0].ast)); /* body */
                  PKL_AST_LOC ((yyvsp[-8].ast)) = (yylsp[-8]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 8101 "pkl-tab.c"
    break;

  case 270: /* stmt: "keyword `break'" ';'  */
#line 2559 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_break_continue_stmt (pkl_parser->ast,
                                                         PKL_AST_BREAK_CONTINUE_STMT_KIND_BREAK);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8111 "pkl-tab.c"
    break;

  case 271: /* stmt: "keyword `continue'" ';'  */
#line 2565 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_break_continue_stmt (pkl_parser->ast,
                                                         PKL_AST_BREAK_CONTINUE_STMT_KIND_CONTINUE);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8121 "pkl-tab.c"
    break;

  case 272: /* stmt: "keyword `return'" ';'  */
#line 2571 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_return_stmt (pkl_parser->ast,
                                                 NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8131 "pkl-tab.c"
    break;

  case 273: /* stmt: "keyword `return'" expression ';'  */
#line 2577 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_return_stmt (pkl_parser->ast,
                                                 (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8141 "pkl-tab.c"
    break;

  case 274: /* stmt: "keyword `try'" stmt "keyword `catch'" comp_stmt  */
#line 2583 "pkl-tab.y"
                {
                  pkl_ast_node body
                    = pkl_ast_make_try_stmt_body (pkl_parser->ast, (yyvsp[-2].ast));
                  pkl_ast_node handler
                    = pkl_ast_make_try_stmt_handler (pkl_parser->ast, (yyvsp[0].ast));

                  (yyval.ast) = pkl_ast_make_try_stmt (pkl_parser->ast,
                                              PKL_AST_TRY_STMT_KIND_CATCH,
                                              body, handler, NULL, NULL);
                  PKL_AST_LOC (body) = (yylsp[-2]);
                  PKL_AST_LOC (handler) = (yylsp[0]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8159 "pkl-tab.c"
    break;

  case 275: /* stmt: "keyword `try'" stmt "keyword `catch'" "keyword `if'" expression comp_stmt  */
#line 2597 "pkl-tab.y"
                {
                  pkl_ast_node body
                    = pkl_ast_make_try_stmt_body (pkl_parser->ast, (yyvsp[-4].ast));
                  pkl_ast_node handler
                    = pkl_ast_make_try_stmt_handler (pkl_parser->ast, (yyvsp[0].ast));

                  (yyval.ast) = pkl_ast_make_try_stmt (pkl_parser->ast,
                                              PKL_AST_TRY_STMT_KIND_CATCH,
                                              body, handler, NULL, (yyvsp[-1].ast));
                  PKL_AST_LOC (body) = (yylsp[-4]);
                  PKL_AST_LOC (handler) = (yylsp[0]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8177 "pkl-tab.c"
    break;

  case 276: /* stmt: "keyword `try'" stmt "keyword `catch'" '(' pushlevel function_arg ')' comp_stmt  */
#line 2611 "pkl-tab.y"
                {
                  pkl_ast_node body
                    = pkl_ast_make_try_stmt_body (pkl_parser->ast, (yyvsp[-6].ast));
                  pkl_ast_node handler
                    = pkl_ast_make_try_stmt_handler (pkl_parser->ast, (yyvsp[0].ast));

                  (yyval.ast) = pkl_ast_make_try_stmt (pkl_parser->ast,
                                              PKL_AST_TRY_STMT_KIND_CATCH,
                                              body, handler, (yyvsp[-2].ast), NULL);
                  PKL_AST_LOC (body) = (yylsp[-6]);
                  PKL_AST_LOC (handler) = (yylsp[0]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);

                  /* Pop the frame introduced by `pushlevel'
                     above.  */
                  pkl_parser->env = pkl_env_pop_frame (pkl_parser->env);
                }
#line 8199 "pkl-tab.c"
    break;

  case 277: /* stmt: "keyword `try'" stmt "keyword `until'" expression ';'  */
#line 2629 "pkl-tab.y"
                {
                  pkl_ast_node body = pkl_ast_make_try_stmt_body (pkl_parser->ast,
                                                                  (yyvsp[-3].ast));

                  (yyval.ast) = pkl_ast_make_try_stmt (pkl_parser->ast,
                                              PKL_AST_TRY_STMT_KIND_UNTIL,
                                              body, NULL /* handler */,
                                              NULL /* arg */, (yyvsp[-1].ast));
                  PKL_AST_LOC (body) = (yylsp[-3]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8215 "pkl-tab.c"
    break;

  case 278: /* stmt: "keyword `raise'" ';'  */
#line 2641 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_raise_stmt (pkl_parser->ast,
                                                NULL);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8225 "pkl-tab.c"
    break;

  case 279: /* stmt: "keyword `raise'" expression ';'  */
#line 2647 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_raise_stmt (pkl_parser->ast,
                                                (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8235 "pkl-tab.c"
    break;

  case 280: /* stmt: "keyword `print'" expression ';'  */
#line 2653 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_print_stmt (pkl_parser->ast,
                                                0 /* printf_p */, (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8245 "pkl-tab.c"
    break;

  case 281: /* stmt: "keyword `printf'" "string" format_arg_list ';'  */
#line 2659 "pkl-tab.y"
                {
                  pkl_ast_node format =
                    pkl_ast_make_format (pkl_parser->ast, (yyvsp[-2].ast), (yyvsp[-1].ast),
                                         1 /* printf_p */);
                  (yyval.ast) = pkl_ast_make_print_stmt (pkl_parser->ast,
                                                1 /* printf_p */, format);
                  PKL_AST_LOC (format) = (yyloc);
                  PKL_AST_LOC ((yyvsp[-2].ast)) = (yylsp[-2]);
                  if (PKL_AST_TYPE ((yyvsp[-2].ast)))
                    PKL_AST_LOC (PKL_AST_TYPE ((yyvsp[-2].ast))) = (yylsp[-2]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8262 "pkl-tab.c"
    break;

  case 283: /* funcall_stmt: primary funcall_stmt_arg_list  */
#line 2676 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_make_funcall (pkl_parser->ast,
                                             (yyvsp[-1].ast), (yyvsp[0].ast));
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8272 "pkl-tab.c"
    break;

  case 285: /* funcall_stmt_arg_list: funcall_stmt_arg_list funcall_stmt_arg  */
#line 2686 "pkl-tab.y"
                {
                  (yyval.ast) = pkl_ast_chainon ((yyvsp[-1].ast), (yyvsp[0].ast));
                }
#line 8280 "pkl-tab.c"
    break;

  case 286: /* funcall_stmt_arg: ':' "identifier" expression  */
#line 2693 "pkl-tab.y"
                  {
                  (yyval.ast) = pkl_ast_make_funcall_arg (pkl_parser->ast,
                                                 (yyvsp[0].ast), (yyvsp[-1].ast));
                  PKL_AST_LOC ((yyvsp[-1].ast)) = (yylsp[-1]);
                  PKL_AST_LOC ((yyval.ast)) = (yyloc);
                }
#line 8291 "pkl-tab.c"
    break;


#line 8295 "pkl-tab.c"

        default: break;
      }
    if (yychar_backup != yychar)
      YY_LAC_DISCARD ("yychar change");
  }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == PKL_TAB_EMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      {
        yypcontext_t yyctx
          = {yyssp, yyesa, &yyes, &yyes_capacity, yytoken, &yylloc};
        if (yychar != PKL_TAB_EMPTY)
          YY_LAC_ESTABLISH;
        if (yyreport_syntax_error (&yyctx, pkl_parser) == 2)
          YYNOMEM;
      }
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= PKL_TAB_EOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == PKL_TAB_EOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, pkl_parser);
          yychar = PKL_TAB_EMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp, pkl_parser);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  /* If the stack popping above didn't lose the initial context for the
     current lookahead token, the shift below will for sure.  */
  YY_LAC_DISCARD ("error recovery");

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, pkl_parser, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != PKL_TAB_EMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, pkl_parser);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp, pkl_parser);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  if (yyes != yyesa)
    YYSTACK_FREE (yyes);

  return yyresult;
}

#line 2732 "pkl-tab.y"


/* Handle syntax errors.  */

int
yyreport_syntax_error (const yypcontext_t *ctx,
                       struct pkl_parser *pkl_parser)
{
  int res = 0;
  yysymbol_kind_t lookahead = yypcontext_token (ctx);

  /* if the unexpected token is alien, then report
     pkl_parser->alien_err_msg.  */
  if (lookahead == YYSYMBOL_ALIEN)
    {
      pkl_tab_error (yypcontext_location (ctx),
                     pkl_parser,
                     pkl_parser->alien_errmsg);
      free (pkl_parser->alien_errmsg);
      pkl_parser->alien_errmsg = NULL;
    }
  else
    {
      /* report tokens expected at this point.  */
      yysymbol_kind_t expected[YYNTOKENS];
      int nexpected = yypcontext_expected_tokens (ctx, expected, YYNTOKENS);

      if (nexpected < 0)
        /* forward errors to yyparse.  */
        res = nexpected;
      else
        {
          char *errmsg = strdup ("syntax error");

          if (!errmsg)
            return YYENOMEM;

          if (lookahead != YYSYMBOL_YYEMPTY)
            {
              char *tmp = pk_str_concat (errmsg,
                                         ": unexpected ",
                                         yysymbol_name (lookahead),
                                         NULL);
              free (errmsg);
              if (!tmp)
                return YYENOMEM;
              errmsg = tmp;
            }

          pkl_tab_error (yypcontext_location (ctx), pkl_parser, errmsg);
          free (errmsg);
        }
    }

  return res;
}
