/* Initialize "struct disassemble_info".

   Copyright (C) 2003-2025 Free Software Foundation, Inc.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street - Fifth Floor, Boston, MA
   02110-1301, USA.  */

#include "dis-asm.h"

void
init_disassemble_info (struct disassemble_info *info, void *stream,
		       fprintf_ftype fprintf_func,
		       fprintf_styled_ftype fprintf_styled_func)
{
#if 0
  memset(info, 0, sizeof (*info));

  info->flavour = bfd_target_unknown_flavour;
  info->arch = bfd_arch_unknown;
  info->endian = BFD_ENDIAN_UNKNOWN;
  info->endian_code = info->endian;
  info->octets_per_byte = 1;
  info->fprintf_func = fprintf_func;
  info->fprintf_styled_func = fprintf_styled_func;
  info->stream = stream;
  info->read_memory_func = buffer_read_memory;
  info->memory_error_func = perror_memory;
  info->print_address_func = generic_print_address;
  info->symbol_at_address_func = generic_symbol_at_address;
  info->symbol_is_valid = generic_symbol_is_valid;
  info->display_endian = BFD_ENDIAN_UNKNOWN;
  info->created_styled_output = false;
#else
  __builtin_memset(info, 0, sizeof (*info));

  info->fprintf_func = fprintf_func;
  info->fprintf_styled_func = fprintf_styled_func;
  info->stream = stream;
  info->print_address_func = 0;
#endif
}

